/*
 * Decompiled with CFR 0.152.
 */
package demo.swingset;

import demo.swingset.AquaTheme;
import demo.swingset.CharcoalTheme;
import demo.swingset.ContrastTheme;
import demo.swingset.DemoModule;
import demo.swingset.EmeraldTheme;
import demo.swingset.RubyTheme;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import swingwt.awt.BorderLayout;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.Frame;
import swingwt.awt.Graphics;
import swingwt.awt.GraphicsConfiguration;
import swingwt.awt.Insets;
import swingwt.awt.LayoutManager;
import swingwt.awt.Point;
import swingwt.awt.Rectangle;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwt.awt.event.ContainerEvent;
import swingwt.awt.event.ContainerListener;
import swingwt.awt.event.WindowAdapter;
import swingwt.awt.event.WindowEvent;
import swingwt.awt.event.WindowListener;
import swingwtx.swing.AbstractAction;
import swingwtx.swing.AbstractButton;
import swingwtx.swing.Action;
import swingwtx.swing.ButtonGroup;
import swingwtx.swing.Icon;
import swingwtx.swing.ImageIcon;
import swingwtx.swing.JButton;
import swingwtx.swing.JComponent;
import swingwtx.swing.JDialog;
import swingwtx.swing.JEditorPane;
import swingwtx.swing.JFrame;
import swingwtx.swing.JLabel;
import swingwtx.swing.JMenu;
import swingwtx.swing.JMenuBar;
import swingwtx.swing.JMenuItem;
import swingwtx.swing.JPanel;
import swingwtx.swing.JPopupMenu;
import swingwtx.swing.JRadioButtonMenuItem;
import swingwtx.swing.JScrollPane;
import swingwtx.swing.JTabbedPane;
import swingwtx.swing.JTextField;
import swingwtx.swing.JToolBar;
import swingwtx.swing.JWindow;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.UIManager;
import swingwtx.swing.border.Border;
import swingwtx.swing.border.EtchedBorder;
import swingwtx.swing.event.ChangeEvent;
import swingwtx.swing.event.ChangeListener;
import swingwtx.swing.plaf.metal.DefaultMetalTheme;
import swingwtx.swing.plaf.metal.MetalLookAndFeel;
import swingwtx.swing.plaf.metal.MetalTheme;

public class SwingSet2
extends JPanel {
    String[] demos = new String[]{"InternalFrameDemo", "ButtonDemo", "ComboBoxDemo", "FileChooserDemo", "HtmlDemo", "ListDemo", "OptionPaneDemo", "ProgressBarDemo", "ScrollPaneDemo", "SliderDemo", "SplitPaneDemo", "TabbedPaneDemo", "TableDemo", "ToolTipDemo", "TreeDemo"};
    private static final String mac = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private static final String metal = "swingwtx.swing.plaf.metal.MetalLookAndFeel";
    private static final String motif = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String windows = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String gtk = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    private static String currentLookAndFeel = "swingwtx.swing.plaf.metal.MetalLookAndFeel";
    private Vector demosVector = new Vector();
    private static final int PREFERRED_WIDTH = 720;
    private static final int PREFERRED_HEIGHT = 640;
    private Dimension HGAP = new Dimension(1, 5);
    private Dimension VGAP = new Dimension(5, 1);
    private ResourceBundle bundle = null;
    private DemoModule currentDemo = null;
    private JPanel demoPanel = null;
    private JDialog aboutBox = null;
    private JTextField statusField = null;
    private ToggleButtonToolBar toolbar = null;
    private ButtonGroup toolbarGroup = new ButtonGroup();
    private JMenuBar menuBar = null;
    private JMenu lafMenu = null;
    private JMenu themesMenu = null;
    private JMenu audioMenu = null;
    private JMenu toolTipMenu = null;
    private ButtonGroup lafMenuGroup = new ButtonGroup();
    private ButtonGroup themesMenuGroup = new ButtonGroup();
    private ButtonGroup audioMenuGroup = new ButtonGroup();
    private ButtonGroup toolTipMenuGroup = new ButtonGroup();
    private JPopupMenu popupMenu = null;
    private ButtonGroup popupMenuGroup = new ButtonGroup();
    private JFrame frame = null;
    private JWindow splashScreen = null;
    private Object applet = null;
    private boolean DEBUG = true;
    private int debugCounter = 0;
    private JTabbedPane tabbedPane = null;
    private JEditorPane demoSrcPane = null;
    private JLabel splashLabel = null;
    Container contentPane = null;
    private static int numSSs = 0;
    private static Vector swingSets = new Vector();
    DemoModule currentTabDemo = null;
    static Insets zeroInsets = new Insets(1, 1, 1, 1);
    static /* synthetic */ Class class$demo$swingset$SwingSet2;

    void loadDemos() {
        int n = 0;
        while (n < this.demos.length) {
            if (!this.isApplet() || !this.demos[n].equals("FileChooserDemo")) {
                this.loadDemo(this.demos[n]);
            }
            if (++n != 1) continue;
            try {
                this.setDemo((DemoModule)((Object)this.demosVector.get(0)));
            }
            catch (Exception exception) {}
        }
    }

    public SwingSet2(Object object) {
        this(object, null);
    }

    public SwingSet2(Object object, GraphicsConfiguration graphicsConfiguration) {
        this.applet = object;
        if (!this.isApplet()) {
            this.frame = SwingSet2.createFrame(graphicsConfiguration);
        }
        this.setLayout((LayoutManager)new BorderLayout());
        this.setSize(720, 640);
        this.createSplashScreen();
        SwingUtilities.invokeLater((Runnable)new Runnable(){

            public void run() {
                SwingSet2.this.showSplashScreen();
            }
        });
        this.initializeDemo();
        this.preloadFirstDemo();
        SwingUtilities.invokeLater((Runnable)new Runnable(){

            public void run() {
                SwingSet2.this.showSwingSet2();
                SwingSet2.this.hideSplash();
            }
        });
        if (!SwingWTUtils.isMacOSX()) {
            DemoLoadThread demoLoadThread = new DemoLoadThread(this);
            demoLoadThread.start();
        } else {
            System.out.println("Loading, please be patient...");
            this.loadDemos();
        }
    }

    public static void main(String[] stringArray) {
        if (SwingWTUtils.isMacOSX()) {
            SwingWTUtils.initialiseMacOSX((Runnable)new Runnable(){

                public void run() {
                    SwingSet2 swingSet2 = new SwingSet2(null, null);
                }
            });
        } else {
            SwingSet2 swingSet2 = new SwingSet2(null, null);
        }
    }

    public void initializeDemo() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new BorderLayout());
        this.add((Component)jPanel, "North");
        this.menuBar = this.createMenus();
        this.getFrame().setJMenuBar(this.menuBar);
        this.popupMenu = this.createPopupMenu();
        ToolBarPanel toolBarPanel = new ToolBarPanel();
        toolBarPanel.setLayout((LayoutManager)new BorderLayout());
        this.toolbar = new ToggleButtonToolBar();
        toolBarPanel.add((Component)this.toolbar, "Center");
        jPanel.add((Component)toolBarPanel, (Object)"South");
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener((ChangeListener)new TabListener());
        this.statusField = new JTextField("");
        this.statusField.setEditable(false);
        this.add((Component)this.statusField, "South");
        this.demoPanel = new JPanel();
        this.demoPanel.setLayout((LayoutManager)new BorderLayout());
        this.demoPanel.setBorder((Border)new EtchedBorder());
        this.tabbedPane.addTab("Hi There!", (Component)this.demoPanel);
        this.demoSrcPane = new JEditorPane("text/html", this.getString("SourceCode.loading"));
        this.demoSrcPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add((Component)this.demoSrcPane);
        this.tabbedPane.addTab(this.getString("TabbedPane.src_label"), null, (Component)this.demoSrcPane, this.getString("TabbedPane.src_tooltip"));
    }

    public JMenuBar createMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = jMenuBar.add(new JMenu(this.getString("FileMenu.file_label")));
        jMenu.setMnemonic(this.getMnemonic("FileMenu.file_mnemonic"));
        this.createMenuItem(jMenu, "FileMenu.about_label", "FileMenu.about_mnemonic", "FileMenu.about_accessible_description", (Action)new AboutAction(this));
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "FileMenu.open_label", "FileMenu.open_mnemonic", "FileMenu.open_accessible_description", null);
        this.createMenuItem(jMenu, "FileMenu.save_label", "FileMenu.save_mnemonic", "FileMenu.save_accessible_description", null);
        this.createMenuItem(jMenu, "FileMenu.save_as_label", "FileMenu.save_as_mnemonic", "FileMenu.save_as_accessible_description", null);
        if (!this.isApplet()) {
            jMenu.addSeparator();
            this.createMenuItem(jMenu, "FileMenu.exit_label", "FileMenu.exit_mnemonic", "FileMenu.exit_accessible_description", (Action)new ExitAction(this));
        }
        if (numSSs == 0) {
            this.lafMenu = jMenuBar.add(new JMenu(this.getString("LafMenu.laf_label")));
            this.lafMenu.setMnemonic(this.getMnemonic("LafMenu.laf_mnemonic"));
            JMenuItem jMenuItem = this.createLafMenuItem(this.lafMenu, "LafMenu.java_label", "LafMenu.java_mnemonic", "LafMenu.java_accessible_description", metal);
            jMenuItem.setSelected(true);
            this.createLafMenuItem(this.lafMenu, "LafMenu.mac_label", "LafMenu.mac_mnemonic", "LafMenu.mac_accessible_description", mac);
            this.createLafMenuItem(this.lafMenu, "LafMenu.motif_label", "LafMenu.motif_mnemonic", "LafMenu.motif_accessible_description", motif);
            this.createLafMenuItem(this.lafMenu, "LafMenu.windows_label", "LafMenu.windows_mnemonic", "LafMenu.windows_accessible_description", windows);
            this.createLafMenuItem(this.lafMenu, "LafMenu.gtk_label", "LafMenu.gtk_mnemonic", "LafMenu.gtk_accessible_description", gtk);
            this.themesMenu = jMenuBar.add(new JMenu(this.getString("ThemesMenu.themes_label")));
            this.themesMenu.setMnemonic(this.getMnemonic("ThemesMenu.themes_mnemonic"));
            this.audioMenu = this.themesMenu.add(new JMenu(this.getString("AudioMenu.audio_label")));
            this.audioMenu.setMnemonic(this.getMnemonic("AudioMenu.audio_mnemonic"));
            this.createAudioMenuItem(this.audioMenu, "AudioMenu.on_label", "AudioMenu.on_mnemonic", "AudioMenu.on_accessible_description", (Action)new OnAudioAction(this));
            jMenuItem = this.createAudioMenuItem(this.audioMenu, "AudioMenu.default_label", "AudioMenu.default_mnemonic", "AudioMenu.default_accessible_description", (Action)new DefaultAudioAction(this));
            jMenuItem.setSelected(true);
            this.createAudioMenuItem(this.audioMenu, "AudioMenu.off_label", "AudioMenu.off_mnemonic", "AudioMenu.off_accessible_description", (Action)new OffAudioAction(this));
            jMenuItem = this.createThemesMenuItem(this.themesMenu, "ThemesMenu.default_label", "ThemesMenu.default_mnemonic", "ThemesMenu.default_accessible_description", new DefaultMetalTheme());
            jMenuItem.setSelected(true);
            this.createThemesMenuItem(this.themesMenu, "ThemesMenu.aqua_label", "ThemesMenu.aqua_mnemonic", "ThemesMenu.aqua_accessible_description", new AquaTheme());
            this.createThemesMenuItem(this.themesMenu, "ThemesMenu.charcoal_label", "ThemesMenu.charcoal_mnemonic", "ThemesMenu.charcoal_accessible_description", new CharcoalTheme());
            this.createThemesMenuItem(this.themesMenu, "ThemesMenu.contrast_label", "ThemesMenu.contrast_mnemonic", "ThemesMenu.contrast_accessible_description", new ContrastTheme());
            this.createThemesMenuItem(this.themesMenu, "ThemesMenu.emerald_label", "ThemesMenu.emerald_mnemonic", "ThemesMenu.emerald_accessible_description", new EmeraldTheme());
            this.createThemesMenuItem(this.themesMenu, "ThemesMenu.ruby_label", "ThemesMenu.ruby_mnemonic", "ThemesMenu.ruby_accessible_description", new RubyTheme());
            this.toolTipMenu = jMenuBar.add(new JMenu(this.getString("ToolTipMenu.tooltip_label")));
            this.toolTipMenu.setMnemonic(this.getMnemonic("ToolTipMenu.tooltip_mnemonic"));
            jMenuItem = this.createToolTipMenuItem(this.toolTipMenu, "ToolTipMenu.on_label", "ToolTipMenu.on_mnemonic", "ToolTipMenu.on_accessible_description", (Action)new ToolTipAction(this, true));
            jMenuItem.setSelected(true);
            this.createToolTipMenuItem(this.toolTipMenu, "ToolTipMenu.off_label", "ToolTipMenu.off_mnemonic", "ToolTipMenu.off_accessible_description", (Action)new ToolTipAction(this, false));
        }
        return jMenuBar;
    }

    public JMenuItem createToolTipMenuItem(JMenu jMenu, String string, String string2, String string3, Action action) {
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)jMenu.add((JMenuItem)new JRadioButtonMenuItem(this.getString(string)));
        this.toolTipMenuGroup.add((AbstractButton)jRadioButtonMenuItem);
        jRadioButtonMenuItem.setMnemonic(this.getMnemonic(string2));
        jRadioButtonMenuItem.addActionListener((ActionListener)action);
        return jRadioButtonMenuItem;
    }

    public JMenuItem createAudioMenuItem(JMenu jMenu, String string, String string2, String string3, Action action) {
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)jMenu.add((JMenuItem)new JRadioButtonMenuItem(this.getString(string)));
        this.audioMenuGroup.add((AbstractButton)jRadioButtonMenuItem);
        jRadioButtonMenuItem.setMnemonic(this.getMnemonic(string2));
        jRadioButtonMenuItem.addActionListener((ActionListener)action);
        return jRadioButtonMenuItem;
    }

    public JMenuItem createMenuItem(JMenu jMenu, String string, String string2, String string3, Action action) {
        JMenuItem jMenuItem = jMenu.add(new JMenuItem(this.getString(string)));
        jMenuItem.setMnemonic(this.getMnemonic(string2));
        jMenuItem.addActionListener((ActionListener)action);
        if (action == null) {
            jMenuItem.setEnabled(false);
        }
        return jMenuItem;
    }

    public JMenuItem createThemesMenuItem(JMenu jMenu, String string, String string2, String string3, DefaultMetalTheme defaultMetalTheme) {
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)jMenu.add((JMenuItem)new JRadioButtonMenuItem(this.getString(string)));
        this.themesMenuGroup.add((AbstractButton)jRadioButtonMenuItem);
        jRadioButtonMenuItem.setMnemonic(this.getMnemonic(string2));
        jRadioButtonMenuItem.addActionListener((ActionListener)new ChangeThemeAction(this, defaultMetalTheme));
        return jRadioButtonMenuItem;
    }

    public JMenuItem createLafMenuItem(JMenu jMenu, String string, String string2, String string3, String string4) {
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)jMenu.add((JMenuItem)new JRadioButtonMenuItem(this.getString(string)));
        this.lafMenuGroup.add((AbstractButton)jRadioButtonMenuItem);
        jRadioButtonMenuItem.setMnemonic(this.getMnemonic(string2));
        jRadioButtonMenuItem.addActionListener((ActionListener)new ChangeLookAndFeelAction(this, string4));
        jRadioButtonMenuItem.setEnabled(this.isAvailableLookAndFeel(string4));
        return jRadioButtonMenuItem;
    }

    public JMenuItem createMultiscreenMenuItem(JMenu jMenu, int n) {
        JMenuItem jMenuItem = null;
        if (n == -1) {
            jMenuItem = jMenu.add(new JMenuItem(this.getString("MultiMenu.all_label")));
            jMenuItem.setMnemonic(this.getMnemonic("MultiMenu.all_mnemonic"));
        } else {
            jMenuItem = jMenu.add(new JMenuItem(this.getString("MultiMenu.single_label") + " " + n));
            jMenuItem.setMnemonic(48 + n);
        }
        jMenuItem.addActionListener((ActionListener)new MultiScreenAction(this, n));
        return jMenuItem;
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu("JPopupMenu demo");
        this.createPopupMenuItem(jPopupMenu, "LafMenu.java_label", "LafMenu.java_mnemonic", "LafMenu.java_accessible_description", metal);
        this.createPopupMenuItem(jPopupMenu, "LafMenu.mac_label", "LafMenu.mac_mnemonic", "LafMenu.mac_accessible_description", mac);
        this.createPopupMenuItem(jPopupMenu, "LafMenu.motif_label", "LafMenu.motif_mnemonic", "LafMenu.motif_accessible_description", motif);
        this.createPopupMenuItem(jPopupMenu, "LafMenu.windows_label", "LafMenu.windows_mnemonic", "LafMenu.windows_accessible_description", windows);
        this.createPopupMenuItem(jPopupMenu, "LafMenu.gtk_label", "LafMenu.gtk_mnemonic", "LafMenu.gtk_accessible_description", gtk);
        return jPopupMenu;
    }

    public JMenuItem createPopupMenuItem(JPopupMenu jPopupMenu, String string, String string2, String string3, String string4) {
        JMenuItem jMenuItem = jPopupMenu.add(new JMenuItem(this.getString(string)));
        this.popupMenuGroup.add((AbstractButton)jMenuItem);
        jMenuItem.setMnemonic(this.getMnemonic(string2));
        jMenuItem.addActionListener((ActionListener)new ChangeLookAndFeelAction(this, string4));
        jMenuItem.setEnabled(this.isAvailableLookAndFeel(string4));
        return jMenuItem;
    }

    public void preloadFirstDemo() {
    }

    public DemoModule addDemo(DemoModule demoModule) {
        this.demosVector.addElement(demoModule);
        SwingUtilities.invokeLater((Runnable)new SwingSetRunnable(this, (Object)demoModule){

            public void run() {
                SwitchToDemoAction switchToDemoAction = new SwitchToDemoAction(this.swingset, (DemoModule)((Object)this.obj));
                JButton jButton = this.swingset.getToolBar().addButton((Action)switchToDemoAction);
                if (jButton == null) {
                    return;
                }
                jButton.setText("");
                jButton.setToolTipText(((DemoModule)((Object)this.obj)).getToolTip());
                if (SwingSet2.this.demos[SwingSet2.this.demos.length - 1].equals(this.obj.getClass().getName())) {
                    SwingSet2.this.setStatus(SwingSet2.this.getString("Status.popupMenuAccessible"));
                }
            }
        });
        return demoModule;
    }

    public void setDemo(DemoModule demoModule) {
        this.currentDemo = demoModule;
        JPanel jPanel = demoModule.getDemoPanel();
        SwingUtilities.updateComponentTreeUI((Component)jPanel);
        this.demoPanel.removeAll();
        this.demoPanel.add((Component)jPanel, (Object)"Center");
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.setTitleAt(0, demoModule.getName());
        this.tabbedPane.setToolTipTextAt(0, demoModule.getToolTip());
    }

    public void showSwingSet2() {
        if (!this.isApplet() && this.getFrame() != null) {
            JFrame jFrame = this.getFrame();
            jFrame.setTitle(this.getString("Frame.title"));
            jFrame.getContentPane().add((Component)this, (Object)"Center");
            jFrame.setLocation(100, 100);
            jFrame.setSize(720, 640);
            jFrame.show();
            ++numSSs;
            swingSets.add(this);
        }
    }

    public void createSplashScreen() {
        this.splashLabel = new JLabel((Icon)this.createImageIcon("Splash.jpg", "Splash.accessible_description"));
        if (!this.isApplet()) {
            this.splashScreen = new JWindow((Frame)this.getFrame());
            this.splashScreen.getContentPane().add((Component)this.splashLabel);
            this.splashScreen.pack();
            Rectangle rectangle = this.getFrame().getGraphicsConfiguration().getBounds();
            this.splashScreen.setSize(550, 300);
            this.splashScreen.setLocation(rectangle.x + rectangle.width / 2 - this.splashScreen.getSize().width / 2, rectangle.y + rectangle.height / 2 - this.splashScreen.getSize().height / 2);
        }
    }

    public void showSplashScreen() {
        if (!this.isApplet()) {
            this.splashScreen.show();
        } else {
            this.add((Component)this.splashLabel, "Center");
            this.validate();
            this.repaint();
        }
    }

    public void hideSplash() {
        if (!this.isApplet()) {
            this.splashScreen.setVisible(false);
            this.splashScreen = null;
            this.splashLabel = null;
        }
    }

    void loadDemo(String string) {
        string = "demo.swingset." + string;
        this.setStatus(this.getString("Status.loading") + this.getString(string + ".name"));
        DemoModule demoModule = null;
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(class$demo$swingset$SwingSet2 == null ? (class$demo$swingset$SwingSet2 = SwingSet2.class$("demo.swingset.SwingSet2")) : class$demo$swingset$SwingSet2);
            demoModule = (DemoModule)((Object)constructor.newInstance(new Object[]{this}));
            this.addDemo(demoModule);
            this.toolbar.invalidate();
        }
        catch (Exception exception) {
            System.out.println("Error occurred loading demo: " + string);
            exception.printStackTrace();
        }
        this.setStatus("");
    }

    protected boolean isAvailableLookAndFeel(String string) {
        return false;
    }

    public boolean isApplet() {
        return this.applet != null;
    }

    public Object getApplet() {
        return this.applet;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public ToggleButtonToolBar getToolBar() {
        return this.toolbar;
    }

    public ButtonGroup getToolBarGroup() {
        return this.toolbarGroup;
    }

    public Container getContentPane() {
        if (this.contentPane == null) {
            if (this.getFrame() != null) {
                this.contentPane = this.getFrame().getContentPane();
            } else if (this.getApplet() != null) {
                this.contentPane = null;
            }
        }
        return this.contentPane;
    }

    public static JFrame createFrame(GraphicsConfiguration graphicsConfiguration) {
        JFrame jFrame = new JFrame(graphicsConfiguration);
        if (numSSs == 0) {
            jFrame.setDefaultCloseOperation(2);
        } else {
            WindowAdapter windowAdapter = new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    numSSs--;
                    swingSets.remove((Object)this);
                }
            };
            jFrame.addWindowListener((WindowListener)windowAdapter);
        }
        return jFrame;
    }

    public void setStatus(String string) {
        SwingUtilities.invokeLater((Runnable)new SwingSetRunnable(this, string){

            public void run() {
                this.swingset.statusField.setText((String)this.obj);
            }
        });
    }

    public String getString(String string) {
        if (string.startsWith("demo.swingset.")) {
            string = string.substring(14, string.length());
        }
        String string2 = null;
        try {
            string2 = this.getResourceBundle().getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("java.util.MissingResourceException: Couldn't find value for: " + string);
        }
        if (string2 == null) {
            string2 = "Could not find resource: " + string + "  ";
        }
        return string2;
    }

    public ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("resources.swingset");
        }
        return this.bundle;
    }

    public char getMnemonic(String string) {
        return this.getString(string).charAt(0);
    }

    public ImageIcon createImageIcon(String string, String string2) {
        String string3 = "/resources/images/" + string;
        return new ImageIcon(((Object)((Object)this)).getClass().getResource(string3));
    }

    public void debug(String string) {
        if (this.DEBUG) {
            System.out.println(this.debugCounter++ + ": " + string);
        }
    }

    public void setLookAndFeel(String string) {
        if (currentLookAndFeel != string) {
            currentLookAndFeel = string;
            this.themesMenu.setEnabled(string == metal);
            this.updateLookAndFeel();
        }
    }

    public void updateLookAndFeel() {
        Object object;
        try {
            UIManager.setLookAndFeel((String)currentLookAndFeel);
            Iterator iterator = swingSets.iterator();
            while (iterator.hasNext()) {
                object = (SwingSet2)((Object)iterator.next());
                SwingUtilities.updateComponentTreeUI((Component)object);
            }
            if (!this.isApplet()) {
                SwingUtilities.updateComponentTreeUI((Component)this.getFrame());
            }
        }
        catch (Exception exception) {
            System.out.println("Failed loading L&F: " + currentLookAndFeel);
            System.out.println(exception);
        }
        for (int i = 0; i < this.demosVector.size(); ++i) {
            object = (DemoModule)((Object)this.demosVector.elementAt(i));
            if (this.currentDemo == object) continue;
            SwingUtilities.invokeLater((Runnable)new SwingSetRunnable(this, object){

                public void run() {
                    SwingUtilities.updateComponentTreeUI((Component)((DemoModule)((Object)this.obj)).getDemoPanel());
                }
            });
        }
    }

    public void setSourceCode(DemoModule demoModule) {
        SwingUtilities.invokeLater((Runnable)new SwingSetRunnable(this, (Object)demoModule){

            public void run() {
                this.swingset.demoSrcPane.setText(((DemoModule)((Object)this.obj)).getSourceCode());
                SwingSet2.this.invalidate();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AboutPanel
    extends JComponent {
        ImageIcon aboutimage = null;
        SwingSet2 swingset = null;

        public AboutPanel(SwingSet2 swingSet22) {
            this.swingset = swingSet22;
            this.aboutimage = swingSet22.createImageIcon("About.jpg", "AboutBox.accessible_description");
            this.setOpaque(false);
        }

        public void paint(Graphics graphics) {
            this.aboutimage.paintIcon((Component)this, graphics, 0, 0);
            super.paint(graphics);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.aboutimage.getIconWidth(), this.aboutimage.getIconHeight());
        }
    }

    class DemoLoadThread
    extends Thread {
        SwingSet2 swingset;

        public DemoLoadThread(SwingSet2 swingSet22) {
            this.swingset = swingSet22;
        }

        public void run() {
            this.swingset.loadDemos();
        }
    }

    class MultiScreenAction
    extends AbstractAction {
        static final int ALL_SCREENS = -1;
        int screen;

        protected MultiScreenAction(SwingSet2 swingSet22, int n) {
            super("MultiScreenAction");
            this.screen = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingSet2 swingSet2 = new SwingSet2(null, null);
        }
    }

    class AboutAction
    extends AbstractAction {
        SwingSet2 swingset;

        protected AboutAction(SwingSet2 swingSet22) {
            super("AboutAction");
            this.swingset = swingSet22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JLabel jLabel = new JLabel((Icon)this.swingset.createImageIcon("About.jpg", "AboutBox.accessible_description"));
            SwingSet2.this.aboutBox = new JDialog((Frame)this.swingset.getFrame(), SwingSet2.this.getString("AboutBox.title"), false);
            SwingSet2.this.aboutBox.getContentPane().add((Component)jLabel, (Object)"Center");
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            JButton jButton = (JButton)jPanel.add((Component)new JButton(SwingSet2.this.getString("AboutBox.ok_button_text")));
            SwingSet2.this.aboutBox.add((Component)jPanel, (Object)"South");
            jButton.addActionListener((ActionListener)new OkAction(SwingSet2.this.aboutBox));
            Point point = this.swingset.getLocationOnScreen();
            SwingSet2.this.aboutBox.setLocation(point.x + 10, point.y + 10);
            SwingSet2.this.aboutBox.setSize(480, 480);
            SwingSet2.this.aboutBox.show();
        }
    }

    class ExitAction
    extends AbstractAction {
        SwingSet2 swingset;

        protected ExitAction(SwingSet2 swingSet22) {
            super("ExitAction");
            this.swingset = swingSet22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }

    class ChangeThemeAction
    extends AbstractAction {
        SwingSet2 swingset;
        DefaultMetalTheme theme;

        protected ChangeThemeAction(SwingSet2 swingSet22, DefaultMetalTheme defaultMetalTheme) {
            super("ChangeTheme");
            this.swingset = swingSet22;
            this.theme = defaultMetalTheme;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MetalLookAndFeel.setCurrentTheme((MetalTheme)this.theme);
            this.swingset.updateLookAndFeel();
        }
    }

    class ToolTipAction
    extends AbstractAction {
        SwingSet2 swingset;
        boolean status;

        protected ToolTipAction(SwingSet2 swingSet22, boolean bl) {
            super("ToolTip Control");
            this.swingset = swingSet22;
            this.status = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class OffAudioAction
    extends AbstractAction {
        SwingSet2 swingset;

        protected OffAudioAction(SwingSet2 swingSet22) {
            super("Audio Off");
            this.swingset = swingSet22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UIManager.put((Object)"AuditoryCues.playList", (Object)UIManager.get((String)"AuditoryCues.noAuditoryCues"));
            this.swingset.updateLookAndFeel();
        }
    }

    class DefaultAudioAction
    extends AbstractAction {
        SwingSet2 swingset;

        protected DefaultAudioAction(SwingSet2 swingSet22) {
            super("Audio Default");
            this.swingset = swingSet22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UIManager.put((Object)"AuditoryCues.playList", (Object)UIManager.get((String)"AuditoryCues.defaultCueList"));
            this.swingset.updateLookAndFeel();
        }
    }

    class OnAudioAction
    extends AbstractAction {
        SwingSet2 swingset;

        protected OnAudioAction(SwingSet2 swingSet22) {
            super("Audio On");
            this.swingset = swingSet22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UIManager.put((Object)"AuditoryCues.playList", (Object)UIManager.get((String)"AuditoryCues.allAuditoryCues"));
            this.swingset.updateLookAndFeel();
        }
    }

    class ActivatePopupMenuAction
    extends AbstractAction {
        SwingSet2 swingset;
        JPopupMenu popup;

        protected ActivatePopupMenuAction(SwingSet2 swingSet22, JPopupMenu jPopupMenu) {
            super("ActivatePopupMenu");
            this.swingset = swingSet22;
            this.popup = jPopupMenu;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Dimension dimension = SwingSet2.this.getSize();
            Dimension dimension2 = this.popup.getPreferredSize();
            this.popup.show((Component)this.swingset, (dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        }
    }

    class ChangeLookAndFeelAction
    extends AbstractAction {
        SwingSet2 swingset;
        String laf;

        protected ChangeLookAndFeelAction(SwingSet2 swingSet22, String string) {
            super("ChangeTheme");
            this.swingset = swingSet22;
            this.laf = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.swingset.setLookAndFeel(this.laf);
        }
    }

    class OkAction
    extends AbstractAction {
        JDialog aboutBox;

        protected OkAction(JDialog jDialog) {
            super("OkAction");
            this.aboutBox = jDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.aboutBox.setVisible(false);
        }
    }

    public class SwitchToDemoAction
    extends AbstractAction {
        SwingSet2 swingset;
        DemoModule demo;

        public SwitchToDemoAction(SwingSet2 swingSet22, DemoModule demoModule) {
            super(demoModule.getName(), demoModule.getIcon());
            this.swingset = swingSet22;
            this.demo = demoModule;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.swingset.setDemo(this.demo);
        }
    }

    class SwingSetRunnable
    implements Runnable {
        protected SwingSet2 swingset;
        protected Object obj;

        public SwingSetRunnable(SwingSet2 swingSet22, Object object) {
            this.swingset = swingSet22;
            this.obj = object;
        }

        public void run() {
        }
    }

    class ToolBarPanel
    extends JPanel
    implements ContainerListener {
        ToolBarPanel() {
        }

        public boolean contains(int n, int n2) {
            Container container = this.getParent();
            if (container != null) {
                Rectangle rectangle = container.getBounds();
                return n >= 0 && n < rectangle.width && n2 >= 0 && n2 < rectangle.height;
            }
            return super.contains(n, n2);
        }

        public void componentAdded(ContainerEvent containerEvent) {
            Container container = containerEvent.getContainer().getParent();
            if (container != null) {
                container.getParent().validate();
                container.getParent().repaint();
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Container container = containerEvent.getContainer().getParent();
            if (container != null) {
                container.getParent().validate();
                container.getParent().repaint();
            }
        }
    }

    protected class ToggleButtonToolBar
    extends JToolBar {
        public ToggleButtonToolBar() {
            this.setPreferredSize(new Dimension(700, 48));
        }

        JButton addButton(Action action) {
            JButton jButton = this.add(action);
            this.parent.invalidate();
            this.invalidate();
            this.parent.invalidate();
            return jButton;
        }
    }

    class TabListener
    implements ChangeListener {
        TabListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            boolean bl;
            boolean bl2 = bl = SwingSet2.this.tabbedPane.getSelectedIndex() == 1;
            if (SwingSet2.this.currentTabDemo != SwingSet2.this.currentDemo && SwingSet2.this.demoSrcPane != null && bl) {
                SwingSet2.this.demoSrcPane.setText(SwingSet2.this.getString("SourceCode.loading"));
                if (!SwingWTUtils.isWindows()) {
                    SwingUtilities.invokeIn((Runnable)new Runnable(this){
                        private final /* synthetic */ TabListener this$1;
                        {
                            this.this$1 = tabListener;
                        }

                        public void run() {
                            Dimension dimension = TabListener.access$300(this.this$1).getFrame().getSize();
                            ++dimension.width;
                            ++dimension.height;
                            TabListener.access$300(this.this$1).getFrame().setSize(dimension);
                        }
                    }, (int)100);
                }
                SwingSet2.this.invalidate();
                SwingSet2.this.repaint();
            }
            if (SwingSet2.this.currentTabDemo != SwingSet2.this.currentDemo && bl) {
                SwingSet2.this.currentTabDemo = SwingSet2.this.currentDemo;
                SwingSet2.this.setSourceCode(SwingSet2.this.currentDemo);
                if (!SwingWTUtils.isWindows()) {
                    SwingUtilities.invokeIn((Runnable)new Runnable(this){
                        private final /* synthetic */ TabListener this$1;
                        {
                            this.this$1 = tabListener;
                        }

                        public void run() {
                            Dimension dimension = TabListener.access$300(this.this$1).getFrame().getSize();
                            ++dimension.width;
                            ++dimension.height;
                            TabListener.access$300(this.this$1).getFrame().setSize(dimension);
                        }
                    }, (int)100);
                }
                SwingSet2.this.invalidate();
                SwingSet2.this.repaint();
            }
        }

        static /* synthetic */ SwingSet2 access$300(TabListener tabListener) {
            return tabListener.SwingSet2.this;
        }
    }
}

