/*
 * Decompiled with CFR 0.152.
 */
package demo.swingset;

import java.util.HashMap;

public class CodeViewer {
    private static HashMap reservedWords = new HashMap();
    private boolean inMultiLineComment = false;
    private String backgroundColor = "#ffffff";
    private String commentStart = "</font><font size=2 color=\"#0000aa\"><i>";
    private String commentEnd = "</font></i><font size=2 color=black>";
    private String stringStart = "</font><font size=2 color=\"#00bb00\">";
    private String stringEnd = "</font><font size=2 color=black>";
    private String reservedWordStart = "<b>";
    private String reservedWordEnd = "</b>";

    public void setCommentStart(String string) {
        this.commentStart = string;
    }

    public void setCommentEnd(String string) {
        this.commentEnd = string;
    }

    public void setStringStart(String string) {
        this.stringStart = string;
    }

    public void setStringEnd(String string) {
        this.stringEnd = string;
    }

    public void setReservedWordStart(String string) {
        this.reservedWordStart = string;
    }

    public void setReservedWordEnd(String string) {
        this.reservedWordEnd = string;
    }

    public String getCommentStart() {
        return this.commentStart;
    }

    public String getCommentEnd() {
        return this.commentEnd;
    }

    public String getStringStart() {
        return this.stringStart;
    }

    public String getStringEnd() {
        return this.stringEnd;
    }

    public String getReservedWordStart() {
        return this.reservedWordStart;
    }

    public String getReservedWordEnd() {
        return this.reservedWordEnd;
    }

    public String syntaxHighlight(String string) {
        return this.htmlFilter(string);
    }

    private String htmlFilter(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        string = this.replace(string, "&", "&#38;");
        string = this.replace(string, "\\\\", "&#92;&#92;");
        string = this.replace(string, "\\\"", "&#92;&#34");
        string = this.replace(string, "<", "&#60;");
        string = this.replace(string, ">", "&#62;");
        return this.multiLineCommentFilter(string);
    }

    private String multiLineCommentFilter(String string) {
        int n;
        if (string == null || string.equals("")) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.inMultiLineComment && (n = string.indexOf("*/")) > -1 && !this.isInsideString(string, n)) {
            this.inMultiLineComment = false;
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append("*/").append(this.commentEnd);
            if (string.length() > n + 2) {
                stringBuffer.append(this.inlineCommentFilter(string.substring(n + 2)));
            }
            return stringBuffer.toString();
        }
        if (this.inMultiLineComment) {
            return string;
        }
        n = string.indexOf("/*");
        if (n > -1 && !this.isInsideString(string, n)) {
            this.inMultiLineComment = true;
            stringBuffer.append(this.inlineCommentFilter(string.substring(0, n)));
            stringBuffer.append(this.commentStart).append("/*");
            stringBuffer.append(this.multiLineCommentFilter(string.substring(n + 2)));
            return stringBuffer.toString();
        }
        return this.inlineCommentFilter(string);
    }

    private String inlineCommentFilter(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf("//");
        if (n > -1 && !this.isInsideString(string, n)) {
            stringBuffer.append(this.stringFilter(string.substring(0, n)));
            stringBuffer.append(this.commentStart);
            stringBuffer.append(string.substring(n));
            stringBuffer.append(this.commentEnd);
        } else {
            stringBuffer.append(this.stringFilter(string));
        }
        return stringBuffer.toString();
    }

    private String stringFilter(String string) {
        int n;
        if (string == null || string.equals("")) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string.indexOf("\"") <= -1) {
            return this.keywordFilter(string);
        }
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        while ((n = string.indexOf("\"")) > -1) {
            if (n3 == -1) {
                n3 = 0;
                stringBuffer.append(this.stringFilter(string.substring(n2, n)));
                stringBuffer.append(this.stringStart).append("\"");
                string = string.substring(n + 1);
                continue;
            }
            n3 = -1;
            n4 = n;
            stringBuffer.append(string.substring(0, n4 + 1));
            stringBuffer.append(this.stringEnd);
            string = string.substring(n4 + 1);
        }
        stringBuffer.append(this.keywordFilter(string));
        return stringBuffer.toString();
    }

    private String keywordFilter(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        while (n < string.length()) {
            stringBuffer2.setLength(0);
            char c = string.charAt(n);
            n2 = n;
            while (n < string.length() && (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                stringBuffer2.append(c);
                if (++n >= string.length()) continue;
                c = string.charAt(n);
            }
            String string2 = stringBuffer2.toString();
            if (reservedWords.containsKey(string2) && !hashMap.containsKey(string2)) {
                hashMap.put(string2, string2);
                string = this.replace(string, string2, this.reservedWordStart + string2 + this.reservedWordEnd);
                n += this.reservedWordStart.length() + this.reservedWordEnd.length();
                continue;
            }
            ++n;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private String replace(String string, String string2, String string3) {
        int n = 0;
        while ((n = string.indexOf(string2, n)) >= 0) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
            n += string3.length();
        }
        return string;
    }

    private boolean isInsideString(String string, int n) {
        int n2;
        if (string.indexOf("\"") < 0) {
            return false;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        int n3 = 0;
        int n4 = 0;
        while ((n2 = string2.indexOf("\"")) > -1) {
            ++n3;
            string2 = string2.substring(n2 + 1);
        }
        while ((n2 = string3.indexOf("\"")) > -1) {
            ++n4;
            string3 = string3.substring(n2 + 1);
        }
        return n4 % 2 != 0 && n3 % 2 != 0;
    }

    private static void loadHash() {
        reservedWords.put("abstract", "abstract");
        reservedWords.put("do", "do");
        reservedWords.put("inner", "inner");
        reservedWords.put("public", "public");
        reservedWords.put("var", "var");
        reservedWords.put("boolean", "boolean");
        reservedWords.put("continue", "continue");
        reservedWords.put("int", "int");
        reservedWords.put("return", "return");
        reservedWords.put("void", "void");
        reservedWords.put("break", "break");
        reservedWords.put("else", "else");
        reservedWords.put("interface", "interface");
        reservedWords.put("short", "short");
        reservedWords.put("volatile", "volatile");
        reservedWords.put("byvalue", "byvalue");
        reservedWords.put("extends", "extends");
        reservedWords.put("long", "long");
        reservedWords.put("static", "static");
        reservedWords.put("while", "while");
        reservedWords.put("case", "case");
        reservedWords.put("final", "final");
        reservedWords.put("naive", "naive");
        reservedWords.put("super", "super");
        reservedWords.put("transient", "transient");
        reservedWords.put("cast", "cast");
        reservedWords.put("float", "float");
        reservedWords.put("new", "new");
        reservedWords.put("rest", "rest");
        reservedWords.put("catch", "catch");
        reservedWords.put("for", "for");
        reservedWords.put("null", "null");
        reservedWords.put("synchronized", "synchronized");
        reservedWords.put("char", "char");
        reservedWords.put("finally", "finally");
        reservedWords.put("operator", "operator");
        reservedWords.put("this", "this");
        reservedWords.put("class", "class");
        reservedWords.put("generic", "generic");
        reservedWords.put("outer", "outer");
        reservedWords.put("switch", "switch");
        reservedWords.put("const", "const");
        reservedWords.put("goto", "goto");
        reservedWords.put("package", "package");
        reservedWords.put("throw", "throw");
        reservedWords.put("double", "double");
        reservedWords.put("if", "if");
        reservedWords.put("private", "private");
        reservedWords.put("true", "true");
        reservedWords.put("default", "default");
        reservedWords.put("import", "import");
        reservedWords.put("protected", "protected");
        reservedWords.put("try", "try");
    }

    static {
        CodeViewer.loadHash();
    }
}

