/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.framework.BundlePermissionCollection;

public final class BundlePermission
extends BasicPermission {
    public static final String PROVIDE_BUNDLE = "provideBundle";
    public static final String REQUIRE_BUNDLE = "requireBundle";
    public static final String FRAGMENT_HOST = "fragmentHost";
    public static final String FRAGMENT_BUNDLE = "fragmentBundle";
    private static final int ACTION_PROVIDE = 1;
    private static final int ACTION_REQUIRE = 2;
    private static final int ACTION_HOST = 4;
    private static final int ACTION_FRAGMENT = 8;
    private static final int ACTION_ALL = 15;
    private static final int ACTION_NONE = 0;
    private static final int ACTION_ERROR = Integer.MIN_VALUE;
    private transient int action_mask = 0;
    private String actions = null;

    public BundlePermission(String symbolicName, String actions) {
        this(symbolicName, BundlePermission.getMask(actions));
    }

    BundlePermission(String uniqueId, int mask) {
        super(uniqueId);
        this.init(mask);
    }

    private void init(int mask) {
        if (mask == 0 || (mask & 0xF) != mask) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = mask;
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String actions) {
        seencomma = false;
        mask = 0;
        if (actions == null) {
            return mask;
        }
        a = actions.toCharArray();
        i = a.length - 1;
        if (i >= 0) ** GOTO lbl41
        return mask;
        {
            --i;
            do {
                if (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) continue block4;
                if (!(i < 12 || a[i - 12] != 'p' && a[i - 12] != 'P' || a[i - 11] != 'r' && a[i - 11] != 'R' || a[i - 10] != 'o' && a[i - 10] != 'O' || a[i - 9] != 'v' && a[i - 9] != 'V' || a[i - 8] != 'i' && a[i - 8] != 'I' || a[i - 7] != 'd' && a[i - 7] != 'D' || a[i - 6] != 'e' && a[i - 6] != 'E' || a[i - 5] != 'b' && a[i - 5] != 'B' || a[i - 4] != 'u' && a[i - 4] != 'U' || a[i - 3] != 'n' && a[i - 3] != 'N' || a[i - 2] != 'd' && a[i - 2] != 'D' || a[i - 1] != 'l' && a[i - 1] != 'L' || a[i] != 'e' && a[i] != 'E')) {
                    matchlen = 13;
                    mask |= 3;
                } else if (!(i < 12 || a[i - 12] != 'r' && a[i - 12] != 'R' || a[i - 11] != 'e' && a[i - 11] != 'E' || a[i - 10] != 'q' && a[i - 10] != 'Q' || a[i - 9] != 'u' && a[i - 9] != 'U' || a[i - 8] != 'i' && a[i - 8] != 'I' || a[i - 7] != 'r' && a[i - 7] != 'R' || a[i - 6] != 'e' && a[i - 6] != 'E' || a[i - 5] != 'b' && a[i - 5] != 'B' || a[i - 4] != 'u' && a[i - 4] != 'U' || a[i - 3] != 'n' && a[i - 3] != 'N' || a[i - 2] != 'd' && a[i - 2] != 'D' || a[i - 1] != 'l' && a[i - 1] != 'L' || a[i] != 'e' && a[i] != 'E')) {
                    matchlen = 13;
                    mask |= 2;
                } else if (!(i < 11 || a[i - 11] != 'f' && a[i - 11] != 'F' || a[i - 10] != 'r' && a[i - 10] != 'R' || a[i - 9] != 'a' && a[i - 9] != 'A' || a[i - 8] != 'g' && a[i - 8] != 'G' || a[i - 7] != 'm' && a[i - 7] != 'M' || a[i - 6] != 'e' && a[i - 6] != 'E' || a[i - 5] != 'n' && a[i - 3] != 'N' || a[i - 4] != 't' && a[i - 4] != 'T' || a[i - 3] != 'h' && a[i - 3] != 'H' || a[i - 2] != 'o' && a[i - 2] != 'O' || a[i - 1] != 's' && a[i - 1] != 'S' || a[i] != 't' && a[i] != 'T')) {
                    matchlen = 12;
                    mask |= 4;
                } else if (!(i < 13 || a[i - 13] != 'f' && a[i - 13] != 'F' || a[i - 12] != 'r' && a[i - 12] != 'R' || a[i - 11] != 'a' && a[i - 11] != 'A' || a[i - 10] != 'g' && a[i - 10] != 'G' || a[i - 9] != 'm' && a[i - 9] != 'M' || a[i - 8] != 'e' && a[i - 8] != 'E' || a[i - 7] != 'n' && a[i - 7] != 'N' || a[i - 6] != 't' && a[i - 6] != 'T' || a[i - 5] != 'b' && a[i - 5] != 'B' || a[i - 4] != 'u' && a[i - 4] != 'U' || a[i - 3] != 'n' && a[i - 3] != 'N' || a[i - 2] != 'd' && a[i - 2] != 'D' || a[i - 1] != 'l' && a[i - 1] != 'L' || a[i] != 'e' && a[i] != 'E')) {
                    matchlen = 14;
                    mask |= 8;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + actions);
                }
                seencomma = false;
                while (i >= matchlen && !seencomma) {
                    switch (a[i - matchlen]) {
                        case ',': {
                            seencomma = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + actions);
                        }
                    }
                    --i;
                }
                i -= matchlen;
lbl41:
                // 2 sources

            } while (i != -1);
        }
        if (seencomma) {
            throw new IllegalArgumentException("invalid permission: " + actions);
        }
        return mask;
    }

    public boolean implies(Permission p) {
        if (p instanceof BundlePermission) {
            BundlePermission target = (BundlePermission)p;
            return (this.action_mask & target.action_mask) == target.action_mask && super.implies(p);
        }
        return false;
    }

    public String getActions() {
        if (this.actions == null) {
            StringBuffer sb = new StringBuffer();
            boolean comma = false;
            if ((this.action_mask & 1) == 1) {
                sb.append(PROVIDE_BUNDLE);
                comma = true;
            }
            if ((this.action_mask & 2) == 2) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(REQUIRE_BUNDLE);
                comma = true;
            }
            if ((this.action_mask & 4) == 4) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(FRAGMENT_HOST);
            }
            if ((this.action_mask & 4) == 8) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(FRAGMENT_BUNDLE);
            }
            this.actions = sb.toString();
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new BundlePermissionCollection();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BundlePermission)) {
            return false;
        }
        BundlePermission p = (BundlePermission)obj;
        return this.action_mask == p.action_mask && this.getName().equals(p.getName());
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getActions().hashCode();
    }

    int getMask() {
        return this.action_mask;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        s.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(BundlePermission.getMask(this.actions));
    }
}

