/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.runtime.AuthorizationDatabase;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.PlatformMetaAreaLock;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;

public class DataArea {
    static final String F_DESCRIPTION = ".platform";
    static final String F_META_AREA = ".metadata";
    static final String F_PLUGIN_PATH = ".plugin-path";
    static final String F_PLUGIN_DATA = ".plugins";
    static final String F_LOG = ".log";
    static final String F_BACKUP = ".bak";
    static final String F_KEYRING = ".keyring";
    static final String F_LOCK_FILE = ".lock";
    static final String F_VERSION = "version.ini";
    static final String PREFERENCES_FILE_NAME = "pref_store.ini";
    private IPath location;
    private PlatformMetaAreaLock metaAreaLock = null;
    private AuthorizationDatabase keyring = null;
    private long keyringTimeStamp;
    private String keyringFile = null;
    private String password = "";
    private boolean initialized = false;

    protected void assertLocationInitialized() throws IllegalStateException {
        if (this.location != null && this.initialized) {
            return;
        }
        Location service = InternalPlatform.getDefault().getInstanceLocation();
        if (service == null) {
            throw new IllegalStateException(Policy.bind("meta.noDataModeSpecified"));
        }
        try {
            URL url = service.getURL();
            if (url == null) {
                throw new IllegalStateException(Policy.bind("meta.instanceDataUnspecified"));
            }
            this.location = new Path(url.getFile());
            this.initializeLocation();
        }
        catch (CoreException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public IPath getBackupFilePathFor(IPath file) throws IllegalStateException {
        this.assertLocationInitialized();
        return file.removeLastSegments(1).append(String.valueOf(file.lastSegment()) + F_BACKUP);
    }

    public IPath getMetadataLocation() throws IllegalStateException {
        this.assertLocationInitialized();
        return this.location.append(F_META_AREA);
    }

    public IPath getInstanceDataLocation() throws IllegalStateException {
        this.assertLocationInitialized();
        return this.location;
    }

    public IPath getLogLocation() throws IllegalStateException {
        return new Path(InternalPlatform.getDefault().getFrameworkLog().getFile().getAbsolutePath());
    }

    public IPath getStateLocation(Bundle bundle) throws IllegalStateException {
        this.assertLocationInitialized();
        return this.getStateLocation(bundle.getSymbolicName());
    }

    public IPath getStateLocation(String bundleName) throws IllegalStateException {
        this.assertLocationInitialized();
        return this.getMetadataLocation().append(F_PLUGIN_DATA).append(bundleName);
    }

    public IPath getPreferenceLocation(Bundle bundle, boolean create) throws IllegalStateException {
        this.assertLocationInitialized();
        return this.getPreferenceLocation(bundle.getSymbolicName(), create);
    }

    public IPath getPreferenceLocation(String bundleName, boolean create) throws IllegalStateException {
        IPath result = this.getStateLocation(bundleName);
        if (create) {
            result.toFile().mkdirs();
        }
        return result.append(PREFERENCES_FILE_NAME);
    }

    public IPath getVersionPath() throws IllegalStateException {
        this.assertLocationInitialized();
        return this.getMetadataLocation().append(F_VERSION);
    }

    private void initializeLocation() throws CoreException {
        if (this.location.toFile().exists() && !this.location.toFile().isDirectory()) {
            String message = Policy.bind("meta.notDir", this.location.toString());
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, message, null));
        }
        if (this.location.getDevice() == null) {
            this.location = new Path(this.location.toFile().getAbsolutePath());
        }
        this.createLocation();
        this.initialized = true;
    }

    private void createLocation() throws CoreException {
        File file = this.location.append(F_META_AREA).toFile();
        try {
            file.mkdirs();
        }
        catch (Exception e) {
            String message = Policy.bind("meta.couldNotCreate", file.getAbsolutePath());
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, message, e));
        }
        if (!file.canWrite()) {
            String message = Policy.bind("meta.readonly", file.getAbsolutePath());
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, message, null));
        }
        IPath path = this.location.append(F_META_AREA).append(F_LOG);
        try {
            InternalPlatform.getDefault().getFrameworkLog().setFile(path.toFile(), true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void createLockFile() throws CoreException, IllegalStateException {
        if (System.getProperty("eclipse.ui.testing") != null) {
            return;
        }
        this.assertLocationInitialized();
        if (System.getProperty("org.eclipse.core.runtime.ignoreLockFile") != null) {
            return;
        }
        String lockLocation = this.getMetadataLocation().append(F_LOCK_FILE).toOSString();
        this.metaAreaLock = new PlatformMetaAreaLock(new File(lockLocation));
        try {
            if (!this.metaAreaLock.acquire()) {
                String message = Policy.bind("meta.inUse", lockLocation);
                throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, message, null));
            }
        }
        catch (IOException e) {
            String message = Policy.bind("meta.failCreateLock", lockLocation);
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, message, e));
        }
    }

    public synchronized void clearLockFile() throws IllegalStateException {
        if (System.getProperty("eclipse.ui.testing") != null) {
            return;
        }
        this.assertLocationInitialized();
        if (this.metaAreaLock != null) {
            this.metaAreaLock.release();
        }
    }

    public void addAuthorizationInfo(URL serverUrl, String realm, String authScheme, Map info) throws CoreException {
        this.loadKeyring();
        this.keyring.addAuthorizationInfo(serverUrl, realm, authScheme, new HashMap(info));
        this.keyring.save();
    }

    public void addProtectionSpace(URL resourceUrl, String realm) throws CoreException {
        this.loadKeyring();
        this.keyring.addProtectionSpace(resourceUrl, realm);
        this.keyring.save();
    }

    public void flushAuthorizationInfo(URL serverUrl, String realm, String authScheme) throws CoreException {
        this.loadKeyring();
        this.keyring.flushAuthorizationInfo(serverUrl, realm, authScheme);
        this.keyring.save();
    }

    public Map getAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        this.loadKeyring();
        Map info = this.keyring.getAuthorizationInfo(serverUrl, realm, authScheme);
        return info == null ? null : new HashMap(info);
    }

    public String getProtectionSpace(URL resourceUrl) {
        this.loadKeyring();
        return this.keyring.getProtectionSpace(resourceUrl);
    }

    private void loadKeyring() {
        if (this.keyring != null && new File(this.keyringFile).lastModified() == this.keyringTimeStamp) {
            return;
        }
        if (this.keyringFile == null) {
            File file = new File(InternalPlatform.getDefault().getConfigurationLocation().getURL().getPath());
            file = new File(file, F_KEYRING);
            this.keyringFile = file.getAbsolutePath();
        }
        try {
            this.keyring = new AuthorizationDatabase(this.keyringFile, this.password);
        }
        catch (CoreException e) {
            InternalPlatform.getDefault().log(e.getStatus());
        }
        if (this.keyring == null) {
            new File(this.keyringFile).delete();
            try {
                this.keyring = new AuthorizationDatabase(this.keyringFile, this.password);
            }
            catch (CoreException coreException) {}
        }
        this.keyringTimeStamp = new File(this.keyringFile).lastModified();
    }

    public void setKeyringFile(String keyringFile) {
        if (this.keyringFile != null) {
            throw new IllegalStateException(Policy.bind("meta.keyringFileAlreadySpecified", this.keyringFile));
        }
        this.keyringFile = keyringFile;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

