#ifndef _SubtitleSystem_h
#define _SubtitleSystem_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <glibmm.h>
#include <list>
#include "Document.h"
#include "SubtitleFormat.h"


class SubtitleSystem
{
public:
	static SubtitleSystem& getInstance();

	/*
	 *	retourne la list des formats supporter
	 */
	std::list<Glib::ustring> get_formats();


	/*
	 *	determine quel est le format du sous-titre
	 */
	Glib::ustring find_subtitle_format(const Glib::ustring &filename);

	/*
	 *	retourne l'extension utiliser par le format
	 *	ex: "ass", "ssa", "srt", ...
	 */
	Glib::ustring get_extension(const Glib::ustring &format);

	/*
	 *	crée la class du format
	 */
	SubtitleFormat* create_subtitle_format(const Glib::ustring &name, Document *doc);
protected:
	/*
	 *	cherche le format de la line str
	 */
	Glib::ustring	find_format(const char *str);
};

#endif//_SubtitleSystem_h
