# Test Config.py

import unittest
import os
import sys

try:
    import pmock
except ImportError:
    sys.exit("You need python-mock (pmock, 0.3) to run this test. http://pmock.sf.net")

sys.path.insert(0, '../src/lib')
import Config

class ConfigTestCase(unittest.TestCase):
    def testPollFrequency(self):
        mock = pmock.Mock()
        poll_frequency = 18000
        mock.expects(pmock.once()).save_option(pmock.eq("/general/poll_frequency"),pmock.eq(poll_frequency))
        config = Config.Config(mock)
        config.set_poll_frequency(poll_frequency)
        mock.verify()
        self.assertEqual(poll_frequency, config.get_poll_frequency())

    def testLastPoll(self):
        mock = pmock.Mock()
        last_poll = 24600
        mock.expects(pmock.once()).save_option(pmock.eq("/general/last_poll"),pmock.eq(last_poll))
        config = Config.Config(mock)
        config.set_last_poll(last_poll)
        mock.verify()
        self.assertEqual(last_poll, config.get_last_poll())

    def testItemsStored(self):
        mock = pmock.Mock()
        stored = 150
        mock.expects(pmock.once()).save_option(pmock.eq("/general/number_of_items_stored"),pmock.eq(stored))
        config = Config.Config(mock)
        config.set_number_of_items_stored(stored)
        mock.verify()
        self.assertEqual(stored, config.get_number_of_items_stored())

    def testItemOrder(self):
        mock = pmock.Mock()
        order = True
        mock.expects(pmock.once()).save_option(pmock.eq("/general/item_order_newest"),pmock.eq(order))
        config = Config.Config(mock)
        config.set_item_order(order)
        mock.verify()
        self.assertEqual(order, config.get_item_order())

    def testOffline(self):
        mock = pmock.Mock()
        offline = False
        mock.expects(pmock.once()).save_option(pmock.eq("/general/offline"),pmock.eq(offline))
        config = Config.Config(mock)
        config.set_offline(offline)
        mock.verify()
        self.assertEqual(offline, config.get_offline())

    # feel free to add more tests here ...

def suite():
    suite = unittest.makeSuite(ConfigTestCase, 'test')
    return suite

if __name__ == '__main__':
    unittest.main()
