/* @(#)chdir.c	1.1 03/08/12 Copyright 1997-2003 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)chdir.c	1.1 03/08/12 Copyright 1997-2003 J. Schilling";
#endif
/*
 *	Copyright (c) 1997-2003 J. Schilling
 */
/*
 * Copyright Jrg Schilling. All rights reserved.
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only.
 * See the file CDDL.Schily.txt in this distribution or
 * http://opensource.org/licenses/cddl1.php for details.
 */

#include <mconfig.h>
#include <stdio.h>
#include <stdxlib.h>
#include <unixstd.h>
#include <strdefs.h>
#include <standard.h>
#include <schily.h>
#include "star.h"
#include "starsubs.h"

#include <dirdefs.h>
#include <maxpath.h>
#include <getcwd.h>

EXPORT	char	*dogetwdir	__PR((void));
EXPORT	BOOL	dochdir		__PR((const char *dir, BOOL doexit));

extern	BOOL	debug;		/* -debug has been specified	*/

EXPORT char *
dogetwdir()
{
	char	dir[PATH_MAX+1];
	char	*ndir;

/* XXX MAXPATHNAME vs. PATH_MAX ??? */

	if (getcwd(dir, PATH_MAX) == NULL)
		comerr("Cannot get working directory\n");
	ndir = __malloc(strlen(dir)+1, "working dir");
	strcpy(ndir, dir);
	return (ndir);
}

EXPORT BOOL
dochdir(dir, doexit)
	const char	*dir;
	BOOL		doexit;
{
	if (debug) /* temporary */
		error("dochdir(%s) = ", dir);

	if (chdir(dir) < 0) {
		int	ex = geterrno();

		if (debug) /* temporary */
			error("%d\n", ex);

		errmsg("Cannot change directory to '%s'.\n", dir);
		if (doexit)
			exit(ex);
		return (FALSE);
	}
	if (debug) /* temporary */
		error("%d\n", 0);

	return (TRUE);
}
