-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
procedure WriteDeclaration
  (Discriminant : in DeclarationDiscriminant;
   Item         : in Symbol;
   Scope        : in Scopes;
   Declaration  : in Location) is

   --------------------------------------------------------------------------------

   procedure WriteRenamingDeclaration (Subprogram  : in Symbol;
                                       Scope       : in Scopes;
                                       Declaration : in Location)
   --# global in     Dict;
   --#        in     LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Declaration,
   --#                                Dict,
   --#                                LexTokenManager.State,
   --#                                Scope,
   --#                                Subprogram;
   is
   begin
      if IsSubprogram (Subprogram) then
         WriteString (Dict.TemporaryFile, "subprogram ");
         WriteName (Dict.TemporaryFile, Subprogram);
         WriteString (Dict.TemporaryFile, " is renamed in ");
         WriteScope (Dict.TemporaryFile, Scope);
         WriteString (Dict.TemporaryFile, " at ");
         WriteLocation (Dict.TemporaryFile, Declaration);
         WriteLine (Dict.TemporaryFile, " ;");
      end if;
   end WriteRenamingDeclaration;

   --------------------------------------------------------------------------------

   procedure WriteOtherDeclaration (Discriminant : in DeclarationDiscriminant;
                                    Item         : in Symbol;
                                    Declaration  : in Location)
   --# global in     Dict;
   --#        in     LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Declaration,
   --#                                Dict,
   --#                                Discriminant,
   --#                                Item,
   --#                                LexTokenManager.State;
   is

      --------------------------------------------------------------------------------

      procedure WriteDiscriminant (File         : in SPARK_IO.File_Type;
                                   Discriminant : in DeclarationDiscriminant)
      --# global in out SPARK_IO.File_Sys;
      --# derives SPARK_IO.File_Sys from *,
      --#                                Discriminant,
      --#                                File;
      is
      begin
         case Discriminant is
            when ConstantDeclaration =>
               WriteString (File, "constant declaration");
            when DeferredConstantDeclaration =>
               WriteString (File, "deferred constant declaration");
            when VariableDeclaration =>
               WriteString (File, "variable declaration");
            when TypeDeclaration =>
               WriteString (File, "type declaration");
            when SubtypeDeclaration =>
               WriteString (File, "subtype declaration");
            when TypeAnnouncement =>
               WriteString (File, "type announcement");
            when PrivateTypeDeclaration =>
               WriteString (File, "private type declaration");
            when PackageSpecification =>
               WriteString (File, "package specification");
            when SubprogramSpecification =>
               WriteString (File, "subprogram specification");
            when RenamingDeclaration =>
               null;
         end case;
      end WriteDiscriminant;

      --------------------------------------------------------------------------------

   begin
      WriteDiscriminant (Dict.TemporaryFile, Discriminant);
      WriteString (Dict.TemporaryFile, " of ");
      WriteName (Dict.TemporaryFile, Item);
      WriteString (Dict.TemporaryFile, " is at ");
      WriteLocation (Dict.TemporaryFile, Declaration);
      WriteLine (Dict.TemporaryFile, " ;");
   end WriteOtherDeclaration;

   --------------------------------------------------------------------------------

begin
   if SPARK_IO.Is_Open (Dict.TemporaryFile) then
      if Discriminant = RenamingDeclaration then
         WriteRenamingDeclaration (Item, Scope, Declaration);
      else
         WriteOtherDeclaration (Discriminant, Item, Declaration);
      end if;
   end if;
end WriteDeclaration;
