# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001, 2002, 2003  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os.path
import src.configureoutput
import cfg

def copy_rc_file():
    """
    Solfege 2.0 is the first release with unversioned rc file.
    """
    rcfilename = os.path.expanduser("~/.solfegerc")
    if os.path.isfile(rcfilename):
        return
    if src.configureoutput.WITH_GNOME:
        rc12 = os.path.expanduser("~/.gnome/solfege1.2")
    else:
        rc12 = os.path.expanduser("~/.solfegerc1.2")
    rc13 = os.path.expanduser("~/.solfegerc1.3")
    rc14 = os.path.expanduser("~/.solfegerc1.4")
    rc15 = os.path.expanduser("~/.solfegerc1.5")
    rc19 = os.path.expanduser("~/.solfegerc1.9")

    old_rc_filename = None
    if not os.path.isfile(rcfilename):
        for fn in (rc19, rc15, rc14, rc13, rc12):
            if os.path.isfile(fn):
                old_rc_filename = fn
                break
        if old_rc_filename:
            d = {}
            cfg.parse_file_into_dict(d, old_rc_filename)
            data = {}
            for k in ['user', 'sound', 'lessoncollections', 'config', 'gui', 'app']:
                data[k] = d[k]
            try:
                del data['gui']['button_height']
            except:
                pass
            cfg.dump(data, rcfilename)

