/*
 * snackDecls.h --
 *
 *	Declarations of functions in the platform independent public Snack API.
 *
 * Copyright (c) 1998-1999 by Scriptics Corporation.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#ifndef _SNACKDECLS
#define _SNACKDECLS

/*
 * WARNING: This file is automatically generated by the tools/genStubs.tcl
 * script.  Any modifications to the function declarations below should be made
 * in the generic/snack.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported function declarations:
 */

/* Slot 0 is reserved */
/* Slot 1 is reserved */
/* 2 */
EXTERN int		Snack_AddSubCmd _ANSI_ARGS_((int snackCmd, 
				char * cmdName, Snack_CmdProc * cmdProc, 
				Snack_DelCmdProc * delCmdProc));
/* 3 */
EXTERN int		Snack_AddFileFormat _ANSI_ARGS_((char * formatName, 
				guessFileTypeProc * guessProc, 
				getHeaderProc * GetHeaderProc, 
				extensionFileTypeProc * extProc, 
				putHeaderProc * PutHeaderProc, 
				openProc * OpenProc, closeProc * CloseProc, 
				readSamplesProc * ReadSamplesProc, 
				writeSamplesProc * WriteSamplesProc, 
				seekProc * SeekProc));
/* 4 */
EXTERN int		Snack_AddCallback _ANSI_ARGS_((Sound * s, 
				updateProc * proc, ClientData cd));
/* 5 */
EXTERN void		Snack_RemoveCallback _ANSI_ARGS_((Sound * s, int id));
/* 6 */
EXTERN void		Snack_ExecCallbacks _ANSI_ARGS_((Sound * s, int flag));
/* 7 */
EXTERN void		Snack_UpdateExtremes _ANSI_ARGS_((Sound * s, 
				int start, int end, int flag));
/* 8 */
EXTERN Sound *		Snack_GetSound _ANSI_ARGS_((Tcl_Interp * interp, 
				char * name));
/* 9 */
EXTERN Sound *		Snack_NewSound _ANSI_ARGS_((int frequency, 
				int format, int nchannels));
/* 10 */
EXTERN int		Snack_ResizeSoundStorage _ANSI_ARGS_((Sound * s, 
				int len));
/* 11 */
EXTERN void		Snack_DeleteSound _ANSI_ARGS_((Sound * s));
/* 12 */
EXTERN void		Snack_PutSoundData _ANSI_ARGS_((Sound * s, int pos, 
				void * buf, int nBytes));
/* 13 */
EXTERN void		Snack_GetSoundData _ANSI_ARGS_((Sound * s, int pos, 
				void * buf, int nBytes));
/* 14 */
EXTERN unsigned char	Snack_Lin2Alaw _ANSI_ARGS_((short pcm_val));
/* 15 */
EXTERN unsigned char	Snack_Lin2Mulaw _ANSI_ARGS_((short pcm_val));
/* 16 */
EXTERN short		Snack_Alaw2Lin _ANSI_ARGS_((unsigned char a_val));
/* 17 */
EXTERN short		Snack_Mulaw2Lin _ANSI_ARGS_((unsigned char u_val));
/* 18 */
EXTERN short		Snack_SwapShort _ANSI_ARGS_((short s));
/* 19 */
EXTERN int		SnackSeekFile _ANSI_ARGS_((seekProc * SeekProc, 
				Sound * s, Tcl_Interp * interp, 
				Tcl_Channel ch, int pos));
/* 20 */
EXTERN int		SnackOpenFile _ANSI_ARGS_((openProc * OpenProc, 
				Sound * s, Tcl_Interp * interp, 
				Tcl_Channel * ch, char * mode));
/* 21 */
EXTERN int		SnackCloseFile _ANSI_ARGS_((closeProc * CloseProc, 
				Sound * s, Tcl_Interp * interp, 
				Tcl_Channel * ch));
/* 22 */
EXTERN void		Snack_WriteLog _ANSI_ARGS_((char * s));
/* 23 */
EXTERN void		Snack_WriteLogInt _ANSI_ARGS_((char * s, int n));
/* 24 */
EXTERN SnackFileFormat * Snack_GetFileFormats _ANSI_ARGS_((void));
/* 25 */
EXTERN void		Snack_InitWindow _ANSI_ARGS_((float * hamwin, 
				int winlen, int fftlen, int type));
/* 26 */
EXTERN int		Snack_InitFFT _ANSI_ARGS_((int n));
/* 27 */
EXTERN int		Snack_DBPowerSpectrum _ANSI_ARGS_((float * x));
/* 28 */
EXTERN void		Snack_StopSound _ANSI_ARGS_((Sound * s, 
				Tcl_Interp * interp));
/* 29 */
EXTERN int		Snack_ProgressCallback _ANSI_ARGS_((Tcl_Obj * cmd, 
				Tcl_Interp * interp, char * type, 
				double fraction));
/* 30 */
EXTERN void		Snack_CreateFileFormat _ANSI_ARGS_((
				Snack_FileFormat * typePtr));
/* 31 */
EXTERN long		Snack_SwapLong _ANSI_ARGS_((long s));
/* 32 */
EXTERN int		Snack_PlatformIsLittleEndian _ANSI_ARGS_((void));
/* 33 */
EXTERN void		Snack_CreateFilterType _ANSI_ARGS_((
				Snack_FilterType * typePtr));

typedef struct SnackStubs {
    int magic;
    struct SnackStubHooks *hooks;

    void *reserved0;
    void *reserved1;
    int (*snack_AddSubCmd) _ANSI_ARGS_((int snackCmd, char * cmdName, Snack_CmdProc * cmdProc, Snack_DelCmdProc * delCmdProc)); /* 2 */
    int (*snack_AddFileFormat) _ANSI_ARGS_((char * formatName, guessFileTypeProc * guessProc, getHeaderProc * GetHeaderProc, extensionFileTypeProc * extProc, putHeaderProc * PutHeaderProc, openProc * OpenProc, closeProc * CloseProc, readSamplesProc * ReadSamplesProc, writeSamplesProc * WriteSamplesProc, seekProc * SeekProc)); /* 3 */
    int (*snack_AddCallback) _ANSI_ARGS_((Sound * s, updateProc * proc, ClientData cd)); /* 4 */
    void (*snack_RemoveCallback) _ANSI_ARGS_((Sound * s, int id)); /* 5 */
    void (*snack_ExecCallbacks) _ANSI_ARGS_((Sound * s, int flag)); /* 6 */
    void (*snack_UpdateExtremes) _ANSI_ARGS_((Sound * s, int start, int end, int flag)); /* 7 */
    Sound * (*snack_GetSound) _ANSI_ARGS_((Tcl_Interp * interp, char * name)); /* 8 */
    Sound * (*snack_NewSound) _ANSI_ARGS_((int frequency, int format, int nchannels)); /* 9 */
    int (*snack_ResizeSoundStorage) _ANSI_ARGS_((Sound * s, int len)); /* 10 */
    void (*snack_DeleteSound) _ANSI_ARGS_((Sound * s)); /* 11 */
    void (*snack_PutSoundData) _ANSI_ARGS_((Sound * s, int pos, void * buf, int nBytes)); /* 12 */
    void (*snack_GetSoundData) _ANSI_ARGS_((Sound * s, int pos, void * buf, int nBytes)); /* 13 */
    unsigned char (*snack_Lin2Alaw) _ANSI_ARGS_((short pcm_val)); /* 14 */
    unsigned char (*snack_Lin2Mulaw) _ANSI_ARGS_((short pcm_val)); /* 15 */
    short (*snack_Alaw2Lin) _ANSI_ARGS_((unsigned char a_val)); /* 16 */
    short (*snack_Mulaw2Lin) _ANSI_ARGS_((unsigned char u_val)); /* 17 */
    short (*snack_SwapShort) _ANSI_ARGS_((short s)); /* 18 */
    int (*snackSeekFile) _ANSI_ARGS_((seekProc * SeekProc, Sound * s, Tcl_Interp * interp, Tcl_Channel ch, int pos)); /* 19 */
    int (*snackOpenFile) _ANSI_ARGS_((openProc * OpenProc, Sound * s, Tcl_Interp * interp, Tcl_Channel * ch, char * mode)); /* 20 */
    int (*snackCloseFile) _ANSI_ARGS_((closeProc * CloseProc, Sound * s, Tcl_Interp * interp, Tcl_Channel * ch)); /* 21 */
    void (*snack_WriteLog) _ANSI_ARGS_((char * s)); /* 22 */
    void (*snack_WriteLogInt) _ANSI_ARGS_((char * s, int n)); /* 23 */
    SnackFileFormat * (*snack_GetFileFormats) _ANSI_ARGS_((void)); /* 24 */
    void (*snack_InitWindow) _ANSI_ARGS_((float * hamwin, int winlen, int fftlen, int type)); /* 25 */
    int (*snack_InitFFT) _ANSI_ARGS_((int n)); /* 26 */
    int (*snack_DBPowerSpectrum) _ANSI_ARGS_((float * x)); /* 27 */
    void (*snack_StopSound) _ANSI_ARGS_((Sound * s, Tcl_Interp * interp)); /* 28 */
    int (*snack_ProgressCallback) _ANSI_ARGS_((Tcl_Obj * cmd, Tcl_Interp * interp, char * type, double fraction)); /* 29 */
    void (*snack_CreateFileFormat) _ANSI_ARGS_((Snack_FileFormat * typePtr)); /* 30 */
    long (*snack_SwapLong) _ANSI_ARGS_((long s)); /* 31 */
    int (*snack_PlatformIsLittleEndian) _ANSI_ARGS_((void)); /* 32 */
    void (*snack_CreateFilterType) _ANSI_ARGS_((Snack_FilterType * typePtr)); /* 33 */
} SnackStubs;

#ifdef __cplusplus
extern "C" {
#endif
extern SnackStubs *snackStubsPtr;
#ifdef __cplusplus
}
#endif

#if defined(USE_SNACK_STUBS) && !defined(USE_SNACK_STUB_PROCS)

/*
 * Inline function declarations:
 */

/* Slot 0 is reserved */
/* Slot 1 is reserved */
#ifndef Snack_AddSubCmd
#define Snack_AddSubCmd \
	(snackStubsPtr->snack_AddSubCmd) /* 2 */
#endif
#ifndef Snack_AddFileFormat
#define Snack_AddFileFormat \
	(snackStubsPtr->snack_AddFileFormat) /* 3 */
#endif
#ifndef Snack_AddCallback
#define Snack_AddCallback \
	(snackStubsPtr->snack_AddCallback) /* 4 */
#endif
#ifndef Snack_RemoveCallback
#define Snack_RemoveCallback \
	(snackStubsPtr->snack_RemoveCallback) /* 5 */
#endif
#ifndef Snack_ExecCallbacks
#define Snack_ExecCallbacks \
	(snackStubsPtr->snack_ExecCallbacks) /* 6 */
#endif
#ifndef Snack_UpdateExtremes
#define Snack_UpdateExtremes \
	(snackStubsPtr->snack_UpdateExtremes) /* 7 */
#endif
#ifndef Snack_GetSound
#define Snack_GetSound \
	(snackStubsPtr->snack_GetSound) /* 8 */
#endif
#ifndef Snack_NewSound
#define Snack_NewSound \
	(snackStubsPtr->snack_NewSound) /* 9 */
#endif
#ifndef Snack_ResizeSoundStorage
#define Snack_ResizeSoundStorage \
	(snackStubsPtr->snack_ResizeSoundStorage) /* 10 */
#endif
#ifndef Snack_DeleteSound
#define Snack_DeleteSound \
	(snackStubsPtr->snack_DeleteSound) /* 11 */
#endif
#ifndef Snack_PutSoundData
#define Snack_PutSoundData \
	(snackStubsPtr->snack_PutSoundData) /* 12 */
#endif
#ifndef Snack_GetSoundData
#define Snack_GetSoundData \
	(snackStubsPtr->snack_GetSoundData) /* 13 */
#endif
#ifndef Snack_Lin2Alaw
#define Snack_Lin2Alaw \
	(snackStubsPtr->snack_Lin2Alaw) /* 14 */
#endif
#ifndef Snack_Lin2Mulaw
#define Snack_Lin2Mulaw \
	(snackStubsPtr->snack_Lin2Mulaw) /* 15 */
#endif
#ifndef Snack_Alaw2Lin
#define Snack_Alaw2Lin \
	(snackStubsPtr->snack_Alaw2Lin) /* 16 */
#endif
#ifndef Snack_Mulaw2Lin
#define Snack_Mulaw2Lin \
	(snackStubsPtr->snack_Mulaw2Lin) /* 17 */
#endif
#ifndef Snack_SwapShort
#define Snack_SwapShort \
	(snackStubsPtr->snack_SwapShort) /* 18 */
#endif
#ifndef SnackSeekFile
#define SnackSeekFile \
	(snackStubsPtr->snackSeekFile) /* 19 */
#endif
#ifndef SnackOpenFile
#define SnackOpenFile \
	(snackStubsPtr->snackOpenFile) /* 20 */
#endif
#ifndef SnackCloseFile
#define SnackCloseFile \
	(snackStubsPtr->snackCloseFile) /* 21 */
#endif
#ifndef Snack_WriteLog
#define Snack_WriteLog \
	(snackStubsPtr->snack_WriteLog) /* 22 */
#endif
#ifndef Snack_WriteLogInt
#define Snack_WriteLogInt \
	(snackStubsPtr->snack_WriteLogInt) /* 23 */
#endif
#ifndef Snack_GetFileFormats
#define Snack_GetFileFormats \
	(snackStubsPtr->snack_GetFileFormats) /* 24 */
#endif
#ifndef Snack_InitWindow
#define Snack_InitWindow \
	(snackStubsPtr->snack_InitWindow) /* 25 */
#endif
#ifndef Snack_InitFFT
#define Snack_InitFFT \
	(snackStubsPtr->snack_InitFFT) /* 26 */
#endif
#ifndef Snack_DBPowerSpectrum
#define Snack_DBPowerSpectrum \
	(snackStubsPtr->snack_DBPowerSpectrum) /* 27 */
#endif
#ifndef Snack_StopSound
#define Snack_StopSound \
	(snackStubsPtr->snack_StopSound) /* 28 */
#endif
#ifndef Snack_ProgressCallback
#define Snack_ProgressCallback \
	(snackStubsPtr->snack_ProgressCallback) /* 29 */
#endif
#ifndef Snack_CreateFileFormat
#define Snack_CreateFileFormat \
	(snackStubsPtr->snack_CreateFileFormat) /* 30 */
#endif
#ifndef Snack_SwapLong
#define Snack_SwapLong \
	(snackStubsPtr->snack_SwapLong) /* 31 */
#endif
#ifndef Snack_PlatformIsLittleEndian
#define Snack_PlatformIsLittleEndian \
	(snackStubsPtr->snack_PlatformIsLittleEndian) /* 32 */
#endif
#ifndef Snack_CreateFilterType
#define Snack_CreateFilterType \
	(snackStubsPtr->snack_CreateFilterType) /* 33 */
#endif

#endif /* defined(USE_SNACK_STUBS) && !defined(USE_SNACK_STUB_PROCS) */

/* !END!: Do not edit above this line. */

#endif /* _SNACKDECLS */
