/*
 * This file is part of the sn package.
 * Distribution of sn is covered by the GNU GPL. See file COPYING.
 * Copyright  1998-2000 Harold Tay.
 * Copyright  2000- Patrik Rdman.
 */

#include <unistd.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <out.h>
#include <pwd.h>
#include <grp.h>
#include <string.h>

static const char rcsid[] = "$Id$";

char *snroot = SNROOT;
uid_t snuid;
uid_t sngid;

void parameters (int wantwriteperms)
{
   struct stat st;

   if (!(snroot = getenv("SNROOT")))
      snroot = SNROOT;

   if (-1 == stat(snroot, &st))
      fail(2, "Can't find \"%s\":%m");
   if (!S_ISDIR(st.st_mode))
      fail(2, "%s is not a directory");
   snuid = st.st_uid;
   sngid = st.st_gid;
   if (0 == geteuid())
   {
      setgid(sngid);
      setuid(snuid);
   }

   if (wantwriteperms)
      if (snuid != geteuid() || sngid != getegid())
      {
         char euid_name[10], egid_name[10];

         strncpy(euid_name, (getpwuid(geteuid()))->pw_name, 10);
         strncpy(egid_name, (getgrgid(getegid()))->gr_name, 10);
         fail(2, "Can't write in %s (I am %s.%s, must be %s.%s)", snroot,
              euid_name, egid_name, (getpwuid(snuid))->pw_name, (getgrgid(sngid))->gr_name);
      }
}
