/* files-db.c  --  The file holding all i/o functions required by Sigitdb..
   
   Copyright (C) Kenneth 'Redhead' Nielsen <kn@redhead.dk>
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */


/****
 * $Id: files-db.c,v 1.3 2003/07/22 22:03:42 redhead Exp $ 
 * $Log: files-db.c,v $
 * Revision 1.3  2003/07/22 22:03:42  redhead
 * Cleaned up the code, which included rewriting every structure in the program.
 * Fixed some error checking, to make sure theres no undocumentet parts that might
 * produce an error.
 *
 * Revision 1.2  2002/10/18 18:25:23  redhead
 * Added the use of boxes to create a surrounding box around the signature
 * This introduced the --with-boxes flag to configure.
 * If that flag isn't used it will default be assumed boxes isn't installed
 * Else the configure script will search for boxes, if none should be found
 * in the search path, you can use --with-boxes=/where to specify it.
 *
 ****/



#ifdef sigitdb

#include "files-db.h" /* #include "config.h" */


/*
 * this is the function we need to have, if we're ever gonna 
 * convert this database int a gzip'ed one.. 
 * it will take what ever fifo, and on first call 
 * convert it from gziped to unziped,
 * on any second call it will convert it back to 
 * gziped format.
 * This function will _only_ be called twice for 
 * each run, and everytime it will be from add_sig() 
 */

int gzconvert(FIFO* fifo)
{
  COUNTER counter;
  OLD_COUNTER old_counter;
  static int compression = 0;
  gzFile zip_file;
  FILE*  bin_file;
  char   switch_name[LINE_SIZE +1];

  /* let's decide the random name for our temporery file.. */

  compression = (compression +1)%2;
  if(fifo->verbose > 0)
    printf("[gzconvert]\t\t: Compression is %s\n", compression ? "on turning it off" : "off turning it on");
  /* make sure the temporary file is NON_EXISTING 
     Dosn't matter if its holding the compressed signatures or 
     if its the uncompressed ones. */

  if(compression)
    {
      /* it must be our first call, we only need to create the temporary file on first call */
#ifdef I__HAVE__SNPRINTF
      snprintf(fifo->temp_data, LINE_SIZE, "/tmp/.sigitdb-gz.%d", getpid());
#else
      sprintf(fifo->temp_data, "/tmp/.sigitdb-gz.%d", getpid());
#endif
      
      /* we have a conversion from gziped to unziped */
      if(access(fifo->data_name, R_OK))
	{
	  /* theres no file we can read from, must be after an unlink, shh dont tell anyone, 
	     we're just mengling a bit with the files.. */
	  if(fifo->verbose > 0)
	    printf("[gzconvert]\t\t: After an unlink, we're switching names.\n");
	  goto switch_file;
	}
      if(!(zip_file = gzopen(fifo->data_name, "rb")))
	{
	  if(fifo->verbose > 0)
	    printf("[gzconvert]\t\t: Error: Couldn't open {%s} file for gzip conversion.\n", fifo->data_name);
	  return CONF_ER;
	}
      if(!(bin_file = fopen(fifo->temp_data, "wb")))
	{
	  if(fifo->verbose > 0)
	    printf("[gzconvert]\t\t: Error: Couldn't open {%s} file for gzip conversion.\n", fifo->temp_data);
	  return CONF_ER;
	}
      if(0 >= gzread(zip_file, (void*) &counter, sizeof(COUNTER)))
	{
	  if(fifo->verbose > 0)
	    printf("[gzconvert]\t\t: Error: Couldn't read from file {%s}\n", fifo->data_name);
	  return NO_READ;
	}
      if(0 < strcmp("0.1.4", counter.ver))
	{
	  /* lets mangle with our counter */
	  gzclose(zip_file);
	  if(!(zip_file = gzopen(fifo->data_name, "rb")))
	    {
	      if(fifo->verbose > 0)
		printf("[gzconvert]\t\t: Error: Couldn't open {%s} file for gzip conversion.\n", fifo->data_name);
	      return CONF_ER;
	    } 
	  if(0 >= gzread(zip_file, (void*) &old_counter, sizeof(OLD_COUNTER)))
	    {
	      if(fifo->verbose > 0)
		printf("[gzconvert]\t\t: Error: Couldn't read from file {%s}\n", fifo->data_name);
	      return NO_READ;
	    } 
	  strcpy(counter.ver, VERSION);
	  counter.count = old_counter.count;
	  counter.remain = 0;
	}
      if(!fwrite((void*) &counter, sizeof(COUNTER),1, bin_file))
	{
	  if(fifo->verbose > 0)
	    printf("[gzconvert]\t\t: Error: Couldn't write to file {%s}\n", fifo->temp_data);
	  return WRITE_ERR;
	}
      while(!gzeof(zip_file))
	{
	  /* just read the gziped file, and print it to bin file */
	  if(0 >= gzread(zip_file, (void*) &fifo->sig, sizeof(SIG)))
	    {
	      if(gzeof(zip_file))
		break;
	      if(fifo->verbose > 0)
		printf("[gzconvert]\t\t: Error: Unable to read from file {%s}\n", fifo->data_name);
	      return NO_READ;
	    } 
	  if(!fwrite((void*) &(fifo->sig), sizeof(SIG),1, bin_file))
	    {
	      if(fifo->verbose > 0)
		printf("[gzconvert]\t\t: Error: Couldn't write to file {%s}\n", fifo->temp_data);
	      return WRITE_ERR;
	    }  
	}
      gzclose(zip_file);
      fclose(bin_file);
    }
  else
    {
      /* It must be an uncompressed file we're dealing with */

      if(access(fifo->data_name, R_OK))
	{
	  /* theres no file we can read from, must be after an unlink, shh dont tell anyone, 
	     we're just mengling abit with the files.. */
	  if(fifo->verbose > 0)
	    printf("[gzconvert]\t\t: An unknown error has happened, suddently {%s} dosn't exist enymore.\n", fifo->data_name);
	  return CONF_MI;
	}
      if(!(zip_file = gzopen(fifo->temp_data, "wb")))
	{
	  if(fifo->verbose > 0)
	    printf("[gzconvert]\t\t: Error: Couldn't open {%s} file for gzip conversion.\n", fifo->temp_data);
	  return CONF_ER;
	}
      if(!(bin_file = fopen(fifo->data_name, "rb")))
	{
	  if(fifo->verbose > 0)
	    printf("[gzconvert]\t\t: Error: Couldn't open {%s} file for gzip conversion.\n", fifo->data_name);
	  return CONF_ER;
	}
      if(!fread((void*) &counter, sizeof(COUNTER),1, bin_file))
	{
	  if(fifo->verbose > 0)
	    printf("[gzconvert]\t\t: Error: Couldn't read from file {%s}\n", fifo->data_name);
	  return NO_READ;
	}
      if(0 >= gzwrite(zip_file, (void*) &counter, sizeof(COUNTER)))
	{
	  if(fifo->verbose > 0)
	    printf("[gzconvert]\t\t: Error: Couldn't write to file {%s}\n", fifo->temp_data);
	  return WRITE_ERR;
	}
      while(!feof(bin_file))
	{
	  /* just read the uncompressed file, and print it to gziped file */
	  if(!fread((void*) &(fifo->sig), sizeof(SIG),1, bin_file))
	    {
	      if(feof(bin_file))
		break;
	      if(fifo->verbose > 0)
		printf("[gzconvert]\t\t: Error: Unable to read from file {%s}\n", fifo->data_name);
	      return NO_READ;
	    } 
	  if(0 >= gzwrite(zip_file, (void*) &(fifo->sig), sizeof(SIG)))
	    {
	      if(fifo->verbose > 0)
		printf("[gzconvert]\t\t: Error: Couldn't write to file {%s}\n", fifo->temp_data);
	      return WRITE_ERR;
	    }  
	}
      gzclose(zip_file);
      fclose(bin_file);
    }
    
 switch_file:
  strcpy(switch_name, fifo->data_name);
  strcpy(fifo->data_name, fifo->temp_data);
  strcpy(fifo->temp_data, switch_name);
  unlink(fifo->temp_data);
  return SUCCESS;
}



/*
 * this is a function, which will take an integer, 
 * and from that make a unique hexa number. 
 * it is intentively to be called when you realy need a unique number
 * the buff should hold atleast HEX_COUNT space.
 */

void create_hex(char buff[])
{
   /* creating a number which you cant
    * recreate in a million years or so.. 
    * unless the time on your computer 
    * is realy fucked.. 
    */
  static size_t counter = 0;
  size_t time_stamp = time(NULL);
  counter++;
  time_stamp += counter;
#ifdef I__HAVE__SNPRINTF
  snprintf(buff, HEXCOUNT, "%X", time_stamp);
#else
  sprintf(buff, "%X", time_stamp);
#endif
}


/* 
 * In order to correct the presettings:
 * Number        : X
 * Identifier    : Y
 * Signature     : Line one
 *                 Line two
 *
 * We need to do some buffer magic, so we 
 * have this function to correct that 
 */

int buffer_mangler(char buffer[], int number)
{
  int length, i = 0, count = number;
  length = strlen(buffer);
  if(number > length)
    return FAILURE;
  /* just add what ever is in the buffer, since it should preceed anything comming */
  for(; buffer[count] != '\0'; count++, i++)
    buffer[i] = buffer[count];
  buffer[i] = '\0';
  return SUCCESS;
}


/* 
 * A function to add all the signatures you need 
 * 
 * It is kinda a "everything bundled into one" 
 * If the file send to it, is _not_ having "@@" in the 
 * first line, it is assumed the entire file is the signature.
 * 
 * If the file has a @@@\t@@\t@ as the first line, it is assumed
 * the file is either created by a --list, or from a --edit
 * thus the file will be read as containing several signatures.
 *
 * Should the first line start with @@, but not have been caught by
 * the previus, it will be assumed it is personaly created, and what
 * ever is found between "@@" and "@@" will be the entire signature.
 * Thus it is _ONLY_ if the first line is @@@\t@@\t@ it is assumed there
 * will be a header repressenting:
 *
 * Number        : X
 * Identifier    : Y
 * Signature     : Line one
 *                 Line two
 *
 * Should the structure tend to look like this, but not follow it quite, 
 * then it will take counter messures, to correct that, but if theres more than 
 * 3 failing signtures, it will give up for good, and assume it is a "@@" 
 * seperated file.
 *
 */

int add_sig(FIFO* fifo)
{
  FILE* in_file;
  unsigned int  total = 0, number, identifier, ver = 0, line_size = LINE_SIZE +20, misses = 0;
  char buffer[line_size +1];

  if(SUCCESS != gzconvert(fifo))
    {
      if(fifo->verbose > 0)
	printf("[add_sig]\t\t: Error: Couldn't convert file {%s}\n", fifo->data_name);
      return CONF_HR;
    }
  fifo->sig.sig[0] = '\0';
  if(fifo->delete[0] == 'S')
    {
      in_file = stdin;
      buffer[0] = '\0';
      ver = fifo->verbose;
      fifo->sig.sig[0] = '\0';
      fifo->sig.ident[0] = '\0';
      fifo->verbose = 0;
      printf("\n[add_sig]\t\t: Reading signature from stdin, use ^D to end transmission.\n\n");
      goto stdin_sig;
    }
  if(fifo->verbose > 0)
    printf("[add_sig]\t\t: Getting sig from file {%s}\n", fifo->fifo_name);
    
  /*
   * first we have the routine to read in the signature.. 
   * let's hope theres enough room for it in the NUM_LINES*LINE_SIZE
   * let's hope fopen will return NULL if the file dosnt exist.
  */
  if(!(in_file = fopen(fifo->fifo_name, "r")))
    {
      if(fifo->verbose > 0)
	printf("[add_sig]\t\t: Error: There's no file named {%s}\n", fifo->fifo_name);
      gzconvert(fifo);
      return CONF_MI;
    }
  /* else lets peek in the file, to see if it contains alot of signatures.. */
  if(!fgets(buffer, line_size, in_file))
    {
      if(fifo->verbose > 0)
	printf("[add_sig]\t\t: Error: The file is empty.\n");
      gzconvert(fifo);
      return NO_READ;
    }
  if(!strncmp(buffer, "@@@\t@@\t@\n", 9))
    { 
      /* we have our own 'new' design to read. */
      if(!fgets(buffer, line_size, in_file))
	{
	  if(fifo->verbose > 0)
	    printf("[add_sig]\t\t: Error: The file is empty.\n");
	  gzconvert(fifo);
	  return NO_READ;
	}
      /* first line will/should allways be "Number\t\t: X", we should disregard it, but lets check to be sure */
      if(sscanf(buffer, "Number\t\t: %d\n", &number) != 1)
	{
	  /* 
	   * If the number dosn't exist we might abort,
	   * but what if we continued, to see if the Identifier is there.. 
	   */
	  if(fifo->verbose > 0)
	    {
	      printf("[add_sig]\t\t: Error: It wasn't our expected Number line.\n");
	      printf("[add_sig]\t\t: Error: Suspecting the worst, but giving it another shot.\n");
	      return FAILURE;
	    }
	}
      if(!fgets(buffer, line_size, in_file))
	{
	  if(fifo->verbose > 0)
	    printf("[add_sig]\t\t: Error: The file is empty.\n");
	  fclose(in_file);
	  gzconvert(fifo);
	  return NO_READ;
	}
      if(sscanf(buffer, "Identifier\t: %X\n", &identifier) != 1)
	{
	  /*
	   * Should the Identifier not bee here, there gotta be something wrong, 
	   * so we should atleast be suspecting something, perhaps search to start, 
	   * and reread first line, then jump to second_check: ?
	  */
	identifier_miss:
	  misses++;
	  if(fifo->verbose > 0)
	    {
	      printf("[add_sig]\t\t: Error: It wasn't our expected Identifier line.\n");
	      printf("[add_sig]\t\t: Error: Is this even a program generated file ?\n");
	      printf("[add_sig]\t\t: Error: Suspecting it to be a manualy generated file,\n");
	      printf("[add_sig]\t\t: Error: made to look as a program generated one.\n");
	      printf("[add_sig]\t\t: Error: Taking counter messures, to handle that.\n");
	    }
	      return FAILURE;
	  fifo->sig.ident[0] = '\0';
	  /* lets read another line, and see if its a Signature: thing, some dumb? user made*/
	  if(!fgets(buffer, line_size, in_file))
	    {
	      if(fifo->verbose > 0)
		printf("[add_sig]\t\t: Error: The file is empty.\n");
	      fclose(in_file);
	      gzconvert(fifo);
	      return NO_READ;
	    }
	  if(!strncmp(buffer, "Signature", 9))
	    {
	      /*
	       * Well, what do you know, it was a user, who wanted to copy the orriginal structure
	       * then we better read the file as such one.
	       */

	      goto signature_start;
	    }
	  /*
	   * Even the Signature failed, then we assume it is a normal user created:
	   *
	   * @@
	   * signature 1
	   * @@
	   * signature 2
	   * @@
	   *
	   * seperated file
	   *
	   */

	giving_up:
	  fifo->sig.sig[0] = '\0';
	  if(!fseek(in_file, 0L, SEEK_SET))
	    {
	      if(fifo->verbose > 0)
		printf("[add_sig]\t\t: Error: Can not seek to begining of file.\n");
	      fclose(in_file);
	      gzconvert(fifo);
	      return SEEK_ERR;
	    }
	  if(!fgets(buffer, line_size, in_file))
	    {
	      if(fifo->verbose > 0)
		printf("[add_sig]\t\t: Error: The file is empty.\n");
	      fclose(in_file);
	      gzconvert(fifo);
	      return NO_READ;
	    }
	  goto second_check;
	}
	sprintf(fifo->sig.ident, "%X", identifier);
      while(!feof(in_file))
	{
	  if(!fgets(buffer, line_size, in_file))
	    {
	      if(fifo->verbose > 1)
		printf("[add_sig]\t\t: There was nothing more to read.\n");
	      continue; /* next time in the while this will get cought */
	    }
	  if(!strncmp(buffer, "Signature\t: ", 12))
	    {
	    signature_start:
	      if(buffer_mangler(buffer, 12))
		if(fifo->verbose > 0)
		  printf("[add_sig]\t\t: Error: The buffer length is less than {11}\n");
	    }
	  else
	    if(!strncmp(buffer, "\t\t  ", 4))
	      {
		if(buffer_mangler(buffer, 4))
		  if(fifo->verbose > 0)
		    printf("[add_sig]\t\t: Error: The buffer length is less than {4}\n");
	      }
	  if(!strncmp(buffer, "@@", 2))
	    {
	      /* now we must assume, that the entire sig is gathered in fifo->sig */
	      if(set_sig(fifo))
		{
		  fclose(in_file);
		  gzconvert(fifo);
		  return FAILURE;
		}
	      if(!fgets(buffer, line_size, in_file))
		{
		  /* it could be the very last sig */
		  if(feof(in_file))
		    break;
		  if(fifo->verbose > 0)
		    printf("[add_sig]\t\t: Error: Unable to read from file.\n");
		  gzconvert(fifo);
		  return NO_READ;
		}
	      /* first line will/should allways be "Number\t\t: X", we should disregard it, but lets check to be sure */
	      if(sscanf(buffer, "Number\t\t: %d\n", &number) != 1)
		{
		  /* 
		   * If the number dosn't exist we might abort,
		   * but what if we continued, to see if the Identifier is there.. 
		   */
		  if(fifo->verbose > 0)
		    {
		      printf("[add_sig]\t\t: Error: It wasn't our expected Number line.\n");
		      printf("[add_sig]\t\t: Error: Suspecting the worst, but giving it another shot.\n");
		    }
		}
	      if(!fgets(buffer, line_size, in_file))
		{
		  if(fifo->verbose > 0)
		    printf("[add_sig]\t\t: Error: The file is empty.\n");
		  fclose(in_file);
		  gzconvert(fifo);
		  return NO_READ;
		}
	      if(sscanf(buffer, "Identifier\t: %X\n", &identifier) != 1)
		{
		  /*
		   * We allready have all these checks, so lets jump to there.. 
		   *
		   * Should we have been here too many times, then we must assume it will allways fail.
		   */
		  if(misses > 4)
		    {
		      /* Unlink the db-file thats allready been set, and assume its a @@ seperated */
		      unlink(fifo->data_name);
		      if(fifo->verbose > 0)
			{
			  printf("[add_sig]\t\t: Error: The Identifier has been missing in too many signatures,\n");
			  printf("[add_sig]\t\t: Error: Assuming its a \"@@\" seperated file, and giving up on\n");
			  printf("[add_sig]\t\t: Error: taking counter messures for the \"@@@\\t@@\\t@\" seperation.\n");
			}
		      
		      goto giving_up;
		    }
		  /* This could give us problems, if we're not carefull it can give endless loops */
		  goto identifier_miss;
		}
	      sprintf(fifo->sig.ident, "%X", identifier);
	      total = 0;
	      fifo->sig.sig[0] = '\0';
	      continue; /* lets skip the rest of the loop */
	    }
	  if(fifo->sig.sig[0] == '\0')
	  {
	    total += strlen(buffer); /* first time will allways have enough room */
	    if(fifo->verbose > 1)
	      printf("[add_sig]\t\t: The total is {%d}\n", total);	    
	    strcpy(fifo->sig.sig, buffer); /* we hope this is the first sig line */
	  }
	  else
	    {
	      if((total += strlen(buffer)) < (NUM_LINES*LINE_SIZE -1))
		{
		  strncat(fifo->sig.sig, buffer, strlen(buffer));
		}
	      else
		{
		  if(fifo->verbose > 0)
		   printf("[add_sig]\t\t: Error: The signature was longer than {%d} chars.\n", 
			  NUM_LINES*LINE_SIZE);
		 fclose(in_file);
		  gzconvert(fifo);
		  return EXCEEDED;
		}
	    }
	  if(fifo->verbose > 2)
	    printf("[add_sig]\t\t: The buffer is containing {%s", buffer); 
	}
      fclose(in_file);
    }
  else
    if(!strncmp(buffer, "@@", 2))
      {
      second_check:
	/* user defined @@ sepperated file */
	while(!feof(in_file))
	  {
	    if(!fgets(buffer, LINE_SIZE, in_file))
	      {
		if(fifo->verbose > 1)
		  printf("[add_sig]\t\t: There was nothing more to read.\n");
		continue; /* next time in the while this will get cought */
	    }
	    total += strlen(buffer); /* first time will allways have enough room */
	    if(fifo->verbose > 1)
	      printf("[add_sig]\t\t: The total is {%d}\n", total);
	    strcpy(fifo->sig.sig, buffer); /* we hope this is the first sig line */
	    if(fifo->verbose > 2)
	      printf("[add_sig]\t\t: The buffer is containing {%s", buffer);
	    while(!feof(in_file))
	      { /* we recon theres gonna be no error once we made the first successfull read */
		fgets(buffer, LINE_SIZE, in_file);
		if(!strncmp(buffer, "@@", 2))
		  {/* now we must assume, that the entire sig is gathered in sign */
		  if(set_sig(fifo))
		    {
		      fclose(in_file);
		      gzconvert(fifo);
		      return FAILURE;
		    }
		  fifo->sig.sig[0] = '\0';
		  fifo->sig.ident[0] = '\0';
		  total = 0;
		  continue; /* lets skip the rest of the loop */
		  }
	      if((total += strlen(buffer)) < (NUM_LINES*LINE_SIZE -1))
		{
		  strncat(fifo->sig.sig, buffer, strlen(buffer));
		}
	      else
		{
		  if(fifo->verbose > 0)
		    printf("[add_sig]\t\t: Error: The signature was longer than {%d} chars.\n", 
			   NUM_LINES*LINE_SIZE);
		  fclose(in_file);
		  gzconvert(fifo);
		  return EXCEEDED;
		}
	      }
	    total = 0;
	  }
	fclose(in_file);
      }
    else
      { /* we only have one sig, so lets just put that in there.. */
	if(!strncmp("Alex, what is the greatest band EVER?", buffer, 37))
	  _shine_on_you_crazy_diamond_();
#ifdef I__HAVE__STRNCPY
      strncpy(fifo->sig.sig, buffer, strlen(buffer));
#else
      strcpy(fifo->sig.sig, buffer);
#endif
      if(fifo->verbose > 1)
	printf("[add_sig]\t\t: The buffer is containing {%s", buffer);
      fifo->sig.sig[strlen(buffer)] = '\0';
    stdin_sig:
      while (fgets(buffer, LINE_SIZE, in_file) > 0)
	{
 	  total += strlen(buffer);
	  if(fifo->verbose > 1)
	    printf("[add_sig]\t\t: The total is: %d.\n", total);
	  if(total < NUM_LINES*LINE_SIZE)
	    {
	      strncat(fifo->sig.sig, buffer, strlen(buffer));
	      continue;
	    }
	  else
	    {
	      if(fifo->verbose > 0)
		printf("[add_sig]\t\t: Error: The signature was longer than {%d} chars.\n", 
		      NUM_LINES*LINE_SIZE);
	      fclose(in_file);
	      gzconvert(fifo);
	      return EXCEEDED;
	    }
	}
      if(fifo->delete[0] == 'S')
	fifo->verbose = ver;
      if(set_sig(fifo))
	{
	  fclose(in_file);
	  gzconvert(fifo);
	  return FAILURE;
	}
      fclose(in_file);
    }
  if(SUCCESS != gzconvert(fifo))
    {
      if(fifo->verbose > 0)
	printf("[add_sig]\t\t: Error: Couldn't convert file {%s}\n", fifo->data_name);
      return CONF_HR;
    }
  if(fifo->verbose > 0)
    printf("[add_sig]\t\t:    DONE\n");
  return SUCCESS;
}


/* 
 * This function is very simmular to the get_sig() it just writes in a loop what's in the database 
 * to a strict text file.
 *
 * Should it be a request for deleting a signature, it will delete and exit
 * befor having to start the $EDITOR
 *
 * Should we have requested a --list, it will print the output to stdout instead of creating a file
 * and it will not invoke the $EDITOR.
 *
 * However it's orriginal purpus, will make it execute your $EDITOR, so that you can edit 
 * the signatures directly in a known environment.
 *
 */
	
int edit_db_file(FIFO* fifo)
{
  char test_temp[NUM_LINES*LINE_SIZE +2], exec_line[LINE_SIZE +1], *editor; 
  size_t i = 1, pid, xpid;
  int waiter;
  gzFile in_file;
  FILE* out_file;
  COUNTER counter;
  OLD_COUNTER old_counter;
  if(fifo->verbose > 0)
    {
      printf("[edit_db_file]\t\t: Writing edit file.\n");
      printf("[edit_db_file]\t\t: Getting sig from file {%s}\n", fifo->data_name);
    } 

  if(!(in_file = gzopen(fifo->data_name, "rb")))
    { /* at this point we should be at the top of the file */
      /* some error happened */
      if(fifo->verbose > 0)
	printf("[edit_db_file]\t\t: Error: Can not open data file.\n");
      return CONF_MI;
    }
  if(fifo->delete[0] == 'L')
    out_file = stdout;
  else
    if(!(out_file = fopen(fifo->fifo_name, "w")))
      {
	/* at this point we should be at the top of the file */
	/* some error happened */
	if(fifo->verbose > 0)
	  printf("[edit_db_file]\t\t: Error: Can not open editing file {%s}\n", fifo->fifo_name);
	return CONF_MI;
      }
  if(0 >= gzread(in_file, (void*) &counter, sizeof(COUNTER)))
    {
      if(fifo->verbose > 0)
	printf("[edit_db_file]\t\t: Error: Can't read from file {%s}\n", fifo->data_name);
      /* some error happened */
      gzclose(in_file);
      fclose(out_file);
      return COUNT_MISS;
    }
  if(0 < strcmp("0.1.4", counter.ver))
    {
      /* lets mangle with our counter */
      gzclose(in_file);
      if(!(in_file = gzopen(fifo->data_name, "rb")))
	{
	  if(fifo->verbose > 0)
	    printf("[edit_db_file]\t\t: Error: Couldn't open {%s} file for counter mengeling.\n", fifo->data_name);
	  return CONF_ER;
	} 
      if(0 >= gzread(in_file, (void*) &old_counter, sizeof(OLD_COUNTER)))
	{
	  if(fifo->verbose > 0)
	    printf("[edit_db_file]\t\t: Error: Couldn't read from file {%s}\n", fifo->data_name);
	  return NO_READ;
	} 
      strcpy(counter.ver, old_counter.ver);
      counter.count = old_counter.count;
      counter.remain = 0;
    }
  counter.count = (int)  ntohl(counter.count);
  if(fifo->verbose > 1)
    printf("[edit_db_file]\t\t: Total is {%ld}\n", counter.count);
  /* now we know the max count, so lets get all the signatures for that */

  
  for(; i <= counter.count+1 && !gzeof(in_file); i++)
    { 
      if(0 >= gzread(in_file, (void*) &(fifo->sig), sizeof(SIG)))
	{
  /* should this fail, due to a premature EOF, then we better not return it failed */
	  if(gzeof(in_file))
	    continue;
	  if(fifo->verbose > 0)
	    printf("[edit_db_file]\t\t: Error: Can't read from file {%s}\n", fifo->data_name);
	  gzclose(in_file);
	  fclose(out_file);
	  return NO_READ;
	}
      if(fifo->delete[0] != '\0' && !strcasecmp(fifo->sig.ident, fifo->delete))
	{
	  if(fifo->verbose > 0)
	    printf("[edit_db_file]\t\t: Deleting Sig {%s}\n", fifo->delete);
	  continue; /* hmm this was the signature we wanted to delete.. */
	}

      if(0 < sprintf(test_temp,"%s", fifo->sig.sig)) /* this is ugly.. totaly idiotic.. */
	{ /* but it is nesssary, if we want to have the correct number of signatures..*/
	  /* non the less.. it seems to remove the very last signature from the database */
	  if(!fprintf(out_file, "@@@\t@@\t@\nNumber\t\t: %d\nIdentifier\t: %s\n", 
		      i, fifo->sig.ident))
	    {
	      if(fifo->verbose > 0)
		printf("[edit_db_file]\t\t: Error: Can't write to editing file.\n");
	      gzclose(in_file);
	      fclose(out_file);
	      return FAILURE;
	    }
	  if(print_sig(out_file, fifo->sig.sig))
	    {
	      if(fifo->verbose > 0)
		printf("[edit_db_file]\t\t: Error: Can't write to editing file.\n");
	      gzclose(in_file);
	      fclose(out_file);
	      return FAILURE;
	    }
	}
    }
  /* here we must be at the end of the out_put file.. Thus we create the last thing */
  fifo->sig.sig[0] = '\0';
  if(!fprintf(out_file, "@@@@\n"))
    {
      if(fifo->verbose > 0)
	printf("[edit_db_file]\t\t: Error: Can't write to editing file.\n");
      gzclose(in_file);
      fclose(out_file);
      return FAILURE;
    }
  if(fifo->verbose > 0)
    printf("[edit_db_file]\t\t:    DONE\n");
  gzclose(in_file);
  fclose(out_file);
  if(fifo->delete[0] != '\0')
    return SUCCESS;
  if ((!(editor = getenv("VISUAL")))
      && (!(editor = getenv("EDITOR")))
      ) {
    editor = DEFAULT_EDITOR;
  }
  
  switch (pid = fork()) {
  case -1:
    if(fifo->verbose > 0)
    printf("[edit_db_file]\t\t: Error: Creating fork()\n");
    return FAIL_FO;
  case 0:
    /* child */
    if (chdir("/tmp") < 0) 
      {
	if(fifo->verbose > 0)
	  printf("[edit_db_file]\t\t: Error: Couldn't change dir to /tmp\n");
	return FAILURE;
      } 
    if (strlen(editor) + strlen(fifo->fifo_name) + 2 >= LINE_SIZE) 
      {
	if(fifo->verbose > 0)
	  printf("[edit_db_file]\t\t: Error: The file length with the editor exceeded buffer length.\n");
	return EXCEEDED;
      }
#ifdef I__HAVE__SNPRINTF
    snprintf(exec_line, LINE_SIZE, "%s %s", editor, fifo->fifo_name);
#else
    sprintf(exec_line, "%s %s", editor, fifo->fifo_name);
#endif
    execlp(_PATH_BSHELL, _PATH_BSHELL, "-c", exec_line, NULL);
    if(fifo->verbose > 0)
      printf("[edit_db_file]\t: Error: Couldn't execute editor.\n");
    if(fifo->verbose > 2)
      printf("\t\t\tPowered by: cat - ^D\n\t");
    if(fifo->verbose > 2)
      printf("\t\t\t- Because editors are for whimps.\n");
    return FAILURE;
    /*NOTREACHED*/
  default:
    /* parent */
    break;
  }
  
  /* parent */
  xpid = wait(&waiter);
  if (xpid != pid) 
    {
      if(fifo->verbose > 0)
	printf("[edit_db_file]\t\t: Error: wrong PID (%d != %d) from \"%s\"\n", (int) xpid, (int) pid, editor);
      return FAILURE;
    }
  if (WIFEXITED(waiter) && WEXITSTATUS(waiter)) 
    {
      if(fifo->verbose > 0)
	printf("[edit_db_file]\t\t: Error: \"%s\" exited with status {%d}\n",
	       editor, WEXITSTATUS(waiter));
      return FAILURE;
    }
  if (WIFSIGNALED(waiter)) 
    {
      if(fifo->verbose > 0)
	printf("[edit_db_file]\t\t: Error: \"%s\" killed; signal %d (%score dumped)\n",
	       editor, WTERMSIG(waiter),
	       WCOREDUMP(waiter) ?"" : "no ");
      return FAILURE;
    }
  return SUCCESS;
}


/* 
 * This is the direct oposite of get_sig, it will open the db-file 
 * and set the signature stored in fifo into it.
 */

int set_sig(FIFO* fifo)
{
  char touch_cmd[LINE_SIZE +1];
  FILE* out_file;
  int was_there = 1;
  COUNTER counter;
  strcpy(counter.ver, VERSION);
  if(fifo->verbose > 0)
    printf("[set_sig]\t\t: Setting sig into file {%s}\n", fifo->data_name);
  if(strlen(fifo->sig.sig) > NUM_LINES*LINE_SIZE)
    {
      if(fifo->verbose > 0)
	printf("[set_sig]\t\t: Error: The signature was longer than {%d} chars.\n", 
	      NUM_LINES*LINE_SIZE);
      return EXCEEDED;
    }
  if(fifo->sig.ident[0] == '\0')
    create_hex(fifo->sig.ident);
  if(access(fifo->data_name, F_OK))
    { /* it must be the very first signature.. hence no file */
      if(fifo->verbose > 0)
	printf("[set_sig]\t\t: The signature file never existed, creating one.\n");
#ifdef I__HAVE__SNPRINTF
      snprintf(touch_cmd, LINE_SIZE, "touch %s", fifo->data_name);
#else
      sprintf(touch_cmd, "touch %s", fifo->data_name);
#endif
      system(touch_cmd);
      was_there = 0;
    }
  
  /* if the file allready exists, then there must be atleast one sig in it */
  /* we now return to the start of the file */
   if(!(out_file = fopen(fifo->data_name, "rwb+")))
    {
      if(fifo->verbose > 0)
	printf("[set_sig]\t\t: Error: Cant open file {%s} for adding a sig.\n", fifo->data_name);
      return FAILURE;
    }
  if(fseek(out_file, 0, SEEK_SET) != 0)
    {
      if(fifo->verbose > 0)
	printf("[set_sig]\t\t: Error: Cant seek in file.\n");
      fclose(out_file);
      return SEEK_ERR;
    }
  if(was_there)
    {
    if(!fread((void*) &counter, sizeof(COUNTER),1, out_file))
      {
	if(fifo->verbose > 0)
	  printf("[set_sig]\t\t: Error: Can't read from file {%s}\n", fifo->data_name);
	fclose(out_file);
	return NO_READ;
      }
    counter.count = (int) ntohl(counter.count);
    }
  else
    counter.count = 0;
  if(fifo->verbose > 1)
    printf("[set_sig]\t\t: Counter 1 is {%ld}\n", counter.count);
  
  /* then we increase that, and stores the new value to the file */
  if(fseek(out_file, 0, SEEK_SET) != 0)
    {
      if(fifo->verbose > 0)
	printf("[set_sig]\t\t: Error: Can't seek in file.\n");
      fclose(out_file);
      return SEEK_ERR;
    }
  if(was_there)
    counter.count = htonl(counter.count +1);
  else
    counter.count = htonl(counter.count);
  if(fifo->verbose > 1)
    printf("[set_sig]\t\t: Counter 2 is {%ld}\n", (long int) ntohl(counter.count));
  if(!fwrite((void*) &counter, sizeof(COUNTER),1, out_file))
    {
      if(fifo->verbose > 0)
	printf("[set_sig]\t\t: Error: Can't write count to file {%s}\n", fifo->data_name);
      fclose(out_file);
      return WRITE_ERR;
    }
  fifo->sig.count = counter.count;
  /* now we can search to the end of the file, and store the new signature */
  if(fseek(out_file, 0, SEEK_END) != 0)
    {
      if(fifo->verbose > 0)
	printf("[set_sig]\t\t: Error: Can't seek in file.\n");
      fclose(out_file);
      return SEEK_ERR;
    }

  if(!fwrite((void*) &(fifo->sig), sizeof(SIG),1, out_file))
    {
      if(fifo->verbose > 0)
	printf("[set_sig]\t\t: Error: Can't write signature to file {%s}\n", fifo->data_name);
      fclose(out_file);
      return WRITE_ERR;
    }
  if(fifo->verbose > 0)
    printf("[set_sig]\t\t:     DONE\n");
  fclose(out_file);
  return SUCCESS;
}




/* 
 * print_sig(), is a function that will take a signature,
 * and print it in a special way, where the signature is displayed as:
 *
 * Signature  : signature line one
 *              signature line two
 *
 * This should give a more readable signature. 
 */

int print_sig(FILE* out_file, char* sig)
{
  /* At this point we have a signature, that is one constant char array
   * So in order to decide the lines we will have to look for the '\n'
   * and then replace those with "\n\t\t  "
   * So let's get cranking.. 
  */
  int i = 0;
  /* first line should allways start with "Signature\t: " */
  if(!fprintf(out_file, "Signature\t: "))
    return FAILURE;
  for (; sig[i] != '\0'; i++)
    {
      if (sig[i] == '\n' && sig[i+1] != '\0')
	{
	  if(!fprintf(out_file, "\n\t\t  "))
	    return FAILURE;
	}
	else
	  if(!fprintf(out_file, "%c", sig[i]))
	    return FAILURE;
    }
  return SUCCESS;
}


#endif
