/**
 * Package header
 *
 * Copyright (C) 2000, 2001, 2002, 2003 by
 * Jeffrey Fulmer - <jdfulmer@armstrong.com>
 * This file is distributed as part of Siege 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 * 
 */
#ifndef SETUP_H
#define SETUP_H

#ifdef  HAVE_CONFIG_H
# include <config.h>
#endif/*HAVE_CONFIG_H*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <pthread.h>
#include <ctype.h>
#include <stdarg.h>

#if HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

#ifndef WEXITSTATUS
# define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif

#ifndef WIFEXITED
# define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif

#ifdef  HAVE_UNISTD_H
# include <unistd.h>
#endif/*HAVE_UNISTD_H*/

#ifdef STDC_HEADERS
# include <string.h>
#else
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
char *strchr (), *strrchr ();
# ifndef HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# endif
#endif

#ifdef  HAVE_SYS_TIMES_H
# include <sys/times.h>
#endif/*HAVE_SYS_TIMES_H*/

#if  TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif/*TIME_WITH_SYS_TIME*/

#if HAVE_ERRNO_H
# include <errno.h>
#endif /* HAVE_ERRNO_H */

#ifndef HAVE_SNPRINTF
# define portable_snprintf  snprintf
# define portable_vsnprintf vsnprintf
#endif

#ifndef  PTHREAD_CREATE_JOINABLE
# define PTHREAD_CREATE_JOINABLE  0
#endif /*PTHREAD_CREATE_JOINABLE*/ 
#ifndef  PTHREAD_CREATE_DETACHED
# define PTHREAD_CREATE_DETACHED  1
#endif /*PTHREAD_CREATE_DETACHED*/


#ifndef HAVE_STRCASECMP
int strcasecmp();
#endif
#ifndef HAVE_STRNCASECMP
int strncasecmp();
#endif
#ifndef HAVE_STRNCMP
int strncmp();
#endif
#ifndef HAVE_STRLEN
int strlen();
#endif
#include <joedog/joedog.h>
#include <joedog/boolean.h>
#include <joedog/joepath.h>

#define  MXCHLD         1024
#define  MSG_NOERROR    010000

#define F_CONNECTING  1
#define F_READING     2
#define F_DONE        4

#define MAXREPS       10301062

void display_help();
void display_version(int i);

/** 
 * configuration struct;
 * NOTE: this data is writeable ONLY during 
 * the configuration step before any threads
 * are spawned.
 */
struct CONFIG
{
  BOOLEAN logging;      /* boolean, log transactions to log file   */
  BOOLEAN shlog;        /* show log file configuration directive.  */
  char    *url;         /* URL for the single hit invocation.      */
  char    logfile[128]; /* alternative user defined simbot.log     */ 
  BOOLEAN verbose;      /* boolean, verbose output to screen       */
  BOOLEAN display;      /* boolean, display the thread id verbose  */
  BOOLEAN config;       /* boolean, prints the configuration       */
  int     cusers;       /* default concurrent users value.         */
  int     delay;        /* range for random time delay, see -d     */
  int     timeout;      /* socket connection timeout value, def:10 */
  BOOLEAN bench;        /* signifies a benchmarking run, no delay  */
  BOOLEAN internet;     /* use random URL selection if TRUE        */
  int     time;         /* length of the siege in hrs, mins, secs  */
  int     secs;         /* time value for the lenght of the siege  */
  int     reps;         /* reps to run the test, default infinite  */ 
  char    file[128];    /* urls.txt file, default in joepath.h     */
  int     length;       /* length of the urls array, made global   */
  BOOLEAN debug;        /* boolean, undocumented debug command     */
  BOOLEAN chunked;      /* boolean, accept chunked encoding        */
  BOOLEAN get;          /* get header information for debugging    */ 
  BOOLEAN mark;         /* signifies a log file mark req.          */ 
  char    *markstr;     /* user defined string value to mark file  */
  int     protocol;     /* 0=HTTP/1.0; 1=HTTP/1.1                  */
  BOOLEAN cookies;      /* to use cookies or not to use cookies    */
  char uagent[256];     /* user defined User-Agent string.         */
  char *username;       /* DEPRECATED!! */
  char *password;       /* DEPRECATED!! */ 
  int  bids;            /* W & P authorization bids before failure */
  struct {
    char *encode;
    struct LOGIN *head;
    pthread_mutex_t lock; 
  } auth;  
  BOOLEAN keepalive;    /* boolean, connection keep-alive value    */
  int     signaled;     /* timed based testing notification bool.  */
  char    extra[512];   /* extra http request headers              */ 
  struct {
    BOOLEAN required;   /* boolean, TRUE == use a proxy server.    */
    char *hostname;     /* hostname for the proxy server.          */
    int  port;          /* port number for proxysrv                */ 
    char *encode;       /* base64 encoded username and password    */
    struct LOGIN *head;
    pthread_mutex_t lock; 
  } proxy;
  BOOLEAN login;        /* boolean, client must login first.       */
  char *loginurl;       /* the initial login URL, first URL hit.   */
  int  failures;        /* number of failed attempts before abort. */
  int  failed;          /* total number of socket failures.        */
  BOOLEAN expire;       /* boolean, TRUE == expire cookies ea. run */
  BOOLEAN follow;       /* boolean, TRUE == follow 302             */
  BOOLEAN zero_ok;      /* boolean, TRUE == zero bytes data is OK. */ 
  char rc[256];         /* filename of SIEGERC file                */  
};

struct O_STATUS
{
  int             total_clients;  /* high water thread mark   */
  int             total_threads;  /* number of active threads */
  pthread_cond_t  exit_cond;      /* pthread cond. variable   */
  pthread_mutex_t mutex_lock;     /* w lock for total_threads */
  int             shutting_down;  /* boolean: 1=TRUE, 0=FALSE */
};

/**
 * struct LINES, read by read_cfg_file
 * in config.c 
 */
typedef struct
{
  int  index;
  char **line;
} LINES;

/**
 * enum PROTOCOL
 * tcp/ip protocol
 */
typedef enum
{
  HTTP        = 0,
  HTTPS       = 1,
  UNSUPPORTED = 2
} PROTOCOL;

/**
 * enum DIRECTIVE
 * HTTP request directive
 */
typedef enum
{
  URL_GET   = 0,
  URL_POST  = 1
} DIRECTIVE;

/**
 * authorization type
 */
typedef enum { BASIC, DIGEST } TYPE; 

/**
 * URL struct URL
 */ 
typedef struct
{
  PROTOCOL protocol;       /* currently only http/https   */
  char *hostname;          /* DNS entry or IP address     */
  int  port;               /* tcp port num, defs: 80, 443 */
  char *pathname;          /* path to http resource.      */
  DIRECTIVE calltype;      /* request: GET/POST/HEAD etc. */
  size_t postlen;
  char *postdata;
  char *posttemp;
} URL;

/**
 * client data
 */
typedef struct
{
  int    id;
  int    hits;
  size_t bytes;
  int    code;
  int    fail;
  URL    **U;
  struct {
    int  www;
    int  proxy;
    struct { 
      int  www;
      int  proxy;
    } bids;
    struct {
      TYPE www;
      TYPE proxy;
    } type;
  } auth;
  int      status;
  float    time;
  unsigned int rand_r_SEED; 
  float bigtime;
  float smalltime;
} CLIENT;  


/**
 * cookie node
 */
typedef struct CNODE
{
  int    index;
  pthread_t threadID;
  char   *name;
  char   *value;
  char   *path;
  char   *domain;
  time_t expires;
  char   *expirestr;
  char   *version;
  char   *max;
  int    secure;
  struct CNODE  *next;
} CNODE;

typedef struct
{
  CNODE *first;
  pthread_mutex_t mutex; 
} COOKIE;


#if INTERN
# define EXTERN /* */
#else
# define EXTERN extern
#endif
 
EXTERN struct CONFIG my;
EXTERN struct O_STATUS our;
EXTERN char *version_string; 
EXTERN char *program_name;
EXTERN COOKIE *cookie; 

#endif  /* SETUP_H */
