/***************************************************************************
                          effect_basic.h  -  description
                             -------------------
    begin                : Sat Sep 22 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EFFECT_BASIC_H
#define EFFECT_BASIC_H

#include "effect.h"
#include "event_basic.h"

/**
  *@author Juan Sebastian Linietsky
  */

class Effect_Rpq_Change : public Effect  {
public:

	void notify_command(Uint8 p_parameter) {

		if (p_parameter!=0) {

			data->variables.rpq=p_parameter;
			data->variables.calculate_real_increment();
		}
	}
};

class Effect_Row_Change : public Effect  {
public:

	void notify_command(Uint8 p_parameter) {

		data->position.row=p_parameter;
		data->position.row-=1; //let it there since it becomes incremented.
			
	}
};

class Effect_Tempo_Change : public Effect  {
public:

	void notify_command(Uint8 p_parameter) {

		if (p_parameter!=0) {

			data->variables.tempo=p_parameter;
			data->variables.calculate_real_increment();
		}
	}
};


class Effect_Pitch_Slide : public Effect  {
protected:
	float amount;
	bool slide_down;

        Effect_Pitch_Slide() {

		processing=true;
	}

public:

	void notify_command(Uint8 p_parameter) {

		if (p_parameter!=0) {

			if (p_parameter>0xF0) { //fineslide

				amount=p_parameter&0xF;
				amount/=5.0;
			} else {
								
				amount=p_parameter;		
			}
		}
	}
	
       	void process(int p_time_amount,int p_time_offset) {

	        float modifier;
		Event_Pitch_Relative *pitch_event = new Event_Pitch_Relative;
	
	        modifier=data->variables.tempo*p_time_amount*amount;
		modifier=modifier/((float)time_divisor/100.0);
	
		if (slide_down) modifier=0-modifier; //slide down
	
		pitch_event->set_pitch_displacement(modifier);		

		queue->push(p_time_offset,track,column,pitch_event);
	}

};

class Effect_Pitch_Slide_Up : public Effect_Pitch_Slide {
public:

	Effect_Pitch_Slide_Up() {

		slide_down=false;
	}
};

class Effect_Pitch_Slide_Down : public Effect_Pitch_Slide {
public:

	Effect_Pitch_Slide_Down() {

		slide_down=true;
	}
};

class Effect_Pitch_Vibrato : public Effect_Vibrato  {

	void set_value(int p_time_offset,int p_value) {

		Event_Pitch_Virtual *pitch_event = new Event_Pitch_Virtual;

		pitch_event->set_pitch(p_value);		
	
		queue->push(p_time_offset,track,column,pitch_event);
	}
};

class Effect_Tone_Portamento : public Effect  {

	int dest_pitch;

public:

	void notify_command(Uint8 p_parameter) {

		if (p_parameter!=0) parameter=p_parameter;		
	}
	
	int notify_begin(Uint8 p_note,Uint8 p_volume,Uint8 p_old_note) {
		
		if (p_note>127) return PROCESS_NOTE|PROCESS_COMMAND;

		if (p_old_note<128) {		

			dest_pitch=data->get_pitch_from_note(p_note-p_old_note,data->song->get_instrument(track)->midi.PBS.get());

			if (p_volume!=Note::CLEAR) {

				//Event_Volume *vol_event = new Event_Volume;
				//vol_event->set_volume(p_volume);						
				//queue->push(data->variables.processing_offset,track,column,vol_event);
			}

			return PROCESS_COMMAND;
		} else {

			dest_pitch=-1;
			return PROCESS_NOTE;
		}
	}

       	void process(int p_time_amount,int p_time_offset) {

	        float modifier;
		Event_Pitch_Relative *pitch_event = new Event_Pitch_Relative;

                modifier=data->variables.tempo*p_time_amount*parameter;
		modifier=modifier/((float)time_divisor/25.0);
		pitch_event->set_pitch_displacement(modifier);		
		pitch_event->set_seek(dest_pitch);

		queue->push(p_time_offset,track,column,pitch_event);

	}

        Effect_Tone_Portamento() {
		processing=true;
	}
};

#endif
