
/*
 * Copyright (c) 1999-2006, Regents of the University of California
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 *  Redistributions of source code must retain the above copyright
 *  notice, this list of conditions and the following disclaimer.
 * 
 *  Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 * 
 *  Neither the name of the University of California, Berkeley nor the
 *  names of its contributors may be used to endorse or promote products
 *  derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * Automatically generated library file asys

 * The drivers embedded in this file may be covered by a different
 * license.  Scroll down to see the license appearing before each
 * driver, or see sfront/src/lib/ directories for driver source file.

 */

#include "tree.h"



void makeaif(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: aiff audio driver for sfront";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             aif file audio driver for sfront                 */ ";
  z[lc++]="/*                  reads/writes AIFF files                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="        ";
  z[lc++]="#include <stdio.h>";
  z[lc++]="#include <string.h>";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/* default name for output audio file */";
  z[lc++]="#define ASYSO_DEFAULTNAME \"output.aif\"";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asyso_ */";
  z[lc++]="";
  z[lc++]="FILE * asyso_fd;     /* output file pointer */";
  z[lc++]="char * asyso_name;   /* name of file  */        ";
  z[lc++]="int asyso_srate;     /* sampling rate */";
  z[lc++]="int asyso_channels;  /* number of channels */";
  z[lc++]="int asyso_size;      /* number of samples in a buffer */";
  z[lc++]="int asyso_nsamp;     /* total number of shorts written */";
  z[lc++]="int asyso_bps;       /* number of bytes per sample, 1-3 */";
  z[lc++]="int asyso_doswap;    /* needs byteswap on write */";
  z[lc++]="float * asyso_buf;   /* output floats from sfront */ ";
  z[lc++]="unsigned char * asyso_cbuf;  /* output chars to file */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* default name for input audio file */";
  z[lc++]="";
  z[lc++]="#define ASYSI_DEFAULTNAME \"input.aif\"";
  z[lc++]="";
  z[lc++]="/* only used for asysi_soundtypecheck */";
  z[lc++]="";
  z[lc++]="#define ASYSI_MATCH  0";
  z[lc++]="#define ASYSI_EOF 1";
  z[lc++]="#define ASYSI_NOMATCH 2";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asysi_ */";
  z[lc++]="";
  z[lc++]="FILE * asysi_fd;     /* input file pointer */";
  z[lc++]="char * asysi_name;   /* name of file  */        ";
  z[lc++]="int asysi_srate;     /* sampling rate */";
  z[lc++]="int asysi_channels;  /* number of channels */";
  z[lc++]="int asysi_nsamp;     /* total number of shorts read */";
  z[lc++]="int asysi_bytes;     /* number of bytes in a buffer */";
  z[lc++]="int asysi_bps;       /* number of bytes per sample, 1-3 */";
  z[lc++]="int asysi_doswap;    /* needs byteswap on read */";
  z[lc++]="unsigned char * asysi_cbuf;  /* buffer of AIFF file bytes */";
  z[lc++]="float * asysi_buf;   /* float buffer for sfront */ ";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*            writes next block of AIFF bytes            */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_putbytes(unsigned char * c, int numbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (rwrite(c, sizeof(char), numbytes, asyso_fd) != numbytes)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*        writes unsigned int to an AIFF file            */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_putint(unsigned int val, int numbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char c[4];";
  z[lc++]="";
  z[lc++]="  if (numbytes > 4)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  switch (numbytes) {";
  z[lc++]="  case 4:";
  z[lc++]="    c[3] = (unsigned char) (val&0x000000FF);";
  z[lc++]="    c[2] = (unsigned char)((val >> 8)&0x000000FF);";
  z[lc++]="    c[1] = (unsigned char)((val >> 16)&0x000000FF);";
  z[lc++]="    c[0] = (unsigned char)((val >> 24)&0x000000FF);";
  z[lc++]="    return asyso_putbytes(c, 4);";
  z[lc++]="  case 3:";
  z[lc++]="    c[2] = (unsigned char) (val&0x000000FF);";
  z[lc++]="    c[1] = (unsigned char)((val >> 8)&0x000000FF);";
  z[lc++]="    c[0] = (unsigned char)((val >> 16)&0x000000FF);";
  z[lc++]="    return asyso_putbytes(c, 3);";
  z[lc++]="  case 2:";
  z[lc++]="    c[1] = (unsigned char) (val&0x000000FF);";
  z[lc++]="    c[0] = (unsigned char)((val >> 8)&0x000000FF);";
  z[lc++]="    return asyso_putbytes(c, 2);";
  z[lc++]="  case 1:";
  z[lc++]="    c[0] = (unsigned char) (val&0x000000FF);";
  z[lc++]="    return asyso_putbytes(c,1);";
  z[lc++]="  default:";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio output setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_setup(int srate, int ochannels, int osize, char * name)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  short swaptest = 0x0001;";
  z[lc++]="  int e;";
  z[lc++]="  unsigned int m;";
  z[lc++]="  unsigned char c[10];";
  z[lc++]="  char * val;";
  z[lc++]="";
  z[lc++]="  asyso_doswap = *((char *)&swaptest);";
  z[lc++]="  if (name == NULL)";
  z[lc++]="    val = ASYSO_DEFAULTNAME;";
  z[lc++]="  else";
  z[lc++]="    val = name;";
  z[lc++]="";
  z[lc++]="  switch (ASYS_OUTFILE_WORDSIZE) {";
  z[lc++]="  case ASYS_OUTFILE_WORDSIZE_8BIT: ";
  z[lc++]="    asyso_bps = 1;";
  z[lc++]="    break;";
  z[lc++]="  case ASYS_OUTFILE_WORDSIZE_16BIT:";
  z[lc++]="    asyso_bps = 2;";
  z[lc++]="    break;";
  z[lc++]="  case ASYS_OUTFILE_WORDSIZE_24BIT:";
  z[lc++]="    asyso_bps = 3;";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  asyso_name = strcpy((char *) calloc((strlen(val)+1),sizeof(char)), val);";
  z[lc++]="  asyso_fd = fopen(asyso_name,\"wb\");";
  z[lc++]="  if (asyso_fd == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  /* preamble for wav file */";
  z[lc++]="";
  z[lc++]="  asyso_putbytes((unsigned char *) \"FORM\",4);";
  z[lc++]="  asyso_putint(0,4);       /* length, patched later */";
  z[lc++]="  asyso_putbytes((unsigned char *) \"AIFFCOMM\",8);";
  z[lc++]="  asyso_putint(18,4);                 /* 18 bytes */";
  z[lc++]="  asyso_putint(ochannels,2);          /* number of channels */";
  z[lc++]="  asyso_putint(0,4);                  /* frames, patched later */";
  z[lc++]="  asyso_putint(8*asyso_bps, 2);       /* bits per sample */";
  z[lc++]="  m = (unsigned int)floor(ldexp(frexp((double)srate, &e),32));";
  z[lc++]="  e += 16382;";
  z[lc++]="  c[0] = e >> 8;";
  z[lc++]="  c[1] = e;";
  z[lc++]="  c[2] = m >> 24;";
  z[lc++]="  c[3] = m >> 16;";
  z[lc++]="  c[4] = m >> 8;";
  z[lc++]="  c[5] = m;";
  z[lc++]="  c[6] = c[7] = c[8] = c[9] = 0;";
  z[lc++]="  asyso_putbytes((unsigned char *)&c[0],10); /* srate */";
  z[lc++]="  asyso_putbytes((unsigned char *) \"SSND\",4);";
  z[lc++]="  asyso_putint(0,4);       /* length, patched later */";
  z[lc++]="  asyso_putint(0,4);       /* offset = 0 */           ";
  z[lc++]="  asyso_putint(0,4);       /* block size */           ";
  z[lc++]="";
  z[lc++]="  asyso_srate = srate;";
  z[lc++]="  asyso_channels = ochannels;";
  z[lc++]="  asyso_size = osize;";
  z[lc++]="  asyso_nsamp = 0;";
  z[lc++]="  asyso_cbuf = (unsigned char *) malloc(osize*asyso_bps);";
  z[lc++]="";
  z[lc++]="  if (asyso_cbuf == NULL)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Can't allocate AIFF byte output buffer (%s).\\n\",";
  z[lc++]="	      strerror(errno));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  asyso_buf = (float *)calloc(osize, sizeof(float));";
  z[lc++]="";
  z[lc++]="  if (asyso_buf == NULL)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Can't allocate AIFF float output buffer (%s).\\n\",";
  z[lc++]="	      strerror(errno));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*           gets next block of AIFF bytes               */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_getbytes(unsigned char * c, int numbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if ((int)rread(c, sizeof(char), numbytes, asysi_fd) != numbytes)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*       flushes next block of AIFF bytes                */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_flushbytes(int numbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char c;";
  z[lc++]="";
  z[lc++]="  while (numbytes > 0)";
  z[lc++]="    {";
  z[lc++]="      if (rread(&c, sizeof(char), 1, asysi_fd) != 1)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="      numbytes--;";
  z[lc++]="    }";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*     converts byte stream to an unsigned int           */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_getint(int numbytes,  unsigned int * ret)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char c[4];";
  z[lc++]="";
  z[lc++]="  if (numbytes > 4)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (ASYS_DONE != asysi_getbytes(&c[0],numbytes))";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  switch (numbytes) {";
  z[lc++]="  case 4:";
  z[lc++]="    *ret  =  (unsigned int)c[3];";
  z[lc++]="    *ret |=  (unsigned int)c[2] << 8;";
  z[lc++]="    *ret |=  (unsigned int)c[1] << 16;";
  z[lc++]="    *ret |=  (unsigned int)c[0] << 24;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 3:";
  z[lc++]="    *ret  =  (unsigned int)c[2];";
  z[lc++]="    *ret |=  (unsigned int)c[1] << 8;";
  z[lc++]="    *ret |=  (unsigned int)c[0] << 16;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 2:";
  z[lc++]="    *ret  =  (unsigned int)c[1];";
  z[lc++]="    *ret |=  (unsigned int)c[0] << 8;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 1:";
  z[lc++]="    *ret = (unsigned int)c[0];";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  default:";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="    ";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*         converts byte stream to an int                */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_getsint(int numbytes, int * ret)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char c[4];";
  z[lc++]="";
  z[lc++]="  if (numbytes > 4)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (ASYS_DONE != asysi_getbytes(&c[0],numbytes))";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  switch (numbytes) {";
  z[lc++]="  case 4:";
  z[lc++]="    *ret  =  (int)c[3];";
  z[lc++]="    *ret |=  (int)c[2] << 8;";
  z[lc++]="    *ret |=  (int)c[1] << 16;";
  z[lc++]="    *ret |=  (int)c[0] << 24;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 3:";
  z[lc++]="    *ret  =  (int)c[2];";
  z[lc++]="    *ret |=  (int)c[1] << 8;";
  z[lc++]="    *ret |=  (int)c[0] << 16;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 2:";
  z[lc++]="    *ret  =  (int)c[1];";
  z[lc++]="    *ret |=  (int)c[0] << 8;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 1:";
  z[lc++]="    *ret = (int)c[0];";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  default:";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="    ";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*  checks byte stream for AIFF cookie --                 */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_soundtypecheck(char * d)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char c[4];";
  z[lc++]="";
  z[lc++]="  if (rread(c, sizeof(char), 4, asysi_fd) != 4)";
  z[lc++]="    return ASYSI_EOF;";
  z[lc++]="  if (strncmp(c,d,4))";
  z[lc++]="    return ASYSI_NOMATCH;";
  z[lc++]="  return ASYSI_MATCH;";
  z[lc++]="}";
  z[lc++]="  ";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio input setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_setup(int srate, int ichannels, int isize, char * name)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  short swaptest = 0x0001;";
  z[lc++]="  unsigned int i, m, commlen;";
  z[lc++]="  int e, len;";
  z[lc++]="  unsigned char c[4];";
  z[lc++]="  char * val;";
  z[lc++]="";
  z[lc++]="  asysi_doswap = *((char *)&swaptest);";
  z[lc++]="  if (name == NULL)";
  z[lc++]="    val = ASYSI_DEFAULTNAME;";
  z[lc++]="  else";
  z[lc++]="    val = name;";
  z[lc++]="  asysi_name = strcpy((char *) calloc((strlen(val)+1),sizeof(char)), val);";
  z[lc++]="  asysi_fd = fopen(asysi_name,\"rb\");";
  z[lc++]="";
  z[lc++]="  if (asysi_fd == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (asysi_soundtypecheck(\"FORM\")!= ASYSI_MATCH)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (asysi_flushbytes(4)!= ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (asysi_soundtypecheck(\"AIFF\")!= ASYSI_MATCH)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (asysi_getbytes(&c[0],4)!= ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  while (strncmp((char *) c,\"SSND\",4))";
  z[lc++]="    {";
  z[lc++]="      if (strncmp((char *) c,\"COMM\",4))";
  z[lc++]="	{";
  z[lc++]="	  if (asysi_getint(4, &i) != ASYS_DONE)";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  if (asysi_flushbytes(i + (i % 2))!= ASYS_DONE)";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  if (asysi_getint(4, &commlen) != ASYS_DONE)";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  if (asysi_getint(2, &i) != ASYS_DONE)";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  if (i != ichannels)";
  z[lc++]="	    {";
  z[lc++]="	      fprintf(stderr,\"Error: Inchannels doesn't match AIFF file\\n\");";
  z[lc++]="	      return ASYS_ERROR;";
  z[lc++]="	    }";
  z[lc++]="	  if (asysi_flushbytes(4)!= ASYS_DONE) /* frames */";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  if (asysi_getint(2, &i) != ASYS_DONE)";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  if ((i < 8) || (i > 24))";
  z[lc++]="	    {";
  z[lc++]="	      fprintf(stderr,\"Error: Can't handle %i bit data\\n\",i);";
  z[lc++]="	      return ASYS_ERROR;";
  z[lc++]="	    }";
  z[lc++]="	  asysi_bps = i/8;";
  z[lc++]="	  if (asysi_getsint(2, &e) != ASYS_DONE)";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  if (asysi_getint(4, &m) != ASYS_DONE)";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  if (asysi_flushbytes(4)!= ASYS_DONE) /* unneeded precision */";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  i = (unsigned int)(0.5+(m*exp(log(2)*(e - 16414.0F))));";
  z[lc++]="	  if (srate != i)";
  z[lc++]="	    fprintf(stderr,\"Warning: SAOL srate %i mismatches AIFF file srate %i\\n\",";
  z[lc++]="		    srate, i);";
  z[lc++]="	  if (commlen > 18)";
  z[lc++]="	    if (asysi_flushbytes(commlen - 18 + (commlen % 2))!= ASYS_DONE) ";
  z[lc++]="	      return ASYS_ERROR;";
  z[lc++]="	}";
  z[lc++]="      if (asysi_getbytes(&c[0],4)!= ASYS_DONE)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  if (asysi_getint(4, &i) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (asysi_flushbytes(8)!= ASYS_DONE) ";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  asysi_nsamp = (i - 8)/asysi_bps;";
  z[lc++]="  asysi_srate = srate;";
  z[lc++]="  asysi_channels = ichannels;";
  z[lc++]="  asysi_bytes = isize*asysi_bps;";
  z[lc++]="  asysi_cbuf = (unsigned char *) malloc(asysi_bytes);";
  z[lc++]="";
  z[lc++]="  if (asysi_cbuf == NULL)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Can't allocate AIFF input byte buffer (%s).\\n\",";
  z[lc++]="	      strerror(errno));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  asysi_buf = (float *) malloc(sizeof(float)*isize);";
  z[lc++]="";
  z[lc++]="  if (asysi_buf == NULL)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Can't allocate AIFF input float buffer (%s).\\n\",";
  z[lc++]="	      strerror(errno));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(int srate, int ochannels, int osample, ";
  z[lc++]="		char * oname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*EV(ACYCLE), oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(int srate, int ichannels, int isample, ";
  z[lc++]="		char * iname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asysi_setup(srate, ichannels, ASYS_ICHAN*EV(ACYCLE), iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(int srate, int ichannels, int ochannels,";
  z[lc++]="		 int isample, int osample, ";
  z[lc++]="		 char * iname, char * oname, int toption)";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (asysi_setup(srate, ichannels, ASYS_ICHAN*EV(ACYCLE), iname) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*EV(ACYCLE), oname);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             shuts down audio output system                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asyso_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  fseek(asyso_fd, 4, SEEK_SET);";
  z[lc++]="  asyso_putint(asyso_bps*asyso_nsamp+46, 4);";
  z[lc++]="  fseek(asyso_fd, 22, SEEK_SET); /* bugfix by Richard Dobson */";
  z[lc++]="  asyso_putint(asyso_nsamp/asyso_channels, 4);";
  z[lc++]="  fseek(asyso_fd, 16, SEEK_CUR);";
  z[lc++]="  asyso_putint(8 + asyso_bps*asyso_nsamp, 4);";
  z[lc++]="  fclose(asyso_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               shuts down audio input system                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysi_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  fclose(asysi_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float * buf = *asys_obuf;";
  z[lc++]="  float fval;";
  z[lc++]="  int val;";
  z[lc++]="  int i = 0;";
  z[lc++]="  int j = 0;";
  z[lc++]="";
  z[lc++]="  switch (asyso_bps) {";
  z[lc++]="  case 3:";
  z[lc++]="    while (i < *osize)";
  z[lc++]="      {";
  z[lc++]="	fval = ((float)(pow(2, 23) - 1))*buf[i++];";
  z[lc++]="	val = (int)((fval >= 0.0F) ? (fval + 0.5F) : (fval - 0.5F));";
  z[lc++]="	asyso_cbuf[j++] = (unsigned char)((val >> 16) & 0x000000FF);";
  z[lc++]="	asyso_cbuf[j++] = (unsigned char)((val >> 8) & 0x000000FF);";
  z[lc++]="	asyso_cbuf[j++] = (unsigned char) (val & 0x000000FF);";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  case 2:";
  z[lc++]="    while (i < *osize)";
  z[lc++]="      {";
  z[lc++]="	fval = ((float)(pow(2, 15) - 1))*buf[i++];";
  z[lc++]="	val = (int)((fval >= 0.0F) ? (fval + 0.5F) : (fval - 0.5F));";
  z[lc++]="	asyso_cbuf[j++] = (unsigned char)((val >> 8) & 0x000000FF);";
  z[lc++]="	asyso_cbuf[j++] = (unsigned char) (val & 0x000000FF);";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  case 1:";
  z[lc++]="    while (i < *osize)";
  z[lc++]="      {";
  z[lc++]="	fval = ((float)(pow(2, 7) - 1))*buf[i++];";
  z[lc++]="	asyso_cbuf[j++] = (unsigned char)";
  z[lc++]="	  (((char)((fval >= 0.0F) ? (fval + 0.5F) : (fval - 0.5F))));";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  if (rwrite(asyso_cbuf, sizeof(char), j, asyso_fd) != j)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  asyso_nsamp += *osize;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               get one frame of audio from input              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], int * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i = 0;";
  z[lc++]="  int j = 0;";
  z[lc++]="";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    *asys_ibuf = asysi_buf;";
  z[lc++]="  ";
  z[lc++]="  if (asysi_nsamp <= 0)";
  z[lc++]="    {";
  z[lc++]="      *isize = 0;";
  z[lc++]="      return ASYS_DONE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  *isize = (int)rread(asysi_cbuf, sizeof(unsigned char), asysi_bytes, asysi_fd);";
  z[lc++]="";
  z[lc++]="  switch (asysi_bps) {";
  z[lc++]="  case 1:                              /* 8-bit  */";
  z[lc++]="    while (i < *isize)";
  z[lc++]="      {";
  z[lc++]="	asysi_buf[i] = ((float)pow(2, -7))*((signed char) asysi_cbuf[i]);";
  z[lc++]="	i++;";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  case 2:                              /* 9-16 bit */";
  z[lc++]="    *isize = (*isize) / 2;";
  z[lc++]="    while (i < *isize)";
  z[lc++]="      {";
  z[lc++]="	asysi_buf[i] = ((float)pow(2, -15))*((int)(asysi_cbuf[j+1]) + ";
  z[lc++]="				    (((int)((char)(asysi_cbuf[j]))) << 8)); ";
  z[lc++]="	i++;";
  z[lc++]="	j += 2;";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  case 3:                            /* 17-24 bit */";
  z[lc++]="    *isize = (*isize) / 3;";
  z[lc++]="    while (i < *isize)";
  z[lc++]="      {";
  z[lc++]="	asysi_buf[i] = ((float)pow(2, -23))*((int)(asysi_cbuf[j+2]) + ";
  z[lc++]="				    (((int)(asysi_cbuf[j+1])) << 8) + ";
  z[lc++]="				    (((int)((char) asysi_cbuf[j])) << 16));";
  z[lc++]="	i++; ";
  z[lc++]="	j += 3;";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  } ";
  z[lc++]="";
  z[lc++]="  asysi_nsamp -= *isize;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  printlib(lc);
}


void makehpux(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: hpux audio driver for sfront";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             HPUX/9.0 audio driver for sfront                 */ ";
  z[lc++]="/*                                                              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="        ";
  z[lc++]="#include <fcntl.h>";
  z[lc++]="#include <sys/socket.h>";
  z[lc++]="#include <audio/Alib.h>";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/* global variables for HPUX audio output */";
  z[lc++]="";
  z[lc++]="Audio *asyso_a;                  /* audio ptr                     */";
  z[lc++]="ATransID asyso_x;                /* audio stream                  */";
  z[lc++]="int asyso_s;                    /* socket for audio stream       */";
  z[lc++]="int asyso_pflag;                /* flag for hardware head start  */";
  z[lc++]="int asyso_pidx;                 /* number of bytes of head start */";
  z[lc++]="int asyso_size;                 /* number of shorts in a buffer  */";
  z[lc++]="short * asyso_buf;               /* location for output buffer    */";
  z[lc++]=" ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="Audio    *asysi_a;      /* audio ptr                     */";
  z[lc++]="ATransID asysi_x;       /* audio stream                  */";
  z[lc++]="int     asysi_s;       /* socket for audio stream       */";
  z[lc++]="int     asysi_size;    /* number of shorts in a buffer  */";
  z[lc++]="short    *asysi_buf;    /* location for output buffer    */";
  z[lc++]="fd_set   asysi_selFD;   /* select file descriptor        */";
  z[lc++]="fd_set   asysi_redFD;   /* ready file descriptor         */";
  z[lc++]="int     asysi_stdFD;   /* stdin file descriptor         */";
  z[lc++]="int     asysi_maxFD;   /* max-numbered file descriptor  */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio system for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_setup(int srate, int ochannels, int osize, char * oname,";
  z[lc++]="		int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  AudioAttributes aa;";
  z[lc++]="  SSPlayParams sp;    ";
  z[lc++]="  SStream as; ";
  z[lc++]="  AGainEntry g[2];";
  z[lc++]="";
  z[lc++]="  asyso_size = osize;";
  z[lc++]="  asyso_buf = (short *)calloc(osize, sizeof(short));";
  z[lc++]="";
  z[lc++]="  asyso_a = AOpenAudio(\"\", NULL);";
  z[lc++]="  aa = *ABestAudioAttributes(asyso_a);";
  z[lc++]="";
  z[lc++]="  aa.attr.sampled_attr.data_format = ADFLin16;";
  z[lc++]="  aa.attr.sampled_attr.bits_per_sample = 16;";
  z[lc++]="  aa.attr.sampled_attr.sampling_rate = srate;";
  z[lc++]="  aa.attr.sampled_attr.channels = ochannels;";
  z[lc++]="  aa.attr.sampled_attr.interleave = 1;";
  z[lc++]="  aa.attr.sampled_attr.duration.type = ATTFullLength;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  if (ochannels > 2)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (ochannels == 1)";
  z[lc++]="    {";
  z[lc++]="      g[0].gain = AUnityGain;";
  z[lc++]="      g[0].u.o.out_ch = AOCTMono;";
  z[lc++]="      g[0].u.o.out_dst = AODTMonoJack;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      g[0].gain = g[1].gain = AUnityGain;";
  z[lc++]="      g[0].u.o.out_ch = AOCTLeft;";
  z[lc++]="      g[1].u.o.out_ch = AOCTRight;";
  z[lc++]="      g[0].u.o.out_dst = AODTLeftLineOut;";
  z[lc++]="      g[1].u.o.out_dst = AODTRightLineOut;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  sp.gain_matrix.type = AGMTOutput;";
  z[lc++]="  sp.gain_matrix.num_entries = ochannels;";
  z[lc++]="  sp.gain_matrix.gain_entries = g;";
  z[lc++]="  sp.play_volume = AUnityGain;   ";
  z[lc++]="";
  z[lc++]="  if (toption == ASYS_RENDER)";
  z[lc++]="    sp.priority = APriorityHigh; ";
  z[lc++]="  else";
  z[lc++]="    sp.priority = APriorityUrgent; ";
  z[lc++]="";
  z[lc++]="  sp.event_mask = 0;             ";
  z[lc++]="";
  z[lc++]="  asyso_x = APlaySStream(asyso_a, ~0, &aa, &sp , &as, NULL);";
  z[lc++]="  if ((asyso_s = socket(AF_INET, SOCK_STREAM, 0)) < 0)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (connect(asyso_s, (struct sockaddr *)&as.tcp_sockaddr,";
  z[lc++]="		   sizeof(struct sockaddr_in)) < 0)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (toption == ASYS_RENDER)";
  z[lc++]="    {";
  z[lc++]="      asyso_pidx = 3 * 2 * ochannels * srate;";
  z[lc++]="      asyso_pflag = 1;";
  z[lc++]="      APauseAudio(asyso_a, asyso_x, NULL, NULL);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    asyso_pflag = asyso_pidx = 0;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              initializes audio input                         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_setup(int srate, int ichannels, int isize, char * iname)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  AudioAttributes rr;";
  z[lc++]="  SStream sr;";
  z[lc++]="  SSRecordParams  asr;";
  z[lc++]="  AGainEntry g[2];";
  z[lc++]="";
  z[lc++]="  asysi_size = isize;";
  z[lc++]="  asysi_buf = (short *)malloc(sizeof(short)*isize);";
  z[lc++]="";
  z[lc++]="  asysi_a = AOpenAudio(\"\", NULL);";
  z[lc++]="  rr = *aBestAudioAttributes(asysi_a);   ";
  z[lc++]="";
  z[lc++]="  rr.attr.sampled_attr.data_format = ADFLin16;";
  z[lc++]="  rr.attr.sampled_attr.bits_per_sample = 16;";
  z[lc++]="  rr.attr.sampled_attr.sampling_rate = srate;";
  z[lc++]="  rr.attr.sampled_attr.channels = ichannels;";
  z[lc++]="  rr.attr.sampled_attr.interleave = 1;";
  z[lc++]="";
  z[lc++]="  if (ichannels > 2)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (ichannels == 1)";
  z[lc++]="    {";
  z[lc++]="      g[0].u.i.in_ch = AICTMono;";
  z[lc++]="      g[0].gain = AUnityGain;";
  z[lc++]="      g[0].u.i.in_src = AISTMonoAuxiliary;";
  z[lc++]="      g[0].u.i.in_src = AISTMonoMicrophone;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      g[0].u.i.in_ch = AICTLeft;";
  z[lc++]="      g[0].gain = AUnityGain;";
  z[lc++]="      g[0].u.i.in_src = AISTLeftAuxiliary;";
  z[lc++]="      g[0].u.i.in_src = AISTLeftMicrophone;";
  z[lc++]="      g[1].u.i.in_ch = AICTRight;";
  z[lc++]="      g[1].gain = AUnityGain;";
  z[lc++]="      g[1].u.i.in_src = AISTRightAuxiliary;";
  z[lc++]="      g[1].u.i.in_src = AISTRightMicrophone;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  asr.gain_matrix.type = AGMTInput;";
  z[lc++]="  asr.gain_matrix.num_entries = ichannels;";
  z[lc++]="  asr.gain_matrix.gain_entries = g;";
  z[lc++]="  asr.record_gain = AUnityGain;  ";
  z[lc++]="  asr.event_mask = 0;";
  z[lc++]="";
  z[lc++]="  if ((asysi_s = socket( AF_INET, SOCK_STREAM, 0 )) < 0)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  asysi_x = ARecordSStream(asysi_a, ~0, &rr, &asr,";
  z[lc++]="			&sr, NULL );";
  z[lc++]="  if (connect(asysi_s,(struct sockaddr *)&sr.tcp_sockaddr,";
  z[lc++]="		   sizeof(struct sockaddr_in)) < 0)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  asysi_maxFD = asysi_stdFD = fileno(stdin);";
  z[lc++]="  if (asysi_s > asysi_maxFD)";
  z[lc++]="    asysi_maxFD = asysi_s;";
  z[lc++]="  FD_ZERO(&asysi_redFD);";
  z[lc++]="  FD_ZERO(&asysi_selFD);";
  z[lc++]="  FD_SET(asysi_stdFD, &asysi_selFD);";
  z[lc++]="  FD_SET(asysi_s, &asysi_selFD);";
  z[lc++]="  ";
  z[lc++]="  fprintf(stderr, \"Hit RETURN to stop recording\\n\" );";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              initializes audio input                         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(int srate, int ichannels, int isample, ";
  z[lc++]="                char * iname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio system for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(int srate, int ochannels, int osample, ";
  z[lc++]="                char * oname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*ACYCLE, oname, toption);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif ";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        initializes bidirectional audio flows                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(int srate, int ichannels, int ochannels,";
  z[lc++]="                 int isample, int osample, ";
  z[lc++]="                 char * iname, char * oname, int toption)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asyso_setup(srate, ochannels, osize, ASYS_OCHAN*ACYCLE, ";
  z[lc++]="		  toption) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              core routine -- shuts down audio input device   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysi_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  close(asysi_s);";
  z[lc++]="  ACloseAudio(asysi_a, NULL);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*            core routine -- shuts down audio output           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asyso_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asyso_pflag) ";
  z[lc++]="    AResumeAudio(asyso_a, asyso_x, NULL, NULL);";
  z[lc++]="  close(asyso_s);";
  z[lc++]="  ASetCloseDownMode(asyso_a, AKeepTransactions, NULL);";
  z[lc++]="  ACloseAudio(asyso_a, NULL);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="  ";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int bsize, bwrite;";
  z[lc++]="  char * buf;";
  z[lc++]="";
  z[lc++]="  bsize = 2*(*osize);";
  z[lc++]="  buf = (char *)(asyso_buf);";
  z[lc++]="  while (bsize) ";
  z[lc++]="    {";
  z[lc++]="      if ((bwrite = write(asyso_s, buf, bsize )) < 0)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="      buf += bwrite;";
  z[lc++]="      bsize -= bwrite;";
  z[lc++]="      if ((asyso_pflag)&&(((asyso_pidx -= bwrite) <= 0)||(bwrite == 0)))";
  z[lc++]="	{";
  z[lc++]="	  AResumeAudio(asyso_a, asyso_x, NULL, NULL);";
  z[lc++]="	  asyso_pflag = 0;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               gets one frame of audio from input             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], int * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    {";
  z[lc++]="      *asys_ibuf = asysi_buf;";
  z[lc++]="      *isize = asysi_size;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((*isize) == 0)";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="  while (1)";
  z[lc++]="    {";
  z[lc++]="      asysi_redFD = asysi_selFD;";
  z[lc++]="";
  z[lc++]="      if (select(asysi_maxFD + 1, (int *)&asysi_redFD, (int *)NULL,";
  z[lc++]="		      (int *)NULL, NULL) < 0)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="    ";
  z[lc++]="      if (FD_ISSET(asysi_s, &asysi_redFD))";
  z[lc++]="	{";
  z[lc++]="	  *isize = read(asysi_s, (char *) asysi_buf, 2*asysi_size);";
  z[lc++]="	  *isize = (*isize)/2;";
  z[lc++]="	  if (*isize < 0)";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  else";
  z[lc++]="	    return ASYS_DONE;";
  z[lc++]="	}";
  z[lc++]="    ";
  z[lc++]="      if (FD_ISSET(asysi_stdFD, &asysi_redFD)) ";
  z[lc++]="	{";
  z[lc++]="	  FD_CLR(asysi_stdFD, &asysi_selFD);";
  z[lc++]="	  AStopAudio(asysi_a, asysi_x, ASMThisTrans,";
  z[lc++]="		     (ATransStatus *)NULL, NULL);";
  z[lc++]="	  *isize = 0;";
  z[lc++]="	  return ASYS_DONE;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void makeraw(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: raw audio driver for sfront";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             raw file audio driver for sfront                 */ ";
  z[lc++]="/*       reads/writes 16-bit signed shorts in native format     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="        ";
  z[lc++]="#include <stdio.h>";
  z[lc++]="#include <string.h>";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/* default name for output audio file */";
  z[lc++]="#define ASYSO_DEFAULTNAME \"output\"";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asyso_ */";
  z[lc++]="";
  z[lc++]="FILE * asyso_fd;     /* output file pointer */";
  z[lc++]="char * asyso_name;   /* name of file  */        ";
  z[lc++]="int asyso_srate;    /* sampling rate */";
  z[lc++]="int asyso_channels; /* number of channels */";
  z[lc++]="int asyso_size;    /* number of samples in a buffer */";
  z[lc++]="int asyso_nsamp;    /* total number of samples written */";
  z[lc++]="short * asyso_buf;   /* location for output buffer */ ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* default name for output audio file */";
  z[lc++]="#define ASYSI_DEFAULTNAME \"input\"";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asysi_ */";
  z[lc++]="";
  z[lc++]="FILE * asysi_fd;     /* input file pointer */";
  z[lc++]="char * asysi_name;   /* name of file  */        ";
  z[lc++]="int asysi_srate;    /* sampling rate */";
  z[lc++]="int asysi_channels; /* number of channels */";
  z[lc++]="int asysi_size;    /* number of samples in a buffer */";
  z[lc++]="int asysi_nsamp;    /* total number of samples written */";
  z[lc++]="short * asysi_buf;   /* location for input buffer */ ";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio output setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_setup(int srate, int ochannels, int osize, char * name)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char * val;";
  z[lc++]="";
  z[lc++]="  if (name == NULL)";
  z[lc++]="    val = ASYSO_DEFAULTNAME;";
  z[lc++]="  else";
  z[lc++]="    val = name;";
  z[lc++]="  asyso_name = strcpy((char *) calloc((strlen(val)+1),sizeof(char)), val);";
  z[lc++]="  asyso_fd = fopen(asyso_name,\"wb\");";
  z[lc++]="  if (asyso_fd == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  asyso_srate = srate;";
  z[lc++]="  asyso_channels = ochannels;";
  z[lc++]="  asyso_size = osize;";
  z[lc++]="  asyso_nsamp = 0;";
  z[lc++]="  asyso_buf = (short *)calloc(osize, sizeof(short));";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio input setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_setup(int srate, int ichannels, int isize, char * name)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char * val;";
  z[lc++]="";
  z[lc++]="  if (name == NULL)";
  z[lc++]="    val = ASYSI_DEFAULTNAME;";
  z[lc++]="  else";
  z[lc++]="    val = name;";
  z[lc++]="  asysi_name = strcpy((char *) calloc((strlen(val)+1),sizeof(char)), val);";
  z[lc++]="  asysi_fd = fopen(asysi_name,\"rb\");";
  z[lc++]="  if (asysi_fd == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  asysi_srate = srate;";
  z[lc++]="  asysi_channels = ichannels;";
  z[lc++]="  asysi_size = isize;";
  z[lc++]="  asysi_nsamp = 0;";
  z[lc++]="  asysi_buf = (short *)malloc(sizeof(short)*isize);";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(int srate, int ochannels, int osample, ";
  z[lc++]="                char * oname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*EV(ACYCLE), oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(int srate, int ichannels, int isample, ";
  z[lc++]="                char * iname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asysi_setup(srate, ichannels, ASYS_ICHAN*EV(ACYCLE), iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(int srate, int ichannels, int ochannels,";
  z[lc++]="                 int isample, int osample, ";
  z[lc++]="                 char * iname, char * oname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (asysi_setup(srate, ichannels, ASYS_ICHAN*EV(ACYCLE), iname) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*EV(ACYCLE), oname);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             shuts down audio output system                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asyso_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char name[1024];";
  z[lc++]="";
  z[lc++]="  fclose(asyso_fd);";
  z[lc++]="  strcpy(name,asyso_name);";
  z[lc++]="  strcat(name,\".info\");";
  z[lc++]="  asyso_fd = fopen(name,\"w\");";
  z[lc++]="  fprintf(asyso_fd,\"%i\\n\",asyso_srate);";
  z[lc++]="  fprintf(asyso_fd,\"%i\\n\",asyso_channels);";
  z[lc++]="  fprintf(asyso_fd,\"%i\\n\",asyso_nsamp);";
  z[lc++]="  fclose(asyso_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               shuts down audio input system                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysi_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char name[1024];";
  z[lc++]="";
  z[lc++]="  fclose(asysi_fd);";
  z[lc++]="  strcpy(name, asysi_name);";
  z[lc++]="  strcat(name,\".info\");";
  z[lc++]="  asysi_fd = fopen(name,\"w\");";
  z[lc++]="  fprintf(asysi_fd,\"%i\\n\", asysi_srate);";
  z[lc++]="  fprintf(asysi_fd,\"%i\\n\", asysi_channels);";
  z[lc++]="  fprintf(asysi_fd,\"%i\\n\", asysi_nsamp);";
  z[lc++]="  fclose(asysi_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="  ";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (rwrite(*asys_obuf, sizeof(short), *osize, asyso_fd) != *osize)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  asyso_nsamp += *osize;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], int * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    *asys_ibuf = asysi_buf;";
  z[lc++]="  *isize = (int)rread(*asys_ibuf, sizeof(short), asysi_size, asysi_fd);";
  z[lc++]="  asysi_nsamp += *isize;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  printlib(lc);
}


void makewav(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: WAV audio driver for sfront";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             wav file audio driver for sfront                 */ ";
  z[lc++]="/****************************************************************/";
  z[lc++]="        ";
  z[lc++]="#include <stdio.h>";
  z[lc++]="#include <string.h>";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/* default name for output audio file */";
  z[lc++]="#define ASYSO_DEFAULTNAME \"output.wav\"";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asyso_ */";
  z[lc++]="";
  z[lc++]="FILE * asyso_fd;     /* output file pointer */";
  z[lc++]="char * asyso_name;   /* name of file  */        ";
  z[lc++]="int asyso_srate;    /* sampling rate */";
  z[lc++]="int asyso_channels; /* number of channels */";
  z[lc++]="int asyso_size;     /* number of float samples _buf */";
  z[lc++]="int asyso_nsamp;    /* total number of samples written */";
  z[lc++]="int asyso_bps;      /* number of bytes per sample, 1-3 */";
  z[lc++]="int asyso_doswap;   /* needs byteswap on write */";
  z[lc++]="float * asyso_buf;   /* output floats from sfront */ ";
  z[lc++]="unsigned char * asyso_cbuf;  /* output chars to file */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* default name for input audio file */";
  z[lc++]="";
  z[lc++]="#define ASYSI_DEFAULTNAME \"input.wav\"";
  z[lc++]="";
  z[lc++]="/* only used for asysi_soundtypecheck */";
  z[lc++]="";
  z[lc++]="#define ASYSI_MATCH  0";
  z[lc++]="#define ASYSI_EOF 1";
  z[lc++]="#define ASYSI_NOMATCH 2";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asysi_ */";
  z[lc++]="";
  z[lc++]="FILE * asysi_fd;     /* input file pointer */";
  z[lc++]="char * asysi_name;   /* name of file  */        ";
  z[lc++]="int asysi_srate;    /* sampling rate */";
  z[lc++]="int asysi_channels; /* number of channels */";
  z[lc++]="int asysi_bytes;     /* number of bytes in a buffer */";
  z[lc++]="int asysi_nsamp;    /* total number of samples read */";
  z[lc++]="int asysi_bps;      /* number of bytes per sample, 1-3 */";
  z[lc++]="int asysi_doswap;   /* needs byteswap on read */";
  z[lc++]="unsigned char * asysi_cbuf;  /* buffer of WAV file bytes */";
  z[lc++]="float * asysi_buf;   /* float buffer for sfront */ ";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*        writes next block of WAV/AIFF bytes            */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_putbytes(unsigned char * c, int numbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (rwrite(c, sizeof(char), numbytes, asyso_fd) != numbytes)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*        writes unsigned int to a WAV files             */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_putint(unsigned int val, int numbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char c[4];";
  z[lc++]="";
  z[lc++]="  if (numbytes > 4)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  switch (numbytes) {";
  z[lc++]="  case 4:";
  z[lc++]="    c[0] = (unsigned char) (val&0x000000FF);";
  z[lc++]="    c[1] = (unsigned char)((val >> 8)&0x000000FF);";
  z[lc++]="    c[2] = (unsigned char)((val >> 16)&0x000000FF);";
  z[lc++]="    c[3] = (unsigned char)((val >> 24)&0x000000FF);";
  z[lc++]="    return asyso_putbytes(c, 4);";
  z[lc++]="  case 3:";
  z[lc++]="    c[0] = (unsigned char) (val&0x000000FF);";
  z[lc++]="    c[1] = (unsigned char)((val >> 8)&0x000000FF);";
  z[lc++]="    c[2] = (unsigned char)((val >> 16)&0x000000FF);";
  z[lc++]="    return asyso_putbytes(c, 3);";
  z[lc++]="  case 2:";
  z[lc++]="    c[0] = (unsigned char) (val&0x000000FF);";
  z[lc++]="    c[1] = (unsigned char)((val >> 8)&0x000000FF);";
  z[lc++]="    return asyso_putbytes(c, 2);";
  z[lc++]="  case 1:";
  z[lc++]="    c[0] = (unsigned char) (val&0x000000FF);";
  z[lc++]="    return asyso_putbytes(c,1);";
  z[lc++]="  default:";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio output setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_setup(int srate, int ochannels, int osize, char * name)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  short swaptest = 0x0100;";
  z[lc++]="  char * val;";
  z[lc++]="";
  z[lc++]="  asyso_doswap = *((char *)&swaptest);";
  z[lc++]="  if (name == NULL)";
  z[lc++]="    val = ASYSO_DEFAULTNAME;";
  z[lc++]="  else";
  z[lc++]="    val = name;";
  z[lc++]="";
  z[lc++]="  switch (ASYS_OUTFILE_WORDSIZE) {";
  z[lc++]="  case ASYS_OUTFILE_WORDSIZE_8BIT: ";
  z[lc++]="    asyso_bps = 1;";
  z[lc++]="    break;";
  z[lc++]="  case ASYS_OUTFILE_WORDSIZE_16BIT:";
  z[lc++]="    asyso_bps = 2;";
  z[lc++]="    break;";
  z[lc++]="  case ASYS_OUTFILE_WORDSIZE_24BIT:";
  z[lc++]="    asyso_bps = 3;";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  asyso_name = strcpy((char *) calloc((strlen(val)+1),sizeof(char)), val);";
  z[lc++]="  asyso_fd = fopen(asyso_name,\"wb\");";
  z[lc++]="  if (asyso_fd == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  /* preamble for wav file */";
  z[lc++]="";
  z[lc++]="  asyso_putbytes((unsigned char *) \"RIFF\",4);";
  z[lc++]="  asyso_putint(0,4);       /* patched later */";
  z[lc++]="  asyso_putbytes((unsigned char *) \"WAVEfmt \",8);";
  z[lc++]="  asyso_putint(16,4);";
  z[lc++]="  asyso_putint(1,2);                          /* PCM  */";
  z[lc++]="  asyso_putint(ochannels,2);                  /* number of channels */";
  z[lc++]="  asyso_putint(srate,4);                      /* srate */";
  z[lc++]="  asyso_putint(srate*ochannels*asyso_bps, 4); /* bytes/sec */";
  z[lc++]="  asyso_putint(ochannels*asyso_bps, 2);       /* block align */";
  z[lc++]="  asyso_putint(8*asyso_bps, 2);               /* bits per sample */";
  z[lc++]="  asyso_putbytes((unsigned char *) \"data\",4);";
  z[lc++]="  asyso_putint(0,4);                          /* patched later */";
  z[lc++]="";
  z[lc++]="  asyso_srate = srate;";
  z[lc++]="  asyso_channels = ochannels;";
  z[lc++]="  asyso_size = osize;";
  z[lc++]="  asyso_nsamp = 0;";
  z[lc++]="  asyso_cbuf = (unsigned char *) malloc(osize*asyso_bps);";
  z[lc++]="";
  z[lc++]="  if (asyso_cbuf == NULL)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Can't allocate WAV byte output buffer (%s).\\n\",";
  z[lc++]="	      strerror(errno));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  asyso_buf = (float *)calloc(osize, sizeof(float));";
  z[lc++]="";
  z[lc++]="  if (asyso_buf == NULL)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Can't allocate WAV float output buffer (%s).\\n\",";
  z[lc++]="	      strerror(errno));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*            gets next block of WAV bytes               */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_getbytes(unsigned char * c, int numbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if ((int)rread(c, sizeof(char), numbytes, asysi_fd) != numbytes)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*        flushes next block of WAV bytes                */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_flushbytes(int numbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char c;";
  z[lc++]="";
  z[lc++]="  while (numbytes > 0)";
  z[lc++]="    {";
  z[lc++]="      if (rread(&c, sizeof(char), 1, asysi_fd) != 1)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="      numbytes--;";
  z[lc++]="    }";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*     converts byte stream to an unsigned int           */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_getint(int numbytes, unsigned int * ret)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char c[4];";
  z[lc++]="";
  z[lc++]="  if (numbytes > 4)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (ASYS_DONE != asysi_getbytes(&c[0],numbytes))";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  switch (numbytes) {";
  z[lc++]="  case 4:";
  z[lc++]="    *ret  =  (unsigned int)c[0];";
  z[lc++]="    *ret |=  (unsigned int)c[1] << 8;";
  z[lc++]="    *ret |=  (unsigned int)c[2] << 16;";
  z[lc++]="    *ret |=  (unsigned int)c[3] << 24;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 3:";
  z[lc++]="    *ret  =  (unsigned int)c[0];";
  z[lc++]="    *ret |=  (unsigned int)c[1] << 8;";
  z[lc++]="    *ret |=  (unsigned int)c[2] << 16;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 2:";
  z[lc++]="    *ret  =  (unsigned int)c[0];";
  z[lc++]="    *ret |=  (unsigned int)c[1] << 8;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 1:";
  z[lc++]="    *ret = (unsigned int)c[0];";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  default:";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="  ";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*  checks byte stream for AIFF/WAV cookie --              */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_soundtypecheck(char * d)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char c[4];";
  z[lc++]="";
  z[lc++]="  if (rread(c, sizeof(char), 4, asysi_fd) != 4)";
  z[lc++]="    return ASYSI_EOF;";
  z[lc++]="  if (strncmp(c,d,4))";
  z[lc++]="    return ASYSI_NOMATCH;";
  z[lc++]="  return ASYSI_MATCH;";
  z[lc++]="}";
  z[lc++]="  ";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio input setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_setup(int srate, int ichannels, int isize, char * name)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  short swaptest = 0x0100;";
  z[lc++]="  unsigned int i, cookie;";
  z[lc++]="  int len;";
  z[lc++]="  char * val;";
  z[lc++]="";
  z[lc++]="  asysi_doswap = *((char *)&swaptest);";
  z[lc++]="";
  z[lc++]="  if (name == NULL)";
  z[lc++]="    val = ASYSI_DEFAULTNAME;";
  z[lc++]="  else";
  z[lc++]="    val = name;";
  z[lc++]="  asysi_name = strcpy((char *) calloc((strlen(val)+1),sizeof(char)), val);";
  z[lc++]="  asysi_fd = fopen(asysi_name,\"rb\");";
  z[lc++]="  if (asysi_fd == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysi_soundtypecheck(\"RIFF\")!= ASYSI_MATCH)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (asysi_flushbytes(4)!= ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (asysi_soundtypecheck(\"WAVE\")!= ASYSI_MATCH)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  while ((cookie = asysi_soundtypecheck(\"fmt \"))!=ASYSI_MATCH)";
  z[lc++]="    {";
  z[lc++]="      if (cookie == ASYSI_EOF)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="      if (asysi_getint(4, &i) != ASYS_DONE)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="      if (asysi_flushbytes(i + (i % 2))!= ASYS_DONE)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  if (asysi_getint(4, &i) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  len = i;";
  z[lc++]="  if ((len -= 16) < 0)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (asysi_getint(2, &i) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (i != 1)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr,\"Error: Can only handle PCM WAV files\\n\");";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  if (asysi_getint(2, &i) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (i != ichannels)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr,\"Error: Inchannels doesn't match WAV file\\n\");";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  if (asysi_getint(4, &i) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (srate != i)";
  z[lc++]="    fprintf(stderr,\"Warning: SAOL srate %i mismatches WAV file srate %i\\n\",";
  z[lc++]="	    srate,i);";
  z[lc++]="  asysi_flushbytes(6);";
  z[lc++]="  if (asysi_getint(2, &i) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if ((i < 8) || (i > 24))";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr,\"Error: Can't handle %i bit data\\n\",i);";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  asysi_bps = i/8;";
  z[lc++]="  asysi_flushbytes(len + (len % 2));";
  z[lc++]="";
  z[lc++]="  while ((cookie = asysi_soundtypecheck(\"data\"))!=ASYSI_MATCH)";
  z[lc++]="    {";
  z[lc++]="      if (cookie == ASYSI_EOF)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="      if (asysi_getint(4, &i) != ASYS_DONE)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="      if (asysi_flushbytes(i + (i % 2))!= ASYS_DONE)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  if (asysi_getint(4, &i) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  asysi_nsamp = i/asysi_bps;";
  z[lc++]="  asysi_srate = srate;";
  z[lc++]="  asysi_channels = ichannels;";
  z[lc++]="  asysi_bytes = isize*asysi_bps;";
  z[lc++]="  asysi_cbuf = (unsigned char *) malloc(asysi_bytes);";
  z[lc++]="";
  z[lc++]="  if (asysi_cbuf == NULL)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Can't allocate WAV input byte buffer (%s).\\n\",";
  z[lc++]="	      strerror(errno));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  asysi_buf = (float *) malloc(sizeof(float)*isize);";
  z[lc++]="";
  z[lc++]="  if (asysi_buf == NULL)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Can't allocate WAV input float buffer (%s).\\n\",";
  z[lc++]="	      strerror(errno));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(int srate, int ochannels, int osample, ";
  z[lc++]="		char * oname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*EV(ACYCLE), oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(int srate, int ichannels, int isample, ";
  z[lc++]="		char * iname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asysi_setup(srate, ichannels, ASYS_ICHAN*EV(ACYCLE), iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(int srate, int ichannels, int ochannels,";
  z[lc++]="		 int isample, int osample, ";
  z[lc++]="		 char * iname, char * oname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (asysi_setup(srate, ichannels, ASYS_ICHAN*EV(ACYCLE), iname) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*EV(ACYCLE), oname);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             shuts down audio output system                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asyso_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  fseek(asyso_fd, 4, SEEK_SET);";
  z[lc++]="  asyso_putint(asyso_bps*(unsigned int)asyso_nsamp+36,4);";
  z[lc++]="  fseek(asyso_fd, 32, SEEK_CUR);";
  z[lc++]="  asyso_putint(asyso_bps*(unsigned int)asyso_nsamp,4);";
  z[lc++]="  fclose(asyso_fd);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               shuts down audio input system                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysi_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  fclose(asysi_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float * buf = *asys_obuf;";
  z[lc++]="  float fval;";
  z[lc++]="  int val;";
  z[lc++]="  int i = 0;";
  z[lc++]="  int j = 0;";
  z[lc++]="";
  z[lc++]="  switch (asyso_bps) {";
  z[lc++]="  case 3:";
  z[lc++]="    while (i < *osize)";
  z[lc++]="      {";
  z[lc++]="	fval = ((float)(pow(2, 23) - 1))*buf[i++];";
  z[lc++]="	val = (int)((fval >= 0.0F) ? (fval + 0.5F) : (fval - 0.5F));";
  z[lc++]="	asyso_cbuf[j++] = (unsigned char) (val & 0x000000FF);";
  z[lc++]="	asyso_cbuf[j++] = (unsigned char)((val >> 8) & 0x000000FF);";
  z[lc++]="	asyso_cbuf[j++] = (unsigned char)((val >> 16) & 0x000000FF);";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  case 2:";
  z[lc++]="    while (i < *osize)";
  z[lc++]="      {";
  z[lc++]="	fval = ((float)(pow(2, 15) - 1))*buf[i++];";
  z[lc++]="	val = (int)((fval >= 0.0F) ? (fval + 0.5F) : (fval - 0.5F));";
  z[lc++]="	asyso_cbuf[j++] = (unsigned char) (val & 0x000000FF);";
  z[lc++]="	asyso_cbuf[j++] = (unsigned char)((val >> 8) & 0x000000FF);";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  case 1:";
  z[lc++]="    while (i < *osize)";
  z[lc++]="      {";
  z[lc++]="	fval = ((float)(pow(2, 7) - 1))*buf[i++];";
  z[lc++]="	asyso_cbuf[j++] = (unsigned char)";
  z[lc++]="	  (128 + ((char)((fval >= 0.0F) ? (fval + 0.5F) : (fval - 0.5F))));";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="  ";
  z[lc++]="  if (rwrite(asyso_cbuf, sizeof(char), j, asyso_fd) != j)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  asyso_nsamp += *osize;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               get one frame of audio from input              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], int * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i = 0;";
  z[lc++]="  int j = 0;";
  z[lc++]="";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    *asys_ibuf = asysi_buf;";
  z[lc++]="  ";
  z[lc++]="  if (asysi_nsamp <= 0)";
  z[lc++]="    {";
  z[lc++]="      *isize = 0;";
  z[lc++]="      return ASYS_DONE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  *isize = (int)rread(asysi_cbuf, sizeof(unsigned char), asysi_bytes, asysi_fd);";
  z[lc++]="";
  z[lc++]="  switch (asysi_bps) {";
  z[lc++]="  case 1:                              /* 8-bit  */";
  z[lc++]="    while (i < *isize)";
  z[lc++]="      {";
  z[lc++]="	asysi_buf[i] = ((float)pow(2, -7))*(((short) asysi_cbuf[i]) - 128);";
  z[lc++]="	i++;";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  case 2:                              /* 9-16 bit */";
  z[lc++]="    *isize = (*isize) / 2;";
  z[lc++]="    while (i < *isize)";
  z[lc++]="      {";
  z[lc++]="	asysi_buf[i] = ((float)pow(2, -15))*((int)(asysi_cbuf[j]) + ";
  z[lc++]="				    (((int)((char)(asysi_cbuf[j+1]))) << 8)); ";
  z[lc++]="	i++;";
  z[lc++]="	j += 2;";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  case 3:                            /* 17-24 bit */";
  z[lc++]="    *isize = (*isize) / 3;";
  z[lc++]="    while (i < *isize)";
  z[lc++]="      {";
  z[lc++]="	asysi_buf[i] = ((float)pow(2, -23))*((int)(asysi_cbuf[j]) + ";
  z[lc++]="				    (((int)(asysi_cbuf[j+1])) << 8) + ";
  z[lc++]="				    (((int)((char) asysi_cbuf[j+2])) << 16));";
  z[lc++]="	i++; ";
  z[lc++]="	j += 3;";
  z[lc++]="      }";
  z[lc++]="    break;";
  z[lc++]="  } ";
  z[lc++]="";
  z[lc++]="  asysi_nsamp -= *isize;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void makedsound(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Win32 DirectSound audio driver for sfront";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Author: Professor John Wawrzynek, UCB CS Division";
  z[lc++]="#    Maintainance Email To: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]=" ";
  z[lc++]="//////////////////////////";
  z[lc++]="// dsound output";
  z[lc++]="// by Vincent Siliakus & Thomas Jongepier";
  z[lc++]="// november 1999";
  z[lc++]="//////////////////////////";
  z[lc++]="#include <windows.h>";
  z[lc++]="#include <windowsx.h>";
  z[lc++]="#include <mmsystem.h>";
  z[lc++]="#include <dsound.h>";
  z[lc++]="#include <objbase.h>";
  z[lc++]="#include <initguid.h> ";
  z[lc++]="";
  z[lc++]="#include <stdio.h>";
  z[lc++]="";
  z[lc++]="#define ASYS_SUCCESS ASYS_DONE";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/* Global variables for audio output.";
  z[lc++]=" */";
  z[lc++]=" ";
  z[lc++]="";
  z[lc++]="char asyso_playing = 0;";
  z[lc++]="int asyso_wrtCursor = 0;";
  z[lc++]="int asyso_bufsize;                                /* buffer size in";
  z[lc++]="bytes        */";
  z[lc++]="int asyso_blksize;                                /* size preferred by";
  z[lc++]="sfront    */";
  z[lc++]="";
  z[lc++]="double asyso_speriod;";
  z[lc++]="LPDIRECTSOUND 		lpDirectSound;";
  z[lc++]="LPDIRECTSOUNDBUFFER lpDsb;	";
  z[lc++]="LPDIRECTSOUNDBUFFER lpPrDsb;";
  z[lc++]="LPDIRECTSOUNDNOTIFY lpDsNotify;";
  z[lc++]="HANDLE				*hBuffPos;";
  z[lc++]="DSBPOSITIONNOTIFY   *PositionNotify;";
  z[lc++]="PCMWAVEFORMAT		pcmwfp;";
  z[lc++]="PCMWAVEFORMAT		pcmwf;";
  z[lc++]="DSBUFFERDESC		dsprbdescp;";
  z[lc++]="DSBUFFERDESC		dsbdesc;";
  z[lc++]="DSCAPS				dscaps;";
  z[lc++]="DSBCAPS				pr,sec;";
  z[lc++]="HRESULT       		hr;	";
  z[lc++]="unsigned int		ds_numofsubbuff;";
  z[lc++]="unsigned int		ds_subbuffercounter=0;";
  z[lc++]="unsigned int		ds_writeposition=0;";
  z[lc++]="unsigned int		ds_counter=0;";
  z[lc++]="unsigned int		ds_resetwritecrspoint=0;";
  z[lc++]="unsigned int		SECBUFFBYTESIZE;";
  z[lc++]="unsigned int		SUBBUFFBYTESIZE;";
  z[lc++]="unsigned int		SUBBUFFSAMPLESIZE;";
  z[lc++]="unsigned int		WRITEPOSITIONOFFSET;";
  z[lc++]="unsigned int		TIMES;";
  z[lc++]="unsigned int		EXCEPTIONTIMES;";
  z[lc++]=" ";
  z[lc++]="  ";
  z[lc++]="void DevCaps(DSCAPS *);";
  z[lc++]="void PrBuffCaps(DSBCAPS *);";
  z[lc++]="void SecBuffCaps(DSBCAPS *);";
  z[lc++]="void WaitForNotification();";
  z[lc++]="void Close();";
  z[lc++]="void Play();";
  z[lc++]="void Stop();";
  z[lc++]="int InitOutput(unsigned int);";
  z[lc++]=" ";
  z[lc++]="void DevCaps(DSCAPS *DSCaps)";
  z[lc++]="{	";
  z[lc++]="	DSCaps->dwSize = sizeof(DSCAPS);";
  z[lc++]="	IDirectSound_GetCaps(lpDirectSound,DSCaps);";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]="void PrBuffCaps(DSBCAPS *PrBCaps)";
  z[lc++]="{	";
  z[lc++]="	PrBCaps->dwSize = sizeof(DSBCAPS); ";
  z[lc++]="	IDirectSoundBuffer_GetCaps(lpPrDsb,PrBCaps); ";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]="void SecBuffCaps(DSBCAPS *SecBCaps)";
  z[lc++]="{	";
  z[lc++]="	SecBCaps->dwSize = sizeof(DSBCAPS);";
  z[lc++]="	IDirectSoundBuffer_GetCaps(lpDsb,SecBCaps);";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]="void WaitForNotification()";
  z[lc++]="{";
  z[lc++]="	DWORD EventNumber = (WaitForMultipleObjects";
  z[lc++]="		(ds_numofsubbuff, hBuffPos, FALSE, INFINITE));";
  z[lc++]="	//ResetEvent(hBuffPos[EventNumber]); //for manual ResetEvent. ";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]="void Close()";
  z[lc++]="{ ";
  z[lc++]="	for(ds_counter=0;ds_counter<ds_numofsubbuff;ds_counter++)";
  z[lc++]="		CloseHandle(hBuffPos[ds_counter]);";
  z[lc++]="	IDirectSoundBuffer_Release(lpDsb);";
  z[lc++]="	IDirectSound_Release(lpDirectSound);";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]="void Play() ";
  z[lc++]="{ ";
  z[lc++]="	IDirectSoundBuffer_Play(lpDsb,0,0,DSBPLAY_LOOPING ); ";
  z[lc++]="} ";
  z[lc++]="  ";
  z[lc++]="void Stop()";
  z[lc++]="{";
  z[lc++]="	IDirectSoundBuffer_Stop(lpDsb);";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]=" ";
  z[lc++]="int InitOutput(unsigned int sys_osize, ";
  z[lc++]="			   unsigned int samplerate, ";
  z[lc++]="			   unsigned int numchannels)";
  z[lc++]="{ ";
  z[lc++]="	HWND hwnd = GetForegroundWindow();";
  z[lc++]="	if(hwnd==NULL)hwnd = GetDesktopWindow();";
  z[lc++]="	SECBUFFBYTESIZE	 =	sys_osize*16;//use 16 or 32	";
  z[lc++]="	SUBBUFFBYTESIZE	 =	sys_osize;";
  z[lc++]="	SUBBUFFSAMPLESIZE=	sys_osize/2;";
  z[lc++]="  	WRITEPOSITIONOFFSET = SUBBUFFBYTESIZE;";
  z[lc++]="	TIMES=SECBUFFBYTESIZE/SUBBUFFBYTESIZE;";
  z[lc++]="	EXCEPTIONTIMES = (WRITEPOSITIONOFFSET/SUBBUFFBYTESIZE);";
  z[lc++]="	ds_resetwritecrspoint =  ";
  z[lc++]="		SECBUFFBYTESIZE-(EXCEPTIONTIMES*SUBBUFFBYTESIZE);";
  z[lc++]="	ds_numofsubbuff=SECBUFFBYTESIZE/SUBBUFFBYTESIZE;";
  z[lc++]="	////////////////////////////////";
  z[lc++]="	//dsound init";
  z[lc++]="	////////////////////////////////";
  z[lc++]="	//Create DirectSound Object";
  z[lc++]="	if FAILED(DirectSoundCreate(NULL, &lpDirectSound, NULL))";
  z[lc++]="		return ASYS_ERROR;";
  z[lc++]="	//";
  z[lc++]="	//Set Cooperative level of DirectSound Object";
  z[lc++]="	if FAILED(IDirectSound_SetCooperativeLevel(lpDirectSound,hwnd, ";
  z[lc++]="			DSSCL_PRIORITY))return ASYS_ERROR;";
  z[lc++]="	//    ";
  z[lc++]="	////////////////////////////////  ";
  z[lc++]="   // Set up wave format structure.";
  z[lc++]="   memset(&pcmwfp, 0, sizeof(PCMWAVEFORMAT));";
  z[lc++]="    pcmwfp.wf.wFormatTag = WAVE_FORMAT_PCM;";
  z[lc++]="    pcmwfp.wf.nChannels = numchannels;";
  z[lc++]="    pcmwfp.wf.nSamplesPerSec = samplerate;";
  z[lc++]="    pcmwfp.wf.nBlockAlign = 2*numchannels;";
  z[lc++]="    pcmwfp.wf.nAvgBytesPerSec =";
  z[lc++]="		pcmwfp.wf.nSamplesPerSec * pcmwfp.wf.nBlockAlign;";
  z[lc++]="    pcmwfp.wBitsPerSample = 16;";
  z[lc++]="	//";
  z[lc++]="	////////////////////////////////";
  z[lc++]="    // Set up DSBUFFERDESC structure.";
  z[lc++]="    memset(&dsprbdescp, 0, sizeof(DSBUFFERDESC)); // Zero it out.";
  z[lc++]="    dsprbdescp.dwSize = sizeof(DSBUFFERDESC);";
  z[lc++]="    dsprbdescp.dwFlags = DSBCAPS_PRIMARYBUFFER;";
  z[lc++]="    dsprbdescp.dwBufferBytes = 0;";
  z[lc++]="    dsprbdescp.lpwfxFormat = NULL;";
  z[lc++]="	//";
  z[lc++]="	////////////////////////////////";
  z[lc++]="	// Create Primary buffer.  ";
  z[lc++]="    if FAILED(IDirectSound_CreateSoundBuffer(lpDirectSound,&dsprbdescp, ";
  z[lc++]="	&lpPrDsb, NULL))return ASYS_ERROR;";
  z[lc++]="	// Set primary buffer to desired format.";
  z[lc++]="    if FAILED(IDirectSoundBuffer_SetFormat(lpPrDsb,";
  z[lc++]="		(LPWAVEFORMATEX)&pcmwfp))return ASYS_ERROR;";
  z[lc++]="	//start playing (no sound yet)";
  z[lc++]="    IDirectSoundBuffer_Play(lpPrDsb,0,0,DSBPLAY_LOOPING);";
  z[lc++]="	//";
  z[lc++]="    // Set up wave format structure.";
  z[lc++]="    memset(&pcmwf, 0, sizeof(PCMWAVEFORMAT));";
  z[lc++]="    pcmwf.wf.wFormatTag = WAVE_FORMAT_PCM;";
  z[lc++]="    pcmwf.wf.nChannels = numchannels;";
  z[lc++]="    pcmwf.wf.nSamplesPerSec = samplerate;";
  z[lc++]="    pcmwf.wf.nBlockAlign = 2*numchannels;";
  z[lc++]="    pcmwf.wf.nAvgBytesPerSec =";
  z[lc++]="		pcmwf.wf.nSamplesPerSec * pcmwf.wf.nBlockAlign;";
  z[lc++]="    pcmwf.wBitsPerSample = 16;	";
  z[lc++]="	//";
  z[lc++]="    // Set up DSBUFFERDESC structure.";
  z[lc++]="    memset(&dsbdesc, 0, sizeof(DSBUFFERDESC)); // Zero it out.";
  z[lc++]="    dsbdesc.dwSize = sizeof(DSBUFFERDESC);";
  z[lc++]="    // Need default controls (pan, volume, frequency).";
  z[lc++]="    dsbdesc.dwFlags = ";
  z[lc++]="					 DSBCAPS_GLOBALFOCUS ";
  z[lc++]="					|DSBCAPS_GETCURRENTPOSITION2";
  z[lc++]="					|DSBCAPS_CTRLPOSITIONNOTIFY ;";
  z[lc++]="    dsbdesc.dwBufferBytes = SECBUFFBYTESIZE;";
  z[lc++]="    dsbdesc.lpwfxFormat = (LPWAVEFORMATEX)&pcmwf;";
  z[lc++]="	//";
  z[lc++]="	////////////////////////////////";
  z[lc++]="	if FAILED(IDirectSound_CreateSoundBuffer(lpDirectSound,&dsbdesc, ";
  z[lc++]="		&lpDsb, NULL))return ASYS_ERROR;";
  z[lc++]="    //";
  z[lc++]="	PositionNotify=(DSBPOSITIONNOTIFY*)malloc(ds_numofsubbuff*";
  z[lc++]="		(sizeof(DSBPOSITIONNOTIFY)));";
  z[lc++]="	hBuffPos=(HANDLE*)malloc(ds_numofsubbuff*sizeof(HANDLE));";
  z[lc++]="	//";
  z[lc++]="	for(ds_counter=0;ds_counter<ds_numofsubbuff;ds_counter++){";
  z[lc++]="		hBuffPos[ds_counter]=CreateEvent(NULL,FALSE,FALSE,NULL);";
  z[lc++]="		PositionNotify[ds_counter].dwOffset = SUBBUFFBYTESIZE*ds_counter;";
  z[lc++]="		PositionNotify[ds_counter].hEventNotify=hBuffPos[ds_counter]; ";
  z[lc++]="	}";
  z[lc++]="	//";
  z[lc++]="	if FAILED(IDirectSoundBuffer_QueryInterface(lpDsb,";
  z[lc++]="		&IID_IDirectSoundNotify,(LPVOID *)&lpDsNotify))return ASYS_ERROR;  ";
  z[lc++]="	//";
  z[lc++]="	IDirectSoundNotify_SetNotificationPositions(lpDsNotify,ds_numofsubbuff,";
  z[lc++]="		PositionNotify); ";
  z[lc++]="	//\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";
  z[lc++]="	//";
  z[lc++]="	Play();";
  z[lc++]="	return ASYS_SUCCESS;";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]=" ";
  z[lc++]="#endif";
  z[lc++]=" ";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]=" ";
  z[lc++]="/* Opens waveform output for a given srate/channels.";
  z[lc++]=" */";
  z[lc++]=" ";
  z[lc++]="int asys_osetup(int srate, int ochannels, int osample, ";
  z[lc++]="                char * oname, int toption)";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  int osize = ASYS_OCHAN*ACYCLE;";
  z[lc++]="";
  z[lc++]="  InitOutput(osize,srate,ochannels);";
  z[lc++]="  return ASYS_SUCCESS;";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]="#endif";
  z[lc++]=" ";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="  ";
  z[lc++]="/*";
  z[lc++]=" * Shuts down audio system.";
  z[lc++]=" */";
  z[lc++]=" ";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]=" ";
  z[lc++]="{";
  z[lc++]="  Stop();";
  z[lc++]="  Close();";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]="#endif";
  z[lc++]=" ";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]=" ";
  z[lc++]="int asys_putbuf(short **buffer, int * osize)";
  z[lc++]=" ";
  z[lc++]="{ 	";
  z[lc++]="	DWORD dwBytes;";
  z[lc++]="	*osize=SUBBUFFSAMPLESIZE; ";
  z[lc++]="	ds_writeposition=ds_subbuffercounter*SUBBUFFBYTESIZE;	";
  z[lc++]="	WaitForNotification();	";
  z[lc++]="	if(ds_writeposition>ds_resetwritecrspoint)";
  z[lc++]="	{";
  z[lc++]="		ds_subbuffercounter=0;";
  z[lc++]="		ds_writeposition=0;";
  z[lc++]="	}";
  z[lc++]="	hr = IDirectSoundBuffer_Unlock(lpDsb,*buffer, ";
  z[lc++]="		SUBBUFFBYTESIZE, NULL,NULL);  ";
  z[lc++]="    hr = IDirectSoundBuffer_Lock(lpDsb,ds_writeposition, ";
  z[lc++]="		SUBBUFFBYTESIZE, (LPVOID*)buffer,&dwBytes, NULL, 0, NULL);    ";
  z[lc++]="	ds_subbuffercounter++;";
  z[lc++]="	return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="   ";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  /* emulates old interface, since I don't understand asys_putbuf */";
  z[lc++]="  /* well enough to make direct modifications  */";
  z[lc++]="";
  z[lc++]="  /* set up first call, which allocates buffer */";
  z[lc++]="";
  z[lc++]="  *asys_obuf = NULL;";
  z[lc++]="  *osize = 0;";
  z[lc++]="";
  z[lc++]="  if (asys_putbuf(asys_obuf, osize) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  /* clear allocated buffer */";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < (*osize); i++)";
  z[lc++]="    (*asys_obuf)[i] = 0;";
  z[lc++]="";
  z[lc++]="  /* send the 4 silence putbuf's of old API */";
  z[lc++]="";
  z[lc++]="  for(i = 0; i < 4; i++)";
  z[lc++]="    if (asys_putbuf(asys_obuf, osize) == ASYS_ERROR)";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]=" ";
  z[lc++]="";
  z[lc++]="/* Currently not supported audio input.  All routines are dummies.";
  z[lc++]=" */";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/* Initializes audio input.";
  z[lc++]=" */";
  z[lc++]="int asys_isetup(int srate, int ichannels, int isample, ";
  z[lc++]="                char * iname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return ASYS_ERROR;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/* Initialized bidirectional audio flows. */";
  z[lc++]="int asys_iosetup(int srate, int ichannels, int ochannels,";
  z[lc++]="                 int isample, int osample, ";
  z[lc++]="                 char * iname, char * oname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return ASYS_ERROR;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* Shuts down audio input device.";
  z[lc++]=" */";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* Gets one frame of audio from input.";
  z[lc++]=" */";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], int * isize)";
  z[lc++]="{";
  z[lc++]="  return ASYS_ERROR;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*  ksync() and ksyncinit() for -playback and -timesync modes  */";
  z[lc++]="/*_____________________________________________________________*/";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_KSYNC)";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION != ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="#include <windows.h>";
  z[lc++]="#include <windowsx.h>";
  z[lc++]="#include <winbase.h>";
  z[lc++]="#include <mmsystem.h>";
  z[lc++]="";
  z[lc++]="#define SYNC_MAXCOUNT 4294967296L";
  z[lc++]="#define SYNC_KMTIME EV(KUTIME)/1000";
  z[lc++]="";
  z[lc++]="DWORD sync_last, sync_this, sync_delay;";
  z[lc++]="TIMECAPS sync_tc;";
  z[lc++]="BOOL sync_waitFlag;";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         support routines                                */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void CALLBACK sync_callBack(UINT uID, UINT uMsg, ";
  z[lc++]="                            DWORD dwUser, DWORD dw1, DWORD dw2)";
  z[lc++]="{";
  z[lc++]="  sync_waitFlag = TRUE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="BOOL sync_sleep(UINT ms)";
  z[lc++]="{";
  z[lc++]="  sync_waitFlag = FALSE;";
  z[lc++]="  if FAILED(timeSetEvent(ms, (UINT) 1, &sync_callBack, 0L, TIME_ONESHOT))";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"timeSetEvent error.\\n\");";
  z[lc++]="      exit(-1);";
  z[lc++]="    }";
  z[lc++]="  // spin wait";
  z[lc++]="  while (!sync_waitFlag) {}";
  z[lc++]="  return TRUE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float ret;";
  z[lc++]="";
  z[lc++]="  sync_this = timeGetTime();";
  z[lc++]="  ";
  z[lc++]="  if (sync_this<sync_last)   // timer wrap around";
  z[lc++]="    sync_last = (DWORD) (sync_last - SYNC_MAXCOUNT) + SYNC_KMTIME;";
  z[lc++]="  else ";
  z[lc++]="    sync_last += SYNC_KMTIME;";
  z[lc++]="";
  z[lc++]="  sync_delay = sync_last - sync_this;";
  z[lc++]="  if (sync_delay>0)";
  z[lc++]="    {";
  z[lc++]="      /* sync_sleep(sync_delay); */   /* can this be safely commented out? */";
  z[lc++]="      ret = (SYNC_KMTIME - sync_delay)/SYNC_KMTIME;";
  z[lc++]="    }";
  z[lc++]="  else ";
  z[lc++]="    ret = 1.0F;";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         initializes k-rate boundaries sync              */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void ksyncinit()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  // Set 1ms time resolution";
  z[lc++]="  if FAILED(timeGetDevCaps(&sync_tc, sizeof(TIMECAPS)))";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"TimeGetDevCaps error.\\n\");";
  z[lc++]="      exit(-1);";
  z[lc++]="    }";
  z[lc++]="  sync_last = timeGetTime();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="#include <windows.h>";
  z[lc++]="#include <windowsx.h>";
  z[lc++]="#include <winbase.h>";
  z[lc++]="#include <mmsystem.h>";
  z[lc++]="";
  z[lc++]="#define SYNC_MAXCOUNT 4294967296L";
  z[lc++]="#define SYNC_KMTIME EV(KUTIME)/1000";
  z[lc++]="";
  z[lc++]="DWORD sync_last, sync_this, sync_delay;";
  z[lc++]="TIMECAPS sync_tc;";
  z[lc++]="BOOL sync_waitFlag;";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         support routines                                */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void CALLBACK sync_callBack(UINT uID, UINT uMsg, ";
  z[lc++]="                            DWORD dwUser, DWORD dw1, DWORD dw2)";
  z[lc++]="{";
  z[lc++]="  sync_waitFlag = TRUE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="BOOL sync_sleep(UINT ms)";
  z[lc++]="{";
  z[lc++]="  sync_waitFlag = FALSE;";
  z[lc++]="  if FAILED(timeSetEvent(ms, (UINT) 1, &sync_callBack, 0L, TIME_ONESHOT))";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"timeSetEvent error.\\n\");";
  z[lc++]="      exit(-1);";
  z[lc++]="    }";
  z[lc++]="  // spin wait";
  z[lc++]="  while (!sync_waitFlag) {}";
  z[lc++]="  return TRUE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float ret;";
  z[lc++]="";
  z[lc++]="  sync_this = timeGetTime();";
  z[lc++]="  ";
  z[lc++]="  if (sync_this<sync_last)   // timer wrap around";
  z[lc++]="    sync_last = (DWORD) (sync_last - SYNC_MAXCOUNT) + SYNC_KMTIME;";
  z[lc++]="  else ";
  z[lc++]="    sync_last += SYNC_KMTIME;";
  z[lc++]="";
  z[lc++]="  sync_delay = sync_last - sync_this;";
  z[lc++]="  if (sync_delay>0)";
  z[lc++]="    {";
  z[lc++]="      sync_sleep(sync_delay);";
  z[lc++]="      ret = (SYNC_KMTIME - sync_delay)/SYNC_KMTIME;";
  z[lc++]="    }";
  z[lc++]="  else ";
  z[lc++]="    ret = 1.0F;";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         initializes k-rate boundaries sync              */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void ksyncinit()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  // Set 1ms time resolution";
  z[lc++]="  if FAILED(timeGetDevCaps(&sync_tc, sizeof(TIMECAPS)))";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"TimeGetDevCaps error.\\n\");";
  z[lc++]="      exit(-1);";
  z[lc++]="    }";
  z[lc++]="  sync_last = timeGetTime();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#endif  /* ASYS_KSYNC */";
  printlib(lc);
}


void makelinux(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: merged linux/freebsd audio driver for sfront";
  z[lc++]="#    Copyright (C) 2000  Bertrand Petit";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#define ASYSIO_LINUX   0";
  z[lc++]="#define ASYSIO_FREEBSD 1";
  z[lc++]="";
  z[lc++]="#define ASYSIO_OSTYPE  ASYSIO_LINUX";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                linux audio driver for sfront                 */ ";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="/**************************************************/";
  z[lc++]="/* define flags for fifo mode, and for a timer to */";
  z[lc++]="/* catch SAOL infinite loops                      */";
  z[lc++]="/**************************************************/";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && (ASYSIO_OSTYPE == ASYSIO_LINUX) && \\";
  z[lc++]="     defined(CSYS_CDRIVER_LINMIDI) && (ASYS_TIMEOPTION == ASYS_TIMESYNC) && \\";
  z[lc++]="     !defined(ASYS_HASINPUT))";
  z[lc++]="#define ASYSIO_USEFIFO 1";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && (ASYSIO_OSTYPE == ASYSIO_LINUX) && \\";
  z[lc++]="    (ASYS_TIMEOPTION != ASYS_TIMESYNC))";
  z[lc++]="#define ASYSIO_USEFIFO 1";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef ASYSIO_USEFIFO";
  z[lc++]="#define ASYSIO_USEFIFO 0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/**************************************************/";
  z[lc++]="/* include headers, based on flags set above      */";
  z[lc++]="/**************************************************/";
  z[lc++]="";
  z[lc++]="#include <unistd.h>";
  z[lc++]="#include <sys/ioctl.h>";
  z[lc++]="#include <fcntl.h>";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_OSTYPE == ASYSIO_LINUX)";
  z[lc++]="#include <sys/soundcard.h>";
  z[lc++]="#include <endian.h>";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_OSTYPE == ASYSIO_FREEBSD)";
  z[lc++]="#include <machine/soundcard.h>";
  z[lc++]="#include <machine/endian.h>";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#include <signal.h>  ";
  z[lc++]="#include <sys/time.h>  ";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO";
  z[lc++]="#include <sched.h>  ";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="#include <time.h>";
  z[lc++]="#endif";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/******************************/";
  z[lc++]="/* other constant definitions */";
  z[lc++]="/******************************/";
  z[lc++]="";
  z[lc++]="#ifndef ASYSIO_DSPDEV";
  z[lc++]="#define ASYSIO_DSPDEV \"/dev/dsp\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/* determines native audio format */";
  z[lc++]="";
  z[lc++]="#if (BYTE_ORDER == BIG_ENDIAN)";
  z[lc++]="# define ASYSIO_AFORMAT AFMT_S16_BE";
  z[lc++]="#else";
  z[lc++]="# if (BYTE_ORDER == LITTLE_ENDIAN)";
  z[lc++]="#  define ASYSIO_AFORMAT AFMT_S16_LE";
  z[lc++]="# else";
  z[lc++]="#  error \"BYTE_ORDER not defined?\"";
  z[lc++]="# endif";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/* codes for IO types */";
  z[lc++]="";
  z[lc++]="#define ASYSIO_I  0";
  z[lc++]="#define ASYSIO_O  1";
  z[lc++]="#define ASYSIO_IO 2";
  z[lc++]="";
  z[lc++]="/* minimum fragment size */";
  z[lc++]="";
  z[lc++]="#define ASYSIO_FRAGMIN    16";
  z[lc++]="#define ASYSIO_LOGFRAGMIN 4";
  z[lc++]="";
  z[lc++]="/* number of silence buffers */";
  z[lc++]="";
  z[lc++]="#define ASYSO_LNUMBUFF 4";
  z[lc++]="";
  z[lc++]="/* maximum number of I/O retries before termination */";
  z[lc++]="";
  z[lc++]="#define ASYSIO_MAXRETRY 256";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO                      /* SCHED_FIFO constants for ksync()  */";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="#define ASYSIO_SYNC_TIMEOUT    5        /* idle time to leave SCHED_FIFO     */";
  z[lc++]="#define ASYSIO_SYNC_ACTIVE     0        /* machine states for noteon timeout */";
  z[lc++]="#define ASYSIO_SYNC_WAITING    1";
  z[lc++]="#define ASYSIO_SYNC_SCHEDOTHER 2";
  z[lc++]="#else";
  z[lc++]="#define ASYSIO_MAXBLOCK ((int)EV(KRATE))*2  /* max wait tor let SCHED_OTHERs run */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/************************/";
  z[lc++]="/* variable definitions */";
  z[lc++]="/************************/";
  z[lc++]="";
  z[lc++]="int  asysio_fd;                    /* device pointer */";
  z[lc++]="int asysio_srate;                 /* sampling rate */";
  z[lc++]="int asysio_channels;              /* number of channels */";
  z[lc++]="int asysio_size;                  /* # samples in a buffer */";
  z[lc++]="int asysio_bsize;                 /* actual # bytes in a buffer */            ";
  z[lc++]="int asysio_requested_bsize;       /* requested # bytes in a buffer */        ";
  z[lc++]="int asysio_input;                 /* 1 if ASYSIO */";
  z[lc++]="int asysio_blocktime;             /* time (in bytes) blocked in kcycle */";
  z[lc++]="";
  z[lc++]="struct count_info asysio_ptr;      /* for GET{I,O}*PTR  ioctl calls */";
  z[lc++]="struct audio_buf_info asysio_info; /* for GET{I,O}SPACE ioctl calls */";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="short * asyso_buf = NULL;          /* output buffer */";
  z[lc++]="int asysio_puts;                   /* total number of putbufs */";
  z[lc++]="int asysio_reset;                  /* flags an overrun */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="short * asysi_buf = NULL;          /* input buffer */";
  z[lc++]="struct audio_buf_info asysi_info;  /* input dma status */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="sigset_t asysio_iloop_mask;            /* for masking off iloop interrupt */";
  z[lc++]="struct sigaction asysio_iloop_action;  /* for setting up iloop interrupt  */";
  z[lc++]="struct itimerval asysio_iloop_timer;   /* for setting up iloop timer      */";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO ";
  z[lc++]="int asysio_fifo;                       /* can get into sched_fifo mode */";
  z[lc++]="struct sched_param asysio_fifoparam;   /* param block for fifo mode */";
  z[lc++]="struct sched_param asysio_otherparam;  /* param block for other mode */";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="/* state machine variables for noteon timeout */";
  z[lc++]="int    asysio_sync_state;";
  z[lc++]="time_t asysio_sync_waitstart;";
  z[lc++]="extern int csysi_newnote;       /* from linmidi */";
  z[lc++]="";
  z[lc++]="#else";
  z[lc++]="";
  z[lc++]="/* state to detect long periods w/o blocking */";
  z[lc++]="int asysio_sync_noblock;                /* how many acycles since last block */";
  z[lc++]="struct timespec asysio_sync_sleeptime;  /* time to wait during forced block  */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_KSYNC)                      /* ksync() state */";
  z[lc++]="struct count_info asysio_sync_ptr;           ";
  z[lc++]="int asysio_sync_target, asysio_sync_incr;    ";
  z[lc++]="float asysio_sync_cpuscale;                  ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                      shutdown routines                       */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down soundcard                      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysio_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (ioctl(asysio_fd, SNDCTL_DSP_SYNC, 0) == -1)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"\\nSoundcard Error: SNDCTL_DSP_SYNC Ioctl Problem\\n\");";
  z[lc++]="      fprintf(stderr, \"Errno Message: %s\\n\\n\", strerror(errno));";
  z[lc++]="    }";
  z[lc++]="  close(asysio_fd);";
  z[lc++]="";
  z[lc++]="  /* so that a slow exit doesn't trigger timer */";
  z[lc++]="";
  z[lc++]="  asysio_iloop_timer.it_value.tv_sec = 0;";
  z[lc++]="  asysio_iloop_timer.it_value.tv_usec = 0;";
  z[lc++]="  asysio_iloop_timer.it_interval.tv_sec = 0;";
  z[lc++]="  asysio_iloop_timer.it_interval.tv_usec = 0;";
  z[lc++]="  ";
  z[lc++]="  if (setitimer(ITIMER_PROF, &asysio_iloop_timer, NULL) < 0)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"\\nSoundcard Driver Error:\\n\\n\");";
  z[lc++]="      fprintf(stderr, \"  Couldn't set up ITIMER_PROF timer.\\n\");";
  z[lc++]="      fprintf(stderr, \"  Errno Message: %s\\n\\n\", strerror(errno));";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysio_shutdown();";
  z[lc++]="  if (asyso_buf != NULL)";
  z[lc++]="    free(asyso_buf);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio input                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysio_shutdown();  ";
  z[lc++]="  if (asysi_buf != NULL)";
  z[lc++]="    free(asysi_buf);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysio_shutdown();";
  z[lc++]="  if (asyso_buf != NULL)";
  z[lc++]="    free(asyso_buf);";
  z[lc++]="  if (asysi_buf != NULL)";
  z[lc++]="    free(asysi_buf);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                 initialization routines                      */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*          generic error-checking ioctl wrapper                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="#define ASYSIO_IOCTL_CALL(x,y,z)  do { if (ioctl(x,y,z) == -1){\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s Ioctl Problem\\n\", #y ); \\";
  z[lc++]="      fprintf(stderr, \"  Errno Message: %s\\n\\n\", strerror(errno));\\";
  z[lc++]="      close(asysio_fd); return ASYS_ERROR;}} while (0)";
  z[lc++]="";
  z[lc++]="#define  ASYSIO_ERROR_RETURN(x) do {\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s.\\n\", x);\\";
  z[lc++]="      fprintf(stderr, \"  Errno Message: %s\\n\\n\", strerror(errno));\\";
  z[lc++]="      close(asysio_fd);\\";
  z[lc++]="      return ASYS_ERROR; } while (0)";
  z[lc++]="";
  z[lc++]="#define  ASYSIO_ERROR_RETURN_NOERRNO(x) do {\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s.\\n\", x);\\";
  z[lc++]="      close(asysio_fd);\\";
  z[lc++]="      return ASYS_ERROR; } while (0)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               opens the soudcard device                      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_opendevice(int dir, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  switch(dir) {";
  z[lc++]="  case ASYSIO_I:";
  z[lc++]="    asysio_fd = open(ASYSIO_DSPDEV, O_RDONLY, 0);";
  z[lc++]="    asysio_input = 1;";
  z[lc++]="    break;";
  z[lc++]="  case ASYSIO_O:";
  z[lc++]="    asysio_fd = open(ASYSIO_DSPDEV, O_WRONLY, 0);";
  z[lc++]="    asysio_input = 0;";
  z[lc++]="    break;";
  z[lc++]="  case ASYSIO_IO:";
  z[lc++]="    asysio_fd = open(ASYSIO_DSPDEV, O_RDWR, 0);";
  z[lc++]="    asysio_input = 1;";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    fprintf(stderr, \"  Error: Unexpected dir parameter value in \\n\");";
  z[lc++]="    fprintf(stderr, \"         asysio_setup.\\n\\n\");";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  if (asysio_fd == -1)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"  Error: Can't open device %s (%s)\\n\\n\", ASYSIO_DSPDEV,";
  z[lc++]="	      strerror(errno));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*         signal handler for trapping SAOL infinite loops      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysio_iloop_handler(int signum) ";
  z[lc++]="{   ";
  z[lc++]="  fprintf(stderr, \"  Error: Either\\n\\n\");";
  z[lc++]="  fprintf(stderr, \"    [1] The SAOL program has an infinite loop in it, or\\n\");";
  z[lc++]="  fprintf(stderr, \"    [2] Content is too complex for real-time work.\\n\\n\");";
  z[lc++]="  fprintf(stderr, \"  Exiting program ...\\n\\n\");";
  z[lc++]="  exit(0);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*         initializes iloop (heartbeat) interrupt              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_initiloop(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  /*********************************************************/";
  z[lc++]="  /* set up signal handler for infinite-loop (iloop) timer */";
  z[lc++]="  /*********************************************************/";
  z[lc++]="  ";
  z[lc++]="  if (sigemptyset(&asysio_iloop_action.sa_mask) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't run sigemptyset(iloop) OS call\");";
  z[lc++]="";
  z[lc++]="  /* infinite-loop timer wins over midi overrun timer */";
  z[lc++]="";
  z[lc++]="  if (sigaddset(&asysio_iloop_action.sa_mask, SIGALRM) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't run sigaddset(iloop) OS call\");";
  z[lc++]="";
  z[lc++]="  asysio_iloop_action.sa_flags = SA_RESTART;";
  z[lc++]="  asysio_iloop_action.sa_handler = asysio_iloop_handler;";
  z[lc++]="  ";
  z[lc++]="  if (sigaction(SIGPROF, &asysio_iloop_action, NULL) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't set up SIGPROF signal handler\");";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  /************************/";
  z[lc++]="  /* set up timer and arm */";
  z[lc++]="  /************************/";
  z[lc++]="";
  z[lc++]="  asysio_iloop_timer.it_value.tv_sec = 3;";
  z[lc++]="  asysio_iloop_timer.it_value.tv_usec = 0;";
  z[lc++]="  asysio_iloop_timer.it_interval.tv_sec = 0;";
  z[lc++]="  asysio_iloop_timer.it_interval.tv_usec = 0;";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_PROF, &asysio_iloop_timer, NULL) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't set up ITIMER_PROF timer\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 initializes sched_fifo                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_initscheduler(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO";
  z[lc++]="";
  z[lc++]="  /*******************************/";
  z[lc++]="  /* set up sched_fifo variables */";
  z[lc++]="  /*******************************/";
  z[lc++]="";
  z[lc++]="  memset(&asysio_otherparam, 0, sizeof(struct sched_param));";
  z[lc++]="  memset(&asysio_fifoparam, 0, sizeof(struct sched_param));";
  z[lc++]=" ";
  z[lc++]="  if ((asysio_fifoparam.sched_priority =";
  z[lc++]="       sched_get_priority_max(SCHED_FIFO)) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't get scheduling priority\");";
  z[lc++]="";
  z[lc++]="  asysio_fifoparam.sched_priority--;";
  z[lc++]="";
  z[lc++]="  /********************************/";
  z[lc++]="  /* try to enter sched-fifo mode */";
  z[lc++]="  /********************************/";
  z[lc++]="";
  z[lc++]="  asysio_fifo = !sched_setscheduler(0, SCHED_FIFO, &asysio_fifoparam);";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 prints startup screen                        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_screenwriter(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, found;";
  z[lc++]="  int haslinmidi = 0;";
  z[lc++]="  float actual_latency;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"%s \",  (ASYS_LATENCYTYPE == ASYS_HIGHLATENCY)? ";
  z[lc++]="	  \"Streaming\" : \"Interactive\");";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"%s Audio \", (asysio_channels == 2) ? \"Stereo\" : \"Mono\");";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="  fprintf(stderr, \"%s\", asysio_input ? \"Input/Output\" : \"Output\");";
  z[lc++]="#else";
  z[lc++]="  fprintf(stderr, \"Input\");";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  found = i = 0;";
  z[lc++]="  while (i < csys_sfront_argc)";
  z[lc++]="    {";
  z[lc++]="      if (!(strcmp(csys_sfront_argv[i],\"-bitc\") && ";
  z[lc++]="	    strcmp(csys_sfront_argv[i],\"-bit\") &&";
  z[lc++]="	    strcmp(csys_sfront_argv[i],\"-orc\")))";
  z[lc++]="	{";
  z[lc++]="	  i++;";
  z[lc++]="	  fprintf(stderr, \" for %s\", csys_sfront_argv[i]);";
  z[lc++]="	  found = 1;";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="      i++;";
  z[lc++]="    }";
  z[lc++]="  if (!found)";
  z[lc++]="    fprintf(stderr, \" for UNKNOWN\");";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  i = 0;";
  z[lc++]="  while (i < csys_sfront_argc)";
  z[lc++]="    {";
  z[lc++]="      if (!strcmp(csys_sfront_argv[i],\"-cin\"))";
  z[lc++]="	{";
  z[lc++]="	  i++;";
  z[lc++]="	  fprintf(stderr, \" (-cin %s)\", csys_sfront_argv[i]);";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="      i++;";
  z[lc++]="    }";
  z[lc++]="  fprintf(stderr, \"\\n\\n\");";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(CSYS_CDRIVER_LINMIDI)";
  z[lc++]="";
  z[lc++]="  haslinmidi = 1;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(CSYS_CDRIVER_LINMIDI) || defined(CSYS_CDRIVER_ALSAMIDI)\\";
  z[lc++]="      || defined(CSYS_CDRIVER_ALSASEQ) || defined(CSYS_CDRIVER_ASCII))";
  z[lc++]="";
  z[lc++]="  /* list midi presets available */";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="	  \"MIDI Preset Numbers (use MIDI controller to select):\\n\\n\");";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < CSYS_PRESETNUM; i++)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"%3i. %s\", ";
  z[lc++]="	      csys_presets[i].preset,";
  z[lc++]="	      csys_instr[csys_presets[i].index].name);";
  z[lc++]="      if ((i&1))";
  z[lc++]="	fprintf(stderr, \"\\n\");";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"\\t\\t\");";
  z[lc++]="	  if (i == (CSYS_PRESETNUM-1))";
  z[lc++]="	    fprintf(stderr, \"\\n\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  fprintf(stderr, \"\\n\");";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(CSYS_CDRIVER_ASCII)";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="  \"To play tunes on ASCII keyboard: a-z for notes, 0-9 for MIDI presets,\\n\");";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="  \"cntrl-C exits. If autorepeat interferes, exit and run 'xset -r' (in X).\\n\\n\");";
  z[lc++]="  ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* diagnose best flags to use, and if they are used */";
  z[lc++]="";
  z[lc++]="#ifdef ASYS_HASOUTPUT";
  z[lc++]="";
  z[lc++]="  if ((ASYS_LATENCYTYPE == ASYS_HIGHLATENCY) || asysio_input ||";
  z[lc++]="      (!haslinmidi))";
  z[lc++]="    {";
  z[lc++]="      if (geteuid() || (ASYS_TIMEOPTION == ASYS_TIMESYNC))";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"For best results, make these changes:\\n\"); ";
  z[lc++]="	  fprintf(stderr, \"\\n\");";
  z[lc++]="	  if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="	    fprintf(stderr, \"   * Remove sfront -timesync flag\\n\");";
  z[lc++]="	  if (geteuid())";
  z[lc++]="	    fprintf(stderr, \"   * Run sa.c executable as root.\\n\");";
  z[lc++]="	  fprintf(stderr, \"\\n\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"This application runs best as root (%s), with:\\n\",";
  z[lc++]="	      !geteuid() ? \"which you are\": \"which you aren't\"); ";
  z[lc++]="      fprintf(stderr, \"\\n\");";
  z[lc++]="      fprintf(stderr, \"  [1] Sfront -playback flag. Good audio quality, keeps\\n\");";
  z[lc++]="      fprintf(stderr, \"      the mouse/kbd alive\");";
  z[lc++]="      fprintf(stderr, \"%s.\\n\", (ASYS_TIMEOPTION == ASYS_PLAYBACK) ?";
  z[lc++]="	      \" (currently chosen)\":\"\");";
  z[lc++]="      fprintf(stderr, \"  [2] Sfront -timesync flag. Better quality, console\\n\");";
  z[lc++]="      fprintf(stderr, \"      freezes during MIDI input\");";
  z[lc++]="      fprintf(stderr, \"%s.\\n\", (ASYS_TIMEOPTION == ASYS_TIMESYNC) ?";
  z[lc++]="	      \" (currently chosen)\":\"\");";
  z[lc++]="      fprintf(stderr, \"\\n\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* latency information */";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT))";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOSPACE, &asysio_info);";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"If audio artifacts still occur, try\");";
  z[lc++]="  ";
  z[lc++]="  actual_latency = ATIME*ASYSO_LNUMBUFF*(asysio_size >> (asysio_channels - 1));";
  z[lc++]="  ";
  z[lc++]="  if (asysio_info.fragstotal < ASYSO_LNUMBUFF)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \" sfront -latency %f flag, and see\\n\", ";
  z[lc++]="	      0.5F*actual_latency);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \" sfront -latency %f flag, and see\\n\", ";
  z[lc++]="	      2.0F*actual_latency);";
  z[lc++]="";
  z[lc++]="    }";
  z[lc++]="  if (ASYS_LATENCYTYPE == ASYS_LOWLATENCY)";
  z[lc++]="    fprintf(stderr, \"http://www.cs.berkeley.edu/\"";
  z[lc++]="	    \"~lazzaro/sa/sfman/user/use/index.html#interact\\n\") ;";
  z[lc++]="  else";
  z[lc++]="    fprintf(stderr, \"http://www.cs.berkeley.edu/\"";
  z[lc++]="	    \"~lazzaro/sa/sfman/user/use/index.html#stream\\n\") ;";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"\\n\");";
  z[lc++]="";
  z[lc++]="  if ((asysio_bsize != ASYSIO_FRAGMIN) &&";
  z[lc++]="      (asysio_bsize == asysio_requested_bsize) && ";
  z[lc++]="      (ASYS_LATENCYTYPE == ASYS_LOWLATENCY))";
  z[lc++]="  {";
  z[lc++]="    fprintf(stderr, \"If interactive response is slow, try \");";
  z[lc++]="    fprintf(stderr, \"sfront -latency %f flag.\\n\", 0.5F*actual_latency);";
  z[lc++]="    fprintf(stderr, \"\\n\");";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="  \"USE AT YOUR OWN RISK. Running as root may damage your file system,\\n\");";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="  \"and network use may result in a malicious attack on your machine.\\n\\n\");";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_USEFIFO && (ASYS_TIMEOPTION == ASYS_TIMESYNC))";
  z[lc++]="";
  z[lc++]="  if (!geteuid())";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, ";
  z[lc++]="      \"NOTE: Mouse and keyboard are frozen for %i seconds after a MIDI\\n\",";
  z[lc++]="	      ASYSIO_SYNC_TIMEOUT);";
  z[lc++]="      fprintf(stderr, ";
  z[lc++]="	      \"NoteOn or NoteOff is received. Do not be alarmed.\\n\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  if (NSYS_NET)";
  z[lc++]="    fprintf(stderr, \"Network status: Contacting SIP server\\n\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        setup operations common to input and output           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_setup(int srate, int channels, int dir, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j, maxfrag;";
  z[lc++]="";
  z[lc++]="  /******************/";
  z[lc++]="  /* open soundcard */";
  z[lc++]="  /******************/";
  z[lc++]="";
  z[lc++]="  if (asysio_opendevice(dir, toption) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  ";
  z[lc++]="  /**************************************/";
  z[lc++]="  /* set up bidirectional I/O if needed */";
  z[lc++]="  /**************************************/";
  z[lc++]="";
  z[lc++]="  if (dir == ASYSIO_IO)";
  z[lc++]="    {";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_OSTYPE != ASYSIO_FREEBSD)";
  z[lc++]="";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_SETDUPLEX, 0);";
  z[lc++]="";
  z[lc++]="#endif ";
  z[lc++]="";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETCAPS, &j);";
  z[lc++]="";
  z[lc++]="      if (!(j & DSP_CAP_DUPLEX))";
  z[lc++]="	ASYSIO_ERROR_RETURN_NOERRNO(\"Sound card can't do bidirectional audio\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /************************/";
  z[lc++]="  /* range check channels */";
  z[lc++]="  /************************/";
  z[lc++]="";
  z[lc++]="  if (channels > 2)";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO(\"Sound card can't handle > 2 channels\");";
  z[lc++]="";
  z[lc++]="  /*********************/";
  z[lc++]="  /* set fragment size */";
  z[lc++]="  /*********************/";
  z[lc++]="";
  z[lc++]="  j = ASYSIO_LOGFRAGMIN;";
  z[lc++]="  i = ASYSIO_FRAGMIN >> channels;   /* only works for channels = 1, 2 */";
  z[lc++]="";
  z[lc++]="  /* find closest power-of-two fragment size to latency request */";
  z[lc++]="";
  z[lc++]="  while (2*ATIME*i*ASYSO_LNUMBUFF < ASYS_LATENCY)";
  z[lc++]="    {";
  z[lc++]="      i <<= 1;";
  z[lc++]="      j++;";
  z[lc++]="    }";
  z[lc++]="  if ((ATIME*2*i*ASYSO_LNUMBUFF - ASYS_LATENCY) < ";
  z[lc++]="      (ASYS_LATENCY - ATIME*i*ASYSO_LNUMBUFF))";
  z[lc++]="    {";
  z[lc++]="      i <<= 1;";
  z[lc++]="      j++;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  asysio_requested_bsize = 2*i*channels;";
  z[lc++]="";
  z[lc++]="  maxfrag = (ASYS_TIMEOPTION != ASYS_TIMESYNC) ? ASYSO_LNUMBUFF :";
  z[lc++]="             ASYSO_LNUMBUFF + ((ACYCLE/i) + 1);";
  z[lc++]="";
  z[lc++]="  j |= (maxfrag << 16);";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_SETFRAGMENT, &j);";
  z[lc++]="";
  z[lc++]="  /********************/";
  z[lc++]="  /* set audio format */";
  z[lc++]="  /********************/";
  z[lc++]="";
  z[lc++]="  j = ASYSIO_AFORMAT;";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_SETFMT, &j);";
  z[lc++]="";
  z[lc++]="  if (j != ASYSIO_AFORMAT)";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO(\"Soundcard can't handle native shorts\");";
  z[lc++]="";
  z[lc++]="  /****************************************************/";
  z[lc++]="  /* set number of channels -- later add channels > 2 */";
  z[lc++]="  /****************************************************/";
  z[lc++]="";
  z[lc++]="  asysio_channels = channels--;";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_STEREO, &channels);";
  z[lc++]="";
  z[lc++]="  if (channels != (asysio_channels-1))";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO(\"Soundcard can't handle number of channels\");";
  z[lc++]="";
  z[lc++]="  /*********************/";
  z[lc++]="  /* set sampling rate */";
  z[lc++]="  /*********************/";
  z[lc++]="";
  z[lc++]="  asysio_srate = srate;";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_SPEED, &srate);";
  z[lc++]="";
  z[lc++]="  if (abs(asysio_srate - srate) > 1000)";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO(\"Soundcard can't handle sampling rate\");";
  z[lc++]="";
  z[lc++]="  /******************************/";
  z[lc++]="  /* compute actual buffer size */";
  z[lc++]="  /******************************/";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETBLKSIZE, &asysio_bsize);";
  z[lc++]="  asysio_size = asysio_bsize >> 1;";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* print out info screen */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="  if (asysio_screenwriter() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  /*********************************/";
  z[lc++]="  /* set SCHED_FIFO if appropriate */";
  z[lc++]="  /*********************************/";
  z[lc++]="";
  z[lc++]="  if (asysio_initscheduler() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  /**********************************/";
  z[lc++]="  /* set up iloop (heartbeat) timer */";
  z[lc++]="  /**********************************/";
  z[lc++]="";
  z[lc++]="  if (asysio_initiloop() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(int srate, int ochannels, int osample, ";
  z[lc++]="                char * oname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asysio_setup(srate, ochannels, ASYSIO_O, toption) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (!(asyso_buf = (short *)calloc(asysio_size, sizeof(short))))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Can't allocate output buffer\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(int srate, int ichannels, int isample, ";
  z[lc++]="                char * iname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asysio_setup(srate, ichannels, ASYSIO_I, toption) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (!(asysi_buf = (short *)malloc(asysio_bsize)))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Can't allocate input buffer\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(int srate, int ichannels, int ochannels,";
  z[lc++]="                 int isample, int osample, ";
  z[lc++]="                 char * iname, char * oname, int toption)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (ichannels != ochannels)";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO";
  z[lc++]="      (\"Soundcard needs SAOL inchannels == outchannels\");";
  z[lc++]="";
  z[lc++]="  if (asysio_setup(srate, ichannels, ASYSIO_IO, toption) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (!(asysi_buf = (short *)malloc(asysio_bsize)))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Can't allocate input buffer\");";
  z[lc++]="";
  z[lc++]="  if (!(asyso_buf = (short *)calloc(asysio_size, sizeof(short))))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Can't allocate output buffer\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*            input, output, and recovery routines              */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               gets one frame of audio from input             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], int * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int diffcompute, starttime;";
  z[lc++]="  int size, recv, bptr, retry;";
  z[lc++]="";
  z[lc++]="  *isize = asysio_size;";
  z[lc++]="";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    *asys_ibuf = asysi_buf;";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETISPACE, &asysio_info);";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="  if (diffcompute = (asysio_info.bytes < asysio_bsize))";
  z[lc++]="    {  ";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_ptr);";
  z[lc++]="      starttime = asysio_ptr.bytes;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  retry = bptr = 0;";
  z[lc++]="  size = asysio_bsize;";
  z[lc++]="";
  z[lc++]="  while ((recv = read(asysio_fd, &((*asys_ibuf)[bptr]), size)) != size)";
  z[lc++]="    {      ";
  z[lc++]="      if (++retry > ASYSIO_MAXRETRY)";
  z[lc++]="	ASYSIO_ERROR_RETURN(\"Too many I/O retries -- asys_getbuf\");";
  z[lc++]="";
  z[lc++]="      if (recv < 0)  /* errors */";
  z[lc++]="	{";
  z[lc++]="	  if ((errno == EAGAIN) || (errno == EINTR))";
  z[lc++]="	    continue;   ";
  z[lc++]="	  else";
  z[lc++]="	    ASYSIO_ERROR_RETURN(\"Read error on output audio device\");";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  bptr += recv; /* partial read */";
  z[lc++]="	  size -= recv;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="  if (diffcompute)";
  z[lc++]="    {  ";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_ptr);";
  z[lc++]="      asysio_blocktime += (asysio_ptr.bytes - starttime);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int size, sent, bptr, retry;";
  z[lc++]="  int diffcompute, starttime;";
  z[lc++]="";
  z[lc++]="  size = (*osize)*2;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  if (asysio_reset)";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOSPACE, &asysio_info);";
  z[lc++]="";
  z[lc++]="  asysio_reset = (++asysio_puts > ASYSO_LNUMBUFF) && ";
  z[lc++]="    (asysio_info.fragments == asysio_info.fragstotal);";
  z[lc++]="  if (asysio_reset)";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION != ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="  if (diffcompute = (asysio_info.bytes < size))";
  z[lc++]="    {  ";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_ptr);";
  z[lc++]="      starttime = asysio_ptr.bytes;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  retry = bptr = 0;";
  z[lc++]="  while ((sent = write(asysio_fd, &((*asys_obuf)[bptr]), size)) != size)";
  z[lc++]="    {";
  z[lc++]="      if (++retry > ASYSIO_MAXRETRY)";
  z[lc++]="	ASYSIO_ERROR_RETURN(\"Too many I/O retries -- asys_putbuf\");";
  z[lc++]="";
  z[lc++]="      if (sent < 0)  /* errors */";
  z[lc++]="	{";
  z[lc++]="	  if ((errno == EAGAIN) || (errno == EINTR))";
  z[lc++]="	    continue;   ";
  z[lc++]="	  else";
  z[lc++]="	    ASYSIO_ERROR_RETURN(\"Write error on output audio device\");";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  bptr += sent;  /* partial write */";
  z[lc++]="	  size -= sent;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION != ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="  if (diffcompute)";
  z[lc++]="    {  ";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_ptr);";
  z[lc++]="      asysio_blocktime += (asysio_ptr.bytes - starttime);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  *osize = asysio_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asysio_size;";
  z[lc++]="";
  z[lc++]="  for(i = 0; i < ASYSO_LNUMBUFF; i++)";
  z[lc++]="    if (asys_putbuf(asys_obuf, osize) == ASYS_ERROR)";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               recovers from an overrun                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_recover(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int size, recv, bptr, retry;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  asysio_reset = 0;";
  z[lc++]="";
  z[lc++]="  memset(asyso_buf, 0, asysio_bsize);";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* flush input if needed */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETISPACE, &asysi_info);";
  z[lc++]="  ";
  z[lc++]="  while (asysi_info.fragments > 0)";
  z[lc++]="    {";
  z[lc++]="      retry = bptr = 0;";
  z[lc++]="      size = asysio_bsize;";
  z[lc++]="";
  z[lc++]="      while ((recv = read(asysio_fd, &(asysi_buf[bptr]), size)) != size)";
  z[lc++]="	{      ";
  z[lc++]="	  if (++retry > ASYSIO_MAXRETRY)";
  z[lc++]="	    ASYSIO_ERROR_RETURN(\"Too many I/O retries -- asysio_recover\");";
  z[lc++]="";
  z[lc++]="	  if (recv < 0)  /* errors */";
  z[lc++]="	    {";
  z[lc++]="	      if ((errno == EAGAIN) || (errno == EINTR))";
  z[lc++]="		continue;   ";
  z[lc++]="	      else";
  z[lc++]="		ASYSIO_ERROR_RETURN(\"Read error on output audio device\");";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      bptr += recv; /* partial read */";
  z[lc++]="	      size -= recv;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETISPACE, &asysi_info);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  ibusidx = 0;";
  z[lc++]="  if (asys_getbuf(&asys_ibuf, &EV(asys_isize))==ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /**************************************/";
  z[lc++]="  /* fill latency interval with silence */ ";
  z[lc++]="  /**************************************/";
  z[lc++]="";
  z[lc++]="  asysio_puts = 0;";
  z[lc++]="  for(i = 0; i < ASYSO_LNUMBUFF; i++)";
  z[lc++]="    if (asys_putbuf(&asyso_buf, &asysio_size) == ASYS_ERROR)";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*        ksync() system for time synchronization          */ ";
  z[lc++]="/*_________________________________________________________*/";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_KSYNC)";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         initializes k-rate boundaries sync              */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void ksyncinit()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysio_sync_target = asysio_sync_incr = ACYCLE*asysio_channels*2;  ";
  z[lc++]="  asysio_sync_cpuscale = 1.0F/asysio_sync_incr;";
  z[lc++]="";
  z[lc++]="  /* for -timesync, set up SCHED_FIFO watchdog state machine */";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_USEFIFO && (ASYS_TIMEOPTION == ASYS_TIMESYNC))";
  z[lc++]="";
  z[lc++]="  if (asysio_fifo)";
  z[lc++]="";
  z[lc++]="    {";
  z[lc++]="      asysio_sync_state = ASYSIO_SYNC_SCHEDOTHER;";
  z[lc++]="      if (sched_setscheduler(0, SCHED_OTHER, &asysio_otherparam))";
  z[lc++]="	epr(0,NULL,NULL,\"internal error -- sched_other unavailable\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* elsewise, set up SCHED_FIFO monitor to force blocking */";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_USEFIFO && (ASYS_TIMEOPTION != ASYS_TIMESYNC))";
  z[lc++]="";
  z[lc++]="  asysio_sync_noblock = 0;";
  z[lc++]="  asysio_sync_sleeptime.tv_sec = 0;";
  z[lc++]="  asysio_sync_sleeptime.tv_nsec = 2000001;  /* 2ms + epsilon forces block */";
  z[lc++]=" ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*     different ksync()s for -timesync and -playback       */ ";
  z[lc++]="/*__________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION != ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float ret;";
  z[lc++]="  int comptime;";
  z[lc++]="";
  z[lc++]="  if (asysio_reset)";
  z[lc++]="    {";
  z[lc++]="      if (asysio_recover()==ASYS_ERROR)";
  z[lc++]="	epr(0,NULL,NULL, \"Soundcard error -- failed recovery.\");";
  z[lc++]="      asysio_sync_target = asysio_sync_incr;";
  z[lc++]="      ret = 1.0F;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_sync_ptr);";
  z[lc++]="";
  z[lc++]="      if (asysio_sync_target == asysio_sync_incr)";
  z[lc++]="	ret = 0.0F;";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  comptime = asysio_sync_ptr.bytes - asysio_blocktime;";
  z[lc++]="	  if (comptime > asysio_sync_target)";
  z[lc++]="	    ret = 1.0F;";
  z[lc++]="	  else";
  z[lc++]="	    ret = (asysio_sync_cpuscale*";
  z[lc++]="		   (asysio_sync_incr - (asysio_sync_target - comptime)));";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      if ((asysio_sync_target = asysio_sync_incr + asysio_sync_ptr.bytes) < 0)";
  z[lc++]="	epr(0,NULL,NULL,\"Soundcard error -- rollover.\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* reset infinite-loop timer */";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_PROF, &asysio_iloop_timer, NULL) < 0)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"  Runtime Errno Message: %s\\n\", strerror(errno));";
  z[lc++]="      epr(0,NULL,NULL, \"Soundcard error -- Couldn't reset ITIMER_PROF\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO";
  z[lc++]="";
  z[lc++]="  if (asysio_fifo)";
  z[lc++]="    {";
  z[lc++]="      /* let other processes run if pending too long */";
  z[lc++]="";
  z[lc++]="      if (asysio_blocktime)";
  z[lc++]="	asysio_sync_noblock = 0;";
  z[lc++]="      else";
  z[lc++]="	asysio_sync_noblock++;";
  z[lc++]="";
  z[lc++]="      if (asysio_sync_noblock > ASYSIO_MAXBLOCK)";
  z[lc++]="	{";
  z[lc++]="	  nanosleep(&asysio_sync_sleeptime, NULL); ";
  z[lc++]="	  asysio_sync_noblock = 0;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  asysio_blocktime = 0;";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float ret;";
  z[lc++]="  int comptime;";
  z[lc++]="";
  z[lc++]="  if (!asysio_reset)";
  z[lc++]="    {";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_sync_ptr);";
  z[lc++]="      if (asysio_sync_ptr.bytes > asysio_sync_target)";
  z[lc++]="	{";
  z[lc++]="	  comptime = asysio_sync_ptr.bytes - asysio_blocktime;";
  z[lc++]="	  if (comptime < asysio_sync_target)";
  z[lc++]="	    ret = (asysio_sync_cpuscale*";
  z[lc++]="		   (asysio_sync_incr - (asysio_sync_target - comptime)));";
  z[lc++]="	  else";
  z[lc++]="	    ret = 1.0F;";
  z[lc++]="	  ret = (asysio_sync_target != asysio_sync_incr) ? ret : 0.0F;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{	  ";
  z[lc++]="	  comptime = asysio_sync_ptr.bytes - asysio_blocktime;";
  z[lc++]="	  ret = (asysio_sync_cpuscale*";
  z[lc++]="		 (asysio_sync_incr - (asysio_sync_target - comptime)));";
  z[lc++]="	  asysio_reset = asysio_input && ";
  z[lc++]="	    ((asysio_sync_target-asysio_sync_ptr.bytes) == asysio_sync_incr);";
  z[lc++]="	  while ((asysio_sync_ptr.bytes < asysio_sync_target) && !asysio_reset)";
  z[lc++]="	    {  ";
  z[lc++]="	      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOSPACE, &asysio_info);";
  z[lc++]="	      asysio_reset = (asysio_info.fragments == asysio_info.fragstotal);";
  z[lc++]="	      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR,&asysio_sync_ptr);";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  if (asysio_reset)";
  z[lc++]="    {";
  z[lc++]="      if (asysio_recover()==ASYS_ERROR)";
  z[lc++]="	epr(0,NULL,NULL,\"Sound driver error -- failed recovery.\");";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_sync_ptr);";
  z[lc++]="      asysio_sync_target = asysio_sync_ptr.bytes;";
  z[lc++]="      ret = 1.0F;";
  z[lc++]="    }";
  z[lc++]="  if ((asysio_sync_target += asysio_sync_incr) < 0)";
  z[lc++]="    epr(0,NULL,NULL,\"Sound driver error -- rollover.\");";
  z[lc++]="";
  z[lc++]="  /* reset infinite-loop timer */";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_PROF, &asysio_iloop_timer, NULL) < 0)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"  Runtime Errno Message: %s\\n\", strerror(errno));";
  z[lc++]="      epr(0,NULL,NULL, \"Soundcard error -- Couldn't reset ITIMER_PROF\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO";
  z[lc++]="";
  z[lc++]="  if (asysio_fifo)";
  z[lc++]="    {";
  z[lc++]="      switch (asysio_sync_state) {";
  z[lc++]="      case ASYSIO_SYNC_ACTIVE:";
  z[lc++]="	if (!csysi_newnote)";
  z[lc++]="	  {";
  z[lc++]="	    asysio_sync_state = ASYSIO_SYNC_WAITING;";
  z[lc++]="	    asysio_sync_waitstart = time(NULL);";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case ASYSIO_SYNC_WAITING:";
  z[lc++]="	if (csysi_newnote)";
  z[lc++]="	  asysio_sync_state = ASYSIO_SYNC_ACTIVE;";
  z[lc++]="	else";
  z[lc++]="	  if ((time(NULL) - asysio_sync_waitstart) >= ASYSIO_SYNC_TIMEOUT)";
  z[lc++]="	    {";
  z[lc++]="	      asysio_sync_state = ASYSIO_SYNC_SCHEDOTHER;";
  z[lc++]="	      if (sched_setscheduler(0, SCHED_OTHER, &asysio_otherparam))";
  z[lc++]="		epr(0,NULL,NULL,\"internal error -- sched_other unavailable\");";
  z[lc++]="	    }";
  z[lc++]="	break;";
  z[lc++]="      case ASYSIO_SYNC_SCHEDOTHER:";
  z[lc++]="	if (csysi_newnote)";
  z[lc++]="	  {";
  z[lc++]="	    asysio_sync_state = ASYSIO_SYNC_ACTIVE;";
  z[lc++]="	    if (sched_setscheduler(0, SCHED_FIFO, &asysio_fifoparam))";
  z[lc++]="	      fprintf(stderr, \"  Note: Process no longer root, \" ";
  z[lc++]="		      \"improved audio quality no longer possible.\\n\");";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  asysio_blocktime = 0;";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#endif /* ASYS_KSYNC */";
  z[lc++]="";
  z[lc++]="#undef ASYSIO_IOCTL_CALL";
  z[lc++]="#undef ASYSIO_ERROR_RETURN";
  z[lc++]="#undef ASYSIO_ERROR_RETURN_NOERRNO";
  z[lc++]="#undef ASYSIO_LINUX";
  z[lc++]="#undef ASYSIO_FREEBSD";
  z[lc++]="#undef ASYSIO_OSTYPE";
  z[lc++]="#undef ASYSIO_DSPDEV";
  z[lc++]="#undef ASYSIO_AFORMAT";
  z[lc++]="#undef ASYSIO_I  ";
  z[lc++]="#undef ASYSIO_O  ";
  z[lc++]="#undef ASYSIO_IO ";
  z[lc++]="#undef ASYSIO_FRAGMIN";
  z[lc++]="#undef ASYSIO_LOGFRAGMIN ";
  z[lc++]="#undef ASYSO_LNUMBUFF";
  z[lc++]="#undef ASYSIO_MAXRETRY";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                    end of soundcard driver                   */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void makefreebsd(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: merged linux/freebsd audio driver for sfront";
  z[lc++]="#    Copyright (C) 2000  Bertrand Petit";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="#define ASYSIO_LINUX   0";
  z[lc++]="#define ASYSIO_FREEBSD 1";
  z[lc++]="";
  z[lc++]="#define ASYSIO_OSTYPE  ASYSIO_FREEBSD";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                linux audio driver for sfront                 */ ";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="/**************************************************/";
  z[lc++]="/* define flags for fifo mode, and for a timer to */";
  z[lc++]="/* catch SAOL infinite loops                      */";
  z[lc++]="/**************************************************/";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && (ASYSIO_OSTYPE == ASYSIO_LINUX) && \\";
  z[lc++]="     defined(CSYS_CDRIVER_LINMIDI) && (ASYS_TIMEOPTION == ASYS_TIMESYNC) && \\";
  z[lc++]="     !defined(ASYS_HASINPUT))";
  z[lc++]="#define ASYSIO_USEFIFO 1";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && (ASYSIO_OSTYPE == ASYSIO_LINUX) && \\";
  z[lc++]="    (ASYS_TIMEOPTION != ASYS_TIMESYNC))";
  z[lc++]="#define ASYSIO_USEFIFO 1";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef ASYSIO_USEFIFO";
  z[lc++]="#define ASYSIO_USEFIFO 0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/**************************************************/";
  z[lc++]="/* include headers, based on flags set above      */";
  z[lc++]="/**************************************************/";
  z[lc++]="";
  z[lc++]="#include <unistd.h>";
  z[lc++]="#include <sys/ioctl.h>";
  z[lc++]="#include <fcntl.h>";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_OSTYPE == ASYSIO_LINUX)";
  z[lc++]="#include <sys/soundcard.h>";
  z[lc++]="#include <endian.h>";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_OSTYPE == ASYSIO_FREEBSD)";
  z[lc++]="#include <machine/soundcard.h>";
  z[lc++]="#include <machine/endian.h>";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#include <signal.h>  ";
  z[lc++]="#include <sys/time.h>  ";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO";
  z[lc++]="#include <sched.h>  ";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="#include <time.h>";
  z[lc++]="#endif";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/******************************/";
  z[lc++]="/* other constant definitions */";
  z[lc++]="/******************************/";
  z[lc++]="";
  z[lc++]="#ifndef ASYSIO_DSPDEV";
  z[lc++]="#define ASYSIO_DSPDEV \"/dev/dsp\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/* determines native audio format */";
  z[lc++]="";
  z[lc++]="#if (BYTE_ORDER == BIG_ENDIAN)";
  z[lc++]="# define ASYSIO_AFORMAT AFMT_S16_BE";
  z[lc++]="#else";
  z[lc++]="# if (BYTE_ORDER == LITTLE_ENDIAN)";
  z[lc++]="#  define ASYSIO_AFORMAT AFMT_S16_LE";
  z[lc++]="# else";
  z[lc++]="#  error \"BYTE_ORDER not defined?\"";
  z[lc++]="# endif";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/* codes for IO types */";
  z[lc++]="";
  z[lc++]="#define ASYSIO_I  0";
  z[lc++]="#define ASYSIO_O  1";
  z[lc++]="#define ASYSIO_IO 2";
  z[lc++]="";
  z[lc++]="/* minimum fragment size */";
  z[lc++]="";
  z[lc++]="#define ASYSIO_FRAGMIN    16";
  z[lc++]="#define ASYSIO_LOGFRAGMIN 4";
  z[lc++]="";
  z[lc++]="/* number of silence buffers */";
  z[lc++]="";
  z[lc++]="#define ASYSO_LNUMBUFF 4";
  z[lc++]="";
  z[lc++]="/* maximum number of I/O retries before termination */";
  z[lc++]="";
  z[lc++]="#define ASYSIO_MAXRETRY 256";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO                      /* SCHED_FIFO constants for ksync()  */";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="#define ASYSIO_SYNC_TIMEOUT    5        /* idle time to leave SCHED_FIFO     */";
  z[lc++]="#define ASYSIO_SYNC_ACTIVE     0        /* machine states for noteon timeout */";
  z[lc++]="#define ASYSIO_SYNC_WAITING    1";
  z[lc++]="#define ASYSIO_SYNC_SCHEDOTHER 2";
  z[lc++]="#else";
  z[lc++]="#define ASYSIO_MAXBLOCK ((int)EV(KRATE))*2  /* max wait tor let SCHED_OTHERs run */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/************************/";
  z[lc++]="/* variable definitions */";
  z[lc++]="/************************/";
  z[lc++]="";
  z[lc++]="int  asysio_fd;                    /* device pointer */";
  z[lc++]="int asysio_srate;                 /* sampling rate */";
  z[lc++]="int asysio_channels;              /* number of channels */";
  z[lc++]="int asysio_size;                  /* # samples in a buffer */";
  z[lc++]="int asysio_bsize;                 /* actual # bytes in a buffer */            ";
  z[lc++]="int asysio_requested_bsize;       /* requested # bytes in a buffer */        ";
  z[lc++]="int asysio_input;                 /* 1 if ASYSIO */";
  z[lc++]="int asysio_blocktime;             /* time (in bytes) blocked in kcycle */";
  z[lc++]="";
  z[lc++]="struct count_info asysio_ptr;      /* for GET{I,O}*PTR  ioctl calls */";
  z[lc++]="struct audio_buf_info asysio_info; /* for GET{I,O}SPACE ioctl calls */";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="short * asyso_buf = NULL;          /* output buffer */";
  z[lc++]="int asysio_puts;                   /* total number of putbufs */";
  z[lc++]="int asysio_reset;                  /* flags an overrun */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="short * asysi_buf = NULL;          /* input buffer */";
  z[lc++]="struct audio_buf_info asysi_info;  /* input dma status */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="sigset_t asysio_iloop_mask;            /* for masking off iloop interrupt */";
  z[lc++]="struct sigaction asysio_iloop_action;  /* for setting up iloop interrupt  */";
  z[lc++]="struct itimerval asysio_iloop_timer;   /* for setting up iloop timer      */";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO ";
  z[lc++]="int asysio_fifo;                       /* can get into sched_fifo mode */";
  z[lc++]="struct sched_param asysio_fifoparam;   /* param block for fifo mode */";
  z[lc++]="struct sched_param asysio_otherparam;  /* param block for other mode */";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="/* state machine variables for noteon timeout */";
  z[lc++]="int    asysio_sync_state;";
  z[lc++]="time_t asysio_sync_waitstart;";
  z[lc++]="extern int csysi_newnote;       /* from linmidi */";
  z[lc++]="";
  z[lc++]="#else";
  z[lc++]="";
  z[lc++]="/* state to detect long periods w/o blocking */";
  z[lc++]="int asysio_sync_noblock;                /* how many acycles since last block */";
  z[lc++]="struct timespec asysio_sync_sleeptime;  /* time to wait during forced block  */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_KSYNC)                      /* ksync() state */";
  z[lc++]="struct count_info asysio_sync_ptr;           ";
  z[lc++]="int asysio_sync_target, asysio_sync_incr;    ";
  z[lc++]="float asysio_sync_cpuscale;                  ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                      shutdown routines                       */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down soundcard                      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysio_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (ioctl(asysio_fd, SNDCTL_DSP_SYNC, 0) == -1)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"\\nSoundcard Error: SNDCTL_DSP_SYNC Ioctl Problem\\n\");";
  z[lc++]="      fprintf(stderr, \"Errno Message: %s\\n\\n\", strerror(errno));";
  z[lc++]="    }";
  z[lc++]="  close(asysio_fd);";
  z[lc++]="";
  z[lc++]="  /* so that a slow exit doesn't trigger timer */";
  z[lc++]="";
  z[lc++]="  asysio_iloop_timer.it_value.tv_sec = 0;";
  z[lc++]="  asysio_iloop_timer.it_value.tv_usec = 0;";
  z[lc++]="  asysio_iloop_timer.it_interval.tv_sec = 0;";
  z[lc++]="  asysio_iloop_timer.it_interval.tv_usec = 0;";
  z[lc++]="  ";
  z[lc++]="  if (setitimer(ITIMER_PROF, &asysio_iloop_timer, NULL) < 0)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"\\nSoundcard Driver Error:\\n\\n\");";
  z[lc++]="      fprintf(stderr, \"  Couldn't set up ITIMER_PROF timer.\\n\");";
  z[lc++]="      fprintf(stderr, \"  Errno Message: %s\\n\\n\", strerror(errno));";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysio_shutdown();";
  z[lc++]="  if (asyso_buf != NULL)";
  z[lc++]="    free(asyso_buf);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio input                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysio_shutdown();  ";
  z[lc++]="  if (asysi_buf != NULL)";
  z[lc++]="    free(asysi_buf);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysio_shutdown();";
  z[lc++]="  if (asyso_buf != NULL)";
  z[lc++]="    free(asyso_buf);";
  z[lc++]="  if (asysi_buf != NULL)";
  z[lc++]="    free(asysi_buf);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                 initialization routines                      */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*          generic error-checking ioctl wrapper                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="#define ASYSIO_IOCTL_CALL(x,y,z)  do { if (ioctl(x,y,z) == -1){\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s Ioctl Problem\\n\", #y ); \\";
  z[lc++]="      fprintf(stderr, \"  Errno Message: %s\\n\\n\", strerror(errno));\\";
  z[lc++]="      close(asysio_fd); return ASYS_ERROR;}} while (0)";
  z[lc++]="";
  z[lc++]="#define  ASYSIO_ERROR_RETURN(x) do {\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s.\\n\", x);\\";
  z[lc++]="      fprintf(stderr, \"  Errno Message: %s\\n\\n\", strerror(errno));\\";
  z[lc++]="      close(asysio_fd);\\";
  z[lc++]="      return ASYS_ERROR; } while (0)";
  z[lc++]="";
  z[lc++]="#define  ASYSIO_ERROR_RETURN_NOERRNO(x) do {\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s.\\n\", x);\\";
  z[lc++]="      close(asysio_fd);\\";
  z[lc++]="      return ASYS_ERROR; } while (0)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               opens the soudcard device                      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_opendevice(int dir, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  switch(dir) {";
  z[lc++]="  case ASYSIO_I:";
  z[lc++]="    asysio_fd = open(ASYSIO_DSPDEV, O_RDONLY, 0);";
  z[lc++]="    asysio_input = 1;";
  z[lc++]="    break;";
  z[lc++]="  case ASYSIO_O:";
  z[lc++]="    asysio_fd = open(ASYSIO_DSPDEV, O_WRONLY, 0);";
  z[lc++]="    asysio_input = 0;";
  z[lc++]="    break;";
  z[lc++]="  case ASYSIO_IO:";
  z[lc++]="    asysio_fd = open(ASYSIO_DSPDEV, O_RDWR, 0);";
  z[lc++]="    asysio_input = 1;";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    fprintf(stderr, \"  Error: Unexpected dir parameter value in \\n\");";
  z[lc++]="    fprintf(stderr, \"         asysio_setup.\\n\\n\");";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  if (asysio_fd == -1)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"  Error: Can't open device %s (%s)\\n\\n\", ASYSIO_DSPDEV,";
  z[lc++]="	      strerror(errno));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*         signal handler for trapping SAOL infinite loops      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysio_iloop_handler(int signum) ";
  z[lc++]="{   ";
  z[lc++]="  fprintf(stderr, \"  Error: Either\\n\\n\");";
  z[lc++]="  fprintf(stderr, \"    [1] The SAOL program has an infinite loop in it, or\\n\");";
  z[lc++]="  fprintf(stderr, \"    [2] Content is too complex for real-time work.\\n\\n\");";
  z[lc++]="  fprintf(stderr, \"  Exiting program ...\\n\\n\");";
  z[lc++]="  exit(0);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*         initializes iloop (heartbeat) interrupt              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_initiloop(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  /*********************************************************/";
  z[lc++]="  /* set up signal handler for infinite-loop (iloop) timer */";
  z[lc++]="  /*********************************************************/";
  z[lc++]="  ";
  z[lc++]="  if (sigemptyset(&asysio_iloop_action.sa_mask) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't run sigemptyset(iloop) OS call\");";
  z[lc++]="";
  z[lc++]="  /* infinite-loop timer wins over midi overrun timer */";
  z[lc++]="";
  z[lc++]="  if (sigaddset(&asysio_iloop_action.sa_mask, SIGALRM) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't run sigaddset(iloop) OS call\");";
  z[lc++]="";
  z[lc++]="  asysio_iloop_action.sa_flags = SA_RESTART;";
  z[lc++]="  asysio_iloop_action.sa_handler = asysio_iloop_handler;";
  z[lc++]="  ";
  z[lc++]="  if (sigaction(SIGPROF, &asysio_iloop_action, NULL) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't set up SIGPROF signal handler\");";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  /************************/";
  z[lc++]="  /* set up timer and arm */";
  z[lc++]="  /************************/";
  z[lc++]="";
  z[lc++]="  asysio_iloop_timer.it_value.tv_sec = 3;";
  z[lc++]="  asysio_iloop_timer.it_value.tv_usec = 0;";
  z[lc++]="  asysio_iloop_timer.it_interval.tv_sec = 0;";
  z[lc++]="  asysio_iloop_timer.it_interval.tv_usec = 0;";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_PROF, &asysio_iloop_timer, NULL) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't set up ITIMER_PROF timer\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 initializes sched_fifo                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_initscheduler(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO";
  z[lc++]="";
  z[lc++]="  /*******************************/";
  z[lc++]="  /* set up sched_fifo variables */";
  z[lc++]="  /*******************************/";
  z[lc++]="";
  z[lc++]="  memset(&asysio_otherparam, 0, sizeof(struct sched_param));";
  z[lc++]="  memset(&asysio_fifoparam, 0, sizeof(struct sched_param));";
  z[lc++]=" ";
  z[lc++]="  if ((asysio_fifoparam.sched_priority =";
  z[lc++]="       sched_get_priority_max(SCHED_FIFO)) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't get scheduling priority\");";
  z[lc++]="";
  z[lc++]="  asysio_fifoparam.sched_priority--;";
  z[lc++]="";
  z[lc++]="  /********************************/";
  z[lc++]="  /* try to enter sched-fifo mode */";
  z[lc++]="  /********************************/";
  z[lc++]="";
  z[lc++]="  asysio_fifo = !sched_setscheduler(0, SCHED_FIFO, &asysio_fifoparam);";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 prints startup screen                        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_screenwriter(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, found;";
  z[lc++]="  int haslinmidi = 0;";
  z[lc++]="  float actual_latency;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"%s \",  (ASYS_LATENCYTYPE == ASYS_HIGHLATENCY)? ";
  z[lc++]="	  \"Streaming\" : \"Interactive\");";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"%s Audio \", (asysio_channels == 2) ? \"Stereo\" : \"Mono\");";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="  fprintf(stderr, \"%s\", asysio_input ? \"Input/Output\" : \"Output\");";
  z[lc++]="#else";
  z[lc++]="  fprintf(stderr, \"Input\");";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  found = i = 0;";
  z[lc++]="  while (i < csys_sfront_argc)";
  z[lc++]="    {";
  z[lc++]="      if (!(strcmp(csys_sfront_argv[i],\"-bitc\") && ";
  z[lc++]="	    strcmp(csys_sfront_argv[i],\"-bit\") &&";
  z[lc++]="	    strcmp(csys_sfront_argv[i],\"-orc\")))";
  z[lc++]="	{";
  z[lc++]="	  i++;";
  z[lc++]="	  fprintf(stderr, \" for %s\", csys_sfront_argv[i]);";
  z[lc++]="	  found = 1;";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="      i++;";
  z[lc++]="    }";
  z[lc++]="  if (!found)";
  z[lc++]="    fprintf(stderr, \" for UNKNOWN\");";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  i = 0;";
  z[lc++]="  while (i < csys_sfront_argc)";
  z[lc++]="    {";
  z[lc++]="      if (!strcmp(csys_sfront_argv[i],\"-cin\"))";
  z[lc++]="	{";
  z[lc++]="	  i++;";
  z[lc++]="	  fprintf(stderr, \" (-cin %s)\", csys_sfront_argv[i]);";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="      i++;";
  z[lc++]="    }";
  z[lc++]="  fprintf(stderr, \"\\n\\n\");";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(CSYS_CDRIVER_LINMIDI)";
  z[lc++]="";
  z[lc++]="  haslinmidi = 1;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(CSYS_CDRIVER_LINMIDI) || defined(CSYS_CDRIVER_ALSAMIDI)\\";
  z[lc++]="      || defined(CSYS_CDRIVER_ALSASEQ) || defined(CSYS_CDRIVER_ASCII))";
  z[lc++]="";
  z[lc++]="  /* list midi presets available */";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="	  \"MIDI Preset Numbers (use MIDI controller to select):\\n\\n\");";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < CSYS_PRESETNUM; i++)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"%3i. %s\", ";
  z[lc++]="	      csys_presets[i].preset,";
  z[lc++]="	      csys_instr[csys_presets[i].index].name);";
  z[lc++]="      if ((i&1))";
  z[lc++]="	fprintf(stderr, \"\\n\");";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"\\t\\t\");";
  z[lc++]="	  if (i == (CSYS_PRESETNUM-1))";
  z[lc++]="	    fprintf(stderr, \"\\n\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  fprintf(stderr, \"\\n\");";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(CSYS_CDRIVER_ASCII)";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="  \"To play tunes on ASCII keyboard: a-z for notes, 0-9 for MIDI presets,\\n\");";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="  \"cntrl-C exits. If autorepeat interferes, exit and run 'xset -r' (in X).\\n\\n\");";
  z[lc++]="  ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* diagnose best flags to use, and if they are used */";
  z[lc++]="";
  z[lc++]="#ifdef ASYS_HASOUTPUT";
  z[lc++]="";
  z[lc++]="  if ((ASYS_LATENCYTYPE == ASYS_HIGHLATENCY) || asysio_input ||";
  z[lc++]="      (!haslinmidi))";
  z[lc++]="    {";
  z[lc++]="      if (geteuid() || (ASYS_TIMEOPTION == ASYS_TIMESYNC))";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"For best results, make these changes:\\n\"); ";
  z[lc++]="	  fprintf(stderr, \"\\n\");";
  z[lc++]="	  if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="	    fprintf(stderr, \"   * Remove sfront -timesync flag\\n\");";
  z[lc++]="	  if (geteuid())";
  z[lc++]="	    fprintf(stderr, \"   * Run sa.c executable as root.\\n\");";
  z[lc++]="	  fprintf(stderr, \"\\n\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"This application runs best as root (%s), with:\\n\",";
  z[lc++]="	      !geteuid() ? \"which you are\": \"which you aren't\"); ";
  z[lc++]="      fprintf(stderr, \"\\n\");";
  z[lc++]="      fprintf(stderr, \"  [1] Sfront -playback flag. Good audio quality, keeps\\n\");";
  z[lc++]="      fprintf(stderr, \"      the mouse/kbd alive\");";
  z[lc++]="      fprintf(stderr, \"%s.\\n\", (ASYS_TIMEOPTION == ASYS_PLAYBACK) ?";
  z[lc++]="	      \" (currently chosen)\":\"\");";
  z[lc++]="      fprintf(stderr, \"  [2] Sfront -timesync flag. Better quality, console\\n\");";
  z[lc++]="      fprintf(stderr, \"      freezes during MIDI input\");";
  z[lc++]="      fprintf(stderr, \"%s.\\n\", (ASYS_TIMEOPTION == ASYS_TIMESYNC) ?";
  z[lc++]="	      \" (currently chosen)\":\"\");";
  z[lc++]="      fprintf(stderr, \"\\n\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* latency information */";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT))";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOSPACE, &asysio_info);";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"If audio artifacts still occur, try\");";
  z[lc++]="  ";
  z[lc++]="  actual_latency = ATIME*ASYSO_LNUMBUFF*(asysio_size >> (asysio_channels - 1));";
  z[lc++]="  ";
  z[lc++]="  if (asysio_info.fragstotal < ASYSO_LNUMBUFF)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \" sfront -latency %f flag, and see\\n\", ";
  z[lc++]="	      0.5F*actual_latency);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \" sfront -latency %f flag, and see\\n\", ";
  z[lc++]="	      2.0F*actual_latency);";
  z[lc++]="";
  z[lc++]="    }";
  z[lc++]="  if (ASYS_LATENCYTYPE == ASYS_LOWLATENCY)";
  z[lc++]="    fprintf(stderr, \"http://www.cs.berkeley.edu/\"";
  z[lc++]="	    \"~lazzaro/sa/sfman/user/use/index.html#interact\\n\") ;";
  z[lc++]="  else";
  z[lc++]="    fprintf(stderr, \"http://www.cs.berkeley.edu/\"";
  z[lc++]="	    \"~lazzaro/sa/sfman/user/use/index.html#stream\\n\") ;";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"\\n\");";
  z[lc++]="";
  z[lc++]="  if ((asysio_bsize != ASYSIO_FRAGMIN) &&";
  z[lc++]="      (asysio_bsize == asysio_requested_bsize) && ";
  z[lc++]="      (ASYS_LATENCYTYPE == ASYS_LOWLATENCY))";
  z[lc++]="  {";
  z[lc++]="    fprintf(stderr, \"If interactive response is slow, try \");";
  z[lc++]="    fprintf(stderr, \"sfront -latency %f flag.\\n\", 0.5F*actual_latency);";
  z[lc++]="    fprintf(stderr, \"\\n\");";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="  \"USE AT YOUR OWN RISK. Running as root may damage your file system,\\n\");";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="  \"and network use may result in a malicious attack on your machine.\\n\\n\");";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_USEFIFO && (ASYS_TIMEOPTION == ASYS_TIMESYNC))";
  z[lc++]="";
  z[lc++]="  if (!geteuid())";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, ";
  z[lc++]="      \"NOTE: Mouse and keyboard are frozen for %i seconds after a MIDI\\n\",";
  z[lc++]="	      ASYSIO_SYNC_TIMEOUT);";
  z[lc++]="      fprintf(stderr, ";
  z[lc++]="	      \"NoteOn or NoteOff is received. Do not be alarmed.\\n\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  if (NSYS_NET)";
  z[lc++]="    fprintf(stderr, \"Network status: Contacting SIP server\\n\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        setup operations common to input and output           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_setup(int srate, int channels, int dir, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j, maxfrag;";
  z[lc++]="";
  z[lc++]="  /******************/";
  z[lc++]="  /* open soundcard */";
  z[lc++]="  /******************/";
  z[lc++]="";
  z[lc++]="  if (asysio_opendevice(dir, toption) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  ";
  z[lc++]="  /**************************************/";
  z[lc++]="  /* set up bidirectional I/O if needed */";
  z[lc++]="  /**************************************/";
  z[lc++]="";
  z[lc++]="  if (dir == ASYSIO_IO)";
  z[lc++]="    {";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_OSTYPE != ASYSIO_FREEBSD)";
  z[lc++]="";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_SETDUPLEX, 0);";
  z[lc++]="";
  z[lc++]="#endif ";
  z[lc++]="";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETCAPS, &j);";
  z[lc++]="";
  z[lc++]="      if (!(j & DSP_CAP_DUPLEX))";
  z[lc++]="	ASYSIO_ERROR_RETURN_NOERRNO(\"Sound card can't do bidirectional audio\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /************************/";
  z[lc++]="  /* range check channels */";
  z[lc++]="  /************************/";
  z[lc++]="";
  z[lc++]="  if (channels > 2)";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO(\"Sound card can't handle > 2 channels\");";
  z[lc++]="";
  z[lc++]="  /*********************/";
  z[lc++]="  /* set fragment size */";
  z[lc++]="  /*********************/";
  z[lc++]="";
  z[lc++]="  j = ASYSIO_LOGFRAGMIN;";
  z[lc++]="  i = ASYSIO_FRAGMIN >> channels;   /* only works for channels = 1, 2 */";
  z[lc++]="";
  z[lc++]="  /* find closest power-of-two fragment size to latency request */";
  z[lc++]="";
  z[lc++]="  while (2*ATIME*i*ASYSO_LNUMBUFF < ASYS_LATENCY)";
  z[lc++]="    {";
  z[lc++]="      i <<= 1;";
  z[lc++]="      j++;";
  z[lc++]="    }";
  z[lc++]="  if ((ATIME*2*i*ASYSO_LNUMBUFF - ASYS_LATENCY) < ";
  z[lc++]="      (ASYS_LATENCY - ATIME*i*ASYSO_LNUMBUFF))";
  z[lc++]="    {";
  z[lc++]="      i <<= 1;";
  z[lc++]="      j++;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  asysio_requested_bsize = 2*i*channels;";
  z[lc++]="";
  z[lc++]="  maxfrag = (ASYS_TIMEOPTION != ASYS_TIMESYNC) ? ASYSO_LNUMBUFF :";
  z[lc++]="             ASYSO_LNUMBUFF + ((ACYCLE/i) + 1);";
  z[lc++]="";
  z[lc++]="  j |= (maxfrag << 16);";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_SETFRAGMENT, &j);";
  z[lc++]="";
  z[lc++]="  /********************/";
  z[lc++]="  /* set audio format */";
  z[lc++]="  /********************/";
  z[lc++]="";
  z[lc++]="  j = ASYSIO_AFORMAT;";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_SETFMT, &j);";
  z[lc++]="";
  z[lc++]="  if (j != ASYSIO_AFORMAT)";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO(\"Soundcard can't handle native shorts\");";
  z[lc++]="";
  z[lc++]="  /****************************************************/";
  z[lc++]="  /* set number of channels -- later add channels > 2 */";
  z[lc++]="  /****************************************************/";
  z[lc++]="";
  z[lc++]="  asysio_channels = channels--;";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_STEREO, &channels);";
  z[lc++]="";
  z[lc++]="  if (channels != (asysio_channels-1))";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO(\"Soundcard can't handle number of channels\");";
  z[lc++]="";
  z[lc++]="  /*********************/";
  z[lc++]="  /* set sampling rate */";
  z[lc++]="  /*********************/";
  z[lc++]="";
  z[lc++]="  asysio_srate = srate;";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_SPEED, &srate);";
  z[lc++]="";
  z[lc++]="  if (abs(asysio_srate - srate) > 1000)";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO(\"Soundcard can't handle sampling rate\");";
  z[lc++]="";
  z[lc++]="  /******************************/";
  z[lc++]="  /* compute actual buffer size */";
  z[lc++]="  /******************************/";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETBLKSIZE, &asysio_bsize);";
  z[lc++]="  asysio_size = asysio_bsize >> 1;";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* print out info screen */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="  if (asysio_screenwriter() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  /*********************************/";
  z[lc++]="  /* set SCHED_FIFO if appropriate */";
  z[lc++]="  /*********************************/";
  z[lc++]="";
  z[lc++]="  if (asysio_initscheduler() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  /**********************************/";
  z[lc++]="  /* set up iloop (heartbeat) timer */";
  z[lc++]="  /**********************************/";
  z[lc++]="";
  z[lc++]="  if (asysio_initiloop() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(int srate, int ochannels, int osample, ";
  z[lc++]="                char * oname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asysio_setup(srate, ochannels, ASYSIO_O, toption) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (!(asyso_buf = (short *)calloc(asysio_size, sizeof(short))))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Can't allocate output buffer\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(int srate, int ichannels, int isample, ";
  z[lc++]="                char * iname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asysio_setup(srate, ichannels, ASYSIO_I, toption) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (!(asysi_buf = (short *)malloc(asysio_bsize)))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Can't allocate input buffer\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(int srate, int ichannels, int ochannels,";
  z[lc++]="                 int isample, int osample, ";
  z[lc++]="                 char * iname, char * oname, int toption)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (ichannels != ochannels)";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO";
  z[lc++]="      (\"Soundcard needs SAOL inchannels == outchannels\");";
  z[lc++]="";
  z[lc++]="  if (asysio_setup(srate, ichannels, ASYSIO_IO, toption) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (!(asysi_buf = (short *)malloc(asysio_bsize)))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Can't allocate input buffer\");";
  z[lc++]="";
  z[lc++]="  if (!(asyso_buf = (short *)calloc(asysio_size, sizeof(short))))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Can't allocate output buffer\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*            input, output, and recovery routines              */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               gets one frame of audio from input             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], int * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int diffcompute, starttime;";
  z[lc++]="  int size, recv, bptr, retry;";
  z[lc++]="";
  z[lc++]="  *isize = asysio_size;";
  z[lc++]="";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    *asys_ibuf = asysi_buf;";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETISPACE, &asysio_info);";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="  if (diffcompute = (asysio_info.bytes < asysio_bsize))";
  z[lc++]="    {  ";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_ptr);";
  z[lc++]="      starttime = asysio_ptr.bytes;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  retry = bptr = 0;";
  z[lc++]="  size = asysio_bsize;";
  z[lc++]="";
  z[lc++]="  while ((recv = read(asysio_fd, &((*asys_ibuf)[bptr]), size)) != size)";
  z[lc++]="    {      ";
  z[lc++]="      if (++retry > ASYSIO_MAXRETRY)";
  z[lc++]="	ASYSIO_ERROR_RETURN(\"Too many I/O retries -- asys_getbuf\");";
  z[lc++]="";
  z[lc++]="      if (recv < 0)  /* errors */";
  z[lc++]="	{";
  z[lc++]="	  if ((errno == EAGAIN) || (errno == EINTR))";
  z[lc++]="	    continue;   ";
  z[lc++]="	  else";
  z[lc++]="	    ASYSIO_ERROR_RETURN(\"Read error on output audio device\");";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  bptr += recv; /* partial read */";
  z[lc++]="	  size -= recv;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="  if (diffcompute)";
  z[lc++]="    {  ";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_ptr);";
  z[lc++]="      asysio_blocktime += (asysio_ptr.bytes - starttime);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int size, sent, bptr, retry;";
  z[lc++]="  int diffcompute, starttime;";
  z[lc++]="";
  z[lc++]="  size = (*osize)*2;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  if (asysio_reset)";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOSPACE, &asysio_info);";
  z[lc++]="";
  z[lc++]="  asysio_reset = (++asysio_puts > ASYSO_LNUMBUFF) && ";
  z[lc++]="    (asysio_info.fragments == asysio_info.fragstotal);";
  z[lc++]="  if (asysio_reset)";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION != ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="  if (diffcompute = (asysio_info.bytes < size))";
  z[lc++]="    {  ";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_ptr);";
  z[lc++]="      starttime = asysio_ptr.bytes;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  retry = bptr = 0;";
  z[lc++]="  while ((sent = write(asysio_fd, &((*asys_obuf)[bptr]), size)) != size)";
  z[lc++]="    {";
  z[lc++]="      if (++retry > ASYSIO_MAXRETRY)";
  z[lc++]="	ASYSIO_ERROR_RETURN(\"Too many I/O retries -- asys_putbuf\");";
  z[lc++]="";
  z[lc++]="      if (sent < 0)  /* errors */";
  z[lc++]="	{";
  z[lc++]="	  if ((errno == EAGAIN) || (errno == EINTR))";
  z[lc++]="	    continue;   ";
  z[lc++]="	  else";
  z[lc++]="	    ASYSIO_ERROR_RETURN(\"Write error on output audio device\");";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  bptr += sent;  /* partial write */";
  z[lc++]="	  size -= sent;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION != ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="  if (diffcompute)";
  z[lc++]="    {  ";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_ptr);";
  z[lc++]="      asysio_blocktime += (asysio_ptr.bytes - starttime);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  *osize = asysio_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asysio_size;";
  z[lc++]="";
  z[lc++]="  for(i = 0; i < ASYSO_LNUMBUFF; i++)";
  z[lc++]="    if (asys_putbuf(asys_obuf, osize) == ASYS_ERROR)";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               recovers from an overrun                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_recover(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int size, recv, bptr, retry;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  asysio_reset = 0;";
  z[lc++]="";
  z[lc++]="  memset(asyso_buf, 0, asysio_bsize);";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* flush input if needed */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETISPACE, &asysi_info);";
  z[lc++]="  ";
  z[lc++]="  while (asysi_info.fragments > 0)";
  z[lc++]="    {";
  z[lc++]="      retry = bptr = 0;";
  z[lc++]="      size = asysio_bsize;";
  z[lc++]="";
  z[lc++]="      while ((recv = read(asysio_fd, &(asysi_buf[bptr]), size)) != size)";
  z[lc++]="	{      ";
  z[lc++]="	  if (++retry > ASYSIO_MAXRETRY)";
  z[lc++]="	    ASYSIO_ERROR_RETURN(\"Too many I/O retries -- asysio_recover\");";
  z[lc++]="";
  z[lc++]="	  if (recv < 0)  /* errors */";
  z[lc++]="	    {";
  z[lc++]="	      if ((errno == EAGAIN) || (errno == EINTR))";
  z[lc++]="		continue;   ";
  z[lc++]="	      else";
  z[lc++]="		ASYSIO_ERROR_RETURN(\"Read error on output audio device\");";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      bptr += recv; /* partial read */";
  z[lc++]="	      size -= recv;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETISPACE, &asysi_info);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  ibusidx = 0;";
  z[lc++]="  if (asys_getbuf(&asys_ibuf, &EV(asys_isize))==ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /**************************************/";
  z[lc++]="  /* fill latency interval with silence */ ";
  z[lc++]="  /**************************************/";
  z[lc++]="";
  z[lc++]="  asysio_puts = 0;";
  z[lc++]="  for(i = 0; i < ASYSO_LNUMBUFF; i++)";
  z[lc++]="    if (asys_putbuf(&asyso_buf, &asysio_size) == ASYS_ERROR)";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*        ksync() system for time synchronization          */ ";
  z[lc++]="/*_________________________________________________________*/";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_KSYNC)";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         initializes k-rate boundaries sync              */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void ksyncinit()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysio_sync_target = asysio_sync_incr = ACYCLE*asysio_channels*2;  ";
  z[lc++]="  asysio_sync_cpuscale = 1.0F/asysio_sync_incr;";
  z[lc++]="";
  z[lc++]="  /* for -timesync, set up SCHED_FIFO watchdog state machine */";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_USEFIFO && (ASYS_TIMEOPTION == ASYS_TIMESYNC))";
  z[lc++]="";
  z[lc++]="  if (asysio_fifo)";
  z[lc++]="";
  z[lc++]="    {";
  z[lc++]="      asysio_sync_state = ASYSIO_SYNC_SCHEDOTHER;";
  z[lc++]="      if (sched_setscheduler(0, SCHED_OTHER, &asysio_otherparam))";
  z[lc++]="	epr(0,NULL,NULL,\"internal error -- sched_other unavailable\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* elsewise, set up SCHED_FIFO monitor to force blocking */";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_USEFIFO && (ASYS_TIMEOPTION != ASYS_TIMESYNC))";
  z[lc++]="";
  z[lc++]="  asysio_sync_noblock = 0;";
  z[lc++]="  asysio_sync_sleeptime.tv_sec = 0;";
  z[lc++]="  asysio_sync_sleeptime.tv_nsec = 2000001;  /* 2ms + epsilon forces block */";
  z[lc++]=" ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*     different ksync()s for -timesync and -playback       */ ";
  z[lc++]="/*__________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION != ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float ret;";
  z[lc++]="  int comptime;";
  z[lc++]="";
  z[lc++]="  if (asysio_reset)";
  z[lc++]="    {";
  z[lc++]="      if (asysio_recover()==ASYS_ERROR)";
  z[lc++]="	epr(0,NULL,NULL, \"Soundcard error -- failed recovery.\");";
  z[lc++]="      asysio_sync_target = asysio_sync_incr;";
  z[lc++]="      ret = 1.0F;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_sync_ptr);";
  z[lc++]="";
  z[lc++]="      if (asysio_sync_target == asysio_sync_incr)";
  z[lc++]="	ret = 0.0F;";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  comptime = asysio_sync_ptr.bytes - asysio_blocktime;";
  z[lc++]="	  if (comptime > asysio_sync_target)";
  z[lc++]="	    ret = 1.0F;";
  z[lc++]="	  else";
  z[lc++]="	    ret = (asysio_sync_cpuscale*";
  z[lc++]="		   (asysio_sync_incr - (asysio_sync_target - comptime)));";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      if ((asysio_sync_target = asysio_sync_incr + asysio_sync_ptr.bytes) < 0)";
  z[lc++]="	epr(0,NULL,NULL,\"Soundcard error -- rollover.\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* reset infinite-loop timer */";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_PROF, &asysio_iloop_timer, NULL) < 0)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"  Runtime Errno Message: %s\\n\", strerror(errno));";
  z[lc++]="      epr(0,NULL,NULL, \"Soundcard error -- Couldn't reset ITIMER_PROF\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO";
  z[lc++]="";
  z[lc++]="  if (asysio_fifo)";
  z[lc++]="    {";
  z[lc++]="      /* let other processes run if pending too long */";
  z[lc++]="";
  z[lc++]="      if (asysio_blocktime)";
  z[lc++]="	asysio_sync_noblock = 0;";
  z[lc++]="      else";
  z[lc++]="	asysio_sync_noblock++;";
  z[lc++]="";
  z[lc++]="      if (asysio_sync_noblock > ASYSIO_MAXBLOCK)";
  z[lc++]="	{";
  z[lc++]="	  nanosleep(&asysio_sync_sleeptime, NULL); ";
  z[lc++]="	  asysio_sync_noblock = 0;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  asysio_blocktime = 0;";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float ret;";
  z[lc++]="  int comptime;";
  z[lc++]="";
  z[lc++]="  if (!asysio_reset)";
  z[lc++]="    {";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_sync_ptr);";
  z[lc++]="      if (asysio_sync_ptr.bytes > asysio_sync_target)";
  z[lc++]="	{";
  z[lc++]="	  comptime = asysio_sync_ptr.bytes - asysio_blocktime;";
  z[lc++]="	  if (comptime < asysio_sync_target)";
  z[lc++]="	    ret = (asysio_sync_cpuscale*";
  z[lc++]="		   (asysio_sync_incr - (asysio_sync_target - comptime)));";
  z[lc++]="	  else";
  z[lc++]="	    ret = 1.0F;";
  z[lc++]="	  ret = (asysio_sync_target != asysio_sync_incr) ? ret : 0.0F;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{	  ";
  z[lc++]="	  comptime = asysio_sync_ptr.bytes - asysio_blocktime;";
  z[lc++]="	  ret = (asysio_sync_cpuscale*";
  z[lc++]="		 (asysio_sync_incr - (asysio_sync_target - comptime)));";
  z[lc++]="	  asysio_reset = asysio_input && ";
  z[lc++]="	    ((asysio_sync_target-asysio_sync_ptr.bytes) == asysio_sync_incr);";
  z[lc++]="	  while ((asysio_sync_ptr.bytes < asysio_sync_target) && !asysio_reset)";
  z[lc++]="	    {  ";
  z[lc++]="	      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOSPACE, &asysio_info);";
  z[lc++]="	      asysio_reset = (asysio_info.fragments == asysio_info.fragstotal);";
  z[lc++]="	      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR,&asysio_sync_ptr);";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  if (asysio_reset)";
  z[lc++]="    {";
  z[lc++]="      if (asysio_recover()==ASYS_ERROR)";
  z[lc++]="	epr(0,NULL,NULL,\"Sound driver error -- failed recovery.\");";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_sync_ptr);";
  z[lc++]="      asysio_sync_target = asysio_sync_ptr.bytes;";
  z[lc++]="      ret = 1.0F;";
  z[lc++]="    }";
  z[lc++]="  if ((asysio_sync_target += asysio_sync_incr) < 0)";
  z[lc++]="    epr(0,NULL,NULL,\"Sound driver error -- rollover.\");";
  z[lc++]="";
  z[lc++]="  /* reset infinite-loop timer */";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_PROF, &asysio_iloop_timer, NULL) < 0)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"  Runtime Errno Message: %s\\n\", strerror(errno));";
  z[lc++]="      epr(0,NULL,NULL, \"Soundcard error -- Couldn't reset ITIMER_PROF\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO";
  z[lc++]="";
  z[lc++]="  if (asysio_fifo)";
  z[lc++]="    {";
  z[lc++]="      switch (asysio_sync_state) {";
  z[lc++]="      case ASYSIO_SYNC_ACTIVE:";
  z[lc++]="	if (!csysi_newnote)";
  z[lc++]="	  {";
  z[lc++]="	    asysio_sync_state = ASYSIO_SYNC_WAITING;";
  z[lc++]="	    asysio_sync_waitstart = time(NULL);";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case ASYSIO_SYNC_WAITING:";
  z[lc++]="	if (csysi_newnote)";
  z[lc++]="	  asysio_sync_state = ASYSIO_SYNC_ACTIVE;";
  z[lc++]="	else";
  z[lc++]="	  if ((time(NULL) - asysio_sync_waitstart) >= ASYSIO_SYNC_TIMEOUT)";
  z[lc++]="	    {";
  z[lc++]="	      asysio_sync_state = ASYSIO_SYNC_SCHEDOTHER;";
  z[lc++]="	      if (sched_setscheduler(0, SCHED_OTHER, &asysio_otherparam))";
  z[lc++]="		epr(0,NULL,NULL,\"internal error -- sched_other unavailable\");";
  z[lc++]="	    }";
  z[lc++]="	break;";
  z[lc++]="      case ASYSIO_SYNC_SCHEDOTHER:";
  z[lc++]="	if (csysi_newnote)";
  z[lc++]="	  {";
  z[lc++]="	    asysio_sync_state = ASYSIO_SYNC_ACTIVE;";
  z[lc++]="	    if (sched_setscheduler(0, SCHED_FIFO, &asysio_fifoparam))";
  z[lc++]="	      fprintf(stderr, \"  Note: Process no longer root, \" ";
  z[lc++]="		      \"improved audio quality no longer possible.\\n\");";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  asysio_blocktime = 0;";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#endif /* ASYS_KSYNC */";
  z[lc++]="";
  z[lc++]="#undef ASYSIO_IOCTL_CALL";
  z[lc++]="#undef ASYSIO_ERROR_RETURN";
  z[lc++]="#undef ASYSIO_ERROR_RETURN_NOERRNO";
  z[lc++]="#undef ASYSIO_LINUX";
  z[lc++]="#undef ASYSIO_FREEBSD";
  z[lc++]="#undef ASYSIO_OSTYPE";
  z[lc++]="#undef ASYSIO_DSPDEV";
  z[lc++]="#undef ASYSIO_AFORMAT";
  z[lc++]="#undef ASYSIO_I  ";
  z[lc++]="#undef ASYSIO_O  ";
  z[lc++]="#undef ASYSIO_IO ";
  z[lc++]="#undef ASYSIO_FRAGMIN";
  z[lc++]="#undef ASYSIO_LOGFRAGMIN ";
  z[lc++]="#undef ASYSO_LNUMBUFF";
  z[lc++]="#undef ASYSIO_MAXRETRY";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                    end of soundcard driver                   */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void makestd(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: std audio driver for sfront";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           stdin/stdout file audio driver for sfront          */ ";
  z[lc++]="/*      reads/write 16-bit signed shorts in native format       */";
  z[lc++]="/*                     to/from stdout/stdin                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="        ";
  z[lc++]="#include <stdio.h>";
  z[lc++]="#include <string.h>";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asys_ */";
  z[lc++]="";
  z[lc++]="FILE * asyso_fd;     /* output file pointer */";
  z[lc++]="char * asyso_name;   /* name of file  */        ";
  z[lc++]="int asyso_srate;    /* sampling rate */";
  z[lc++]="int asyso_channels; /* number of channels */";
  z[lc++]="int asyso_size;    /* number of samples in a buffer */";
  z[lc++]="int asyso_nsamp;    /* total number of samples written */";
  z[lc++]="short * asyso_buf;   /* output buffer */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asys_ */";
  z[lc++]="";
  z[lc++]="FILE * asysi_fd;     /* input file pointer */";
  z[lc++]="char * asysi_name;   /* name of file  */        ";
  z[lc++]="int asysi_srate;    /* sampling rate */";
  z[lc++]="int asysi_channels; /* number of channels */";
  z[lc++]="int asysi_size;  /* number of samples in a buffer */";
  z[lc++]="int asysi_nsamp;    /* total number of samples written */";
  z[lc++]="short * asysi_buf;   /* output buffer */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio output setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_setup(int srate, int ochannels, int osize, char * oname)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asyso_name = strcpy((char *) calloc(7, sizeof(char)), \"stdout\");";
  z[lc++]="  asyso_fd = stdout;";
  z[lc++]="  asyso_srate = srate;";
  z[lc++]="  asyso_channels = ochannels;";
  z[lc++]="  asyso_size = osize;";
  z[lc++]="  asyso_nsamp = 0;";
  z[lc++]="  asyso_buf = (short *)calloc(osize, sizeof(short));";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio input setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_setup(int srate, int ichannels, int isize, char * iname)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_name = strcpy((char *) calloc(6, sizeof(char)), \"stdin\");";
  z[lc++]="  asysi_fd = stdin;";
  z[lc++]="  asysi_srate = srate;";
  z[lc++]="  asysi_channels = ichannels;";
  z[lc++]="  asysi_size = isize;";
  z[lc++]="  asysi_nsamp = 0;";
  z[lc++]="  asysi_buf = (short *)malloc(sizeof(short)*isize);";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(int srate, int ochannels, int osample, ";
  z[lc++]="                char * oname, int toption)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*EV(ACYCLE), oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(int srate, int ichannels, int isample, ";
  z[lc++]="                char * iname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asysi_setup(srate, ichannels, ASYS_ICHAN*EV(ACYCLE), iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(int srate, int ichannels, int ochannels,";
  z[lc++]="                 int isample, int osample, ";
  z[lc++]="                 char * iname, char * oname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (asysi_setup(srate, ichannels, ASYS_ICHAN*EV(ACYCLE), iname) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*EV(ACYCLE), oname);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             shuts down audio output system                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asyso_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char name[1024];";
  z[lc++]="";
  z[lc++]="  fclose(asyso_fd);";
  z[lc++]="  strcpy(name,asyso_name);";
  z[lc++]="  strcat(name,\".info\");";
  z[lc++]="  asyso_fd = fopen(name,\"w\");";
  z[lc++]="  fprintf(asyso_fd,\"%i\\n\",asyso_srate);";
  z[lc++]="  fprintf(asyso_fd,\"%i\\n\",asyso_channels);";
  z[lc++]="  fprintf(asyso_fd,\"%i\\n\",asyso_nsamp);";
  z[lc++]="  fclose(asyso_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               shuts down audio input system                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysi_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char name[1024];";
  z[lc++]="";
  z[lc++]="  fclose(asysi_fd);";
  z[lc++]="  strcpy(name, asysi_name);";
  z[lc++]="  strcat(name,\".info\");";
  z[lc++]="  asysi_fd = fopen(name,\"w\");";
  z[lc++]="  fprintf(asysi_fd,\"%i\\n\", asysi_srate);";
  z[lc++]="  fprintf(asysi_fd,\"%i\\n\", asysi_channels);";
  z[lc++]="  fprintf(asysi_fd,\"%i\\n\", asysi_nsamp);";
  z[lc++]="  fclose(asysi_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="  ";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (rwrite(*asys_obuf, sizeof(short), *osize, asyso_fd) != *osize)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  asyso_nsamp += *osize;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], int * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    *asys_ibuf = asysi_buf;";
  z[lc++]="  *isize = (int)rread(*asys_ibuf, sizeof(short), asysi_size, asysi_fd);";
  z[lc++]="  asysi_nsamp += *isize;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  printlib(lc);
}


void makevcdat(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: View (a Chipmunk tool) .dat file driver";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             raw file audio driver for sfront                 */ ";
  z[lc++]="/*       reads/writes 16-bit signed shorts in native format     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="        ";
  z[lc++]="#include <stdio.h>";
  z[lc++]="#include <string.h>";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/* default name for output audio file */";
  z[lc++]="#define ASYSO_DEFAULTNAME \"output\"";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asyso_ */";
  z[lc++]="";
  z[lc++]="FILE * asyso_fd[ASYS_OCHAN]; /* output file pointer */";
  z[lc++]="int asyso_srate;            /* sampling rate */";
  z[lc++]="float asyso_stime;           /* sample period */";
  z[lc++]="int asyso_channels;         /* number of channels */";
  z[lc++]="int asyso_size;             /* number of samples in a buffer */";
  z[lc++]="int asyso_nsamp;            /* total number of samples written */";
  z[lc++]="ASYS_OTYPE * asyso_buf;      /* location for output buffer */ ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* default name for output audio file */";
  z[lc++]="#define ASYSI_DEFAULTNAME \"input\"";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asysi_ */";
  z[lc++]="";
  z[lc++]="FILE * asysi_fd;     /* input file pointer */";
  z[lc++]="char * asysi_name;   /* name of file  */        ";
  z[lc++]="int asysi_srate;    /* sampling rate */";
  z[lc++]="int asysi_channels; /* number of channels */";
  z[lc++]="int asysi_size;    /* number of samples in a buffer */";
  z[lc++]="int asysi_nsamp;    /* total number of samples written */";
  z[lc++]="ASYS_ITYPE * asysi_buf;   /* location for input buffer */ ";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio output setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_setup(int srate, int ochannels, int osample, ";
  z[lc++]="		int osize, char * name)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="  char * cname;";
  z[lc++]="  char * nname;";
  z[lc++]="";
  z[lc++]="  /* note: ASYS_OCHAN holds same value as ochannels */";
  z[lc++]="";
  z[lc++]="  if (name == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      if (ASYS_OCHAN == 1)";
  z[lc++]="	{";
  z[lc++]="	  asyso_fd[0] = fopen(name,\"w\");";
  z[lc++]="	  if (asyso_fd[0] == NULL)";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  cname = strcpy((char *)calloc((strlen(name)+1),sizeof(char)), name);";
  z[lc++]="	  cname[((int)strlen(cname))-4]='\\0';";
  z[lc++]="	  nname = (char *) malloc((int)strlen(cname)+8);";
  z[lc++]="	  for(i=0;i < ASYS_OCHAN;i++)";
  z[lc++]="	    {";
  z[lc++]="	      sprintf(nname,\"%s%i.dat\",cname,i+1);";
  z[lc++]="	      asyso_fd[i] = fopen(nname,\"w\");";
  z[lc++]="	      if (asyso_fd[i] == NULL)";
  z[lc++]="		return ASYS_ERROR;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  for(i=0;i<ASYS_OCHAN;i++)";
  z[lc++]="    {";
  z[lc++]="      fprintf(asyso_fd[i],\"1\\n\");";
  z[lc++]="      fprintf(asyso_fd[i],\"# Sa.c channel %i: sample rate %i\\n\\n\",i+1,srate);";
  z[lc++]="      fprintf(asyso_fd[i],\"pairs\\n\");";
  z[lc++]="      fprintf(asyso_fd[i],\"ch%i\\n\",i+1);";
  z[lc++]="      fprintf(asyso_fd[i],\"*\\n\");";
  z[lc++]="      fprintf(asyso_fd[i],\"*\\n\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  asyso_srate = srate;";
  z[lc++]="  asyso_stime = 1.0F/srate;";
  z[lc++]="  asyso_channels = ochannels;";
  z[lc++]="  asyso_size = osize;";
  z[lc++]="  asyso_nsamp = 0;";
  z[lc++]="  asyso_buf = (ASYS_OTYPE *)calloc(osize, sizeof(ASYS_OTYPE));";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio input setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_setup(int srate, int ichannels, int isample, ";
  z[lc++]="		int isize, char * name)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char strbuf[128];";
  z[lc++]="  char * ret;";
  z[lc++]="  char * val;";
  z[lc++]="";
  z[lc++]="  if (name == NULL)";
  z[lc++]="    val = ASYSI_DEFAULTNAME;";
  z[lc++]="  else";
  z[lc++]="    val = name;";
  z[lc++]="  asysi_name = strcpy((char *) calloc((strlen(val)+1),sizeof(char)), val);";
  z[lc++]="  asysi_fd = fopen(asysi_name,\"r\");";
  z[lc++]="  if (asysi_fd == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  ret = fgets(strbuf, 128, asysi_fd);";
  z[lc++]="  while ((strstr(strbuf,\"pairs\") == NULL)||(strbuf[0]=='#'))";
  z[lc++]="    {";
  z[lc++]="      if (ret == NULL)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="      ret = fgets(strbuf, 128, asysi_fd);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (fgets(strbuf, 128, asysi_fd) == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (fgets(strbuf, 128, asysi_fd) == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (fgets(strbuf, 128, asysi_fd) == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  ";
  z[lc++]="  asysi_srate = srate;";
  z[lc++]="  asysi_channels = ichannels;";
  z[lc++]="  asysi_size = isize;";
  z[lc++]="  asysi_nsamp = 0;";
  z[lc++]="  asysi_buf = (ASYS_ITYPE *)malloc(sizeof(ASYS_ITYPE)*isize);";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(int srate, int ochannels, int osample, ";
  z[lc++]="                char * oname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asyso_setup(srate, ochannels, osample, ASYS_OCHAN*EV(ACYCLE), oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(int srate, int ichannels, int isample, ";
  z[lc++]="                char * iname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asysi_setup(srate, ichannels, isample, ASYS_ICHAN*EV(ACYCLE), iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(int srate, int ichannels, int ochannels,";
  z[lc++]="                 int isample, int osample, ";
  z[lc++]="                 char * iname, char * oname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asysi_setup(srate, ichannels, isample, ASYS_ICHAN*EV(ACYCLE),";
  z[lc++]="		  iname) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return asyso_setup(srate, ochannels, osample, ASYS_OCHAN*EV(ACYCLE), oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             shuts down audio output system                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asyso_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  for (i=0;i<ASYS_OCHAN;i++)";
  z[lc++]="    {";
  z[lc++]="      fprintf(asyso_fd[i],\"\\n\");";
  z[lc++]="      fclose(asyso_fd[i]);";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               shuts down audio input system                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysi_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  fclose(asysi_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="  ";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < *osize; i++)";
  z[lc++]="    {";
  z[lc++]="      fprintf(asyso_fd[i % ASYS_OCHAN], \"%f %f\\n\", asyso_nsamp*asyso_stime, ";
  z[lc++]="	      (float)((*asys_obuf)[i]));";
  z[lc++]="      if (!(i%ASYS_OCHAN))";
  z[lc++]="	asyso_nsamp++;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               gets one frame of audio from input             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], int * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float x, y;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    *asys_ibuf = asysi_buf;";
  z[lc++]="  *isize = 0;";
  z[lc++]="  while (*isize < asysi_size)";
  z[lc++]="    {";
  z[lc++]="      if (fscanf(asysi_fd,\"%f%f\",&x, &y) != 2)";
  z[lc++]="	break;";
  z[lc++]="      for (i = 0; i < asysi_channels; i++)";
  z[lc++]="	(*asys_ibuf)[(*isize)++] = (ASYS_ITYPE) y;";
  z[lc++]="    }";
  z[lc++]="  asysi_nsamp += *isize;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  printlib(lc);
}


void makenull(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: null audio driver for sfront (thanks to Michael McGonagle)";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           nullin/nullout file audio driver for sfront        */";
  z[lc++]="/*           for benchmarking and printf()-driven apps          */ ";
  z[lc++]="/****************************************************************/";
  z[lc++]="        ";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asys_ */";
  z[lc++]="";
  z[lc++]="int asyso_size;    /* number of samples in a buffer */";
  z[lc++]="short * asyso_buf;  /* output buffer */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asys_ */";
  z[lc++]="";
  z[lc++]="int asysi_size;     /* number of samples in a buffer */";
  z[lc++]="short * asysi_buf;   /* input buffer */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio output setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_setup(int srate, int ochannels, int osize, char * oname)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asyso_size = osize;";
  z[lc++]="  asyso_buf = (short *)calloc(osize, sizeof(short));";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio input setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_setup(int srate, int ichannels, int isize, char * iname)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_size = isize;";
  z[lc++]="  asysi_buf = (short *)calloc(isize, sizeof(short));";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(int srate, int ochannels, int osample, ";
  z[lc++]="                char * oname, int toption)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*EV(ACYCLE), oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(int srate, int ichannels, int isample, ";
  z[lc++]="                char * iname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asysi_setup(srate, ichannels, ASYS_ICHAN*EV(ACYCLE), iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(int srate, int ichannels, int ochannels,";
  z[lc++]="                 int isample, int osample, ";
  z[lc++]="                 char * iname, char * oname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (asysi_setup(srate, ichannels, ASYS_ICHAN*EV(ACYCLE), iname) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*EV(ACYCLE), oname);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], int * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               gets one frame of audio from input             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], int * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    *asys_ibuf = asysi_buf;";
  z[lc++]="  *isize = asysi_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  printlib(lc);
}


void makeirix(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: IRIX audio driver for sfront";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#    Copyright (C) 2001  Michael Pruett";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#include <dmedia/audio.h>";
  z[lc++]="#include <unistd.h>";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asys_ */";
  z[lc++]="";
  z[lc++]="ALport asyso_port;	/* audio port */";
  z[lc++]="int asyso_size;	/* number of samples in a buffer */";
  z[lc++]="short *asyso_buf;	/* output buffer */";
  z[lc++]="int asyso_channels;	/* number of channels */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asys_ */";
  z[lc++]="";
  z[lc++]="ALport asysi_port;	/* audio port */";
  z[lc++]="int asysi_size;	/* number of samples in a buffer */";
  z[lc++]="short *asysi_buf;	/* input buffer */";
  z[lc++]="int asysi_channels;	/* number of channels */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="static int setrate (ALport port, double rate)";
  z[lc++]="{";
  z[lc++]="	int	res;";
  z[lc++]="	ALpv	params;";
  z[lc++]="";
  z[lc++]="	res = alGetResource(port);";
  z[lc++]="";
  z[lc++]="	params.param = AL_RATE;";
  z[lc++]="	params.value.ll = alDoubleToFixed(rate);";
  z[lc++]="";
  z[lc++]="	if (alSetParams(res, &params, 1) < 0)";
  z[lc++]="	{";
  z[lc++]="		return ASYS_ERROR;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="	return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio output setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_setup (int srate, int ochannels, int osize, char *oname)";
  z[lc++]="{";
  z[lc++]="	ALconfig	config;";
  z[lc++]="";
  z[lc++]="	config = alNewConfig();";
  z[lc++]="";
  z[lc++]="	alSetChannels(config, ochannels);";
  z[lc++]="	alSetWidth(config, AL_SAMPLE_16);";
  z[lc++]="";
  z[lc++]="	asyso_port = alOpenPort(\"sfront\", \"w\", config);";
  z[lc++]="";
  z[lc++]="	alFreeConfig(config);";
  z[lc++]="";
  z[lc++]="	if (asyso_port == NULL)";
  z[lc++]="		return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="	if (setrate(asyso_port, srate) != ASYS_DONE)";
  z[lc++]="		return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="	asyso_channels = ochannels;";
  z[lc++]="	asyso_size = osize;";
  z[lc++]="	asyso_buf = (short *) calloc(osize, sizeof (short));";
  z[lc++]="	return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio input setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_setup(int srate, int ichannels, int isize, char *iname)";
  z[lc++]="{";
  z[lc++]="	ALconfig	config;";
  z[lc++]="";
  z[lc++]="	config = alNewConfig();";
  z[lc++]="";
  z[lc++]="	alSetChannels(config, ichannels);";
  z[lc++]="	alSetWidth(config, AL_SAMPLE_16);";
  z[lc++]="";
  z[lc++]="	asysi_port = alOpenPort(\"sfront\", \"r\", config);";
  z[lc++]="";
  z[lc++]="	alFreeConfig(config);";
  z[lc++]="";
  z[lc++]="	if (asysi_port == NULL)";
  z[lc++]="		return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="	if (setrate(asysi_port, srate) != ASYS_DONE)";
  z[lc++]="		return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="	asysi_channels = ichannels;";
  z[lc++]="	asysi_size = isize;";
  z[lc++]="	asysi_buf = (short *) calloc(isize, sizeof (short));";
  z[lc++]="	return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup (int srate, int ochannels, int osample,";
  z[lc++]="	char *oname, int toption)";
  z[lc++]="{";
  z[lc++]="	return asyso_setup(srate, ochannels, ASYS_OCHAN*ACYCLE, oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(int srate, int ichannels, int isample,";
  z[lc++]="	char *iname, int toption)";
  z[lc++]="{";
  z[lc++]="	return asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup (int srate, int ichannels, int ochannels,";
  z[lc++]="	int isample, int osample,";
  z[lc++]="	char *iname, char *oname, int toption)";
  z[lc++]="{";
  z[lc++]="	int	result;";
  z[lc++]="";
  z[lc++]="	result = asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname);";
  z[lc++]="";
  z[lc++]="	if (result != ASYS_DONE)";
  z[lc++]="		return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="	return asyso_setup(srate, ochannels, ASYS_OCHAN*ACYCLE, oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="{";
  z[lc++]="	while (alGetFilled(asyso_port) > 0)";
  z[lc++]="		sginap(1);";
  z[lc++]="";
  z[lc++]="	alClosePort(asyso_port);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="{";
  z[lc++]="	alClosePort(asysi_port);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="{";
  z[lc++]="	alClosePort(asysi_port);";
  z[lc++]="";
  z[lc++]="	while (alGetFilled(asyso_port) > 0)";
  z[lc++]="		sginap(1);";
  z[lc++]="";
  z[lc++]="	alClosePort(asyso_port);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble (ASYS_OTYPE *asys_obuf[], int *osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="	*asys_obuf = asyso_buf;";
  z[lc++]="	*osize = asyso_size;";
  z[lc++]="";
  z[lc++]="	alZeroFrames(asyso_port, *osize);";
  z[lc++]="";
  z[lc++]="	return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf (ASYS_OTYPE *asys_obuf[], int *osize)";
  z[lc++]="{";
  z[lc++]="	*osize = asyso_size;";
  z[lc++]="";
  z[lc++]="	alWriteFrames(asyso_port, *asys_obuf, *osize / asyso_channels);";
  z[lc++]="";
  z[lc++]="	return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               gets one frame of audio from input             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf (ASYS_ITYPE *asys_ibuf[], int *isize)";
  z[lc++]="{";
  z[lc++]="	if (*asys_ibuf == NULL)";
  z[lc++]="		*asys_ibuf = asysi_buf;";
  z[lc++]="	*isize = asysi_size;";
  z[lc++]="";
  z[lc++]="	alReadFrames(asysi_port, *asys_ibuf, *isize / asysi_channels);";
  z[lc++]="";
  z[lc++]="	return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  printlib(lc);
}


void makeportaudio(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: portaudio audio driver for sfront";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             wav file audio driver for sfront                 */ ";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="#define ASYSN_PORTAUDIO_DEBUG        0    /* 1 for debug printouts */";
  z[lc++]="        ";
  z[lc++]="#define ASYSN_PORTAUDIO_SLEEPMS    250    /* exit check interval */";
  z[lc++]="";
  z[lc++]="#define ASYSN_PORTAUDIO_BUFFMIN      2    /* at least double buffer   */";
  z[lc++]="#define ASYSN_PORTAUDIO_BUFFDEFAULT  4    /* known to work well       */";
  z[lc++]="#define ASYSN_PORTAUDIO_BUFFMAX      6    /* avoid huge buffer counts */";
  z[lc++]="#define ASYSN_PORTAUDIO_LATENCYMAX 0.5    /* 500ms maximum latency    */";
  z[lc++]="";
  z[lc++]="PaStream * asysn_portaudio_fd;";
  z[lc++]="int asysn_portaudio_silence;";
  z[lc++]="volatile int asysn_portaudio_done;";
  z[lc++]="";
  z[lc++]="/* state for passive input driver */";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="ASYS_ITYPE * asysn_portaudio_ibuf;";
  z[lc++]="int asysn_portaudio_iptr;";
  z[lc++]="int asysn_portaudio_ilast;";
  z[lc++]="int asysn_portaudio_ileft;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/* state for passive output driver */";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASOUTPUT))";
  z[lc++]="";
  z[lc++]="ASYS_OTYPE * asysn_portaudio_obuf;";
  z[lc++]="int asysn_portaudio_optr;";
  z[lc++]="int asysn_portaudio_olast;";
  z[lc++]="int asysn_portaudio_oleft;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*       callback functions for different scenareos              */";
  z[lc++]="/*_______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_O)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*            output-only callback function                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_portaudio_callback(void * inputBuffer, void * outputBuffer,";
  z[lc++]="			     unsigned long framesPerBuffer, ";
  z[lc++]="			     PaTimestamp outTime, void *userData)";
  z[lc++]="{";
  z[lc++]="  int optr = 0;";
  z[lc++]="  int oleft = (int) (framesPerBuffer * ASYS_OCHAN);";
  z[lc++]="  float * obuf = (float *) outputBuffer;";
  z[lc++]="  int osize;";
  z[lc++]="";
  z[lc++]="  if ((asysn_portaudio_done == ASYS_DONE) && (asysn_portaudio_silence == 0))";
  z[lc++]="    {";
  z[lc++]="      do ";
  z[lc++]="	{";
  z[lc++]="	  osize = oleft;";
  z[lc++]="	  asysn_portaudio_done = asys_orun(&(obuf[optr]), &osize);";
  z[lc++]="	  optr += osize;";
  z[lc++]="	  oleft -= osize;";
  z[lc++]="	} ";
  z[lc++]="      while ((asysn_portaudio_done == ASYS_DONE) && (oleft > 0));";
  z[lc++]="";
  z[lc++]="      if (oleft > 0)";
  z[lc++]="	memset(&(obuf[optr]), 0, sizeof(float)*oleft);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      memset(outputBuffer, 0, sizeof(float)*oleft);";
  z[lc++]="      if (asysn_portaudio_silence)";
  z[lc++]="	asysn_portaudio_silence--;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_IO)";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*       Portaudio input and output callback function           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_portaudio_callback(void * inputBuffer, void * outputBuffer,";
  z[lc++]="			     unsigned long framesPerBuffer, ";
  z[lc++]="			     PaTimestamp outTime, void *userData)";
  z[lc++]="{";
  z[lc++]="  int ileft = (int) (framesPerBuffer * ASYS_ICHAN);";
  z[lc++]="  int oleft = (int) (framesPerBuffer * ASYS_OCHAN);";
  z[lc++]="  float * ibuf = (float *) inputBuffer;";
  z[lc++]="  float * obuf = (float *) outputBuffer;";
  z[lc++]="  int isize, osize;";
  z[lc++]="";
  z[lc++]="  isize = ileft;";
  z[lc++]="  osize = oleft;";
  z[lc++]="";
  z[lc++]="  if ((asysn_portaudio_done == ASYS_DONE) && (asysn_portaudio_silence == 0))";
  z[lc++]="    {";
  z[lc++]="      asysn_portaudio_done = asys_iorun(ibuf, &isize, obuf, &osize);";
  z[lc++]="";
  z[lc++]="      if (osize < oleft)";
  z[lc++]="	memset(&(obuf[osize]), 0, sizeof(float)*(oleft - osize));";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      memset(outputBuffer, 0, sizeof(float)*oleft);";
  z[lc++]="      if (asysn_portaudio_silence)";
  z[lc++]="	asysn_portaudio_silence--;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*       Portaudio output, passive input callback function      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_portaudio_callback(void * inputBuffer, void * outputBuffer,";
  z[lc++]="			     unsigned long framesPerBuffer, ";
  z[lc++]="			     PaTimestamp outTime, void *userData)";
  z[lc++]="{";
  z[lc++]="  int isize, osize;";
  z[lc++]="  int optr = 0;";
  z[lc++]="  int oleft = (int) (framesPerBuffer * ASYS_OCHAN);";
  z[lc++]="  float * obuf = (float *) outputBuffer;";
  z[lc++]="";
  z[lc++]="  if ((asysn_portaudio_done == ASYS_DONE) && (asysn_portaudio_silence == 0))";
  z[lc++]="    {";
  z[lc++]="      do ";
  z[lc++]="	{";
  z[lc++]="	  if (asysn_portaudio_ileft == 0)";
  z[lc++]="	    {  ";
  z[lc++]="	      if ((asys_getbuf(&asysn_portaudio_ibuf, &asysn_portaudio_ilast) ";
  z[lc++]="		   != ASYS_DONE) || (asysn_portaudio_ilast == 0))";
  z[lc++]="		{";
  z[lc++]="		  asysn_portaudio_done = ASYS_EXIT;";
  z[lc++]="		  break;";
  z[lc++]="		}";
  z[lc++]="	      asysn_portaudio_iptr  = 0;";
  z[lc++]="	      asysn_portaudio_ileft = asysn_portaudio_ilast;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  isize = asysn_portaudio_ileft;";
  z[lc++]="	  osize = oleft;";
  z[lc++]="	  asysn_portaudio_done = asys_iorun(&(asysn_portaudio_ibuf";
  z[lc++]="					      [asysn_portaudio_iptr]),";
  z[lc++]="					    &isize, &(obuf[optr]), &osize);";
  z[lc++]="	  asysn_portaudio_iptr += isize;";
  z[lc++]="	  asysn_portaudio_ileft -= isize;";
  z[lc++]="	  optr += osize;";
  z[lc++]="	  oleft -= osize;";
  z[lc++]="	}";
  z[lc++]="      while ((asysn_portaudio_done == ASYS_DONE) && (oleft > 0));";
  z[lc++]="";
  z[lc++]="      if (oleft > 0)";
  z[lc++]="	memset(&(obuf[optr]), 0, sizeof(float)*oleft);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      memset(outputBuffer, 0, sizeof(float)*oleft);";
  z[lc++]="      if (asysn_portaudio_silence)";
  z[lc++]="	asysn_portaudio_silence--;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*       Portaudio input, passive output callback function      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_portaudio_callback(void * inputBuffer, void * outputBuffer,";
  z[lc++]="			     unsigned long framesPerBuffer, ";
  z[lc++]="			     PaTimestamp outTime, void *userData)";
  z[lc++]="{";
  z[lc++]="  int isize, osize;";
  z[lc++]="  int iptr = 0;";
  z[lc++]="  int ileft = (int) (framesPerBuffer * ASYS_ICHAN);";
  z[lc++]="  float * ibuf = (float *) inputBuffer;";
  z[lc++]="";
  z[lc++]="  while ((asysn_portaudio_done == ASYS_DONE) && ileft)";
  z[lc++]="    {";
  z[lc++]="      isize = ileft;";
  z[lc++]="      osize = asysn_portaudio_oleft;";
  z[lc++]="";
  z[lc++]="      asysn_portaudio_done = asys_iorun(&(ibuf[iptr]), &isize,";
  z[lc++]="					&(asysn_portaudio_obuf";
  z[lc++]="					  [asysn_portaudio_optr]), &osize);";
  z[lc++]="";
  z[lc++]="      if (asysn_portaudio_done == ASYS_DONE)";
  z[lc++]="	{";
  z[lc++]="	  asysn_portaudio_optr  += osize;";
  z[lc++]="	  asysn_portaudio_oleft -= osize;";
  z[lc++]="	  iptr  += isize;";
  z[lc++]="	  ileft -= isize;";
  z[lc++]="";
  z[lc++]="	  if (asysn_portaudio_oleft == 0)";
  z[lc++]="	    {";
  z[lc++]="	      if (asys_putbuf(&asysn_portaudio_obuf, &asysn_portaudio_olast)";
  z[lc++]="		  == ASYS_DONE)";
  z[lc++]="		{";
  z[lc++]="		  asysn_portaudio_oleft = asysn_portaudio_olast;";
  z[lc++]="		  asysn_portaudio_optr  = 0;";
  z[lc++]="		}";
  z[lc++]="	      else";
  z[lc++]="		asysn_portaudio_done = ASYS_EXIT;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  osize = asysn_portaudio_olast - asysn_portaudio_oleft;";
  z[lc++]="	  asys_putbuf(&asysn_portaudio_obuf, &osize);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               initialize Portaudio system                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_portaudio_init(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  PaError err;";
  z[lc++]="";
  z[lc++]="  if ((err = Pa_Initialize()) != paNoError)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: PortAudio initialization failure (%s).\\n\", ";
  z[lc++]="	      Pa_GetErrorText(err));";
  z[lc++]="      if (err == paHostError)";
  z[lc++]="	fprintf(stderr, \"     : Native error (%s).\\n\", strerror(errno));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              check default output suitability                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_portaudio_outcheck(double * srate, int ochannels, PaDeviceID * pid)";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  const PaDeviceInfo * pidinfo;";
  z[lc++]="  PaError err;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  if ((*pid = Pa_GetDefaultOutputDeviceID()) == paNoDevice)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: No PortAudio output device.\\n\");";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((pidinfo = Pa_GetDeviceInfo(*pid)) == NULL)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: Bad PortAudio default output ID.\\n\");";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (pidinfo->maxOutputChannels < ochannels)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: SAOL outchannels %i > soundcard limit %i.\\n\",";
  z[lc++]="	      ochannels, pidinfo->maxOutputChannels);";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (pidinfo->numSampleRates == -1)";
  z[lc++]="    {";
  z[lc++]="      if ((*srate < pidinfo->sampleRates[0]) ||";
  z[lc++]="	  (*srate > pidinfo->sampleRates[1]))";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"Error: SAOL srate %lf > outside PortAudio range \"";
  z[lc++]="		  \"[%lf, %lf].\\n\", *srate, pidinfo->sampleRates[0],";
  z[lc++]="		  pidinfo->sampleRates[1]);";
  z[lc++]="	  return ASYS_ERROR;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      err = paHostError;";
  z[lc++]="      for (i = 0; i < pidinfo->numSampleRates; i++)";
  z[lc++]="	if (*srate == pidinfo->sampleRates[i])";
  z[lc++]="	  {";
  z[lc++]="	    err = paNoError;";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="      /* later add approximate check */";
  z[lc++]="      ";
  z[lc++]="      if (err == paHostError)";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"Error: SAOL srate %lf not among PortAudio rates \",";
  z[lc++]="		  *srate);";
  z[lc++]="	  for (i = 0; i < pidinfo->numSampleRates; i++)";
  z[lc++]="	    fprintf(stderr, \"%lf \", pidinfo->sampleRates[i]);";
  z[lc++]="	  fprintf(stderr, \"\\n\");";
  z[lc++]="	  return ASYS_ERROR;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              check default input suitability                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_portaudio_incheck(double * srate, int ichannels, PaDeviceID * pid)";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  const PaDeviceInfo * pidinfo;";
  z[lc++]="  PaError err;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  if ((*pid = Pa_GetDefaultInputDeviceID()) == paNoDevice)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: No PortAudio input device.\\n\");";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((pidinfo = Pa_GetDeviceInfo(*pid)) == NULL)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: Bad PortAudio default input ID.\\n\");";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (pidinfo->maxInputChannels < ichannels)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: SAOL inchannels %i > soundcard limit %i.\\n\",";
  z[lc++]="	      ichannels, pidinfo->maxInputChannels);";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (pidinfo->numSampleRates == -1)";
  z[lc++]="    {";
  z[lc++]="      if ((*srate < pidinfo->sampleRates[0]) ||";
  z[lc++]="	  (*srate > pidinfo->sampleRates[1]))";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"Error: SAOL srate %lf > outside PortAudio irange \"";
  z[lc++]="		  \"[%lf, %lf].\\n\", *srate, pidinfo->sampleRates[0],";
  z[lc++]="		  pidinfo->sampleRates[1]);";
  z[lc++]="	  return ASYS_ERROR;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      err = paHostError;";
  z[lc++]="      for (i = 0; i < pidinfo->numSampleRates; i++)";
  z[lc++]="	if (*srate == pidinfo->sampleRates[i])";
  z[lc++]="	  {";
  z[lc++]="	    err = paNoError;";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="      /* later add approximate check */";
  z[lc++]="      ";
  z[lc++]="      if (err == paHostError)";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"Error: SAOL srate %lf not among PortAudio irates \",";
  z[lc++]="		  *srate);";
  z[lc++]="	  for (i = 0; i < pidinfo->numSampleRates; i++)";
  z[lc++]="	    fprintf(stderr, \"%lf \", pidinfo->sampleRates[i]);";
  z[lc++]="	  fprintf(stderr, \"\\n\");";
  z[lc++]="	  return ASYS_ERROR;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                determine buffer parameters                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_portaudio_buffparam(unsigned long * framesPerBuffer,";
  z[lc++]="			      unsigned long * numberOfBuffers,";
  z[lc++]="			      double samplerate)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  double totframes, maxframes;";
  z[lc++]="  unsigned long num;";
  z[lc++]="  int i, found;";
  z[lc++]="";
  z[lc++]="  /* high-latency mac_carbon needs special treatment */";
  z[lc++]="";
  z[lc++]="#ifdef ASYS_OUTDRIVER_MAC_CARBON";
  z[lc++]="";
  z[lc++]="  if (ASYS_LATENCYTYPE == ASYS_HIGHLATENCY)";
  z[lc++]="    {";
  z[lc++]="      *numberOfBuffers = 10;";
  z[lc++]="      *framesPerBuffer = (ASYS_LATENCY/ATIME)/(*numberOfBuffers);";
  z[lc++]="      return ASYS_DONE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* used for windows and low-latency mac_carbon */";
  z[lc++]="";
  z[lc++]="  *numberOfBuffers = ASYSN_PORTAUDIO_BUFFDEFAULT;";
  z[lc++]="  totframes = ASYS_LATENCY/ATIME;";
  z[lc++]="  maxframes = ASYSN_PORTAUDIO_LATENCYMAX/ATIME;";
  z[lc++]="  found = 0;";
  z[lc++]="";
  z[lc++]="  do {";
  z[lc++]="";
  z[lc++]="    *framesPerBuffer = (unsigned long) (totframes/(*numberOfBuffers));";
  z[lc++]="  ";
  z[lc++]="    for (i = 1; i < *framesPerBuffer; i *= 2)";
  z[lc++]="      if ((*framesPerBuffer >= i) && (*framesPerBuffer <= i*2))";
  z[lc++]="	{";
  z[lc++]="	  *framesPerBuffer = (((*framesPerBuffer - i) ";
  z[lc++]="			       < (2*i - *framesPerBuffer)) ? i : 2*i);";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="    num = Pa_GetMinNumBuffers(*framesPerBuffer, samplerate);";
  z[lc++]="";
  z[lc++]="    if (num <= *numberOfBuffers)";
  z[lc++]="      found = 1;";
  z[lc++]="    else";
  z[lc++]="      totframes *= 2;";
  z[lc++]="";
  z[lc++]="  } while ((found == 0) && (totframes < maxframes));";
  z[lc++]="";
  z[lc++]="  /* handle a driver with broken Pa_GetMinNumBuffers() */";
  z[lc++]="  ";
  z[lc++]="  if (found == 0)";
  z[lc++]="    {";
  z[lc++]="      *numberOfBuffers = ASYSN_PORTAUDIO_BUFFDEFAULT;";
  z[lc++]="      *framesPerBuffer = (ASYS_LATENCY/ATIME)/(*numberOfBuffers);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  asysn_portaudio_silence = *numberOfBuffers;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*  portaudio output only: a ASYS_ACTIVE_IO, all ASYS_ACTIVE_O  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(int srate, int ochannels, int osample, ";
  z[lc++]="		char * oname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  double samplerate = (double) srate;";
  z[lc++]="  unsigned long framesPerBuffer;";
  z[lc++]="  unsigned long numberOfBuffers;";
  z[lc++]="  PaDeviceID opid;";
  z[lc++]="  PaError err;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_init() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_outcheck(&samplerate, ochannels, &opid) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_buffparam(&framesPerBuffer, ";
  z[lc++]="				&numberOfBuffers, samplerate) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  err = Pa_OpenStream(&asysn_portaudio_fd, ";
  z[lc++]="		      paNoDevice,   0, paFloat32, NULL, ";
  z[lc++]="		      opid, ochannels, paFloat32, NULL, ";
  z[lc++]="		      samplerate, framesPerBuffer, numberOfBuffers, ";
  z[lc++]="		      paClipOff | paDitherOff, asysn_portaudio_callback, NULL);";
  z[lc++]="		      ";
  z[lc++]="  if (err != paNoError)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: Cannot open PortAudio stream (%s).\\n\", ";
  z[lc++]="	      Pa_GetErrorText(err));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (ASYSN_PORTAUDIO_DEBUG)";
  z[lc++]="    {";
  z[lc++]="      printf(\"Opening output-only Portaudio stream, %i channels\\n\"";
  z[lc++]="	     \"sample rate %lf, %lu buffers of frame size %lu\\n\",";
  z[lc++]="	     ochannels, samplerate, numberOfBuffers, framesPerBuffer);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/* portaudio input only: a ASYS_ACTIVE_IO case                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(int srate, int ichannels, int isample, ";
  z[lc++]="		char * iname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  double samplerate = (double) srate;";
  z[lc++]="  unsigned long framesPerBuffer;";
  z[lc++]="  unsigned long numberOfBuffers;";
  z[lc++]="  PaDeviceID ipid;";
  z[lc++]="  PaError err;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_init() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_incheck(&samplerate, ichannels, &ipid) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_buffparam(&framesPerBuffer, ";
  z[lc++]="				&numberOfBuffers, samplerate) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  err = Pa_OpenStream(&asysn_portaudio_fd, ";
  z[lc++]="		      ipid, ichannels, paFloat32, NULL,";
  z[lc++]="		      paNoDevice,   0, paFloat32, NULL, ";
  z[lc++]="		      samplerate, framesPerBuffer, numberOfBuffers, ";
  z[lc++]="		      paClipOff | paDitherOff, asysn_portaudio_callback, NULL);";
  z[lc++]="		      ";
  z[lc++]="  if (err != paNoError)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: Cannot open PortAudio stream (%s).\\n\", ";
  z[lc++]="	      Pa_GetErrorText(err));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   portaudio input and output: a ASYS_ACTIVE_IO case          */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(int srate, int ichannels, int ochannels,";
  z[lc++]="		 int isample, int osample, ";
  z[lc++]="		 char * iname, char * oname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  double osamplerate = (double) srate;";
  z[lc++]="  unsigned long framesPerBuffer;";
  z[lc++]="  unsigned long numberOfBuffers;";
  z[lc++]="  PaDeviceID opid, ipid;";
  z[lc++]="  double isamplerate;";
  z[lc++]="  PaError err;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_init() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_outcheck(&osamplerate, ochannels, &opid) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  isamplerate = osamplerate;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_incheck(&isamplerate, ichannels, &ipid) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_buffparam(&framesPerBuffer, ";
  z[lc++]="				&numberOfBuffers, isamplerate) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  err = Pa_OpenStream(&asysn_portaudio_fd, ";
  z[lc++]="		      ipid, ichannels, paFloat32, NULL, ";
  z[lc++]="		      opid, ochannels, paFloat32, NULL, ";
  z[lc++]="		      isamplerate, framesPerBuffer, numberOfBuffers,";
  z[lc++]="		      paClipOff | paDitherOff, asysn_portaudio_callback, NULL);";
  z[lc++]="		      ";
  z[lc++]="  if (err != paNoError)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: Cannot open PortAudio stream (%s).\\n\", ";
  z[lc++]="	      Pa_GetErrorText(err));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*       common shutdown routine for all I/O combinations       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_portaudio_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int status = Pa_StreamActive(asysn_portaudio_fd);";
  z[lc++]="";
  z[lc++]="  if (status == 1)";
  z[lc++]="    {";
  z[lc++]="      Pa_StopStream(asysn_portaudio_fd);";
  z[lc++]="      status = Pa_StreamActive(asysn_portaudio_fd);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (status == 0)";
  z[lc++]="    Pa_CloseStream(asysn_portaudio_fd);";
  z[lc++]="";
  z[lc++]="  Pa_Terminate();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysn_portaudio_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysn_portaudio_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysn_portaudio_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*          active audio main -- works for all I/O types        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_main(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysn_portaudio_done = ASYS_DONE;";
  z[lc++]="";
  z[lc++]="  /* initialize passive audio input driver, if needed */";
  z[lc++]="  ";
  z[lc++]="#if (defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="  asysn_portaudio_ibuf = NULL;";
  z[lc++]="  asysn_portaudio_iptr  = 0;";
  z[lc++]="  asysn_portaudio_ilast = 0;";
  z[lc++]="";
  z[lc++]="  if ((asys_getbuf(&asysn_portaudio_ibuf, &asysn_portaudio_ilast) ";
  z[lc++]="       != ASYS_DONE) || (asysn_portaudio_ilast == 0))";
  z[lc++]="    return;";
  z[lc++]="  asysn_portaudio_ileft = asysn_portaudio_ilast;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* initialize passive audio output driver, if needed */";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASOUTPUT))";
  z[lc++]="";
  z[lc++]="  asysn_portaudio_obuf = NULL;";
  z[lc++]="  asysn_portaudio_optr  = 0;";
  z[lc++]="  asysn_portaudio_olast = 0;";
  z[lc++]="";
  z[lc++]="  if (asys_preamble(&asysn_portaudio_obuf,&asysn_portaudio_olast) != ASYS_DONE)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  asysn_portaudio_oleft = asysn_portaudio_olast;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  if (Pa_StartStream(asysn_portaudio_fd) != paNoError)";
  z[lc++]="    {";
  z[lc++]="      asysn_portaudio_done = ASYS_ERROR;";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  while (asysn_portaudio_done == ASYS_DONE)";
  z[lc++]="    Pa_Sleep(ASYSN_PORTAUDIO_SLEEPMS);";
  z[lc++]="  ";
  z[lc++]="  if (asysn_portaudio_done == ASYS_ERROR)";
  z[lc++]="    Pa_AbortStream(asysn_portaudio_fd);";
  z[lc++]="  else";
  z[lc++]="    Pa_StopStream(asysn_portaudio_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_KSYNC)";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         initializes k-rate boundaries sync              */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void ksyncinit()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return (float) Pa_GetCPULoad(asysn_portaudio_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  printlib(lc);
}


void makecoreaudio(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Apple CoreAudio driver for sfront";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2006, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* include headers */";
  z[lc++]="/*_________________*/";
  z[lc++]="";
  z[lc++]="#include <sys/types.h>";
  z[lc++]="#include <sys/times.h>";
  z[lc++]="#include <unistd.h>";
  z[lc++]="#include <sys/mman.h>";
  z[lc++]="#include <mach/mach.h>";
  z[lc++]="#include <mach/host_priv.h>";
  z[lc++]="#include <mach/vm_region.h>";
  z[lc++]="#include <mach-o/getsect.h>";
  z[lc++]="";
  z[lc++]="#if defined(CSYS_CDRIVER_COREMIDI)";
  z[lc++]="#include <CoreFoundation/CFString.h>";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#include <CoreAudio/AudioHardware.h>";
  z[lc++]="#include <CoreAudio/CoreAudioTypes.h>";
  z[lc++]="#include <CoreAudio/HostTime.h>";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~*/";
  z[lc++]="/* error macros */";
  z[lc++]="/*______________*/";
  z[lc++]="";
  z[lc++]="#define  ASYSIO_ERROR_REPORT(x) do {\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s.\\n\", x);\\";
  z[lc++]="      } while (0)";
  z[lc++]="";
  z[lc++]="#define  ASYSIO_ERROR_RETURN(x) do {\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s.\\n\", x);\\";
  z[lc++]="      return ASYS_ERROR; } while (0)";
  z[lc++]="";
  z[lc++]="#define  ASYSIO_ERROR_EMPTYRETURN(x) do {\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s.\\n\", x);\\";
  z[lc++]="      return;} while (0)";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~*/";
  z[lc++]="/* constants */";
  z[lc++]="/*___________*/";
  z[lc++]="";
  z[lc++]="/* test definitions for listenerprocs */";
  z[lc++]="";
  z[lc++]="#define ASYSN_COREAUDIO_LPROC_MUTETEST  0     /* test mode: mute forces shutdown */";
  z[lc++]="";
  z[lc++]="/* for latency and buffering */";
  z[lc++]="";
  z[lc++]="#define ASYSN_COREAUDIO_LOWLATENCY   0.002    /* 2 ms buffer for low latency   */";
  z[lc++]="#define ASYSN_COREAUDIO_HIGHLATENCY  0.020    /* 20 ms buffer for high latency */";
  z[lc++]="#define ASYSN_COREAUDIO_LEADERTIME   0.050    /* silience to prime CoreAudio   */";
  z[lc++]="#define ASYSN_COREAUDIO_TRUEMAXFRAMES 2205    /* workaround ...                */";
  z[lc++]="";
  z[lc++]="/* for virtual memory paging */";
  z[lc++]="";
  z[lc++]="#define ASYSN_COREAUDIO_TOUCHMARGIN   256    /* for touch: 1MB for others (PPC)  */";
  z[lc++]="#define ASYSN_COREAUDIO_LOCKMARGIN   1024    /* for touch: 4MB for others (PPC)  */";
  z[lc++]="";
  z[lc++]="/* piping codes */";
  z[lc++]="";
  z[lc++]="#define ASYSN_COREAUDIO_PIPE_OK         0    /* normal termination for SA        */";
  z[lc++]="#define ASYSN_COREAUDIO_PIPE_LPROC      1    /* listener proc request            */";
  z[lc++]="";
  z[lc++]="/* for printout -- paging */";
  z[lc++]="";
  z[lc++]="#define ASYSN_COREAUDIO_SHORTRAM 1   /* not enough RAM          */";
  z[lc++]="#define ASYSN_COREAUDIO_PAGEIN   0   /* successful page-in      */";
  z[lc++]="#define ASYSN_COREAUDIO_STATFAIL -1  /* Host_statistics failed  */";
  z[lc++]="";
  z[lc++]="int asysn_coreaudio_pageinfo;       /* codes success of page-in  */";
  z[lc++]="int asysn_coreaudio_pagelock;       /* codes page-locking status */";
  z[lc++]="int asysn_coreaudio_pagetot;        /* number of pages inuse     */";
  z[lc++]="";
  z[lc++]="/* for printout -- coreaudio input */";
  z[lc++]="";
  z[lc++]="#define ASYSN_COREAUDIO_INPUT_NONE  0   /* no input source           */";
  z[lc++]="#define ASYSN_COREAUDIO_INPUT_IDEF  1   /* default coreaudio input   */";
  z[lc++]="#define ASYSN_COREAUDIO_INPUT_ODEF  2   /* coreaudio output as input */";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~*/";
  z[lc++]="/* variables */";
  z[lc++]="/*___________*/";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="#define ASYSO_MAXSTREAM   16            /* max number of ostreams  */";
  z[lc++]="";
  z[lc++]="AudioDeviceID asyso_aid;                   /* audio output device  */";
  z[lc++]="Float32 * asyso_buffptr[ASYSO_MAXSTREAM];  /* stream pointers      */";
  z[lc++]="UInt32 asyso_buffchan[ASYSO_MAXSTREAM];    /* per-stream channels  */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="#define ASYSI_MAXSTREAM   16            /* max number of istreams  */";
  z[lc++]="";
  z[lc++]="AudioDeviceID asysi_aid;                   /* audio input device   */";
  z[lc++]="Float32 * asysi_buffptr[ASYSI_MAXSTREAM];  /* stream pointers      */";
  z[lc++]="UInt32 asysi_buffchan[ASYSI_MAXSTREAM];    /* per-stream channels  */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/* state for passive input driver */";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="ASYS_ITYPE * asysn_coreaudio_ibuf;";
  z[lc++]="int asysn_coreaudio_ilast;";
  z[lc++]="int asysn_coreaudio_iptr;";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/* state for passive output driver */";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASOUTPUT))";
  z[lc++]="";
  z[lc++]="ASYS_OTYPE * asysn_coreaudio_obuf;";
  z[lc++]="int asysn_coreaudio_optr;";
  z[lc++]="int asysn_coreaudio_olast;";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="int asysn_coreaudio_instatus;        /* code coreaudio input info   */";
  z[lc++]="";
  z[lc++]="/* for printout -- frame info */";
  z[lc++]="";
  z[lc++]="UInt32 asysn_coreaudio_frame_samples;  /* frame length in samples     */";
  z[lc++]="float asysn_coreaudio_frame_seconds;   /* frame length in seconds     */";
  z[lc++]="";
  z[lc++]="/* for printout -- mismatch warnings */";
  z[lc++]="";
  z[lc++]="int asysn_coreaudio_insize_mismatch;   /* too many coreaudio inputs   */";
  z[lc++]="int asysn_coreaudio_outsize_mismatch;  /* not enough coreaudio outputs */";
  z[lc++]="";
  z[lc++]="/* general-purpose variables */";
  z[lc++]="";
  z[lc++]="int asysn_coreaudio_pipepair[2];    /* asys_main/IOProc comm chan  */";
  z[lc++]="int volatile asysn_coreaudio_live;  /* routes silence or SA to out */";
  z[lc++]="int asysn_coreaudio_silentframes;   /* leader-tape length          */";
  z[lc++]="";
  z[lc++]="int volatile asysn_coreaudio_touch; /* for page warmups           */";
  z[lc++]="UInt64 asysn_coreaudio_ksync_then;   /* counter for time spent     */";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* forward externs */";
  z[lc++]="/*_________________*/";
  z[lc++]="";
  z[lc++]="extern float ksync(void);";
  z[lc++]="extern void  main_ipass(void);";
  z[lc++]="extern int   main_kpass(void);";
  z[lc++]="extern void  main_apass(void);";
  z[lc++]="extern void  main_control(void);";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*   asys_mac() functions     */";
  z[lc++]="/*----------------------------*/";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_O)";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*                    CoreAudio output, no input                    */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_mac_orun(float * obuff[], UInt32 obuffchan[], UInt32 onumbuff, UInt32 frames)";
  z[lc++]="{";
  z[lc++]="  int frameidx = 0;";
  z[lc++]="  int busidx, chanidx, buffidx;";
  z[lc++]="";
  z[lc++]="  if (EV(asys_exit_status) == ASYS_EXIT)";
  z[lc++]="    return ASYS_EXIT;";
  z[lc++]="";
  z[lc++]="  while (frameidx < frames)";
  z[lc++]="    if (EV(acycleidx) < EV(ACYCLE))";
  z[lc++]="      {";
  z[lc++]="	memset(&(TB(0)), 0, sizeof(float)*ENDBUS);";
  z[lc++]="	main_apass();";
  z[lc++]="";
  z[lc++]="#if (ASYS_OCHAN == 1L)   /* mono case */";
  z[lc++]="	for (buffidx = 0; buffidx < onumbuff; buffidx++)";
  z[lc++]="	  for (chanidx = 0; chanidx < obuffchan[buffidx]; chanidx++)";
  z[lc++]="	    *((obuff[buffidx])++) = TB(BUS_output_bus);";
  z[lc++]="#else";
  z[lc++]="	busidx = BUS_output_bus;";
  z[lc++]="	for (buffidx = 0; buffidx < onumbuff; buffidx++)";
  z[lc++]="	  for (chanidx = 0; chanidx < obuffchan[buffidx]; chanidx++)";
  z[lc++]="	    {";
  z[lc++]="	      if (busidx < ENDBUS_output_bus)";
  z[lc++]="		*(obuff[buffidx]) = TB(busidx++);";
  z[lc++]="	      (obuff[buffidx])++;";
  z[lc++]="	    }";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="	EV(acycleidx)++;";
  z[lc++]="	frameidx++;";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	EV(acycleidx) = 0;";
  z[lc++]="	if (EV(pass) == APASS)";
  z[lc++]="	  {      ";
  z[lc++]="	    EV(cpuload) = ksync();";
  z[lc++]="	    EV(kcycleidx)++;";
  z[lc++]="	  }";
  z[lc++]="	if (EV(kcycleidx) > EV(endkcycle))";
  z[lc++]="	  return (EV(asys_exit_status) = ASYS_EXIT);";
  z[lc++]="";
  z[lc++]="	EV(pass) = IPASS;";
  z[lc++]="	EV(scorebeats) = EV(scoremult)*(EV(kcycleidx) - EV(kbase)) + EV(scorebase);";
  z[lc++]="	EV(absolutetime) = (EV(kcycleidx) - 1)*EV(KTIME);";
  z[lc++]="	main_ipass();";
  z[lc++]="	EV(pass) = KPASS;";
  z[lc++]="	main_control();";
  z[lc++]="	if (main_kpass())";
  z[lc++]="	  return (EV(asys_exit_status) = ASYS_EXIT);";
  z[lc++]="	EV(pass) = APASS;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif  /* ASYS_ACTIVE_O */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_IO) && defined(ASYS_HASINPUT) && defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*                    CoreAudio output and input                    */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_mac_iorun(float * obuff[], UInt32 obuffchan[], UInt32 onumbuff, ";
  z[lc++]="		   float * ibuff[], UInt32 ibuffchan[], UInt32 inumbuff, ";
  z[lc++]="		   UInt32 frames)";
  z[lc++]="{";
  z[lc++]="  int frameidx = 0;";
  z[lc++]="  int mono_in = ((inumbuff == 1) && (ibuffchan[0] == 1));";
  z[lc++]="  int busidx, chanidx, buffidx;";
  z[lc++]="";
  z[lc++]="  if (EV(asys_exit_status) == ASYS_EXIT)";
  z[lc++]="    return ASYS_EXIT;";
  z[lc++]="";
  z[lc++]="  while (frameidx < frames)";
  z[lc++]="    if (EV(acycleidx) < EV(ACYCLE))";
  z[lc++]="      {";
  z[lc++]="	memset(&(TB(0)), 0, sizeof(float)*ENDBUS);";
  z[lc++]="";
  z[lc++]="	if (!mono_in)";
  z[lc++]="	  {";
  z[lc++]="	    busidx = BUS_input_bus;";
  z[lc++]="	    for (buffidx = 0; buffidx < inumbuff; buffidx++)";
  z[lc++]="	      for (chanidx = 0; chanidx < ibuffchan[buffidx]; chanidx++)";
  z[lc++]="		{";
  z[lc++]="		  if (busidx < ENDBUS_input_bus)";
  z[lc++]="		    TB(busidx++) = *(ibuff[buffidx]);";
  z[lc++]="		  (ibuff[buffidx])++;";
  z[lc++]="		}";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  {";
  z[lc++]="	    for(busidx=BUS_input_bus;busidx<ENDBUS_input_bus;busidx++)";
  z[lc++]="	      TB(busidx) = *(ibuff[0]);";
  z[lc++]="	    (ibuff[0])++;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="	main_apass();";
  z[lc++]="";
  z[lc++]="#if (ASYS_OCHAN == 1L)   /* mono case */";
  z[lc++]="	for (buffidx = 0; buffidx < onumbuff; buffidx++)";
  z[lc++]="	  for (chanidx = 0; chanidx < obuffchan[buffidx]; chanidx++)";
  z[lc++]="	    *((obuff[buffidx])++) = TB(BUS_output_bus);";
  z[lc++]="#else";
  z[lc++]="	busidx = BUS_output_bus;";
  z[lc++]="	for (buffidx = 0; buffidx < onumbuff; buffidx++)";
  z[lc++]="	  for (chanidx = 0; chanidx < obuffchan[buffidx]; chanidx++)";
  z[lc++]="	    {";
  z[lc++]="	      if (busidx < ENDBUS_output_bus)";
  z[lc++]="		*(obuff[buffidx]) = TB(busidx++);";
  z[lc++]="	      (obuff[buffidx])++;";
  z[lc++]="	    }";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="	EV(acycleidx)++;";
  z[lc++]="	frameidx++;";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	EV(acycleidx) = 0;";
  z[lc++]="	if (EV(pass) == APASS)";
  z[lc++]="	  {      ";
  z[lc++]="	    EV(cpuload) = ksync();";
  z[lc++]="	    EV(kcycleidx)++;";
  z[lc++]="	  }";
  z[lc++]="	if (EV(kcycleidx) > EV(endkcycle))";
  z[lc++]="	  return (EV(asys_exit_status) = ASYS_EXIT);";
  z[lc++]="";
  z[lc++]="	EV(pass) = IPASS;";
  z[lc++]="	EV(scorebeats) = EV(scoremult)*(EV(kcycleidx) - EV(kbase)) + EV(scorebase);";
  z[lc++]="	EV(absolutetime) = (EV(kcycleidx) - 1)*EV(KTIME);";
  z[lc++]="	main_ipass();";
  z[lc++]="	EV(pass) = KPASS;";
  z[lc++]="	main_control();";
  z[lc++]="	if (main_kpass())";
  z[lc++]="	  return (EV(asys_exit_status) = ASYS_EXIT);";
  z[lc++]="	EV(pass) = APASS;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif /* ASYS_ACTIVE_IO -- CoreAudio I + O */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*                  CoreAudio output, passive input                 */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_mac_orun(float * obuff[], UInt32 obuffchan[], UInt32 onumbuff,";
  z[lc++]="		   UInt32 frames)";
  z[lc++]="{";
  z[lc++]="  int frameidx = 0;";
  z[lc++]="  int busidx, chanidx, buffidx;";
  z[lc++]="";
  z[lc++]="  if (EV(asys_exit_status) == ASYS_EXIT)";
  z[lc++]="    return ASYS_EXIT;";
  z[lc++]="";
  z[lc++]="  while (frameidx < frames)";
  z[lc++]="    if (EV(acycleidx) < EV(ACYCLE))";
  z[lc++]="      {";
  z[lc++]="	memset(&(TB(0)), 0, sizeof(float)*ENDBUS);";
  z[lc++]="";
  z[lc++]="	if (asysn_coreaudio_ilast == asysn_coreaudio_iptr)";
  z[lc++]="	  {  ";
  z[lc++]="	    if ((asys_getbuf(&asysn_coreaudio_ibuf, &asysn_coreaudio_ilast) ";
  z[lc++]="		 != ASYS_DONE) || (asysn_coreaudio_ilast == 0))";
  z[lc++]="	      return (EV(asys_exit_status) = ASYS_EXIT);";
  z[lc++]="	    asysn_coreaudio_iptr = 0;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="#if (ASYS_ITYPENAME == ASYS_SHORT)";
  z[lc++]="	for(busidx=BUS_input_bus;busidx<ENDBUS_input_bus;busidx++)";
  z[lc++]="	  TB(busidx) = 3.051851e-5F*asysn_coreaudio_ibuf[asysn_coreaudio_iptr++];";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (ASYS_ITYPENAME == ASYS_FLOAT)";
  z[lc++]="	for(busidx=BUS_input_bus;busidx<ENDBUS_input_bus;busidx++)";
  z[lc++]="	  TB(busidx) = asysn_coreaudio_ibuf[asysn_coreaudio_iptr++];";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="	main_apass();";
  z[lc++]="";
  z[lc++]="#if (ASYS_OCHAN == 1L)   /* mono case */";
  z[lc++]="	for (buffidx = 0; buffidx < onumbuff; buffidx++)";
  z[lc++]="	  for (chanidx = 0; chanidx < obuffchan[buffidx]; chanidx++)";
  z[lc++]="	    *((obuff[buffidx])++) = TB(BUS_output_bus);";
  z[lc++]="#else";
  z[lc++]="	busidx = BUS_output_bus;";
  z[lc++]="	for (buffidx = 0; buffidx < onumbuff; buffidx++)";
  z[lc++]="	  for (chanidx = 0; chanidx < obuffchan[buffidx]; chanidx++)";
  z[lc++]="	    {";
  z[lc++]="	      if (busidx < ENDBUS_output_bus)";
  z[lc++]="		*(obuff[buffidx]) = TB(busidx++);";
  z[lc++]="	      (obuff[buffidx])++;";
  z[lc++]="	    }";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="	EV(acycleidx)++;";
  z[lc++]="	frameidx++;";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	EV(acycleidx) = 0;";
  z[lc++]="	if (EV(pass) == APASS)";
  z[lc++]="	  {      ";
  z[lc++]="	    EV(cpuload) = ksync();";
  z[lc++]="	    EV(kcycleidx)++;";
  z[lc++]="	  }";
  z[lc++]="	if (EV(kcycleidx) > EV(endkcycle))";
  z[lc++]="	  return (EV(asys_exit_status) = ASYS_EXIT);";
  z[lc++]="";
  z[lc++]="	EV(pass) = IPASS;";
  z[lc++]="	EV(scorebeats) = EV(scoremult)*(EV(kcycleidx) - EV(kbase)) + EV(scorebase);";
  z[lc++]="	EV(absolutetime) = (EV(kcycleidx) - 1)*EV(KTIME);";
  z[lc++]="	main_ipass();";
  z[lc++]="	EV(pass) = KPASS;";
  z[lc++]="	main_control();";
  z[lc++]="	if (main_kpass())";
  z[lc++]="	  return (EV(asys_exit_status) = ASYS_EXIT);";
  z[lc++]="	EV(pass) = APASS;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif /* ASYS_ACTIVE_IO -- CoreAudio O only */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*                  CoreAudio input, passive output                 */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_mac_irun(float * ibuff[], UInt32 ibuffchan[], UInt32 inumbuff, ";
  z[lc++]="		  UInt32 frames)";
  z[lc++]="{";
  z[lc++]="  int frameidx = 0;";
  z[lc++]="  int mono_in = ((inumbuff == 1) && (ibuffchan[0] == 1));";
  z[lc++]="  int busidx, chanidx, buffidx;";
  z[lc++]="";
  z[lc++]="  if (EV(asys_exit_status) == ASYS_EXIT)";
  z[lc++]="    return ASYS_EXIT;";
  z[lc++]="";
  z[lc++]="  while (frameidx < frames)";
  z[lc++]="    if (EV(acycleidx) < EV(ACYCLE))";
  z[lc++]="      {";
  z[lc++]="	memset(&(TB(0)), 0, sizeof(float)*ENDBUS);";
  z[lc++]="";
  z[lc++]="	if (!mono_in)";
  z[lc++]="	  {";
  z[lc++]="	    busidx = BUS_input_bus;";
  z[lc++]="	    for (buffidx = 0; buffidx < inumbuff; buffidx++)";
  z[lc++]="	      for (chanidx = 0; chanidx < ibuffchan[buffidx]; chanidx++)";
  z[lc++]="		{";
  z[lc++]="		  if (busidx < ENDBUS_input_bus)";
  z[lc++]="		    TB(busidx++) = *(ibuff[buffidx]);";
  z[lc++]="		  (ibuff[buffidx])++;";
  z[lc++]="		}";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  {";
  z[lc++]="	    for(busidx=BUS_input_bus;busidx<ENDBUS_input_bus;busidx++)";
  z[lc++]="	      TB(busidx) = *(ibuff[0]);";
  z[lc++]="	    (ibuff[0])++;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="	main_apass();";
  z[lc++]="";
  z[lc++]="#if (ASYS_OTYPENAME == ASYS_FLOAT)";
  z[lc++]="	for (busidx = BUS_output_bus; busidx < ENDBUS_output_bus; busidx++)";
  z[lc++]="	  if ((TB(busidx) <= 1.0F) && (TB(busidx) >= -1.0F))";
  z[lc++]="	    asysn_coreaudio_obuf[asysn_coreaudio_optr++] = TB(busidx);";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      if (TB(busidx) > 0.0F)";
  z[lc++]="		asysn_coreaudio_obuf[asysn_coreaudio_optr++] = 1.0F;";
  z[lc++]="	      else";
  z[lc++]="		asysn_coreaudio_obuf[asysn_coreaudio_optr++] = -1.0F;";
  z[lc++]="	    }";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (ASYS_OTYPENAME == ASYS_SHORT)";
  z[lc++]="	for (busidx = BUS_output_bus; busidx < ENDBUS_output_bus; busidx++)";
  z[lc++]="	  if ((TB(busidx) <= 1.0F) && (TB(busidx) >= -1.0F))";
  z[lc++]="	    asysn_coreaudio_obuf[asysn_coreaudio_optr++] = ((float)0x7FFF)*TB(busidx);";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      if (TB(busidx) > 0.0F)";
  z[lc++]="		asysn_coreaudio_obuf[asysn_coreaudio_optr++] = 0x7FFF;";
  z[lc++]="	      else";
  z[lc++]="		asysn_coreaudio_obuf[asysn_coreaudio_optr++] = 0xFFFF;";
  z[lc++]="	    }";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="	if (asysn_coreaudio_optr == asysn_coreaudio_olast)";
  z[lc++]="	  {";
  z[lc++]="	    if (asys_putbuf(&asysn_coreaudio_obuf,&asysn_coreaudio_olast)==ASYS_DONE)";
  z[lc++]="	      asysn_coreaudio_optr = 0;";
  z[lc++]="	    else";
  z[lc++]="	      return (EV(asys_exit_status) = ASYS_EXIT);";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="	EV(acycleidx)++;";
  z[lc++]="	frameidx++;";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	EV(acycleidx) = 0;";
  z[lc++]="	if (EV(pass) == APASS)";
  z[lc++]="	  {      ";
  z[lc++]="	    EV(cpuload) = ksync();";
  z[lc++]="	    EV(kcycleidx)++;";
  z[lc++]="	  }";
  z[lc++]="	if (EV(kcycleidx) > EV(endkcycle))";
  z[lc++]="	  {";
  z[lc++]="	    if (asysn_coreaudio_optr)";
  z[lc++]="	      asys_putbuf(&asysn_coreaudio_obuf, &asysn_coreaudio_optr);";
  z[lc++]="	    return (EV(asys_exit_status) = ASYS_EXIT);";
  z[lc++]="	  }";
  z[lc++]="	EV(pass) = IPASS;";
  z[lc++]="	EV(scorebeats) = EV(scoremult)*(EV(kcycleidx) - EV(kbase)) + EV(scorebase);";
  z[lc++]="	EV(absolutetime) = (EV(kcycleidx) - 1)*EV(KTIME);";
  z[lc++]="	main_ipass();";
  z[lc++]="	EV(pass) = KPASS;";
  z[lc++]="	main_control();";
  z[lc++]="	if (main_kpass())";
  z[lc++]="	  {";
  z[lc++]="	    if (asysn_coreaudio_optr)";
  z[lc++]="	      asys_putbuf(&asysn_coreaudio_obuf, &asysn_coreaudio_optr);";
  z[lc++]="	    return (EV(asys_exit_status) = ASYS_EXIT);";
  z[lc++]="	  }";
  z[lc++]="	EV(pass) = APASS;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif /* ASYS_ACTIVE_IO -- CoreAudio I only */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*   callback function suite  */";
  z[lc++]="/*----------------------------*/";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_O) || (defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*          CoreAudio output, no input or passive input             */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="OSStatus asysn_coreaudio_only_output(AudioDeviceID inDevice, ";
  z[lc++]="				     const AudioTimeStamp * inNow,";
  z[lc++]="				     const AudioBufferList * inInputData,";
  z[lc++]="				     const AudioTimeStamp * inInputTime,";
  z[lc++]="				     AudioBufferList * outOutputData,";
  z[lc++]="				     const AudioTimeStamp * outOutputTime, ";
  z[lc++]="				     void * inClientData)";
  z[lc++]="{";
  z[lc++]="  UInt32 numbuff = ASYSO_MAXSTREAM;";
  z[lc++]="  UInt32 i, frames, retcode;";
  z[lc++]="";
  z[lc++]="  /* exit gracefully if audio output goes away */";
  z[lc++]="";
  z[lc++]="  if ((outOutputTime->mFlags & kAudioTimeStampHostTimeValid) &&";
  z[lc++]="      (outOutputTime->mHostTime == 0))";
  z[lc++]="    return kAudioHardwareNoError;";
  z[lc++]="";
  z[lc++]="  /* set up cpuload timing state */";
  z[lc++]="";
  z[lc++]="  if (inNow->mFlags & kAudioTimeStampHostTimeValid)";
  z[lc++]="    asysn_coreaudio_ksync_then = inNow->mHostTime - asysn_coreaudio_ksync_then;";
  z[lc++]="  else";
  z[lc++]="    asysn_coreaudio_ksync_then = (AudioGetCurrentHostTime() -";
  z[lc++]="				  asysn_coreaudio_ksync_then);";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_live == ASYS_DONE)";
  z[lc++]="    {";
  z[lc++]="      /* set up pointers for asys_mac_orun() call, then make call */";
  z[lc++]="";
  z[lc++]="      if (outOutputData->mNumberBuffers <= ASYSO_MAXSTREAM)";
  z[lc++]="	numbuff = outOutputData->mNumberBuffers;";
  z[lc++]="";
  z[lc++]="      for (i = 0; i < numbuff; i++)";
  z[lc++]="	{";
  z[lc++]="	  asyso_buffptr[i] = (Float32 *) outOutputData->mBuffers[i].mData;";
  z[lc++]="	  asyso_buffchan[i] = outOutputData->mBuffers[i].mNumberChannels;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (asyso_buffchan[0] <= 2)";
  z[lc++]="	frames = outOutputData->mBuffers[0].mDataByteSize >> (1 + asyso_buffchan[0]);";
  z[lc++]="      else";
  z[lc++]="	frames = outOutputData->mBuffers[0].mDataByteSize/(asyso_buffchan[0] << 2);";
  z[lc++]="";
  z[lc++]="      asysn_coreaudio_live = asys_mac_orun(asyso_buffptr, asyso_buffchan,";
  z[lc++]="					   numbuff, frames);";
  z[lc++]="";
  z[lc++]="      /* inform main thread of normal exit or error */";
  z[lc++]="";
  z[lc++]="      if (asysn_coreaudio_live != ASYS_DONE)";
  z[lc++]="	{";
  z[lc++]="	  retcode = ASYSN_COREAUDIO_PIPE_OK;";
  z[lc++]="	  if (write(asysn_coreaudio_pipepair[1], &retcode, sizeof(UInt32)) < 0)";
  z[lc++]="	    perror(\"Error writing asys_main pipe\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      /* silience at start of program */";
  z[lc++]="";
  z[lc++]="      if (asysn_coreaudio_silentframes && !(--asysn_coreaudio_silentframes))";
  z[lc++]="	asysn_coreaudio_live = ASYS_DONE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* set up cpuload timing state for next time */";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_ksync_then = (AudioGetCurrentHostTime() - ";
  z[lc++]="				asysn_coreaudio_ksync_then);";
  z[lc++]="  return kAudioHardwareNoError;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif  /* CoreAudio output, no input or passive input */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_IO) && defined(ASYS_HASINPUT) && defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*      coreaudio input and output, from the same audio device      */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="OSStatus asysn_coreaudio_input_output(AudioDeviceID inDevice, ";
  z[lc++]="				      const AudioTimeStamp * inNow,";
  z[lc++]="				      const AudioBufferList * inInputData,";
  z[lc++]="				      const AudioTimeStamp * inInputTime,";
  z[lc++]="				      AudioBufferList * outOutputData,";
  z[lc++]="				      const AudioTimeStamp * outOutputTime, ";
  z[lc++]="				      void * inClientData)";
  z[lc++]="{";
  z[lc++]="  UInt32 inumbuff = ASYSI_MAXSTREAM;";
  z[lc++]="  UInt32 onumbuff = ASYSO_MAXSTREAM;";
  z[lc++]="  UInt32 i, frames, retcode;";
  z[lc++]="";
  z[lc++]="  /* exit gracefully if audio input or output goes away */";
  z[lc++]="";
  z[lc++]="  if (((inInputTime->mFlags & kAudioTimeStampHostTimeValid) &&";
  z[lc++]="       (inInputTime->mHostTime == 0)) ||";
  z[lc++]="      ((outOutputTime->mFlags & kAudioTimeStampHostTimeValid) &&";
  z[lc++]="       (outOutputTime->mHostTime == 0)))";
  z[lc++]="    return kAudioHardwareNoError;";
  z[lc++]="";
  z[lc++]="  /* set up cpuload timing state */";
  z[lc++]="";
  z[lc++]="  if (inNow->mFlags & kAudioTimeStampHostTimeValid)";
  z[lc++]="    asysn_coreaudio_ksync_then = inNow->mHostTime - asysn_coreaudio_ksync_then;";
  z[lc++]="  else";
  z[lc++]="    asysn_coreaudio_ksync_then = (AudioGetCurrentHostTime() -";
  z[lc++]="				  asysn_coreaudio_ksync_then);";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_live == ASYS_DONE)";
  z[lc++]="    {";
  z[lc++]="      /* set up pointers for asys_mac_iorun() call, then make call */";
  z[lc++]="";
  z[lc++]="      if (outOutputData->mNumberBuffers <= ASYSO_MAXSTREAM)";
  z[lc++]="	onumbuff = outOutputData->mNumberBuffers;";
  z[lc++]="";
  z[lc++]="      for (i = 0; i < onumbuff; i++)";
  z[lc++]="	{";
  z[lc++]="	  asyso_buffptr[i] = (Float32 *) outOutputData->mBuffers[i].mData;";
  z[lc++]="	  asyso_buffchan[i] = outOutputData->mBuffers[i].mNumberChannels;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (asyso_buffchan[0] <= 2)";
  z[lc++]="	frames = outOutputData->mBuffers[0].mDataByteSize >> (1 + asyso_buffchan[0]);";
  z[lc++]="      else";
  z[lc++]="	frames = outOutputData->mBuffers[0].mDataByteSize/(asyso_buffchan[0] << 2);";
  z[lc++]="";
  z[lc++]="      if (inInputData->mNumberBuffers <= ASYSI_MAXSTREAM)";
  z[lc++]="	inumbuff = inInputData->mNumberBuffers;";
  z[lc++]="";
  z[lc++]="      for (i = 0; i < inumbuff; i++)";
  z[lc++]="	{";
  z[lc++]="	  asysi_buffptr[i] = (Float32 *) inInputData->mBuffers[i].mData;";
  z[lc++]="	  asysi_buffchan[i] = inInputData->mBuffers[i].mNumberChannels;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      asysn_coreaudio_live = asys_mac_iorun(asyso_buffptr, asyso_buffchan,";
  z[lc++]="					    onumbuff, asysi_buffptr, ";
  z[lc++]="					    asysi_buffchan, inumbuff, frames);";
  z[lc++]="";
  z[lc++]="      /* inform main thread of normal exit or error */";
  z[lc++]="";
  z[lc++]="      if (asysn_coreaudio_live != ASYS_DONE)";
  z[lc++]="	{";
  z[lc++]="	  retcode = ASYSN_COREAUDIO_PIPE_OK;";
  z[lc++]="	  if (write(asysn_coreaudio_pipepair[1], &retcode, sizeof(UInt32)) < 0)";
  z[lc++]="	    perror(\"Error writing asys_main pipe\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      /* silience at start of program */";
  z[lc++]="";
  z[lc++]="      if (asysn_coreaudio_silentframes && !(--asysn_coreaudio_silentframes))";
  z[lc++]="	asysn_coreaudio_live = ASYS_DONE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* set up cpuload timing state for next time */";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_ksync_then = (AudioGetCurrentHostTime() - ";
  z[lc++]="				asysn_coreaudio_ksync_then);";
  z[lc++]="  return kAudioHardwareNoError;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif  /* ASYS_ACTIVE_IO, coreaudio input and output */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*      coreaudio input and output, from the same audio device      */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="OSStatus asysn_coreaudio_only_input(AudioDeviceID inDevice, ";
  z[lc++]="				      const AudioTimeStamp * inNow,";
  z[lc++]="				      const AudioBufferList * inInputData,";
  z[lc++]="				      const AudioTimeStamp * inInputTime,";
  z[lc++]="				      AudioBufferList * outOutputData,";
  z[lc++]="				      const AudioTimeStamp * outOutputTime, ";
  z[lc++]="				      void * inClientData)";
  z[lc++]="{";
  z[lc++]="  UInt32 inumbuff = ASYSI_MAXSTREAM;";
  z[lc++]="  UInt32 i, frames, retcode;";
  z[lc++]="";
  z[lc++]="  /* exit gracefully if audio input goes away */";
  z[lc++]="";
  z[lc++]="  if ((inInputTime->mFlags & kAudioTimeStampHostTimeValid) &&";
  z[lc++]="      (inInputTime->mHostTime == 0))";
  z[lc++]="    return kAudioHardwareNoError;";
  z[lc++]="";
  z[lc++]="  /* set up cpuload timing state */";
  z[lc++]="";
  z[lc++]="  if (inNow->mFlags & kAudioTimeStampHostTimeValid)";
  z[lc++]="    asysn_coreaudio_ksync_then = inNow->mHostTime - asysn_coreaudio_ksync_then;";
  z[lc++]="  else";
  z[lc++]="    asysn_coreaudio_ksync_then = (AudioGetCurrentHostTime() -";
  z[lc++]="				  asysn_coreaudio_ksync_then);";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_live == ASYS_DONE)";
  z[lc++]="    {";
  z[lc++]="      /* set up pointers for asys_mac_irun() call, then make call */";
  z[lc++]="";
  z[lc++]="      if (inInputData->mNumberBuffers <= ASYSI_MAXSTREAM)";
  z[lc++]="	inumbuff = inInputData->mNumberBuffers;";
  z[lc++]="";
  z[lc++]="      for (i = 0; i < inumbuff; i++)";
  z[lc++]="	{";
  z[lc++]="	  asysi_buffptr[i] = (Float32 *) inInputData->mBuffers[i].mData;";
  z[lc++]="	  asysi_buffchan[i] = inInputData->mBuffers[i].mNumberChannels;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (asysi_buffchan[0] <= 2)";
  z[lc++]="	frames = inInputData->mBuffers[0].mDataByteSize >> (1 + asysi_buffchan[0]);";
  z[lc++]="      else";
  z[lc++]="	frames = inInputData->mBuffers[0].mDataByteSize/(asysi_buffchan[0] << 2);";
  z[lc++]="";
  z[lc++]="      asysn_coreaudio_live = asys_mac_irun(asysi_buffptr, asysi_buffchan, ";
  z[lc++]="					   inumbuff, frames);";
  z[lc++]="";
  z[lc++]="      /* inform main thread of normal exit or error */";
  z[lc++]="";
  z[lc++]="      if (asysn_coreaudio_live != ASYS_DONE)";
  z[lc++]="	{";
  z[lc++]="	  retcode = ASYSN_COREAUDIO_PIPE_OK;";
  z[lc++]="	  if (write(asysn_coreaudio_pipepair[1], &retcode, sizeof(UInt32)) < 0)";
  z[lc++]="	    perror(\"Error writing asys_main pipe\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      /* silience at start of program */";
  z[lc++]="";
  z[lc++]="      if (asysn_coreaudio_silentframes && !(--asysn_coreaudio_silentframes))";
  z[lc++]="	asysn_coreaudio_live = ASYS_DONE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* set up cpuload timing state for next time */";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_ksync_then = (AudioGetCurrentHostTime() - ";
  z[lc++]="				asysn_coreaudio_ksync_then);";
  z[lc++]="  return kAudioHardwareNoError;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif  /* ASYS_ACTIVE_IO, coreaudio input only */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*   setup function suite  */";
  z[lc++]="/*-------------------------*/";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*                    page in working set                           */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_coreaudio_page()";
  z[lc++]="{";
  z[lc++]="  UInt32 psize, pagetop, addrtop, touchtop, vm_total, err;";
  z[lc++]="  unsigned int statsize = HOST_VM_INFO_COUNT;";
  z[lc++]="  vm_statistics_data_t vm_stat;";
  z[lc++]="  struct vm_region_basic_info rinfo;";
  z[lc++]="  mach_msg_type_number_t rinfo_count;";
  z[lc++]="  mach_port_t object_name;";
  z[lc++]="  vm_address_t raddr;";
  z[lc++]="  vm_size_t rsize;";
  z[lc++]="";
  z[lc++]="  /**********************************/";
  z[lc++]="  /* get current system paging info */";
  z[lc++]="  /**********************************/";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_pageinfo = ASYSN_COREAUDIO_PAGEIN;";
  z[lc++]="";
  z[lc++]="  if (host_statistics(mach_host_self(), HOST_VM_INFO, ";
  z[lc++]="		      (host_info_t) &vm_stat, &statsize))";
  z[lc++]="    {";
  z[lc++]="      asysn_coreaudio_pageinfo = ASYSN_COREAUDIO_STATFAIL;";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  vm_total = (vm_stat.free_count + vm_stat.active_count";
  z[lc++]="	      + vm_stat.inactive_count); ";
  z[lc++]="";
  z[lc++]="  /***********************************/";
  z[lc++]="  /* compute highest page, advise OS */";
  z[lc++]="  /***********************************/";
  z[lc++]="";
  z[lc++]="  psize = getpagesize();";
  z[lc++]="  pagetop = (get_end() - 1)/psize;";
  z[lc++]="";
  z[lc++]="  madvise((caddr_t) psize, (pagetop - 1)*psize, MADV_WILLNEED);";
  z[lc++]="";
  z[lc++]="  if ((pagetop - 1 + ASYSN_COREAUDIO_TOUCHMARGIN) <= vm_total)";
  z[lc++]="    touchtop = pagetop;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      touchtop = vm_total + 1;";
  z[lc++]="      asysn_coreaudio_pageinfo = ASYSN_COREAUDIO_SHORTRAM;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  /**********************************/";
  z[lc++]="  /* touch every page except page 0 */";
  z[lc++]="  /**********************************/";
  z[lc++]="";
  z[lc++]="  for (addrtop = touchtop*psize; addrtop >= psize; addrtop -= psize)";
  z[lc++]="    asysn_coreaudio_touch ^= *((int *) addrtop);";
  z[lc++]="";
  z[lc++]="  /******************************/";
  z[lc++]="  /* attempt to do page locking */";
  z[lc++]="  /******************************/";
  z[lc++]="";
  z[lc++]="  do {";
  z[lc++]="    err = 1;";
  z[lc++]="";
  z[lc++]="    /* can only lock if enough room */";
  z[lc++]="    ";
  z[lc++]="    if ((pagetop - 1 + ASYSN_COREAUDIO_LOCKMARGIN) > vm_total)";
  z[lc++]="      break; err++;";
  z[lc++]="    ";
  z[lc++]="    addrtop = psize;";
  z[lc++]="";
  z[lc++]="    while (addrtop < get_end())";
  z[lc++]="      {";
  z[lc++]="	raddr = addrtop;";
  z[lc++]="	rinfo_count = VM_REGION_BASIC_INFO_COUNT;";
  z[lc++]="    ";
  z[lc++]="	if (vm_region(mach_task_self(), &raddr, &rsize, VM_REGION_BASIC_INFO, ";
  z[lc++]="		      (vm_region_info_t) &rinfo, &rinfo_count, &object_name))";
  z[lc++]="	  break;";
  z[lc++]="";
  z[lc++]="	if (raddr >= get_end())";
  z[lc++]="	  break;";
  z[lc++]="";
  z[lc++]="	if ((raddr + rsize) > get_end())";
  z[lc++]="	  rsize = get_end() - raddr;";
  z[lc++]="";
  z[lc++]="	if (vm_wire(mach_host_self(), mach_task_self(), ";
  z[lc++]="		    (vm_address_t) raddr, (vm_size_t) rsize,";
  z[lc++]="		    rinfo.protection))";
  z[lc++]="	  break;";
  z[lc++]="";
  z[lc++]="	addrtop = raddr + rsize;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  } while ((err = 0));";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_pagelock = (err == 0);";
  z[lc++]="  asysn_coreaudio_pagetot  = pagetop;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*             setup device-independent properties                  */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_coreaudio_globalsetup()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  UInt32 state = 1;";
  z[lc++]="";
  z[lc++]="  /* set up pipe to main thread */";
  z[lc++]="";
  z[lc++]="  if (pipe(asysn_coreaudio_pipepair))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Cannot open end-of-audio pipe\");";
  z[lc++]="";
  z[lc++]="  /* let HAL know the main thread sleeps */";
  z[lc++]="";
  z[lc++]="  if (AudioHardwareSetProperty(kAudioHardwarePropertySleepingIsAllowed,";
  z[lc++]="			       sizeof(UInt32), &state))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Cannot notify HAL of sleep status\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*               check for requested device type                    */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_coreaudio_devicesetup(AudioDeviceID * aid, int input)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  UInt32 kopen, size, state;";
  z[lc++]="  char * message;";
  z[lc++]="";
  z[lc++]="  /* see if device exists */";
  z[lc++]="";
  z[lc++]="  size = sizeof(AudioDeviceID);";
  z[lc++]="  kopen = (input ? kAudioHardwarePropertyDefaultInputDevice :";
  z[lc++]="	   kAudioHardwarePropertyDefaultOutputDevice);";
  z[lc++]="";
  z[lc++]="  if (AudioHardwareGetProperty(kopen, &size, aid))";
  z[lc++]="    {";
  z[lc++]="      message = (input ? \"Default input device not found\" :";
  z[lc++]="		 \"Default output device not found\");";
  z[lc++]="      ASYSIO_ERROR_RETURN(message);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* see if device is ready to use */";
  z[lc++]="";
  z[lc++]="  size = sizeof(UInt32);";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceGetProperty(*aid, 0, input, kAudioDevicePropertyDeviceIsAlive, ";
  z[lc++]="			     &size, &state))";
  z[lc++]="    {";
  z[lc++]="      message = (input ? ";
  z[lc++]="		 \"Cannot sense if input device is ready to use\" :";
  z[lc++]="		 \"Cannot sense if output device is ready to use\");";
  z[lc++]="      ASYSIO_ERROR_RETURN(message);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!state)";
  z[lc++]="    {";
  z[lc++]="      message = (input ? ";
  z[lc++]="		 \"Input device is not ready to use\" :";
  z[lc++]="		 \"Output device is not ready to use\");";
  z[lc++]="      ASYSIO_ERROR_RETURN(message);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (input)";
  z[lc++]="    asysn_coreaudio_instatus = ASYSN_COREAUDIO_INPUT_IDEF;";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*         returns a device name + manufacturer as a string         */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="char * asysn_coreaudio_getdevicename(AudioDeviceID aid, UInt32 input)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  Boolean wflag;";
  z[lc++]="  UInt32 devsize, mansize;";
  z[lc++]="  char * devname, * manname, * retstr;";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceGetPropertyInfo(aid, 0, input, kAudioDevicePropertyDeviceName, ";
  z[lc++]="				 &devsize, &wflag))";
  z[lc++]="    return NULL;";
  z[lc++]="  ";
  z[lc++]="  devname = malloc(devsize);";
  z[lc++]="  ";
  z[lc++]="  if (AudioDeviceGetProperty(aid, 0, input, kAudioDevicePropertyDeviceName, ";
  z[lc++]="			     &devsize, devname))";
  z[lc++]="    return NULL;";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceGetPropertyInfo(aid, 0, input, kAudioDevicePropertyDeviceManufacturer, ";
  z[lc++]="				 &mansize, &wflag))";
  z[lc++]="    return NULL;";
  z[lc++]="  ";
  z[lc++]="  manname = malloc(mansize);";
  z[lc++]="  ";
  z[lc++]="  if (AudioDeviceGetProperty(aid, 0, input, kAudioDevicePropertyDeviceManufacturer, ";
  z[lc++]="			     &mansize, manname))";
  z[lc++]="    return NULL;";
  z[lc++]="";
  z[lc++]="  retstr = calloc(mansize + devsize + 16, 1);";
  z[lc++]="";
  z[lc++]="  sprintf(retstr, \"%s (%s)\", devname, manname);";
  z[lc++]="";
  z[lc++]="  free(devname);";
  z[lc++]="  free(manname);";
  z[lc++]="  return retstr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_COREAUDIO_DEBUG)";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*                  print all system devices                        */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_coreaudio_printdevices(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  UInt32 size, numdev, i, input;";
  z[lc++]="  AudioDeviceID * aid;";
  z[lc++]="  char * message;";
  z[lc++]="  Boolean wflag;";
  z[lc++]="";
  z[lc++]="  /* get size of device list */";
  z[lc++]="";
  z[lc++]="  if (AudioHardwareGetPropertyInfo(kAudioHardwarePropertyDevices, &size, &wflag))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Cannot determine size of device array\");";
  z[lc++]="";
  z[lc++]="  aid = malloc(size);";
  z[lc++]="  numdev = size/sizeof(AudioDeviceID);";
  z[lc++]="";
  z[lc++]="  if (AudioHardwareGetProperty(kAudioHardwarePropertyDevices, &size, aid))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Cannot obtain the device array\");";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < numdev; i++)";
  z[lc++]="    for (input = 0; input <= 1; input++)";
  z[lc++]="      {";
  z[lc++]="	if (AudioDeviceGetPropertyInfo(aid[i], 0, input, kAudioDevicePropertyDeviceName, ";
  z[lc++]="				       &size, &wflag))";
  z[lc++]="	  ASYSIO_ERROR_RETURN(\"Cannot determine name size\");";
  z[lc++]="	";
  z[lc++]="	message = malloc(size);";
  z[lc++]="	";
  z[lc++]="	if (AudioDeviceGetProperty(aid[i], 0, input, kAudioDevicePropertyDeviceName, ";
  z[lc++]="				   &size, message))";
  z[lc++]="	  ASYSIO_ERROR_RETURN(\"Cannot determine name\");";
  z[lc++]="	";
  z[lc++]="	if (AudioDeviceGetPropertyInfo(aid[i], 0, input, kAudioDevicePropertyStreams, ";
  z[lc++]="				       &size, &wflag))";
  z[lc++]="	  ASYSIO_ERROR_RETURN(\"Cannot determine stream size\");";
  z[lc++]="";
  z[lc++]="	printf(\"%s %u: %s [%u stream(s)]\\n\", input ? \"Input\" : \"Output\", i, ";
  z[lc++]="	       message, size/sizeof(AudioStreamID));";
  z[lc++]="	";
  z[lc++]="	free(message);";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif ";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*     initializes asyso_aid and asysi_aid for coreaudio i + o      */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_coreaudio_iodevicesetup(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  UInt32 size, input, state;";
  z[lc++]="  char * message;";
  z[lc++]="";
  z[lc++]="  size = sizeof(AudioDeviceID);";
  z[lc++]="";
  z[lc++]="  if (AudioHardwareGetProperty(kAudioHardwarePropertyDefaultOutputDevice,";
  z[lc++]="			       &size, &asyso_aid))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Default audio device does not exist\");";
  z[lc++]="";
  z[lc++]="  size = sizeof(AudioDeviceID);";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_instatus = ASYSN_COREAUDIO_INPUT_ODEF;";
  z[lc++]="";
  z[lc++]="  if (!AudioHardwareGetProperty(kAudioHardwarePropertyDefaultInputDevice,";
  z[lc++]="				&size, &asysi_aid) && (asysi_aid == asyso_aid))";
  z[lc++]="    asysn_coreaudio_instatus = ASYSN_COREAUDIO_INPUT_IDEF;";
  z[lc++]="";
  z[lc++]="  asysi_aid = asyso_aid;";
  z[lc++]="";
  z[lc++]="  /* see if device is ready to use */";
  z[lc++]="";
  z[lc++]="  for (input = 0; input <= 1; input++)";
  z[lc++]="    {";
  z[lc++]="      size = sizeof(UInt32);";
  z[lc++]="";
  z[lc++]="      if (AudioDeviceGetProperty(asyso_aid, 0, input, ";
  z[lc++]="				 kAudioDevicePropertyDeviceIsAlive, &size, &state))";
  z[lc++]="	{";
  z[lc++]="	  message = (input ? ";
  z[lc++]="		     \"Cannot sense if input device is ready to use\" :";
  z[lc++]="		     \"Cannot sense if output device is ready to use\");";
  z[lc++]="	  ASYSIO_ERROR_RETURN(message);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (!state)";
  z[lc++]="	{";
  z[lc++]="	  message = (input ? ";
  z[lc++]="		     \"Input device is not ready to use\" :";
  z[lc++]="		     \"Output device is not ready to use\");";
  z[lc++]="	  ASYSIO_ERROR_RETURN(message);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*         returns the stream configuration for a device            */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_coreaudio_streaminfo(AudioDeviceID aid, Boolean input, ";
  z[lc++]="			       UInt32 * numstreams,  /* number of streams     */";
  z[lc++]="			       double * srate,       /* srate of stream 1     */";
  z[lc++]="			       UInt32 * numchan      /* total num channels    */";
  z[lc++]="			       )";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  UInt32 size, i;";
  z[lc++]="  Boolean wflag, fpcm;";
  z[lc++]="  char * message;";
  z[lc++]="  AudioBufferList * abl;";
  z[lc++]="  AudioStreamBasicDescription desc;";
  z[lc++]="  ";
  z[lc++]=" if (AudioDeviceGetPropertyInfo(aid, 0, input, ";
  z[lc++]="				 kAudioDevicePropertyStreamConfiguration,";
  z[lc++]="				 &size, &wflag))";
  z[lc++]="    {";
  z[lc++]="      message = (input ? ";
  z[lc++]="		 \"Cannot determine size of input stream configuration\" :";
  z[lc++]="		 \"Cannot determine size of output stream configuration\");";
  z[lc++]="      ASYSIO_ERROR_RETURN(message);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((abl = malloc(size)) == NULL)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Process out of memory\");";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceGetProperty(aid, 0, input, ";
  z[lc++]="			     kAudioDevicePropertyStreamConfiguration,";
  z[lc++]="			     &size, abl))";
  z[lc++]="    {";
  z[lc++]="      message = (input ? ";
  z[lc++]="		 \"Cannot determine input stream configuration\" :";
  z[lc++]="		 \"Cannot determine output stream configuration\");";
  z[lc++]="      ASYSIO_ERROR_RETURN(message);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((*numstreams = abl->mNumberBuffers) == 0)";
  z[lc++]="    {";
  z[lc++]="      message = (input ? ";
  z[lc++]="		 \"Audio device has no input streams\" :";
  z[lc++]="		 \"Audio device has no output streams\");";
  z[lc++]="      ASYSIO_ERROR_RETURN(message);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  *numchan = 0;";
  z[lc++]="  fpcm = 1;";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < *numstreams; i++)";
  z[lc++]="    {";
  z[lc++]="      (*numchan) += abl->mBuffers[i].mNumberChannels;";
  z[lc++]="      size = sizeof(AudioStreamBasicDescription);";
  z[lc++]="";
  z[lc++]="      if (AudioDeviceGetProperty(aid, *numchan, input, ";
  z[lc++]="				 kAudioDevicePropertyStreamFormat,";
  z[lc++]="				 &size, &desc))";
  z[lc++]="	{";
  z[lc++]="	  message = (input ? ";
  z[lc++]="		     \"Cannot determine input stream format\" :";
  z[lc++]="		     \"Cannot determine output stream format\");";
  z[lc++]="	  ASYSIO_ERROR_RETURN(message);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (!i)";
  z[lc++]="	*srate = desc.mSampleRate;";
  z[lc++]="";
  z[lc++]="      fpcm = (fpcm && (desc.mFormatID == kAudioFormatLinearPCM) &&";
  z[lc++]="	      (desc.mFormatFlags & kLinearPCMFormatFlagIsFloat));";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  free(abl);";
  z[lc++]="";
  z[lc++]="  if (!fpcm)";
  z[lc++]="    {";
  z[lc++]="      message = (input ? ";
  z[lc++]="		 \"Audio input device is not linear PCM\" :";
  z[lc++]="		 \"Audio output device is not linear PCM\");";
  z[lc++]="      ASYSIO_ERROR_RETURN(message);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*            tries to reconfigure a one-stream device            */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_coreaudio_reconfigure(AudioDeviceID aid, Boolean input, ";
  z[lc++]="				int srate, double * core_srate)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  AudioStreamBasicDescription desc;";
  z[lc++]="  UInt32 size;";
  z[lc++]="  Boolean wflag;";
  z[lc++]="  ";
  z[lc++]="  /* leave if the stream format is not writable */";
  z[lc++]="";
  z[lc++]=" if (AudioDeviceGetPropertyInfo(aid, 1, input, ";
  z[lc++]="				kAudioDevicePropertyStreamFormat,";
  z[lc++]="				&size, &wflag) || (wflag == 0))";
  z[lc++]="   return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="  /* get closest match */";
  z[lc++]="";
  z[lc++]="  memset(&desc, 0, (size = sizeof(desc)));";
  z[lc++]="  desc.mSampleRate = (Float64) srate;";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceGetProperty(aid, 1, input, ";
  z[lc++]="			     kAudioDevicePropertyStreamFormatMatch, ";
  z[lc++]="			     &size, &desc))";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="      ";
  z[lc++]="  /* don't change if it won't make any difference */";
  z[lc++]="";
  z[lc++]="  if (*core_srate == desc.mSampleRate)";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="  /* make the change and exit */";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceSetProperty(aid, 0, 1, input, ";
  z[lc++]="			     kAudioDevicePropertyStreamFormat, ";
  z[lc++]="			     sizeof(desc), &desc))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Error reconfiguring the stream\");";
  z[lc++]="";
  z[lc++]="  *core_srate = desc.mSampleRate;";
  z[lc++]=" 	";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*                   tries to set buffer latency                    */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_coreaudio_latencyset(AudioDeviceID aid, Boolean input, ";
  z[lc++]="			       double core_srate)";
  z[lc++]="{";
  z[lc++]="  Float32 seconds = ASYS_LATENCY;";
  z[lc++]="  AudioValueRange framerange;";
  z[lc++]="  UInt32 size, framesize;";
  z[lc++]="";
  z[lc++]="  /* use user input or constants to set nominal latency */";
  z[lc++]="";
  z[lc++]="  if (!ASYS_USERLATENCY)";
  z[lc++]="    {";
  z[lc++]="      if (ASYS_LATENCYTYPE == ASYS_HIGHLATENCY)";
  z[lc++]="	seconds = ASYSN_COREAUDIO_HIGHLATENCY;";
  z[lc++]="      else";
  z[lc++]="	seconds = ASYSN_COREAUDIO_LOWLATENCY;";
  z[lc++]="    }";
  z[lc++]="  framesize = (UInt32)(seconds*core_srate + 0.5);";
  z[lc++]="";
  z[lc++]="  /* clip to CoreAudio frame limits */";
  z[lc++]="";
  z[lc++]="  size = sizeof(AudioValueRange);";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceGetProperty(aid, 0, input, ";
  z[lc++]="			     kAudioDevicePropertyBufferFrameSizeRange,";
  z[lc++]="			     &size, &framerange))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Cannot determine current framerange\");";
  z[lc++]="";
  z[lc++]="  framesize = (framesize > framerange.mMinimum) ? framesize : framerange.mMinimum;";
  z[lc++]="  framesize = (framesize < framerange.mMaximum) ? framesize : framerange.mMaximum;";
  z[lc++]="";
  z[lc++]="  framesize = ((framesize < ASYSN_COREAUDIO_TRUEMAXFRAMES) ? ";
  z[lc++]="	       framesize : ASYSN_COREAUDIO_TRUEMAXFRAMES);";
  z[lc++]="";
  z[lc++]="  /* set the final latency value */";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceSetProperty(aid, 0, 1, input, ";
  z[lc++]="			     kAudioDevicePropertyBufferFrameSize, ";
  z[lc++]="			     sizeof(UInt32), &framesize))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Error reconfiguring the framesize\");";
  z[lc++]="";
  z[lc++]="  size = sizeof(UInt32);";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceGetProperty(aid, 0, input, ";
  z[lc++]="			     kAudioDevicePropertyBufferFrameSize,";
  z[lc++]="			     &size, &framesize))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Cannot determine current framerange\");";
  z[lc++]="";
  z[lc++]="  /* set leader-tape length */";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_silentframes = ((int)(ASYSN_COREAUDIO_LEADERTIME*";
  z[lc++]="					core_srate/framesize)); ";
  z[lc++]="  asysn_coreaudio_live = ASYS_EXIT;";
  z[lc++]="";
  z[lc++]="  /* for printout routine */";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_frame_seconds = (float)(framesize/core_srate);";
  z[lc++]="  asysn_coreaudio_frame_samples = framesize;";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*               print coreaudio banner to stdout                   */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_coreaudio_printbanner(void)";
  z[lc++]="{";
  z[lc++]="  char * name;";
  z[lc++]="";
  z[lc++]="  printf(\"\\n\");";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_O) || (defined(ASYS_ACTIVE_IO) && defined(ASYS_HASOUTPUT))";
  z[lc++]="  if ((name = asysn_coreaudio_getdevicename(asyso_aid, 0)))";
  z[lc++]="    {";
  z[lc++]="      printf(\"CoreAudio Output: %s.\\n\", name);";
  z[lc++]="      if (asysn_coreaudio_outsize_mismatch)";
  z[lc++]="	printf(\"         WARNING: Discarding extra SAOL outchannels.\\n\");";
  z[lc++]="      free(name);";
  z[lc++]="    }";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_IO) && defined(ASYS_HASINPUT)";
  z[lc++]="  if ((name = asysn_coreaudio_getdevicename(asysi_aid, 1)))";
  z[lc++]="    {";
  z[lc++]="      printf(\"CoreAudio  Input: %s.\\n\", name);";
  z[lc++]="      if (asysn_coreaudio_insize_mismatch)";
  z[lc++]="	printf(\"         WARNING: Discarding extra CoreAudio inputs.\\n\");";
  z[lc++]="      if (asysn_coreaudio_instatus == ASYSN_COREAUDIO_INPUT_ODEF)";
  z[lc++]="	printf(\"         WARNING: Using output device as input \"";
  z[lc++]="	       \"(Multi-device I/O unsupported).\");";
  z[lc++]="      free(name);";
  z[lc++]="    }";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  printf(\"\\n\");";
  z[lc++]="  printf(\"Buffer latency: %lfs [%u frames]. Adjust with sfront -latency option.\\n\",";
  z[lc++]="	 asysn_coreaudio_frame_seconds, asysn_coreaudio_frame_samples);";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_pagelock)";
  z[lc++]="    printf(\"%i pages locked into RAM.\\n\", asysn_coreaudio_pagetot);";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      switch (asysn_coreaudio_pageinfo) {";
  z[lc++]="      case ASYSN_COREAUDIO_STATFAIL:";
  z[lc++]="	printf(\"Failed to page in working set: expect artifacts\\n\");";
  z[lc++]="	break;";
  z[lc++]="      case ASYSN_COREAUDIO_SHORTRAM:";
  z[lc++]="	printf(\"Not enough RAM to page in full working set: expect artifacts\\n\");";
  z[lc++]="	break;";
  z[lc++]="      case ASYSN_COREAUDIO_PAGEIN:";
  z[lc++]="	printf(\"Working set (%i pages) paged in RAM; could not lock pages.\\n\",";
  z[lc++]="	       asysn_coreaudio_pagetot);";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  printf(\"\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*             generic coreaudio device listenerproc                */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="OSStatus asysn_coreaudio_devlisten(AudioDeviceID inDevice, ";
  z[lc++]="				   UInt32 inChannel,";
  z[lc++]="				   Boolean isInput,";
  z[lc++]="				   AudioDevicePropertyID inPropertyID,";
  z[lc++]="				   void * inClientData)";
  z[lc++]="{";
  z[lc++]="  UInt32 retcode = ASYSN_COREAUDIO_PIPE_LPROC; ";
  z[lc++]="  UInt32 size = sizeof(UInt32);";
  z[lc++]="  UInt32 state;";
  z[lc++]="";
  z[lc++]="  /* for now, only monitoring properties that return UInt32's   */";
  z[lc++]="  /* this will need to be more general for arbitrary properties */";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceGetProperty(inDevice, inChannel, isInput, inPropertyID, ";
  z[lc++]="			     &size, &state))";
  z[lc++]="    return kAudioHardwareNoError;";
  z[lc++]="";
  z[lc++]="  if ((inPropertyID == kAudioDevicePropertyDeviceIsAlive) && state)";
  z[lc++]="    return kAudioHardwareNoError;";
  z[lc++]="";
  z[lc++]="  if (write(asysn_coreaudio_pipepair[1], &retcode, sizeof(UInt32)) < 0)";
  z[lc++]="    perror(\"Error writing asys_main pipe\");";
  z[lc++]="";
  z[lc++]="  return kAudioHardwareNoError;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*              set up listener procs for a device                  */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_coreaudio_setup_dlisten(AudioDeviceID aid, int input)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  /* for testing purpose: mute key emulates device disconnect */";
  z[lc++]="";
  z[lc++]="#if (ASYSN_COREAUDIO_LPROC_MUTETEST)";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceAddPropertyListener(aid, 0, input, ";
  z[lc++]="				     kAudioDevicePropertyMute,";
  z[lc++]="				     asysn_coreaudio_devlisten,";
  z[lc++]="				     (void *) NULL))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Cannot add new PropertyListener to device\");";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* monitor device disconnect property */";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceAddPropertyListener(aid, 0, input, ";
  z[lc++]="				     kAudioDevicePropertyDeviceIsAlive,";
  z[lc++]="				     asysn_coreaudio_devlisten,";
  z[lc++]="				     (void *) NULL))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Cannot add new PropertyListener to device\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*              shutdown listener procs for a device                */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_coreaudio_shutdown_dlisten(AudioDeviceID aid, int input)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  /* remove all properties added in _setup_ above */";
  z[lc++]="";
  z[lc++]="#if (ASYSN_COREAUDIO_LPROC_MUTETEST)";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceRemovePropertyListener(aid, 0, input, ";
  z[lc++]="					kAudioDevicePropertyMute,";
  z[lc++]="					asysn_coreaudio_devlisten))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Cannot remove PropertyListener from device\");";
  z[lc++]="  ";
  z[lc++]="#endif";
  z[lc++]="  ";
  z[lc++]="  if (AudioDeviceRemovePropertyListener(aid, 0, input, ";
  z[lc++]="					kAudioDevicePropertyDeviceIsAlive,";
  z[lc++]="					asysn_coreaudio_devlisten))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Cannot remove PropertyListener from device\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/* coreaudio audio output only: ASYS_ACTIVE_O + one ASYS_ACTIVE_IO  */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(int srate, int ochannels, int osample, ";
  z[lc++]="		char * oname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  Float64 core_srate;";
  z[lc++]="  UInt32 core_numchan, numstreams;";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_page();";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_globalsetup())";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_devicesetup(&asyso_aid, 0))";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_streaminfo(asyso_aid, 0, &numstreams, &core_srate,";
  z[lc++]="				 &core_numchan)) ";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (((int) core_srate) != srate)";
  z[lc++]="    {";
  z[lc++]="      if (asysn_coreaudio_reconfigure(asyso_aid, 0, srate, &core_srate))";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="      if (((int) core_srate) != srate)";
  z[lc++]="	{";
  z[lc++]="	  printf(\"Error: CoreAudio cannot handle SAOL srate %li\\n\",srate);";
  z[lc++]="	  printf(\"       Change SAOL program srate to %li\\n\", (int) core_srate);";
  z[lc++]="	  return ASYS_ERROR;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (asysn_coreaudio_streaminfo(asyso_aid, 0, &numstreams, &core_srate,";
  z[lc++]="				     &core_numchan)) ";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_latencyset(asyso_aid, 0, core_srate))";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceAddIOProc(asyso_aid, asysn_coreaudio_only_output,";
  z[lc++]="			   (void *) NULL))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Cannot add new IOProc to device\");";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_outsize_mismatch = ((ochannels < core_numchan) &&";
  z[lc++]="				      (ochannels > 1));";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_setup_dlisten(asyso_aid, 0))";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_printbanner();";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif /* CoreAudio output, no input or passive input */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/* coreaudio audio input only: an ASYS_ACTIVE_IO case           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(int srate, int ichannels, int isample, ";
  z[lc++]="		char * iname, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  UInt32 in_numchan, in_numstreams;";
  z[lc++]="  Float64 in_srate;";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_page();";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_globalsetup())";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_devicesetup(&asysi_aid, 0))";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_streaminfo(asysi_aid, 1, &in_numstreams, &in_srate,";
  z[lc++]="				 &in_numchan)) ";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (((int) in_srate) != srate)";
  z[lc++]="    {";
  z[lc++]="      if (asysn_coreaudio_reconfigure(asysi_aid, 1, srate, &in_srate))";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="      if (((int) in_srate) != srate)";
  z[lc++]="	{";
  z[lc++]="	  printf(\"Error: CoreAudio cannot handle SAOL srate %li\\n\",srate);";
  z[lc++]="	  printf(\"       Change SAOL program srate to %li\\n\", (int) in_srate);";
  z[lc++]="	  return ASYS_ERROR;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (asysn_coreaudio_streaminfo(asysi_aid, 1, &in_numstreams, &in_srate,";
  z[lc++]="				     &in_numchan)) ";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_latencyset(asysi_aid, 1, in_srate))";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceAddIOProc(asysi_aid, asysn_coreaudio_only_input,";
  z[lc++]="			   (void *) NULL))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Cannot add new IOProc to device\");";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_insize_mismatch = ((ichannels < in_numchan) && ";
  z[lc++]="				     (in_numchan > 1));";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_setup_dlisten(asysi_aid, 1))";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_printbanner();";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   coreaudio input and output: an ASYS_ACTIVE_IO case         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(int srate, int ichannels, int ochannels,";
  z[lc++]="		 int isample, int osample, ";
  z[lc++]="		 char * iname, char * oname, int toption)";
  z[lc++]="{";
  z[lc++]="  UInt32 in_numchan, out_numchan, in_numstreams, out_numstreams;";
  z[lc++]="  Float64 in_srate, out_srate;";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_page();";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_globalsetup())";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_iodevicesetup())";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_streaminfo(asyso_aid, 0, &out_numstreams, &out_srate,";
  z[lc++]="				 &out_numchan)) ";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_streaminfo(asysi_aid, 1, &in_numstreams, &in_srate,";
  z[lc++]="				 &in_numchan)) ";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if ((((int) in_srate) != srate) || (((int) out_srate) != srate))";
  z[lc++]="    {";
  z[lc++]="      if (asysn_coreaudio_reconfigure(asyso_aid, 0, srate, &out_srate))";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="      if (asysn_coreaudio_reconfigure(asysi_aid, 1, srate, &in_srate))";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="      if ((((int) in_srate) != srate) || (((int) out_srate) != srate))";
  z[lc++]="	ASYSIO_ERROR_RETURN(\"Audio output device srate mismatch\");";
  z[lc++]="";
  z[lc++]="      if (asysn_coreaudio_streaminfo(asyso_aid, 0, &out_numstreams, &out_srate,";
  z[lc++]="				     &out_numchan)) ";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="      if (asysn_coreaudio_streaminfo(asysi_aid, 1, &in_numstreams, &in_srate,";
  z[lc++]="				     &in_numchan)) ";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_latencyset(asyso_aid, 0, out_srate))";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceAddIOProc(asyso_aid, asysn_coreaudio_input_output,";
  z[lc++]="			   (void *) NULL))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Cannot add new IOProc to device\");";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_outsize_mismatch = ((ochannels < out_numchan) &&";
  z[lc++]="				      (ochannels > 1));";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_insize_mismatch = ((ichannels < in_numchan) && ";
  z[lc++]="				     (in_numchan > 1));";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_setup_dlisten(asyso_aid, 0))";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_setup_dlisten(asysi_aid, 1))";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_printbanner();";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*   asys_main function  */";
  z[lc++]="/*-----------------------*/";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*        asys_main: starts IOProc, waits for error or exit         */";
  z[lc++]="/********************************************************************/";
  z[lc++]=" ";
  z[lc++]="void asys_main(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  UInt32 retcode;";
  z[lc++]="  int ret, pval, retry;";
  z[lc++]="  fd_set pset;";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="  /* set up passive input */";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_ibuf = NULL;";
  z[lc++]="  asysn_coreaudio_iptr  = 0;";
  z[lc++]="  asysn_coreaudio_ilast = 0;";
  z[lc++]="";
  z[lc++]="  if ((asys_getbuf(&asysn_coreaudio_ibuf, &asysn_coreaudio_ilast) ";
  z[lc++]="       != ASYS_DONE) || (asysn_coreaudio_ilast == 0))";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="  /* set up passive output */";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_obuf = NULL;";
  z[lc++]="  asysn_coreaudio_optr  = 0;";
  z[lc++]="  asysn_coreaudio_olast = 0;";
  z[lc++]="";
  z[lc++]="  if (asys_preamble(&asysn_coreaudio_obuf,&asysn_coreaudio_olast) != ASYS_DONE)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* start the correct device */";
  z[lc++]=" ";
  z[lc++]="#if defined(ASYS_ACTIVE_O) || (defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceStart(asyso_aid, asysn_coreaudio_only_output))";
  z[lc++]="    ASYSIO_ERROR_EMPTYRETURN(\"Cannot start audio output\");";
  z[lc++]="";
  z[lc++]="#endif /* ASYS_ACTIVE_O */";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_IO) && defined(ASYS_HASINPUT) && defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceStart(asyso_aid, asysn_coreaudio_input_output))";
  z[lc++]="    ASYSIO_ERROR_EMPTYRETURN(\"Cannot start audio input/output\");";
  z[lc++]="";
  z[lc++]="#endif /* ASYS_HASINPUT && ASYS_HASOUTPUT */";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="  if (AudioDeviceStart(asysi_aid, asysn_coreaudio_only_input))";
  z[lc++]="    ASYSIO_ERROR_EMPTYRETURN(\"Cannot start audio input\");";
  z[lc++]="";
  z[lc++]="#endif /* ASYS_ACTIVE_IO && !ASYS_HASOUTPUT */";
  z[lc++]=" ";
  z[lc++]="  /* wait for interesting things to happen ... */";
  z[lc++]="";
  z[lc++]="  pval = asysn_coreaudio_pipepair[0];";
  z[lc++]="";
  z[lc++]="  do {";
  z[lc++]="    FD_ZERO(&pset);";
  z[lc++]="    FD_SET(pval, &pset);";
  z[lc++]="    ret = select(pval + 1, &pset, NULL, NULL, NULL);";
  z[lc++]="";
  z[lc++]="    /* ignore signal-interrupted select()'s */";
  z[lc++]="    ";
  z[lc++]="    if ((ret < 0) && ((errno == EINTR) || (errno == EAGAIN)))";
  z[lc++]="      continue;";
  z[lc++]="    ";
  z[lc++]="    /* check for normal end */";
  z[lc++]="    ";
  z[lc++]="    if ((ret == 1) && (FD_ISSET(pval, &pset)))";
  z[lc++]="      {";
  z[lc++]="	if (read(pval, &retcode, sizeof(UInt32)) == sizeof(UInt32))";
  z[lc++]="	  if (retcode == ASYSN_COREAUDIO_PIPE_LPROC)";
  z[lc++]="	    printf(\"Error: CoreAudio HAL requested shutdown.\\n\\n\");";
  z[lc++]="";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="    printf(\"Error: Abnormal select() in asys_main.\\n\\n\");";
  z[lc++]="    break;";
  z[lc++]="";
  z[lc++]="  } while (1);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*   shutdown function suite   */";
  z[lc++]="/*-----------------------------*/";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/*         shutdown function for audio output only scenareo         */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="{";
  z[lc++]="  if (AudioDeviceStop(asyso_aid, asysn_coreaudio_only_output))";
  z[lc++]="    ASYSIO_ERROR_EMPTYRETURN(\"Cannot stop audio output\");";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_shutdown_dlisten(asyso_aid, 0))";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  close(asysn_coreaudio_pipepair[0]);";
  z[lc++]="  close(asysn_coreaudio_pipepair[1]);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (AudioDeviceStop(asysi_aid, asysn_coreaudio_only_input))";
  z[lc++]="    ASYSIO_ERROR_EMPTYRETURN(\"Cannot stop audio input\");";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_shutdown_dlisten(asysi_aid, 1))";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  close(asysn_coreaudio_pipepair[0]);";
  z[lc++]="  close(asysn_coreaudio_pipepair[1]);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (AudioDeviceStop(asyso_aid, asysn_coreaudio_input_output))";
  z[lc++]="    ASYSIO_ERROR_EMPTYRETURN(\"Cannot stop audio output\");";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_shutdown_dlisten(asyso_aid, 0))";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  if (asysn_coreaudio_shutdown_dlisten(asysi_aid, 1))";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  close(asysn_coreaudio_pipepair[0]);";
  z[lc++]="  close(asysn_coreaudio_pipepair[1]);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*   ksync function suite  */";
  z[lc++]="/*-------------------------*/";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_KSYNC)";
  z[lc++]="";
  z[lc++]="float asysn_coreaudio_ksync_normal;   /* normalization value */";
  z[lc++]="float asysn_coreaudio_ksync_lastret;  /* swap-out heuristic  */";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         initializes k-rate boundaries sync              */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void ksyncinit()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysn_coreaudio_ksync_then = 0;";
  z[lc++]="  asysn_coreaudio_ksync_normal = (float) (EV(KRATE)/AudioGetHostClockFrequency());";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  UInt64 now = AudioGetCurrentHostTime();";
  z[lc++]="  float ret;";
  z[lc++]="";
  z[lc++]="  ret = (((float)(now - asysn_coreaudio_ksync_then))*";
  z[lc++]="	 asysn_coreaudio_ksync_normal);";
  z[lc++]="";
  z[lc++]="  if (ret > 1.0F)";
  z[lc++]="    ret = 1.0F;";
  z[lc++]="";
  z[lc++]="  if (ret < 1.0F)";
  z[lc++]="    asysn_coreaudio_ksync_lastret = ret;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      if (asysn_coreaudio_ksync_lastret < 1.0F)";
  z[lc++]="	ret = asysn_coreaudio_ksync_lastret;";
  z[lc++]="      else";
  z[lc++]="	ret = 1.0F;";
  z[lc++]="      asysn_coreaudio_ksync_lastret = 1.0F;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  asysn_coreaudio_ksync_then = now;";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif  /* ASYS_KSYNC */";
  z[lc++]="";
  z[lc++]="#undef  ASYSIO_ERROR_REPORT";
  z[lc++]="#undef  ASYSIO_ERROR_RETURN";
  z[lc++]="#undef  ASYSIO_ERROR_EMPTYRETURN";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                    end of coreaudio driver                   */";
  z[lc++]="/*______________________________________________________________*/";
  printlib(lc);
}


void makeaudiounit(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: audiounit audio driver for sfront";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2008, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           Apple AudioUnit audio driver for sfront            */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~*/";
  z[lc++]="/* debug level */";
  z[lc++]="/*_____________*/";
  z[lc++]="";
  z[lc++]="/*  Level 0:  No debugging messages            */";
  z[lc++]="/*  Level 1:  Session setup and error messages */";
  z[lc++]="/*  Level 2:  + All MIDI events                */";
  z[lc++]="/*  Level 3:  + All Rendering calls            */";
  z[lc++]="";
  z[lc++]="#if !defined(ASYS_AUDIOUNIT_DEBUG_LEVEL)";
  z[lc++]="#define ASYS_AUDIOUNIT_DEBUG_LEVEL 0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* aucontrol detection */";
  z[lc++]="/*_____________________*/";
  z[lc++]="";
  z[lc++]="#if defined(CSYS_CDRIVER_AUCONTROL) || defined(CSYS_CDRIVER_AUCONTROLM)";
  z[lc++]="#define ASYS_AUDIOUNIT_HAS_AUCONTROL  1";
  z[lc++]="#else";
  z[lc++]="#define ASYS_AUDIOUNIT_HAS_AUCONTROL  0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(CSYS_CDRIVER_AUCONTROLM)";
  z[lc++]="#define ASYS_AUDIOUNIT_MIDISUPPORT  1";
  z[lc++]="#else";
  z[lc++]="#define ASYS_AUDIOUNIT_MIDISUPPORT  0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* reentrant defines */";
  z[lc++]="/*___________________*/";
  z[lc++]="";
  z[lc++]="#if (ENGINE_STYLE == ENGINE_REENTRANT)";
  z[lc++]="#define MY_ENGINE_PTR        My->ENGINE_PTR";
  z[lc++]="#define MY_ENGINE_PTR_COMMA  My->ENGINE_PTR,";
  z[lc++]="#define MY_ENGINE_PTR_ASSIGNED_TO  My->ENGINE_PTR = ";
  z[lc++]="#define MY_ENGINE_PTR_DESTROY_SEMICOLON  free(MY_ENGINE_PTR);";
  z[lc++]="#define MY_ENGINE_PTR_IS_NULL (MY_ENGINE_PTR == NULL)";
  z[lc++]="#define MY_ENGINE_PTR_IS_NOT_NULL (MY_ENGINE_PTR != NULL)";
  z[lc++]="#define ENGINE_MEMSTATUS_SEMICOLON(x) \\";
  z[lc++]="        asysn_audiounit_memstatus(ENGINE_PTR, ENGINE_SIZE, x);";
  z[lc++]="#else";
  z[lc++]="#define MY_ENGINE_PTR ";
  z[lc++]="#define MY_ENGINE_PTR_COMMA ";
  z[lc++]="#define MY_ENGINE_PTR_ASSIGNED_TO  ";
  z[lc++]="#define MY_ENGINE_PTR_DESTROY_SEMICOLON ";
  z[lc++]="#define MY_ENGINE_PTR_IS_NULL (0)";
  z[lc++]="#define MY_ENGINE_PTR_IS_NOT_NULL (1)";
  z[lc++]="#define ENGINE_MEMSTATUS_SEMICOLON(x) ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* include headers */";
  z[lc++]="/*_________________*/";
  z[lc++]="";
  z[lc++]="#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)";
  z[lc++]="#include <CoreServices/CoreServices.h>";
  z[lc++]="#include <AudioUnit/AudioUnit.h>";
  z[lc++]="#include <AudioToolbox/AudioUnitUtilities.h>";
  z[lc++]="#else";
  z[lc++]="#include <ConditionalMacros.h>";
  z[lc++]="#include <CoreServices.h>";
  z[lc++]="#include <AudioUnit.h>";
  z[lc++]="#include <AudioUnitUtilities.h>";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/* 64-bit integer headers */";
  z[lc++]="";
  z[lc++]="#include <stdint.h>";
  z[lc++]="";
  z[lc++]="/* for control driver socket system */";
  z[lc++]="";
  z[lc++]="#include <sys/types.h>";
  z[lc++]="#include <sys/socket.h>";
  z[lc++]="#include <unistd.h>";
  z[lc++]="#include <sys/uio.h>";
  z[lc++]="#include <fcntl.h>";
  z[lc++]="";
  z[lc++]="/* include files for memory paging */";
  z[lc++]="";
  z[lc++]="#include <sys/mman.h>";
  z[lc++]="";
  z[lc++]="/* include files for synchronization */";
  z[lc++]="";
  z[lc++]="#include <libkern/OSAtomic.h>";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* endian detection */";
  z[lc++]="/*__________________*/";
  z[lc++]="";
  z[lc++]="Float32 asysn_audiounit_float32_endian_test = -1;";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_FLOAT32_BIGENDIAN \\";
  z[lc++]="        ((((char *)(&asysn_audiounit_float32_endian_test))[0]) != 0)";
  z[lc++]=" ";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*     audiounit defines     */";
  z[lc++]="/*___________________________*/";
  z[lc++]="";
  z[lc++]="/* after if if-tree runs, only one audio type should be 1 */";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASINPUT) && defined(ASYS_HASOUTPUT) && defined(ASYS_ACTIVE_O))";
  z[lc++]="#define ASYS_AUDIOUNIT_MUSICDEVICE 1";
  z[lc++]="#else";
  z[lc++]="#define ASYS_AUDIOUNIT_MUSICDEVICE 0";
  z[lc++]="#endif";
  z[lc++]="                                     ";
  z[lc++]="#if (defined(ASYS_HASINPUT) && defined(ASYS_HASOUTPUT) && defined(ASYS_ACTIVE_IO))";
  z[lc++]="#define ASYS_AUDIOUNIT_EFFECT 1";
  z[lc++]="#else";
  z[lc++]="#define ASYS_AUDIOUNIT_EFFECT 0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*  The Wiretap Macro Calls */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/********************/";
  z[lc++]="/* level one macros */";
  z[lc++]="/********************/";
  z[lc++]="";
  z[lc++]="#if (ASYS_AUDIOUNIT_DEBUG_LEVEL >= 1)";
  z[lc++]=" ";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP(a, b) do {\\";
  z[lc++]="      asysn_audiounit_wiretap(a, b);\\";
  z[lc++]="      } while (0)";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP_PUTSTRING(a) do {\\";
  z[lc++]="      asysn_audiounit_wiretap_putstring(a);\\";
  z[lc++]="      } while (0)";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP_PRINT_COMPONENT_RESULT(a) do {\\";
  z[lc++]="      asysn_audiounit_wiretap_print_component_result(a);\\";
  z[lc++]="      } while (0)";
  z[lc++]="";
  z[lc++]="#else";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP(a, b) do { } while (0)";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP_PUTSTRING(a) do { } while (0)";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP_PRINT_COMPONENT_RESULT(a) do { } while (0)";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/********************/";
  z[lc++]="/* level two macros */";
  z[lc++]="/********************/";
  z[lc++]="";
  z[lc++]="#if (ASYS_AUDIOUNIT_DEBUG_LEVEL >= 2)";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP_MIDIEVENT(a, b, c, d, e, f) do {\\";
  z[lc++]="      asysn_audiounit_wiretap_midievent(a, b, c, d, e, f);\\";
  z[lc++]="      } while (0)";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP_M(a, b) do {\\";
  z[lc++]="      asysn_audiounit_wiretap(a, b);\\";
  z[lc++]="      } while (0)";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP_GETPARAMETER(a, b, c, d, e, f) do {\\";
  z[lc++]="      asysn_audiounit_wiretap_getparameter(a, b, c, d, e, f);\\";
  z[lc++]="      } while (0)";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP_SETPARAMETER(a, b, c, d, e, f, g) do {\\";
  z[lc++]="      asysn_audiounit_wiretap_setparameter(a, b, c, d, e, f, g);\\";
  z[lc++]="      } while (0)";
  z[lc++]="#else";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP_MIDIEVENT(a, b, c, d, e, f) do { } while (0)";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP_M(a, b) do { } while (0)";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP_GETPARAMETER(a, b, c, d, e, f) do { } while (0)";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP_SETPARAMETER(a, b, c, d, e, f, g) do { } while (0)";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/**********************/";
  z[lc++]="/* level three macros */";
  z[lc++]="/**********************/";
  z[lc++]="";
  z[lc++]="#if (ASYS_AUDIOUNIT_DEBUG_LEVEL >= 3)";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP_RENDERER(a, b, c, d, e, f) do {\\";
  z[lc++]="      asysn_audiounit_wiretap_renderer(a, b, c, d, e, f);\\";
  z[lc++]="      } while (0)";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP_R(a, b) do {\\";
  z[lc++]="      asysn_audiounit_wiretap(a, b);\\";
  z[lc++]="      } while (0)";
  z[lc++]="";
  z[lc++]="#else";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP_RENDERER(a, b, c, d, e, f) do { } while (0)";
  z[lc++]="#define ASYS_AUDIOUNIT_WIRETAP_R(a, b) do { } while (0)";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        Part One: Sfront asys_ dummy function calls           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="        ";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(int srate, int ochannels, int osample, ";
  z[lc++]="		char * oname, int toption) { return ASYS_DONE; }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(int srate, int ichannels, int isample, ";
  z[lc++]="                char * iname, int toption) { return ASYS_DONE; }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(int srate, int ichannels, int ochannels,";
  z[lc++]="                 int isample, int osample, char * iname, ";
  z[lc++]="		 char * oname, int toption) { return ASYS_DONE; }";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)  { }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void) { }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void) { }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        syntactically necessary, but will never be called     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_main(void) { }";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*   ksync function suite  */";
  z[lc++]="/*-------------------------*/";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_KSYNC)";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         initializes k-rate boundaries sync              */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void ksyncinit() { }";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync() {  return 0.0F; }  /* encodes \"uses no CPU\" */";
  z[lc++]="";
  z[lc++]="#endif   /* ASYS_KSYNC */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*************************************************************/";
  z[lc++]="/*         Start of Part Two: The AudioUnit Component        */";
  z[lc++]="/*************************************************************/";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*  AudioUnit Property Constants  */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_NULL    0";
  z[lc++]="#define ASYS_AUDIOUNIT_MONO    1";
  z[lc++]="#define ASYS_AUDIOUNIT_STEREO  2";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_OUTPUT_MAXCHANNELS ASYS_AUDIOUNIT_STEREO";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="#define ASYS_AUDIOUNIT_INPUT_MAXCHANNELS  ASYS_AUDIOUNIT_STEREO";
  z[lc++]="#define ASYS_AUDIOUNIT_SUPPORTED_FORMATS  4";
  z[lc++]="#else";
  z[lc++]="#define ASYS_AUDIOUNIT_INPUT_MAXCHANNELS  0";
  z[lc++]="#define ASYS_AUDIOUNIT_SUPPORTED_FORMATS  2";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/* static input and output channels, from SAOL program */";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_OUTPUT_CHANNELS (ENDBUS_output_bus - BUS_output_bus)";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="#define ASYS_AUDIOUNIT_INPUT_CHANNELS (ENDBUS_input_bus - BUS_input_bus)";
  z[lc++]="#else";
  z[lc++]="#define ASYS_AUDIOUNIT_INPUT_CHANNELS 0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/* element limits */";
  z[lc++]="";
  z[lc++]="#if (ASYS_AUDIOUNIT_EFFECT)";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_ELEMENT_INPUTPREF   1  /* our default */";
  z[lc++]="#define ASYS_AUDIOUNIT_ELEMENT_INPUTMAX    8  /* maximum we accept */";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_ELEMENT_OUTPUTPREF  1  /* our default */";
  z[lc++]="#define ASYS_AUDIOUNIT_ELEMENT_OUTPUTMAX   1  /* maximum we accept */";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE   8  /* for I-bound data structures */";
  z[lc++]="";
  z[lc++]="#else";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_ELEMENT_INPUTPREF   0  /* our default */";
  z[lc++]="#define ASYS_AUDIOUNIT_ELEMENT_INPUTMAX    0  /* maximum we accept */";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_ELEMENT_OUTPUTPREF  1  /* our default */";
  z[lc++]="#define ASYS_AUDIOUNIT_ELEMENT_OUTPUTMAX   1  /* maximum we accept */";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE   1  /* for I-bound data structures */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/* maximum number of frames per slice */";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_FRAMES_PER_SLICE  4096";
  z[lc++]="";
  z[lc++]="/* in-place processing not supported */";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_INPLACE_PROCESSING 0 ";
  z[lc++]="";
  z[lc++]="/* number of instruments -- only used by MusicDevice */";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_INSTRUMENT_COUNT  1 ";
  z[lc++]="";
  z[lc++]="/* constants for property listeners */";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_PROPLISTEN_PARAMETERINFO  0";
  z[lc++]="#define ASYS_AUDIOUNIT_PROPLISTEN_PARAMETERLIST  1";
  z[lc++]="#define ASYS_AUDIOUNIT_PROPLISTEN_CPULOAD        2";
  z[lc++]="#define ASYS_AUDIOUNIT_PROPLISTEN_LATENCY        3";
  z[lc++]="#define ASYS_AUDIOUNIT_PROPLISTEN_TAILTIME       4";
  z[lc++]="#define ASYS_AUDIOUNIT_PROPLISTEN_FACTORYPRESETS 5";
  z[lc++]="#define ASYS_AUDIOUNIT_PROPLISTEN_RENDERQUALITY  6";
  z[lc++]="#define ASYS_AUDIOUNIT_PROPLISTEN_CURRENTPRESET  7";
  z[lc++]="#define ASYS_AUDIOUNIT_PROPLISTEN_PRESENTPRESET  8";
  z[lc++]="#define ASYS_AUDIOUNIT_PROPLISTEN_STREAMFROMDISK 9";
  z[lc++]="#define ASYS_AUDIOUNIT_PROPLISTEN_ARRAYSIZE     10   /* ++ for each property added */";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*  reset/paging behaviors   */";
  z[lc++]="/*___________________________*/";
  z[lc++]="";
  z[lc++]="/* active reset does Uninitialize/Initialize for ResetSelect */";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_PASSIVE_RESET 0";
  z[lc++]="#define ASYS_AUDIOUNIT_ACTIVE_RESET  1";
  z[lc++]="#define ASYS_AUDIOUNIT_RESET_TYPE ASYS_AUDIOUNIT_PASSIVE_RESET";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* istate-machine constants  */";
  z[lc++]="/*___________________________*/";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_ISTATE_ABSENT           0 ";
  z[lc++]="#define ASYS_AUDIOUNIT_ISTATE_INSTANCE         1";
  z[lc++]="#define ASYS_AUDIOUNIT_ISTATE_INSTANCE_PASSING 2";
  z[lc++]="#define ASYS_AUDIOUNIT_ISTATE_FLUX             3";
  z[lc++]="#define ASYS_AUDIOUNIT_ISTATE_FLUX_PASSING     4";
  z[lc++]="#define ASYS_AUDIOUNIT_ISTATE_ENGINE           5";
  z[lc++]="#define ASYS_AUDIOUNIT_ISTATE_ENGINE_PASSING   6";
  z[lc++]="#define ASYS_AUDIOUNIT_ISTATE_ENGINE_RENDER    7";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* istate-machine return values  */";
  z[lc++]="/*_______________________________*/";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_IRESPONSE_COMPLETE               0";
  z[lc++]="#define ASYS_AUDIOUNIT_IRESPONSE_INITIALIZE             1";
  z[lc++]="#define ASYS_AUDIOUNIT_IRESPONSE_UNINITIALIZE           2";
  z[lc++]="#define ASYS_AUDIOUNIT_IRESPONSE_CLOSE                  3";
  z[lc++]="#define ASYS_AUDIOUNIT_IRESPONSE_RENDER                 4";
  z[lc++]="#define ASYS_AUDIOUNIT_IRESPONSE_WIRE                   5";
  z[lc++]="#define ASYS_AUDIOUNIT_IRESPONSE_REINITIALIZE           6";
  z[lc++]="#define ASYS_AUDIOUNIT_IRESPONSE_REUNINITIALIZE         7";
  z[lc++]="#define ASYS_AUDIOUNIT_IRESPONSE_UNINITIALIZE_AND_CLOSE 8";
  z[lc++]="#define ASYS_AUDIOUNIT_IRESPONSE_MY_IS_NULL             9";
  z[lc++]="#define ASYS_AUDIOUNIT_IRESPONSE_ERROR                 10";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*   Control Driver Constants     */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/* retry limit for socket writing */";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_RETRY_MAX  256";
  z[lc++]="";
  z[lc++]="/* bitfield constants for MIDIevent flags variable */";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_MIDIFLAGS_WAITING 0x01u  /* queuing flag bit */";
  z[lc++]="";
  z[lc++]="/* bitfield constants for SASLevent flags variable */";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_SASLFLAGS_WAITING 0x01u  /* queuing flag bit */";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*   SAOL Parameter Constants    */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_PARAMETER_DEFAULT_UNIT kAudioUnitParameterUnit_Generic";
  z[lc++]="#define ASYS_AUDIOUNIT_PARAMETER_DEFAULT_MINIMUM 0.0F";
  z[lc++]="#define ASYS_AUDIOUNIT_PARAMETER_DEFAULT_MAXIMUM 1.0F";
  z[lc++]="#define ASYS_AUDIOUNIT_PARAMETER_DEFAULT_DEFAULT 0.5F";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*           TypeDefs             */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*  typedef for a MIDI event   */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="typedef struct asysn_audiounit_MIDIevent {";
  z[lc++]="  unsigned char cmd;";
  z[lc++]="  unsigned char d0;";
  z[lc++]="  unsigned char d1;";
  z[lc++]="  unsigned char flags;";
  z[lc++]="  int kcycleidx;";
  z[lc++]="} asysn_audiounit_MIDIevent;";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*  typedef for a SASL event   */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="typedef struct asysn_audiounit_SASLevent {";
  z[lc++]="  int index;";
  z[lc++]="  Float32 value;";
  z[lc++]="  unsigned char flags;";
  z[lc++]="  int kcycleidx;";
  z[lc++]="} asysn_audiounit_SASLevent;";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*  typedef for SAOL parameter */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="typedef struct asysn_audiounit_saolparam {";
  z[lc++]="  Float32 value;";
  z[lc++]="  int index;";
  z[lc++]="  int use;";
  z[lc++]="} asysn_audiounit_saolparam;";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*  typedef for a listener proc  */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="typedef struct asysn_audiounit_proplisten {";
  z[lc++]="  AudioUnitPropertyListenerProc lproc;";
  z[lc++]="  void * lrefcon;";
  z[lc++]="  struct asysn_audiounit_proplisten * next;";
  z[lc++]="} asysn_audiounit_proplisten;";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*  typedef for a render notify proc  */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="typedef struct asysn_audiounit_rendernotify {";
  z[lc++]="  AURenderCallback nproc;";
  z[lc++]="  void * nrefcon;";
  z[lc++]="  struct asysn_audiounit_rendernotify * next;";
  z[lc++]="} asysn_audiounit_rendernotify;";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* typedef for instance state */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="typedef struct asysn_audiounit_InstanceState {";
  z[lc++]="";
  z[lc++]="  ComponentInstance component;  /* component instance ID */";
  z[lc++]="  volatile int istate;          /* initialization state machine */";
  z[lc++]="  ENGINE_PTR_DECLARE_SEMICOLON  /* engine pointer for the instance */";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* mirrored engine state */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  UInt32 acycle;";
  z[lc++]="  Float32 krate;";
  z[lc++]="  volatile uint64_t acycleidx_kcycleidx;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* current value of properties */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  /* common to Effects and MusicDevices */";
  z[lc++]="";
  z[lc++]="  AudioUnitConnection MakeConnection[ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE];";
  z[lc++]="  Float32 CPULoad;";
  z[lc++]="  OSSpinLock lock_CPULoad;";
  z[lc++]="  AudioStreamBasicDescription OutputStreamFormat;";
  z[lc++]="  OSType SRCAlgorithm;";
  z[lc++]="  UInt32 InputElementCount;";
  z[lc++]="  UInt32 OutputElementCount;";
  z[lc++]="  Float64 Latency;";
  z[lc++]="  AUChannelInfo SupportedNumChannels[ASYS_AUDIOUNIT_SUPPORTED_FORMATS];";
  z[lc++]="  UInt32 MaximumFramesPerSlice;";
  z[lc++]="  Float64 TailTime;";
  z[lc++]="  UInt32 BypassEffect;";
  z[lc++]="  UInt32 LastBypassEffect;";
  z[lc++]="  OSStatus LastRenderError;";
  z[lc++]="  AURenderCallbackStruct SetRenderCallback[ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE];";
  z[lc++]="  asysn_audiounit_rendernotify * rendernotify;";
  z[lc++]="  OSSpinLock lock_rendernotify;";
  z[lc++]="  UInt32 RenderQuality;";
  z[lc++]="  UInt32 InPlaceProcessing;";
  z[lc++]="  AUPreset PresentPreset;";
  z[lc++]="  OSSpinLock lock_PresentPreset;";
  z[lc++]="  UInt32 OfflineRender;";
  z[lc++]="  Float64 PresentationLatency;";
  z[lc++]="  UInt32 StreamFromDisk;";
  z[lc++]="  asysn_audiounit_proplisten * proplisteners[ASYS_AUDIOUNIT_PROPLISTEN_ARRAYSIZE];";
  z[lc++]="  OSSpinLock lock_proplisteners;";
  z[lc++]="  OSSpinLock lock_sampledelivery;  /* for MakeConnection and SetRenderCallback */";
  z[lc++]="  ";
  z[lc++]="  /* exclusive to MusicDevices and MusicEffects (?) */";
  z[lc++]="";
  z[lc++]="  UInt32 InstrumentCount;";
  z[lc++]="";
  z[lc++]="  /* properties exclusive to Effects */";
  z[lc++]="";
  z[lc++]="  AudioStreamBasicDescription InputStreamFormat[ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE];";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* per-instance state */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  /* data output array: common to Effects and Music Devices */";
  z[lc++]="";
  z[lc++]="  Float32 * mData_Output[ASYS_AUDIOUNIT_OUTPUT_MAXCHANNELS];";
  z[lc++]="";
  z[lc++]="  /* rendering templates and data carriers: exclusive to Effects */";
  z[lc++]="";
  z[lc++]="  AudioBufferList * AudioBufferTemplate;";
  z[lc++]="  AudioBufferList * AudioBufferCarrier;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* aup_ property state */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  int num_saolparams;";
  z[lc++]="  AudioUnitParameterID * parameterlist;";
  z[lc++]="  AudioUnitParameterInfo * parameterinfo;";
  z[lc++]="  int * pvs_size;";
  z[lc++]="  char *** pvs_cstr;";
  z[lc++]="  asysn_audiounit_saolparam * saolparam;";
  z[lc++]="";
  z[lc++]="  int num_factory;";
  z[lc++]="  Float32 ** factorypreset_values;";
  z[lc++]="  AUPreset * factorypreset_info;";
  z[lc++]="  CFMutableArrayRef factorypreset_array;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~*/";
  z[lc++]="  /* ksync state */";
  z[lc++]="  /*~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  UInt64 ksync_timespent;  /* total time spent in one kpass */";
  z[lc++]="  Float32 ksync_normalize;    /* unit translations: 1/ticks to Hz */";
  z[lc++]="  Float32 ksync_last_cpuload;   /* used for missing data heuristic  */";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* state passed to engine */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  char componentname[32];";
  z[lc++]="";
  z[lc++]="  char mpipeflag[32];";
  z[lc++]="  char mpipevalue[32];";
  z[lc++]="";
  z[lc++]="  char spipeflag[32];";
  z[lc++]="  char spipevalue[32];";
  z[lc++]="";
  z[lc++]="  char * argv[5];";
  z[lc++]="  int argc;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* aucontrol state */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  int mpipepair[2];";
  z[lc++]="  int spipepair[2];";
  z[lc++]="";
  z[lc++]="} asysn_audiounit_InstanceState;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* The page-management system  */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_opencount = 0;   /* number of audiounit instances */";
  z[lc++]="OSSpinLock asysn_audiounit_lock_opencount;      /* protects opencount */";
  z[lc++]="";
  z[lc++]="/********************************************/";
  z[lc++]="/* set memory status of a region of memory  */";
  z[lc++]="/********************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_memstatus(void * addr, size_t len, int advice)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  madvise((caddr_t) addr, len, advice);";
  z[lc++]="  return;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* The ksync system  */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/*********************************************/";
  z[lc++]="/* startup initialization for ksync system   */";
  z[lc++]="/*********************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_ksyncinit(asysn_audiounit_InstanceState * My)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  My->ksync_timespent = 0;";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_CPULoad));";
  z[lc++]="";
  z[lc++]="  My->ksync_normalize = (Float32) (My->krate/AudioGetHostClockFrequency());";
  z[lc++]="  if (My->CPULoad)";
  z[lc++]="    My->ksync_normalize = My->ksync_normalize/My->CPULoad;";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_CPULoad));";
  z[lc++]="";
  z[lc++]="  My->ksync_last_cpuload = 0.0F;   ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/********************************************/";
  z[lc++]="/* computes cpuload value at end of a kpass */";
  z[lc++]="/********************************************/";
  z[lc++]="";
  z[lc++]="Float32 asysn_audiounit_ksync(asysn_audiounit_InstanceState * My)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  UInt64 now = AudioGetCurrentHostTime();";
  z[lc++]="  Float32 ret;";
  z[lc++]="";
  z[lc++]="  ret = My->ksync_normalize*((Float32)(now - My->ksync_timespent));";
  z[lc++]="";
  z[lc++]="  if (ret > 1.0F)";
  z[lc++]="    ret = 1.0F;";
  z[lc++]="";
  z[lc++]="  if (ret < 1.0F)";
  z[lc++]="    My->ksync_last_cpuload = ret;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      ret = My->ksync_last_cpuload;";
  z[lc++]="      My->ksync_last_cpuload = 1.0F;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  My->ksync_timespent = now;";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*    Fast Dispatch Functions     */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/***********************************************/";
  z[lc++]="/* Helper Routine for MIDIEvent Fast Dispatch  */";
  z[lc++]="/***********************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_sendMIDIevent(asysn_audiounit_MIDIevent * MIDIevent,";
  z[lc++]="					      asysn_audiounit_InstanceState * My)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  uint64_t acycleidx_kcycleidx;";
  z[lc++]="  int32_t acycleidx, kcycleidx;";
  z[lc++]="  int write_failed = 0;";
  z[lc++]="  int retry = 0;";
  z[lc++]="  int acount;";
  z[lc++]="";
  z[lc++]="  if (!ASYS_AUDIOUNIT_HAS_AUCONTROL)";
  z[lc++]="    return noErr;";
  z[lc++]="";
  z[lc++]="  /* on entry, MIDIevent->kcycle holds offset of event (in samples) from the */";
  z[lc++]="  /* start of the next buffer. This start time in the sfront engine is coded */";
  z[lc++]="  /* by the tuple (kcycleidx, acycleidx).                                    */";
  z[lc++]="";
  z[lc++]="  acycleidx_kcycleidx = My->acycleidx_kcycleidx;";
  z[lc++]="  kcycleidx = (int32_t)(acycleidx_kcycleidx & 0x00000000FFFFFFFF);";
  z[lc++]="  acycleidx = (int32_t)(acycleidx_kcycleidx >> 32);";
  z[lc++]="";
  z[lc++]="  acount = acycleidx + MIDIevent->kcycleidx;";
  z[lc++]="  MIDIevent->kcycleidx = kcycleidx;";
  z[lc++]="";
  z[lc++]="  /* initialization of acycleidx_kcycleidx skirts zero-time condition issue */";
  z[lc++]="";
  z[lc++]="  while (acount >= My->acycle)";
  z[lc++]="    {";
  z[lc++]="      acount -= My->acycle;";
  z[lc++]="      MIDIevent->kcycleidx++;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  while (write(My->mpipepair[1], MIDIevent, sizeof(asysn_audiounit_MIDIevent)) < 0)";
  z[lc++]="    if ((errno != EINTR) || (++retry >= ASYS_AUDIOUNIT_RETRY_MAX))";
  z[lc++]="      {";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING(\"\\tSocket write error in sendMIDIevent\\n\\n\");";
  z[lc++]="	write_failed = 1;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]=" ";
  z[lc++]="  return noErr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***********************************/";
  z[lc++]="/* MIDIEvent Fast Dispatch Handler */";
  z[lc++]="/***********************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_MyMIDIEventProc(void * inComponentStorage,";
  z[lc++]="						UInt32 inStatus,";
  z[lc++]="						UInt32 inData1,";
  z[lc++]="						UInt32 inData2,";
  z[lc++]="						UInt32 inOffsetSampleFrame)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_MIDIevent MIDIevent;";
  z[lc++]="  int result;";
  z[lc++]="";
  z[lc++]="  if (!inComponentStorage)           /* avoid race condition */";
  z[lc++]="    return noErr;";
  z[lc++]="";
  z[lc++]="  MIDIevent.cmd = (unsigned char) inStatus;";
  z[lc++]="  MIDIevent.d0 = (unsigned char)inData1;";
  z[lc++]="  MIDIevent.d1 = (unsigned char)inData2;";
  z[lc++]="  MIDIevent.flags = ASYS_AUDIOUNIT_MIDIFLAGS_WAITING;";
  z[lc++]="  MIDIevent.kcycleidx = (int) inOffsetSampleFrame;";
  z[lc++]="";
  z[lc++]="  result = asysn_audiounit_sendMIDIevent";
  z[lc++]="    (&MIDIevent, (asysn_audiounit_InstanceState *) inComponentStorage);";
  z[lc++]="";
  z[lc++]="  ASYS_AUDIOUNIT_WIRETAP_MIDIEVENT(inComponentStorage, inStatus, inData1, ";
  z[lc++]="				   inData2, inOffsetSampleFrame, \"Fast Dispatch\");";
  z[lc++]="";
  z[lc++]="  return result;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/**************************************************/";
  z[lc++]="/* Helper Routine for GetParameter Fast Dispatch  */";
  z[lc++]="/**************************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_getSASLevent(AudioUnitParameterID inID, ";
  z[lc++]="					     Float32 * outValue,";
  z[lc++]="					     asysn_audiounit_InstanceState * My)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (inID >= My->num_saolparams)";
  z[lc++]="    return kAudioUnitErr_InvalidParameter;";
  z[lc++]="";
  z[lc++]="  *outValue = My->saolparam[inID].value;";
  z[lc++]="  return noErr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/**************************************/";
  z[lc++]="/* GetParameter Fast Dispatch Handler */";
  z[lc++]="/**************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_MyGetParameterProc(void * inComponentStorage,";
  z[lc++]="						   AudioUnitParameterID inID,";
  z[lc++]="						   AudioUnitScope inScope,";
  z[lc++]="						   AudioUnitElement inElement,";
  z[lc++]="						   Float32 * outValue)";
  z[lc++]="{";
  z[lc++]="  int result;";
  z[lc++]="";
  z[lc++]="  if (!inComponentStorage)           /* avoid race condition */";
  z[lc++]="    return noErr;";
  z[lc++]="";
  z[lc++]="  if (inScope != kAudioUnitScope_Global)  /* inScope */";
  z[lc++]="    return kAudioUnitErr_InvalidScope;";
  z[lc++]="";
  z[lc++]="  result = asysn_audiounit_getSASLevent";
  z[lc++]="    (inID, outValue, (asysn_audiounit_InstanceState *) inComponentStorage);";
  z[lc++]="";
  z[lc++]="  ASYS_AUDIOUNIT_WIRETAP_GETPARAMETER(inComponentStorage, inID, inScope, ";
  z[lc++]="				      inElement, outValue, \"Fast Dispatch\");";
  z[lc++]="";
  z[lc++]="  return result;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/**************************************************/";
  z[lc++]="/* Helper Routine for SetParameter Fast Dispatch  */";
  z[lc++]="/**************************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_sendSASLevent(asysn_audiounit_SASLevent * SASLevent,";
  z[lc++]="					      asysn_audiounit_InstanceState * My)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  uint64_t acycleidx_kcycleidx;";
  z[lc++]="  int32_t acycleidx, kcycleidx;";
  z[lc++]="  int write_failed = 0;";
  z[lc++]="  int retry = 0;";
  z[lc++]="  int acount;";
  z[lc++]="";
  z[lc++]="  if (!ASYS_AUDIOUNIT_HAS_AUCONTROL)";
  z[lc++]="    return noErr;";
  z[lc++]="";
  z[lc++]="  /* on entry:                                                               */";
  z[lc++]="  /*            SASLevent->index holds AudioUnit index (not SAOL index) and  */";
  z[lc++]="  /*            has been range-checked.                                      */";
  z[lc++]="  /*                                                                         */";
  z[lc++]="  /*            SASLevent->value is range-checked.                           */";
  z[lc++]="  /*                                                                         */";
  z[lc++]="  /*            SASLevent->flags is not set.                                 */";
  z[lc++]="  /*                                                                         */";
  z[lc++]="  /*            SASLevent->kcycle holds offset of event (in samples) from    */";
  z[lc++]="  /*            the start of the next buffer. This start time in the sfront  */";
  z[lc++]="  /*            engine is coded by the tuple (kcycleidx, acycleidx).         */";
  z[lc++]="";
  z[lc++]="  SASLevent->index = My->saolparam[SASLevent->index].index;";
  z[lc++]="  SASLevent->flags = ASYS_AUDIOUNIT_SASLFLAGS_WAITING;";
  z[lc++]="";
  z[lc++]="  acycleidx_kcycleidx = My->acycleidx_kcycleidx;";
  z[lc++]="  kcycleidx = (int32_t)(acycleidx_kcycleidx & 0x00000000FFFFFFFF);";
  z[lc++]="  acycleidx = (int32_t)(acycleidx_kcycleidx >> 32);";
  z[lc++]="";
  z[lc++]="  acount = acycleidx + SASLevent->kcycleidx;";
  z[lc++]="  SASLevent->kcycleidx = kcycleidx;";
  z[lc++]="";
  z[lc++]="  /* initialization of acycleidx_kcycleidx skirts zero-time condition issue */";
  z[lc++]="";
  z[lc++]="  while (acount >= My->acycle)";
  z[lc++]="    {";
  z[lc++]="      acount -= My->acycle;";
  z[lc++]="      SASLevent->kcycleidx++;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  while (write(My->spipepair[1], SASLevent, sizeof(asysn_audiounit_SASLevent)) < 0)";
  z[lc++]="    if ((errno != EINTR) || (++retry >= ASYS_AUDIOUNIT_RETRY_MAX))";
  z[lc++]="      {";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING(\"\\tSocket write error in sendSASLevent\\n\\n\");";
  z[lc++]="	write_failed = 1;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]=" ";
  z[lc++]="  return noErr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/**************************************/";
  z[lc++]="/* SetParameter Fast Dispatch Handler */";
  z[lc++]="/**************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_MySetParameterProc(void * inComponentStorage,";
  z[lc++]="						   AudioUnitParameterID inID,";
  z[lc++]="						   AudioUnitScope inScope,";
  z[lc++]="						   AudioUnitElement inElement,";
  z[lc++]="						   Float32 inValue,";
  z[lc++]="						   UInt32 inBufferOffsetInFrames)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_InstanceState * My;";
  z[lc++]="  asysn_audiounit_SASLevent SASLevent;";
  z[lc++]="  int result;";
  z[lc++]="";
  z[lc++]="  My = ((asysn_audiounit_InstanceState *) inComponentStorage);";
  z[lc++]="";
  z[lc++]="  if (!My)           /* avoid race condition */";
  z[lc++]="    return noErr;";
  z[lc++]="";
  z[lc++]="  if ((inID < 0) || (inID >= My->num_saolparams))  /* range-check ID */";
  z[lc++]="    return kAudioUnitErr_InvalidParameter;";
  z[lc++]="";
  z[lc++]="  if (inScope != kAudioUnitScope_Global)  /* inScope */";
  z[lc++]="    return kAudioUnitErr_InvalidScope;";
  z[lc++]="";
  z[lc++]="  if (inValue > My->parameterinfo[inID].maxValue)";
  z[lc++]="    inValue = My->parameterinfo[inID].maxValue;";
  z[lc++]="";
  z[lc++]="  if (inValue < My->parameterinfo[inID].minValue)";
  z[lc++]="    inValue = My->parameterinfo[inID].minValue;";
  z[lc++]="";
  z[lc++]="  SASLevent.index = inID;";
  z[lc++]="  SASLevent.value = My->saolparam[inID].value = inValue;";
  z[lc++]="  SASLevent.kcycleidx = (int)(inBufferOffsetInFrames);";
  z[lc++]="";
  z[lc++]="  result = asysn_audiounit_sendSASLevent(&SASLevent, My);";
  z[lc++]="";
  z[lc++]="  ASYS_AUDIOUNIT_WIRETAP_SETPARAMETER(My, inID, inScope, ";
  z[lc++]="				      inElement, inValue, inBufferOffsetInFrames, ";
  z[lc++]="				      \"Fast Dispatch\");";
  z[lc++]="";
  z[lc++]="  return result;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* AUEventListenerNotify support  */";
  z[lc++]="/*                                */";
  z[lc++]="/* To let global variable writes  */";
  z[lc++]="/* by SAOL programs be seen in UI */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/************************************************/";
  z[lc++]="/* checks all variables, does update if needed  */";
  z[lc++]="/************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_eventlistenernotify(asysn_audiounit_InstanceState * My)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  ENGINE_PTR_DECLARE_SEMICOLON";
  z[lc++]="  AudioUnitEvent event;";
  z[lc++]="  Float32 value;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  ENGINE_PTR_ASSIGNED_TO  MY_ENGINE_PTR;  /* for NG() reference */";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < My->num_saolparams; i++)";
  z[lc++]="    if (My->saolparam[i].use & CSYS_WRITTEN)";
  z[lc++]="      if ((value = NG(My->saolparam[i].index)) != My->saolparam[i].value)";
  z[lc++]="	{";
  z[lc++]="	  if (value > My->parameterinfo[i].maxValue)";
  z[lc++]="	    NG(My->saolparam[i].index) = value = My->parameterinfo[i].maxValue;";
  z[lc++]="	  if (value < My->parameterinfo[i].minValue)";
  z[lc++]="	    NG(My->saolparam[i].index) = value = My->parameterinfo[i].minValue;";
  z[lc++]="	  ";
  z[lc++]="	  if (value != My->saolparam[i].value)";
  z[lc++]="	    {";
  z[lc++]="	      My->saolparam[i].value = value;";
  z[lc++]="	      event.mEventType = kAudioUnitEvent_ParameterValueChange; ";
  z[lc++]="	      event.mArgument.mParameter.mAudioUnit = My->component; ";
  z[lc++]="	      event.mArgument.mParameter.mParameterID = i;";
  z[lc++]="	      event.mArgument.mParameter.mScope = kAudioUnitScope_Global; ";
  z[lc++]="	      event.mArgument.mParameter.mElement = 0; ";
  z[lc++]="	      OSMemoryBarrier();";
  z[lc++]="	      AUEventListenerNotify(NULL, NULL, &event);";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*------------------------------------------*/";
  z[lc++]="/*  Specialized Renderers for Each AU Type  */";
  z[lc++]="/*------------------------------------------*/";
  z[lc++]="";
  z[lc++]="#if ASYS_AUDIOUNIT_MUSICDEVICE ";
  z[lc++]="";
  z[lc++]="/************************************************************/";
  z[lc++]="/* Helper Routine For Fast-Dispatch Renderer -- MusicDevice */";
  z[lc++]="/************************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_activeo_renderer(asysn_audiounit_InstanceState * My,";
  z[lc++]="				      AudioBufferList * ioData)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  ENGINE_PTR_DECLARE_SEMICOLON";
  z[lc++]="  UInt32 frames = ioData->mBuffers[0].mDataByteSize/sizeof(Float32);";
  z[lc++]="  Float32 eincr, escale;";
  z[lc++]="  UInt32 do_effect, do_bypass;";
  z[lc++]="  Float32 * out_left, * out_right;";
  z[lc++]="  Float32 left;";
  z[lc++]="#if (ASYS_AUDIOUNIT_OUTPUT_CHANNELS > ASYS_AUDIOUNIT_MONO)";
  z[lc++]="  Float32 right;";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  ENGINE_PTR_ASSIGNED_TO  MY_ENGINE_PTR;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  if (My->BypassEffect == 0)";
  z[lc++]="    {";
  z[lc++]="      if (My->LastBypassEffect == 0)";
  z[lc++]="	{";
  z[lc++]="	  do_effect = 1;";
  z[lc++]="	  do_bypass = 0;";
  z[lc++]="	  eincr = escale = 0.0F;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  do_effect = 1;";
  z[lc++]="	  do_bypass = 1;";
  z[lc++]="	  eincr = escale = 1.0F/(frames + 1);";
  z[lc++]="	  My->LastBypassEffect = 0;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      if (My->LastBypassEffect == 1)";
  z[lc++]="	{";
  z[lc++]="	  do_effect = 0;";
  z[lc++]="	  do_bypass = 1;";
  z[lc++]="	  eincr = escale = 0.0F;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  do_effect = 1;";
  z[lc++]="	  do_bypass = 1;";
  z[lc++]="	  eincr = - 1.0F/(frames + 1);";
  z[lc++]="	  escale = 1.0F + eincr;";
  z[lc++]="	  My->LastBypassEffect = 1;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  out_left = (Float32 *) (ioData->mBuffers[0].mData);";
  z[lc++]="";
  z[lc++]="  if (ioData->mNumberBuffers > ASYS_AUDIOUNIT_MONO)";
  z[lc++]="    out_right = (Float32 *) (ioData->mBuffers[1].mData);";
  z[lc++]="  else";
  z[lc++]="    out_right = NULL;";
  z[lc++]="";
  z[lc++]="  while (frames)";
  z[lc++]="    if (EV(acycleidx) < EV(ACYCLE))";
  z[lc++]="      {";
  z[lc++]="	memset(&(TB(0)), 0, ENDBUS*sizeof(ASYS_OTYPE));  /* set bus to silence */";
  z[lc++]="	main_apass(ENGINE_PTR);                         /* compute samples    */";
  z[lc++]="";
  z[lc++]="	if (do_effect)";
  z[lc++]="	  {";
  z[lc++]="	    left = TB(BUS_output_bus);";
  z[lc++]="	    if ((left > 1.0F) || (left < -1.0F))";
  z[lc++]="	      left = (left > 0) ? 1.0F : -1.0F;";
  z[lc++]="	    ";
  z[lc++]="	    *out_left = left;";
  z[lc++]="	    ";
  z[lc++]="	    if (out_right)";
  z[lc++]="	      {";
  z[lc++]="#if (ASYS_AUDIOUNIT_OUTPUT_CHANNELS == ASYS_AUDIOUNIT_MONO)";
  z[lc++]="		*out_right = left;";
  z[lc++]="#else";
  z[lc++]="		right = TB(BUS_output_bus + 1);";
  z[lc++]="		if ((right > 1.0F) || (right < -1.0F))";
  z[lc++]="		  right = (right > 0) ? 1.0F : -1.0F;";
  z[lc++]="		*out_right = right;";
  z[lc++]="#endif";
  z[lc++]="	      }";
  z[lc++]="	    else";
  z[lc++]="	      {";
  z[lc++]="#if (ASYS_AUDIOUNIT_OUTPUT_CHANNELS > ASYS_AUDIOUNIT_MONO)";
  z[lc++]="		right = TB(BUS_output_bus + 1);";
  z[lc++]="		if ((right > 1.0F) || (right < -1.0F))";
  z[lc++]="		  right = (right > 0) ? 1.0F : -1.0F;";
  z[lc++]="		*out_left += right;";
  z[lc++]="		*out_left *= 0.5F;";
  z[lc++]="#endif";
  z[lc++]="	      }";
  z[lc++]="";
  z[lc++]="	    if (do_bypass)";
  z[lc++]="	      {";
  z[lc++]="		*out_left *= escale;";
  z[lc++]="		if (out_right)";
  z[lc++]="		  *out_right *= escale;";
  z[lc++]="		escale += eincr;";
  z[lc++]="	      }";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="	if (do_bypass && !do_effect)";
  z[lc++]="	  {";
  z[lc++]="	    *out_left = 0.0F;";
  z[lc++]="";
  z[lc++]="	    if (out_right)";
  z[lc++]="	      *out_right = 0.0F;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="	out_left++;";
  z[lc++]="";
  z[lc++]="	if (out_right)";
  z[lc++]="	  out_right++;";
  z[lc++]="";
  z[lc++]="	EV(acycleidx)++; frames--;     /* update all positions */";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	EV(acycleidx) = 0;";
  z[lc++]="	if (EV(pass) == APASS)";
  z[lc++]="	  {";
  z[lc++]="	    EV(cpuload) = asysn_audiounit_ksync(My);";
  z[lc++]="  	    EV(kcycleidx)++;         /* we run forever; don't test against endkcycle */";
  z[lc++]="	  }";
  z[lc++]="	EV(pass) = IPASS;";
  z[lc++]="	EV(scorebeats) = EV(scoremult)*(EV(kcycleidx) - EV(kbase)) + EV(scorebase);";
  z[lc++]="	EV(absolutetime) = (EV(kcycleidx) - 1)*EV(KTIME);";
  z[lc++]="	main_ipass(ENGINE_PTR);";
  z[lc++]="	EV(pass) = KPASS;";
  z[lc++]="	main_control(ENGINE_PTR);";
  z[lc++]="	main_kpass(ENGINE_PTR);      /* we run forever; don't check return value */";
  z[lc++]="	if (ASYS_AUDIOUNIT_PARAMETERS_WRITTEN)";
  z[lc++]="	  asysn_audiounit_eventlistenernotify(My);";
  z[lc++]="	EV(pass) = APASS;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  My->acycleidx_kcycleidx = (((uint64_t) (EV(kcycleidx))) & 0x00000000FFFFFFFF) | ";
  z[lc++]="    (((uint64_t) (EV(acycleidx))) << 32);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*****************************************/";
  z[lc++]="/* Fast-Dispatch Renderer -- MusicDevice */";
  z[lc++]="/*****************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_MyRenderer(void * inComponentStorage,";
  z[lc++]="					   AudioUnitRenderActionFlags * ioActionFlags,";
  z[lc++]="					   const AudioTimeStamp * inTimeStamp,";
  z[lc++]="					   UInt32 inOutputBusNumber,";
  z[lc++]="					   UInt32 inNumberFrames,";
  z[lc++]="					   AudioBufferList * ioData)";
  z[lc++]="{";
  z[lc++]="  UInt32 error_code;";
  z[lc++]="  char message[128];";
  z[lc++]="  asysn_audiounit_rendernotify * notify;";
  z[lc++]="  AudioUnitRenderActionFlags action_flags;";
  z[lc++]="  asysn_audiounit_InstanceState * My = ((asysn_audiounit_InstanceState *) ";
  z[lc++]="					inComponentStorage);";
  z[lc++]="  int i, iresponse;";
  z[lc++]="";
  z[lc++]="  if (inNumberFrames > ASYS_AUDIOUNIT_FRAMES_PER_SLICE)";
  z[lc++]="    return kAudioUnitErr_TooManyFramesToProcess;";
  z[lc++]="";
  z[lc++]="  if (!My)";
  z[lc++]="    return kAudioUnitErr_Uninitialized;   /* avoid race condition */";
  z[lc++]="";
  z[lc++]="  switch(iresponse = asysn_audiounit_realtime_enterstate(My)) {";
  z[lc++]="  case ASYS_AUDIOUNIT_IRESPONSE_WIRE:";
  z[lc++]="  case ASYS_AUDIOUNIT_IRESPONSE_RENDER:";
  z[lc++]="    break;";
  z[lc++]="  case ASYS_AUDIOUNIT_IRESPONSE_MY_IS_NULL:";
  z[lc++]="  case ASYS_AUDIOUNIT_IRESPONSE_ERROR:";
  z[lc++]="  default:";
  z[lc++]="    return kAudioUnitErr_Uninitialized;   /* avoid race condition, bugs */";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  /* supply return buffers (only!) if needed */";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < ioData->mNumberBuffers; i++)";
  z[lc++]="    if (ioData->mBuffers[i].mData == NULL)";
  z[lc++]="      ioData->mBuffers[i].mData = (void *) My->mData_Output[i];";
  z[lc++]="";
  z[lc++]="  /* do PreRender notification */";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_rendernotify));";
  z[lc++]="";
  z[lc++]="  notify = My->rendernotify;";
  z[lc++]="  while (notify)";
  z[lc++]="    {";
  z[lc++]="      if (notify->nproc)";
  z[lc++]="	{";
  z[lc++]="	  action_flags = kAudioUnitRenderAction_PreRender;";
  z[lc++]="";
  z[lc++]="	  if (error_code = ((* notify->nproc)";
  z[lc++]="			    (notify->nrefcon, &action_flags, ";
  z[lc++]="			     inTimeStamp, (AudioUnitElement) 0, inNumberFrames,";
  z[lc++]="			     ioData)))";
  z[lc++]="	    {";
  z[lc++]="	      sprintf(message, \"\\nasysn_audiounit_MyRenderer\"";
  z[lc++]="		      \"\\n\\tError: PreRender Rendernotify callback\" ";
  z[lc++]="		      \" returned OSType %u\\n\", error_code);";
  z[lc++]="	      ASYS_AUDIOUNIT_WIRETAP_PUTSTRING(message);";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      notify = notify->next;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_rendernotify));";
  z[lc++]="";
  z[lc++]="  /* the actual rendering done by the audio unit */";
  z[lc++]="";
  z[lc++]="  if (iresponse == ASYS_AUDIOUNIT_IRESPONSE_RENDER)";
  z[lc++]="    {";
  z[lc++]="      My->ksync_timespent = AudioGetCurrentHostTime() - My->ksync_timespent;";
  z[lc++]="      asysn_audiounit_activeo_renderer(My, ioData);";
  z[lc++]="      My->ksync_timespent = AudioGetCurrentHostTime() - My->ksync_timespent;";
  z[lc++]="    }";
  z[lc++]="  else   /* for _WIRE, zero all buffers */";
  z[lc++]="    for (i = 0; i < ioData->mNumberBuffers; i++)  ";
  z[lc++]="      memset(ioData->mBuffers[i].mData, 0, sizeof(Float32)*inNumberFrames);";
  z[lc++]="";
  z[lc++]="  /* do PostRender notification */";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_rendernotify));";
  z[lc++]="";
  z[lc++]="  notify = My->rendernotify;";
  z[lc++]="  while (notify)";
  z[lc++]="    {";
  z[lc++]="      if (notify->nproc)";
  z[lc++]="	{";
  z[lc++]="	  action_flags = kAudioUnitRenderAction_PostRender;";
  z[lc++]="";
  z[lc++]="	  if (error_code = ((* notify->nproc)";
  z[lc++]="			    (notify->nrefcon, &action_flags, ";
  z[lc++]="			     inTimeStamp, (AudioUnitElement) 0, inNumberFrames,";
  z[lc++]="			     ioData)))";
  z[lc++]="	    {";
  z[lc++]="	      sprintf(message, \"\\nasysn_audiounit_MyRenderer\"";
  z[lc++]="		      \"\\n\\tError: PostRender Rendernotify callback\" ";
  z[lc++]="		      \" returned OSType %u\\n\", error_code);";
  z[lc++]="	      ASYS_AUDIOUNIT_WIRETAP_PUTSTRING(message);";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      notify = notify->next;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_rendernotify));";
  z[lc++]="";
  z[lc++]="  asysn_audiounit_realtime_exitstate(My);";
  z[lc++]="";
  z[lc++]="  return noErr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif /* ASYS_AUDIOUNIT_MUSICDEVICE */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if ASYS_AUDIOUNIT_EFFECT";
  z[lc++]="";
  z[lc++]="/********************************************************/";
  z[lc++]="/* Helper Routine For Fast-Dispatch Renderer -- Effects */";
  z[lc++]="/********************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_activeio_renderer(asysn_audiounit_InstanceState * My,";
  z[lc++]="				       AudioBufferList * ioData)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  ENGINE_PTR_DECLARE_SEMICOLON";
  z[lc++]="  UInt32 frames = ioData->mBuffers[0].mDataByteSize/sizeof(Float32);";
  z[lc++]="  Float32 eincr, bincr, escale, bscale;";
  z[lc++]="  UInt32 do_effect, do_bypass;";
  z[lc++]="  Float32 * out_left, * out_right, * in_left, * in_right;";
  z[lc++]="  Float32 left;";
  z[lc++]="#if (ASYS_AUDIOUNIT_OUTPUT_CHANNELS > ASYS_AUDIOUNIT_MONO)";
  z[lc++]="  Float32 right;";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  ENGINE_PTR_ASSIGNED_TO  MY_ENGINE_PTR;";
  z[lc++]="";
  z[lc++]="  if (My->BypassEffect == 0)";
  z[lc++]="    {";
  z[lc++]="      if (My->LastBypassEffect == 0)";
  z[lc++]="	{";
  z[lc++]="	  do_effect = 1;";
  z[lc++]="	  do_bypass = 0;";
  z[lc++]="	  eincr = bincr = bscale = escale = 0.0F;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  do_effect = 1;";
  z[lc++]="	  do_bypass = 1;";
  z[lc++]="	  eincr = escale = 1.0F/(frames + 1);";
  z[lc++]="	  bincr = - eincr;";
  z[lc++]="	  bscale = 1.0F - eincr;";
  z[lc++]="	  My->LastBypassEffect = 0;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      if (My->LastBypassEffect == 1)";
  z[lc++]="	{";
  z[lc++]="	  do_effect = 0;";
  z[lc++]="	  do_bypass = 1;";
  z[lc++]="	  eincr = bincr = bscale = escale = 0.0F;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  do_effect = 1;";
  z[lc++]="	  do_bypass = 1;";
  z[lc++]="	  bincr = bscale = 1.0F/(frames + 1);";
  z[lc++]="	  eincr = - bincr;";
  z[lc++]="	  escale = 1.0F - bincr;";
  z[lc++]="	  My->LastBypassEffect = 1;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  out_left = (Float32 *) (ioData->mBuffers[0].mData);";
  z[lc++]="";
  z[lc++]="  if (ioData->mNumberBuffers > ASYS_AUDIOUNIT_MONO)";
  z[lc++]="    out_right = (Float32 *) (ioData->mBuffers[1].mData);";
  z[lc++]="  else";
  z[lc++]="    out_right = NULL;";
  z[lc++]="";
  z[lc++]="  in_left = (Float32 *) (My->AudioBufferCarrier->mBuffers[0].mData);";
  z[lc++]="";
  z[lc++]="  if (My->AudioBufferCarrier->mNumberBuffers > ASYS_AUDIOUNIT_MONO)";
  z[lc++]="    in_right = (Float32 *) (My->AudioBufferCarrier->mBuffers[1].mData);";
  z[lc++]="  else";
  z[lc++]="    in_right = NULL;";
  z[lc++]="";
  z[lc++]="  while (frames)";
  z[lc++]="    if (EV(acycleidx) < EV(ACYCLE))";
  z[lc++]="      {";
  z[lc++]="	memset(&(TB(0)), 0, ENDBUS*sizeof(ASYS_OTYPE));  /* set bus to silence */";
  z[lc++]="";
  z[lc++]="	TB(BUS_input_bus) = *in_left;";
  z[lc++]=" ";
  z[lc++]="	if (in_right)";
  z[lc++]="	  {";
  z[lc++]="#if (ASYS_AUDIOUNIT_INPUT_CHANNELS > ASYS_AUDIOUNIT_MONO)";
  z[lc++]="	    TB(BUS_input_bus + 1) = *in_right;";
  z[lc++]="#else";
  z[lc++]="	    TB(BUS_input_bus) += *in_right;";
  z[lc++]="	    TB(BUS_input_bus) *= 0.5F;";
  z[lc++]="#endif";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  {";
  z[lc++]="#if (ASYS_AUDIOUNIT_INPUT_CHANNELS > ASYS_AUDIOUNIT_MONO)";
  z[lc++]="	    TB(BUS_input_bus + 1) = *in_left;";
  z[lc++]="#endif";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="	main_apass(ENGINE_PTR);                   /* compute samples    */";
  z[lc++]="";
  z[lc++]="	if (do_effect)";
  z[lc++]="	  {";
  z[lc++]="	    left = TB(BUS_output_bus);";
  z[lc++]="	    if ((left > 1.0F) || (left < -1.0F))";
  z[lc++]="	      left = (left > 0) ? 1.0F : -1.0F;";
  z[lc++]="";
  z[lc++]="	    *out_left = left;";
  z[lc++]="";
  z[lc++]="	    if (out_right)";
  z[lc++]="	      {";
  z[lc++]="#if (ASYS_AUDIOUNIT_OUTPUT_CHANNELS == ASYS_AUDIOUNIT_MONO)";
  z[lc++]="		*out_right = left;";
  z[lc++]="#else";
  z[lc++]="		right = TB(BUS_output_bus + 1);";
  z[lc++]="		if ((right > 1.0F) || (right < -1.0F))";
  z[lc++]="		  right = (right > 0) ? 1.0F : -1.0F;";
  z[lc++]="		*out_right = right;";
  z[lc++]="#endif";
  z[lc++]="	      }";
  z[lc++]="	    else";
  z[lc++]="	      {";
  z[lc++]="#if (ASYS_AUDIOUNIT_OUTPUT_CHANNELS > ASYS_AUDIOUNIT_MONO)";
  z[lc++]="		right = TB(BUS_output_bus + 1);";
  z[lc++]="		if ((right > 1.0F) || (right < -1.0F))";
  z[lc++]="		  right = (right > 0) ? 1.0F : -1.0F;";
  z[lc++]="		*out_left += right;";
  z[lc++]="		*out_left *= 0.5F;";
  z[lc++]="#endif";
  z[lc++]="	      }";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="	if (do_bypass)";
  z[lc++]="	  {";
  z[lc++]="	    if (!do_effect)";
  z[lc++]="	      *out_left = *in_left;";
  z[lc++]="	    else";
  z[lc++]="	      {";
  z[lc++]="		if (out_right || !in_right)";
  z[lc++]="		  *out_left = escale*(*out_left) + bscale*(*in_left);";
  z[lc++]="		else";
  z[lc++]="		  *out_left = escale*(*out_left) + bscale*0.5F*(*in_left);";
  z[lc++]="	      }";
  z[lc++]="";
  z[lc++]="	    if (out_right)";
  z[lc++]="	      {";
  z[lc++]="		if (!do_effect)";
  z[lc++]="		  {";
  z[lc++]="		    if (in_right)";
  z[lc++]="		      *out_right = *in_right;";
  z[lc++]="		    else ";
  z[lc++]="		      *out_right = *in_left;";
  z[lc++]="		  }";
  z[lc++]="		else";
  z[lc++]="		  {";
  z[lc++]="		    if (in_right)";
  z[lc++]="		      *out_right = escale*(*out_right) + bscale*(*in_right);";
  z[lc++]="		    else ";
  z[lc++]="		      *out_right = escale*(*out_right) + bscale*(*in_left);";
  z[lc++]="		  }";
  z[lc++]="	      }";
  z[lc++]="	    else";
  z[lc++]="	      {";
  z[lc++]="		if (in_right)";
  z[lc++]="		  {";
  z[lc++]="		    if (!do_effect)";
  z[lc++]="		      *out_left = 0.5F*(*out_left + *in_right);";
  z[lc++]="		    else";
  z[lc++]="		      *out_left = *out_left + bscale*0.5F*(*in_right);";
  z[lc++]="		  }";
  z[lc++]="	      }";
  z[lc++]="";
  z[lc++]="	    if (do_effect)";
  z[lc++]="	      {";
  z[lc++]="		bscale += bincr;";
  z[lc++]="		escale += eincr;";
  z[lc++]="	      }";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="	in_left++;";
  z[lc++]="	out_left++;";
  z[lc++]="";
  z[lc++]="	if (in_right)";
  z[lc++]="	  in_right++;";
  z[lc++]="";
  z[lc++]="	if (out_right)";
  z[lc++]="	  out_right++;";
  z[lc++]="";
  z[lc++]="	EV(acycleidx)++; frames--;  /* updates */";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	EV(acycleidx) = 0;";
  z[lc++]="	if (EV(pass) == APASS)";
  z[lc++]="	  {      ";
  z[lc++]="	    EV(cpuload) = asysn_audiounit_ksync(My);";
  z[lc++]="	    EV(kcycleidx)++;         /* we run forever; don't test against endkcycle */";
  z[lc++]="	  }";
  z[lc++]="	EV(pass) = IPASS;";
  z[lc++]="	EV(scorebeats) = EV(scoremult)*(EV(kcycleidx) - EV(kbase)) + EV(scorebase);";
  z[lc++]="	EV(absolutetime) = (EV(kcycleidx) - 1)*EV(KTIME);";
  z[lc++]="	main_ipass(ENGINE_PTR);";
  z[lc++]="	EV(pass) = KPASS;";
  z[lc++]="	main_control(ENGINE_PTR);";
  z[lc++]="	main_kpass(ENGINE_PTR);      /* we run forever; don't check return value */";
  z[lc++]="	if (ASYS_AUDIOUNIT_PARAMETERS_WRITTEN)";
  z[lc++]="	  asysn_audiounit_eventlistenernotify(My);";
  z[lc++]="	EV(pass) = APASS;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  My->acycleidx_kcycleidx = (((uint64_t) (EV(kcycleidx))) & 0x00000000FFFFFFFF) | ";
  z[lc++]="    (((uint64_t) (EV(acycleidx))) << 32);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/**********************************************************/";
  z[lc++]="/* Helper Routine For Fast-Dispatch Renderer -- Pass-thru */";
  z[lc++]="/**********************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_activeio_passthru(asysn_audiounit_InstanceState * My,";
  z[lc++]="				       AudioBufferList * ioData)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  UInt32 frames = ioData->mBuffers[0].mDataByteSize/sizeof(Float32);";
  z[lc++]="  Float32 * out_left, * out_right, * in_left, * in_right;";
  z[lc++]="";
  z[lc++]="  out_left = (Float32 *) (ioData->mBuffers[0].mData);";
  z[lc++]="";
  z[lc++]="  if (ioData->mNumberBuffers > ASYS_AUDIOUNIT_MONO)";
  z[lc++]="    out_right = (Float32 *) (ioData->mBuffers[1].mData);";
  z[lc++]="  else";
  z[lc++]="    out_right = NULL;";
  z[lc++]="";
  z[lc++]="  in_left = (Float32 *) (My->AudioBufferCarrier->mBuffers[0].mData);";
  z[lc++]="";
  z[lc++]="  if (My->AudioBufferCarrier->mNumberBuffers > ASYS_AUDIOUNIT_MONO)";
  z[lc++]="    in_right = (Float32 *) (My->AudioBufferCarrier->mBuffers[1].mData);";
  z[lc++]="  else";
  z[lc++]="    in_right = NULL;";
  z[lc++]="";
  z[lc++]="  while (frames)";
  z[lc++]="    {";
  z[lc++]="      *out_left = *in_left;";
  z[lc++]="";
  z[lc++]="      if (out_right)";
  z[lc++]="	{";
  z[lc++]="	  if (in_right)";
  z[lc++]="	    *out_right = *in_right;";
  z[lc++]="	  else ";
  z[lc++]="	    *out_right = *in_left;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	if (in_right)";
  z[lc++]="	  *out_left = 0.5F*(*out_left + *in_right);";
  z[lc++]="      ";
  z[lc++]="      in_left++;";
  z[lc++]="      out_left++;";
  z[lc++]="      ";
  z[lc++]="      if (in_right)";
  z[lc++]="	in_right++;";
  z[lc++]="      ";
  z[lc++]="      if (out_right)";
  z[lc++]="	out_right++;";
  z[lc++]="      ";
  z[lc++]="      frames--;";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*************************************/";
  z[lc++]="/* Fast-Dispatch Renderer -- Effects */";
  z[lc++]="/*************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_MyRenderer(void * inComponentStorage,";
  z[lc++]="					   AudioUnitRenderActionFlags * ioActionFlags,";
  z[lc++]="					   const AudioTimeStamp * inTimeStamp,";
  z[lc++]="					   UInt32 inOutputBusNumber,";
  z[lc++]="					   UInt32 inNumberFrames,";
  z[lc++]="					   AudioBufferList * ioData)";
  z[lc++]="{";
  z[lc++]="  UInt32 error_code;";
  z[lc++]="  char message[128];  ";
  z[lc++]="  asysn_audiounit_rendernotify * notify;";
  z[lc++]="  AudioUnitRenderActionFlags action_flags;";
  z[lc++]="  AudioTimeStamp AudioTimeStampCarrier;";
  z[lc++]="  asysn_audiounit_InstanceState * My = ((asysn_audiounit_InstanceState *) ";
  z[lc++]="					inComponentStorage);";
  z[lc++]="  ComponentResult return_value;";
  z[lc++]="  int i, iresponse;";
  z[lc++]="";
  z[lc++]="  if (inNumberFrames > ASYS_AUDIOUNIT_FRAMES_PER_SLICE)";
  z[lc++]="    return kAudioUnitErr_TooManyFramesToProcess;";
  z[lc++]="";
  z[lc++]="  if (!My)";
  z[lc++]="    return kAudioUnitErr_Uninitialized;    /* avoid race condition */";
  z[lc++]="";
  z[lc++]="  switch(iresponse = asysn_audiounit_realtime_enterstate(My)) {";
  z[lc++]="  case ASYS_AUDIOUNIT_IRESPONSE_WIRE:";
  z[lc++]="  case ASYS_AUDIOUNIT_IRESPONSE_RENDER:";
  z[lc++]="    break;";
  z[lc++]="  case ASYS_AUDIOUNIT_IRESPONSE_MY_IS_NULL:";
  z[lc++]="  case ASYS_AUDIOUNIT_IRESPONSE_ERROR:";
  z[lc++]="  default:";
  z[lc++]="    return kAudioUnitErr_Uninitialized;   /* avoid race condition, bugs */";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  return_value = noErr;";
  z[lc++]="  action_flags = 0;";
  z[lc++]="";
  z[lc++]="  /* prepare AudioTimeStampCarrier */";
  z[lc++]="";
  z[lc++]="  memset(&AudioTimeStampCarrier, 0, sizeof(AudioTimeStamp));";
  z[lc++]="  AudioTimeStampCarrier.mSampleTime = inTimeStamp->mSampleTime;";
  z[lc++]="  AudioTimeStampCarrier.mFlags = kAudioTimeStampSampleTimeValid;";
  z[lc++]="";
  z[lc++]="  /* prepare AudioBufferCarrier */";
  z[lc++]="";
  z[lc++]="  memcpy(My->AudioBufferCarrier, My->AudioBufferTemplate, ";
  z[lc++]="	 sizeof(UInt32) + My->AudioBufferTemplate->mNumberBuffers*sizeof(AudioBuffer));";
  z[lc++]=" ";
  z[lc++]="  for (i = 0; i < My->AudioBufferCarrier->mNumberBuffers; i++)";
  z[lc++]="    My->AudioBufferCarrier->mBuffers[i].mDataByteSize = ";
  z[lc++]="      ioData->mBuffers[0].mDataByteSize;";
  z[lc++]="";
  z[lc++]="  /* retrieve audio samples to process, log errors */ ";
  z[lc++]="  /*   assumptions: ";
  z[lc++]="     - a callback returning noErr returns the amount of data we asked for ";
  z[lc++]="  */";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_sampledelivery));";
  z[lc++]="";
  z[lc++]="  if (My->SetRenderCallback[0].inputProc)";
  z[lc++]="    {";
  z[lc++]="      if (error_code = ((* My->SetRenderCallback[0].inputProc)";
  z[lc++]="			(My->SetRenderCallback[0].inputProcRefCon, &action_flags, ";
  z[lc++]="			 &AudioTimeStampCarrier, (AudioUnitElement) 0, inNumberFrames,";
  z[lc++]="			 My->AudioBufferCarrier)))";
  z[lc++]="	{";
  z[lc++]="	  sprintf(message, \"\\nMyRenderer\"";
  z[lc++]="		  \"\\n\\tError: Render callback returned OSType %u\\n\", error_code);";
  z[lc++]="	  ASYS_AUDIOUNIT_WIRETAP_PUTSTRING(message);";
  z[lc++]="	  return_value = kAudioUnitErr_NoConnection;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      if ((My->MakeConnection[0].sourceAudioUnit == 0) || ";
  z[lc++]="	  (error_code = AudioUnitRender(My->MakeConnection[0].sourceAudioUnit, ";
  z[lc++]="					&action_flags, &AudioTimeStampCarrier, ";
  z[lc++]="					My->MakeConnection[0].sourceOutputNumber,";
  z[lc++]="					inNumberFrames, My->AudioBufferCarrier)))";
  z[lc++]="	{";
  z[lc++]="	  if (My->MakeConnection[0].sourceAudioUnit == 0)";
  z[lc++]="	    {";
  z[lc++]="	      sprintf(message, \"\\nMyRenderer\"";
  z[lc++]="		      \"\\n\\tError: No connection to use with AudioUnitRender\\n\");";
  z[lc++]="	      ASYS_AUDIOUNIT_WIRETAP_PUTSTRING(message);";
  z[lc++]="	      return_value = kAudioUnitErr_NoConnection;";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      sprintf(message, \"\\nMyRenderer\\n\\tError: AudioUnitRender returned:\\n\\t\"); ";
  z[lc++]="	      ASYS_AUDIOUNIT_WIRETAP_PUTSTRING(message);";
  z[lc++]="	      ASYS_AUDIOUNIT_WIRETAP_PRINT_COMPONENT_RESULT(error_code);";
  z[lc++]="	      sprintf(message, \"\\n\"); ";
  z[lc++]="	      ASYS_AUDIOUNIT_WIRETAP_PUTSTRING(message);";
  z[lc++]="	      return_value = error_code;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_sampledelivery));";
  z[lc++]="";
  z[lc++]="  /* supply return buffers (only!) if needed */";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < ioData->mNumberBuffers; i++)  /* straight-wire, no gain */";
  z[lc++]="    if (ioData->mBuffers[i].mData == NULL)";
  z[lc++]="      ioData->mBuffers[i].mData = (void *) My->mData_Output[i];";
  z[lc++]="";
  z[lc++]="  /* do PreRender notification */";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_rendernotify));";
  z[lc++]="";
  z[lc++]="  notify = My->rendernotify;";
  z[lc++]="  while (notify)";
  z[lc++]="    {";
  z[lc++]="      if (notify->nproc)";
  z[lc++]="	{";
  z[lc++]="	  action_flags = kAudioUnitRenderAction_PreRender;";
  z[lc++]="";
  z[lc++]="	  if (error_code = ((* notify->nproc)";
  z[lc++]="			    (notify->nrefcon, &action_flags, ";
  z[lc++]="			     inTimeStamp, (AudioUnitElement) 0, inNumberFrames,";
  z[lc++]="			     ioData)))";
  z[lc++]="	    {";
  z[lc++]="	      sprintf(message, \"\\nasysn_audiounit_MyRenderer\"";
  z[lc++]="		      \"\\n\\tError: PreRender Rendernotify callback\" ";
  z[lc++]="		      \" returned OSType %u\\n\", error_code);";
  z[lc++]="	      ASYS_AUDIOUNIT_WIRETAP_PUTSTRING(message);";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      notify = notify->next;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_rendernotify));";
  z[lc++]="";
  z[lc++]="  /* the actual rendering done by the audio unit */";
  z[lc++]="";
  z[lc++]="  if (return_value == noErr) ";
  z[lc++]="    {";
  z[lc++]="      if (iresponse == ASYS_AUDIOUNIT_IRESPONSE_RENDER)";
  z[lc++]="	{";
  z[lc++]="	  My->ksync_timespent = AudioGetCurrentHostTime() - My->ksync_timespent;";
  z[lc++]="	  asysn_audiounit_activeio_renderer(My, ioData);";
  z[lc++]="	  My->ksync_timespent = AudioGetCurrentHostTime() - My->ksync_timespent;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	asysn_audiounit_activeio_passthru(My, ioData);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    for (i = 0; i < ioData->mNumberBuffers; i++)  /* in case of error, silence */";
  z[lc++]="      memset(ioData->mBuffers[i].mData, 0, ioData->mBuffers[i].mDataByteSize);";
  z[lc++]="";
  z[lc++]="  /* do PostRender notification */";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_rendernotify));";
  z[lc++]="";
  z[lc++]="  notify = My->rendernotify;";
  z[lc++]="  while (notify)";
  z[lc++]="    {";
  z[lc++]="      if (notify->nproc)";
  z[lc++]="	{";
  z[lc++]="	  action_flags = kAudioUnitRenderAction_PostRender;";
  z[lc++]="";
  z[lc++]="	  if (error_code = ((* notify->nproc)";
  z[lc++]="			    (notify->nrefcon, &action_flags, ";
  z[lc++]="			     inTimeStamp, (AudioUnitElement) 0, inNumberFrames,";
  z[lc++]="			     ioData)))";
  z[lc++]="	    {";
  z[lc++]="	      sprintf(message, \"\\nasysn_audiounit_MyRenderer\"";
  z[lc++]="		      \"\\n\\tError: PostRender Rendernotify callback\" ";
  z[lc++]="		      \" returned OSType %u\\n\", error_code);";
  z[lc++]="	      ASYS_AUDIOUNIT_WIRETAP_PUTSTRING(message);";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      notify = notify->next;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_rendernotify));";
  z[lc++]="";
  z[lc++]="  asysn_audiounit_realtime_exitstate(My);";
  z[lc++]="";
  z[lc++]="  return return_value;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif /* ASYS_AUDIOUNIT_EFFECT */";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* Helper Functions for all Selector Calls    */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/* Helper Function for Factory Presets: returns a preset name   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="CFStringRef asysn_audiounit_factorypresetname(CFIndex idx) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  CFStringRef ret = NULL;";
  z[lc++]="  char * nptr, * val_name;";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  j = 0;";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < CSYS_GLOBALNUM; i++)";
  z[lc++]="    if ((csys_global[i].type == CSYS_TABLE) && csys_global[i].name &&";
  z[lc++]="	!strncmp(\"aup_factory_\", csys_global[i].name, strlen(\"aup_factory_\")) &&";
  z[lc++]="	strlen(csys_global[i].name) > strlen(\"aup_factory_\") && ((j++) == idx))";
  z[lc++]="      {";
  z[lc++]="	nptr = val_name = malloc";
  z[lc++]="	  (strlen(&(csys_global[i].name[strlen(\"aup_factory_\")])) + 1);";
  z[lc++]="";
  z[lc++]="	strcpy(val_name, &(csys_global[i].name[strlen(\"aup_factory_\")]));";
  z[lc++]="";
  z[lc++]="	do {";
  z[lc++]="	  if (*nptr == '_')";
  z[lc++]="	    *nptr = ' ';";
  z[lc++]="	} while (*(++nptr));";
  z[lc++]="";
  z[lc++]="	ret = CFStringCreateWithCString(NULL, val_name, kCFStringEncodingASCII);";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="      ";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/* Helper Function for Factory Presets: returns a preset number */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_factorypresetnumber(CFStringRef cfstr) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char * nptr, * val_name, * match;";
  z[lc++]="  int i, j;";
  z[lc++]="";
  z[lc++]="  if (!cfstr)";
  z[lc++]="    return -1;";
  z[lc++]="";
  z[lc++]="  match = calloc(CFStringGetLength(cfstr) + 1, 1);";
  z[lc++]="  CFStringGetCString(cfstr, match, CFStringGetLength(cfstr) + 1, ";
  z[lc++]="		     kCFStringEncodingASCII);";
  z[lc++]="";
  z[lc++]="  j = 0;";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < CSYS_GLOBALNUM; i++)";
  z[lc++]="    if ((csys_global[i].type == CSYS_TABLE) && csys_global[i].name &&";
  z[lc++]="	!strncmp(\"aup_factory_\", csys_global[i].name, strlen(\"aup_factory_\")) &&";
  z[lc++]="	strlen(csys_global[i].name) > strlen(\"aup_factory_\"))";
  z[lc++]="      {";
  z[lc++]="	nptr = val_name = malloc";
  z[lc++]="	  (strlen(&(csys_global[i].name[strlen(\"aup_factory_\")])) + 1);";
  z[lc++]="";
  z[lc++]="	strcpy(val_name, &(csys_global[i].name[strlen(\"aup_factory_\")]));";
  z[lc++]="";
  z[lc++]="	do {";
  z[lc++]="	  if (*nptr == '_')";
  z[lc++]="	    *nptr = ' ';";
  z[lc++]="	} while (*(++nptr));";
  z[lc++]="";
  z[lc++]="	if (!strcmp(match, val_name))";
  z[lc++]="	  return j;";
  z[lc++]="";
  z[lc++]="	j++;";
  z[lc++]="      }";
  z[lc++]="      ";
  z[lc++]="  return -1;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/***********************************************************************/";
  z[lc++]="/* Helper Function for GetProperty: Create ParameterValueStrings array */";
  z[lc++]="/***********************************************************************/";
  z[lc++]="";
  z[lc++]="CFMutableArrayRef asysn_audiounit_parametervaluestrings_create";
  z[lc++]="(asysn_audiounit_InstanceState * My, AudioUnitParameterID i) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  CFMutableArrayRef array;";
  z[lc++]="  int j;";
  z[lc++]="";
  z[lc++]="  if ((i < 0) || (i >= My->num_saolparams) || (My->pvs_size[i] == 0))";
  z[lc++]="    return NULL;";
  z[lc++]="";
  z[lc++]="  array = CFArrayCreateMutable(NULL, My->pvs_size[i], &kCFTypeArrayCallBacks);";
  z[lc++]="";
  z[lc++]="  for (j = 0; j < My->pvs_size[i]; j++)";
  z[lc++]="    CFArrayInsertValueAtIndex(array, j, CFStringCreateWithCString";
  z[lc++]="			      (NULL, My->pvs_cstr[i][j], kCFStringEncodingASCII));";
  z[lc++]="";
  z[lc++]="  return array;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*****************************************************************/";
  z[lc++]="/* Pre-engine-execution passes for initialize_parametersystem()  */";
  z[lc++]="/*****************************************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_earlypass_parametersystem";
  z[lc++]="                        (asysn_audiounit_InstanceState * My) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j, msize;";
  z[lc++]="  char * nptr;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* Pass 1 on csys_global[]: count parameters and factory presets  */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < CSYS_GLOBALNUM; i++)";
  z[lc++]="    if (csys_global[i].name &&";
  z[lc++]="	(!strncmp(csys_global[i].name, \"aup_\", 4)) &&";
  z[lc++]="	(strlen(csys_global[i].name) > 4))";
  z[lc++]="      switch (csys_global[i].type) {";
  z[lc++]="      case CSYS_IRATE:";
  z[lc++]="      case CSYS_KRATE:";
  z[lc++]="	if (csys_global[i].width != 1)";
  z[lc++]="	  break;";
  z[lc++]="";
  z[lc++]="	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="	/* change sfront/src/writepre.c line 3206 */";
  z[lc++]="	/* when the code below changes            */";
  z[lc++]="	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="	/* skip over reserved names */";
  z[lc++]="";
  z[lc++]=" 	if ((nptr = strstr(&(csys_global[i].name[4]), \"_idx\")) && ";
  z[lc++]="	    (strlen(nptr) > 6) && (nptr[4] >= '0') && (nptr[4] <= '9'))";
  z[lc++]="	  break;";
  z[lc++]="";
  z[lc++]="	if (strstr(&(csys_global[i].name[4]), \"_unit_\"))";
  z[lc++]="	  break;";
  z[lc++]="";
  z[lc++]="	if ((strstr(&(csys_global[i].name[4]), \"_slider_squarelaw\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_slider_cubic\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_slider_squareroot\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_slider_cuberoot\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_slider_log\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_slider_exp\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_slider_linear\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_slider\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_checkbox\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_menu\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_display_number\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_display_checkbox\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_display_menu\")))";
  z[lc++]="	  break;";
  z[lc++]="";
  z[lc++]="	My->num_saolparams++;";
  z[lc++]="	break;";
  z[lc++]="      case CSYS_TABLE:";
  z[lc++]="	if (!strncmp(\"aup_factory_\", csys_global[i].name, strlen(\"aup_factory_\"))";
  z[lc++]="	    && (strlen(csys_global[i].name) > strlen(\"aup_factory_\")))";
  z[lc++]="	  My->num_factory++;";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* Create data structures for parameters, factory presets, etc  */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  if (My->num_saolparams == 0)";
  z[lc++]="    return noErr;";
  z[lc++]="";
  z[lc++]="  if (!(My->parameterlist = (AudioUnitParameterID *) ";
  z[lc++]="	malloc(My->num_saolparams*sizeof(AudioUnitParameterID))))";
  z[lc++]="    return kAudioUnitErr_FailedInitialization;";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < My->num_saolparams; i++)";
  z[lc++]="    My->parameterlist[i] = i;";
  z[lc++]="";
  z[lc++]="  if (!(My->parameterinfo = (AudioUnitParameterInfo *)";
  z[lc++]="	calloc(My->num_saolparams, sizeof(AudioUnitParameterInfo))))";
  z[lc++]="    return kAudioUnitErr_FailedInitialization;";
  z[lc++]="";
  z[lc++]="  if (!(My->pvs_size = (int *) calloc(My->num_saolparams, sizeof(int))))";
  z[lc++]="    return kAudioUnitErr_FailedInitialization;";
  z[lc++]="";
  z[lc++]="  if (!(My->pvs_cstr = (char ***) calloc(My->num_saolparams, sizeof(char **))))";
  z[lc++]="    return kAudioUnitErr_FailedInitialization;";
  z[lc++]="";
  z[lc++]="  msize = My->num_saolparams*sizeof(asysn_audiounit_saolparam);";
  z[lc++]="  if (!(My->saolparam = (asysn_audiounit_saolparam *) malloc(msize)))";
  z[lc++]="    return kAudioUnitErr_FailedInitialization;";
  z[lc++]="  asysn_audiounit_memstatus(My->saolparam, msize, MADV_WILLNEED);";
  z[lc++]="";
  z[lc++]="  if (My->num_factory)";
  z[lc++]="    {";
  z[lc++]="      if (!(My->factorypreset_info = (AUPreset *) ";
  z[lc++]="	    calloc(My->num_factory, sizeof(AUPreset))))";
  z[lc++]="	return kAudioUnitErr_FailedInitialization;";
  z[lc++]="";
  z[lc++]="      msize = My->num_factory*sizeof(Float32 *);";
  z[lc++]="      if (!(My->factorypreset_values = (Float32 **) calloc(1, msize)))";
  z[lc++]="	return kAudioUnitErr_FailedInitialization;";
  z[lc++]="      asysn_audiounit_memstatus(My->factorypreset_values, msize, MADV_WILLNEED);";
  z[lc++]="";
  z[lc++]="      for (i = 0; i < My->num_factory; i++)";
  z[lc++]="	{";
  z[lc++]="	  msize = My->num_saolparams*sizeof(Float32);";
  z[lc++]="	  if (!(My->factorypreset_values[i] = (Float32 *) malloc(msize)))";
  z[lc++]="	    return kAudioUnitErr_FailedInitialization;";
  z[lc++]="	  asysn_audiounit_memstatus(My->factorypreset_values[i], msize, MADV_WILLNEED);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* todo: add parameter value strings data structures */";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* Pass 2 on csys_global[]: Initialize parameter names  */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  j = 0;";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < CSYS_GLOBALNUM; i++)";
  z[lc++]="    if (csys_global[i].name &&";
  z[lc++]="	(!strncmp(csys_global[i].name, \"aup_\", 4)) &&";
  z[lc++]="	(strlen(csys_global[i].name) > 4))";
  z[lc++]="      switch (csys_global[i].type) {";
  z[lc++]="      case CSYS_IRATE:";
  z[lc++]="      case CSYS_KRATE:";
  z[lc++]="	if (csys_global[i].width != 1)";
  z[lc++]="	  break;";
  z[lc++]="";
  z[lc++]="	/* skip over reserved names */";
  z[lc++]="";
  z[lc++]="	if ((nptr = strstr(&(csys_global[i].name[4]), \"_idx\")) && ";
  z[lc++]="	    (strlen(nptr) > 6) && (nptr[4] >= '0') && (nptr[4] <= '9'))";
  z[lc++]="	  break;";
  z[lc++]="";
  z[lc++]="	if (strstr(&(csys_global[i].name[4]), \"_unit_\"))";
  z[lc++]="	  break;";
  z[lc++]="";
  z[lc++]="	if ((strstr(&(csys_global[i].name[4]), \"_slider_squarelaw\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_slider_cubic\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_slider_squareroot\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_slider_cuberoot\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_slider_log\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_slider_exp\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_slider_linear\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_slider\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_checkbox\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_menu\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_display_number\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_display_checkbox\")) ||";
  z[lc++]="	    (strstr(&(csys_global[i].name[4]), \"_display_menu\")))";
  z[lc++]="	  break;";
  z[lc++]="";
  z[lc++]="	/* Do all initialization that may be done early */";
  z[lc++]="";
  z[lc++]="	strncpy(My->parameterinfo[j].name, &(csys_global[i].name[4]), 60);";
  z[lc++]="	My->parameterinfo[j].name[59] = '\\0';";
  z[lc++]="";
  z[lc++]="	My->parameterinfo[j].unit = ASYS_AUDIOUNIT_PARAMETER_DEFAULT_UNIT;";
  z[lc++]="	My->parameterinfo[j].minValue = ASYS_AUDIOUNIT_PARAMETER_DEFAULT_MINIMUM;";
  z[lc++]="	My->parameterinfo[j].maxValue = ASYS_AUDIOUNIT_PARAMETER_DEFAULT_MAXIMUM;";
  z[lc++]="	My->parameterinfo[j].defaultValue = ASYS_AUDIOUNIT_PARAMETER_DEFAULT_DEFAULT;";
  z[lc++]="";
  z[lc++]="	My->parameterinfo[j].flags = kAudioUnitParameterFlag_HasCFNameString |";
  z[lc++]="	  kAudioUnitParameterFlag_IsReadable | kAudioUnitParameterFlag_IsWritable |";
  z[lc++]="	  kAudioUnitParameterFlag_CFNameRelease;";
  z[lc++]="";
  z[lc++]="	My->saolparam[j].index = csys_global[i].index;";
  z[lc++]="	My->saolparam[j].use = csys_global[i].use;";
  z[lc++]="";
  z[lc++]="	j++;";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  return noErr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/* Parameter-value strings pass for initialize_parametersystem()  */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_parametervaluestrings_parametersystem";
  z[lc++]="                (asysn_audiounit_InstanceState * My) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j, k, str_idx, len;";
  z[lc++]="  char * nptr, * match;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* Create parameter-value strings for Indexed parameters */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  for (j = 0; j < My->num_saolparams; j++)";
  z[lc++]="    if (My->parameterinfo[j].unit == kAudioUnitParameterUnit_Indexed)";
  z[lc++]="      {";
  z[lc++]="	My->pvs_size[j] = (My->parameterinfo[j].maxValue ";
  z[lc++]="			   - My->parameterinfo[j].minValue + 1);";
  z[lc++]="	";
  z[lc++]="	My->pvs_cstr[j] = (char **) calloc(My->pvs_size[j], sizeof(char *));";
  z[lc++]="";
  z[lc++]="	if (!(My->pvs_cstr[j]))";
  z[lc++]="	  return kAudioUnitErr_FailedInitialization;";
  z[lc++]="";
  z[lc++]="	/* create array and default values */";
  z[lc++]="";
  z[lc++]="	for (k = 0; k < My->pvs_size[j]; k++)";
  z[lc++]="	  {";
  z[lc++]="	    My->pvs_cstr[j][k] = (char *)calloc(strlen(\"4294967295\") + 1, sizeof(char));";
  z[lc++]="";
  z[lc++]="	    if (!(My->pvs_cstr[j][k]))";
  z[lc++]="	      return kAudioUnitErr_FailedInitialization;";
  z[lc++]="";
  z[lc++]="	    sprintf(My->pvs_cstr[j][k], \"%u\", k);";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="	/* overwrite default values with custom strings */";
  z[lc++]="";
  z[lc++]="	len = strlen(\"aup_\") + strlen(My->parameterinfo[j].name) + strlen(\"_idx\");";
  z[lc++]="";
  z[lc++]="	if (!(match = malloc(len + 1)))";
  z[lc++]="	  return kAudioUnitErr_FailedInitialization;";
  z[lc++]="";
  z[lc++]="	sprintf((nptr = match), \"aup_%s_idx\", My->parameterinfo[j].name); ";
  z[lc++]="";
  z[lc++]="	do {";
  z[lc++]="	  if (*nptr == ' ')";
  z[lc++]="	    *nptr = '_';";
  z[lc++]="	} while (*(++nptr));";
  z[lc++]="";
  z[lc++]="	for (i = 0; i < CSYS_GLOBALNUM; i++)";
  z[lc++]="	  if (csys_global[i].name && (csys_global[j].width == 1) &&";
  z[lc++]="	      ((csys_global[i].type == CSYS_IRATE) || ";
  z[lc++]="	       (csys_global[i].type == CSYS_KRATE)) &&";
  z[lc++]="	      (!strncmp(csys_global[i].name, match, len)) && ";
  z[lc++]="	      (strlen(csys_global[i].name) > len) &&";
  z[lc++]="	      (sscanf(&(csys_global[i].name[len]), \"%u_\", &k) == 1) && ";
  z[lc++]="	      (k >= 0) && (k <= My->pvs_size[j]))";
  z[lc++]="	    {";
  z[lc++]="	      str_idx = len;";
  z[lc++]="	      while (csys_global[i].name[str_idx++] != '_');";
  z[lc++]="";
  z[lc++]="	      if (csys_global[i].name[str_idx] != '\\0')";
  z[lc++]="		{";
  z[lc++]="		  free(My->pvs_cstr[j][k]);";
  z[lc++]="";
  z[lc++]="		  nptr = My->pvs_cstr[j][k] ";
  z[lc++]="		    = malloc(strlen(&(csys_global[i].name[str_idx])) + 1);";
  z[lc++]="";
  z[lc++]="		  if (!nptr)";
  z[lc++]="		    return kAudioUnitErr_FailedInitialization;";
  z[lc++]="";
  z[lc++]="		  strcpy(My->pvs_cstr[j][k], &(csys_global[i].name[str_idx]));";
  z[lc++]="";
  z[lc++]="		  do {";
  z[lc++]="		    if (*nptr == '_')";
  z[lc++]="		      *nptr = ' ';";
  z[lc++]="		  } while (*(++nptr));";
  z[lc++]="		}";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	free(match);";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  return noErr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/* Factory preset pass for initialize_parametersystem()  */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_factorypreset_parametersystem";
  z[lc++]="                (ENGINE_PTR_DECLARE_COMMA ";
  z[lc++]="                 asysn_audiounit_InstanceState * My) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j, k, idx;";
  z[lc++]="  char * nptr, * match;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* initialize factory preset data structures */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  if (My->num_factory)";
  z[lc++]="    {";
  z[lc++]="      j = 0;";
  z[lc++]="      My->factorypreset_array = CFArrayCreateMutable(NULL, My->num_factory, NULL);";
  z[lc++]="";
  z[lc++]="      if (!(My->factorypreset_array))";
  z[lc++]="	return kAudioUnitErr_FailedInitialization;";
  z[lc++]="";
  z[lc++]="      for (i = 0; i < CSYS_GLOBALNUM; i++)";
  z[lc++]="	if ((csys_global[i].type == CSYS_TABLE) && csys_global[i].name &&";
  z[lc++]="	    !strncmp(\"aup_factory_\", csys_global[i].name, strlen(\"aup_factory_\")) &&";
  z[lc++]="	    strlen(csys_global[i].name) > strlen(\"aup_factory_\"))";
  z[lc++]="	  {";
  z[lc++]="	    nptr = match = malloc";
  z[lc++]="	      (strlen(&(csys_global[i].name[strlen(\"aup_factory_\")])) + 1);";
  z[lc++]="";
  z[lc++]="	    if (!nptr)";
  z[lc++]="	      return kAudioUnitErr_FailedInitialization;";
  z[lc++]="";
  z[lc++]="	    strcpy(match, &(csys_global[i].name[strlen(\"aup_factory_\")]));";
  z[lc++]="	    do {";
  z[lc++]="	      if (*nptr == '_')";
  z[lc++]="		*nptr = ' ';";
  z[lc++]="	    } while (*(++nptr));";
  z[lc++]="";
  z[lc++]="	    My->factorypreset_info[j].presetNumber = j;";
  z[lc++]="	    My->factorypreset_info[j].presetName = CFStringCreateWithCString";
  z[lc++]="	      (NULL, match, kCFStringEncodingASCII);";
  z[lc++]="";
  z[lc++]="	    if (!(My->factorypreset_info[j].presetName))";
  z[lc++]="	      return kAudioUnitErr_FailedInitialization;";
  z[lc++]="";
  z[lc++]="	    CFArrayAppendValue(My->factorypreset_array, &(My->factorypreset_info[j]));";
  z[lc++]="";
  z[lc++]="	    free(match);";
  z[lc++]="";
  z[lc++]="	    for (k = 0; k < My->num_saolparams; k++)";
  z[lc++]="	      My->factorypreset_values[j][k] = My->parameterinfo[k].defaultValue;";
  z[lc++]="";
  z[lc++]="	    if (EV(gtables)[idx = csys_global[i].index].t)";
  z[lc++]="	      for (k = 0; (k < EV(gtables)[idx].len) && (k < My->num_saolparams); k++)";
  z[lc++]="		{";
  z[lc++]="		  My->factorypreset_values[j][k] = EV(gtables)[idx].t[k];";
  z[lc++]="		  My->factorypreset_values[j][k]  = ";
  z[lc++]="		    (My->factorypreset_values[j][k] < My->parameterinfo[k].minValue)";
  z[lc++]="		    ? My->parameterinfo[k].minValue : My->factorypreset_values[j][k];";
  z[lc++]="		  My->factorypreset_values[j][k]  = ";
  z[lc++]="		    (My->factorypreset_values[j][k] > My->parameterinfo[k].maxValue)";
  z[lc++]="		    ? My->parameterinfo[k].maxValue : My->factorypreset_values[j][k];";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	    j++;";
  z[lc++]="	  }";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return noErr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/************************************************************/";
  z[lc++]="/* Helper for Open Selector: Initializes parameter system.  */";
  z[lc++]="/************************************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_initialize_parametersystem";
  z[lc++]="                   (asysn_audiounit_InstanceState * My) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, j, k, ret, match_len, unit_num;";
  z[lc++]="  char * nptr, * kptr, * match;";
  z[lc++]="  ENGINE_PTR_DECLARE_SEMICOLON";
  z[lc++]="";
  z[lc++]="  if ((ASYS_AUDIOUNIT_HAS_AUCONTROL == 0) || (CSYS_GLOBALNUM == 0))";
  z[lc++]="    return noErr;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* Parameter initialization passes that precede engine start */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  if ((ret = asysn_audiounit_earlypass_parametersystem(My)) != noErr)";
  z[lc++]="    return ret;";
  z[lc++]="";
  z[lc++]="  if (My->num_saolparams == 0)";
  z[lc++]="    return noErr;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* Execute engine to define parameters and factory presets  */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  ENGINE_PTR_ASSIGNED_TO  system_init(My->argc, My->argv, ";
  z[lc++]="				      My->OutputStreamFormat.mSampleRate);";
  z[lc++]="";
  z[lc++]="  if (ENGINE_PTR_IS_NULL)";
  z[lc++]="    return kAudioUnitErr_FailedInitialization;";
  z[lc++]="";
  z[lc++]="  effects_init(ENGINE_PTR);";
  z[lc++]="  main_initpass(ENGINE_PTR);";
  z[lc++]="  asysn_audiounit_ksyncinit(My);";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* Use engine results to complete parameter data structures */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  for (j = 0; j < My->num_saolparams; j++)";
  z[lc++]="    {";
  z[lc++]="      match = malloc(strlen(\"aup_\") + strlen(My->parameterinfo[j].name) + ";
  z[lc++]="		     strlen(\"_pinfo\") + 1);";
  z[lc++]="";
  z[lc++]="      if (!match)";
  z[lc++]="	{";
  z[lc++]="	  shut_down(ENGINE_PTR);";
  z[lc++]="	  return kAudioUnitErr_FailedInitialization;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      sprintf(match, \"aup_%s_pinfo\", My->parameterinfo[j].name); ";
  z[lc++]="";
  z[lc++]="      for (i = 0; i < CSYS_GLOBALNUM; i++)";
  z[lc++]="	if ((csys_global[i].type == CSYS_TABLE) && csys_global[i].name &&";
  z[lc++]="	    !strcmp(match, csys_global[i].name))";
  z[lc++]="	  {";
  z[lc++]="	    k = csys_global[i].index;";
  z[lc++]="";
  z[lc++]="	    if (EV(gtables)[k].t && (EV(gtables)[k].len >= 3) && ";
  z[lc++]="		(EV(gtables)[k].t[0] <= EV(gtables)[k].t[1]) && ";
  z[lc++]="		(EV(gtables)[k].t[1] <= EV(gtables)[k].t[2]))";
  z[lc++]="	      {";
  z[lc++]="		My->parameterinfo[j].minValue = EV(gtables)[k].t[0];";
  z[lc++]="		My->parameterinfo[j].defaultValue = EV(gtables)[k].t[1];";
  z[lc++]="		My->parameterinfo[j].maxValue = EV(gtables)[k].t[2];";
  z[lc++]="";
  z[lc++]="		if (My->parameterinfo[j].minValue > My->parameterinfo[j].maxValue)";
  z[lc++]="		  {";
  z[lc++]="		    My->parameterinfo[j].minValue = EV(gtables)[k].t[2];";
  z[lc++]="		    My->parameterinfo[j].maxValue = EV(gtables)[k].t[0];";
  z[lc++]="		  }";
  z[lc++]="";
  z[lc++]="		if (My->parameterinfo[j].defaultValue > My->parameterinfo[j].maxValue)";
  z[lc++]="		  My->parameterinfo[j].defaultValue = EV(gtables)[k].t[2];";
  z[lc++]="";
  z[lc++]="		if (My->parameterinfo[j].defaultValue < My->parameterinfo[j].minValue)";
  z[lc++]="		  My->parameterinfo[j].defaultValue = EV(gtables)[k].t[0];";
  z[lc++]="	      }";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="      free(match);";
  z[lc++]="";
  z[lc++]="      match = malloc((match_len = strlen(\"aup_\") + strlen(My->parameterinfo[j].name) + ";
  z[lc++]="		      strlen(\"_unit_\")) + 1);";
  z[lc++]="";
  z[lc++]="      if (!match)";
  z[lc++]="	{";
  z[lc++]="	  shut_down(ENGINE_PTR);";
  z[lc++]="	  return kAudioUnitErr_FailedInitialization;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      sprintf(match, \"aup_%s_unit_\", My->parameterinfo[j].name); ";
  z[lc++]="";
  z[lc++]="      for (i = 0; i < CSYS_GLOBALNUM; i++)";
  z[lc++]="	if (((csys_global[i].type == CSYS_IRATE) || ";
  z[lc++]="	     (csys_global[i].type == CSYS_KRATE)) && ";
  z[lc++]="	    (csys_global[i].width == 1) &&";
  z[lc++]="	    csys_global[i].name &&";
  z[lc++]="	    !strncmp(match, csys_global[i].name, match_len))";
  z[lc++]="	  {";
  z[lc++]="	    if (strlen(csys_global[i].name) <= match_len)";
  z[lc++]="	      continue;";
  z[lc++]="";
  z[lc++]="	    nptr = &(csys_global[i].name[match_len]);";
  z[lc++]="";
  z[lc++]="	    /* for now, only support custom units */";
  z[lc++]="";
  z[lc++]="	    kptr = malloc(strlen(nptr) + 1);";
  z[lc++]="";
  z[lc++]="	    if (!kptr)";
  z[lc++]="	      {";
  z[lc++]="		shut_down(ENGINE_PTR);";
  z[lc++]="		return kAudioUnitErr_FailedInitialization;";
  z[lc++]="	      }";
  z[lc++]="";
  z[lc++]="	    strcpy(kptr, &(csys_global[i].name[match_len]));";
  z[lc++]="";
  z[lc++]="	    nptr = kptr;";
  z[lc++]="	    do {";
  z[lc++]="	      if (*nptr == '_')";
  z[lc++]="		*nptr = ' ';";
  z[lc++]="	    } while (*(++nptr));";
  z[lc++]="";
  z[lc++]="	    My->parameterinfo[j].unitName = CFStringCreateWithCString";
  z[lc++]="	      (NULL, kptr, kCFStringEncodingASCII);";
  z[lc++]="";
  z[lc++]="	    if (!(My->parameterinfo[j].unitName))";
  z[lc++]="	      {";
  z[lc++]="		shut_down(ENGINE_PTR);";
  z[lc++]="		return kAudioUnitErr_FailedInitialization;";
  z[lc++]="	      }";
  z[lc++]="";
  z[lc++]="	    My->parameterinfo[j].unit = kAudioUnitParameterUnit_CustomUnit;";
  z[lc++]="";
  z[lc++]="	    free(kptr);";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="      free(match);";
  z[lc++]="";
  z[lc++]="      match = malloc((match_len = strlen(\"aup_\") + strlen(My->parameterinfo[j].name) + ";
  z[lc++]="		      strlen(\"_\")) + 1);";
  z[lc++]="";
  z[lc++]="      if (!match)";
  z[lc++]="	{";
  z[lc++]="	  shut_down(ENGINE_PTR);";
  z[lc++]="	  return kAudioUnitErr_FailedInitialization;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      sprintf(match, \"aup_%s_\", My->parameterinfo[j].name); ";
  z[lc++]="";
  z[lc++]="      for (i = 0; i < CSYS_GLOBALNUM; i++)";
  z[lc++]="";
  z[lc++]="	if (((csys_global[i].type == CSYS_IRATE) || ";
  z[lc++]="	     (csys_global[i].type == CSYS_KRATE)) && ";
  z[lc++]="	    (csys_global[i].width == 1) &&";
  z[lc++]="	    csys_global[i].name &&";
  z[lc++]="	    !strncmp(match, csys_global[i].name, match_len))";
  z[lc++]="	  {";
  z[lc++]="	    if (strlen(csys_global[i].name) <= match_len)";
  z[lc++]="	      continue;";
  z[lc++]="";
  z[lc++]="	    nptr = &(csys_global[i].name[match_len]);";
  z[lc++]="";
  z[lc++]="	    if (!strcmp(nptr, \"slider_squarelaw\"))";
  z[lc++]="	      My->parameterinfo[j].flags |= ";
  z[lc++]="		kAudioUnitParameterFlag_DisplaySquared;";
  z[lc++]="	    else";
  z[lc++]="	      if (!strcmp(nptr, \"slider_cubic\"))";
  z[lc++]="		My->parameterinfo[j].flags |= ";
  z[lc++]="		  kAudioUnitParameterFlag_DisplayCubed;";
  z[lc++]="	      else";
  z[lc++]="		if (!strcmp(nptr, \"slider_squareroot\"))";
  z[lc++]="		  My->parameterinfo[j].flags |= ";
  z[lc++]="		    kAudioUnitParameterFlag_DisplaySquareRoot;";
  z[lc++]="		else";
  z[lc++]="		  if (!strcmp(nptr, \"slider_cuberoot\"))";
  z[lc++]="		    My->parameterinfo[j].flags |= ";
  z[lc++]="		      kAudioUnitParameterFlag_DisplayCubeRoot;";
  z[lc++]="		  else";
  z[lc++]="		    if (!strcmp(nptr, \"slider_log\"))";
  z[lc++]="		      My->parameterinfo[j].flags |= ";
  z[lc++]="			kAudioUnitParameterFlag_DisplayLogarithmic;";
  z[lc++]="		    else";
  z[lc++]="		      if (!strcmp(nptr, \"slider_exp\"))";
  z[lc++]="			My->parameterinfo[j].flags |= ";
  z[lc++]="			  kAudioUnitParameterFlag_DisplayExponential;";
  z[lc++]="		      else";
  z[lc++]="			if (!strcmp(nptr, \"menu\") || !strcmp(nptr, \"display_menu\"))";
  z[lc++]="			  {";
  z[lc++]="			    if (!strcmp(nptr, \"display_menu\"))";
  z[lc++]="			      My->parameterinfo[j].flags &= ";
  z[lc++]="				~ kAudioUnitParameterFlag_IsWritable;";
  z[lc++]="";
  z[lc++]="			    My->parameterinfo[j].unit = ";
  z[lc++]="			      kAudioUnitParameterUnit_Indexed;";
  z[lc++]="			    if (My->parameterinfo[j].unitName)";
  z[lc++]="			      {";
  z[lc++]="				CFRelease(My->parameterinfo[j].unitName);";
  z[lc++]="				My->parameterinfo[j].unitName = NULL;";
  z[lc++]="			      }";
  z[lc++]="			  }";
  z[lc++]="			else";
  z[lc++]="			  if (!strcmp(nptr, \"checkbox\") || ";
  z[lc++]="			      !strcmp(nptr, \"display_checkbox\"))";
  z[lc++]="			    {";
  z[lc++]="			      if (!strcmp(nptr, \"display_checkbox\"))";
  z[lc++]="				My->parameterinfo[j].flags &= ";
  z[lc++]="				  ~ kAudioUnitParameterFlag_IsWritable;";
  z[lc++]="";
  z[lc++]="			      My->parameterinfo[j].unit = ";
  z[lc++]="				kAudioUnitParameterUnit_Boolean;";
  z[lc++]="			      if (My->parameterinfo[j].unitName)";
  z[lc++]="				{";
  z[lc++]="				  CFRelease(My->parameterinfo[j].unitName);";
  z[lc++]="				  My->parameterinfo[j].unitName = NULL;";
  z[lc++]="				}";
  z[lc++]="			    }";
  z[lc++]="			  else";
  z[lc++]="			    if (!strcmp(nptr, \"display_number\"))";
  z[lc++]="			      {";
  z[lc++]="				My->parameterinfo[j].flags &= ";
  z[lc++]="				  ~ kAudioUnitParameterFlag_IsWritable;";
  z[lc++]="			      }";
  z[lc++]="			    else";
  z[lc++]="			      if ((strcmp(nptr, \"slider_linear\") != 0) &&";
  z[lc++]="				  (strcmp(nptr, \"slider\") != 0))";
  z[lc++]="				continue;";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="      free(match);";
  z[lc++]="      ";
  z[lc++]="      My->saolparam[j].value = My->parameterinfo[j].defaultValue;";
  z[lc++]="";
  z[lc++]="      nptr = &(My->parameterinfo[j].name[0]);";
  z[lc++]="      do {";
  z[lc++]="	if (*nptr == '_')";
  z[lc++]="	  *nptr = ' ';";
  z[lc++]="      } while (*(++nptr));";
  z[lc++]="      ";
  z[lc++]="      My->parameterinfo[j].cfNameString = CFStringCreateWithCString";
  z[lc++]="	(NULL, My->parameterinfo[j].name, kCFStringEncodingASCII);";
  z[lc++]="";
  z[lc++]="      if (!(My->parameterinfo[j].cfNameString))";
  z[lc++]="	{";
  z[lc++]="	  shut_down(ENGINE_PTR);";
  z[lc++]="	  return kAudioUnitErr_FailedInitialization;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* Create parameter-value strings for Indexed parameters */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  if ((ret = asysn_audiounit_parametervaluestrings_parametersystem(My)) != noErr)";
  z[lc++]="    {";
  z[lc++]="      shut_down(ENGINE_PTR);";
  z[lc++]="      return ret;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* initialize factory preset data structures */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  if ((ret = asysn_audiounit_factorypreset_parametersystem";
  z[lc++]="       (ENGINE_PTR_COMMA My)) != noErr)";
  z[lc++]="    {";
  z[lc++]="      shut_down(ENGINE_PTR);";
  z[lc++]="      return ret;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* Shut down engine  */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  shut_down(ENGINE_PTR);";
  z[lc++]="  return noErr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/************************************************************/";
  z[lc++]="/* Helper for Open Selector: Initializes property variables */";
  z[lc++]="/************************************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_initialize_properties";
  z[lc++]="(asysn_audiounit_InstanceState * My) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* the first set of parameters define the signal flow  */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  /* the preferred audiounit bus widths */";
  z[lc++]="";
  z[lc++]="  My->InputElementCount = ASYS_AUDIOUNIT_ELEMENT_INPUTPREF;";
  z[lc++]="  My->OutputElementCount = ASYS_AUDIOUNIT_ELEMENT_OUTPUTPREF;";
  z[lc++]="";
  z[lc++]="  /* defines fixed channel widths. todo: turn into an array of formats */";
  z[lc++]="";
  z[lc++]="  if (ASYS_AUDIOUNIT_EFFECT)";
  z[lc++]="    {";
  z[lc++]="      My->SupportedNumChannels[0].inChannels = ASYS_AUDIOUNIT_MONO;";
  z[lc++]="      My->SupportedNumChannels[0].outChannels = ASYS_AUDIOUNIT_MONO;";
  z[lc++]="      My->SupportedNumChannels[1].inChannels = ASYS_AUDIOUNIT_MONO;";
  z[lc++]="      My->SupportedNumChannels[1].outChannels = ASYS_AUDIOUNIT_STEREO;";
  z[lc++]="      My->SupportedNumChannels[2].inChannels = ASYS_AUDIOUNIT_STEREO;";
  z[lc++]="      My->SupportedNumChannels[2].outChannels = ASYS_AUDIOUNIT_MONO;";
  z[lc++]="      My->SupportedNumChannels[3].inChannels = ASYS_AUDIOUNIT_STEREO;";
  z[lc++]="      My->SupportedNumChannels[3].outChannels = ASYS_AUDIOUNIT_STEREO;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      My->SupportedNumChannels[0].inChannels = ASYS_AUDIOUNIT_NULL;";
  z[lc++]="      My->SupportedNumChannels[0].outChannels = ASYS_AUDIOUNIT_MONO;";
  z[lc++]="      My->SupportedNumChannels[1].inChannels = ASYS_AUDIOUNIT_NULL;";
  z[lc++]="      My->SupportedNumChannels[1].outChannels = ASYS_AUDIOUNIT_STEREO;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  /* maximum audio sample chunk -- augment with other variables to resize buffers */";
  z[lc++]="  ";
  z[lc++]="  My->MaximumFramesPerSlice = ASYS_AUDIOUNIT_FRAMES_PER_SLICE;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* our desired input and output stream format */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  for (i=0; i < ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE; i++)";
  z[lc++]="    {";
  z[lc++]="      /* mChannelsPerFrame code mono, stereo, etc */";
  z[lc++]="";
  z[lc++]="      My->InputStreamFormat[i].mChannelsPerFrame = ASYS_AUDIOUNIT_INPUT_CHANNELS;";
  z[lc++]="";
  z[lc++]="      /* could also be kAudioStreamAnyRate, once we support setproperty over-ride */";
  z[lc++]="";
  z[lc++]="      My->InputStreamFormat[i].mSampleRate = SAOL_SRATE;";
  z[lc++]="  ";
  z[lc++]="      /* a set of non-interleaved mono channels -- do not touch these */";
  z[lc++]="";
  z[lc++]="      My->InputStreamFormat[i].mFormatID = kAudioFormatLinearPCM;";
  z[lc++]="      ";
  z[lc++]="      My->InputStreamFormat[i].mFormatFlags = (kAudioFormatFlagIsFloat | ";
  z[lc++]="					    kAudioFormatFlagIsPacked | ";
  z[lc++]="					    kAudioFormatFlagIsNonInterleaved);";
  z[lc++]="      ";
  z[lc++]="      if (ASYS_AUDIOUNIT_FLOAT32_BIGENDIAN)";
  z[lc++]="	My->InputStreamFormat[i].mFormatFlags |= kAudioFormatFlagIsBigEndian;";
  z[lc++]="";
  z[lc++]="      My->InputStreamFormat[i].mBytesPerPacket = 4;";
  z[lc++]="      My->InputStreamFormat[i].mBytesPerFrame = 4;";
  z[lc++]="      My->InputStreamFormat[i].mFramesPerPacket = 1;";
  z[lc++]="      My->InputStreamFormat[i].mBitsPerChannel = 32;";
  z[lc++]="      ";
  z[lc++]="      My->InputStreamFormat[i].mReserved = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* mChannelsPerFrame code mono, stereo, etc */";
  z[lc++]="";
  z[lc++]="  My->OutputStreamFormat.mChannelsPerFrame = ASYS_AUDIOUNIT_OUTPUT_CHANNELS;";
  z[lc++]="";
  z[lc++]="  /* could also be kAudioStreamAnyRate, once we support setproperty over-ride */";
  z[lc++]="";
  z[lc++]="  My->OutputStreamFormat.mSampleRate = SAOL_SRATE;  ";
  z[lc++]="";
  z[lc++]="  My->acycle = ((int)(SAOL_SRATE))/((int)(SAOL_KRATE));";
  z[lc++]="  My->krate = SAOL_KRATE;";
  z[lc++]="  My->acycleidx_kcycleidx = 1;     /* acycleidx = 0, kcycleidx = 1 */";
  z[lc++]="";
  z[lc++]="  /* a set of non-interleaved mono channels -- do not touch these */";
  z[lc++]="";
  z[lc++]="  My->OutputStreamFormat.mFormatID = kAudioFormatLinearPCM;";
  z[lc++]="  ";
  z[lc++]="  My->OutputStreamFormat.mFormatFlags = (kAudioFormatFlagIsFloat | ";
  z[lc++]="					 kAudioFormatFlagIsPacked | ";
  z[lc++]="					 kAudioFormatFlagIsNonInterleaved);";
  z[lc++]="";
  z[lc++]="  if (ASYS_AUDIOUNIT_FLOAT32_BIGENDIAN)";
  z[lc++]="    My->OutputStreamFormat.mFormatFlags |= kAudioFormatFlagIsBigEndian;";
  z[lc++]="";
  z[lc++]="  My->OutputStreamFormat.mBytesPerPacket = 4;";
  z[lc++]="  My->OutputStreamFormat.mBytesPerFrame = 4;";
  z[lc++]="  My->OutputStreamFormat.mFramesPerPacket = 1;";
  z[lc++]="  My->OutputStreamFormat.mBitsPerChannel = 32;";
  z[lc++]="";
  z[lc++]="  My->OutputStreamFormat.mReserved = 0;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* end of streamformat property */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  /* tracks if the audio unit is currently bypassed */";
  z[lc++]="";
  z[lc++]="  My->BypassEffect = 0;";
  z[lc++]="  My->LastBypassEffect = 0;";
  z[lc++]="";
  z[lc++]="  /* set to 1 if we renderer returns the buffers use for SetRenderCallback */";
  z[lc++]="";
  z[lc++]="  My->InPlaceProcessing = ASYS_AUDIOUNIT_INPLACE_PROCESSING;";
  z[lc++]="";
  z[lc++]="  /* define the null preset */";
  z[lc++]="";
  z[lc++]="  My->PresentPreset.presetName = CFStringCreateWithCString(NULL, \"Untitled\", ";
  z[lc++]="							   kCFStringEncodingASCII);";
  z[lc++]="  if (!(My->PresentPreset.presetName))";
  z[lc++]="    return kAudioUnitErr_FailedInitialization;";
  z[lc++]="";
  z[lc++]="  My->PresentPreset.presetNumber = -1;";
  z[lc++]="";
  z[lc++]="  My->lock_PresentPreset = 0;";
  z[lc++]="";
  z[lc++]="  /* number of instruments offered by the music device */";
  z[lc++]="";
  z[lc++]="  if (ASYS_AUDIOUNIT_MUSICDEVICE)";
  z[lc++]="    My->InstrumentCount = ASYS_AUDIOUNIT_INSTRUMENT_COUNT;";
  z[lc++]="  else";
  z[lc++]="    My->InstrumentCount = 0;";
  z[lc++]="";
  z[lc++]="  /* 1 if the audio unit intends to stream samples off of the disk */";
  z[lc++]="";
  z[lc++]="  My->StreamFromDisk = 0;";
  z[lc++]="";
  z[lc++]="  /* the function pointer and parameters SetRenderCallback provides */";
  z[lc++]="";
  z[lc++]="  for (i=0; i < ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE; i++)";
  z[lc++]="    {";
  z[lc++]="      My->SetRenderCallback[i].inputProc = NULL;";
  z[lc++]="      My->SetRenderCallback[i].inputProcRefCon = NULL;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* how the host tells us who is driving us */";
  z[lc++]="";
  z[lc++]="  for (i=0; i < ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE; i++)";
  z[lc++]="    {";
  z[lc++]="      My->MakeConnection[i].sourceAudioUnit = 0;";
  z[lc++]="      My->MakeConnection[i].sourceOutputNumber = 0;";
  z[lc++]="      My->MakeConnection[i].destInputNumber = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* lock for both SetRenderCallback and MakeConnection */";
  z[lc++]="";
  z[lc++]="  My->lock_sampledelivery = 0;";
  z[lc++]="";
  z[lc++]=" /* the function pointer and parameters RenderNotify provides, and its lock */";
  z[lc++]=" ";
  z[lc++]="  My->rendernotify = NULL;";
  z[lc++]="  My->lock_rendernotify = 0;";
  z[lc++]="";
  z[lc++]="  /* tracks last rendering error for the rendering proc - clear after returning it */";
  z[lc++]="";
  z[lc++]="  My->LastRenderError = noErr;";
  z[lc++]="";
  z[lc++]="  /* for now, assume AU algorithm has no latency */";
  z[lc++]="";
  z[lc++]="  My->Latency = 0.0;";
  z[lc++]="";
  z[lc++]="  /* tail time (in a reverb sense) for the audio unit */";
  z[lc++]="";
  z[lc++]="  My->TailTime = 0.0;";
  z[lc++]="";
  z[lc++]="  /* to be used for selecting sfront's sample-rate conversion algorithm */";
  z[lc++]="";
  z[lc++]="  My->SRCAlgorithm = kAudioUnitSRCAlgorithm_Polyphase;";
  z[lc++]="";
  z[lc++]="  /* request for render quality, using 0-127 scaled enum in AudioUnitProperties.h */";
  z[lc++]="";
  z[lc++]="  My->RenderQuality = kRenderQuality_Max;";
  z[lc++]="";
  z[lc++]="  /* the % of total CPU load the host allots to us, 0 codes no limit */";
  z[lc++]="  ";
  z[lc++]="  My->CPULoad = 0.0;";
  z[lc++]="  My->lock_CPULoad = 0;";
  z[lc++]="  My->ksync_normalize = (Float32) (My->krate/AudioGetHostClockFrequency());";
  z[lc++]="";
  z[lc++]="  /* a heads-up for off-line operation, sent by host */";
  z[lc++]="";
  z[lc++]="  My->OfflineRender = 0;";
  z[lc++]="";
  z[lc++]="  /* a heads-up for the presentation latency, sent by host */";
  z[lc++]="";
  z[lc++]="  My->PresentationLatency = 0.0;";
  z[lc++]="";
  z[lc++]="  /* listener callback lists for each supported property */";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < ASYS_AUDIOUNIT_PROPLISTEN_ARRAYSIZE; i++)";
  z[lc++]="    My->proplisteners[i] = NULL;";
  z[lc++]="";
  z[lc++]="  My->lock_proplisteners = 0;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* aup_ property state */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  My->num_saolparams = 0;";
  z[lc++]="  My->parameterlist = NULL;";
  z[lc++]="  My->parameterinfo = NULL;";
  z[lc++]="  My->pvs_size = NULL;";
  z[lc++]="  My->pvs_cstr = NULL;";
  z[lc++]="  My->saolparam = NULL;";
  z[lc++]="  My->num_factory = 0;";
  z[lc++]="  My->factorypreset_values = NULL;";
  z[lc++]="  My->factorypreset_info = NULL;";
  z[lc++]="  My->factorypreset_array = NULL;";
  z[lc++]="";
  z[lc++]="  return noErr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/************************************************************/";
  z[lc++]="/* Helper for Open Selector: Memstatus for global variables */";
  z[lc++]="/************************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_globalvars_memstatus(int advice)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int msize, i, j;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* global arrays used by main_ipass */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="#if (defined(CSYS_MAXEXTCHAN) && (CSYS_MAXEXTCHAN > 0))";
  z[lc++]="  msize = CSYS_MAXEXTCHAN*sizeof(int);";
  z[lc++]="  asysn_audiounit_memstatus(cme_preset, msize, advice);";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(CSYS_MAXSASLINSTR) && (CSYS_MAXSASLINSTR > 0))";
  z[lc++]="  msize = CSYS_MAXSASLINSTR*sizeof(int);";
  z[lc++]="  asysn_audiounit_memstatus(csys_instrtablesize, msize, advice);";
  z[lc++]="  asysn_audiounit_memstatus(csys_instrvarsize, msize, advice);";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* global table arrays */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="#if (defined(CSYS_TABLE_CATALOG_SIZE) && (CSYS_TABLE_CATALOG_SIZE > 0))";
  z[lc++]="  for (i = 0; i < CSYS_TABLE_CATALOG_SIZE; i++)";
  z[lc++]="    {";
  z[lc++]="      msize = csys_table_catalog[i].num*sizeof(float);";
  z[lc++]="      asysn_audiounit_memstatus(csys_table_catalog[i].t, msize, advice);";
  z[lc++]="    }";
  z[lc++]="#endif ";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* reflection interface variables */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="#if (defined(CSYS_GLOBALNUM) && (CSYS_GLOBALNUM > 0))";
  z[lc++]="  msize = CSYS_GLOBALNUM*sizeof(csys_varstruct);";
  z[lc++]="  asysn_audiounit_memstatus(csys_global, msize, advice);";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(CSYS_TARGETNUM) && (CSYS_TARGETNUM > 0))";
  z[lc++]="  msize = CSYS_TARGETNUM*sizeof(csys_targetstruct);";
  z[lc++]="  asysn_audiounit_memstatus(csys_target, msize, advice);";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(CSYS_LABELNUM) && (CSYS_LABELNUM > 0))";
  z[lc++]="  msize = CSYS_LABELNUM*sizeof(csys_labelstruct);";
  z[lc++]="  asysn_audiounit_memstatus(csys_labels, msize, advice);";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(CSYS_PRESETNUM) && (CSYS_PRESETNUM > 0))";
  z[lc++]="  msize = CSYS_PRESETNUM*sizeof(csys_presetstruct);";
  z[lc++]="  asysn_audiounit_memstatus(csys_presets, msize, advice);";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(CSYS_SAMPLENUM) && (CSYS_SAMPLENUM > 0))";
  z[lc++]="  msize = CSYS_SAMPLENUM*sizeof(csys_samplestruct);";
  z[lc++]="  asysn_audiounit_memstatus(csys_samples, msize, advice);";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(CSYS_BUSNUM) && (CSYS_BUSNUM > 0))";
  z[lc++]="  msize = CSYS_BUSNUM*sizeof(csys_busstruct);";
  z[lc++]="  asysn_audiounit_memstatus(csys_bus, msize, advice);";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(CSYS_ROUTENUM) && (CSYS_ROUTENUM > 0))";
  z[lc++]="  msize = CSYS_ROUTENUM*sizeof(csys_routestruct);";
  z[lc++]="  asysn_audiounit_memstatus(csys_route, msize, advice);";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(CSYS_SENDNUM) && (CSYS_SENDNUM > 0))";
  z[lc++]="  msize = CSYS_SENDNUM*sizeof(csys_sendstruct);";
  z[lc++]="  asysn_audiounit_memstatus(csys_send, msize, advice);";
  z[lc++]="  for (i = 0; i < CSYS_SENDNUM; i++)";
  z[lc++]="    if (csys_send[i].bus)";
  z[lc++]="      {";
  z[lc++]="	msize = csys_send[i].nbus*sizeof(int);";
  z[lc++]="	asysn_audiounit_memstatus(csys_send[i].bus, msize, advice);";
  z[lc++]="      }";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(CSYS_INSTRNUM) && (CSYS_INSTRNUM > 0))";
  z[lc++]="  msize = CSYS_INSTRNUM*sizeof(csys_instrstruct);";
  z[lc++]="  asysn_audiounit_memstatus(csys_instr, msize, advice);";
  z[lc++]="  for (i = 0; i < CSYS_INSTRNUM; i++)";
  z[lc++]="    {";
  z[lc++]="      if (csys_instr[i].name)";
  z[lc++]="	{";
  z[lc++]="	  msize = (strlen(csys_instr[i].name) + 1)*sizeof(char);";
  z[lc++]="	  asysn_audiounit_memstatus(csys_instr[i].name, msize, advice);";
  z[lc++]="	}";
  z[lc++]="      if (csys_instr[i].vars)";
  z[lc++]="	{";
  z[lc++]="	  msize = csys_instr[i].numvars*sizeof(csys_varstruct);";
  z[lc++]="	  asysn_audiounit_memstatus(csys_instr[i].vars, msize, advice);";
  z[lc++]="	  for (j = 0; j < csys_instr[i].numvars; j++)";
  z[lc++]="	    if (csys_instr[i].vars[j].name)";
  z[lc++]="	      {";
  z[lc++]="		msize = (strlen(csys_instr[i].vars[j].name) + 1)*sizeof(char);";
  z[lc++]="		asysn_audiounit_memstatus(csys_instr[i].vars[j].name, msize, advice);";
  z[lc++]="	      }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="} ";
  z[lc++]="";
  z[lc++]="/************************************************************/";
  z[lc++]="/* Helper for Open Selector: Recover from a failed open.    */";
  z[lc++]="/************************************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_instance_cleanup";
  z[lc++]="(ComponentParameters * p, asysn_audiounit_InstanceState * My)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, k, msize;";
  z[lc++]="";
  z[lc++]="  if (My)";
  z[lc++]="    {";
  z[lc++]="      if (My->PresentPreset.presetName)";
  z[lc++]="	CFRelease(My->PresentPreset.presetName);";
  z[lc++]="";
  z[lc++]="      if (My->AudioBufferCarrier)";
  z[lc++]="	{";
  z[lc++]="	  msize = sizeof(UInt32) + sizeof(AudioBuffer)*ASYS_AUDIOUNIT_INPUT_MAXCHANNELS;";
  z[lc++]="	  asysn_audiounit_memstatus(My->AudioBufferCarrier, msize, MADV_FREE);";
  z[lc++]="	  free(My->AudioBufferCarrier);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (My->AudioBufferTemplate)";
  z[lc++]="	{";
  z[lc++]="	  msize = sizeof(Float32)*ASYS_AUDIOUNIT_FRAMES_PER_SLICE;";
  z[lc++]="	  for(i = 0; i < ASYS_AUDIOUNIT_INPUT_MAXCHANNELS; i++)";
  z[lc++]="	    if (My->AudioBufferTemplate->mBuffers[i].mData)";
  z[lc++]="	      {";
  z[lc++]="		asysn_audiounit_memstatus(My->AudioBufferTemplate->mBuffers[i].mData, ";
  z[lc++]="					  msize, MADV_FREE);";
  z[lc++]="		free(My->AudioBufferTemplate->mBuffers[i].mData);";
  z[lc++]="	      }";
  z[lc++]="	  msize = sizeof(UInt32) + sizeof(AudioBuffer)*ASYS_AUDIOUNIT_INPUT_MAXCHANNELS;";
  z[lc++]="	  asysn_audiounit_memstatus(My->AudioBufferTemplate, msize, MADV_FREE);";
  z[lc++]="	  free(My->AudioBufferTemplate);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      for(i = 0; i < ASYS_AUDIOUNIT_OUTPUT_MAXCHANNELS; i++)";
  z[lc++]="	if (My->mData_Output[i])";
  z[lc++]="	  {";
  z[lc++]="	    msize = sizeof(Float32)*ASYS_AUDIOUNIT_FRAMES_PER_SLICE;";
  z[lc++]="	    asysn_audiounit_memstatus(My->mData_Output[i], msize, MADV_FREE);";
  z[lc++]="	    free(My->mData_Output[i]);";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="      if (My->mpipepair[0])";
  z[lc++]="	close(My->mpipepair[0]);";
  z[lc++]="      if (My->mpipepair[1])";
  z[lc++]="	close(My->mpipepair[1]);";
  z[lc++]="      if (My->spipepair[0])";
  z[lc++]="	close(My->spipepair[0]);";
  z[lc++]="      if (My->spipepair[1])";
  z[lc++]="	close(My->spipepair[1]);";
  z[lc++]="";
  z[lc++]="      if (My->parameterlist)";
  z[lc++]="	free(My->parameterlist);";
  z[lc++]="";
  z[lc++]="      if (My->parameterinfo)";
  z[lc++]="	{";
  z[lc++]="	  for (i = 0; i < My->num_saolparams; i++)";
  z[lc++]="	    {";
  z[lc++]="	      if (My->parameterinfo[i].cfNameString)";
  z[lc++]="		CFRelease(My->parameterinfo[i].cfNameString);";
  z[lc++]="	      if (My->parameterinfo[i].unitName)";
  z[lc++]="		CFRelease(My->parameterinfo[i].unitName);";
  z[lc++]="	    }";
  z[lc++]="	  free(My->parameterinfo);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (My->pvs_size)";
  z[lc++]="	{";
  z[lc++]="	  if (My->pvs_cstr)";
  z[lc++]="	    {";
  z[lc++]="	      for (i = 0; i < My->num_saolparams; i++)";
  z[lc++]="		if (My->pvs_cstr[i])";
  z[lc++]="		  {";
  z[lc++]="		    for (k = 0; k < My->pvs_size[i]; k++)";
  z[lc++]="		      if (My->pvs_cstr[i][k])";
  z[lc++]="			free(My->pvs_cstr[i][k]);";
  z[lc++]="		    free(My->pvs_cstr[i]);";
  z[lc++]="		  }";
  z[lc++]="	      free(My->pvs_cstr);";
  z[lc++]="	    }";
  z[lc++]="	  free(My->pvs_size);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (My->saolparam)";
  z[lc++]="	{";
  z[lc++]="	  msize = My->num_saolparams*sizeof(asysn_audiounit_saolparam);";
  z[lc++]="	  asysn_audiounit_memstatus(My->saolparam, msize, MADV_FREE);";
  z[lc++]="	  free(My->saolparam);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (My->factorypreset_info)";
  z[lc++]="	{";
  z[lc++]="	  for (i = 0; i < My->num_factory; i++)";
  z[lc++]="	    if (My->factorypreset_info[i].presetName)";
  z[lc++]="	      CFRelease(My->factorypreset_info[i].presetName);";
  z[lc++]="	  free(My->factorypreset_info);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (My->factorypreset_values)";
  z[lc++]="	{";
  z[lc++]="	  msize = My->num_saolparams*sizeof(Float32);";
  z[lc++]="	  for (i = 0; i < My->num_factory; i++)";
  z[lc++]="	    if (My->factorypreset_values[i])";
  z[lc++]="	      {";
  z[lc++]="		asysn_audiounit_memstatus(My->factorypreset_values[i], msize, MADV_FREE);";
  z[lc++]="		free(My->factorypreset_values[i]);";
  z[lc++]="	      }";
  z[lc++]="";
  z[lc++]="	  msize = My->num_factory*sizeof(Float32 *);";
  z[lc++]="	  asysn_audiounit_memstatus(My->factorypreset_values, msize, MADV_FREE);";
  z[lc++]="	  free(My->factorypreset_values);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (My->factorypreset_array)";
  z[lc++]="	CFRelease(My->factorypreset_array);";
  z[lc++]="";
  z[lc++]="      msize = sizeof(asysn_audiounit_InstanceState);";
  z[lc++]="      asysn_audiounit_memstatus(My, msize, MADV_FREE);";
  z[lc++]="      free(My);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  SetComponentInstanceStorage((ComponentInstance) p->params[0], (Handle) NULL); ";
  z[lc++]="  return kAudioUnitErr_FailedInitialization;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/**********************************************************************/";
  z[lc++]="/* Helper for Initialize Selector: Send all parameters to SAOL engine */";
  z[lc++]="/**********************************************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_engine_parameter_update";
  z[lc++]="(asysn_audiounit_InstanceState * My) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_SASLevent SASLevent;";
  z[lc++]="  int result = noErr;";
  z[lc++]="  int i;";
  z[lc++]="  ";
  z[lc++]="  for (i = 0; i < My->num_saolparams; i++)";
  z[lc++]="    {";
  z[lc++]="      SASLevent.index = i;";
  z[lc++]="      SASLevent.value = My->saolparam[i].value;";
  z[lc++]="      SASLevent.kcycleidx = 0;";
  z[lc++]="      result |= asysn_audiounit_sendSASLevent(&SASLevent, My);    ";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return result;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***************************************************************/";
  z[lc++]="/* Helper for Uninitialize Selector: empty MIDI and SASL pipes */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_engine_emptypipes";
  z[lc++]="(asysn_audiounit_InstanceState * My) ";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_MIDIevent mdummy;";
  z[lc++]="  asysn_audiounit_SASLevent sdummy;";
  z[lc++]="  int retry = 0;";
  z[lc++]="";
  z[lc++]="  if (ASYS_AUDIOUNIT_MIDISUPPORT && My->mpipepair[0])";
  z[lc++]="    do { ";
  z[lc++]="      if (retry++ > ASYS_AUDIOUNIT_RETRY_MAX)";
  z[lc++]="	break;";
  z[lc++]="    } while ((read(My->mpipepair[0], &mdummy, ";
  z[lc++]="		   sizeof(asysn_audiounit_MIDIevent)) > 0) || (errno == EINTR));";
  z[lc++]="";
  z[lc++]="  retry == 0;";
  z[lc++]="";
  z[lc++]="  if (My->spipepair[0])";
  z[lc++]="    do {";
  z[lc++]="      if (retry++ > ASYS_AUDIOUNIT_RETRY_MAX)";
  z[lc++]="	break;";
  z[lc++]="    } while ((read(My->spipepair[0], &sdummy, ";
  z[lc++]="		   sizeof(asysn_audiounit_SASLevent)) > 0) || (errno == EINTR));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* Helper Functions for the GetProperty Selector Helper for ClassInfo  */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/***********************************************/";
  z[lc++]="/* Big-endian int append to a CFMutableDataRef */";
  z[lc++]="/***********************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_classinfo_pdata_intwrite(CFMutableDataRef pdata, SInt32 value)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char p[4];";
  z[lc++]="  ";
  z[lc++]="  p[0] = 0x000000FF & (value >> 24);";
  z[lc++]="  p[1] = 0x000000FF & (value >> 16);";
  z[lc++]="  p[2] = 0x000000FF & (value >> 8);";
  z[lc++]="  p[3] = 0x000000FF & (value);";
  z[lc++]="";
  z[lc++]="  CFDataAppendBytes(pdata, (UInt8 *) p, 4);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***************************************************/";
  z[lc++]="/*  Big-endian float append to a CFMutableDataRef  */";
  z[lc++]="/*   Assumes int and float share an enddian-ness   */   ";
  z[lc++]="/***************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_classinfo_pdata_floatwrite(CFMutableDataRef pdata, Float32 fval)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  union { int i; float f ; } u;";
  z[lc++]="  unsigned char p[4];";
  z[lc++]="";
  z[lc++]="  u.f = fval;";
  z[lc++]="  ";
  z[lc++]="  p[0] = 0x000000FF & (u.i >> 24);";
  z[lc++]="  p[1] = 0x000000FF & (u.i >> 16);";
  z[lc++]="  p[2] = 0x000000FF & (u.i >> 8);";
  z[lc++]="  p[3] = 0x000000FF & (u.i);";
  z[lc++]="";
  z[lc++]="  CFDataAppendBytes(pdata, (UInt8 *) p, 4);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/************************************/";
  z[lc++]="/* Adds integer item to a ClassInfo */";
  z[lc++]="/************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_classinfo_addint(CFMutableDictionaryRef ClassInfo, ";
  z[lc++]="				     char * ckey, SInt32 value)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  CFStringRef key;";
  z[lc++]="  CFNumberRef num;";
  z[lc++]="  int errcode = -1;";
  z[lc++]="";
  z[lc++]="  key = CFStringCreateWithCString(NULL, ckey, kCFStringEncodingASCII);";
  z[lc++]="  if (key)";
  z[lc++]="    {";
  z[lc++]="      num = CFNumberCreate(NULL, kCFNumberSInt32Type, &value);";
  z[lc++]="      if (num)";
  z[lc++]="	{";
  z[lc++]="	  CFDictionarySetValue(ClassInfo, key, num);";
  z[lc++]="	  CFRelease(num);";
  z[lc++]="	  errcode = 0;";
  z[lc++]="	}";
  z[lc++]="      CFRelease(key);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return errcode;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/************************************/";
  z[lc++]="/* Adds float item to a ClassInfo */";
  z[lc++]="/************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_classinfo_addfloat(CFMutableDictionaryRef ClassInfo, ";
  z[lc++]="				       char * ckey, Float32 fval)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  CFStringRef key;";
  z[lc++]="  CFNumberRef num;";
  z[lc++]="  int errcode = -1;";
  z[lc++]="";
  z[lc++]="  key = CFStringCreateWithCString(NULL, ckey, kCFStringEncodingASCII);";
  z[lc++]="  if (key)";
  z[lc++]="    {";
  z[lc++]="      num = CFNumberCreate(NULL, kCFNumberFloatType, &fval);";
  z[lc++]="      if (num)";
  z[lc++]="	{";
  z[lc++]="	  CFDictionarySetValue(ClassInfo, key, num);";
  z[lc++]="	  CFRelease(num);";
  z[lc++]="	  errcode = 0;";
  z[lc++]="	}";
  z[lc++]="      CFRelease(key);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return errcode;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*************************************/";
  z[lc++]="/* Adds CFString item to a ClassInfo */";
  z[lc++]="/*************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_classinfo_addcfstr(CFMutableDictionaryRef ClassInfo, ";
  z[lc++]="				       char * ckey, CFStringRef cfstr)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  CFStringRef key;";
  z[lc++]="  int errcode = -1;";
  z[lc++]="";
  z[lc++]="  key = CFStringCreateWithCString(NULL, ckey, kCFStringEncodingASCII);";
  z[lc++]="  if (key)";
  z[lc++]="    {";
  z[lc++]="      CFDictionarySetValue(ClassInfo, key, cfstr);";
  z[lc++]="      CFRelease(key);";
  z[lc++]="      errcode = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return errcode;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/************************************************************************/";
  z[lc++]="/* Helper for GetProperty Selector: Create ClassInfo for use by AU host */";
  z[lc++]="/************************************************************************/";
  z[lc++]="";
  z[lc++]="CFMutableDictionaryRef asysn_audiounit_classinfo_create";
  z[lc++]="                                           (asysn_audiounit_InstanceState * My) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  CFMutableDictionaryRef ClassInfo;";
  z[lc++]="  CFMutableDataRef pdata;";
  z[lc++]="  CFStringRef key;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  ClassInfo = CFDictionaryCreateMutable";
  z[lc++]="    (NULL, 0, &kCFTypeDictionaryKeyCallBacks, &kCFTypeDictionaryValueCallBacks);";
  z[lc++]="";
  z[lc++]="  /* component definitions adapted from volume.r */";
  z[lc++]="";
  z[lc++]="  asysn_audiounit_classinfo_addint(ClassInfo, kAUPresetVersionKey, ";
  z[lc++]="				   0);  /* version 0 */";
  z[lc++]="  asysn_audiounit_classinfo_addint(ClassInfo, kAUPresetTypeKey, ";
  z[lc++]="				   ASYS_AUDIOUNIT_COMP_TYPE);";
  z[lc++]="  asysn_audiounit_classinfo_addint(ClassInfo, kAUPresetSubtypeKey, ";
  z[lc++]="				   ASYS_AUDIOUNIT_COMP_SUBTYPE);";
  z[lc++]="  asysn_audiounit_classinfo_addint(ClassInfo, kAUPresetManufacturerKey, ";
  z[lc++]="				   ASYS_AUDIOUNIT_COMP_MANU);";
  z[lc++]="";
  z[lc++]="  /* parameter data */";
  z[lc++]="";
  z[lc++]="  if ((pdata = CFDataCreateMutable(NULL, 0)) && My->num_saolparams)";
  z[lc++]="    {";
  z[lc++]="      asysn_audiounit_classinfo_pdata_intwrite(pdata, ";
  z[lc++]="  			              kAudioUnitScope_Global);     /* global scope */";
  z[lc++]="      asysn_audiounit_classinfo_pdata_intwrite(pdata, ";
  z[lc++]="				      0);                       /* element (bus) 0 */";
  z[lc++]="      asysn_audiounit_classinfo_pdata_intwrite(pdata, ";
  z[lc++]="				      My->num_saolparams); /* number of parameters */";
  z[lc++]="";
  z[lc++]="      for (i = 0; i < My->num_saolparams; i++)";
  z[lc++]="	{";
  z[lc++]="	  /* parameter index */";
  z[lc++]="";
  z[lc++]="	  asysn_audiounit_classinfo_pdata_intwrite(pdata, i);";
  z[lc++]="";
  z[lc++]="	  /* value */";
  z[lc++]="";
  z[lc++]="	  asysn_audiounit_classinfo_pdata_floatwrite";
  z[lc++]="	    (pdata, ";
  z[lc++]="	     (My->parameterinfo[i].flags & kAudioUnitParameterFlag_IsWritable) ?";
  z[lc++]="	     My->saolparam[i].value : My->parameterinfo[i].defaultValue);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (pdata)";
  z[lc++]="    {";
  z[lc++]="      key = CFStringCreateWithCString(NULL, kAUPresetDataKey, kCFStringEncodingASCII);";
  z[lc++]="      if (key)";
  z[lc++]="	{";
  z[lc++]="	  CFDictionarySetValue(ClassInfo, key, pdata);";
  z[lc++]="	  CFRelease(key);";
  z[lc++]="	}";
  z[lc++]="      CFRelease(pdata);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  asysn_audiounit_classinfo_addcfstr(ClassInfo, kAUPresetNameKey, ";
  z[lc++]="				     My->PresentPreset.presetName);";
  z[lc++]="  asysn_audiounit_classinfo_addint(ClassInfo, kAUPresetRenderQualityKey, ";
  z[lc++]="				   (SInt32) (My->RenderQuality));";
  z[lc++]="  asysn_audiounit_classinfo_addfloat(ClassInfo, kAUPresetCPULoadKey, ";
  z[lc++]="				     My->CPULoad);";
  z[lc++]="";
  z[lc++]="  /* add kAUPresetElementNameKey here if named elements/buses are supported */";
  z[lc++]="";
  z[lc++]="  return ClassInfo;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* Helper Functions for the SetProperty Selector Helper for ClassInfo  */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/**************************************/";
  z[lc++]="/* Read integer item from a ClassInfo */";
  z[lc++]="/**************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_classinfo_readint(CFMutableDictionaryRef ClassInfo, ";
  z[lc++]="				      char * ckey, SInt32 * value)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  CFStringRef key;";
  z[lc++]="  CFNumberRef num;";
  z[lc++]="  SInt32 newval;";
  z[lc++]="  int errcode = -1;";
  z[lc++]="";
  z[lc++]="  key = CFStringCreateWithCString(NULL, ckey, kCFStringEncodingASCII);";
  z[lc++]="  if (key)";
  z[lc++]="    {";
  z[lc++]="      num = CFDictionaryGetValue(ClassInfo, key);";
  z[lc++]="      if (num && CFNumberGetValue(num, kCFNumberSInt32Type, &newval))";
  z[lc++]="	{";
  z[lc++]="	  errcode = 0;";
  z[lc++]="	  *value = newval;";
  z[lc++]="	}";
  z[lc++]="      CFRelease(key);";
  z[lc++]="    }";
  z[lc++]="  return errcode;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/**************************************/";
  z[lc++]="/*  Read float item from a ClassInfo  */";
  z[lc++]="/**************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_classinfo_readfloat(CFMutableDictionaryRef ClassInfo, ";
  z[lc++]="					char * ckey, Float32 * value)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  CFStringRef key;";
  z[lc++]="  CFNumberRef num;";
  z[lc++]="  Float32 newval;";
  z[lc++]="  int errcode = -1;";
  z[lc++]="";
  z[lc++]="  key = CFStringCreateWithCString(NULL, ckey, kCFStringEncodingASCII);";
  z[lc++]="  if (key)";
  z[lc++]="    {";
  z[lc++]="      num = CFDictionaryGetValue(ClassInfo, key);";
  z[lc++]="      if (num && CFNumberGetValue(num, kCFNumberFloat32Type, &newval))";
  z[lc++]="	{";
  z[lc++]="	  errcode = 0;";
  z[lc++]="	  *value = newval;";
  z[lc++]="	}";
  z[lc++]="      CFRelease(key);";
  z[lc++]="    }";
  z[lc++]="  return errcode;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***************************************/";
  z[lc++]="/* Read CFString item from a ClassInfo */";
  z[lc++]="/***************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_classinfo_readcfstr(CFMutableDictionaryRef ClassInfo, ";
  z[lc++]="					char * ckey, CFStringRef * cfstr)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  CFStringRef key;";
  z[lc++]="  CFNumberRef num;";
  z[lc++]="  CFStringRef newstr;";
  z[lc++]="  int errcode = -1;";
  z[lc++]="";
  z[lc++]="  key = CFStringCreateWithCString(NULL, ckey, kCFStringEncodingASCII);";
  z[lc++]="  if (key)";
  z[lc++]="    {";
  z[lc++]="      if (newstr = CFDictionaryGetValue(ClassInfo, key))";
  z[lc++]="	{";
  z[lc++]="	  errcode = 0;";
  z[lc++]="	  CFRetain(newstr);";
  z[lc++]="	  if (*cfstr)";
  z[lc++]="	    CFRelease(*cfstr);";
  z[lc++]="	  *cfstr = newstr;";
  z[lc++]="	}";
  z[lc++]="      CFRelease(key);";
  z[lc++]="    }";
  z[lc++]="  return errcode;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***********************************************/";
  z[lc++]="/* Big-endian int read from a CFMutableDataRef */";
  z[lc++]="/***********************************************/";
  z[lc++]="";
  z[lc++]="SInt32 asysn_audiounit_classinfo_pdata_intread(CFMutableDataRef pdata, UInt8 ** p)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  SInt32 value;";
  z[lc++]="  ";
  z[lc++]="  value = ((*p)[0] << 24) | ((*p)[1] << 16) | ((*p)[2] << 8) | ((*p)[3]);";
  z[lc++]="  (*p) += 4;";
  z[lc++]="  return value;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*************************************************/";
  z[lc++]="/* Big-endian float read from a CFMutableDataRef */";
  z[lc++]="/*************************************************/";
  z[lc++]="";
  z[lc++]="Float32 asysn_audiounit_classinfo_pdata_floatread(CFMutableDataRef pdata, UInt8 ** p)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  union { SInt32 i; Float32 f ; } u;";
  z[lc++]="";
  z[lc++]="  u.i = ((*p)[0] << 24) | ((*p)[1] << 16) | ((*p)[2] << 8) | ((*p)[3]);";
  z[lc++]="  (*p) += 4;";
  z[lc++]="  return u.f;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************/";
  z[lc++]="/* Read parameter data from a ClassInfo */";
  z[lc++]="/****************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_classinfo_readpdata(asysn_audiounit_InstanceState * My, ";
  z[lc++]="					CFMutableDictionaryRef ClassInfo)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int errcode = -1;";
  z[lc++]="  CFStringRef key;";
  z[lc++]="  CFMutableDataRef pdata;";
  z[lc++]="  UInt8 * p, * pmax;";
  z[lc++]="  UInt32 scope, bus, count, idx;";
  z[lc++]="  Float32 fval;";
  z[lc++]="";
  z[lc++]="  key = CFStringCreateWithCString(NULL, kAUPresetDataKey, kCFStringEncodingASCII);";
  z[lc++]="";
  z[lc++]="  if (key && (pdata = (CFMutableDataRef) CFDictionaryGetValue(ClassInfo, key)))";
  z[lc++]="    {";
  z[lc++]="      p = (UInt8 *) CFDataGetBytePtr(pdata);";
  z[lc++]="      pmax = p + CFDataGetLength(pdata);";
  z[lc++]="";
  z[lc++]="      do {";
  z[lc++]="	if (p == pmax)";
  z[lc++]="	  {";
  z[lc++]="	    errcode = 0; ";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="	if ((pmax - p) >= 12)";
  z[lc++]="	  {";
  z[lc++]="	    scope = asysn_audiounit_classinfo_pdata_intread(pdata, &p);";
  z[lc++]="	    bus = asysn_audiounit_classinfo_pdata_intread(pdata, &p);";
  z[lc++]="	    count = asysn_audiounit_classinfo_pdata_intread(pdata, &p);";
  z[lc++]="	    if ((pmax - p) >= count*(sizeof(SInt32) + sizeof(Float32)))";
  z[lc++]="	      if ((scope == kAudioUnitScope_Global) && !bus)";
  z[lc++]="		while (count--)";
  z[lc++]="		  {";
  z[lc++]="		    idx = asysn_audiounit_classinfo_pdata_intread(pdata, &p);";
  z[lc++]="		    fval = asysn_audiounit_classinfo_pdata_floatread(pdata, &p);";
  z[lc++]="		    if (idx < My->num_saolparams)";
  z[lc++]="		      {";
  z[lc++]="			if (fval > My->parameterinfo[idx].maxValue)";
  z[lc++]="			  fval = My->parameterinfo[idx].maxValue;";
  z[lc++]="			";
  z[lc++]="			if (fval < My->parameterinfo[idx].minValue)";
  z[lc++]="			  fval = My->parameterinfo[idx].minValue;";
  z[lc++]="";
  z[lc++]="			My->saolparam[idx].value = fval;";
  z[lc++]="		      }";
  z[lc++]="		  }";
  z[lc++]="	      else";
  z[lc++]="		p += count*(sizeof(SInt32) + sizeof(Float32));";
  z[lc++]="	    else";
  z[lc++]="	      break;";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  break;";
  z[lc++]="      } while (1);";
  z[lc++]="      ";
  z[lc++]="      CFRelease(key);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return errcode;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/************************************************************************/";
  z[lc++]="/* Helper for SetProperty Selector: Reads ClassInfo returned by AU host */";
  z[lc++]="/************************************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_classinfo_read(asysn_audiounit_InstanceState * My, ";
  z[lc++]="				    CFMutableDictionaryRef ClassInfo) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_classinfo_readpdata(My, ClassInfo);";
  z[lc++]="";
  z[lc++]="  asysn_audiounit_engine_parameter_update(My); ";
  z[lc++]="";
  z[lc++]="  asysn_audiounit_classinfo_readint(ClassInfo, kAUPresetRenderQualityKey, ";
  z[lc++]="				    (SInt32 *) &(My->RenderQuality));";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_CPULoad));";
  z[lc++]="";
  z[lc++]="  asysn_audiounit_classinfo_readfloat(ClassInfo, kAUPresetCPULoadKey, ";
  z[lc++]="				      &(My->CPULoad));";
  z[lc++]="  My->ksync_normalize = (Float32) (My->krate/AudioGetHostClockFrequency());";
  z[lc++]="  if (My->CPULoad)";
  z[lc++]="    My->ksync_normalize = My->ksync_normalize/My->CPULoad;";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_CPULoad));";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_PresentPreset));";
  z[lc++]="";
  z[lc++]="  asysn_audiounit_classinfo_readcfstr(ClassInfo, kAUPresetNameKey, ";
  z[lc++]="				      &(My->PresentPreset.presetName));";
  z[lc++]="";
  z[lc++]="  My->PresentPreset.presetNumber = ";
  z[lc++]="    asysn_audiounit_factorypresetnumber(My->PresentPreset.presetName); ";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_PresentPreset));";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  /* add kAUPresetElementNameKey here if named elements/buses are supported */";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/* Helper Function for SetProperty: PresentProperty Factory Presets */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_presentproperty_setfactory";
  z[lc++]="(asysn_audiounit_InstanceState * My) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int j, k;";
  z[lc++]="";
  z[lc++]="  j = My->PresentPreset.presetNumber;";
  z[lc++]="";
  z[lc++]="  if ((j < 0) || (j > My->num_factory))";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  for (k = 0; k < My->num_saolparams; k++)";
  z[lc++]="    My->saolparam[k].value = My->factorypreset_values[j][k];";
  z[lc++]="";
  z[lc++]="  asysn_audiounit_engine_parameter_update(My); ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************************************/";
  z[lc++]="/* Helper for Property Selectors: returns 1 for supported properties */";
  z[lc++]="/*********************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_supported_property(AudioUnitPropertyID id, AudioUnitScope scope) ";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  switch (id) {";
  z[lc++]="  case kAudioUnitProperty_ClassInfo: /* 0 */";
  z[lc++]="    return 1;";
  z[lc++]="  case kAudioUnitProperty_MakeConnection: /* 1 */";
  z[lc++]="    return 1;";
  z[lc++]="  case kAudioUnitProperty_SampleRate: /* 2 */";
  z[lc++]="    switch (scope) {";
  z[lc++]="    case kAudioUnitScope_Input:";
  z[lc++]="      return (ASYS_AUDIOUNIT_EFFECT) ? 1 : 0;";
  z[lc++]="    case kAudioUnitScope_Global:";
  z[lc++]="    case kAudioUnitScope_Output:";
  z[lc++]="      return 1;";
  z[lc++]="    default:";
  z[lc++]="      return 0;";
  z[lc++]="    }";
  z[lc++]="  case kAudioUnitProperty_ParameterList: /* 3 */";
  z[lc++]="    return  (scope == kAudioUnitScope_Global);";
  z[lc++]="  case kAudioUnitProperty_ParameterInfo: /* 4 */ ";
  z[lc++]="    return 1;";
  z[lc++]="  case kAudioUnitProperty_FastDispatch:  /* 5 */";
  z[lc++]="    return 1;";
  z[lc++]="  case kAudioUnitProperty_CPULoad: /* 6 */ ";
  z[lc++]="    return (scope == kAudioUnitScope_Global) ? ";
  z[lc++]="      ASYS_AUDIOUNIT_SUPPORT_PROPERTY_CPULOAD : 0; ";
  z[lc++]="  case kAudioUnitProperty_StreamFormat: /* 8 */ ";
  z[lc++]="    switch (scope) {";
  z[lc++]="    case kAudioUnitScope_Input:";
  z[lc++]="      return (ASYS_AUDIOUNIT_EFFECT) ? 1 : 0;";
  z[lc++]="    case kAudioUnitScope_Global:";
  z[lc++]="    case kAudioUnitScope_Output:";
  z[lc++]="      return 1;";
  z[lc++]="    default:";
  z[lc++]="      return 0;";
  z[lc++]="    }";
  z[lc++]="  case kAudioUnitProperty_SRCAlgorithm: /* 9 */";
  z[lc++]="    return 1;";
  z[lc++]="  case kAudioUnitProperty_ElementCount: /* 11, also kAudioUnitProperty_BusCount */";
  z[lc++]="    return 1;";
  z[lc++]="  case kAudioUnitProperty_Latency: /* 12 */";
  z[lc++]="    return (scope == kAudioUnitScope_Global) ? 1 : 0; ";
  z[lc++]="  case kAudioUnitProperty_SupportedNumChannels: /* 13 */";
  z[lc++]="    return (scope == kAudioUnitScope_Global) ? 1 : 0; ";
  z[lc++]="  case kAudioUnitProperty_MaximumFramesPerSlice: /* 14 */";
  z[lc++]="    return (scope == kAudioUnitScope_Global) ? 1 : 0; ";
  z[lc++]="  case kAudioUnitProperty_ParameterValueStrings: /* 16 */";
  z[lc++]="    return (scope == kAudioUnitScope_Global) ? 1 : 0; ";
  z[lc++]="  case kAudioUnitProperty_TailTime: /* 20 */";
  z[lc++]="    return (scope == kAudioUnitScope_Global) ? 1 : 0; ";
  z[lc++]="  case kAudioUnitProperty_BypassEffect: /* 21 */";
  z[lc++]="    return (scope == kAudioUnitScope_Global) ? 1 : 0; ";
  z[lc++]="  case kAudioUnitProperty_LastRenderError: /* 22 */";
  z[lc++]="    return (scope == kAudioUnitScope_Global) ? 1 : 0; ";
  z[lc++]="  case kAudioUnitProperty_SetRenderCallback:  /* 23 */";
  z[lc++]="    return 1;";
  z[lc++]="  case kAudioUnitProperty_FactoryPresets: /* 24 */";
  z[lc++]="    return 1;";
  z[lc++]="  case kAudioUnitProperty_RenderQuality: /* 26 */";
  z[lc++]="    return (scope == kAudioUnitScope_Global) ? ";
  z[lc++]="      ASYS_AUDIOUNIT_SUPPORT_PROPERTY_RENDERQUALITY : 0; ";
  z[lc++]="  case kAudioUnitProperty_InPlaceProcessing: /* 29 */";
  z[lc++]="    return 1;";
  z[lc++]="  case kAudioUnitProperty_CocoaUI: /* 31 */";
  z[lc++]="#if defined(ASYS_AUDIOUNIT_VIEW_BUNDLECF)";
  z[lc++]="    return 1;";
  z[lc++]="#else";
  z[lc++]="    return 0;";
  z[lc++]="#endif";
  z[lc++]="  case kAudioUnitProperty_OfflineRender: /* 37 */";
  z[lc++]="    return 1;";
  z[lc++]="  case kAudioUnitProperty_PresentPreset: /* 36 */";
  z[lc++]="    return 1;";
  z[lc++]="  case kAudioUnitProperty_PresentationLatency: /* 40 */";
  z[lc++]="    return 1;";
  z[lc++]="  case kMusicDeviceProperty_InstrumentCount: /* 1000 */";
  z[lc++]="    switch (scope) {";
  z[lc++]="    case kAudioUnitScope_Global:";
  z[lc++]="    case kAudioUnitScope_Input:";
  z[lc++]="      return ASYS_AUDIOUNIT_MUSICDEVICE ? 1 : 0;";
  z[lc++]="    default:";
  z[lc++]="      return 0;";
  z[lc++]="    }";
  z[lc++]="  case kMusicDeviceProperty_StreamFromDisk: /* 1011 */";
  z[lc++]="    return ASYS_AUDIOUNIT_SUPPORT_PROPERTY_STREAMFROMDISK;";
  z[lc++]="  default:";
  z[lc++]="    return 0;";
  z[lc++]="  }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*******************************************************************/";
  z[lc++]="/* Helper for property Selectors: returns property size (in bytes) */";
  z[lc++]="/*******************************************************************/";
  z[lc++]="";
  z[lc++]="unsigned int asysn_audiounit_property_size(AudioUnitPropertyID id, ";
  z[lc++]="					   asysn_audiounit_InstanceState * My)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  switch (id) {";
  z[lc++]="  case kAudioUnitProperty_ClassInfo: /* 0 */";
  z[lc++]="    return sizeof(CFPropertyListRef);   ";
  z[lc++]="  case kAudioUnitProperty_MakeConnection: /* 1 */";
  z[lc++]="    return sizeof(AudioUnitConnection);   ";
  z[lc++]="  case kAudioUnitProperty_SampleRate: /* 2 */";
  z[lc++]="    return sizeof(Float64);   ";
  z[lc++]="  case kAudioUnitProperty_ParameterList: /* 3 */";
  z[lc++]="    return My->num_saolparams*sizeof(AudioUnitParameterID);   ";
  z[lc++]="  case kAudioUnitProperty_ParameterInfo: /* 4 */ ";
  z[lc++]="    return sizeof(AudioUnitParameterInfo);   ";
  z[lc++]="  case kAudioUnitProperty_FastDispatch:  /* 5 */";
  z[lc++]="    return sizeof(void *);   ";
  z[lc++]="  case kAudioUnitProperty_CPULoad: /* 6 */ ";
  z[lc++]="    return sizeof(Float32);   ";
  z[lc++]="  case kAudioUnitProperty_StreamFormat: /* 8 */ ";
  z[lc++]="    return sizeof(AudioStreamBasicDescription);   ";
  z[lc++]="  case kAudioUnitProperty_SRCAlgorithm: /* 9 */";
  z[lc++]="    return sizeof(OSType);   ";
  z[lc++]="  case kAudioUnitProperty_ElementCount: /* 11, also kAudioUnitProperty_BusCount */";
  z[lc++]="    return sizeof(UInt32);   ";
  z[lc++]="  case kAudioUnitProperty_Latency: /* 12 */";
  z[lc++]="    return sizeof(Float64);   ";
  z[lc++]="  case kAudioUnitProperty_SupportedNumChannels: /* 13 */";
  z[lc++]="    return ASYS_AUDIOUNIT_SUPPORTED_FORMATS*sizeof(AUChannelInfo);   ";
  z[lc++]="  case kAudioUnitProperty_MaximumFramesPerSlice: /* 14 */";
  z[lc++]="    return sizeof(UInt32);   ";
  z[lc++]="  case kAudioUnitProperty_ParameterValueStrings: /* 16 */";
  z[lc++]="    return sizeof(CFArrayRef);";
  z[lc++]="  case kAudioUnitProperty_TailTime: /* 20 */";
  z[lc++]="    return sizeof(Float64);   ";
  z[lc++]="  case kAudioUnitProperty_BypassEffect: /* 21 */";
  z[lc++]="    return sizeof(UInt32);   ";
  z[lc++]="  case kAudioUnitProperty_LastRenderError: /* 22 */";
  z[lc++]="    return sizeof(OSStatus);   ";
  z[lc++]="  case kAudioUnitProperty_SetRenderCallback:  /* 23 */";
  z[lc++]="    return sizeof(AURenderCallbackStruct);   ";
  z[lc++]="  case kAudioUnitProperty_FactoryPresets: /* 24 */";
  z[lc++]="    return sizeof(CFArrayRef);";
  z[lc++]="  case kAudioUnitProperty_RenderQuality: /* 26 */";
  z[lc++]="    return sizeof(UInt32);   ";
  z[lc++]="  case kAudioUnitProperty_InPlaceProcessing: /* 29 */";
  z[lc++]="    return sizeof(UInt32);   ";
  z[lc++]="  case kAudioUnitProperty_CocoaUI: /* 31 */";
  z[lc++]="#if defined(ASYS_AUDIOUNIT_VIEW_BUNDLECF)";
  z[lc++]="    return sizeof(AudioUnitCocoaViewInfo);";
  z[lc++]="#else";
  z[lc++]="    break;";
  z[lc++]="#endif";
  z[lc++]="  case kAudioUnitProperty_PresentPreset: /* 36 */";
  z[lc++]="    return sizeof(AUPreset);";
  z[lc++]="  case kAudioUnitProperty_OfflineRender: /* 37 */";
  z[lc++]="    return sizeof(UInt32);   ";
  z[lc++]="  case kAudioUnitProperty_PresentationLatency: /* 40 */";
  z[lc++]="    return sizeof(Float64);   ";
  z[lc++]="  case kMusicDeviceProperty_InstrumentCount: /* 1000 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kMusicDeviceProperty_StreamFromDisk: /* 1011 */";
  z[lc++]="    return sizeof(UInt32);   ";
  z[lc++]="  default:  /* no entries here -- all cases above should specify datasize */";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  ASYS_AUDIOUNIT_WIRETAP_PUTSTRING(\"WARNING: asysn_audiounit_property_size()\" ";
  z[lc++]="				   \"called on an unsupported property\\n\");";
  z[lc++]="  return 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***************************************************************/";
  z[lc++]="/* Helper for Property Listener: returns proplisteners[] index */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_proplisteners_index(AudioUnitPropertyID id)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int property = -1;";
  z[lc++]="";
  z[lc++]="  switch (id) {";
  z[lc++]="  case kAudioUnitProperty_ParameterList: /* 3 */ ";
  z[lc++]="    property = ASYS_AUDIOUNIT_PROPLISTEN_PARAMETERLIST;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterInfo: /* 4 */ ";
  z[lc++]="    property = ASYS_AUDIOUNIT_PROPLISTEN_PARAMETERINFO;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_CPULoad: /* 6 */";
  z[lc++]="    property = ASYS_AUDIOUNIT_PROPLISTEN_CPULOAD;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_Latency: /* 12 */";
  z[lc++]="    property = ASYS_AUDIOUNIT_PROPLISTEN_LATENCY;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_TailTime: /* 20 */";
  z[lc++]="    property = ASYS_AUDIOUNIT_PROPLISTEN_TAILTIME;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_FactoryPresets: /* 24 */";
  z[lc++]="    property = ASYS_AUDIOUNIT_PROPLISTEN_FACTORYPRESETS;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_RenderQuality: /* 26 */";
  z[lc++]="    property = ASYS_AUDIOUNIT_PROPLISTEN_RENDERQUALITY;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_CurrentPreset: /* 28 */";
  z[lc++]="    property = ASYS_AUDIOUNIT_PROPLISTEN_CURRENTPRESET;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_PresentPreset: /* 36 */";
  z[lc++]="    property = ASYS_AUDIOUNIT_PROPLISTEN_PRESENTPRESET;";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_StreamFromDisk: /* 1011 */";
  z[lc++]="    property = ASYS_AUDIOUNIT_PROPLISTEN_STREAMFROMDISK;";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  return property;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***************************************************************/";
  z[lc++]="/* Helper for properties: informs listeners of a status change */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_proplisteners_update(";
  z[lc++]="                             asysn_audiounit_InstanceState * My,";
  z[lc++]="			     AudioUnitPropertyID id, ";
  z[lc++]="			     AudioUnitScope scope,";
  z[lc++]="			     AudioUnitElement element)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int idx = asysn_audiounit_proplisteners_index(id);";
  z[lc++]="  asysn_audiounit_proplisten * lp;";
  z[lc++]="";
  z[lc++]="  if (idx < 0)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_proplisteners));";
  z[lc++]="";
  z[lc++]="  for (lp = My->proplisteners[idx]; lp != NULL; lp = lp->next)";
  z[lc++]="    (*(lp->lproc))(lp->lrefcon, My->component, id, scope, element);";
  z[lc++]="";
  z[lc++]="  /* some apps are buggy and need a double-send ... */";
  z[lc++]="";
  z[lc++]="  for (lp = My->proplisteners[idx]; lp != NULL; lp = lp->next)";
  z[lc++]="    (*(lp->lproc))(lp->lrefcon, My->component, id, scope, element);";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_proplisteners));";
  z[lc++]="";
  z[lc++]="  return;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*  The istate state transition functions    */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/***************************************************************/";
  z[lc++]="/* State transition diagram on entrance to InitializeSelect:   */";
  z[lc++]="/*                                                             */";
  z[lc++]="/*           ABSENT: Return _MY_IS_NULL.                       */";
  z[lc++]="/*         INSTANCE: Set FLUX, return _INITIALIZE.             */";
  z[lc++]="/* INSTANCE_PASSING: Set FLUX_PASSING, return _INITIALIZE.     */";
  z[lc++]="/*             FLUX: Spin to INSTANCE* or ENGINE*.             */";
  z[lc++]="/*     FLUX_PASSING: Spin to INSTANCE* or ENGINE*.             */";
  z[lc++]="/*           ENGINE: Return _REINITIALIZE.                     */";
  z[lc++]="/*   ENGINE_PASSING: Return _REINITIALIZE.                     */";
  z[lc++]="/*    ENGINE_RENDER: Return _REINITIALIZE.                     */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_initializeselect_enterstate(asysn_audiounit_InstanceState * My)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int ret;";
  z[lc++]="";
  z[lc++]="  do ";
  z[lc++]="    {";
  z[lc++]="      switch(My->istate) {";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ABSENT:";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_MY_IS_NULL;";
  z[lc++]="	break; ";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_INSTANCE:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_INSTANCE, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_FLUX, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_INITIALIZE;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_INSTANCE_PASSING:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_INSTANCE_PASSING, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_FLUX_PASSING, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_INITIALIZE;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_FLUX:";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_FLUX_PASSING:";
  z[lc++]="	OSMemoryBarrier();";
  z[lc++]="	continue;          /* spin to _INSTANCE or _ENGINE */";
  z[lc++]="	break; ";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE:";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE_PASSING:";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE_RENDER:";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_REINITIALIZE;";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_ERROR;";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - initializeselect_entrance (default)\\n\\n\");";
  z[lc++]="	break; ";
  z[lc++]="      }";
  z[lc++]="    } while (0);";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***************************************************************/";
  z[lc++]="/* State transition diagram on exit from InitializeSelect:     */";
  z[lc++]="/*                                                             */";
  z[lc++]="/*                                                             */";
  z[lc++]="/*           ABSENT: Return _ERROR.                            */";
  z[lc++]="/*         INSTANCE: Return _ERROR.                            */";
  z[lc++]="/* INSTANCE_PASSING: Return _ERROR.                            */";
  z[lc++]="/*             FLUX: Set ENGINE, return _COMPLETE.             */";
  z[lc++]="/*     FLUX_PASSING: Set ENGINE_PASSING, return _COMPLETE.     */";
  z[lc++]="/*           ENGINE: Return _ERROR.                            */";
  z[lc++]="/*   ENGINE_PASSING: Return _ERROR.                            */";
  z[lc++]="/*    ENGINE_RENDER: Return _ERROR.                            */";
  z[lc++]="/*                                                             */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_initializeselect_exitstate(asysn_audiounit_InstanceState * My)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int ret;";
  z[lc++]="";
  z[lc++]="  do ";
  z[lc++]="    {";
  z[lc++]="      switch(My->istate) {";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ABSENT:";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - initializeselect_exit (absent)\\n\\n\");";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_ERROR;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_INSTANCE:";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_INSTANCE_PASSING:";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - initializeselect_exit (instance*)\\n\\n\");";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_ERROR;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_FLUX:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_FLUX, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_ENGINE, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_COMPLETE;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_FLUX_PASSING:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_FLUX_PASSING, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_ENGINE_PASSING, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_COMPLETE;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE:";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE_PASSING:";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE_RENDER:";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - initializeselect_exit (engine*)\\n\\n\");";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_ERROR;";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - initializeselect_exit (default)\\n\\n\");";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_ERROR;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    } while (0);";
  z[lc++]="  ";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/********************************************************************/";
  z[lc++]="/* State transition diagram on entrance to UninitializeSelect:      */";
  z[lc++]="/*                                                                  */";
  z[lc++]="/*           ABSENT: Return _MY_IS_NULL.                            */";
  z[lc++]="/*         INSTANCE: Return _REUNINITIALIZE.                        */ ";
  z[lc++]="/* INSTANCE_PASSING: Return _REUNINITIALIZE.                        */ ";
  z[lc++]="/*             FLUX: Spin to INSTANCE* or ENGINE*.                  */";
  z[lc++]="/*     FLUX_PASSING: Spin to INSTANCE* or ENGINE*.                  */";
  z[lc++]="/*           ENGINE: Set FLUX, return _UNINITIALIZE                 */";
  z[lc++]="/*   ENGINE_PASSING: Spin to ENGINE.                                */";
  z[lc++]="/*    ENGINE_RENDER: Spin to ENGINE.                                */";
  z[lc++]="/********************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_uninitializeselect_enterstate(asysn_audiounit_InstanceState * My)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int ret;";
  z[lc++]="";
  z[lc++]="  do ";
  z[lc++]="    {";
  z[lc++]="      switch(My->istate) {";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ABSENT:";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_MY_IS_NULL;";
  z[lc++]="	break; ";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_INSTANCE:";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_INSTANCE_PASSING:";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_REUNINITIALIZE;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_FLUX:";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_FLUX_PASSING:";
  z[lc++]="	OSMemoryBarrier();";
  z[lc++]="	continue;          /* spin to _INSTANCE or _ENGINE */";
  z[lc++]="	break; ";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_ENGINE, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_FLUX, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_UNINITIALIZE;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE_PASSING:";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE_RENDER:";
  z[lc++]="	OSMemoryBarrier();";
  z[lc++]="	continue;           /* spin to _ENGINE */";
  z[lc++]="      default:";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_ERROR;";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - uninitializeselect_entrance\\n\\n\");";
  z[lc++]="	break; ";
  z[lc++]="      }";
  z[lc++]="    } while (0);";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/***************************************************************/";
  z[lc++]="/* State transition diagram on exit from UninitializeSelect:   */";
  z[lc++]="/*                                                             */";
  z[lc++]="/*           ABSENT: Return _ERROR.                            */";
  z[lc++]="/*         INSTANCE: Return _ERROR.                            */";
  z[lc++]="/* INSTANCE_PASSING: Return _ERROR.                            */";
  z[lc++]="/*             FLUX: Set INSTANCE, return _COMPLETE.           */";
  z[lc++]="/*     FLUX_PASSING: Set INSTANCE_PASSING, return _COMPLETE.   */";
  z[lc++]="/*           ENGINE: Return _ERROR.                            */";
  z[lc++]="/*   ENGINE_PASSING: Return _ERROR.                            */";
  z[lc++]="/*    ENGINE_RENDER: Return _ERROR.                            */";
  z[lc++]="/*                                                             */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_uninitializeselect_exitstate(asysn_audiounit_InstanceState * My)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int ret;";
  z[lc++]="";
  z[lc++]="  do ";
  z[lc++]="    {";
  z[lc++]="      switch(My->istate) {";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ABSENT:";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - uninitializeselect_exit (absent)\\n\\n\");";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_ERROR;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_INSTANCE:";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_INSTANCE_PASSING:";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - uninitializeselect_exit (instance*)\\n\\n\");";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_ERROR;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_FLUX:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_FLUX, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_INSTANCE, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_COMPLETE;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_FLUX_PASSING:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_FLUX_PASSING, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_INSTANCE_PASSING, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_COMPLETE;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE:";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE_PASSING:";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE_RENDER:";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - uninitializeselect_exit (engine*)\\n\\n\");";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_ERROR;";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - uninitializeselect_exit (default)\\n\\n\");";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_ERROR;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    } while (0);";
  z[lc++]="  ";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*****************************************************************/";
  z[lc++]="/* State transition diagram on entrance to CloseSelect:          */";
  z[lc++]="/*                                                               */";
  z[lc++]="/*           ABSENT: Return _MY_IS_NULL.                         */";
  z[lc++]="/*         INSTANCE: Set ABSENT, return _CLOSE.                  */";
  z[lc++]="/* INSTANCE_PASSING: Spin to INSTANCE                            */";
  z[lc++]="/*             FLUX: Spin to INSTANCE or ENGINE                  */";
  z[lc++]="/*     FLUX_PASSING: Spin to INSTANCE or ENGINE                  */";
  z[lc++]="/*           ENGINE: Set ABSENT, return UNINITIALIZE_AND_CLOSE   */";
  z[lc++]="/*   ENGINE_PASSING: Spin to ENGINE                              */";
  z[lc++]="/*    ENGINE_RENDER: Spin to ENGINE                              */";
  z[lc++]="/*****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_closeselect_enterstate(asysn_audiounit_InstanceState * My)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int ret;";
  z[lc++]="";
  z[lc++]="  do ";
  z[lc++]="    {";
  z[lc++]="      switch(My->istate) {";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ABSENT:";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_MY_IS_NULL;";
  z[lc++]="	break; ";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_INSTANCE:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_INSTANCE, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_ABSENT, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_CLOSE;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_INSTANCE_PASSING:";
  z[lc++]="	OSMemoryBarrier();";
  z[lc++]="	continue;          /* spin to _INSTANCE */";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_FLUX:";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_FLUX_PASSING:";
  z[lc++]="	OSMemoryBarrier();";
  z[lc++]="	continue;          /* spin to _INSTANCE or _ENGINE */";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_ENGINE, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_ABSENT, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_UNINITIALIZE_AND_CLOSE;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE_PASSING:";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE_RENDER:";
  z[lc++]="	OSMemoryBarrier();";
  z[lc++]="	continue;          /* spin to _ENGINE */";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_ERROR;";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - closeselect_enter\\n\\n\");";
  z[lc++]="	break; ";
  z[lc++]="      }";
  z[lc++]="    } while (0);";
  z[lc++]="  ";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/******************************************************************/";
  z[lc++]="/* State transition diagram on entrance to real-time thread:      */";
  z[lc++]="/*                                                                */";
  z[lc++]="/*           ABSENT: Return _MY_IS_NULL (abnormal)                */";
  z[lc++]="/*         INSTANCE: Set INSTANCE_PASSING, return _WIRE           */";
  z[lc++]="/* INSTANCE_PASSING: Set INSTANCE, return _WIRE (abnormal)        */";
  z[lc++]="/*             FLUX: Set FLUX_PASSING, return _WIRE               */";
  z[lc++]="/*     FLUX_PASSING: Set FLUX, return _WIRE (abnormal)            */";
  z[lc++]="/*           ENGINE: Set ENGINE_RENDER, return _RENDER            */";
  z[lc++]="/*   ENGINE_PASSING: Set ENGINE_RENDER, return _RENDER (abnormal) */";
  z[lc++]="/*    ENGINE_RENDER: Return _RENDER (abnormal)                    */";
  z[lc++]="/******************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_realtime_enterstate(asysn_audiounit_InstanceState * My)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int ret;";
  z[lc++]="";
  z[lc++]="  do ";
  z[lc++]="    {";
  z[lc++]="      switch(My->istate) {";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ABSENT:";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_MY_IS_NULL;";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - realtime_entrance (absent)\\n\\n\");";
  z[lc++]="	break; ";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_INSTANCE:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_INSTANCE, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_INSTANCE_PASSING, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_WIRE;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_INSTANCE_PASSING:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_INSTANCE_PASSING, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_INSTANCE, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_WIRE;";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - realtime_entrance (instance_passing)\\n\\n\");";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_FLUX:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_FLUX, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_FLUX_PASSING, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_WIRE;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_FLUX_PASSING:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_FLUX_PASSING, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_FLUX, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_WIRE;";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - realtime_entrance (flux_passing)\\n\\n\");";
  z[lc++]="	break; ";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_ENGINE, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_ENGINE_PASSING, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_RENDER;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE_PASSING:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_ENGINE_PASSING, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_ENGINE, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_RENDER;";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - realtime_entrance (engine_passing)\\n\\n\");";
  z[lc++]="	break; ";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE_RENDER:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_ENGINE_RENDER, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_ENGINE, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_RENDER;";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - realtime_entrance (engine_render)\\n\\n\");";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_ERROR;";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - realtime_entrance (default)\\n\\n\");";
  z[lc++]="	break; ";
  z[lc++]="      }";
  z[lc++]="    } while (0);";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/************************************************************/";
  z[lc++]="/* State transition diagram on exit from real-time thread:  */";
  z[lc++]="/*                                                          */";
  z[lc++]="/*           ABSENT: Return _MY_IS_NULL (abnormal)          */";
  z[lc++]="/*         INSTANCE: Return _COMPLETE (abnormal)            */";
  z[lc++]="/* INSTANCE_PASSING: Set INSTANCE, return _COMPLETE         */";
  z[lc++]="/*             FLUX: Return _COMPLETE (abnormal)            */";
  z[lc++]="/*     FLUX_PASSING: Set FLUX, return _COMPLETE             */";
  z[lc++]="/*           ENGINE: Return _COMPLETE (abnormal)            */";
  z[lc++]="/*   ENGINE_PASSING: Set ENGINE, return _COMPLETE           */";
  z[lc++]="/*    ENGINE_RENDER: Set ENGINE, return _COMPLETE           */";
  z[lc++]="/************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_realtime_exitstate(asysn_audiounit_InstanceState * My)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int ret;";
  z[lc++]="";
  z[lc++]="  do ";
  z[lc++]="    {";
  z[lc++]="      switch(My->istate) {";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ABSENT:";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_MY_IS_NULL;";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - realtime_exit (absent)\\n\\n\");";
  z[lc++]="	break; ";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_INSTANCE:";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_COMPLETE;";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - realtime_exit (instance)\\n\\n\");";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_INSTANCE_PASSING:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_INSTANCE_PASSING, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_INSTANCE, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_COMPLETE;";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_FLUX:";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_COMPLETE;";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - realtime_exit (flux)\\n\\n\");";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_FLUX_PASSING:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_FLUX_PASSING, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_FLUX, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_COMPLETE;";
  z[lc++]="	break; ";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE:";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_COMPLETE;";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - realtime_exit (engine)\\n\\n\");";
  z[lc++]="	break;";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE_PASSING:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_ENGINE_PASSING, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_ENGINE, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_COMPLETE;";
  z[lc++]="	break; ";
  z[lc++]="      case ASYS_AUDIOUNIT_ISTATE_ENGINE_RENDER:";
  z[lc++]="	if (!OSAtomicCompareAndSwap32Barrier";
  z[lc++]="	    (ASYS_AUDIOUNIT_ISTATE_ENGINE_RENDER, ";
  z[lc++]="	     ASYS_AUDIOUNIT_ISTATE_ENGINE, ";
  z[lc++]="	     (int32_t *) &(My->istate)))";
  z[lc++]="	  continue;";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_COMPLETE;";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	ret = ASYS_AUDIOUNIT_IRESPONSE_ERROR;";
  z[lc++]="	ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	  (\"\\tBad transition - realtime_exit (default)\\n\\n\");";
  z[lc++]="	break; ";
  z[lc++]="      }";
  z[lc++]="    } while (0);";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*  The Selector Calls    */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/**************************************/";
  z[lc++]="/*          Selector: Open            */";
  z[lc++]="/*                                    */";
  z[lc++]="/*  params[0]: ComponentInstance ci   */";
  z[lc++]="/*                                    */";
  z[lc++]="/**************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_kComponentOpenSelect(ComponentParameters * p, ";
  z[lc++]="						     asysn_audiounit_InstanceState * My)";
  z[lc++]="{ ";
  z[lc++]="  int socket_flags;";
  z[lc++]="  int i, msize;";
  z[lc++]="";
  z[lc++]="  msize = sizeof(asysn_audiounit_InstanceState);";
  z[lc++]="  if (!(My = (asysn_audiounit_InstanceState *) calloc(1, msize)))";
  z[lc++]="    return asysn_audiounit_instance_cleanup(p, My);";
  z[lc++]="  asysn_audiounit_memstatus(My, msize, MADV_WILLNEED);";
  z[lc++]="";
  z[lc++]="  My->component = (ComponentInstance) (p->params[0]);";
  z[lc++]="  sprintf(My->componentname, \"c%u\", (unsigned int) My->component);";
  z[lc++]="  My->argv[0] = My->componentname;";
  z[lc++]="";
  z[lc++]="  if (asysn_audiounit_initialize_properties(My) != noErr)";
  z[lc++]="    return asysn_audiounit_instance_cleanup(p, My);";
  z[lc++]="";
  z[lc++]="  if (ASYS_AUDIOUNIT_EFFECT)";
  z[lc++]="    {";
  z[lc++]="      msize = (sizeof(UInt32) + sizeof(AudioBuffer)*ASYS_AUDIOUNIT_INPUT_MAXCHANNELS);";
  z[lc++]="";
  z[lc++]="      if (!(My->AudioBufferCarrier = calloc(msize, 1)))";
  z[lc++]="	return asysn_audiounit_instance_cleanup(p, My);";
  z[lc++]="";
  z[lc++]="      if (!(My->AudioBufferTemplate = calloc(msize, 1)))";
  z[lc++]="	return asysn_audiounit_instance_cleanup(p, My);";
  z[lc++]="";
  z[lc++]="      asysn_audiounit_memstatus(My->AudioBufferCarrier, msize, MADV_WILLNEED);";
  z[lc++]="      asysn_audiounit_memstatus(My->AudioBufferTemplate, msize, MADV_WILLNEED);";
  z[lc++]="      ";
  z[lc++]="      My->AudioBufferTemplate->mNumberBuffers = ASYS_AUDIOUNIT_INPUT_CHANNELS;";
  z[lc++]="";
  z[lc++]="      msize = sizeof(Float32)*ASYS_AUDIOUNIT_FRAMES_PER_SLICE;";
  z[lc++]="";
  z[lc++]="      for(i = 0; i < ASYS_AUDIOUNIT_INPUT_MAXCHANNELS; i++)";
  z[lc++]="	{";
  z[lc++]="	  My->AudioBufferTemplate->mBuffers[i].mNumberChannels = 1;";
  z[lc++]="";
  z[lc++]="	  if (!(My->AudioBufferTemplate->mBuffers[i].mData = malloc(msize)))";
  z[lc++]="	    return asysn_audiounit_instance_cleanup(p, My);";
  z[lc++]="";
  z[lc++]="	  asysn_audiounit_memstatus(My->AudioBufferTemplate->mBuffers[i].mData, ";
  z[lc++]="				    msize, MADV_WILLNEED);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  msize = sizeof(Float32)*ASYS_AUDIOUNIT_FRAMES_PER_SLICE;";
  z[lc++]="";
  z[lc++]="  for(i = 0; i < ASYS_AUDIOUNIT_OUTPUT_MAXCHANNELS; i++)";
  z[lc++]="    {";
  z[lc++]="      if (!(My->mData_Output[i] = (Float32 *) malloc(msize)))";
  z[lc++]="	return asysn_audiounit_instance_cleanup(p, My);";
  z[lc++]="      asysn_audiounit_memstatus(My->mData_Output[i], msize, MADV_WILLNEED);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (ASYS_AUDIOUNIT_HAS_AUCONTROL)";
  z[lc++]="    {";
  z[lc++]="      /*~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="      /* set up MIDI socket */";
  z[lc++]="      /*--------------------*/";
  z[lc++]="";
  z[lc++]="      if (socketpair(AF_UNIX, SOCK_DGRAM, 0, My->mpipepair))";
  z[lc++]="	{";
  z[lc++]="	  ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	    (\"\\n\\tIn OpenSelect: Error during MIDI socketpair() call.\\n\");";
  z[lc++]="	  return asysn_audiounit_instance_cleanup(p, My);";
  z[lc++]="	} ";
  z[lc++]="";
  z[lc++]="      if ((socket_flags = fcntl(My->mpipepair[0], F_GETFL, 0)) == -1)";
  z[lc++]="	{";
  z[lc++]="	  ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	    (\"\\n\\tIn OpenSelect: Error during mpipepair[0] F_GETFL fcntl() call.\\n\");";
  z[lc++]="	  return asysn_audiounit_instance_cleanup(p, My);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (fcntl(My->mpipepair[0], F_SETFL, socket_flags | O_NONBLOCK) == -1)";
  z[lc++]="	{";
  z[lc++]="	  ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	    (\"\\n\\tIn OpenSelect: Error during mpipepair[0] F_SETFL fcntl() call.\\n\");";
  z[lc++]="	  return asysn_audiounit_instance_cleanup(p, My);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /*~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="      /* set up SASL socket */";
  z[lc++]="      /*--------------------*/";
  z[lc++]="";
  z[lc++]="      if (socketpair(AF_UNIX, SOCK_DGRAM, 0, My->spipepair))";
  z[lc++]="	{";
  z[lc++]="	  ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	    (\"\\n\\tIn OpenSelect: Error during SASL socketpair() call.\\n\");";
  z[lc++]="	  return asysn_audiounit_instance_cleanup(p, My);";
  z[lc++]="	} ";
  z[lc++]="";
  z[lc++]="      if ((socket_flags = fcntl(My->spipepair[0], F_GETFL, 0)) == -1)";
  z[lc++]="	{";
  z[lc++]="	  ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	    (\"\\n\\tIn OpenSelect: Error during spipepair[0] F_GETFL fcntl() call.\\n\");";
  z[lc++]="	  return asysn_audiounit_instance_cleanup(p, My);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (fcntl(My->spipepair[0], F_SETFL, socket_flags | O_NONBLOCK) == -1)";
  z[lc++]="	{";
  z[lc++]="	  ASYS_AUDIOUNIT_WIRETAP_PUTSTRING";
  z[lc++]="	    (\"\\n\\tIn OpenSelect: Error during spipepair[0] F_SETFL fcntl() call.\\n\");";
  z[lc++]="	  return asysn_audiounit_instance_cleanup(p, My);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /*~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="      /* set up argc and argv */";
  z[lc++]="      /*----------------------*/";
  z[lc++]="";
  z[lc++]="      My->argc = 5;";
  z[lc++]="";
  z[lc++]="      My->argv[1] = My->mpipeflag;";
  z[lc++]="      My->argv[2] = My->mpipevalue;";
  z[lc++]="";
  z[lc++]="      sprintf(My->mpipeflag, \"-asys_audiounit_mpipe\");";
  z[lc++]="      sprintf(My->mpipevalue, \"%i\", My->mpipepair[0]);";
  z[lc++]="";
  z[lc++]="      My->argv[3] = My->spipeflag;";
  z[lc++]="      My->argv[4] = My->spipevalue;";
  z[lc++]="";
  z[lc++]="      sprintf(My->spipeflag, \"-asys_audiounit_spipe\");";
  z[lc++]="      sprintf(My->spipevalue, \"%i\", My->spipepair[0]);";
  z[lc++]="      }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      My->argc = 1;";
  z[lc++]="";
  z[lc++]="      My->argv[1] = My->argv[2] = NULL;";
  z[lc++]="      My->mpipepair[0] = My->mpipepair[1] = 0;";
  z[lc++]="";
  z[lc++]="      My->argv[3] = My->argv[4] = NULL;";
  z[lc++]="      My->spipepair[0] = My->spipepair[1] = 0;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (asysn_audiounit_initialize_parametersystem(My) != noErr)";
  z[lc++]="    return asysn_audiounit_instance_cleanup(p, My);";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&asysn_audiounit_lock_opencount);";
  z[lc++]="";
  z[lc++]="  if (!(asysn_audiounit_opencount++))";
  z[lc++]="    asysn_audiounit_globalvars_memstatus(MADV_WILLNEED);";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&asysn_audiounit_lock_opencount);";
  z[lc++]="";
  z[lc++]="  My->istate = ASYS_AUDIOUNIT_ISTATE_INSTANCE;";
  z[lc++]="";
  z[lc++]="  SetComponentInstanceStorage((ComponentInstance) p->params[0], (Handle) My); ";
  z[lc++]="";
  z[lc++]="  return noErr; ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/**************************************/";
  z[lc++]="/*           Selector: Close          */";
  z[lc++]="/*                                    */";
  z[lc++]="/*  params[0]: ComponentInstance ci   */";
  z[lc++]="/*                                    */";
  z[lc++]="/**************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_kComponentCloseSelect(ComponentParameters * p, ";
  z[lc++]="					    asysn_audiounit_InstanceState * My)";
  z[lc++]="{ ";
  z[lc++]="  ENGINE_PTR_DECLARE_SEMICOLON";
  z[lc++]="  asysn_audiounit_proplisten * remove;";
  z[lc++]="  asysn_audiounit_rendernotify * notify;";
  z[lc++]="  int i, k, msize, ret;";
  z[lc++]="";
  z[lc++]="  ret = asysn_audiounit_closeselect_enterstate(My);";
  z[lc++]="";
  z[lc++]="  SetComponentInstanceStorage((ComponentInstance) p->params[0], (Handle) NULL); ";
  z[lc++]="";
  z[lc++]="  switch (ret) {";
  z[lc++]="  case ASYS_AUDIOUNIT_IRESPONSE_UNINITIALIZE_AND_CLOSE:";
  z[lc++]="    ENGINE_PTR_ASSIGNED_TO  MY_ENGINE_PTR;";
  z[lc++]="    ENGINE_MEMSTATUS_SEMICOLON(MADV_FREE)";
  z[lc++]="    shut_down(ENGINE_PTR);";
  z[lc++]="    MY_ENGINE_PTR_ASSIGNED_TO  NULL;";
  z[lc++]="    break;";
  z[lc++]="  case ASYS_AUDIOUNIT_IRESPONSE_CLOSE:";
  z[lc++]="    break;";
  z[lc++]="  case ASYS_AUDIOUNIT_IRESPONSE_MY_IS_NULL:";
  z[lc++]="  case ASYS_AUDIOUNIT_IRESPONSE_ERROR:";
  z[lc++]="  default:";
  z[lc++]="    return noErr;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  if (ASYS_AUDIOUNIT_HAS_AUCONTROL)";
  z[lc++]="    {";
  z[lc++]="      close(My->mpipepair[0]);";
  z[lc++]="      close(My->mpipepair[1]);";
  z[lc++]="      close(My->spipepair[0]);";
  z[lc++]="      close(My->spipepair[1]);";
  z[lc++]="";
  z[lc++]="      if (My->num_saolparams)";
  z[lc++]="	{";
  z[lc++]="	  free(My->parameterlist);";
  z[lc++]="	  for (i = 0; i < My->num_saolparams; i++)";
  z[lc++]="	    {";
  z[lc++]="	      if (My->parameterinfo[i].cfNameString)";
  z[lc++]="		CFRelease(My->parameterinfo[i].cfNameString);";
  z[lc++]="	      if (My->parameterinfo[i].unitName)";
  z[lc++]="		CFRelease(My->parameterinfo[i].unitName);";
  z[lc++]="	    }";
  z[lc++]="	  free(My->parameterinfo);";
  z[lc++]="";
  z[lc++]="	  for (i = 0; i < My->num_saolparams; i++)";
  z[lc++]="	    if (My->pvs_size[i])";
  z[lc++]="	      {";
  z[lc++]="		for (k = 0; k < My->pvs_size[i]; k++)";
  z[lc++]="		  free(My->pvs_cstr[i][k]);";
  z[lc++]="		free(My->pvs_cstr[i]);";
  z[lc++]="	      }";
  z[lc++]="	  free(My->pvs_size);";
  z[lc++]="	  free(My->pvs_cstr);";
  z[lc++]="";
  z[lc++]="	  msize = My->num_saolparams*sizeof(asysn_audiounit_saolparam);";
  z[lc++]="	  asysn_audiounit_memstatus(My->saolparam, msize, MADV_FREE);";
  z[lc++]="	  free(My->saolparam);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if (My->num_factory)";
  z[lc++]="	{";
  z[lc++]="	  for (i = 0; i < My->num_factory; i++)";
  z[lc++]="	    {";
  z[lc++]="	      if (My->factorypreset_values[i])";
  z[lc++]="		{";
  z[lc++]="		  msize = My->num_saolparams*sizeof(Float32);";
  z[lc++]="		  asysn_audiounit_memstatus(My->factorypreset_values[i], ";
  z[lc++]="					    msize, MADV_FREE);";
  z[lc++]="		  free(My->factorypreset_values[i]);";
  z[lc++]="		}";
  z[lc++]="";
  z[lc++]="	      if (My->factorypreset_info[i].presetName)";
  z[lc++]="		CFRelease(My->factorypreset_info[i].presetName);";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  msize = My->num_factory*sizeof(Float32 *);";
  z[lc++]="	  asysn_audiounit_memstatus(My->factorypreset_values, msize, MADV_FREE);";
  z[lc++]="	  free(My->factorypreset_values);";
  z[lc++]="";
  z[lc++]="	  free(My->factorypreset_info);";
  z[lc++]="	  CFRelease(My->factorypreset_array);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_PresentPreset));";
  z[lc++]="";
  z[lc++]="  CFRelease(My->PresentPreset.presetName);";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_PresentPreset));";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_proplisteners));";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < ASYS_AUDIOUNIT_PROPLISTEN_ARRAYSIZE; i++)";
  z[lc++]="    while (My->proplisteners[i] != NULL)";
  z[lc++]="      {";
  z[lc++]="	remove = My->proplisteners[i];";
  z[lc++]="	My->proplisteners[i] = My->proplisteners[i]->next;";
  z[lc++]="	msize = sizeof(asysn_audiounit_proplisten);";
  z[lc++]="	asysn_audiounit_memstatus(remove, msize, MADV_FREE);";
  z[lc++]="	free(remove);";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_proplisteners));";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_rendernotify));";
  z[lc++]="";
  z[lc++]="  while (My->rendernotify)";
  z[lc++]="    {";
  z[lc++]="      notify = My->rendernotify;";
  z[lc++]="      My->rendernotify = notify->next;";
  z[lc++]="      msize = sizeof(asysn_audiounit_rendernotify);";
  z[lc++]="      asysn_audiounit_memstatus(notify, msize, MADV_FREE);";
  z[lc++]="      free(notify);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_rendernotify));";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  if (ASYS_AUDIOUNIT_EFFECT)";
  z[lc++]="    {";
  z[lc++]="      msize = (sizeof(UInt32) + sizeof(AudioBuffer)*ASYS_AUDIOUNIT_INPUT_MAXCHANNELS);";
  z[lc++]="      asysn_audiounit_memstatus(My->AudioBufferCarrier, msize, MADV_FREE);";
  z[lc++]="      free(My->AudioBufferCarrier);";
  z[lc++]="";
  z[lc++]="      msize = sizeof(Float32)*ASYS_AUDIOUNIT_FRAMES_PER_SLICE;";
  z[lc++]="      for(i = 0; i < ASYS_AUDIOUNIT_INPUT_MAXCHANNELS; i++)";
  z[lc++]="	{";
  z[lc++]="	  asysn_audiounit_memstatus(My->AudioBufferTemplate->mBuffers[i].mData, ";
  z[lc++]="				    msize, MADV_FREE);";
  z[lc++]="	  free(My->AudioBufferTemplate->mBuffers[i].mData);";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      msize = (sizeof(UInt32) + sizeof(AudioBuffer)*ASYS_AUDIOUNIT_INPUT_MAXCHANNELS);";
  z[lc++]="      asysn_audiounit_memstatus(My->AudioBufferTemplate, msize, MADV_FREE);";
  z[lc++]="      free(My->AudioBufferTemplate);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  for(i = 0; i < ASYS_AUDIOUNIT_OUTPUT_MAXCHANNELS; i++)";
  z[lc++]="    {";
  z[lc++]="      msize = sizeof(Float32)*ASYS_AUDIOUNIT_FRAMES_PER_SLICE;";
  z[lc++]="      asysn_audiounit_memstatus(My->mData_Output[i], msize, MADV_FREE);";
  z[lc++]="      free(My->mData_Output[i]);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  msize = sizeof(asysn_audiounit_InstanceState);";
  z[lc++]="  asysn_audiounit_memstatus(My, msize, MADV_FREE);";
  z[lc++]="  free(My);";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&asysn_audiounit_lock_opencount);";
  z[lc++]="";
  z[lc++]="  if (!(--asysn_audiounit_opencount))";
  z[lc++]="    asysn_audiounit_globalvars_memstatus(MADV_FREE);";
  z[lc++]="";
  z[lc++]="  if (asysn_audiounit_opencount < 0)   /* should never be true */";
  z[lc++]="    asysn_audiounit_opencount = 0;";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&asysn_audiounit_lock_opencount);";
  z[lc++]="";
  z[lc++]="  return noErr; ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/************************/";
  z[lc++]="/* Selector: Initialize */";
  z[lc++]="/*                      */";
  z[lc++]="/************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_kAudioUnitInitializeSelect(ComponentParameters * p, ";
  z[lc++]="  					        asysn_audiounit_InstanceState * My)";
  z[lc++]="{ ";
  z[lc++]="  ENGINE_PTR_DECLARE_SEMICOLON";
  z[lc++]="";
  z[lc++]="  switch (asysn_audiounit_initializeselect_enterstate(My)) {";
  z[lc++]="    case ASYS_AUDIOUNIT_IRESPONSE_INITIALIZE:";
  z[lc++]="      break;";
  z[lc++]="    case ASYS_AUDIOUNIT_IRESPONSE_MY_IS_NULL:";
  z[lc++]="    case ASYS_AUDIOUNIT_IRESPONSE_REINITIALIZE:";
  z[lc++]="    default:";
  z[lc++]="      return noErr;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  ENGINE_PTR_ASSIGNED_TO  system_init(My->argc, My->argv, ";
  z[lc++]="				      My->OutputStreamFormat.mSampleRate);";
  z[lc++]="  ";
  z[lc++]="  MY_ENGINE_PTR_ASSIGNED_TO  ENGINE_PTR;";
  z[lc++]="  ";
  z[lc++]="  if (ENGINE_PTR_IS_NULL)";
  z[lc++]="    return kAudioUnitErr_FailedInitialization;";
  z[lc++]="  ";
  z[lc++]="  ENGINE_MEMSTATUS_SEMICOLON(MADV_WILLNEED)";
  z[lc++]="    ";
  z[lc++]="  effects_init(ENGINE_PTR);";
  z[lc++]="  main_initpass(ENGINE_PTR);";
  z[lc++]="  asysn_audiounit_ksyncinit(My);";
  z[lc++]="  ";
  z[lc++]="  EV(kcycleidx) = EV(kbase);";
  z[lc++]="  EV(acycleidx) = EV(ACYCLE) + 1;   /* +1 denotes zero-time condition */";
  z[lc++]="  EV(pass) = IPASS;";
  z[lc++]="  ";
  z[lc++]="  My->acycle = EV(ACYCLE);";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_CPULoad));";
  z[lc++]="";
  z[lc++]="  My->krate = EV(KRATE);";
  z[lc++]="";
  z[lc++]="  My->ksync_normalize = (Float32) (My->krate/AudioGetHostClockFrequency());";
  z[lc++]="  if (My->CPULoad)";
  z[lc++]="    My->ksync_normalize = My->ksync_normalize/My->CPULoad;";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_CPULoad));";
  z[lc++]="";
  z[lc++]="  My->acycleidx_kcycleidx = 1;     /* acycleidx = 0, kcycleidx = 1 */";
  z[lc++]="";
  z[lc++]="  if (ASYS_AUDIOUNIT_HAS_AUCONTROL)";
  z[lc++]="    asysn_audiounit_engine_parameter_update(My);";
  z[lc++]="  ";
  z[lc++]="  asysn_audiounit_initializeselect_exitstate(My);";
  z[lc++]="";
  z[lc++]="  return noErr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/**************************/";
  z[lc++]="/* Selector: Uninitialize */";
  z[lc++]="/*                        */";
  z[lc++]="/**************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_kAudioUnitUninitializeSelect(ComponentParameters * p, ";
  z[lc++]="						   asysn_audiounit_InstanceState * My)";
  z[lc++]="{ ";
  z[lc++]="  int j;";
  z[lc++]="  ENGINE_PTR_DECLARE_SEMICOLON";
  z[lc++]="";
  z[lc++]="  switch (asysn_audiounit_uninitializeselect_enterstate(My)) {";
  z[lc++]="    case ASYS_AUDIOUNIT_IRESPONSE_UNINITIALIZE:";
  z[lc++]="      break;";
  z[lc++]="    case ASYS_AUDIOUNIT_IRESPONSE_MY_IS_NULL:";
  z[lc++]="    case ASYS_AUDIOUNIT_IRESPONSE_REUNINITIALIZE:";
  z[lc++]="    default:";
  z[lc++]="      return noErr;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  ENGINE_PTR_ASSIGNED_TO  MY_ENGINE_PTR;";
  z[lc++]="  ENGINE_MEMSTATUS_SEMICOLON(MADV_FREE)";
  z[lc++]="  shut_down(ENGINE_PTR);";
  z[lc++]="  MY_ENGINE_PTR_ASSIGNED_TO  NULL;";
  z[lc++]="";
  z[lc++]="  My->acycle = ((int)(SAOL_SRATE))/((int)(SAOL_KRATE));";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_CPULoad));";
  z[lc++]="";
  z[lc++]="  My->krate = SAOL_KRATE;";
  z[lc++]="";
  z[lc++]="  My->ksync_normalize = (Float32) (My->krate/AudioGetHostClockFrequency());";
  z[lc++]="  if (My->CPULoad)";
  z[lc++]="    My->ksync_normalize = My->ksync_normalize/My->CPULoad;";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_CPULoad));";
  z[lc++]="";
  z[lc++]="  My->acycleidx_kcycleidx = 1;   /* acycleidx = 0, kcycleidx = 1 */";
  z[lc++]="";
  z[lc++]="  asysn_audiounit_uninitializeselect_exitstate(My);";
  z[lc++]="  asysn_audiounit_engine_emptypipes(My);";
  z[lc++]="";
  z[lc++]="  return noErr; ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/********************************************/";
  z[lc++]="/*        Selector: GetPropertyInfo         */";
  z[lc++]="/*                                          */";
  z[lc++]="/*  params[0]: Boolean * outWritable;       */";
  z[lc++]="/*  params[1]: UInt32 * outDataSize;        */";
  z[lc++]="/*  params[2]: AudioUnitElement inElement;  */";
  z[lc++]="/*  params[3]: AudioUnitScope inScope;      */";
  z[lc++]="/*  params[4]: AudioUnitPropertyID inID;    */";
  z[lc++]="/*                                          */";
  z[lc++]="/********************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_kAudioUnitGetPropertyInfoSelect";
  z[lc++]="(ComponentParameters * p, asysn_audiounit_InstanceState * My)";
  z[lc++]="";
  z[lc++]="{ ";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* return early for invalid properties */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  if (!asysn_audiounit_supported_property((AudioUnitPropertyID)(p->params[4]),";
  z[lc++]="			  (AudioUnitScope)(p->params[3])))";
  z[lc++]="    return kAudioUnitErr_InvalidProperty; ";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* provide datasize if requested by a non-null pointer */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  if (p->params[1])";
  z[lc++]="    *((UInt32 *)(p->params[1])) = asysn_audiounit_property_size(p->params[4], My);";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* provide writable status if requested by a non-null pointer */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  if (p->params[0])";
  z[lc++]="    {";
  z[lc++]="      switch (p->params[4] /* property ID */) {";
  z[lc++]="      case kAudioUnitProperty_ParameterList: /* 3 */";
  z[lc++]="      case kAudioUnitProperty_ParameterInfo: /* 4 */ ";
  z[lc++]="      case kAudioUnitProperty_FastDispatch:  /* 5 */";
  z[lc++]="	*((Boolean *)(p->params[0])) = 0;   ";
  z[lc++]="	break;";
  z[lc++]="      case kAudioUnitProperty_ElementCount: /* 11, also kAudioUnitProperty_BusCount */";
  z[lc++]="	/* for hosts that require AUs to support side-chaining */";
  z[lc++]="	*((Boolean *)(p->params[0])) = (p->params[3] == kAudioUnitScope_Input);   ";
  z[lc++]="	break;";
  z[lc++]="      case kAudioUnitProperty_SupportedNumChannels: /* 13 */";
  z[lc++]="      case kAudioUnitProperty_ParameterValueStrings: /* 16 */";
  z[lc++]="      case kAudioUnitProperty_FactoryPresets: /* 24 */";
  z[lc++]="      case kAudioUnitProperty_CocoaUI: /* 31 */";
  z[lc++]="	*((Boolean *)(p->params[0])) = 0;   ";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	*((Boolean *)(p->params[0])) = 1;   ";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return noErr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/********************************************/";
  z[lc++]="/*         Selector: GetProperty            */";
  z[lc++]="/*                                          */";
  z[lc++]="/*  params[0]: UInt32 * ioDataSize;         */";
  z[lc++]="/*  params[1]: void * outData;              */";
  z[lc++]="/*  params[2]: AudioUnitElement inElement;  */";
  z[lc++]="/*  params[3]: AudioUnitScope inScope;      */";
  z[lc++]="/*  params[4]: AudioUnitPropertyID inID;    */";
  z[lc++]="/*                                          */";
  z[lc++]="/********************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_kAudioUnitGetPropertySelect(ComponentParameters * p, ";
  z[lc++]="					       asysn_audiounit_InstanceState * My)";
  z[lc++]="{ ";
  z[lc++]="  ComponentResult result = noErr;";
  z[lc++]="  CFBundleRef au_bundle = NULL;";
  z[lc++]="  CFURLRef view_bundle_url = NULL;";
  z[lc++]="  UInt32 size;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* return early for invalid properties */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  if (!asysn_audiounit_supported_property((AudioUnitPropertyID)(p->params[4]),";
  z[lc++]="			  (AudioUnitScope)(p->params[3])))";
  z[lc++]="    return kAudioUnitErr_InvalidProperty; ";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* check size of property storage */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  if (*((UInt32 *)(p->params[0])) != ";
  z[lc++]="      (size = asysn_audiounit_property_size(p->params[4], My)))";
  z[lc++]="    if (*((UInt32 *)(p->params[0])) > size)";
  z[lc++]="      *((UInt32 *)(p->params[0])) = size;";
  z[lc++]="    else";
  z[lc++]="      return kAudioUnitErr_InvalidPropertyValue;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* assign property value */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  switch (p->params[4] /* property ID */) {";
  z[lc++]="  case kAudioUnitProperty_ClassInfo: /* 0 */   ";
  z[lc++]="    *((CFPropertyListRef *)((void *)(p->params[1]))) = ";
  z[lc++]="      asysn_audiounit_classinfo_create(My);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_MakeConnection: /* 1 */";
  z[lc++]="    if ((p->params[2] >= ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE) ||";
  z[lc++]="	(p->params[2] < 0))";
  z[lc++]="      {";
  z[lc++]="	result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    OSSpinLockLock(&(My->lock_sampledelivery));";
  z[lc++]="    ((AudioUnitConnection *)((void *)(p->params[1])))->sourceAudioUnit";
  z[lc++]="      = My->MakeConnection[p->params[2]].sourceAudioUnit;";
  z[lc++]="    ((AudioUnitConnection *)((void *)(p->params[1])))->sourceOutputNumber";
  z[lc++]="      = My->MakeConnection[p->params[2]].sourceOutputNumber;";
  z[lc++]="    ((AudioUnitConnection *)((void *)(p->params[1])))->destInputNumber";
  z[lc++]="      = My->MakeConnection[p->params[2]].destInputNumber;";
  z[lc++]="    OSSpinLockUnlock(&(My->lock_sampledelivery));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SampleRate: /* 2 */";
  z[lc++]="    switch (p->params[3] /* inScope */ ) {";
  z[lc++]="    case kAudioUnitScope_Input:";
  z[lc++]="    if (!(ASYS_AUDIOUNIT_EFFECT) || ";
  z[lc++]="	(p->params[2] >= ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE) ||";
  z[lc++]="	(p->params[2] < 0))";
  z[lc++]="      {";
  z[lc++]="	result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    *((Float64 *)((void *)(p->params[1]))) = ";
  z[lc++]="      My->InputStreamFormat[p->params[2]].mSampleRate;";
  z[lc++]="    break;";
  z[lc++]="    case kAudioUnitScope_Global:";
  z[lc++]="    case kAudioUnitScope_Output:";
  z[lc++]="      *((Float64 *)((void *)(p->params[1]))) = My->OutputStreamFormat.mSampleRate;";
  z[lc++]="      break;";
  z[lc++]="    default:";
  z[lc++]="      result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterList: /* 3 */";
  z[lc++]="    memcpy(((AudioUnitParameterID *)((void *)(p->params[1]))), My->parameterlist,";
  z[lc++]="	   sizeof(AudioUnitParameterID)*My->num_saolparams);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterInfo: /* 4 */";
  z[lc++]="    if (p->params[2] < My->num_saolparams)  /* p->param[2] requests ParameterID. */";
  z[lc++]="      {";
  z[lc++]="	if (My->parameterinfo[p->params[2]].cfNameString)";
  z[lc++]="	  CFRetain(My->parameterinfo[p->params[2]].cfNameString);";
  z[lc++]="	if (My->parameterinfo[p->params[2]].unitName)";
  z[lc++]="	  CFRetain(My->parameterinfo[p->params[2]].unitName);";
  z[lc++]="	memcpy(((AudioUnitParameterInfo *)((void *)(p->params[1]))), ";
  z[lc++]="	       &(My->parameterinfo[p->params[2]]), sizeof(AudioUnitParameterInfo));";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_FastDispatch:  /* 5 */";
  z[lc++]="    switch (p->params[2] /* inElement */ )  {";
  z[lc++]="    case kAudioUnitRenderSelect:";
  z[lc++]="      *((AudioUnitRenderProc *)(p->params[1])) = asysn_audiounit_MyRenderer;";
  z[lc++]="      break;";
  z[lc++]="    case kMusicDeviceMIDIEventSelect:";
  z[lc++]="      if (ASYS_AUDIOUNIT_MIDISUPPORT)";
  z[lc++]="	*((MusicDeviceMIDIEventProc *)(p->params[1])) = asysn_audiounit_MyMIDIEventProc;";
  z[lc++]="      else";
  z[lc++]="	result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="      break;";
  z[lc++]="    case kAudioUnitGetParameterSelect:";
  z[lc++]="      *((AudioUnitGetParameterProc *)(p->params[1])) = ";
  z[lc++]="	asysn_audiounit_MyGetParameterProc;";
  z[lc++]="      break;";
  z[lc++]="    case kAudioUnitSetParameterSelect:";
  z[lc++]="      *((AudioUnitSetParameterProc *)(p->params[1])) = ";
  z[lc++]="	asysn_audiounit_MySetParameterProc;";
  z[lc++]="      break;";
  z[lc++]="    default:";
  z[lc++]="      result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_CPULoad: /* 6 */ ";
  z[lc++]="    *((Float32 *)((void *)(p->params[1]))) = My->CPULoad;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_StreamFormat: /* 8 */ ";
  z[lc++]="    switch (p->params[3] /* inScope */ ) {";
  z[lc++]="    case kAudioUnitScope_Input:";
  z[lc++]="    if (!(ASYS_AUDIOUNIT_EFFECT) || ";
  z[lc++]="	(p->params[2] >= ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE) ||";
  z[lc++]="	(p->params[2] < 0))";
  z[lc++]="      {";
  z[lc++]="	result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mChannelsPerFrame";
  z[lc++]="      = My->InputStreamFormat[p->params[2]].mChannelsPerFrame;";
  z[lc++]="    ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mSampleRate";
  z[lc++]="      = My->InputStreamFormat[p->params[2]].mSampleRate;";
  z[lc++]="    ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mFormatID";
  z[lc++]="      = My->InputStreamFormat[p->params[2]].mFormatID;";
  z[lc++]="    ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mFormatFlags";
  z[lc++]="      = My->InputStreamFormat[p->params[2]].mFormatFlags;";
  z[lc++]="    ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mBytesPerPacket";
  z[lc++]="      = My->InputStreamFormat[p->params[2]].mBytesPerPacket;";
  z[lc++]="    ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mBytesPerFrame";
  z[lc++]="      = My->InputStreamFormat[p->params[2]].mBytesPerFrame;";
  z[lc++]="    ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mFramesPerPacket";
  z[lc++]="      = My->InputStreamFormat[p->params[2]].mFramesPerPacket;";
  z[lc++]="    ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mBitsPerChannel";
  z[lc++]="      = My->InputStreamFormat[p->params[2]].mBitsPerChannel;";
  z[lc++]="    ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mReserved";
  z[lc++]="      = My->InputStreamFormat[p->params[2]].mReserved;";
  z[lc++]="      break;";
  z[lc++]="    case kAudioUnitScope_Global:";
  z[lc++]="    case kAudioUnitScope_Output:";
  z[lc++]="      ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mChannelsPerFrame";
  z[lc++]="	= My->OutputStreamFormat.mChannelsPerFrame;";
  z[lc++]="      ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mSampleRate";
  z[lc++]="	= My->OutputStreamFormat.mSampleRate;";
  z[lc++]="      ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mFormatID";
  z[lc++]="	= My->OutputStreamFormat.mFormatID;";
  z[lc++]="      ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mFormatFlags";
  z[lc++]="	= My->OutputStreamFormat.mFormatFlags;";
  z[lc++]="      ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mBytesPerPacket";
  z[lc++]="	= My->OutputStreamFormat.mBytesPerPacket;";
  z[lc++]="      ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mBytesPerFrame";
  z[lc++]="	= My->OutputStreamFormat.mBytesPerFrame;";
  z[lc++]="      ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mFramesPerPacket";
  z[lc++]="	= My->OutputStreamFormat.mFramesPerPacket;";
  z[lc++]="      ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mBitsPerChannel";
  z[lc++]="	= My->OutputStreamFormat.mBitsPerChannel;";
  z[lc++]="      ((AudioStreamBasicDescription *)((void *)(p->params[1])))->mReserved";
  z[lc++]="	= My->OutputStreamFormat.mReserved;";
  z[lc++]="      break;";
  z[lc++]="    default:";
  z[lc++]="      result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SRCAlgorithm: /* 9 */";
  z[lc++]="    *((OSType *)((void *)(p->params[1]))) = My->SRCAlgorithm;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ElementCount: /* 11, also kAudioUnitProperty_BusCount */";
  z[lc++]="    switch (p->params[3] /* inScope */ ) {";
  z[lc++]="    case kAudioUnitScope_Input:";
  z[lc++]="      *((UInt32 *)((void *)(p->params[1]))) = My->InputElementCount;";
  z[lc++]="      break;";
  z[lc++]="    case kAudioUnitScope_Global:";
  z[lc++]="    case kAudioUnitScope_Output:";
  z[lc++]="      *((UInt32 *)((void *)(p->params[1]))) = My->OutputElementCount;";
  z[lc++]="      break;";
  z[lc++]="    case kAudioUnitScope_Part:";
  z[lc++]="    case kAudioUnitScope_Group:";
  z[lc++]="      *((UInt32 *)((void *)(p->params[1]))) = 0;";
  z[lc++]="      break;";
  z[lc++]="    default:";
  z[lc++]="      result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_Latency: /* 12 */";
  z[lc++]="    *((Float64 *)((void *)(p->params[1]))) = My->Latency;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SupportedNumChannels: /* 13 */";
  z[lc++]="    memcpy(((AudioUnitParameterID *)((void *)(p->params[1]))), My->SupportedNumChannels,";
  z[lc++]="	   ASYS_AUDIOUNIT_SUPPORTED_FORMATS*sizeof(AUChannelInfo));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_MaximumFramesPerSlice: /* 14 */";
  z[lc++]="    *((UInt32 *)((void *)(p->params[1]))) = My->MaximumFramesPerSlice;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterValueStrings: /* 16 */";
  z[lc++]="    if ((*((CFMutableArrayRef *)((void *)(p->params[1]))) = ";
  z[lc++]="	 asysn_audiounit_parametervaluestrings_create(My, p->params[2])) == NULL)";
  z[lc++]="      result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_TailTime: /* 20 */";
  z[lc++]="    *((Float64 *)((void *)(p->params[1]))) = My->TailTime;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_BypassEffect: /* 21 */";
  z[lc++]="    *((UInt32 *)((void *)(p->params[1]))) = My->BypassEffect;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_LastRenderError: /* 22 */";
  z[lc++]="    *((OSStatus *)((void *)(p->params[1]))) = My->LastRenderError;";
  z[lc++]="    My->LastRenderError = noErr;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SetRenderCallback:  /* 23 */";
  z[lc++]="    if ((p->params[2] >= ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE) ||";
  z[lc++]="	(p->params[2] < 0))";
  z[lc++]="      {";
  z[lc++]="	result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    OSSpinLockLock(&(My->lock_sampledelivery));";
  z[lc++]="    ((AURenderCallbackStruct *)((void *)(p->params[1])))->inputProc";
  z[lc++]="      = My->SetRenderCallback[p->params[2]].inputProc;";
  z[lc++]="    ((AURenderCallbackStruct *)((void *)(p->params[1])))->inputProcRefCon";
  z[lc++]="      = My->SetRenderCallback[p->params[2]].inputProcRefCon;";
  z[lc++]="    OSSpinLockUnlock(&(My->lock_sampledelivery));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_FactoryPresets: /* 24 */";
  z[lc++]="    if (My->num_factory)";
  z[lc++]="      {";
  z[lc++]="	CFRetain(My->factorypreset_array);";
  z[lc++]="	*((CFPropertyListRef *)((void *)(p->params[1]))) = My->factorypreset_array;";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_RenderQuality: /* 26 */";
  z[lc++]="    *((UInt32 *)((void *)(p->params[1]))) = My->RenderQuality;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_InPlaceProcessing: /* 29 */";
  z[lc++]="    *((UInt32 *)((void *)(p->params[1]))) = My->InPlaceProcessing;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_CocoaUI: /* 31 */";
  z[lc++]="#if defined(ASYS_AUDIOUNIT_VIEW_BUNDLECF)";
  z[lc++]="";
  z[lc++]="    if ((au_bundle = CFBundleGetBundleWithIdentifier(ASYS_AUDIOUNIT_AU_BUNDLECF)))";
  z[lc++]="      CFRetain(au_bundle);";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="    view_bundle_url = CFBundleCopyResourceURL(au_bundle,";
  z[lc++]="					      ASYS_AUDIOUNIT_VIEW_BUNDLECF,";
  z[lc++]="					      CFSTR(\"bundle\"), NULL);";
  z[lc++]="    CFRelease(au_bundle);";
  z[lc++]="";
  z[lc++]="    if (!view_bundle_url)";
  z[lc++]="      {";
  z[lc++]="	result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="    ((AudioUnitCocoaViewInfo *)(p->params[1]))->mCocoaAUViewBundleLocation =";
  z[lc++]="      view_bundle_url;";
  z[lc++]="";
  z[lc++]="    ((AudioUnitCocoaViewInfo *)(p->params[1]))->mCocoaAUViewClass[0] =";
  z[lc++]="      CFStringCreateCopy(NULL, ASYS_AUDIOUNIT_VIEW_BASECLASSCF);";
  z[lc++]="#else";
  z[lc++]="    result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="#endif";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_PresentPreset: /* 36 */";
  z[lc++]="    OSSpinLockLock(&(My->lock_PresentPreset));";
  z[lc++]="    ((AUPreset *)(p->params[1]))->presetNumber = My->PresentPreset.presetNumber;";
  z[lc++]="    ((AUPreset *)(p->params[1]))->presetName = My->PresentPreset.presetName;";
  z[lc++]="    CFRetain(My->PresentPreset.presetName);";
  z[lc++]="    OSSpinLockUnlock(&(My->lock_PresentPreset));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_OfflineRender: /* 37 */";
  z[lc++]="    *((UInt32 *)((void *)(p->params[1]))) = My->OfflineRender;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_PresentationLatency: /* 40 */";
  z[lc++]="    *((Float64 *)((void *)(p->params[1]))) = My->PresentationLatency;";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_InstrumentCount: /* 1000 */";
  z[lc++]="    if (ASYS_AUDIOUNIT_MUSICDEVICE)";
  z[lc++]="      *((UInt32 *)((void *)(p->params[1]))) = My->InstrumentCount;";
  z[lc++]="    else";
  z[lc++]="      result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_StreamFromDisk: /* 1011 */";
  z[lc++]="    *((UInt32 *)((void *)(p->params[1]))) = My->StreamFromDisk;";
  z[lc++]="    break;";
  z[lc++]="  default:  /* should never happen */";
  z[lc++]="    result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  return result;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/********************************************/";
  z[lc++]="/*         Selector: SetProperty            */";
  z[lc++]="/*                                          */";
  z[lc++]="/*  params[0]: UInt32 inDataSize;           */";
  z[lc++]="/*  params[1]: const void * inData;         */";
  z[lc++]="/*  params[2]: AudioUnitElement inElement;  */";
  z[lc++]="/*  params[3]: AudioUnitScope inScope;      */";
  z[lc++]="/*  params[4]: AudioUnitPropertyID inID;    */";
  z[lc++]="/*                                          */";
  z[lc++]="/********************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_kAudioUnitSetPropertySelect(ComponentParameters * p, ";
  z[lc++]="					       asysn_audiounit_InstanceState * My)";
  z[lc++]="{ ";
  z[lc++]="  ComponentResult result = noErr; ";
  z[lc++]="  CFStringRef key;";
  z[lc++]="";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="  /* return early for invalid properties */";
  z[lc++]="  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="  if (!asysn_audiounit_supported_property((AudioUnitPropertyID)(p->params[4]),";
  z[lc++]="			  (AudioUnitScope)(p->params[3])))";
  z[lc++]="    return kAudioUnitErr_InvalidProperty; ";
  z[lc++]="";
  z[lc++]="  switch (p->params[4] /* property ID */) {";
  z[lc++]="  case kAudioUnitProperty_ClassInfo: /* 0 */  ";
  z[lc++]="    asysn_audiounit_classinfo_read(";
  z[lc++]="                        My, *((CFMutableDictionaryRef *)((void *)(p->params[1])))); ";
  z[lc++]="    asysn_audiounit_proplisteners_update(My, kAudioUnitProperty_PresentPreset,";
  z[lc++]="					 kAudioUnitScope_Global, (AudioUnitElement) 0);";
  z[lc++]="    asysn_audiounit_proplisteners_update(My, kAudioUnitProperty_RenderQuality,";
  z[lc++]="					 kAudioUnitScope_Global, (AudioUnitElement) 0);";
  z[lc++]="    asysn_audiounit_proplisteners_update(My, kAudioUnitProperty_CPULoad,";
  z[lc++]="					 kAudioUnitScope_Global, (AudioUnitElement) 0);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_MakeConnection: /* 1 */";
  z[lc++]="    if ((p->params[2] >= ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE) ||";
  z[lc++]="	(p->params[2] < 0))";
  z[lc++]="      {";
  z[lc++]="	result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    OSSpinLockLock(&(My->lock_sampledelivery));";
  z[lc++]="    My->MakeConnection[p->params[2]].sourceAudioUnit = ";
  z[lc++]="      ((AudioUnitConnection *)((void *)(p->params[1])))->sourceAudioUnit;";
  z[lc++]="    My->MakeConnection[p->params[2]].sourceOutputNumber = ";
  z[lc++]="      ((AudioUnitConnection *)((void *)(p->params[1])))->sourceOutputNumber;";
  z[lc++]="    My->MakeConnection[p->params[2]].destInputNumber = ";
  z[lc++]="      ((AudioUnitConnection *)((void *)(p->params[1])))->destInputNumber;";
  z[lc++]="    OSSpinLockUnlock(&(My->lock_sampledelivery));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SampleRate: /* 2 */";
  z[lc++]="    switch (p->params[3] /* inScope */ ) {";
  z[lc++]="    case kAudioUnitScope_Input:";
  z[lc++]="      if (!(ASYS_AUDIOUNIT_EFFECT) || ";
  z[lc++]="	  (p->params[2] >= ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE) ||";
  z[lc++]="	  (p->params[2] < 0))";
  z[lc++]="	{";
  z[lc++]="	  result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="	My->InputStreamFormat[p->params[2]].mSampleRate = ";
  z[lc++]="	  *((Float64 *)((void *)(p->params[1]))); ";
  z[lc++]="      break;";
  z[lc++]="    case kAudioUnitScope_Output:";
  z[lc++]="      My->OutputStreamFormat.mSampleRate = *((Float64 *)((void *)(p->params[1])));";
  z[lc++]="      break;";
  z[lc++]="    case kAudioUnitScope_Global:";
  z[lc++]="      if ((ASYS_AUDIOUNIT_EFFECT) && ";
  z[lc++]="	  (p->params[2] < ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE) ||";
  z[lc++]="	  (p->params[2] >= 0))";
  z[lc++]="	My->InputStreamFormat[p->params[2]].mSampleRate =";
  z[lc++]="	  *((Float64 *)((void *)(p->params[1]))); ";
  z[lc++]="      My->OutputStreamFormat.mSampleRate = *((Float64 *)((void *)(p->params[1])));";
  z[lc++]="      break;";
  z[lc++]="    default:";
  z[lc++]="      result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterList: /* 3 */";
  z[lc++]="    result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="    break;    /* hosts not permitted to change Parameter List */";
  z[lc++]="  case kAudioUnitProperty_ParameterInfo: /* 4 */ ";
  z[lc++]="    result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="    break;    /* hosts not permitted to change Parameter Info */";
  z[lc++]="  case kAudioUnitProperty_FastDispatch:  /* 5 */";
  z[lc++]="    result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="    break;    /* hosts not permitted to set the dispatch routines */";
  z[lc++]="  case kAudioUnitProperty_CPULoad: /* 6 */";
  z[lc++]="";
  z[lc++]="    OSSpinLockLock(&(My->lock_CPULoad));";
  z[lc++]="";
  z[lc++]="    My->CPULoad = *((Float32 *)((void *)(p->params[1])));";
  z[lc++]="    My->ksync_normalize = (Float32) (My->krate/AudioGetHostClockFrequency());";
  z[lc++]="    if (My->CPULoad)";
  z[lc++]="      My->ksync_normalize = My->ksync_normalize/My->CPULoad;";
  z[lc++]="";
  z[lc++]="    OSSpinLockUnlock(&(My->lock_CPULoad));";
  z[lc++]="";
  z[lc++]="    asysn_audiounit_proplisteners_update(My, kAudioUnitProperty_CPULoad,";
  z[lc++]="					 kAudioUnitScope_Global, (AudioUnitElement) 0);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_StreamFormat: /* 8 */ ";
  z[lc++]="";
  z[lc++]="    /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="    /* reject non-native endian-ness */";
  z[lc++]="    /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="    ";
  z[lc++]="    if (ASYS_AUDIOUNIT_FLOAT32_BIGENDIAN != ";
  z[lc++]="	(((((AudioStreamBasicDescription *)((void *)(p->params[1])))->mFormatFlags)";
  z[lc++]="	  & kAudioFormatFlagIsBigEndian) != 0))";
  z[lc++]="      {";
  z[lc++]="	result = kAudioUnitErr_InvalidPropertyValue; ";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="    switch (p->params[3] /* inScope */ ) {";
  z[lc++]="    case kAudioUnitScope_Input:";
  z[lc++]="";
  z[lc++]="      if (!(ASYS_AUDIOUNIT_EFFECT) || ";
  z[lc++]="	  (p->params[2] >= ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE) ||";
  z[lc++]="	  (p->params[2] < 0))";
  z[lc++]="	{";
  z[lc++]="	  result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="      /* if the AU uses an input, accept if it doesn't exceed channel limit */";
  z[lc++]="      /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="      if (((AudioStreamBasicDescription *)";
  z[lc++]="	   ((void *)(p->params[1])))->mChannelsPerFrame &&";
  z[lc++]="	  (((AudioStreamBasicDescription *)";
  z[lc++]="	    ((void *)(p->params[1])))->mChannelsPerFrame";
  z[lc++]="	   <= ASYS_AUDIOUNIT_INPUT_MAXCHANNELS))";
  z[lc++]="	{";
  z[lc++]="	  if (p->params[2] == 0)";
  z[lc++]="	    My->AudioBufferTemplate->mNumberBuffers = ";
  z[lc++]="	      ((AudioStreamBasicDescription *)";
  z[lc++]="	       ((void *)(p->params[1])))->mChannelsPerFrame;";
  z[lc++]="	  ";
  z[lc++]="	  My->InputStreamFormat[p->params[2]].mChannelsPerFrame = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mChannelsPerFrame;";
  z[lc++]="	  My->InputStreamFormat[p->params[2]].mSampleRate = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mSampleRate;";
  z[lc++]="	  My->InputStreamFormat[p->params[2]].mFormatID = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mFormatID;";
  z[lc++]="	  My->InputStreamFormat[p->params[2]].mFormatFlags = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mFormatFlags;";
  z[lc++]="	  My->InputStreamFormat[p->params[2]].mBytesPerPacket = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mBytesPerPacket;";
  z[lc++]="	  My->InputStreamFormat[p->params[2]].mBytesPerFrame = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mBytesPerFrame;";
  z[lc++]="	  My->InputStreamFormat[p->params[2]].mFramesPerPacket = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mFramesPerPacket;";
  z[lc++]="	  My->InputStreamFormat[p->params[2]].mBitsPerChannel = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mBitsPerChannel;";
  z[lc++]="	  My->InputStreamFormat[p->params[2]].mReserved = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mReserved;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="      break;";
  z[lc++]="    case kAudioUnitScope_Output:";
  z[lc++]="";
  z[lc++]="      /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="      /* if number of output channels meet our limits, accept */";
  z[lc++]="      /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="      if (((AudioStreamBasicDescription *)((void *)(p->params[1])))->mChannelsPerFrame  ";
  z[lc++]="	  && ";
  z[lc++]="	  (((AudioStreamBasicDescription *)((void *)(p->params[1])))->mChannelsPerFrame ";
  z[lc++]="	   <= ASYS_AUDIOUNIT_OUTPUT_MAXCHANNELS))";
  z[lc++]="	{";
  z[lc++]="	  My->OutputStreamFormat.mChannelsPerFrame = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mChannelsPerFrame;";
  z[lc++]="	  My->OutputStreamFormat.mSampleRate = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mSampleRate;";
  z[lc++]="	  My->OutputStreamFormat.mFormatID = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mFormatID;";
  z[lc++]="	  My->OutputStreamFormat.mFormatFlags = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mFormatFlags;";
  z[lc++]="	  My->OutputStreamFormat.mBytesPerPacket = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mBytesPerPacket;";
  z[lc++]="	  My->OutputStreamFormat.mBytesPerFrame = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mBytesPerFrame;";
  z[lc++]="	  My->OutputStreamFormat.mFramesPerPacket = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mFramesPerPacket;";
  z[lc++]="	  My->OutputStreamFormat.mBitsPerChannel = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mBitsPerChannel;";
  z[lc++]="	  My->OutputStreamFormat.mReserved = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mReserved;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	result = kAudioUnitErr_InvalidPropertyValue; ";
  z[lc++]="      break;";
  z[lc++]="    case kAudioUnitScope_Global:";
  z[lc++]="";
  z[lc++]="      /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="      /* if number of output channels meet our limits, accept */";
  z[lc++]="      /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="      if (((AudioStreamBasicDescription *)((void *)(p->params[1])))->mChannelsPerFrame  ";
  z[lc++]="	  && ";
  z[lc++]="	  (((AudioStreamBasicDescription *)((void *)(p->params[1])))->mChannelsPerFrame ";
  z[lc++]="	   <= ASYS_AUDIOUNIT_OUTPUT_MAXCHANNELS))";
  z[lc++]="	{";
  z[lc++]="	  My->OutputStreamFormat.mChannelsPerFrame = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mChannelsPerFrame;";
  z[lc++]="	  My->OutputStreamFormat.mSampleRate = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mSampleRate;";
  z[lc++]="	  My->OutputStreamFormat.mFormatID = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mFormatID;";
  z[lc++]="	  My->OutputStreamFormat.mFormatFlags = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mFormatFlags;";
  z[lc++]="	  My->OutputStreamFormat.mBytesPerPacket = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mBytesPerPacket;";
  z[lc++]="	  My->OutputStreamFormat.mBytesPerFrame = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mBytesPerFrame;";
  z[lc++]="	  My->OutputStreamFormat.mFramesPerPacket = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mFramesPerPacket;";
  z[lc++]="	  My->OutputStreamFormat.mBitsPerChannel = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mBitsPerChannel;";
  z[lc++]="	  My->OutputStreamFormat.mReserved = ";
  z[lc++]="	    ((AudioStreamBasicDescription *)";
  z[lc++]="	     ((void *)(p->params[1])))->mReserved;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  result = kAudioUnitErr_InvalidPropertyValue; ";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      if ((ASYS_AUDIOUNIT_EFFECT) && ";
  z[lc++]="	  (p->params[2] < ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE) ||";
  z[lc++]="	  (p->params[2] >= 0))";
  z[lc++]="	{";
  z[lc++]="";
  z[lc++]="	  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="	  /* if the AU uses an input, accept if it doesn't exceed channel limit */";
  z[lc++]="	  /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="	  ";
  z[lc++]="	  if (((AudioStreamBasicDescription *)";
  z[lc++]="	       ((void *)(p->params[1])))->mChannelsPerFrame &&";
  z[lc++]="	      (((AudioStreamBasicDescription *)";
  z[lc++]="		((void *)(p->params[1])))->mChannelsPerFrame";
  z[lc++]="	       <= ASYS_AUDIOUNIT_INPUT_MAXCHANNELS)) ";
  z[lc++]="	    {";
  z[lc++]="	      if (p->params[2] == 0)";
  z[lc++]="		My->AudioBufferTemplate->mNumberBuffers = ";
  z[lc++]="		  ((AudioStreamBasicDescription *)";
  z[lc++]="		   ((void *)(p->params[1])))->mChannelsPerFrame;";
  z[lc++]="	      ";
  z[lc++]="	      My->InputStreamFormat[p->params[2]].mChannelsPerFrame = ";
  z[lc++]="		((AudioStreamBasicDescription *)";
  z[lc++]="		 ((void *)(p->params[1])))->mChannelsPerFrame;";
  z[lc++]="	      My->InputStreamFormat[p->params[2]].mSampleRate = ";
  z[lc++]="		((AudioStreamBasicDescription *)";
  z[lc++]="		 ((void *)(p->params[1])))->mSampleRate;";
  z[lc++]="	      My->InputStreamFormat[p->params[2]].mFormatID = ";
  z[lc++]="		((AudioStreamBasicDescription *)";
  z[lc++]="		 ((void *)(p->params[1])))->mFormatID;";
  z[lc++]="	      My->InputStreamFormat[p->params[2]].mFormatFlags = ";
  z[lc++]="		((AudioStreamBasicDescription *)";
  z[lc++]="		 ((void *)(p->params[1])))->mFormatFlags;";
  z[lc++]="	      My->InputStreamFormat[p->params[2]].mBytesPerPacket = ";
  z[lc++]="		((AudioStreamBasicDescription *)";
  z[lc++]="		 ((void *)(p->params[1])))->mBytesPerPacket;";
  z[lc++]="	      My->InputStreamFormat[p->params[2]].mBytesPerFrame = ";
  z[lc++]="		((AudioStreamBasicDescription *)";
  z[lc++]="		 ((void *)(p->params[1])))->mBytesPerFrame;";
  z[lc++]="	      My->InputStreamFormat[p->params[2]].mFramesPerPacket = ";
  z[lc++]="		((AudioStreamBasicDescription *)";
  z[lc++]="		 ((void *)(p->params[1])))->mFramesPerPacket;";
  z[lc++]="	      My->InputStreamFormat[p->params[2]].mBitsPerChannel = ";
  z[lc++]="		((AudioStreamBasicDescription *)";
  z[lc++]="		 ((void *)(p->params[1])))->mBitsPerChannel;";
  z[lc++]="	      My->InputStreamFormat[p->params[2]].mReserved = ";
  z[lc++]="		((AudioStreamBasicDescription *)";
  z[lc++]="		 ((void *)(p->params[1])))->mReserved;";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="	}";
  z[lc++]="      break;";
  z[lc++]="    default:";
  z[lc++]="      result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SRCAlgorithm: /* 9 */";
  z[lc++]="    My->SRCAlgorithm = *((OSType *)((void *)(p->params[1])));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ElementCount: /* 11, also kAudioUnitProperty_BusCount */";
  z[lc++]="    switch (p->params[3] /* inScope */ ) {";
  z[lc++]="    case kAudioUnitScope_Input:";
  z[lc++]="      if (*((UInt32 *)((void *)(p->params[1]))) <= ASYS_AUDIOUNIT_ELEMENT_INPUTMAX)";
  z[lc++]="	My->InputElementCount = *((UInt32 *)((void *)(p->params[1])));";
  z[lc++]="      else";
  z[lc++]="	result = kAudioUnitErr_InvalidPropertyValue; ";
  z[lc++]="      break;";
  z[lc++]="    case kAudioUnitScope_Output:";
  z[lc++]="      if (*((UInt32 *)((void *)(p->params[1]))) <= ASYS_AUDIOUNIT_ELEMENT_OUTPUTMAX)";
  z[lc++]="	My->OutputElementCount = *((UInt32 *)((void *)(p->params[1])));";
  z[lc++]="      else";
  z[lc++]="	result = kAudioUnitErr_InvalidPropertyValue; ";
  z[lc++]="      break;";
  z[lc++]="    case kAudioUnitScope_Global:";
  z[lc++]="      if (*((UInt32 *)((void *)(p->params[1]))) <= ASYS_AUDIOUNIT_ELEMENT_OUTPUTMAX)";
  z[lc++]="	My->OutputElementCount = *((UInt32 *)((void *)(p->params[1])));";
  z[lc++]="      else";
  z[lc++]="	result = kAudioUnitErr_InvalidPropertyValue; ";
  z[lc++]="      if (ASYS_AUDIOUNIT_EFFECT)";
  z[lc++]="	{";
  z[lc++]="	  if (*((UInt32 *)((void *)(p->params[1]))) <= ASYS_AUDIOUNIT_ELEMENT_INPUTMAX)";
  z[lc++]="	    My->InputElementCount = *((UInt32 *)((void *)(p->params[1])));";
  z[lc++]="	  else";
  z[lc++]="	    result = kAudioUnitErr_InvalidPropertyValue;";
  z[lc++]="	}";
  z[lc++]="      break;";
  z[lc++]="    case kAudioUnitScope_Part:";
  z[lc++]="    case kAudioUnitScope_Group:";
  z[lc++]="      break;";
  z[lc++]="    default:";
  z[lc++]="      result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_Latency: /* 12 */";
  z[lc++]="    My->Latency = *((Float64 *)((void *)(p->params[1])));";
  z[lc++]="    asysn_audiounit_proplisteners_update(My, kAudioUnitProperty_Latency,";
  z[lc++]="					 kAudioUnitScope_Global, (AudioUnitElement) 0);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SupportedNumChannels: /* 13 */";
  z[lc++]="    result = kAudioUnitErr_InvalidPropertyValue;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_MaximumFramesPerSlice: /* 14 */";
  z[lc++]="    if (*((UInt32 *)((void *)(p->params[1]))) > ASYS_AUDIOUNIT_FRAMES_PER_SLICE)";
  z[lc++]="      result = kAudioUnitErr_InvalidPropertyValue;";
  z[lc++]="    else";
  z[lc++]="      My->MaximumFramesPerSlice = *((UInt32 *)((void *)(p->params[1])));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterValueStrings: /* 16 */";
  z[lc++]="    result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="    break;    /* hosts not permitted to set ParameterValueStrings */";
  z[lc++]="  case kAudioUnitProperty_TailTime: /* 20 */";
  z[lc++]="    My->TailTime = *((Float64 *)((void *)(p->params[1])));";
  z[lc++]="    asysn_audiounit_proplisteners_update(My, kAudioUnitProperty_TailTime,";
  z[lc++]="					 kAudioUnitScope_Global, (AudioUnitElement) 0);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_BypassEffect: /* 21 */";
  z[lc++]="    My->BypassEffect = *((UInt32 *)((void *)(p->params[1])));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_LastRenderError: /* 22 */";
  z[lc++]="    My->LastRenderError = *((OSStatus *)((void *)(p->params[1])));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SetRenderCallback:  /* 23 */";
  z[lc++]="    if ((p->params[2] >= ASYS_AUDIOUNIT_ELEMENT_ARRAYSIZE) ||";
  z[lc++]="	(p->params[2] < 0))";
  z[lc++]="      {";
  z[lc++]="	result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    OSSpinLockLock(&(My->lock_sampledelivery));";
  z[lc++]="    memcpy(&(My->SetRenderCallback[p->params[2]]), ";
  z[lc++]="	   (AURenderCallbackStruct *)(p->params[1]),";
  z[lc++]="	   sizeof(AURenderCallbackStruct));";
  z[lc++]="    OSSpinLockUnlock(&(My->lock_sampledelivery));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_FactoryPresets: /* 24 */";
  z[lc++]="    result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="    break;    /* hosts not permitted to change Factory Presets */";
  z[lc++]="  case kAudioUnitProperty_RenderQuality: /* 26 */";
  z[lc++]="    My->RenderQuality = *((UInt32 *)((void *)(p->params[1])));";
  z[lc++]="    asysn_audiounit_proplisteners_update(My, kAudioUnitProperty_RenderQuality,";
  z[lc++]="					 kAudioUnitScope_Global, (AudioUnitElement) 0);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_InPlaceProcessing: /* 29 */";
  z[lc++]="    if (*((UInt32 *)((void *)(p->params[1]))) != ASYS_AUDIOUNIT_INPLACE_PROCESSING)";
  z[lc++]="      result = kAudioUnitErr_InvalidPropertyValue;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_PresentPreset: /* 36 */";
  z[lc++]="    OSSpinLockLock(&(My->lock_PresentPreset));";
  z[lc++]="    CFRelease(My->PresentPreset.presetName);";
  z[lc++]="    My->PresentPreset.presetNumber = ((AUPreset *)(p->params[1]))->presetNumber;";
  z[lc++]="    My->PresentPreset.presetName = ((AUPreset *)(p->params[1]))->presetName;";
  z[lc++]="    CFRetain(My->PresentPreset.presetName);";
  z[lc++]="    OSSpinLockUnlock(&(My->lock_PresentPreset));";
  z[lc++]="    asysn_audiounit_presentproperty_setfactory(My);";
  z[lc++]="    asysn_audiounit_proplisteners_update(My, kAudioUnitProperty_PresentPreset,";
  z[lc++]="					 kAudioUnitScope_Global, (AudioUnitElement) 0);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_OfflineRender: /* 37 */";
  z[lc++]="    My->OfflineRender = *((UInt32 *)((void *)(p->params[1]))); ";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_PresentationLatency: /* 40 */";
  z[lc++]="    My->PresentationLatency = *((Float64 *)((void *)(p->params[1]))); ";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_InstrumentCount: /* 1000 */";
  z[lc++]="    if (ASYS_AUDIOUNIT_EFFECT)";
  z[lc++]="      result = kAudioUnitErr_InvalidPropertyValue;";
  z[lc++]="    else";
  z[lc++]="      if (*((UInt32 *)((void *)(p->params[1]))) != ASYS_AUDIOUNIT_INSTRUMENT_COUNT)";
  z[lc++]="	result = kAudioUnitErr_InvalidPropertyValue;";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_StreamFromDisk: /* 1011 */";
  z[lc++]="    My->StreamFromDisk = *((UInt32 *)((void *)(p->params[1]))); ";
  z[lc++]="    asysn_audiounit_proplisteners_update(My, kMusicDeviceProperty_StreamFromDisk,";
  z[lc++]="					 kAudioUnitScope_Global, (AudioUnitElement) 0);";
  z[lc++]="    break;";
  z[lc++]="  default:   /* should never happen */";
  z[lc++]="    result = kAudioUnitErr_InvalidProperty; ";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  return result;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/**********************************************************/";
  z[lc++]="/*                 Selector: Render                       */";
  z[lc++]="/*                                                        */";
  z[lc++]="/* params[0]: AudioBufferList * ioData;                   */";
  z[lc++]="/* params[1]: UInt32 inNumberFrames;                      */";
  z[lc++]="/* params[2]: UInt32 inOutputBusNumber;                   */";
  z[lc++]="/* params[3]: const AudioTimeStamp * inTimeStamp;         */";
  z[lc++]="/* params[4]: AudioUnitRenderActionFlags * ioActionFlags; */";
  z[lc++]="/*                                                        */";
  z[lc++]="/**********************************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_kAudioUnitRenderSelect(ComponentParameters * p, ";
  z[lc++]="					  asysn_audiounit_InstanceState * My)";
  z[lc++]="{ ";
  z[lc++]="  return (asysn_audiounit_MyRenderer((void *) My, ";
  z[lc++]="				     (AudioUnitRenderActionFlags *)(p->params[4]),";
  z[lc++]="				     (const AudioTimeStamp *)(p->params[3]),";
  z[lc++]="				     (UInt32)(p->params[2]), (UInt32)(p->params[1]),";
  z[lc++]="				     (AudioBufferList *)(p->params[0])));";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*******************/";
  z[lc++]="/* Selector: Reset */";
  z[lc++]="/*                 */";
  z[lc++]="/*******************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_kAudioUnitResetSelect(ComponentParameters * p, ";
  z[lc++]="					 asysn_audiounit_InstanceState * My)";
  z[lc++]="{ ";
  z[lc++]="";
  z[lc++]="#if (ASYS_AUDIOUNIT_RESET_TYPE == ASYS_AUDIOUNIT_ACTIVE_RESET)";
  z[lc++]="  asysn_audiounit_kAudioUnitUninitializeSelect(p, My);";
  z[lc++]="  asysn_audiounit_kAudioUnitInitializeSelect(p, My);";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  return noErr; ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*****************************************************/";
  z[lc++]="/* Selector: Add Property Listener                   */";
  z[lc++]="/*                                                   */";
  z[lc++]="/*  params[0]: void * inProcRefCon;                  */";
  z[lc++]="/*  params[1]: AudioUnitPropertyListenerProc inProc; */";
  z[lc++]="/*  params[2]: AudioUnitPropertyID inID;             */";
  z[lc++]="/*                                                   */";
  z[lc++]="/* The caller passes in a function inProc to call    */";
  z[lc++]="/* the AU changes the property, and an object        */ ";
  z[lc++]="/* inProcRefCon to pass to the function.             */";
  z[lc++]="/*****************************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_kAudioUnitAddPropertyListenerSelect(";
  z[lc++]="                                           ComponentParameters * p, ";
  z[lc++]="					   asysn_audiounit_InstanceState * My)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_proplisten * lp;";
  z[lc++]="  AudioUnitPropertyListenerProc lproc;";
  z[lc++]="  void * lrefcon;";
  z[lc++]="  int idx, found, msize;";
  z[lc++]="";
  z[lc++]="  if ((idx = asysn_audiounit_proplisteners_index(p->params[2])) < 0)";
  z[lc++]="    return noErr; ";
  z[lc++]="  ";
  z[lc++]="  lrefcon = (void *)(p->params[0]);";
  z[lc++]="  lproc = (AudioUnitPropertyListenerProc)(p->params[1]);";
  z[lc++]="";
  z[lc++]="  if (!lproc)";
  z[lc++]="    return noErr; ";
  z[lc++]="";
  z[lc++]="  found = 0;";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_proplisteners));";
  z[lc++]="";
  z[lc++]="  for (lp = My->proplisteners[idx]; lp != NULL; lp = lp->next)";
  z[lc++]="    if ((lp->lrefcon == lrefcon) && (lp->lproc == lproc))";
  z[lc++]="      {";
  z[lc++]="	found = 1;";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  if (!found)";
  z[lc++]="    {";
  z[lc++]="      msize = sizeof(asysn_audiounit_proplisten);";
  z[lc++]="      if (lp = malloc(msize))";
  z[lc++]="	{";
  z[lc++]="	  asysn_audiounit_memstatus(lp, msize, MADV_WILLNEED);";
  z[lc++]="	  lp->lproc = lproc;";
  z[lc++]="	  lp->lrefcon = lrefcon;";
  z[lc++]="	  lp->next = My->proplisteners[idx];";
  z[lc++]="	  My->proplisteners[idx] = lp;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_proplisteners));";
  z[lc++]="";
  z[lc++]="  /* end of critical section */";
  z[lc++]="  ";
  z[lc++]="  return noErr; ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*****************************************************/";
  z[lc++]="/* Selector: Remove Property Listener                */";
  z[lc++]="/*                                                   */";
  z[lc++]="/*  params[0]: AudioUnitPropertyListenerProc inProc; */";
  z[lc++]="/*  params[1]: AudioUnitPropertyID inID;             */";
  z[lc++]="/*                                                   */";
  z[lc++]="/* Instructs the AudioUnit to stop calling the       */";
  z[lc++]="/* inProc for the specified property inID.           */";
  z[lc++]="/*****************************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_kAudioUnitRemovePropertyListenerSelect(";
  z[lc++]="                                           ComponentParameters * p, ";
  z[lc++]="					   asysn_audiounit_InstanceState * My)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_proplisten * lp, * remove, ** trailer;";
  z[lc++]="  AudioUnitPropertyListenerProc lproc;";
  z[lc++]="  int idx, msize;";
  z[lc++]="";
  z[lc++]="  if ((idx = asysn_audiounit_proplisteners_index(p->params[1])) < 0)";
  z[lc++]="    return noErr; ";
  z[lc++]="";
  z[lc++]="  lproc = (AudioUnitPropertyListenerProc)(p->params[0]);";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_proplisteners));";
  z[lc++]="";
  z[lc++]="  lp = My->proplisteners[idx];";
  z[lc++]="  trailer = &(My->proplisteners[idx]);";
  z[lc++]="";
  z[lc++]="  while (lp != NULL)";
  z[lc++]="    if (lp->lproc == lproc)";
  z[lc++]="      {";
  z[lc++]="	remove = lp;";
  z[lc++]="	lp = (*trailer) = lp->next;";
  z[lc++]="	msize = sizeof(asysn_audiounit_proplisten);";
  z[lc++]="	asysn_audiounit_memstatus(remove, msize, MADV_FREE);";
  z[lc++]=" 	free(remove);";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	trailer = &(lp->next);";
  z[lc++]="	lp = lp->next;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_proplisteners));";
  z[lc++]="";
  z[lc++]="  return noErr; ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*************************************/";
  z[lc++]="/*  Selector: Add Render Notify      */";
  z[lc++]="/*                                   */";
  z[lc++]="/*  params[0]: void * inProcRefCon;  */";
  z[lc++]="/*  params[1]: ProcPtr inProc;       */";
  z[lc++]="/*                                   */";
  z[lc++]="/*************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_kAudioUnitAddRenderNotifySelect";
  z[lc++]="(ComponentParameters * p, asysn_audiounit_InstanceState * My)";
  z[lc++]="{ ";
  z[lc++]="  asysn_audiounit_rendernotify * notify;";
  z[lc++]="  int msize;";
  z[lc++]="";
  z[lc++]="  msize = sizeof(asysn_audiounit_rendernotify);";
  z[lc++]="  if (!(notify = malloc(msize)))";
  z[lc++]="    return noErr;";
  z[lc++]="  asysn_audiounit_memstatus(notify, msize, MADV_WILLNEED);";
  z[lc++]="";
  z[lc++]="  notify->nproc = (AURenderCallback)(p->params[1]);";
  z[lc++]="  notify->nrefcon = (void *)(p->params[0]);";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_rendernotify));";
  z[lc++]="";
  z[lc++]="  notify->next = My->rendernotify;";
  z[lc++]="  My->rendernotify = notify;";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_rendernotify));";
  z[lc++]="";
  z[lc++]="  return noErr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*************************************/";
  z[lc++]="/*  Selector: Remove Render Notify   */";
  z[lc++]="/*                                   */";
  z[lc++]="/*  params[0]: void * inProcRefCon;  */";
  z[lc++]="/*  params[1]: ProcPtr inProc;       */";
  z[lc++]="/*                                   */";
  z[lc++]="/*************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_kAudioUnitRemoveRenderNotifySelect";
  z[lc++]="(ComponentParameters * p, asysn_audiounit_InstanceState * My)";
  z[lc++]="{ ";
  z[lc++]="  asysn_audiounit_rendernotify * notify, * remove, ** trailer;";
  z[lc++]="  int msize;";
  z[lc++]="";
  z[lc++]="  OSSpinLockLock(&(My->lock_rendernotify));";
  z[lc++]="";
  z[lc++]="  notify = My->rendernotify;";
  z[lc++]="  trailer = &(My->rendernotify);";
  z[lc++]="";
  z[lc++]="  while (notify != NULL)";
  z[lc++]="    if ((notify->nproc == (AURenderCallback)(p->params[1])) &&";
  z[lc++]="	(notify->nrefcon == (void *)(p->params[0])))";
  z[lc++]="      {";
  z[lc++]="	remove = notify;";
  z[lc++]="	notify = (*trailer) = notify->next;";
  z[lc++]="";
  z[lc++]="	msize = sizeof(asysn_audiounit_rendernotify);";
  z[lc++]="	asysn_audiounit_memstatus(remove, msize, MADV_FREE);";
  z[lc++]="	free(remove);";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      {";
  z[lc++]="	trailer = &(notify->next);";
  z[lc++]="	notify = notify->next;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  OSSpinLockUnlock(&(My->lock_rendernotify));";
  z[lc++]="";
  z[lc++]="  return noErr;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/******************************************/";
  z[lc++]="/*     Selector: GetParameterSelect       */";
  z[lc++]="/*                                        */";
  z[lc++]="/* params[0]: Float32 * outValue          */";
  z[lc++]="/* params[1]: AudioUnitElement inElement  */";
  z[lc++]="/* params[2]: AudioUnitScope inScope      */";
  z[lc++]="/* params[3]: AudioUnitParameterID inID   */";
  z[lc++]="/*                                        */";
  z[lc++]="/******************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_kAudioUnitGetParameterSelect";
  z[lc++]="(ComponentParameters * p, asysn_audiounit_InstanceState * My)";
  z[lc++]="{ ";
  z[lc++]="  if (((AudioUnitScope)(p->params[2])) != kAudioUnitScope_Global)  /* inScope */";
  z[lc++]="    return kAudioUnitErr_InvalidScope;";
  z[lc++]="";
  z[lc++]="  return asysn_audiounit_getSASLevent(((AudioUnitParameterID)(p->params[3])) /* inID */,";
  z[lc++]="				      ((Float32 *)(p->params[0])) /* outValue */, My);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*********************************************/";
  z[lc++]="/*     Selector: SetParameterSelect          */";
  z[lc++]="/*                                           */";
  z[lc++]="/* params[0]: UInt32 inBufferOffsetInFrames  */";
  z[lc++]="/* params[1]: Float32 inValue                */";
  z[lc++]="/* params[2]: AudioUnitElement inElement     */";
  z[lc++]="/* params[3]: AudioUnitScope inScope;        */";
  z[lc++]="/* params[4]: AudioUnitParameterID inID;     */";
  z[lc++]="/*                                           */";
  z[lc++]="/*********************************************/";
  z[lc++]="";
  z[lc++]="ComponentResult asysn_audiounit_kAudioUnitSetParameterSelect";
  z[lc++]="(ComponentParameters * p, asysn_audiounit_InstanceState * My)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_SASLevent SASLevent;";
  z[lc++]="  int result;";
  z[lc++]="  Float32 inValue;";
  z[lc++]="  int inID;";
  z[lc++]="";
  z[lc++]="  if (((AudioUnitScope)(p->params[3])) != kAudioUnitScope_Global)  /* inScope */";
  z[lc++]="    return kAudioUnitErr_InvalidScope;";
  z[lc++]="";
  z[lc++]="  inID = (AudioUnitParameterID)(p->params[4]);";
  z[lc++]="";
  z[lc++]="  if ((inID < 0) || (inID >= My->num_saolparams))  /* range-check ID */";
  z[lc++]="    return kAudioUnitErr_InvalidParameter;";
  z[lc++]="";
  z[lc++]="  inValue = *((Float32 *)((unsigned char *)(&(p->params[1]))));";
  z[lc++]="";
  z[lc++]="  if (inValue > My->parameterinfo[inID].maxValue)";
  z[lc++]="    inValue = My->parameterinfo[inID].maxValue;";
  z[lc++]="";
  z[lc++]="  if (inValue < My->parameterinfo[inID].minValue)";
  z[lc++]="    inValue = My->parameterinfo[inID].minValue;";
  z[lc++]="";
  z[lc++]="  SASLevent.index = inID;";
  z[lc++]="  SASLevent.value = My->saolparam[inID].value = inValue;";
  z[lc++]="  SASLevent.kcycleidx = (int)((UInt32)(p->params[0]));";
  z[lc++]="";
  z[lc++]="  return asysn_audiounit_sendSASLevent(&SASLevent, My);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* The AudioUnit Entry Function */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/************************************************************/";
  z[lc++]="/*   The function Component Manager calls to access the AU  */";
  z[lc++]="/************************************************************/";
  z[lc++]="";
  z[lc++]="extern ComponentResult asysn_audiounit_entry(ComponentParameters * p, Handle * obj) ";
  z[lc++]="{ ";
  z[lc++]="  asysn_audiounit_MIDIevent MIDIevent;";
  z[lc++]="  ComponentResult result;";
  z[lc++]="";
  z[lc++]="  if (obj == NULL) ";
  z[lc++]="    switch (p->what) {";
  z[lc++]="    case kComponentOpenSelect:";
  z[lc++]="    case kComponentVersionSelect:";
  z[lc++]="    case kComponentCanDoSelect:";
  z[lc++]="      break;";
  z[lc++]="    default:";
  z[lc++]="    return noErr;  /* avoid race condition */";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  switch (p->what) { ";
  z[lc++]="  case kComponentOpenSelect:";
  z[lc++]="    result = asysn_audiounit_kComponentOpenSelect";
  z[lc++]="      (p, (asysn_audiounit_InstanceState *) obj);";
  z[lc++]="    break;";
  z[lc++]="  case kComponentCloseSelect:";
  z[lc++]="    result = asysn_audiounit_kComponentCloseSelect";
  z[lc++]="      (p, (asysn_audiounit_InstanceState *) obj);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitInitializeSelect:";
  z[lc++]="    result = asysn_audiounit_kAudioUnitInitializeSelect";
  z[lc++]="      (p, (asysn_audiounit_InstanceState *) obj);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitUninitializeSelect:";
  z[lc++]="    result = asysn_audiounit_kAudioUnitUninitializeSelect";
  z[lc++]="      (p, (asysn_audiounit_InstanceState *) obj);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitGetPropertyInfoSelect:";
  z[lc++]="    result = asysn_audiounit_kAudioUnitGetPropertyInfoSelect";
  z[lc++]="      (p, (asysn_audiounit_InstanceState *) obj);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitGetPropertySelect:";
  z[lc++]="    result = asysn_audiounit_kAudioUnitGetPropertySelect";
  z[lc++]="      (p, (asysn_audiounit_InstanceState *) obj);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitSetPropertySelect:";
  z[lc++]="    result = asysn_audiounit_kAudioUnitSetPropertySelect";
  z[lc++]="      (p, (asysn_audiounit_InstanceState *) obj);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitRenderSelect:";
  z[lc++]="    result = asysn_audiounit_kAudioUnitRenderSelect";
  z[lc++]="      (p, (asysn_audiounit_InstanceState *) obj);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitResetSelect:";
  z[lc++]="    result = asysn_audiounit_kAudioUnitResetSelect";
  z[lc++]="      (p, (asysn_audiounit_InstanceState *) obj);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitAddPropertyListenerSelect:";
  z[lc++]="    result = asysn_audiounit_kAudioUnitAddPropertyListenerSelect";
  z[lc++]="      (p, (asysn_audiounit_InstanceState *) obj);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitRemovePropertyListenerSelect:";
  z[lc++]="    result = asysn_audiounit_kAudioUnitRemovePropertyListenerSelect";
  z[lc++]="      (p, (asysn_audiounit_InstanceState *) obj);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitAddRenderNotifySelect:";
  z[lc++]="    result = asysn_audiounit_kAudioUnitAddRenderNotifySelect";
  z[lc++]="      (p, (asysn_audiounit_InstanceState *) obj);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitRemoveRenderNotifySelect:";
  z[lc++]="    result = asysn_audiounit_kAudioUnitRemoveRenderNotifySelect";
  z[lc++]="      (p, (asysn_audiounit_InstanceState *) obj);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitGetParameterSelect:";
  z[lc++]="    result = asysn_audiounit_kAudioUnitGetParameterSelect";
  z[lc++]="      (p, (asysn_audiounit_InstanceState *) obj);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitSetParameterSelect:";
  z[lc++]="    result = asysn_audiounit_kAudioUnitSetParameterSelect";
  z[lc++]="      (p, (asysn_audiounit_InstanceState *) obj);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitScheduleParametersSelect:";
  z[lc++]="    result = noErr;";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceMIDIEventSelect:";
  z[lc++]="    if (ASYS_AUDIOUNIT_MIDISUPPORT)";
  z[lc++]="      {";
  z[lc++]="	MIDIevent.cmd = (unsigned char)((UInt32)(p->params[3]));";
  z[lc++]="	MIDIevent.d0 = (unsigned char)((UInt32)(p->params[2]));";
  z[lc++]="	MIDIevent.d1 = (unsigned char)((UInt32)(p->params[1]));";
  z[lc++]="	MIDIevent.flags = ASYS_AUDIOUNIT_MIDIFLAGS_WAITING;";
  z[lc++]="	MIDIevent.kcycleidx = (int)((UInt32)(p->params[0]));";
  z[lc++]="	result = asysn_audiounit_sendMIDIevent";
  z[lc++]="	  (&MIDIevent, (asysn_audiounit_InstanceState *) obj);";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      result = badComponentSelector;";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceSysExSelect:";
  z[lc++]="  case kMusicDevicePrepareInstrumentSelect:";
  z[lc++]="  case kMusicDeviceReleaseInstrumentSelect:";
  z[lc++]="  case kMusicDeviceStartNoteSelect:";
  z[lc++]="  case kMusicDeviceStopNoteSelect:";
  z[lc++]="  default:";
  z[lc++]="    result = badComponentSelector;";
  z[lc++]="    break;";
  z[lc++]="  case kComponentVersionSelect:";
  z[lc++]="    result = 0x00010000;    /* major version 1, minor version 0 */";
  z[lc++]="    break;";
  z[lc++]="  case kComponentCanDoSelect:";
  z[lc++]="    switch (p->params[0]) {";
  z[lc++]="    case kComponentOpenSelect:";
  z[lc++]="    case kComponentCloseSelect:";
  z[lc++]="    case kAudioUnitInitializeSelect:";
  z[lc++]="    case kAudioUnitUninitializeSelect:";
  z[lc++]="    case kAudioUnitGetPropertyInfoSelect:";
  z[lc++]="    case kAudioUnitGetPropertySelect:";
  z[lc++]="    case kAudioUnitSetPropertySelect:";
  z[lc++]="    case kAudioUnitRenderSelect:";
  z[lc++]="    case kAudioUnitResetSelect:";
  z[lc++]="    case kAudioUnitGetParameterSelect:";
  z[lc++]="    case kAudioUnitSetParameterSelect:";
  z[lc++]="    case kAudioUnitAddRenderNotifySelect:";
  z[lc++]="    case kAudioUnitRemoveRenderNotifySelect:";
  z[lc++]="      result = 1;";
  z[lc++]="      break;";
  z[lc++]="    case kMusicDeviceMIDIEventSelect:";
  z[lc++]="      result = ASYS_AUDIOUNIT_MIDISUPPORT;";
  z[lc++]="    default:";
  z[lc++]="      result = 0;";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  switch (p->what) { ";
  z[lc++]="  case kAudioUnitRenderSelect:";
  z[lc++]="    ASYS_AUDIOUNIT_WIRETAP_R(p, result);";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceMIDIEventSelect:";
  z[lc++]="    ASYS_AUDIOUNIT_WIRETAP_M(p, result);";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    ASYS_AUDIOUNIT_WIRETAP(p, result);";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  return result;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*         End of Part Three (The AudioUnit Component)          */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        End of Apple AudioUnit audio driver for sfront        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  printlib(lc);
}


void makewiretap(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: wiretap logger for audiounit driver for sfront";
  z[lc++]="#";
  z[lc++]="# Copyright (c) 1999-2008, Regents of the University of California";
  z[lc++]="# All rights reserved.";
  z[lc++]="#";
  z[lc++]="# Redistribution and use in source and binary forms, with or without";
  z[lc++]="# modification, are permitted provided that the following conditions are";
  z[lc++]="# met:";
  z[lc++]="#";
  z[lc++]="#  Redistributions of source code must retain the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer.";
  z[lc++]="#";
  z[lc++]="#  Redistributions in binary form must reproduce the above copyright";
  z[lc++]="#  notice, this list of conditions and the following disclaimer in the";
  z[lc++]="#  documentation and/or other materials provided with the distribution.";
  z[lc++]="#";
  z[lc++]="#  Neither the name of the University of California, Berkeley nor the";
  z[lc++]="#  names of its contributors may be used to endorse or promote products";
  z[lc++]="#  derived from this software without specific prior written permission.";
  z[lc++]="#";
  z[lc++]="# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS";
  z[lc++]="# \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR";
  z[lc++]="# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT";
  z[lc++]="# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,";
  z[lc++]="# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT";
  z[lc++]="# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,";
  z[lc++]="# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY";
  z[lc++]="# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT";
  z[lc++]="# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE";
  z[lc++]="# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*          Wiretap debugger for audio driver for sfront        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~*/";
  z[lc++]="/* debug level */";
  z[lc++]="/*_____________*/";
  z[lc++]="";
  z[lc++]="/*  Level 0:  No debugging messages            */";
  z[lc++]="/*  Level 1:  Session setup and error messages */";
  z[lc++]="/*  Level 2:  + All MIDI events                */";
  z[lc++]="/*  Level 3:  + All Rendering calls            */";
  z[lc++]="";
  z[lc++]="#if !defined(ASYS_AUDIOUNIT_DEBUG_LEVEL)";
  z[lc++]="#define ASYS_AUDIOUNIT_DEBUG_LEVEL 2";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* include headers */";
  z[lc++]="/*_________________*/";
  z[lc++]="";
  z[lc++]="#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)";
  z[lc++]="#include <CoreServices/CoreServices.h>";
  z[lc++]="#include <AudioUnit/AudioUnit.h>";
  z[lc++]="#else";
  z[lc++]="#include <ConditionalMacros.h>";
  z[lc++]="#include <CoreServices.h>";
  z[lc++]="#include <AudioUnit.h>";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* endian detection */";
  z[lc++]="/*__________________*/";
  z[lc++]="";
  z[lc++]="SInt32 asysn_audiounit_sint32_endian_test = -2;";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_SINT32_BIGENDIAN \\";
  z[lc++]="        ((((char *)(&asysn_audiounit_sint32_endian_test))[0]) == ((char)(-1)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                The Wiretap Debugging System                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* Global Variables and Constants */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="#define ASYS_AUDIOUNIT_LOGFILE_NAME \"/tmp/wiretap.txt\"";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_first_logfile_open = 1;";
  z[lc++]="FILE * asysn_audiounit_logfile;";
  z[lc++]="";
  z[lc++]="enum";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_PropertySizeUnknown = -1,";
  z[lc++]="  asysn_audiounit_PropertySizeWildCard = -2,";
  z[lc++]="};";
  z[lc++]="";
  z[lc++]="extern int asysn_audiounit_opencount;   /* number of audiounit instances */";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* Low-Level Logfile Management */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/********************************************/";
  z[lc++]="/* clears logfile at the start of a session */";
  z[lc++]="/********************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_logfile_initialize(void) ";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_logfile = fopen(ASYS_AUDIOUNIT_LOGFILE_NAME, \"w\");";
  z[lc++]="  fclose(asysn_audiounit_logfile);";
  z[lc++]="  asysn_audiounit_first_logfile_open = 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* Name-Printing Routines */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/*************************/";
  z[lc++]="/* prints out scope name */";
  z[lc++]="/*************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_scope_name(int scope)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  switch(scope) {";
  z[lc++]="  case kAudioUnitScope_Global:  /* 0 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitScope_Global\", scope);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitScope_Input:	/* 1 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitScope_Input\", scope);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitScope_Output:  /* 2 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitScope_Output\", scope);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitScope_Group:   /* 3 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitScope_Group\", scope);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitScope_Part:    /* 4 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitScope_Part\", scope);";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"(%i)\", scope);";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************/";
  z[lc++]="/* prints out selector name */";
  z[lc++]="/****************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_selector_name(int selector)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  switch(selector) {";
  z[lc++]="";
  z[lc++]="  case kComponentOpenSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kComponentOpenSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kComponentCloseSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kComponentCloseSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kComponentCanDoSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kComponentCanDoSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kComponentVersionSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kComponentVersionSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kComponentRegisterSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kComponentRegisterSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kComponentTargetSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kComponentTargetSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kComponentUnregisterSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kComponentUnregisterSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kComponentGetMPWorkFunctionSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kComponentGetMPWorkFunctionSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kComponentExecuteWiredActionSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kComponentExecuteWiredActionSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kComponentGetPublicResourceSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kComponentGetPublicResourceSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitRange:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitRange\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitInitializeSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitInitializeSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitUninitializeSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitUninitializeSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitGetPropertyInfoSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitGetPropertyInfoSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitGetPropertySelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitGetPropertySelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitSetPropertySelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitSetPropertySelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitAddPropertyListenerSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitAddPropertyListenerSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitRemovePropertyListenerSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitRemovePropertyListenerSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitAddRenderNotifySelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitAddRenderNotifySelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitRemoveRenderNotifySelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitRemoveRenderNotifySelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitGetParameterSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitGetParameterSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitSetParameterSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitSetParameterSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitScheduleParametersSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitScheduleParametersSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitRenderSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitRenderSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitResetSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitResetSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceMIDIEventSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kMusicDeviceMIDIEventSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceSysExSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kMusicDeviceSysExSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDevicePrepareInstrumentSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kMusicDevicePrepareInstrumentSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceReleaseInstrumentSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kMusicDeviceReleaseInstrumentSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceStartNoteSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kMusicDeviceStartNoteSelect\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceStopNoteSelect:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kMusicDeviceStopNoteSelect\");";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"(%i)\", selector);";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*******************************/";
  z[lc++]="/* prints out return code name */";
  z[lc++]="/*******************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_returncode_name(ComponentResult returncode)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  switch (returncode) {";
  z[lc++]="  case noErr:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"noErr (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case badComponentInstance:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"badComponentInstance (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case badComponentSelector:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"badComponentSelector (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_InvalidProperty:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_InvalidProperty (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_InvalidParameter:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_InvalidParameter (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_InvalidElement:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_InvalidElement (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_NoConnection:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_NoConnection (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_FailedInitialization:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_FailedInitialization (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_TooManyFramesToProcess:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_TooManyFramesToProcess (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_IllegalInstrument:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_IllegalInstrument (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_InstrumentTypeNotFound:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_InstrumentTypeNotFound (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_InvalidFile:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_InvalidFile (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_UnknownFileType:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_UnknownFileType (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_FileNotSpecified:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_FileNotSpecified (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_FormatNotSupported:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_FormatNotSupported (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_Uninitialized:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_Uninitialized (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_InvalidScope:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_InvalidScope (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_PropertyNotWritable:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_PropertyNotWritable (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_CannotDoInCurrentContext:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_CannotDoInCurrentContext (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_InvalidPropertyValue:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_InvalidPropertyValue (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_PropertyNotInUse:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_PropertyNotInUse (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_Initialized:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_Initialized (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_InvalidOfflineRender:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_InvalidOfflineRender (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitErr_Unauthorized:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitErr_Unauthorized (%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"(%i)\", ";
  z[lc++]="	    returncode);";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/**************************************/";
  z[lc++]="/* prints return code if interesting  */";
  z[lc++]="/**************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_nonzero_returncode(ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  if (returncode)";
  z[lc++]="    {";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tReturning \"); ";
  z[lc++]="      asysn_audiounit_print_returncode_name(returncode);";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************/";
  z[lc++]="/* prints out property name */";
  z[lc++]="/****************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_property_name(int property)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  switch(property) {";
  z[lc++]="  case kAudioUnitProperty_ClassInfo: /* 0 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ClassInfo\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_MakeConnection: /* 1 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_MakeConnection\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SampleRate: /* 2 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_SampleRate\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterList: /* 3 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ParameterList\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterInfo: /* 4 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ParameterInfo\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_FastDispatch: /* 5 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_FastDispatch\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_CPULoad: /* 6 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_CPULoad\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_StreamFormat: /* 8 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_StreamFormat\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SRCAlgorithm: /* 9 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_SRCAlgorithm\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ReverbRoomType: /* 10 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ReverbRoomType\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ElementCount: /* 11, also kAudioUnitProperty_BusCount */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ElementCount_or_BusCount\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_Latency: /* 12 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_Latency\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SupportedNumChannels: /* 13 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_SupportedNumChannels\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_MaximumFramesPerSlice: /* 14 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_MaximumFramesPerSlice\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SetExternalBuffer: /* 15 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_SetExternalBuffer\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterValueStrings: /* 16 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ParameterValueStrings\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_MIDIControlMapping: /* 17 */ ";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_MIDIControlMapping\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_GetUIComponentList: /* 18 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_GetUIComponentList\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_AudioChannelLayout: /* 19 */  ";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_AudioChannelLayout\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_TailTime: /* 20 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_TailTime\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_BypassEffect: /* 21 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_BypassEffect\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_LastRenderError: /* 22 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_LastRenderError\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SetRenderCallback: /* 23 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_SetRenderCallback\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_FactoryPresets: /* 24 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_FactoryPresets\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ContextName: /* 25 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ContextName\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_RenderQuality: /* 26 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_RenderQuality\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_HostCallbacks: /* 27 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_HostCallbacks\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_CurrentPreset: /* 28 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_CurrentPreset\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_InPlaceProcessing: /* 29 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_InPlaceProcessing\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ElementName: /* 30 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ElementName\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_CocoaUI: /* 31 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_CocoaUI\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterStringFromValue: /* 33 */";
  z[lc++]="    /* also kAudioUnitProperty_ParameterValueName */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ParameterStringFromValue\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterIDName: /* 34 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ParameterIDName\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterClumpName: /* 35 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ParameterClumpName\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_PresentPreset: /* 36 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_PresentPreset\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_OfflineRender: /* 37 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_OfflineRender\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterValueFromString: /* 38 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ParameterValueFromString\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_IconLocation: /* 39 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_IconLocation\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_PresentationLatency: /* 40 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_PresentationLatency\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_AllParameterMIDIMappings: /* 41 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_AllParameterMIDIMappings\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_AddParameterMIDIMapping: /* 42 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_AddParameterMIDIMapping\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_RemoveParameterMIDIMapping: /* 43 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_RemoveParameterMIDIMapping\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_HotMapParameterMIDIMapping: /* 44 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_HotMapParameterMIDIMapping\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_DependentParameters: /* 45 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_DependentParameters\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_InstrumentCount: /* 1000 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_InstrumentCount\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_InstrumentName: /* 1001 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_InstrumentName\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_GroupOutputBus: /* 1002 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_GroupOutputBus\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_SoundBankFSSpec: /* 1003 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_SoundBankFSSpec\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_InstrumentNumber: /* 1004 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_InstrumentNumber\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_UsesInternalReverb: /* 1005 */ ";
  z[lc++]="    /* also kAudioUnitProperty_UsesInternalReverb */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_UsesInternalReverb\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_MIDIXMLNames: /* 1006 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_MIDIXMLNames\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_BankName: /* 1007 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_BankName\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_SoundBankData: /* 1008 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_SoundBankData\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_PartGroup: /* 1010 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_PartGroup\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_StreamFromDisk: /* 1011 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_StreamFromDisk\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_SoundBankFSRef: /* 1012 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_SoundBankFSRef\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOutputUnitProperty_CurrentDevice: /* 2000 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioOutputUnitProperty_CurrentDevice\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOutputUnitProperty_IsRunning: /* 2001 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioOutputUnitProperty_IsRunning\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOutputUnitProperty_ChannelMap: /* 2002 */ ";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioOutputUnitProperty_ChannelMap\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOutputUnitProperty_EnableIO: /* 2003 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioOutputUnitProperty_EnableIO\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOutputUnitProperty_StartTime: /* 2004 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioOutputUnitProperty_StartTime\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOutputUnitProperty_SetInputCallback: /* 2005 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioOutputUnitProperty_SetInputCallback\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOutputUnitProperty_HasIO: /* 2006 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioOutputUnitProperty_HasIO\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOutputUnitProperty_StartTimestampsAtZero: /* 2007 */ ";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioOutputUnitProperty_StartTimestampsAtZero\");";
  z[lc++]="    break;";
  z[lc++]="";
  z[lc++]="  case kAudioUnitProperty_SpatializationAlgorithm: /* 3000 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_SpatializationAlgorithm\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SpeakerConfiguration: /* 3001 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_SpeakerConfiguration\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_DopplerShift: /* 3002 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_DopplerShift\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_3DMixerRenderingFlags: /* 3003 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_3DMixerRenderingFlags\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_3DMixerDistanceAtten: /* 3004 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_3DMixerDistanceAtten\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_MatrixLevels: /* 3006 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_MatrixLevels\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_MeteringMode: /* 3007 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_MeteringMode\");";
  z[lc++]="    break;";
  z[lc++]="#if (0)   /* depreciated */";
  z[lc++]="  case kAudioUnitProperty_PannerMode: /* 3008 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_PannerMode\");";
  z[lc++]="    break;";
  z[lc++]="#endif";
  z[lc++]="  case kAudioUnitProperty_MatrixDimensions: /* 3009 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_MatrixDimensions\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_3DMixerDistanceParams: /* 3010 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_3DMixerDistanceParams\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_MeterClipping: /* 3011 */ ";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_MeterClipping\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOfflineUnitProperty_InputSize: /* 3020 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioOfflineUnitProperty_InputSize\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOfflineUnitProperty_OutputSize: /* 3021 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioOfflineUnitProperty_OutputSize\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitOfflineProperty_StartOffset: /* 3022 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioOfflineUnitProperty_StartOffset\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitOfflineProperty_PreflightRequirements: /* 3023 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioOfflineUnitProperty_PreflightRequirements\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitOfflineProperty_PreflightName: /* 3024 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioOfflineUnitProperty_PreflightName\");";
  z[lc++]="    break;";
  z[lc++]="";
  z[lc++]="  case kAudioUnitProperty_ScheduleAudioSlice: /* 3300 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ScheduleAudioSlice\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ScheduleStartTimeStamp: /* 3301 */ ";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ScheduleStartTimeStamp\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_CurrentPlayTime: /* 3302 */ ";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_CurrentPlayTime\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ScheduledFileIDs: /* 3310 */	";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ScheduledFileIDs\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ScheduledFileRegion: /* 3311 */  ";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ScheduledFileRegion\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ScheduledFilePrime: /* 3312 */   ";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ScheduledFilePrime\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ScheduledFileBufferSizeFrames: /* 3313 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ScheduledFileBufferSizeFrames\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ScheduledFileNumberBuffers: /* 3314 */	";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_ScheduledFileNumberBuffers\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_DeferredRendererPullSize: /* 3320 */	";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_DeferredRendererPullSize\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_DeferredRendererExtraLatency: /* 3321 */  ";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_DeferredRendererExtraLatency\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_DeferredRendererWaitFrames: /* 3322 */	";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitProperty_DeferredRendererWaitFrames\");";
  z[lc++]="    break;";
  z[lc++]="  case kAUNetReceiveProperty_Hostname: /* 3511 */";
  z[lc++]="  case kAUNetReceiveProperty_Password: /* 3512 */";
  z[lc++]="  case kAUNetSendProperty_PortNum: /* 3513 */";
  z[lc++]="  case kAUNetSendProperty_TransmissionFormat: /* 3514 */";
  z[lc++]="  case kAUNetSendProperty_TransmissionFormatIndex: /* 3515 */";
  z[lc++]="  case kAUNetSendProperty_ServiceName: /* 3516 */";
  z[lc++]="  case kAUNetSendProperty_Disconnect: /* 3517 */";
  z[lc++]="  case kAUNetSendProperty_Password: /* 3518 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"AUNet Property %i\", property);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitMigrateProperty_FromPlugin: /* 4000 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitMigrateProperty_FromPlugin\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitMigrateProperty_OldAutomation: /* 4001 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"kAudioUnitMigrateProperty_OldAutomation\");";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"(%i)\", property);";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*****************************/";
  z[lc++]="/* prints out parameter name */";
  z[lc++]="/*****************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_parameter_name(int parameter)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  switch(parameter) {";
  z[lc++]="  default:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"(%i)\", parameter);";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/******************************/";
  z[lc++]="/* prints out parameter units */";
  z[lc++]="/******************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_parameter_units(int units)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  switch(units) {";
  z[lc++]="  case kAudioUnitParameterUnit_Generic:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"(generic)\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_Indexed:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"(indexed)\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_Boolean:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"(boolean)\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_Percent:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"%\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_Seconds:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"s\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_SampleFrames:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"frames\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_Phase:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"degrees (phase)\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_Rate:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"1/s (rate)\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_Hertz:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"Hz\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_Cents:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"cents\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_RelativeSemiTones:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"semitones (relative)\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_MIDINoteNumber:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"note number\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_MIDIController:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"CC number\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_Decibels:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"dB\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_LinearGain:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"gain (linear)\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_Degrees:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"degrees\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_EqualPowerCrossfade:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"(crossfade - equal power)\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_MixerFaderCurve1:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"(mixer fader curve1)\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_Pan:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"pan\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_Meters:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"m\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_AbsoluteCents:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"cents (absolute)\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitParameterUnit_CustomUnit:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"custom\");";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"(%i)\", units);";
  z[lc++]="    break;";
  z[lc++]="  };";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/**************************************/";
  z[lc++]="/* prints out a MIDI channel command  */";
  z[lc++]="/**************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_midievent(unsigned char command, unsigned char d0, ";
  z[lc++]="				     unsigned char c0)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if ((command & 0xF0) == 0x80)  /* note off */";
  z[lc++]="    {";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tNote Off: ch %i note %i vel %i\", ";
  z[lc++]="	      command & 0x0F, d0, c0);";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="  if ((command & 0xF0) == 0x90)  /* note on */";
  z[lc++]="    {";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tNote On: ch %i note %i vel %i\", ";
  z[lc++]="	      command & 0x0F, d0, c0);";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="  if ((command & 0xF0) == 0xA0)  /* aftertouch */";
  z[lc++]="    {";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tPoly Aftertouch: ch %i note %i vel %i\", ";
  z[lc++]="	      command & 0x0F, d0, c0);";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="  if ((command & 0xF0) == 0xB0)  /* control change */";
  z[lc++]="    {";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tControl change: ch %i num %i val %i\", ";
  z[lc++]="	      command & 0x0F, d0, c0);";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="  if ((command & 0xF0) == 0xC0)  /* patch change */";
  z[lc++]="    {";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tPatch Change: ch %i pp %i\", ";
  z[lc++]="	      command & 0x0F, d0);";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="  if ((command & 0xF0) == 0xD0)  /* channel aftertouch */";
  z[lc++]="    {";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tChannel Aftertouch: ch %i val %i\", ";
  z[lc++]="	      command & 0x0F, d0);";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="  if ((command & 0xF0) == 0xE0)  /* pitch wheel */";
  z[lc++]="    {";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tPitch wheel: ch %i top %i bot %i\", ";
  z[lc++]="	      command & 0x0F, c0, d0);";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tSystem command: %hhX\", command);";
  z[lc++]="  return;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* Size-Checking Routines */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/*************************************/";
  z[lc++]="/* number of bytes of params[] array */";
  z[lc++]="/*************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_expected_param_size(ComponentParameters *p)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  switch(p->what) {";
  z[lc++]="";
  z[lc++]="  case kComponentOpenSelect:";
  z[lc++]="    return 4;";
  z[lc++]="    break;";
  z[lc++]="  case kComponentCloseSelect:";
  z[lc++]="    return 4;";
  z[lc++]="    break;";
  z[lc++]="  case kComponentCanDoSelect:";
  z[lc++]="    return 4;";
  z[lc++]="    break;";
  z[lc++]="  case kComponentVersionSelect:";
  z[lc++]="    return 0;";
  z[lc++]="    break;";
  z[lc++]="  case kComponentRegisterSelect:";
  z[lc++]="    return 0;";
  z[lc++]="    break;";
  z[lc++]="  case kComponentTargetSelect:";
  z[lc++]="    return 4;";
  z[lc++]="    break;";
  z[lc++]="  case kComponentUnregisterSelect:";
  z[lc++]="    return 0;";
  z[lc++]="    break;";
  z[lc++]="  case kComponentGetMPWorkFunctionSelect:";
  z[lc++]="  case kComponentExecuteWiredActionSelect:";
  z[lc++]="  case kComponentGetPublicResourceSelect:";
  z[lc++]="    return -1;  /* todo: find correct values for these selectors */";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitRange:";
  z[lc++]="    return -1;  /* todo: find correct values for this selector */";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitInitializeSelect:";
  z[lc++]="    return 0;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitUninitializeSelect:";
  z[lc++]="    return 0;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitGetPropertyInfoSelect:";
  z[lc++]="    return 20;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitGetPropertySelect:";
  z[lc++]="    return 20;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitSetPropertySelect:";
  z[lc++]="    return 20;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitAddPropertyListenerSelect:";
  z[lc++]="    return 12;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitRemovePropertyListenerSelect:";
  z[lc++]="    return 8;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitAddRenderNotifySelect:";
  z[lc++]="    return 8;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitRemoveRenderNotifySelect:";
  z[lc++]="    return 8;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitGetParameterSelect:";
  z[lc++]="    return 16;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitSetParameterSelect:";
  z[lc++]="    return 20;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitScheduleParametersSelect:";
  z[lc++]="    return 8;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitRenderSelect:";
  z[lc++]="    return 20;";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitResetSelect:";
  z[lc++]="    return 8;";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceMIDIEventSelect:";
  z[lc++]="    return 16;";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceSysExSelect:";
  z[lc++]="    return 8;";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDevicePrepareInstrumentSelect:";
  z[lc++]="    return 4;";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceReleaseInstrumentSelect:";
  z[lc++]="    return 4;";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceStartNoteSelect:";
  z[lc++]="    return 20;";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceStopNoteSelect:";
  z[lc++]="    return 12;";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  return -1;  /* return -1 for unrecognized selectors */";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************/";
  z[lc++]="/* error-checks paramSize value  */";
  z[lc++]="/*********************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_paramsize_check(ComponentParameters *p)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int expected = asysn_audiounit_expected_param_size(p);";
  z[lc++]="";
  z[lc++]="  if (expected >=0)";
  z[lc++]="    {";
  z[lc++]="      if (p->paramSize != expected)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, ";
  z[lc++]="		\"\\n\\tWARNING: Expected paramSize %i, actual paramsize %i\",";
  z[lc++]="		expected, p->paramSize); ";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    fprintf(asysn_audiounit_logfile, ";
  z[lc++]="	    \"\\n\\tWARNING: Unknown selector, cannot verify paramSize value \"); ";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/********************************************/";
  z[lc++]="/* number of bytes of get/set property data */";
  z[lc++]="/********************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_expected_property_size(AudioUnitPropertyID id)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  switch(id) {";
  z[lc++]="  case kAudioUnitProperty_ClassInfo: /* 0 */";
  z[lc++]="    return sizeof(void *);";
  z[lc++]="  case kAudioUnitProperty_MakeConnection: /* 1 */";
  z[lc++]="    return sizeof(AudioUnitConnection);";
  z[lc++]="  case kAudioUnitProperty_SampleRate: /* 2 */";
  z[lc++]="    return sizeof(Float64);";
  z[lc++]="  case kAudioUnitProperty_ParameterList: /* 3 */ ";
  z[lc++]="    return asysn_audiounit_PropertySizeWildCard;  ";
  z[lc++]="  case kAudioUnitProperty_ParameterInfo: /* 4 */ ";
  z[lc++]="    return sizeof(AudioUnitParameterInfo);  ";
  z[lc++]="  case kAudioUnitProperty_FastDispatch: /* 5 */ ";
  z[lc++]="    /* sizeof(void *), but we always want printing */";
  z[lc++]="    return asysn_audiounit_PropertySizeWildCard;  ";
  z[lc++]="  case kAudioUnitProperty_CPULoad:      /* 6 */";
  z[lc++]="    return sizeof(Float32);";
  z[lc++]="  case kAudioUnitProperty_StreamFormat: /* 8 */ ";
  z[lc++]="    return sizeof(AudioStreamBasicDescription);";
  z[lc++]="  case kAudioUnitProperty_SRCAlgorithm: /* 9 */";
  z[lc++]="    return sizeof(OSType);";
  z[lc++]="  case kAudioUnitProperty_ReverbRoomType: /* 10 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kAudioUnitProperty_ElementCount: /* 11, also kAudioUnitProperty_BusCount */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kAudioUnitProperty_Latency: /* 12 */";
  z[lc++]="    return sizeof(Float64);";
  z[lc++]="  case kAudioUnitProperty_SupportedNumChannels: /* 13 */";
  z[lc++]="    return asysn_audiounit_PropertySizeWildCard;  ";
  z[lc++]="  case kAudioUnitProperty_MaximumFramesPerSlice: /* 14 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kAudioUnitProperty_SetExternalBuffer: /* 15 */";
  z[lc++]="    return sizeof(AudioUnitExternalBuffer);";
  z[lc++]="  case kAudioUnitProperty_ParameterValueStrings: /* 16 */";
  z[lc++]="    return sizeof(CFArrayRef);";
  z[lc++]="  case kAudioUnitProperty_MIDIControlMapping: /* 17 */ ";
  z[lc++]="    return asysn_audiounit_PropertySizeWildCard;";
  z[lc++]="  case kAudioUnitProperty_GetUIComponentList: /* 18 */";
  z[lc++]="    return asysn_audiounit_PropertySizeWildCard;";
  z[lc++]="  case kAudioUnitProperty_AudioChannelLayout: /* 19 */";
  z[lc++]="    /* AudioChannelLayout, variable length */  ";
  z[lc++]="    return asysn_audiounit_PropertySizeWildCard;";
  z[lc++]="  case kAudioUnitProperty_TailTime: /* 20 */";
  z[lc++]="    return sizeof(Float64);";
  z[lc++]="  case kAudioUnitProperty_BypassEffect: /* 21 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kAudioUnitProperty_LastRenderError: /* 22 */";
  z[lc++]="    return sizeof(OSStatus);";
  z[lc++]="  case kAudioUnitProperty_SetRenderCallback: /* 23 */";
  z[lc++]="    return sizeof(AURenderCallbackStruct);";
  z[lc++]="  case kAudioUnitProperty_FactoryPresets: /* 24 */ ";
  z[lc++]="    return sizeof(CFArrayRef);  ";
  z[lc++]="  case kAudioUnitProperty_ContextName: /* 25 */";
  z[lc++]="    return sizeof(CFStringRef);";
  z[lc++]="  case kAudioUnitProperty_RenderQuality: /* 26 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kAudioUnitProperty_HostCallbacks: /* 27 */";
  z[lc++]="    return sizeof(HostCallbackInfo);";
  z[lc++]="  case kAudioUnitProperty_CurrentPreset: /* 28 */";
  z[lc++]="    return sizeof(AUPreset);";
  z[lc++]="  case kAudioUnitProperty_InPlaceProcessing: /* 29 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kAudioUnitProperty_ElementName: /* 30 */";
  z[lc++]="    return sizeof(CFStringRef);";
  z[lc++]="  case kAudioUnitProperty_CocoaUI: /* 31 */";
  z[lc++]="    /* AudioUnitCocoaViewInfo, variable length */";
  z[lc++]="    return asysn_audiounit_PropertySizeWildCard;";
  z[lc++]="  case kAudioUnitProperty_SupportedChannelLayoutTags: /* 32 */";
  z[lc++]="    /* AudioChannelLayoutTags[kVariableLengthArray] */";
  z[lc++]="    return asysn_audiounit_PropertySizeWildCard;";
  z[lc++]="  case kAudioUnitProperty_ParameterStringFromValue: /* 33 */";
  z[lc++]="    /* also kAudioUnitProperty_ParameterValueName */";
  z[lc++]="    return sizeof(AudioUnitParameterStringFromValue);";
  z[lc++]="  case kAudioUnitProperty_ParameterIDName: /* 34 */";
  z[lc++]="    return sizeof(AudioUnitParameterIDName);";
  z[lc++]="  case kAudioUnitProperty_ParameterClumpName: /* 35 */";
  z[lc++]="    return sizeof(AudioUnitParameterIDName);";
  z[lc++]="  case kAudioUnitProperty_PresentPreset: /* 36 */";
  z[lc++]="    return sizeof(AUPreset);";
  z[lc++]="  case kAudioUnitProperty_OfflineRender: /* 37 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kAudioUnitProperty_ParameterValueFromString: /* 38 */";
  z[lc++]="    return sizeof(AudioUnitParameterValueFromString);";
  z[lc++]="  case kAudioUnitProperty_IconLocation: /* 39 */";
  z[lc++]="    return sizeof(CFURLRef);";
  z[lc++]="  case kAudioUnitProperty_PresentationLatency: /* 40 */";
  z[lc++]="    return sizeof(Float64);";
  z[lc++]="  case kAudioUnitProperty_AllParameterMIDIMappings: /* 41 */";
  z[lc++]="    /* array of AUParameterMIDIMapping */";
  z[lc++]="    return asysn_audiounit_PropertySizeWildCard;";
  z[lc++]="  case kAudioUnitProperty_AddParameterMIDIMapping: /* 42 */";
  z[lc++]="    /* array of AUParameterMIDIMapping */";
  z[lc++]="    return asysn_audiounit_PropertySizeWildCard;";
  z[lc++]="  case kAudioUnitProperty_RemoveParameterMIDIMapping: /* 43 */";
  z[lc++]="    /* array of AUParameterMIDIMapping */";
  z[lc++]="    return asysn_audiounit_PropertySizeWildCard;";
  z[lc++]="  case kAudioUnitProperty_HotMapParameterMIDIMapping: /* 44 */";
  z[lc++]="    /* one AUParameterMIDIMapping or NULL */";
  z[lc++]="    return asysn_audiounit_PropertySizeWildCard;";
  z[lc++]="  case kAudioUnitProperty_DependentParameters: /* 45 */";
  z[lc++]="    /* array of AUDependentParameter */";
  z[lc++]="    return asysn_audiounit_PropertySizeWildCard;";
  z[lc++]="  case kMusicDeviceProperty_InstrumentCount: /* 1000 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kMusicDeviceProperty_InstrumentName: /* 1001 */";
  z[lc++]="    return sizeof(char *);";
  z[lc++]="  case kMusicDeviceProperty_GroupOutputBus: /* 1002 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kMusicDeviceProperty_SoundBankFSSpec: /* 1003 */";
  z[lc++]="    return sizeof(FSSpec);";
  z[lc++]="  case kMusicDeviceProperty_InstrumentNumber: /* 1004 */";
  z[lc++]="    return sizeof(MusicDeviceInstrumentID);";
  z[lc++]="  case kMusicDeviceProperty_UsesInternalReverb: /* 1005 */ ";
  z[lc++]="    /* also kAudioUnitProperty_UsesInternalReverb */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kMusicDeviceProperty_MIDIXMLNames: /* 1006 */";
  z[lc++]="    return sizeof(CFURLRef);";
  z[lc++]="  case kMusicDeviceProperty_BankName: /* 1007 */";
  z[lc++]="    return sizeof(CFStringRef);";
  z[lc++]="  case kMusicDeviceProperty_SoundBankData: /* 1008 */";
  z[lc++]="    return asysn_audiounit_PropertySizeWildCard;";
  z[lc++]="  case kMusicDeviceProperty_PartGroup: /* 1010 */";
  z[lc++]="    return sizeof(AudioUnitElement);";
  z[lc++]="  case kMusicDeviceProperty_StreamFromDisk: /* 1011 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kMusicDeviceProperty_SoundBankFSRef: /* 1012 */";
  z[lc++]="    return sizeof(FSRef);";
  z[lc++]="  case kAudioOutputUnitProperty_CurrentDevice: /* 2000 */";
  z[lc++]="    return sizeof(AudioDeviceID);";
  z[lc++]="  case kAudioOutputUnitProperty_IsRunning: /* 2001 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kAudioOutputUnitProperty_ChannelMap: /* 2002 */";
  z[lc++]="    /* variable-length array of SInt32 */ ";
  z[lc++]="    return asysn_audiounit_PropertySizeWildCard;";
  z[lc++]="  case kAudioOutputUnitProperty_EnableIO: /* 2003 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kAudioOutputUnitProperty_StartTime: /* 2004 */";
  z[lc++]="    return sizeof(AudioOutputUnitStartAtTimeParams);";
  z[lc++]="  case kAudioOutputUnitProperty_SetInputCallback: /* 2005 */";
  z[lc++]="    return sizeof(AURenderCallbackStruct);";
  z[lc++]="  case kAudioOutputUnitProperty_HasIO: /* 2006 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kAudioOutputUnitProperty_StartTimestampsAtZero: /* 2007 */ ";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kAudioUnitProperty_SpatializationAlgorithm: /* 3000 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kAudioUnitProperty_SpeakerConfiguration: /* 3001 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kAudioUnitProperty_DopplerShift: /* 3002 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kAudioUnitProperty_3DMixerRenderingFlags: /* 3003 */";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAudioUnitProperty_3DMixerDistanceAtten: /* 3004 */";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAudioUnitProperty_MatrixLevels: /* 3006 */";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAudioUnitProperty_MeteringMode: /* 3007 */";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="#if (0)  /* depreciated */";
  z[lc++]="  case kAudioUnitProperty_PannerMode: /* 3008 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="#endif";
  z[lc++]="  case kAudioUnitProperty_MatrixDimensions: /* 3009 */";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAudioUnitProperty_3DMixerDistanceParams: /* 3010 */";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAudioUnitProperty_MeterClipping: /* 3011 */ ";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAudioOfflineUnitProperty_InputSize: /* 3020 */";
  z[lc++]="    return sizeof(UInt64);";
  z[lc++]="  case kAudioOfflineUnitProperty_OutputSize: /* 3021 */";
  z[lc++]="    return sizeof(UInt64);";
  z[lc++]="  case kAudioUnitOfflineProperty_StartOffset: /* 3022 */";
  z[lc++]="    return sizeof(UInt64);";
  z[lc++]="  case kAudioUnitOfflineProperty_PreflightRequirements: /* 3023 */";
  z[lc++]="    return sizeof(UInt32);";
  z[lc++]="  case kAudioUnitOfflineProperty_PreflightName: /* 3024 */";
  z[lc++]="    return sizeof(CFStringRef);";
  z[lc++]="  case kAudioUnitProperty_ScheduleAudioSlice: /* 3300 */	";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAudioUnitProperty_ScheduleStartTimeStamp: /* 3301 */ ";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAudioUnitProperty_CurrentPlayTime: /* 3302 */ ";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAudioUnitProperty_ScheduledFileIDs: /* 3310 */	";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAudioUnitProperty_ScheduledFileRegion: /* 3311 */  ";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAudioUnitProperty_ScheduledFilePrime: /* 3312 */   ";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAudioUnitProperty_ScheduledFileBufferSizeFrames: /* 3313 */";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAudioUnitProperty_ScheduledFileNumberBuffers: /* 3314 */	";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAudioUnitProperty_DeferredRendererPullSize: /* 3320 */	";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAudioUnitProperty_DeferredRendererExtraLatency: /* 3321 */  ";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAudioUnitProperty_DeferredRendererWaitFrames: /* 3322 */	";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAUNetReceiveProperty_Hostname: /* 3511 */";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAUNetReceiveProperty_Password: /* 3512 */";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAUNetSendProperty_PortNum: /* 3513 */";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAUNetSendProperty_TransmissionFormat: /* 3514 */";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAUNetSendProperty_TransmissionFormatIndex: /* 3515 */";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAUNetSendProperty_ServiceName: /* 3516 */";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAUNetSendProperty_Disconnect: /* 3517 */";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAUNetSendProperty_Password: /* 3518 */";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;";
  z[lc++]="  case kAudioUnitMigrateProperty_FromPlugin: /* 4000 */";
  z[lc++]="    return sizeof(CFArrayRef);";
  z[lc++]="  case kAudioUnitMigrateProperty_OldAutomation: /* 4001 */";
  z[lc++]="    return sizeof(AudioUnitParameterValueTranslation);";
  z[lc++]="  default:";
  z[lc++]="    return asysn_audiounit_PropertySizeUnknown;  ";
  z[lc++]="  }";
  z[lc++]="} ";
  z[lc++]="";
  z[lc++]="/**********************************************************************/";
  z[lc++]="/* error-checks property size value: return status (0 == size match)  */";
  z[lc++]="/**********************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_print_propertysize_check(AudioUnitPropertyID id, UInt32 datasize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int expected = asysn_audiounit_expected_property_size(id);";
  z[lc++]="";
  z[lc++]="  if (expected == asysn_audiounit_PropertySizeUnknown) ";
  z[lc++]="    return 1;          ";
  z[lc++]="";
  z[lc++]="  if ((expected != asysn_audiounit_PropertySizeWildCard) && (datasize != expected))";
  z[lc++]="    {";
  z[lc++]="      fprintf(asysn_audiounit_logfile, ";
  z[lc++]="	      \"\\n\\tWARNING: Expected property data size %i, actual size %i\",";
  z[lc++]="	      expected, datasize);";
  z[lc++]="      return 1;";
  z[lc++]="    }";
  z[lc++]="  return 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* Property-Specific Print Routines */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/************************************************/";
  z[lc++]="/*    Helper for kAudioUnitProperty_ClassInfo   */";
  z[lc++]="/*      Reads integer item from a ClassInfo     */";
  z[lc++]="/************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_wiretap_classinfo_readint(CFMutableDictionaryRef ClassInfo, ";
  z[lc++]="				      char * ckey, SInt32 * value)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  CFStringRef key;";
  z[lc++]="  CFNumberRef num;";
  z[lc++]="  SInt32 newval;";
  z[lc++]="  int errcode = -1;";
  z[lc++]="";
  z[lc++]="  key = CFStringCreateWithCString(NULL, ckey, kCFStringEncodingASCII);";
  z[lc++]="  if (key)";
  z[lc++]="    {";
  z[lc++]="      num = CFDictionaryGetValue(ClassInfo, key);";
  z[lc++]="      if (num && CFNumberGetValue(num, kCFNumberSInt32Type, &newval))";
  z[lc++]="	{";
  z[lc++]="	  errcode = 0;";
  z[lc++]="	  *value = newval;";
  z[lc++]="	}";
  z[lc++]="      CFRelease(key);";
  z[lc++]="    }";
  z[lc++]="  return errcode;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/************************************************/";
  z[lc++]="/*    Helper for kAudioUnitProperty_ClassInfo   */";
  z[lc++]="/*      Reads float item from a ClassInfo       */";
  z[lc++]="/************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_wiretap_classinfo_readfloat(CFMutableDictionaryRef ClassInfo, ";
  z[lc++]="					char * ckey, Float32 * value)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  CFStringRef key;";
  z[lc++]="  CFNumberRef num;";
  z[lc++]="  Float32 newval;";
  z[lc++]="  int errcode = -1;";
  z[lc++]="";
  z[lc++]="  key = CFStringCreateWithCString(NULL, ckey, kCFStringEncodingASCII);";
  z[lc++]="  if (key)";
  z[lc++]="    {";
  z[lc++]="      num = CFDictionaryGetValue(ClassInfo, key);";
  z[lc++]="      if (num && CFNumberGetValue(num, kCFNumberFloat32Type, &newval))";
  z[lc++]="	{";
  z[lc++]="	  errcode = 0;";
  z[lc++]="	  *value = newval;";
  z[lc++]="	}";
  z[lc++]="      CFRelease(key);";
  z[lc++]="    }";
  z[lc++]="  return errcode;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/************************************************/";
  z[lc++]="/*    Helper for kAudioUnitProperty_ClassInfo   */";
  z[lc++]="/*      Reads CFString item from a ClassInfo    */";
  z[lc++]="/************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_audiounit_wiretap_classinfo_readcfstr(CFMutableDictionaryRef ClassInfo, ";
  z[lc++]="					char * ckey, CFStringRef * cfstr)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  CFStringRef key;";
  z[lc++]="  CFNumberRef num;";
  z[lc++]="  CFStringRef newstr;";
  z[lc++]="  int errcode = -1;";
  z[lc++]="";
  z[lc++]="  key = CFStringCreateWithCString(NULL, ckey, kCFStringEncodingASCII);";
  z[lc++]="  if (key)";
  z[lc++]="    {";
  z[lc++]="      if (newstr = CFDictionaryGetValue(ClassInfo, key))";
  z[lc++]="	{";
  z[lc++]="	  errcode = 0;";
  z[lc++]="	  CFRetain(newstr);";
  z[lc++]="	  if (*cfstr)";
  z[lc++]="	    CFRelease(*cfstr);";
  z[lc++]="	  *cfstr = newstr;";
  z[lc++]="	}";
  z[lc++]="      CFRelease(key);";
  z[lc++]="    }";
  z[lc++]="  return errcode;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/************************************************/";
  z[lc++]="/*    Helper for kAudioUnitProperty_ClassInfo   */";
  z[lc++]="/*  Big-endian int read from a CFMutableDataRef */";
  z[lc++]="/************************************************/";
  z[lc++]="";
  z[lc++]="SInt32 asysn_audiounit_wiretap_classinfo_pdata_intread(CFMutableDataRef pdata, UInt8 ** p)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  SInt32 value;";
  z[lc++]="  ";
  z[lc++]="  value = ((*p)[0] << 24) | ((*p)[1] << 16) | ((*p)[2] << 8) | ((*p)[3]);";
  z[lc++]="  (*p) += 4;";
  z[lc++]="  return value;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/**************************************************/";
  z[lc++]="/*     Helper for kAudioUnitProperty_ClassInfo    */";
  z[lc++]="/*  Big-endian float read from a CFMutableDataRef */";
  z[lc++]="/**************************************************/";
  z[lc++]="";
  z[lc++]="Float32 asysn_audiounit_wiretap_classinfo_pdata_floatread(CFMutableDataRef pdata, UInt8 ** p)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  union { SInt32 i; Float32 f ; } u;";
  z[lc++]="";
  z[lc++]="  u.i = ((*p)[0] << 24) | ((*p)[1] << 16) | ((*p)[2] << 8) | ((*p)[3]);";
  z[lc++]="  (*p) += 4;";
  z[lc++]="  return u.f;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/**************************************/";
  z[lc++]="/*  kAudioUnitProperty_ClassInfo      */";
  z[lc++]="/*                                    */";
  z[lc++]="/* *data is a CFPropertyListRef       */";
  z[lc++]="/*                                    */";
  z[lc++]="/**************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_property_ClassInfo(CFMutableDictionaryRef * data)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  CFStringRef cfstr;";
  z[lc++]="  char * nptr, * cstr = NULL;";
  z[lc++]="  CFStringRef key;";
  z[lc++]="  SInt32 value;";
  z[lc++]="  Float32 fval;";
  z[lc++]="  UInt32 scope, bus, count, idx;";
  z[lc++]="  CFMutableDataRef pdata;";
  z[lc++]="  UInt8 * p, * pmax;";
  z[lc++]="  float * pval = NULL;";
  z[lc++]="  int i, pval_size = 0;";
  z[lc++]="  char c[4];";
  z[lc++]="";
  z[lc++]="  if (*data == NULL)";
  z[lc++]="    {";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tA null preset\"); ";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (CFGetTypeID(*data) != CFDictionaryGetTypeID())";
  z[lc++]="    {";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tA preset dictionary with a bad type\"); ";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (asysn_audiounit_wiretap_classinfo_readint(*data, kAUPresetVersionKey, &value))";
  z[lc++]="    {";
  z[lc++]="      fprintf(asysn_audiounit_logfile, ";
  z[lc++]="	      \"\\n\\tA preset dictionary without a valid version field\"); ";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    if (value)";
  z[lc++]="      {";
  z[lc++]="	fprintf(asysn_audiounit_logfile, ";
  z[lc++]="		\"\\n\\tA preset dictionary with a bad version number\"); ";
  z[lc++]="	return;";
  z[lc++]="      }";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tA preset for \"); ";
  z[lc++]="";
  z[lc++]="  if (!asysn_audiounit_wiretap_classinfo_readint(*data, kAUPresetTypeKey, (SInt32 *) c))";
  z[lc++]="    {";
  z[lc++]="      if (ASYS_AUDIOUNIT_SINT32_BIGENDIAN)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"%c%c%c%c \", c[0], c[1], c[2], c[3]); ";
  z[lc++]="      else";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"%c%c%c%c \", c[3], c[2], c[1], c[0]); ";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!asysn_audiounit_wiretap_classinfo_readint(*data, kAUPresetSubtypeKey, (SInt32 *) c))";
  z[lc++]="    {";
  z[lc++]="      if (ASYS_AUDIOUNIT_SINT32_BIGENDIAN)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"%c%c%c%c \", c[0], c[1], c[2], c[3]); ";
  z[lc++]="      else";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"%c%c%c%c \", c[3], c[2], c[1], c[0]); ";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!asysn_audiounit_wiretap_classinfo_readint(*data, kAUPresetManufacturerKey, (SInt32 *) c))";
  z[lc++]="    {";
  z[lc++]="      if (ASYS_AUDIOUNIT_SINT32_BIGENDIAN)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"%c%c%c%c \", c[0], c[1], c[2], c[3]); ";
  z[lc++]="      else";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"%c%c%c%c \", c[3], c[2], c[1], c[0]); ";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  key = CFStringCreateWithCString(NULL, kAUPresetDataKey, kCFStringEncodingASCII);";
  z[lc++]="";
  z[lc++]="  if (key && (pdata = (CFMutableDataRef) CFDictionaryGetValue(*data, key)))";
  z[lc++]="    {";
  z[lc++]="      p = (UInt8 *) CFDataGetBytePtr(pdata);";
  z[lc++]="      pmax = p + CFDataGetLength(pdata);";
  z[lc++]="";
  z[lc++]="      do {";
  z[lc++]="	if (p == pmax)";
  z[lc++]="	  break;";
  z[lc++]="	if ((pmax - p) >= 12)";
  z[lc++]="	  {";
  z[lc++]="	    scope = asysn_audiounit_wiretap_classinfo_pdata_intread(pdata, &p);";
  z[lc++]="	    bus = asysn_audiounit_wiretap_classinfo_pdata_intread(pdata, &p);";
  z[lc++]="	    count = asysn_audiounit_wiretap_classinfo_pdata_intread(pdata, &p);";
  z[lc++]="	    fprintf(asysn_audiounit_logfile, \"\\n\\t%u parameters for scope %u, \"";
  z[lc++]="		    \"element %u:\", count, scope, bus);";
  z[lc++]="	    if ((pmax - p) >= count*(sizeof(SInt32) + sizeof(Float32)))";
  z[lc++]="	      {";
  z[lc++]="		pval = calloc(count, sizeof(float));";
  z[lc++]="		pval_size = count;";
  z[lc++]="		while (count--)";
  z[lc++]="		  {";
  z[lc++]="		    idx = asysn_audiounit_wiretap_classinfo_pdata_intread(pdata, &p);";
  z[lc++]="		    fval = asysn_audiounit_wiretap_classinfo_pdata_floatread(pdata, &p);";
  z[lc++]="		    fprintf(asysn_audiounit_logfile, \"\\n\\tP[%u] = %g\", idx, fval);";
  z[lc++]="		    if ((idx >= 0) && (idx < pval_size))";
  z[lc++]="		      pval[idx] = fval;";
  z[lc++]="		  }";
  z[lc++]="	      }";
  z[lc++]="	    else";
  z[lc++]="	      {";
  z[lc++]="		fprintf(asysn_audiounit_logfile, \"\\n\\tCorrupt data structure\");";
  z[lc++]="		break;";
  z[lc++]="	      }";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  {";
  z[lc++]="	    fprintf(asysn_audiounit_logfile, \"\\n\\tCorrupt data structure\");";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="      } while (1);";
  z[lc++]="      ";
  z[lc++]="      CFRelease(key);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  cfstr = NULL;";
  z[lc++]="";
  z[lc++]="  if (!asysn_audiounit_wiretap_classinfo_readcfstr(*data, kAUPresetNameKey, &cfstr))";
  z[lc++]="    {";
  z[lc++]="      cstr = calloc(CFStringGetLength(cfstr) + 1, 1);";
  z[lc++]="      CFStringGetCString(cfstr, cstr, CFStringGetLength(cfstr) + 1, ";
  z[lc++]="			 kCFStringEncodingASCII);";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tPreset Name: %s\", cstr);";
  z[lc++]="      CFRelease(cfstr);    /* keep cstr to print out factory table */";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!asysn_audiounit_wiretap_classinfo_readint(*data, kAUPresetRenderQualityKey, ";
  z[lc++]="					 (SInt32 *) &value))";
  z[lc++]="    {";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tRender Quality: \"); ";
  z[lc++]="      switch (value) {";
  z[lc++]="      case 127:";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"Maximum (127)\");";
  z[lc++]="	break;";
  z[lc++]="      case 96:";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"High (96)\");";
  z[lc++]="	break;";
  z[lc++]="      case 64:";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"Medium (64)\");";
  z[lc++]="	break;";
  z[lc++]="      case 32:";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"Low (32)\");";
  z[lc++]="	break;";
  z[lc++]="      case 0:";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"Minimum (0)\");";
  z[lc++]="	break;";
  z[lc++]="      default:";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"%u \", value);";
  z[lc++]="      }";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (!asysn_audiounit_wiretap_classinfo_readfloat(*data, kAUPresetCPULoadKey, &fval))";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tCPU Load: %g\", fval);";
  z[lc++]="";
  z[lc++]="  if (cstr)";
  z[lc++]="    {";
  z[lc++]="      if (pval)";
  z[lc++]="	{";
  z[lc++]="	  nptr = cstr;";
  z[lc++]="	  do {";
  z[lc++]="	    if (*nptr == ' ')";
  z[lc++]="	      *nptr = '_';";
  z[lc++]="	  } while (*(++nptr));";
  z[lc++]="	  fprintf(asysn_audiounit_logfile, ";
  z[lc++]="		  \"\\n\\ttable aup_factory_%s(data, %i\", cstr, pval_size);";
  z[lc++]="	  for (i = 0; i < pval_size; i++)";
  z[lc++]="	    fprintf(asysn_audiounit_logfile, \", %g\", pval[i]);";
  z[lc++]="	  fprintf(asysn_audiounit_logfile, \");\\n\\t\");";
  z[lc++]="	  free(pval);";
  z[lc++]="	}";
  z[lc++]="      free(cstr);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* add kAUPresetElementNameKey here if named elements/buses are supported */";
  z[lc++]="";
  z[lc++]="  return;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/**************************************/";
  z[lc++]="/*  kAudioUnitProperty_ParameterList  */";
  z[lc++]="/*                                    */";
  z[lc++]="/* An array of                        */";
  z[lc++]="/* UInt32 AudioUnitParameterID        */";
  z[lc++]="/*                                    */";
  z[lc++]="/**************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_property_ParameterList(AudioUnitParameterID * data,";
  z[lc++]="					    UInt32 datasize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned int i;";
  z[lc++]="";
  z[lc++]="  if (datasize)";
  z[lc++]="    for (i = 0; i < datasize/sizeof(UInt32); i++)";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tParameterID %i\", data[i]);";
  z[lc++]="  else";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tEmpty parameter list\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*****************************************/";
  z[lc++]="/*  kAudioUnitProperty_ParameterInfo     */";
  z[lc++]="/*                                       */";
  z[lc++]="/* element specifies the parameter       */";
  z[lc++]="/* *data holds AudioUnitParameterInfo    */";
  z[lc++]="/*                                       */";
  z[lc++]="/* char                    name[60];     */";
  z[lc++]="/* CFStringRef             cfNameString; */";
  z[lc++]="/* AudioUnitParameterUnit  unit;         */";
  z[lc++]="/* Float32                 minValue;     */";
  z[lc++]="/* Float32                 maxValue;     */";
  z[lc++]="/* Float32                 defaultValue; */";
  z[lc++]="/* UInt32                  flags;        */";
  z[lc++]="/*                                       */";
  z[lc++]="/*****************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_property_ParameterInfo(AudioUnitParameterInfo * data,";
  z[lc++]="						  UInt32 element)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  CFIndex slen;";
  z[lc++]="  char * cstr;";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tParameter info for element %u\", element);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tName: %s\", data->name);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tUnits: \");";
  z[lc++]="  asysn_audiounit_print_parameter_units(data->unit);";
  z[lc++]="";
  z[lc++]="  if (data->unit == kAudioUnitParameterUnit_CustomUnit)";
  z[lc++]="    {";
  z[lc++]="      if (data->unitName)";
  z[lc++]="	{";
  z[lc++]="	  slen = CFStringGetLength(data->unitName) + 1;";
  z[lc++]="	  cstr = calloc(slen, 1);";
  z[lc++]="	  CFStringGetCString(data->unitName, cstr, slen, kCFStringEncodingASCII);";
  z[lc++]="	  fprintf(asysn_audiounit_logfile, \"\\n\\tCustom Unit: %s\", cstr);";
  z[lc++]="	  free(cstr);";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tCustom Unit: <null>\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tMinimum value: %g\", data->minValue);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tDefault value: %g\", data->defaultValue);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tMaximum value: %g\", data->maxValue);";
  z[lc++]="";
  z[lc++]="  if (data->flags)";
  z[lc++]="    {";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_Global)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: global\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_Input)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: input\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_Output)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: output\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_Group) ";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: group\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_CFNameRelease)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: CF-name-release\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_MeterReadOnly)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: meter-read-only\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_DisplaySquareRoot)	";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: display-square-root\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_DisplaySquared)	";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: display-squared\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_DisplayCubed)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: display-cubed\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_DisplayCubeRoot)	";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: display-cube-root\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_DisplayExponential)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: display-exponential\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_HasClump)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: has-clump\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_HasName)	";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: has-name\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_ValuesHaveStrings)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: values-have-strings\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_DisplayLogarithmic)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: display-logarithmic\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_IsHighResolution)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: high-resolution\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_NonRealTime)	";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: non-real-time\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_CanRamp)	";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: can-ramp\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_ExpertMode) 		";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: expert-mode\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_HasCFNameString) 	";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: has-CF-name-string\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_IsGlobalMeta)	";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: global-meta\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_IsElementMeta)		";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: element-meta\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_IsReadable)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: readable\");";
  z[lc++]="      if (data->flags & kAudioUnitParameterFlag_IsWritable)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tFlag: writable\");";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/************************************/";
  z[lc++]="/*  kAudioUnitProperty_FastDispatch */";
  z[lc++]="/*                                  */";
  z[lc++]="/* *data points to the function     */";
  z[lc++]="/* that handles selector \"element\"  */";
  z[lc++]="/*                                  */";
  z[lc++]="/************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_property_FastDispatch(int element, int * data)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tDispatch route for selector \");";
  z[lc++]="  asysn_audiounit_print_selector_name(element);";
  z[lc++]="  if ((*data) == 0)";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tReturns a NULL function pointer \");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/************************************/";
  z[lc++]="/*  kAudioUnitProperty_StreamFormat */";
  z[lc++]="/*                                  */";
  z[lc++]="/*  *data points to an              */";
  z[lc++]="/*  AudioStreamBasicDescription:    */ ";
  z[lc++]="/*                                  */";
  z[lc++]="/*  Float64 mSampleRate;            */";
  z[lc++]="/*  UInt32  mFormatID;              */";
  z[lc++]="/*  UInt32  mFormatFlags;           */";
  z[lc++]="/*  UInt32  mBytesPerPacket;        */";
  z[lc++]="/*  UInt32  mFramesPerPacket;       */";
  z[lc++]="/*  UInt32  mBytesPerFrame;         */";
  z[lc++]="/*  UInt32  mChannelsPerFrame;      */";
  z[lc++]="/*  UInt32  mBitsPerChannel;        */";
  z[lc++]="/*  UInt32  mReserved;              */";
  z[lc++]="/*                                  */";
  z[lc++]="/* (line 117, CoreAudioTypes.h)     */";
  z[lc++]="/*                                  */";
  z[lc++]="/************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_property_StreamFormat(AudioStreamBasicDescription * data)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (data->mSampleRate == kAudioStreamAnyRate)";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tmSampleRate: kAudioStreamAnyRate\"); ";
  z[lc++]="  else";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tmSampleRate: %lg Hz\", data->mSampleRate);";
  z[lc++]="";
  z[lc++]="  if (data->mFormatID == kAudioFormatLinearPCM)";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tmFormatID: kAudioFormatLinearPCM\"); ";
  z[lc++]="  else";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tmFormatID: Compressed Format %i\", ";
  z[lc++]="	    data->mFormatID);";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tmFormatFlags: \");";
  z[lc++]="";
  z[lc++]="  if (data->mFormatFlags & kAudioFormatFlagIsFloat)";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"Float \");";
  z[lc++]="";
  z[lc++]="  if (data->mFormatFlags & kAudioFormatFlagIsBigEndian)";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"BigEndian \");";
  z[lc++]="";
  z[lc++]="  if (data->mFormatFlags & kAudioFormatFlagIsSignedInteger)";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"SignedInteger \");";
  z[lc++]="";
  z[lc++]="  if (data->mFormatFlags & kAudioFormatFlagIsPacked)";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"Packed \");";
  z[lc++]="";
  z[lc++]="  if (data->mFormatFlags & kAudioFormatFlagIsAlignedHigh)";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"AlignedHigh \");";
  z[lc++]="";
  z[lc++]="  if (data->mFormatFlags & kAudioFormatFlagIsNonInterleaved)";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"NonInterleaved \");";
  z[lc++]="";
  z[lc++]="  if (data->mFormatFlags & kAudioFormatFlagIsNonMixable)";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"NonMixable \");";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tmBytesPerPacket: %u\", ";
  z[lc++]="	  data->mBytesPerPacket); ";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tmFramesPerPacket: %u\", ";
  z[lc++]="	  data->mFramesPerPacket);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tmBytesPerFrame: %u\", ";
  z[lc++]="	  data->mBytesPerFrame);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tmChannelsPerFrame: %u\", ";
  z[lc++]="	  data->mChannelsPerFrame);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tmBitsPerChannel: %u\", ";
  z[lc++]="	  data->mBitsPerChannel);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tmReserved: %u\", ";
  z[lc++]="	  data->mReserved);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/********************************************/";
  z[lc++]="/*  kAudioUnitProperty_SupportedNumChannels */";
  z[lc++]="/*                                          */";
  z[lc++]="/* An array of                              */";
  z[lc++]="/* UInt32 AUChannelInfo                     */";
  z[lc++]="/*                                          */";
  z[lc++]="/********************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_property_SupportedNumChannels(AUChannelInfo * data,";
  z[lc++]="					    UInt32 datasize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned int i;";
  z[lc++]="";
  z[lc++]="  if (datasize)";
  z[lc++]="    for (i = 0; i < datasize/sizeof(AUChannelInfo); i++)";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tFormat %i: in = %i/out = %i\", ";
  z[lc++]="	      i, data[i].inChannels, data[i].outChannels);";
  z[lc++]="  else";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tEmpty supported format list\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************/";
  z[lc++]="/*  kAudioUnitProperty_ParameterValueStrings */";
  z[lc++]="/*                                           */";
  z[lc++]="/* *data points to the CFArrayRef holding    */";
  z[lc++]="/* value strings for parameter \"element\"     */";
  z[lc++]="/*                                           */";
  z[lc++]="/*********************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_property_ParameterValueStrings(CFArrayRef * data)";
  z[lc++]="{";
  z[lc++]="  CFArrayRef array;";
  z[lc++]="  CFStringRef cfstr;";
  z[lc++]="  CFIndex asize, slen, i;";
  z[lc++]="  char * cstr;";
  z[lc++]="  ";
  z[lc++]="  if ((array = *((CFArrayRef *) data)) && (asize = CFArrayGetCount(array)))";
  z[lc++]="    {";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tParameter strings:\");";
  z[lc++]="      for (i = 0; i < asize; i++)";
  z[lc++]="	if (cfstr = CFArrayGetValueAtIndex(array, i))";
  z[lc++]="	  {";
  z[lc++]="	    slen = CFStringGetLength(cfstr) + 1;";
  z[lc++]="	    cstr = calloc(slen, 1);";
  z[lc++]="	    CFStringGetCString(cfstr, cstr, slen, kCFStringEncodingASCII);";
  z[lc++]="	    fprintf(asysn_audiounit_logfile, \"\\n\\t%i: %s\", i, cstr);";
  z[lc++]="	    CFRelease(cfstr);";
  z[lc++]="	    free(cstr);";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  fprintf(asysn_audiounit_logfile, \"\\n\\t%i: <non-existent string>\", i);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tNull CFArrayRef or empty CFArray\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/**************************************/";
  z[lc++]="/*  kAudioUnitProperty_FactoryPresets */";
  z[lc++]="/*                                    */";
  z[lc++]="/* *data is a CFArrayRef              */";
  z[lc++]="/* array elements are AUPresets       */";
  z[lc++]="/*                                    */";
  z[lc++]="/* struct AUPreset {                  */";
  z[lc++]="/*  SInt32       presetNumber;        */";
  z[lc++]="/*  CFStringRef  presetName;          */";
  z[lc++]="/* };                                 */";
  z[lc++]="/*                                    */";
  z[lc++]="/**************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_property_FactoryPresets(CFArrayRef * data)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  CFArrayRef array;";
  z[lc++]="  AUPreset * preset;";
  z[lc++]="  CFIndex asize, slen, i;";
  z[lc++]="  char * cstr;";
  z[lc++]="";
  z[lc++]="  if ((array = *((CFArrayRef *) data)) && (asize = CFArrayGetCount(array)))";
  z[lc++]="    {";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tFactory presets:\");";
  z[lc++]="      for (i = 0; i < asize; i++)";
  z[lc++]="	if (preset = (AUPreset *) CFArrayGetValueAtIndex(array, i))";
  z[lc++]="	  {";
  z[lc++]="	    slen = CFStringGetLength(preset->presetName) + 1;";
  z[lc++]="	    cstr = calloc(slen, 1);";
  z[lc++]="	    CFStringGetCString(preset->presetName, cstr, slen, kCFStringEncodingASCII);";
  z[lc++]="	    fprintf(asysn_audiounit_logfile, \"\\n\\t%i: %s\", preset->presetNumber, cstr);";
  z[lc++]="	    free(cstr);";
  z[lc++]="	  }";
  z[lc++]="	else";
  z[lc++]="	  fprintf(asysn_audiounit_logfile, \"\\n\\t%i: <non-existent preset>\", i);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tNull CFArrayRef or empty CFArray\");";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*******************************************/";
  z[lc++]="/*  kAudioUnitProperty_CocoaUI             */";
  z[lc++]="/*                                         */";
  z[lc++]="/* An AudioUnitCocoaViewInfo               */";
  z[lc++]="/*                                         */";
  z[lc++]="/* typedef struct AudioUnitCocoaViewInfo { */";
  z[lc++]="/* CFURLRef  mCocoaAUViewBundleLocation;   */";
  z[lc++]="/* CFStringRef mCocoaAUViewClass[1];       */";
  z[lc++]="/* };                                      */";
  z[lc++]="/*                                         */";
  z[lc++]="/*******************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_property_CocoaViewInfo(AudioUnitCocoaViewInfo * data,";
  z[lc++]="						  UInt32 datasize)";
  z[lc++]="{";
  z[lc++]="  unsigned char url_cstring[4096];";
  z[lc++]="  CFStringRef cfstr;";
  z[lc++]="  char * cstr;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  if ((data->mCocoaAUViewBundleLocation) &&";
  z[lc++]="      (CFURLGetFileSystemRepresentation(data->mCocoaAUViewBundleLocation, ";
  z[lc++]="					true, &(url_cstring[0]), 4096)))";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"URL: %s\", url_cstring);";
  z[lc++]="  else";
  z[lc++]="    if (data->mCocoaAUViewBundleLocation)";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"URL is > 4095 chars.\");";
  z[lc++]="    else";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"URL is null.\");";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < (datasize - sizeof(CFURLRef))/sizeof(CFStringRef); i++)";
  z[lc++]="    if ((cfstr = data->mCocoaAUViewClass[i]))";
  z[lc++]="      {";
  z[lc++]="	cstr = calloc(CFStringGetLength(cfstr) + 1, 1);";
  z[lc++]="	CFStringGetCString(cfstr, cstr, CFStringGetLength(cfstr) + 1, ";
  z[lc++]="			   kCFStringEncodingASCII);";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \"\\n\\tClass (%i): %s\", i, cstr);";
  z[lc++]="	free(cstr);";
  z[lc++]="      }";
  z[lc++]="    else";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tClass (%i) is a null string.\", i);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* The Main Property Print Routine */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/****************************/";
  z[lc++]="/* prints out property data */";
  z[lc++]="/****************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_property_data(AudioUnitPropertyID id, AudioUnitScope scope,";
  z[lc++]="					 AudioUnitElement element, UInt32 datasize,";
  z[lc++]="					 void * data)";
  z[lc++]="{";
  z[lc++]="  char name[256];      ";
  z[lc++]="  int namesize = 255;   /* paranoia: 256 probably would work OK ... */";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\t\");";
  z[lc++]="  asysn_audiounit_print_scope_name(scope);";
  z[lc++]="";
  z[lc++]="  switch(id) {                           /* Print element/bus info */";
  z[lc++]="  default:";
  z[lc++]="    if (element)                         /* skip default to reduce clutter */ ";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tElement %i\", element);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_FastDispatch:   /* skip element print for these properties */";
  z[lc++]="  case kAudioUnitProperty_ParameterInfo: ";
  z[lc++]="  case kAudioUnitProperty_MakeConnection: ";
  z[lc++]="  case kMusicDeviceProperty_InstrumentName:";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  if (asysn_audiounit_print_propertysize_check(id, datasize))  ";
  z[lc++]="    return;               /* can we print *data ? if not return early */";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\t\");";
  z[lc++]="";
  z[lc++]="  switch(id) {  /* print property data structures */";
  z[lc++]="  case kAudioUnitProperty_ClassInfo: /* 0 */";
  z[lc++]="    asysn_audiounit_print_property_ClassInfo((CFMutableDictionaryRef *) data);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_MakeConnection: /* 1 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, ";
  z[lc++]="	    \"\\n\\tConnection from output %u of AU %u to input bus %u%s\", ";
  z[lc++]="	    ((AudioUnitConnection *) data)->sourceOutputNumber,";
  z[lc++]="	    ((AudioUnitConnection *) data)->sourceAudioUnit,";
  z[lc++]="	    ((AudioUnitConnection *) data)->destInputNumber,";
  z[lc++]="	    (((AudioUnitConnection *) data)->destInputNumber != element) ? ";
  z[lc++]="	    \" (mismatch with element)\" : \"\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SampleRate: /* 2 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tA Sample rate is %lf Hz\", ";
  z[lc++]="	    *((Float64 *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterList: /* 3 */";
  z[lc++]="    asysn_audiounit_print_property_ParameterList((AudioUnitParameterID *) data,";
  z[lc++]="					   datasize);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterInfo: /* 4 */ ";
  z[lc++]="    asysn_audiounit_print_property_ParameterInfo((AudioUnitParameterInfo *) data,";
  z[lc++]="					   element);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_FastDispatch: /* 5 */";
  z[lc++]="    asysn_audiounit_print_property_FastDispatch(element, (int *) data);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_CPULoad: /* 6 */ ";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tCPULoad value is %g\", *((Float32 *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_StreamFormat: /* 8 */ ";
  z[lc++]="    asysn_audiounit_print_property_StreamFormat((AudioStreamBasicDescription *) data);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SRCAlgorithm: /* 9 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tSRC algorithm is '%c%c%c%c'\", ";
  z[lc++]="	    ((char *) data)[0], ((char *) data)[1], ";
  z[lc++]="	    ((char *) data)[2], ((char *) data)[3]);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ReverbRoomType: /* 10 */";
  z[lc++]="    switch (*((UInt32 *)data)) {";
  z[lc++]="    case kReverbRoomType_SmallRoom:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tSmallRoom\");";
  z[lc++]="      break;";
  z[lc++]="    case kReverbRoomType_MediumRoom:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tMediumRoom\");";
  z[lc++]="      break;";
  z[lc++]="    case kReverbRoomType_LargeRoom:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tLargeRoom\");";
  z[lc++]="      break;";
  z[lc++]="    case kReverbRoomType_MediumHall:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tMediumHall\");";
  z[lc++]="      break;";
  z[lc++]="    case kReverbRoomType_LargeHall:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tLargeHall\");";
  z[lc++]="      break;";
  z[lc++]="    case kReverbRoomType_Plate:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tPlate\");";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ElementCount: /* 11, also kAudioUnitProperty_BusCount */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tBusCount/ElementCount value is %u\", ";
  z[lc++]="	    *((UInt32 *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_Latency: /* 12 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tLatency value is %lfs\", *((Float64 *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SupportedNumChannels: /* 13 */";
  z[lc++]="    asysn_audiounit_print_property_SupportedNumChannels((AUChannelInfo *) data,";
  z[lc++]="					   datasize);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_MaximumFramesPerSlice: /* 14 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tMaximumFramesPerSlice value is %u\", ";
  z[lc++]="	    *((UInt32 *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SetExternalBuffer: /* 15 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tBuffer size: %u bytes\", ";
  z[lc++]="	    ((AudioUnitExternalBuffer *) data)->size);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterValueStrings: /* 16 */";
  z[lc++]="    asysn_audiounit_print_property_ParameterValueStrings((CFArrayRef *) data);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_MIDIControlMapping: /* 17 */ ";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tArray of %i MIDI control mappings\",";
  z[lc++]="	    datasize/sizeof(AudioUnitMIDIControlMapping));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_GetUIComponentList: /* 18 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, ";
  z[lc++]="	    \"\\n\\tArray of %i user-interface component instances\",";
  z[lc++]="	    datasize/sizeof(ComponentInstance));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_AudioChannelLayout: /* 19 */  ";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tLayout data for multi-channel audio\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_TailTime: /* 20 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tTail time is %lfs\", *((Float64 *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_BypassEffect: /* 21 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tAudio is %s\", ";
  z[lc++]="	    *((UInt32 *) data) ? \"bypassed\" : \"not-bypassed\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_LastRenderError: /* 22 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tLast error code was %i\",  ";
  z[lc++]="	    *((OSStatus *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SetRenderCallback: /* 23 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tFunction address %u, data object address %u\", ";
  z[lc++]="	    (UInt32)(((AURenderCallbackStruct *) data)->inputProc),";
  z[lc++]="	    (UInt32)(((AURenderCallbackStruct *) data)->inputProcRefCon));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_FactoryPresets: /* 24 */";
  z[lc++]="    asysn_audiounit_print_property_FactoryPresets((CFArrayRef *) data);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ContextName: /* 25 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\t%sCFStringRef for a context name\",";
  z[lc++]="	    *((CFStringRef *) data) == NULL ? \"Null-ptr \" : \"\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_RenderQuality: /* 26 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tRenderQuality value is %u\", ";
  z[lc++]="	    *((UInt32 *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_HostCallbacks: /* 27 */";
  z[lc++]="    if (((HostCallbackInfo *) data)->beatAndTempoProc)";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tOffering GetBeatAndTempo callback\");";
  z[lc++]="    if (((HostCallbackInfo *) data)->musicalTimeLocationProc)";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tOffering GetMusicalTimeLocation callback\");";
  z[lc++]="    if (((HostCallbackInfo *) data)->transportStateProc)";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tOffering GetTransportStateProc callback\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_CurrentPreset: /* 28 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tCurrent preset index is %i\", ";
  z[lc++]="	    *((SInt32 *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_InPlaceProcessing: /* 29 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tInPlaceProcessing value is %s\", ";
  z[lc++]="	    *((UInt32 *) data) ? \"on\" : \"off\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ElementName: /* 30 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\t%sCFStringRef for an element name\",";
  z[lc++]="	    *((CFStringRef *) data) == NULL ? \"Null-ptr \" : \"\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_CocoaUI: /* 31 */";
  z[lc++]="    asysn_audiounit_print_property_CocoaViewInfo((AudioUnitCocoaViewInfo *) data,";
  z[lc++]="						 datasize);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SupportedChannelLayoutTags: /* 32 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, ";
  z[lc++]="	    \"\\n\\tInformation about multi-channel audio layouts\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterStringFromValue: /* 33 */";
  z[lc++]="    /* also kAudioUnitProperty_ParameterValueName */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tString for value %g for Parameter ID %u\", ";
  z[lc++]="	    *(((AudioUnitParameterValueName *) data)->inValue),";
  z[lc++]="	    ((AudioUnitParameterValueName *) data)->inParamID);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterIDName: /* 34 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tExtended naming info for a parameter\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterClumpName: /* 35 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tExtended naming info for a parameter clump\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_PresentPreset: /* 36 */";
  z[lc++]="    if (CFStringGetCString(((AUPreset *) data)->presetName, name, ";
  z[lc++]="			   namesize, kCFStringEncodingASCII))";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tCurrent preset is %s (%i)\", ";
  z[lc++]="	      name, ((AUPreset *) data)->presetNumber);";
  z[lc++]="    else";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tCurrent preset is %i\", ";
  z[lc++]="	      ((AUPreset *) data)->presetNumber);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_OfflineRender: /* 37 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tOffline rendering is %s\", ";
  z[lc++]="	    *((UInt32 *) data) ? \"on\" : \"off\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ParameterValueFromString: /* 38 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tString for value %g for Parameter ID %u\", ";
  z[lc++]="	    ((AudioUnitParameterValueFromString *) data)->outValue,";
  z[lc++]="	    ((AudioUnitParameterValueFromString *) data)->inParamID);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_IconLocation: /* 39 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\t%sCFURLRef for an icon location\",";
  z[lc++]="	    *((CFURLRef *) data) == NULL ? \"Null-ptr \" : \"\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_PresentationLatency: /* 40 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tPresentation latency is %lg\", ";
  z[lc++]="	    *((Float64 *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_AllParameterMIDIMappings: /* 41 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tMIDI mapping data structures\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_AddParameterMIDIMapping: /* 42 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tMIDI mapping data structures\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_RemoveParameterMIDIMapping: /* 43 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tMIDI mapping data structures\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_HotMapParameterMIDIMapping: /* 44 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tMIDI mapping data structures\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_DependentParameters: /* 45 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tMIDI mapping data structures\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_InstrumentCount: /* 1000 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tNumber of instruments: %u\", ";
  z[lc++]="	    *((UInt32 *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_InstrumentName: /* 1001 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tInstrument name for %u: %s\", element, ";
  z[lc++]="	    *((char **) data));";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_GroupOutputBus: /* 1002 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tOutput bus for group %u: %u\", element, ";
  z[lc++]="	    *((UInt32 *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_SoundBankFSSpec: /* 1003 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tPointer to a SoundBank file\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_InstrumentNumber: /* 1004 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tInstrument index %u has ID %u\", element, ";
  z[lc++]="	    *((MusicDeviceInstrumentID *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_UsesInternalReverb: /* 1005 */ ";
  z[lc++]="    /* also kAudioUnitProperty_UsesInternalReverb */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tInternal reverb is %s\", ";
  z[lc++]="	    *((UInt32 *) data) ? \"in use\" : \"not in use\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_MIDIXMLNames: /* 1006 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\t%sCFURLRef for a MIDI XML file\",";
  z[lc++]="	    *((CFURLRef *) data) == NULL ? \"Null-ptr \" : \"\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_BankName: /* 1007 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\t%sCFStringRef for an bank name\",";
  z[lc++]="	    *((CFStringRef *) data) == NULL ? \"Null-ptr \" : \"\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_SoundBankData: /* 1008 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tPointer to an in-memory SoundBank\");";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_PartGroup: /* 1010 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tGroup IO for for part %u: %u\", element, ";
  z[lc++]="	    *((UInt32 *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_StreamFromDisk: /* 1011 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tStreamFromDisk value: %u\", ";
  z[lc++]="	    *((UInt32 *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceProperty_SoundBankFSRef: /* 1012 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tReference to a SoundBank file\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOutputUnitProperty_CurrentDevice: /* 2000 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tID of current device: %u\", ";
  z[lc++]="	    *((UInt32 *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOutputUnitProperty_IsRunning: /* 2001 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tDevice is%s running\",";
  z[lc++]="	    *((UInt32 *) data) ? \"\" : \" not\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOutputUnitProperty_ChannelMap: /* 2002 */ ";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tI/O channel map for an OutputUnit\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOutputUnitProperty_EnableIO: /* 2003 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\t%s for unit is %s\", ";
  z[lc++]="	    element ? \"Input\" : \"Output\",  ";
  z[lc++]="	    *((UInt32 *) data) ? \"enabled\" : \"disabled\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOutputUnitProperty_StartTime: /* 2004 */";
  z[lc++]="    if (((AudioOutputUnitStartAtTimeParams *) data)->mTimestamp.mFlags & ";
  z[lc++]="	kAudioTimeStampSampleTimeValid)";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tStart at sample time: %lg\", ";
  z[lc++]="	      ((AudioOutputUnitStartAtTimeParams *) data)->mTimestamp.mSampleTime);";
  z[lc++]="    if (((AudioOutputUnitStartAtTimeParams *) data)->mTimestamp.mFlags & ";
  z[lc++]="	kAudioTimeStampSampleTimeValid)";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tStart at host time: %lg\", ";
  z[lc++]="	      ((AudioOutputUnitStartAtTimeParams *) data)->mTimestamp.mHostTime);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOutputUnitProperty_SetInputCallback: /* 2005 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tCallback for new input from an Output Unit\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOutputUnitProperty_HasIO: /* 2006 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\t%s for unit is %s\", ";
  z[lc++]="	    element ? \"Input\" : \"Output\",  ";
  z[lc++]="	    *((UInt32 *) data) ? \"available\" : \"not available\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOutputUnitProperty_StartTimestampsAtZero: /* 2007 */ ";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tTimestamps start %s\",";
  z[lc++]="	    *((UInt32 *) data) ? \"at zero\" : \"reflects HAL timestamps\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SpatializationAlgorithm: /* 3000 */";
  z[lc++]="    switch (*((UInt32 *)data)) {";
  z[lc++]="    case kSpatializationAlgorithm_EqualPowerPanning:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tEqual Power Panning\");";
  z[lc++]="      break;";
  z[lc++]="    case kSpatializationAlgorithm_SphericalHead:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tSpherical Head\");";
  z[lc++]="      break;";
  z[lc++]="    case kSpatializationAlgorithm_HRTF:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tHRTF\");";
  z[lc++]="      break;";
  z[lc++]="    case kSpatializationAlgorithm_SoundField:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tSound Field\");";
  z[lc++]="      break;";
  z[lc++]="    case kSpatializationAlgorithm_VectorBasedPanning:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tVector-Based Panning\");";
  z[lc++]="      break;";
  z[lc++]="    case kSpatializationAlgorithm_StereoPassThrough:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tStereo Pass Through\");";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_SpeakerConfiguration: /* 3001 */";
  z[lc++]="    switch (*((UInt32 *)data)) {";
  z[lc++]="    case kSpeakerConfiguration_HeadPhones: ";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tHeadPhones\");";
  z[lc++]="      break;";
  z[lc++]="    case kSpeakerConfiguration_Stereo: ";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tStereo\");";
  z[lc++]="      break;";
  z[lc++]="    case kSpeakerConfiguration_Quad:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tQuad\");";
  z[lc++]="      break;";
  z[lc++]="    case  kSpeakerConfiguration_5_0:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\t5.0/5.1 speaker setup\");";
  z[lc++]="      break;";
  z[lc++]="    }";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_DopplerShift: /* 3002 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tDoppler shift is %s\",";
  z[lc++]="	    *((UInt32 *) data) ? \"on\" : \"off\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_3DMixerRenderingFlags: /* 3003 */";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_3DMixerDistanceAtten: /* 3004 */";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_MatrixLevels: /* 3006 */";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_MeteringMode: /* 3007 */";
  z[lc++]="    break;";
  z[lc++]="#if (0)      /* depreciated */";
  z[lc++]="  case kAudioUnitProperty_PannerMode: /* 3008 */";
  z[lc++]="    switch (*((UInt32 *)data)) {";
  z[lc++]="    case kPannerMode_Normal:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tPassThru\");";
  z[lc++]="      break;    ";
  z[lc++]="    case kPannerMode_FaderMode:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tFader\");";
  z[lc++]="      break;    ";
  z[lc++]="    case 2:   /* kPannerMode_Panner */";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tPanner\");";
  z[lc++]="      break;    ";
  z[lc++]="    }";
  z[lc++]="    break;";
  z[lc++]="#endif";
  z[lc++]="  case kAudioUnitProperty_MatrixDimensions: /* 3009 */";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_3DMixerDistanceParams: /* 3010 */";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_MeterClipping: /* 3011 */ ";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOfflineUnitProperty_InputSize: /* 3020 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tInput size is %llu\", *((UInt64 *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioOfflineUnitProperty_OutputSize: /* 3021 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tOutput size is %llu\", *((UInt64 *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitOfflineProperty_StartOffset: /* 3022 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tStart offset is is %llu\", ";
  z[lc++]="	    *((UInt64 *) data));";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitOfflineProperty_PreflightRequirements: /* 3023 */";
  z[lc++]="    switch (*((UInt32 *)data)) {";
  z[lc++]="    case kOfflinePreflight_NotRequired:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tNot Required\");";
  z[lc++]="      break;    ";
  z[lc++]="    case kOfflinePreflight_Optional:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tOptional\");";
  z[lc++]="      break;    ";
  z[lc++]="    case kOfflinePreflight_Required:";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tRequired\");";
  z[lc++]="      break;    ";
  z[lc++]="    }";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitOfflineProperty_PreflightName: /* 3024 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\t%sCFStringRef for an pre-flight name\",";
  z[lc++]="	    *((CFStringRef *) data) == NULL ? \"Null-ptr \" : \"\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ScheduleAudioSlice: /* 3300 */	";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ScheduleStartTimeStamp: /* 3301 */ ";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_CurrentPlayTime: /* 3302 */ ";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ScheduledFileIDs: /* 3310 */	";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ScheduledFileRegion: /* 3311 */  ";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ScheduledFilePrime: /* 3312 */   ";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ScheduledFileBufferSizeFrames: /* 3313 */";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_ScheduledFileNumberBuffers: /* 3314 */	";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_DeferredRendererPullSize: /* 3320 */	";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_DeferredRendererExtraLatency: /* 3321 */  ";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitProperty_DeferredRendererWaitFrames: /* 3322 */	";
  z[lc++]="    break;";
  z[lc++]="  case kAUNetReceiveProperty_Hostname: /* 3511 */";
  z[lc++]="    break;";
  z[lc++]="  case kAUNetReceiveProperty_Password: /* 3512 */";
  z[lc++]="    break;";
  z[lc++]="  case kAUNetSendProperty_PortNum: /* 3513 */";
  z[lc++]="    break;";
  z[lc++]="  case kAUNetSendProperty_TransmissionFormat: /* 3514 */";
  z[lc++]="    break;";
  z[lc++]="  case kAUNetSendProperty_TransmissionFormatIndex: /* 3515 */";
  z[lc++]="    break;";
  z[lc++]="  case kAUNetSendProperty_ServiceName: /* 3516 */";
  z[lc++]="    break;";
  z[lc++]="  case kAUNetSendProperty_Disconnect: /* 3517 */";
  z[lc++]="    break;";
  z[lc++]="  case kAUNetSendProperty_Password: /* 3518 */";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitMigrateProperty_FromPlugin: /* 4000 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\t%sCFArrayRef of plug-in conversion data\",";
  z[lc++]="	    *((CFArrayRef *) data) == NULL ? \"Null-ptr \" : \"\");";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitMigrateProperty_OldAutomation: /* 4001 */";
  z[lc++]="    fprintf(asysn_audiounit_logfile, ";
  z[lc++]="	    \"\\n\\tAutomation data for plug-in format conversion\");";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    break;";
  z[lc++]="  }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* Selector-Specific Print Routines */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="/*************************************/";
  z[lc++]="/* kComponentOpenSelect              */";
  z[lc++]="/*                                   */";
  z[lc++]="/*  params[0]: ComponentInstance ci  */";
  z[lc++]="/*                                   */";
  z[lc++]="/*************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kComponentOpenSelect(ComponentParameters * p, ";
  z[lc++]="						ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tFor # %u.  %i instance(s) now open\", ";
  z[lc++]="	  (unsigned) (p->params[0]), asysn_audiounit_opencount);";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*************************************/";
  z[lc++]="/* kComponentCloseSelect             */";
  z[lc++]="/*                                   */";
  z[lc++]="/*  params[0]: ComponentInstance ci  */";
  z[lc++]="/*                                   */";
  z[lc++]="/*************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kComponentCloseSelect(ComponentParameters * p, ";
  z[lc++]="						 ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tFor instance # %u.  %i instance(s) remain open\",";
  z[lc++]="	   (unsigned) (p->params[0]), asysn_audiounit_opencount);";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*************************************/";
  z[lc++]="/* kAudioUnitInitializeSelect        */";
  z[lc++]="/*                                   */";
  z[lc++]="/*************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kAudioUnitInitializeSelect(ComponentParameters * p, ";
  z[lc++]="						      ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*************************************/";
  z[lc++]="/* kAudioUnitUninitializeSelect      */";
  z[lc++]="/*                                   */";
  z[lc++]="/*************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kAudioUnitUninitializeSelect(ComponentParameters * p, ";
  z[lc++]="							ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/********************************************/";
  z[lc++]="/* kAudioUnitGetPropertyInfoSelect          */";
  z[lc++]="/*                                          */";
  z[lc++]="/*  params[0]: Boolean * outWritable;       */";
  z[lc++]="/*  params[1]: UInt32 * outDataSize;        */";
  z[lc++]="/*  params[2]: AudioUnitElement inElement;  */";
  z[lc++]="/*  params[3]: AudioUnitScope inScope;      */";
  z[lc++]="/*  params[4]: AudioUnitPropertyID inID;    */";
  z[lc++]="/*                                          */";
  z[lc++]="/********************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kAudioUnitGetPropertyInfoSelect(ComponentParameters * p, ";
  z[lc++]="							   ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tFor \"); ";
  z[lc++]="  asysn_audiounit_print_property_name(p->params[4]);";
  z[lc++]="  if ((p->params[0]) && (p->params[1]))";
  z[lc++]="    {";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\t%u byte %s property on bus %i, \", ";
  z[lc++]="	      *((UInt32 *)(p->params[1])), *((Boolean *)(p->params[0])) ? ";
  z[lc++]="	      \"writeable\" : \"read-only\", p->params[2]);";
  z[lc++]="      asysn_audiounit_print_scope_name(p->params[3]);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tNULL pointer(s) returned\");";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/********************************************/";
  z[lc++]="/* kAudioUnitGetPropertySelect              */";
  z[lc++]="/*                                          */";
  z[lc++]="/*  params[0]: UInt32 * ioDataSize;         */";
  z[lc++]="/*  params[1]: void * outData;              */";
  z[lc++]="/*  params[2]: AudioUnitElement inElement;  */";
  z[lc++]="/*  params[3]: AudioUnitScope inScope;      */";
  z[lc++]="/*  params[4]: AudioUnitPropertyID inID;    */";
  z[lc++]="/*                                          */";
  z[lc++]="/********************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kAudioUnitGetPropertySelect(ComponentParameters * p, ";
  z[lc++]="						       ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tFor \"); ";
  z[lc++]="  asysn_audiounit_print_property_name(p->params[4]);";
  z[lc++]="  asysn_audiounit_print_property_data(p->params[4], /* AudioUnitPropertyID id */ ";
  z[lc++]="		      p->params[3],                   /* AudioUnitScope scope */";
  z[lc++]="		      p->params[2],               /* AudioUnitElement element */";
  z[lc++]="		      *((UInt32 *)((void *)(p->params[0]))), /* UInt32 datasize */";
  z[lc++]="		      (void *)(p->params[1]));               /* void * data */";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/********************************************/";
  z[lc++]="/* kAudioUnitSetPropertySelect              */";
  z[lc++]="/*                                          */";
  z[lc++]="/*  params[0]: UInt32 inDataSize;           */";
  z[lc++]="/*  params[1]: const void * inData;         */";
  z[lc++]="/*  params[2]: AudioUnitElement inElement;  */";
  z[lc++]="/*  params[3]: AudioUnitScope inScope;      */";
  z[lc++]="/*  params[4]: AudioUnitPropertyID inID;    */";
  z[lc++]="/*                                          */";
  z[lc++]="/********************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kAudioUnitSetPropertySelect(ComponentParameters * p, ";
  z[lc++]="						       ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tFor \"); ";
  z[lc++]="  asysn_audiounit_print_property_name(p->params[4]);";
  z[lc++]="  asysn_audiounit_print_property_data(p->params[4], /* AudioUnitPropertyID id */ ";
  z[lc++]="				      p->params[3], /* AudioUnitScope scope */";
  z[lc++]="				      p->params[2], /* AudioUnitElement element */ ";
  z[lc++]="				      p->params[0], /* UInt32 datasize */";
  z[lc++]="				      (void *)(p->params[1]));  /* void * data */";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*****************************************************/";
  z[lc++]="/* kAudioUnitAddPropertyListenerSelect               */";
  z[lc++]="/*                                                   */";
  z[lc++]="/*  params[0]: void * inProcRefCon;                  */";
  z[lc++]="/*  params[1]: AudioUnitPropertyListenerProc inProc; */";
  z[lc++]="/*  params[2]: AudioUnitPropertyID inID;             */";
  z[lc++]="/*                                                   */";
  z[lc++]="/* The caller passes in a function inProc to call    */";
  z[lc++]="/* the AU changes the property, and an object        */ ";
  z[lc++]="/* inProcRefCon to pass to the function.             */";
  z[lc++]="/*****************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kAudioUnitAddPropertyListenerSelect";
  z[lc++]="(ComponentParameters * p, ComponentResult returncode)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tFor \"); ";
  z[lc++]="  asysn_audiounit_print_property_name(p->params[2]);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \", faddr %u\", (UInt32) (p->params[1])); ";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \", caddr %u\", (UInt32) (p->params[0])); ";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*****************************************************/";
  z[lc++]="/* kAudioUnitRemovePropertyListenerSelect            */";
  z[lc++]="/*                                                   */";
  z[lc++]="/*  params[0]: AudioUnitPropertyListenerProc inProc; */";
  z[lc++]="/*  params[1]: AudioUnitPropertyID inID;             */";
  z[lc++]="/*                                                   */";
  z[lc++]="/* Instructs the AudioUnit to stop calling the       */";
  z[lc++]="/* inProc for the specified property inID.           */";
  z[lc++]="/*****************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kAudioUnitRemovePropertyListenerSelect";
  z[lc++]="(ComponentParameters * p, ComponentResult returncode)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tFor \"); ";
  z[lc++]="  asysn_audiounit_print_property_name(p->params[1]);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \", function address %u\", (UInt32) (p->params[0])); ";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*************************************/";
  z[lc++]="/* kAudioUnitAddRenderNotifySelect   */";
  z[lc++]="/*                                   */";
  z[lc++]="/*  params[0]: void * inProcRefCon;  */";
  z[lc++]="/*  params[1]: ProcPtr inProc;       */";
  z[lc++]="/*                                   */";
  z[lc++]="/*************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kAudioUnitAddRenderNotifySelect";
  z[lc++]="(ComponentParameters * p, ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************/";
  z[lc++]="/* kAudioUnitRemoveRenderNotifySelect   */";
  z[lc++]="/*                                      */";
  z[lc++]="/*  params[0]: void * inProcRefCon;     */";
  z[lc++]="/*  params[1]: ProcPtr inProc;          */";
  z[lc++]="/*                                      */";
  z[lc++]="/****************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kAudioUnitRemoveRenderNotifySelect";
  z[lc++]="(ComponentParameters * p, ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*******************************************/";
  z[lc++]="/* kAudioUnitGetParameterSelect            */";
  z[lc++]="/*                                         */";
  z[lc++]="/* params[0]: Float32 * outValue           */";
  z[lc++]="/* params[1]: AudioUnitElement inElement   */";
  z[lc++]="/* params[2]: AudioUnitScope inScope       */";
  z[lc++]="/* params[3]: AudioUnitParameterID inID    */";
  z[lc++]="/*                                         */";
  z[lc++]="/*******************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kAudioUnitGetParameterSelect(ComponentParameters * p, ";
  z[lc++]="							ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tParameter \"); ";
  z[lc++]="  asysn_audiounit_print_parameter_name(p->params[3]);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \" value is %g\", *((Float32 *)(p->params[0])));";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\t\"); ";
  z[lc++]="  asysn_audiounit_print_scope_name(p->params[2]);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \", element %i\", p->params[1]); ";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************/";
  z[lc++]="/* kAudioUnitSetParameterSelect              */";
  z[lc++]="/*                                           */";
  z[lc++]="/* params[0]: UInt32 inBufferOffsetInFrames  */";
  z[lc++]="/* params[1]: Float32 inValue                */";
  z[lc++]="/* params[2]: AudioUnitElement inElement     */";
  z[lc++]="/* params[3]: AudioUnitScope inScope;        */";
  z[lc++]="/* params[4]: AudioUnitParameterID inID;     */";
  z[lc++]="/*                                           */";
  z[lc++]="/*********************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kAudioUnitSetParameterSelect(ComponentParameters * p, ";
  z[lc++]="							ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tParameter \"); ";
  z[lc++]="  asysn_audiounit_print_parameter_name(p->params[4]);";
  z[lc++]="";
  z[lc++]="  /* todo: verify endian-ness correctness */";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \" value is %g\", ";
  z[lc++]="	  *((Float32 *)((unsigned char *)(&(p->params[1])))));";
  z[lc++]="";
  z[lc++]="  if (p->params[0])";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \" (frame offset %u)\", (UInt32)(p->params[0]));";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\t\"); ";
  z[lc++]="  asysn_audiounit_print_scope_name(p->params[3]);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \", element %i\", p->params[2]); ";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/***************************************************************/";
  z[lc++]="/* kAudioUnitScheduleParametersSelect                          */";
  z[lc++]="/*                                                             */";
  z[lc++]="/* params[0]: UInt32 inNumParamEvents;                         */";
  z[lc++]="/* params[1]: const AudioUnitParameterEvent* inParameterEvent; */";
  z[lc++]="/*                                                             */";
  z[lc++]="/***************************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kAudioUnitScheduleParametersSelect(ComponentParameters * p, ";
  z[lc++]="							      ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tScheduling %u updates \", ";
  z[lc++]="	  (UInt32)(p->params[0])); ";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/**********************************************************/";
  z[lc++]="/* kAudioUnitRenderSelect                                 */";
  z[lc++]="/*                                                        */";
  z[lc++]="/* params[0]: AudioBufferList * ioData;                   */";
  z[lc++]="/* params[1]: UInt32 inNumberFrames;                      */";
  z[lc++]="/* params[2]: UInt32 inOutputBusNumber;                   */";
  z[lc++]="/* params[3]: const AudioTimeStamp * inTimeStamp;         */";
  z[lc++]="/* params[4]: AudioUnitRenderActionFlags * ioActionFlags; */";
  z[lc++]="/*                                                        */";
  z[lc++]="/**********************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kAudioUnitRenderSelect(ComponentParameters * p, ";
  z[lc++]="						  ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*******************************************/";
  z[lc++]="/* kAudioUnitResetSelect                   */";
  z[lc++]="/*                                         */";
  z[lc++]="/*  params[0]: AudioUnitElement inElement; */";
  z[lc++]="/*  params[1]: AudioUnitScope inScope;     */";
  z[lc++]="/*                                         */";
  z[lc++]="/*******************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kAudioUnitResetSelect(ComponentParameters * p, ";
  z[lc++]="						 ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tIn \"); ";
  z[lc++]="  asysn_audiounit_print_scope_name(p->params[1]);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \", element %i\", p->params[0]); ";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/******************************************/";
  z[lc++]="/* kMusicDeviceMIDIEventSelect            */";
  z[lc++]="/*                                        */";
  z[lc++]="/*  params[3]: UInt32 inStatus            */";
  z[lc++]="/*  params[2]: UInt32 inData1             */";
  z[lc++]="/*  params[1]: UInt32 inData2             */";
  z[lc++]="/*  params[0]: UInt32 inOffsetSampleFrame */";
  z[lc++]="/*                                        */";
  z[lc++]="/******************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kMusicDeviceMIDIEventSelect(ComponentParameters * p, ";
  z[lc++]="						       ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  asysn_audiounit_print_midievent((unsigned char)((UInt32)(p->params[3])),";
  z[lc++]="		  (unsigned char)((UInt32)(p->params[2])),";
  z[lc++]="		  (unsigned char)((UInt32)(p->params[1])));";
  z[lc++]="  if (p->params[0])";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tOffset %u samples from buffer start\",";
  z[lc++]="	    (UInt32)(p->params[0])); ";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/**********************************/";
  z[lc++]="/* kMusicDeviceSysExSelect        */";
  z[lc++]="/*                                */";
  z[lc++]="/*  params[0]: UInt8 * inData     */";
  z[lc++]="/*  params[1]: UInt32 inLength    */";
  z[lc++]="/*    (order may be wrong)        */";
  z[lc++]="/**********************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kMusicDeviceSysExSelect(ComponentParameters * p, ";
  z[lc++]="						   ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\t%u-byte MIDI SysEx command\", ";
  z[lc++]="	  (UInt32)(p->params[1])); ";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************/";
  z[lc++]="/* kMusicDevicePrepareInstrumentSelect              */";
  z[lc++]="/*                                                  */";
  z[lc++]="/* params[0]: MusicDeviceInstrumentID inInstrument  */";
  z[lc++]="/*                                                  */";
  z[lc++]="/****************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kMusicDevicePrepareInstrumentSelect";
  z[lc++]="(ComponentParameters * p, ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tInstrument ID: %u\", ";
  z[lc++]="	  (UInt32)(p->params[0])); ";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************/";
  z[lc++]="/* kMusicDeviceReleaseInstrumentSelect              */";
  z[lc++]="/*                                                  */";
  z[lc++]="/* params[0]: MusicDeviceInstrumentID inInstrument  */";
  z[lc++]="/*                                                  */";
  z[lc++]="/****************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kMusicDeviceReleaseInstrumentSelect";
  z[lc++]="(ComponentParameters * p, ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tInstrument ID: %u\", (UInt32)(p->params[0])); ";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************/";
  z[lc++]="/* kMusicDeviceStartNoteSelect                      */";
  z[lc++]="/*                                                  */";
  z[lc++]="/*  params[0]: MusicDeviceInstrumentID inInstrument */";
  z[lc++]="/*  params[1]: MusicDeviceGroupID inGroupID         */";
  z[lc++]="/*  params[2]: NoteInstanceID * outNoteInstanceID   */";
  z[lc++]="/*  params[3]: UInt32 inOffsetSampleFrame           */";
  z[lc++]="/*  params[4]: MusicDeviceNoteParams * inParams     */";
  z[lc++]="/*          (order may be reversed)                 */";
  z[lc++]="/****************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kMusicDeviceStartNoteSelect(ComponentParameters * p, ";
  z[lc++]="						       ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tInstrument ID: %u\", (UInt32)(p->params[0])); ";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tGroup ID: %u\", (UInt32)(p->params[1])); ";
  z[lc++]="  if (p->params[3])";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tOffset %u samples from buffer start\",";
  z[lc++]="	    (UInt32)(p->params[3])); ";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************/";
  z[lc++]="/* kMusicDeviceStopNoteSelect                       */";
  z[lc++]="/*                                                  */";
  z[lc++]="/*  params[0]: MusicDeviceGroupID inGroupID         */";
  z[lc++]="/*  params[1]: NoteInstanceID * outNoteInstanceID   */";
  z[lc++]="/*  params[2]: UInt32 inOffsetSampleFrame           */";
  z[lc++]="/*         (order may be reversed)                  */";
  z[lc++]="/****************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_print_kMusicDeviceStopNoteSelect(ComponentParameters * p, ";
  z[lc++]="						      ComponentResult returncode)";
  z[lc++]="{";
  z[lc++]="  asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tInstrument ID: %u\", (UInt32)(p->params[0])); ";
  z[lc++]="  if (p->params[3])";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tOffset %u samples from buffer start\",";
  z[lc++]="	    (UInt32)(p->params[2])); ";
  z[lc++]="  asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="  asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/* The wiretap API calls */";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="";
  z[lc++]="#if (ASYS_AUDIOUNIT_DEBUG_LEVEL >= 1)";
  z[lc++]="";
  z[lc++]="/**************************************************/";
  z[lc++]="/* entry function for snooping on component calls */";
  z[lc++]="/**************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_wiretap(ComponentParameters * p, ComponentResult returncode)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asysn_audiounit_first_logfile_open) asysn_audiounit_logfile_initialize();";
  z[lc++]="  asysn_audiounit_logfile = fopen(ASYS_AUDIOUNIT_LOGFILE_NAME, \"a\");";
  z[lc++]="";
  z[lc++]="  switch (p->what) { /* jump table to routines for specific selectors */";
  z[lc++]="  case kComponentOpenSelect:";
  z[lc++]="    asysn_audiounit_print_kComponentOpenSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kComponentCloseSelect:";
  z[lc++]="    asysn_audiounit_print_kComponentCloseSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitInitializeSelect:";
  z[lc++]="    asysn_audiounit_print_kAudioUnitInitializeSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitUninitializeSelect:";
  z[lc++]="    asysn_audiounit_print_kAudioUnitUninitializeSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitGetPropertyInfoSelect:";
  z[lc++]="    asysn_audiounit_print_kAudioUnitGetPropertyInfoSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitGetPropertySelect:";
  z[lc++]="    asysn_audiounit_print_kAudioUnitGetPropertySelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitSetPropertySelect:";
  z[lc++]="    asysn_audiounit_print_kAudioUnitSetPropertySelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitAddPropertyListenerSelect:";
  z[lc++]="    asysn_audiounit_print_kAudioUnitAddPropertyListenerSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitRemovePropertyListenerSelect:";
  z[lc++]="    asysn_audiounit_print_kAudioUnitRemovePropertyListenerSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitAddRenderNotifySelect:";
  z[lc++]="    asysn_audiounit_print_kAudioUnitAddRenderNotifySelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitRemoveRenderNotifySelect:";
  z[lc++]="    asysn_audiounit_print_kAudioUnitRemoveRenderNotifySelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitGetParameterSelect:";
  z[lc++]="    asysn_audiounit_print_kAudioUnitGetParameterSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitSetParameterSelect:";
  z[lc++]="    asysn_audiounit_print_kAudioUnitSetParameterSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitScheduleParametersSelect:";
  z[lc++]="    asysn_audiounit_print_kAudioUnitScheduleParametersSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitRenderSelect:";
  z[lc++]="    asysn_audiounit_print_kAudioUnitRenderSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kAudioUnitResetSelect:";
  z[lc++]="    asysn_audiounit_print_kAudioUnitResetSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceMIDIEventSelect:";
  z[lc++]="    asysn_audiounit_print_kMusicDeviceMIDIEventSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceSysExSelect:";
  z[lc++]="    asysn_audiounit_print_kMusicDeviceSysExSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDevicePrepareInstrumentSelect:";
  z[lc++]="    asysn_audiounit_print_kMusicDevicePrepareInstrumentSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceReleaseInstrumentSelect:";
  z[lc++]="    asysn_audiounit_print_kMusicDeviceReleaseInstrumentSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceStartNoteSelect:";
  z[lc++]="    asysn_audiounit_print_kMusicDeviceStartNoteSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  case kMusicDeviceStopNoteSelect:";
  z[lc++]="    asysn_audiounit_print_kMusicDeviceStopNoteSelect(p, returncode);";
  z[lc++]="    break;";
  z[lc++]="  default:  /* the generic selector print routine */";
  z[lc++]="    asysn_audiounit_print_selector_name(p->what);";
  z[lc++]="    asysn_audiounit_print_nonzero_returncode(returncode);";
  z[lc++]="    asysn_audiounit_print_paramsize_check(p);";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \".\\n\\n\");";
  z[lc++]="  }";
  z[lc++]="  fclose(asysn_audiounit_logfile);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*************************************************/";
  z[lc++]="/* entry function for snooping on renderer calls */";
  z[lc++]="/*************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_wiretap_renderer(void * inComponentStorage,";
  z[lc++]="				      AudioUnitRenderActionFlags * ioActionFlags,";
  z[lc++]="				      const AudioTimeStamp * inTimeStamp,";
  z[lc++]="				      UInt32 inOutputBusNumber,";
  z[lc++]="				      UInt32 inNumberFrames,";
  z[lc++]="				      AudioBufferList * ioData)";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  if (asysn_audiounit_first_logfile_open) asysn_audiounit_logfile_initialize();";
  z[lc++]="  asysn_audiounit_logfile = fopen(ASYS_AUDIOUNIT_LOGFILE_NAME, \"a\");";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"Renderer report\"); ";
  z[lc++]="";
  z[lc++]="  if (inTimeStamp->mFlags & kAudioTimeStampSampleTimeValid)";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tSample time: %lg\", ";
  z[lc++]="	      inTimeStamp->mSampleTime); ";
  z[lc++]="  if (inTimeStamp->mFlags & kAudioTimeStampHostTimeValid)";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tHost time: %llu\", ";
  z[lc++]="	      inTimeStamp->mHostTime); ";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\t%u frames on output bus %u\", ";
  z[lc++]="	  inNumberFrames, inOutputBusNumber); ";
  z[lc++]="";
  z[lc++]="  if (*ioActionFlags)";
  z[lc++]="    {";
  z[lc++]="      fprintf(asysn_audiounit_logfile, \"\\n\\tFlags:\"); ";
  z[lc++]="      if ((*ioActionFlags) &  kAudioUnitRenderAction_PreRender)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \" PreRender\"); ";
  z[lc++]="      if ((*ioActionFlags) &  kAudioUnitRenderAction_PostRender)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \" PostRender\"); ";
  z[lc++]="      if ((*ioActionFlags) &  kAudioUnitRenderAction_OutputIsSilence)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \" OutputIsSilence\"); ";
  z[lc++]="      if ((*ioActionFlags) & kAudioOfflineUnitRenderAction_Preflight)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \" Preflight\");";
  z[lc++]="      if ((*ioActionFlags) & kAudioOfflineUnitRenderAction_Render)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \" Render\");";
  z[lc++]="      if ((*ioActionFlags) &kAudioOfflineUnitRenderAction_Complete)";
  z[lc++]="	fprintf(asysn_audiounit_logfile, \" Complete\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tmNumberBuffers: %u\", ioData->mNumberBuffers);";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < ioData->mNumberBuffers; i++)";
  z[lc++]="  fprintf(asysn_audiounit_logfile, ";
  z[lc++]="	  \"\\n\\t\\tBuffer %u has %u channel(s) of %u-ptr %u-byte waveforms\", ";
  z[lc++]="	  i, ioData->mBuffers[i].mNumberChannels, ";
  z[lc++]="	  (UInt32)(ioData->mBuffers[i].mData),";
  z[lc++]="	  ioData->mBuffers[i].mDataByteSize);";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\"); ";
  z[lc++]="  fclose(asysn_audiounit_logfile);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/**************************************************/";
  z[lc++]="/* entry function for snooping on midievent calls */";
  z[lc++]="/**************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_wiretap_midievent(void * inComponentStorage,";
  z[lc++]="				       UInt32 inStatus,";
  z[lc++]="				       UInt32 inData1,";
  z[lc++]="				       UInt32 inData2,";
  z[lc++]="				       UInt32 inOffsetSampleFrame, ";
  z[lc++]="				       char * type)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asysn_audiounit_first_logfile_open) asysn_audiounit_logfile_initialize();";
  z[lc++]="  asysn_audiounit_logfile = fopen(ASYS_AUDIOUNIT_LOGFILE_NAME, \"a\");";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"%s MIDI Event\", type);";
  z[lc++]="  asysn_audiounit_print_midievent((unsigned char)(inStatus), (unsigned char)(inData1),";
  z[lc++]="		  (unsigned char)(inData2));";
  z[lc++]="  if (inOffsetSampleFrame)";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \"\\n\\tOffset %u samples from buffer start\",";
  z[lc++]="	    inOffsetSampleFrame);";
  z[lc++]=" ";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\n\"); ";
  z[lc++]="  fclose(asysn_audiounit_logfile);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*****************************************************/";
  z[lc++]="/* entry function for snooping on getparameter calls */";
  z[lc++]="/*****************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_wiretap_getparameter(void * inComponentStorage,";
  z[lc++]="					  AudioUnitParameterID inID,";
  z[lc++]="					  AudioUnitScope inScope,";
  z[lc++]="					  AudioUnitElement inElement,";
  z[lc++]="					  Float32 * outValue,";
  z[lc++]="					  char * type)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  if (asysn_audiounit_first_logfile_open) asysn_audiounit_logfile_initialize();";
  z[lc++]="  asysn_audiounit_logfile = fopen(ASYS_AUDIOUNIT_LOGFILE_NAME, \"a\");";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"%s GetParameter Event\", type);";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tParameter \"); ";
  z[lc++]="  asysn_audiounit_print_parameter_name(inID);";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \" value is %g\", *outValue);";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\t\");";
  z[lc++]=" ";
  z[lc++]="  asysn_audiounit_print_scope_name(inScope);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \", element %i\", inElement); ";
  z[lc++]=" ";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\n\"); ";
  z[lc++]="  fclose(asysn_audiounit_logfile);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*****************************************************/";
  z[lc++]="/* entry function for snooping on setparameter calls */";
  z[lc++]="/*****************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_wiretap_setparameter(void * inComponentStorage,";
  z[lc++]="					  AudioUnitParameterID inID,";
  z[lc++]="					  AudioUnitScope inScope,";
  z[lc++]="					  AudioUnitElement inElement,";
  z[lc++]="					  Float32 inValue,";
  z[lc++]="					  UInt32 inBufferOffsetInFrames,";
  z[lc++]="					  char * type)";
  z[lc++]="     ";
  z[lc++]="{";
  z[lc++]="  if (asysn_audiounit_first_logfile_open) asysn_audiounit_logfile_initialize();";
  z[lc++]="  asysn_audiounit_logfile = fopen(ASYS_AUDIOUNIT_LOGFILE_NAME, \"a\");";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"%s SetParameter Event\", type);";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\tParameter \"); ";
  z[lc++]="  asysn_audiounit_print_parameter_name(inID);";
  z[lc++]="";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \" value is %g\", inValue);";
  z[lc++]="";
  z[lc++]="  if (inBufferOffsetInFrames)";
  z[lc++]="    fprintf(asysn_audiounit_logfile, \" (frame offset %u)\", inBufferOffsetInFrames);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\t\");";
  z[lc++]=" ";
  z[lc++]="  asysn_audiounit_print_scope_name(inScope);";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \", element %i\", inElement); ";
  z[lc++]=" ";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"\\n\\n\"); ";
  z[lc++]="  fclose(asysn_audiounit_logfile);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/******************************************/";
  z[lc++]="/* prints arbitrary string to the logfile */";
  z[lc++]="/******************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_wiretap_putstring(char * s)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asysn_audiounit_first_logfile_open) asysn_audiounit_logfile_initialize();";
  z[lc++]="  asysn_audiounit_logfile = fopen(ASYS_AUDIOUNIT_LOGFILE_NAME, \"a\");";
  z[lc++]="  fprintf(asysn_audiounit_logfile, \"%s\", s); ";
  z[lc++]="  fclose(asysn_audiounit_logfile);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*************************************/";
  z[lc++]="/* prints out a ComponentResult name */";
  z[lc++]="/*************************************/";
  z[lc++]="";
  z[lc++]="void asysn_audiounit_wiretap_print_component_result(ComponentResult returncode)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asysn_audiounit_first_logfile_open) asysn_audiounit_logfile_initialize();";
  z[lc++]="  asysn_audiounit_logfile = fopen(ASYS_AUDIOUNIT_LOGFILE_NAME, \"a\");";
  z[lc++]="  asysn_audiounit_print_returncode_name(returncode);";
  z[lc++]="  fclose(asysn_audiounit_logfile);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif  /* (ASYS_AUDIOUNIT_DEBUG_LEVEL >= 1) */";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*     End of wiretap logger for audiounit driver for sfront    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  printlib(lc);
}


