/* ScummVM - Scumm Interpreter
 * Copyright (C) 2001  Ludvig Strigeus
 * Copyright (C) 2001-2006 The ScummVM project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL: https://svn.sourceforge.net/svnroot/scummvm/scummvm/tags/release-0-9-1/base/commandLine.h $
 * $Id: commandLine.h 22397 2006-05-09 14:16:43Z sev $
 *
 */

#ifndef BASE_OPTIONS_H
#define BASE_OPTIONS_H

#include "common/str.h"
#include "common/config-manager.h"

namespace Base {

void registerDefaults();
Common::String parseCommandLine(Common::StringMap &settings, int argc, char **argv);
bool processSettings(Common::String &command, Common::StringMap &settings);

} // End of namespace Base

#endif
