/* ScummVM - Scumm Interpreter
 * Copyright (C) 2001-2006 The ScummVM project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL: https://svn.sourceforge.net/svnroot/scummvm/scummvm/tags/release-0-9-1/backends/maemo/maemo-sdl.cpp $
 * $Id: maemo-sdl.cpp 22919 2006-06-04 19:44:47Z sev $
 *
 */

#include "common/stdafx.h"
#include "backends/maemo/maemo-sdl.h"


void OSystem_MAEMO::loadGFXMode() {
	if (_fullscreen || effectiveScreenHeight() > 400) {
		_overlayWidth = 800;
		_overlayHeight = 480;

		_fullscreen = true;
	} else {
		_overlayWidth = 720;
		_overlayHeight = 400;
	}

	if (_screenHeight != 200)
		_adjustAspectRatio = false;

	OSystem_SDL::loadGFXMode();
}
