/***************************************************************************
                          scribus.cpp  -  description
                             -------------------
    begin                : Fre Apr  6 21:09:31 CEST 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qaccel.h>
#include <qapplication.h>
#include <qcolordialog.h>
#include <qcolor.h>
#include <qiconset.h>
#include <qtextstream.h>
#include <qplatinumstyle.h>
#include <qwindowsstyle.h>
#include <qmotifstyle.h>
#include <qmotifplusstyle.h>
#include <qcdestyle.h>
#include <qregexp.h>
#include "scribus.h"
#include "scribus.moc"
#include "newfile.h"
#include "page.h"
#include "query.h"
#include "mdup.h"
#include "docinfo.h"
#include "reformdoc.h"
#include "serializer.h"
#include "align.h"
#include "fmitem.h"
#include "fontprefs.h"
#include "libprefs/prefs.h"
#include <stdio.h>
#include <stdlib.h>
#include "pdfopts.h"
#include "inspage.h"
#include "delpages.h"
#include "movepage.h"
#include "helpbrowser.h"
#include "scribusXml.h"
#include "libabout/about.h"
#include "druck.h"
#include "editformats.h"
#include "muster.h"
#include "applytemplate.h"
#include "picstatus.h"
#include "customfdialog.h"
#include "cmsprefs.h"
#include "annot.h"
#include <dlfcn.h>
#include "config.h"
extern QPixmap loadIcon(QString nam);

#ifdef HAVE_CMS
cmsHPROFILE CMSinputProf;
cmsHPROFILE CMSoutputProf;
cmsHPROFILE CMSprinterProf;
bool SoftProofing;
bool CMSuse;
int IntentMonitor;
int IntentPrinter;
#endif
bool CMSavail;
ProfilesL InputProfiles;

ScribusApp::ScribusApp()
{
  setCaption(tr("Scribus " VERSION));
  setIcon(loadIcon("AppIcon.xpm"));
  initMenuBar();
  initStatusBar();
  WerkTools2 = new QToolBar(tr("File"), this);
  DatNeu = new QToolButton(loadIcon("DateiNeu.xpm"), tr("Creates a new Document"), QString::null, this, SLOT(slotFileNew()), WerkTools2);
  DatOpe = new QToolButton(loadIcon("DateiOpen.xpm"), tr("Opens a Document"), QString::null, this, SLOT(slotDocOpen()), WerkTools2);
  DatSav = new QToolButton(loadIcon("DateiSave.xpm"), tr("Saves the current Document"), QString::null, this, SLOT(slotFileSave()), WerkTools2);
  DatClo = new QToolButton(loadIcon("DateiClos.xpm"), tr("Closes the current Document"), QString::null, this, SLOT(slotFileClose()), WerkTools2);
  DatPri = new QToolButton(loadIcon("DateiPrint.xpm"), tr("Prints the current Document"), QString::null, this, SLOT(slotFilePrint()), WerkTools2);
  DatPDF = new QToolButton(loadIcon("acrobat.png"), tr("Saves the current Document as PDF"), QString::null, this, SLOT(SaveAsPDF()), WerkTools2);
	DatSav->setEnabled(false);
	DatClo->setEnabled(false);
	DatPri->setEnabled(false);
	DatPDF->setEnabled(false);
	DatOpe->setPopup(recentMenu);
  WerkTools = new QToolBar(tr("Tools"), this);
	Select = new QToolButton(loadIcon("Kreuz.xpm"), tr("Select Items"), QString::null, this, SLOT(ModeFromTB()), WerkTools);
	Select->setToggleButton(true);
	Select->setOn( TRUE );
	Rotiere = new QToolButton(loadIcon("Rotieren.xpm"), tr("Rotate Item"), QString::null, this, SLOT(ModeFromTB()), WerkTools);
	Rotiere->setToggleButton( TRUE );
	Rotiere->setEnabled(false);
	Textedit = new QToolButton(loadIcon("Editm.xpm"),tr("Edit Contents of Frame"), QString::null, this, SLOT(ModeFromTB()), WerkTools );
	Textedit->setToggleButton( TRUE );
	Textedit->setEnabled( FALSE );
	Zoom = new QToolButton(loadIcon("Lupe.xpm"),tr("Zooms in or out"), QString::null, this, SLOT(ModeFromTB()), WerkTools );
	Zoom->setToggleButton( TRUE );
	Texte = new QToolButton(loadIcon("Text.xpm"),tr("Insert Textbox"), QString::null, this, SLOT(ModeFromTB()), WerkTools );
	Texte->setToggleButton( TRUE );
	BildB = new QToolButton(loadIcon("Bild.xpm"),tr("Insert Picture"), QString::null, this, SLOT(ModeFromTB()), WerkTools );
	BildB->setToggleButton( TRUE );
	Rechteck = new QToolButton(loadIcon("Rechtecke.xpm"),tr("Insert Rectangles"), QString::null, this, SLOT(ModeFromTB()), WerkTools );
	Rechteck->setToggleButton( TRUE );
	Kreis = new QToolButton(loadIcon("Kreise.xpm"),tr("Insert Ovals"), QString::null, this, SLOT(ModeFromTB()), WerkTools );
	Kreis->setToggleButton( TRUE );
	Linien = new QToolButton(loadIcon("Stift.xpm"),tr("Insert Lines"), QString::null, this, SLOT(ModeFromTB()), WerkTools );
	Linien->setToggleButton( TRUE );
	KetteEin = new QToolButton(loadIcon("Lock.xpm"),tr("Create Textchains"), QString::null, this, SLOT(ModeFromTB()), WerkTools );
	KetteEin->setToggleButton( TRUE );
	KetteEin->setEnabled(false);
	KetteAus = new QToolButton(loadIcon("Unlock.xpm"),tr("Break Textchains"), QString::null, this, SLOT(ModeFromTB()), WerkTools );
	KetteAus->setToggleButton( TRUE );
	KetteAus->setEnabled(false);
	/** Erstelle Fontliste */
  NoFonts = false;
  GetAllFonts();
  if (NoFonts)
  	{
		QString mess = tr("There are no Postscript-Fonts on your System");
		mess += "\n" + tr("Exiting now");
		QMessageBox::critical(this, tr("Fatal Error"), mess, 1, 0, 0);
  	}
  else
  	{
  	HaveDoc = false;
		TemplateMode = false;
  	BuildFontMenu();
		SCFontsIterator it(Prefs.AvailFonts);
		Prefs.DefFont = it.currentKey();
  	Prefs.DefSize = 12;
  	Prefs.AppFontSize = 12;
  	/** Default Farbenliste */
  	Prefs.DColors.clear();
	  Prefs.DColors.insert("White", CMYKColor(0, 0, 0, 0));
  	Prefs.DColors.insert("Black", CMYKColor(0, 0, 0, 255));
		Prefs.DColors.insert("Blue", CMYKColor(255, 255, 0, 0));
		Prefs.DColors.insert("Cyan", CMYKColor(255, 0, 0, 0));
		Prefs.DColors.insert("Green", CMYKColor(255, 0, 255, 0));
		Prefs.DColors.insert("Red", CMYKColor(0, 255, 255, 0));
		Prefs.DColors.insert("Yellow", CMYKColor(0, 0, 255, 0));
		Prefs.DColors.insert("Magenta", CMYKColor(0, 255, 0, 0));
		DispX = 10;
		DispY = 10;
		Prefs.Wheelval = 40;
		Prefs.GrabRad = 4;
		Prefs.DminGrid = 20;
	  Prefs.DmajGrid = 100;
	  DocNr = 1;
	  Prefs.DminColor = QColor(green);
	  Prefs.DmajColor = QColor(green);
	  Prefs.DpapColor = QColor(white);
	  Prefs.DmargColor = QColor(blue);
	  Prefs.DVHoch = 33;
	  Prefs.DVHochSc = 100;
	  Prefs.DVTief = 33;
	  Prefs.DVTiefSc = 100;
	  Prefs.DVKapit = 75;
	  Prefs.GUI = 0;
	  Prefs.Dpen = "Black";
	  Prefs.Dbrush = "Black";
	  Prefs.Dshade = 100;
	  Prefs.Dshade2 = 100;
	  Prefs.DLineArt = SolidLine;
	  Prefs.Dwidth = 1;
	  Prefs.DpenLine = "Black";
	  Prefs.DpenText = "Black";
	  Prefs.DshadeLine = 100;
	  Prefs.DLstyleLine = SolidLine;
	  Prefs.DwidthLine = 1;
	  Prefs.MagMin = 10;
	  Prefs.MagMax = 800;
	  Prefs.MagStep = 25;
	  Prefs.DbrushPict = "White";
	  Prefs.ShadePict = 100;
	  Prefs.ScaleX = 1;
	  Prefs.ScaleY = 1;
	  Prefs.Before = true;
	  Prefs.Einheit = 0;
	  Umrech = 1.0;
	  CurrentStyle = 0;
	  CurrentABStil = 0;
	  BufferSet = false;
	  BufferSet2 = false;
	  Prefs.Werkv = true;
	  Prefs.Mpalv = false;
	  Prefs.Cpalv = false;
	  Prefs.Tpalv = false;
	  Prefs.Spalv = false;
	  Prefs.SCpalv = false;
	  Prefs.PSize = 40;
	  Prefs.SaveAtQ = true;
	  Prefs.ShFrames = true;
	  Prefs.PagesSbS = true;
	  Prefs.RecentDocs.clear();
	  Prefs.RecentDCount = 5;
	  Prefs.RandFarbig = false;
	  Prefs.AutoLine = 20;
	  PDFavailable = true;
	  PrinterUsed = false;
		resize(610, 600);
		Cpal = new Cpalette(this, "Color", 0, WStyle_Customize | WStyle_DialogBorder);
		Cpal->SetColors(Prefs.DColors);
		Tpal = new Tree(this, WStyle_Customize | WStyle_DialogBorder);
		Mpal2 = new Mpalette2(this, FontMenu);
		Spal = new Spalette(this);
		Npal = new NodePalette(this);
		ScBook = new Biblio(this, Prefs.AvailFonts, &Prefs);
		CMSavail = false;
		Prefs.DCMSset.DefaultMonitorProfile = "";
		Prefs.DCMSset.DefaultPrinterProfile = "";
		Prefs.DCMSset.DefaultInputProfile = "";
		Prefs.DCMSset.DefaultInputProfile2 = "";
		Prefs.DCMSset.CMSinUse = false;
		Prefs.DCMSset.SoftProofOn = false;
		Prefs.DCMSset.DefaultIntentMonitor = 1;
		Prefs.DCMSset.DefaultIntentMonitor2 = 1;
		Prefs.DCMSset.DefaultIntentPrinter = 0;
		SetKeyEntry(56, tr("Smart Hyphen"), 0, ALT+Key_Minus);
		SetKeyEntry(57, tr("Align Left"), 0, CTRL+Key_L);
		SetKeyEntry(58, tr("Align Right"), 0, CTRL+Key_R);
		SetKeyEntry(59, tr("Align Center"), 0, CTRL+Key_E);
		SetKeyEntry(60, tr("Insert Pagenumber"), 0, ALT+Key_NumberSign);
		GetCMSProfiles();
		ReadPrefs();
		SetShortCut();
		if (CMSavail)
			{
			editMenu->insertItem(tr("Colormanagement..."), this , SLOT(SetCMSPrefs()));
			ProfilesL::Iterator ip;
			if ((Prefs.DCMSset.DefaultInputProfile == "") || (!InputProfiles.contains(Prefs.DCMSset.DefaultInputProfile)))
				{
				ip = InputProfiles.begin();
				Prefs.DCMSset.DefaultInputProfile = ip.key();
				}
			if ((Prefs.DCMSset.DefaultInputProfile2 == "") || (!InputProfiles.contains(Prefs.DCMSset.DefaultInputProfile2)))
				{
				ip = InputProfiles.begin();
				Prefs.DCMSset.DefaultInputProfile2 = ip.key();
				}
			if ((Prefs.DCMSset.DefaultMonitorProfile == "") || (!MonitorProfiles.contains(Prefs.DCMSset.DefaultMonitorProfile)))
				{
				ip = MonitorProfiles.begin();
				Prefs.DCMSset.DefaultMonitorProfile = ip.key();
				}
			if ((Prefs.DCMSset.DefaultPrinterProfile == "") || (!PrinterProfiles.contains(Prefs.DCMSset.DefaultPrinterProfile)))
				{
				ip = PrinterProfiles.begin();
				Prefs.DCMSset.DefaultPrinterProfile = ip.key();
				}
			OpenCMSProfiles();
			if ((Prefs.DCMSset.CMSinUse) && (Prefs.DCMSset.SoftProofOn))
				RecalcColors();
#ifdef HAVE_CMS
			SoftProofing = Prefs.DCMSset.SoftProofOn;
			CMSuse = Prefs.DCMSset.CMSinUse;
			IntentPrinter = Prefs.DCMSset.DefaultIntentPrinter;
			IntentMonitor = Prefs.DCMSset.DefaultIntentMonitor;
#endif
			}
		QString SCf = QString(getenv("HOME"))+"/.scribusscrap.scs";
		QFileInfo SCfi = QFileInfo(SCf);
		if (SCfi.exists())
			{
			ScBook->BibWin->ReadContents(SCf);
			ScBook->ScFilename = SCf;
			}
		ScBook->AdjustMenu();
		HaveGS = system("gs -h > /dev/null 2>&1");
		InitPlugs();
		connect(Mpal2->TA, SIGNAL(Schliessen()), this, SLOT(ToggleMpal()));
		connect(Mpal2, SIGNAL(BackHome()), this, SLOT(Aktiv()));
		connect(Mpal2, SIGNAL(Stellung(int)), this, SLOT(setItemHoch(int)));
		connect(Mpal2, SIGNAL(NewAbStyle(int)), this, SLOT(setNewAbStyle(int)));
		connect(Mpal2, SIGNAL(DocChanged()), this, SLOT(slotDocCh()));
		connect(Cpal, SIGNAL(Schliessen()), this, SLOT(ToggleCpal()));
		connect(Cpal, SIGNAL(NewPen(QString)), this, SLOT(setPenFarbe(QString)));
		connect(Cpal, SIGNAL(NewBrush(QString)), this, SLOT(setBrushFarbe(QString)));
		connect(Cpal, SIGNAL(NewPenShade(int)), this, SLOT(setPenShade(int)));
		connect(Cpal, SIGNAL(NewBrushShade(int)), this, SLOT(setBrushShade(int)));
		connect(Cpal, SIGNAL(QueryItem()), this, SLOT(GetBrushPen()));
		connect(Tpal, SIGNAL(Schliessen()), this, SLOT(ToggleTpal()));
		connect(Tpal, SIGNAL(SelectElement(int, int)), this, SLOT(SelectFromOutl(int, int)));
		connect(Tpal, SIGNAL(SelectSeite(int)), this, SLOT(SelectFromOutlS(int)));
		connect(Spal, SIGNAL(Schliessen()), this, SLOT(ToggleSpal()));
		connect(Spal, SIGNAL(NewStyle(int)), this, SLOT(setNewAbStyle(int)));
		connect(Spal, SIGNAL(EditSt()), this, SLOT(slotEditStyles()));
		connect(Npal, SIGNAL(Schliessen()), this, SLOT(NoFrameEdit()));
		connect(ScBook, SIGNAL(Schliessen()), this, SLOT(ToggleBpal()));
		connect(recentMenu, SIGNAL(activated(int)), this, SLOT(LoadRecent(int)));
		connect(ColorMenu, SIGNAL(activated(int)), this, SLOT(setItemFarbe(int)));
	  connect(ShadeMenu, SIGNAL(activated(int)), this, SLOT(setItemShade(int)));
	  connect(FontMenu, SIGNAL(activated(int)), this, SLOT(setItemFont(int)));
	  connect(SizeTMenu, SIGNAL(activated(int)), this, SLOT(setItemFSize(int)));
	  connect(TypeStyleMenu, SIGNAL(activated(int)), this, SLOT(setItemTypeStyle(int)));
	  connect(AliMenu, SIGNAL(activated(int)), this, SLOT(setItemTextAli(int)));
		connect(this, SIGNAL(TextIFont(QString)), this, SLOT(AdjustFontMenu(QString)));
		connect(this, SIGNAL(TextISize(int)), this, SLOT(setFSizeMenu(int)));
		connect(this, SIGNAL(TextISize(int)), Mpal2, SLOT(setSize(int)));
		connect(this, SIGNAL(TextUSval(float)), Mpal2, SLOT(setExtra(float)));
		connect(this, SIGNAL(TextStil(int)), Mpal2, SLOT(setStil(int)));
		connect(this, SIGNAL(TextFarben(QString, QString, int, int)), Cpal, SLOT(setActFarben(QString, QString, int, int)));
	}
}

ScribusApp::~ScribusApp()
{
}

void ScribusApp::initMenuBar()
{
	int a;
	int MenID;
	QFont tmp;
	recentMenu = new QPopupMenu();
	RecentDocs.clear();
	fileMenu=new QPopupMenu();
	fid12 = fileMenu->insertItem(loadIcon("DateiNeu16.png"), tr("New"), this, SLOT(slotFileNew()), CTRL+Key_N);
	fid13 = fileMenu->insertItem(loadIcon("DateiOpen16.png"), tr("Open..."), this, SLOT(slotDocOpen()), CTRL+Key_O);
	fid14 = fileMenu->insertItem(tr("Recent Documents"), recentMenu);
	SetKeyEntry(0, tr("New"), fid12, CTRL+Key_N);
	SetKeyEntry(1, tr("Open..."), fid13, CTRL+Key_O);
	fileMenu->insertSeparator();
	fid1 = fileMenu->insertItem(loadIcon("DateiClos16.png"), tr("Close"), this, SLOT(slotFileClose()), CTRL+Key_W);
	SetKeyEntry(2, tr("Close"), fid1, CTRL+Key_W);
	fileMenu->setItemEnabled(fid1, 0);
	fid4 = fileMenu->insertItem(loadIcon("DateiSave16.png"), tr("Save"), this, SLOT(slotFileSave()), CTRL+Key_S);
	SetKeyEntry(3, tr("Save"), fid4, CTRL+Key_S);
	fileMenu->setItemEnabled(fid4, 0);
	fid5 = fileMenu->insertItem(tr("Save as..."), this, SLOT(slotFileSaveAs()));
	SetKeyEntry(4, tr("Save as..."), fid5, 0);
	fileMenu->setItemEnabled(fid5, 0);
	fileMenu->insertSeparator();
	importMenu = new QPopupMenu();
	fid2 = importMenu->insertItem(tr("Get Text/Picture..."), this, SLOT(slotFileOpen()));
	importMenu->setItemEnabled(fid2, 0);
	fileMenu->insertItem(tr("Import..."), importMenu);
	exportMenu = new QPopupMenu();
	fid3 = exportMenu->insertItem(tr("Save Text..."), this, SLOT(SaveText()));
	exportMenu->setItemEnabled(fid3, 0);
	fid8 = exportMenu->insertItem(tr("Save Page as EPS..."), this, SLOT(SaveAsEps()));
	exportMenu->setItemEnabled(fid8, 0);
	fid10 = exportMenu->insertItem(tr("Save as PDF..."), this, SLOT(SaveAsPDF()));
	exportMenu->setItemEnabled(fid10, 0);
	fid11 = fileMenu->insertItem(tr("Export..."), exportMenu);
	fileMenu->setItemEnabled(fid11, 0);
	fileMenu->insertSeparator();
	fid6 = fileMenu->insertItem(tr("Document Info..."), this, SLOT(InfoDoc()), CTRL+Key_I);
	fileMenu->setItemEnabled(fid6, 0);
	SetKeyEntry(5, tr("Document Info..."), fid6, CTRL+Key_I);
	fid7 = fileMenu->insertItem(tr("Document Setup..."), this, SLOT(SetupDoc()));
	fileMenu->setItemEnabled(fid7, 0);
	SetKeyEntry(6, tr("Document Setup..."), fid7, 0);
	fid9 = fileMenu->insertItem(loadIcon("DateiPrint16.png"), tr("Print..."), this, SLOT(slotFilePrint()), CTRL+Key_P);
	fileMenu->setItemEnabled(fid9, 0);
	SetKeyEntry(7, tr("Print..."), fid9, CTRL+Key_P);
	fileMenu->insertSeparator();
	MenID = fileMenu->insertItem(loadIcon("exit.png"), tr("Quit"), this, SLOT(slotFileQuit()), CTRL+Key_Q);
	SetKeyEntry(8, tr("Quit"), MenID, CTRL+Key_Q);
	editMenu = new QPopupMenu();
	edid1 = editMenu->insertItem(loadIcon("editcut.png"), tr("Cut"), this , SLOT(slotEditCut()), CTRL+Key_X);
	edid2 = editMenu->insertItem(loadIcon("editcopy.png"), tr("Copy"), this , SLOT(slotEditCopy()), CTRL+Key_C);
	edid3 = editMenu->insertItem(loadIcon("editpaste.png"), tr("Paste"), this , SLOT(slotEditPaste()), CTRL+Key_V);
	edid4 = editMenu->insertItem(loadIcon("editdelete.png"), tr("Clear"), this, SLOT(DeleteText()));
	edid5 = editMenu->insertItem(tr("Select all"), this, SLOT(SelectAll()), CTRL+Key_A);
	SetKeyEntry(9, tr("Cut"), edid1, CTRL+Key_X);
	SetKeyEntry(10, tr("Copy"), edid2, CTRL+Key_C);
	SetKeyEntry(11, tr("Paste"), edid3, CTRL+Key_V);
	SetKeyEntry(12, tr("Clear"), edid4, 0);
	SetKeyEntry(13, tr("Select all"), edid5, CTRL+Key_A);
	editMenu->insertSeparator();
	MenID = editMenu->insertItem(tr("Colors..."), this , SLOT(slotEditColors()));
	SetKeyEntry(14, tr("Colors..."), MenID, 0);
	edid6 = editMenu->insertItem(tr("Styles..."), this , SLOT(slotEditStyles()));
	SetKeyEntry(15, tr("Styles..."), edid6, 0);
	tman = editMenu->insertItem(tr("Templates..."), this, SLOT(ManageTemp()));
	SetKeyEntry(16, tr("Templates..."), tman, 0);
	MenID = editMenu->insertItem(tr("Fonts..."), this , SLOT(slotFontOrg()));
	SetKeyEntry(17, tr("Fonts..."), MenID, 0);
	MenID = editMenu->insertItem(tr("Preferences..."), this , SLOT(slotPrefsOrg()));
	SetKeyEntry(18, tr("Preferences..."), MenID, 0);
	editMenu->setItemEnabled(edid1, 0);
	editMenu->setItemEnabled(edid2, 0);
	editMenu->setItemEnabled(edid3, 0);
	editMenu->setItemEnabled(edid4, 0);
	editMenu->setItemEnabled(edid5, 0);
	editMenu->setItemEnabled(edid6, 0);
	editMenu->setItemEnabled(tman, 0);
	StilMenu = new QPopupMenu();
	ObjMenu = new QPopupMenu();
	MenID = ObjMenu->insertItem(tr("Modify..."), this, SLOT(ModifyObject()), CTRL+Key_M);
	SetKeyEntry(19, tr("Modify..."), MenID, CTRL+Key_M);
	MenID = ObjMenu->insertItem(tr("Duplicate"), this, SLOT(ObjektDup()), CTRL+Key_D);
	SetKeyEntry(20, tr("Duplicate"), MenID, CTRL+Key_D);
	MenID = ObjMenu->insertItem(tr("Multiple Duplicate"), this, SLOT(ObjektDupM()));
	SetKeyEntry(21, tr("Multiple Duplicate"), MenID, 0);
	Loesch = ObjMenu->insertItem(tr("Delete"), this, SLOT(DeleteObjekt()), CTRL+Key_K);
	SetKeyEntry(22, tr("Delete"), Loesch, CTRL+Key_K);
	ObjMenu->insertSeparator();
	Gr = ObjMenu->insertItem(tr("Group"), this, SLOT(GroupObj()), CTRL+Key_G);
	SetKeyEntry(23, tr("Group"), Gr, CTRL+Key_G);
	UnGr = ObjMenu->insertItem(tr("Ungroup"), this, SLOT(UnGroupObj()), CTRL+Key_U);
	SetKeyEntry(24, tr("Ungroup"), UnGr, CTRL+Key_U);
	ObjMenu->insertSeparator();
	MenID = ObjMenu->insertItem(tr("Send to Back"), this, SLOT(Objekt2Back()));
	SetKeyEntry(25, tr("Send to Back"), MenID, 0);
	MenID = ObjMenu->insertItem(tr("Bring to Front"), this, SLOT(Objekt2Front()));
	SetKeyEntry(26, tr("Bring to Front"), MenID, 0);
	MenID = ObjMenu->insertItem(tr("Lower"), this, SLOT(ObjektLower()));
	SetKeyEntry(27, tr("Lower"), MenID, 0);
	MenID = ObjMenu->insertItem(tr("Raise"), this, SLOT(ObjektRaise()));
	SetKeyEntry(28, tr("Raise"), MenID, 0);
	DistM = ObjMenu->insertItem(tr("Distribute/Align..."), this, SLOT(ObjektAlign()));
	SetKeyEntry(29, tr("Distribute/Align..."), DistM, 0);
	ObjMenu->insertSeparator();
	ShapeMenu = new QPopupMenu();
	ShapeMenu->insertItem(tr("Rectangle"), this, SLOT(RectFrame()));
	ShapeMenu->insertItem(tr("Rounded Rectangle"), this, SLOT(RoundedFrame()));
	ShapeMenu->insertItem(tr("Oval"), this, SLOT(OvalFrame()));
	ShapeEdit = ShapeMenu->insertItem(tr("Edit Frame"), this, SLOT(ToggleFrameEdit()));
	ShapeM = ObjMenu->insertItem(tr("Shape"), ShapeMenu);
	ObjMenu->setItemEnabled(ShapeM, 0);
	ObjMenu->setItemEnabled(DistM, 0);
	ObjMenu->setItemEnabled(Gr, 0);
	ObjMenu->setItemEnabled(UnGr, 0);
	pageMenu = new QPopupMenu();
	MenID = pageMenu->insertItem(tr("Insert..."), this, SLOT(slotNewPageM()));
	SetKeyEntry(30, tr("Insert..."), MenID, 0);
	pgmd = pageMenu->insertItem(tr("Delete..."), this, SLOT(DeletePage()));
	SetKeyEntry(31, tr("Delete..."), pgmd, 0);
	MenID = pageMenu->insertItem(tr("Copy")+"...", this, SLOT(CopyPage()));
	SetKeyEntry(61, tr("Copy")+"...", MenID, 0);
	pgmv = pageMenu->insertItem(tr("Move..."), this, SLOT(MovePage()));
	SetKeyEntry(32, tr("Move..."), pgmv, 0);
	MenID = pageMenu->insertItem(tr("Apply Template..."), this, SLOT(ApplyTemp()));
	SetKeyEntry(33, tr("Apply Template..."), MenID, 0);
	pageMenu->setItemEnabled(pgmd, 0);
	pageMenu->setItemEnabled(pgmv, 0);
	viewMenu=new QPopupMenu();
	MenID = viewMenu->insertItem(tr("Fit in Window"), this, SLOT(slotZoomFit()), CTRL+Key_0);
	SetKeyEntry(34, tr("Fit in Window"), MenID, CTRL+Key_0);
	MenID = viewMenu->insertItem("50%", this, SLOT(slotZoom50()));
	SetKeyEntry(35, tr("50%"), MenID, 0);
	MenID = viewMenu->insertItem("75%", this, SLOT(slotZoom75()));
	SetKeyEntry(36, tr("75%"), MenID, 0);
	MenID = viewMenu->insertItem(tr("Actual Size"), this, SLOT(slotZoom100()), CTRL+Key_1);
	SetKeyEntry(37, tr("Actual Size"), MenID, CTRL+Key_1);
	MenID = viewMenu->insertItem("200%", this, SLOT(slotZoom200()));
	SetKeyEntry(38, tr("200%"), MenID, 0);
	MenID = viewMenu->insertItem(tr("Thumbnails"), this, SLOT(slotZoom20()));
	SetKeyEntry(39, tr("Thumbnails"), MenID, 0);
	viewMenu->insertSeparator();
	Markers = viewMenu->insertItem(tr("Hide Margins"), this, SLOT(ToggleMarks()));
	SetKeyEntry(40, tr("Hide Margins"), Markers, 0);
	FrameDr = viewMenu->insertItem(tr("Hide Frames"), this, SLOT(ToggleFrames()));
	SetKeyEntry(41, tr("Hide Frames"), FrameDr, 0);
	Bilder = viewMenu->insertItem(tr("Hide Images"), this, SLOT(TogglePics()));
	SetKeyEntry(42, tr("Hide Images"), Bilder, 0);
	Ras = viewMenu->insertItem(tr("Show Guides"), this, SLOT(ToggleRaster()));
	SetKeyEntry(43, tr("Show Guides"), Ras, 0);
	uRas = viewMenu->insertItem(tr("Snap to Guides"), this, SLOT(ToggleURaster()));
	SetKeyEntry(44, tr("Snap to Guides"), uRas, 0);
	for (a=0; a<6; a++)
		{
		viewMenu->setItemEnabled(viewMenu->idAt(a), 0);
		}
	viewMenu->setItemEnabled(Markers, 0);
	viewMenu->setItemEnabled(FrameDr, 0);
	viewMenu->setItemEnabled(Bilder, 0);
	viewMenu->setItemEnabled(Ras, 0);
	viewMenu->setItemEnabled(uRas, 0);
	toolMenu=new QPopupMenu();
	viewTools = toolMenu->insertItem(tr("Hide Tools"), this, SLOT(ToggleTools()));
	SetKeyEntry(45, tr("Hide Tools"), viewTools, 0);
	viewMpal = toolMenu->insertItem(tr("Show Measurements"), this, SLOT(ToggleMpal()));
	SetKeyEntry(46, tr("Show Measurements"), viewMpal, 0);
	viewCpal = toolMenu->insertItem(tr("Show Colors"), this, SLOT(ToggleCpal()));
	SetKeyEntry(47, tr("Show Colors"), viewCpal, 0);
	viewTpal = toolMenu->insertItem(tr("Show Outline"), this, SLOT(ToggleTpal()));
	SetKeyEntry(48, tr("Show Outline"), viewTpal, 0);
	viewSpal = toolMenu->insertItem(tr("Show Styles"), this, SLOT(ToggleSpal()));
	SetKeyEntry(49, tr("Show Styles"), viewSpal, 0);
	viewBpal = toolMenu->insertItem(tr("Show Scrapbook"), this, SLOT(ToggleBpal()));
	SetKeyEntry(50, tr("Show Scrapbook"), viewBpal, 0);
	extraMenu=new QPopupMenu();
	MenID = extraMenu->insertItem(tr("Manage Pictures"), this, SLOT(StatusPic()));
	SetKeyEntry(51, tr("Manage Pictures"), MenID, 0);
	helpMenu=new QPopupMenu();
	MenID = helpMenu->insertItem(tr("About Scribus"), this, SLOT(slotHelpAbout()));
	SetKeyEntry(52, tr("About Scribus"), MenID, 0);
	MenID = helpMenu->insertItem(tr("About Qt"), this, SLOT(slotHelpAboutQt()));
	SetKeyEntry(53, tr("About Qt"), MenID, 0);
	helpMenu->insertSeparator();
	MenID = helpMenu->insertItem(tr("Online-Help..."), this, SLOT(slotOnlineHelp()));
	SetKeyEntry(54, tr("Online-Help..."), MenID, 0);
	tip = helpMenu->insertItem(tr("Tool-Tips"), this, SLOT(ToggleTips()));
	SetKeyEntry(55, tr("Tool-Tips"), tip, 0);
  tipsOn = true;
  helpMenu->setItemChecked(tip, tipsOn);
//	helpMenu->insertItem(tr("Test"), this, SLOT(slotTest()));
//	helpMenu->insertItem(tr("Test2"), this, SLOT(slotTest2()));
	menuBar()->insertItem(tr("File"), fileMenu);
	menuBar()->insertItem(tr("Edit"), editMenu);
	Stm = menuBar()->insertItem(tr("Style"), StilMenu);
	Obm = menuBar()->insertItem(tr("Item"), ObjMenu);
	pgmm = menuBar()->insertItem(tr("Page"), pageMenu);
	menuBar()->setItemEnabled(Stm, 0);
	menuBar()->setItemEnabled(Obm, 0);
	menuBar()->setItemEnabled(pgmm, 0);
	menuBar()->insertItem(tr("View"), viewMenu);
	menuBar()->insertItem(tr("Tools"), toolMenu);
	exmn = menuBar()->insertItem(tr("Extras"), extraMenu);
	menuBar()->setItemEnabled(exmn, 0);
	menuBar()->insertSeparator();
	menuBar()->insertItem(tr("Help"), helpMenu);
	AliMenu = new QPopupMenu();
	AliMenu->insertItem(tr("Left"));
	AliMenu->insertItem(tr("Center"));
	AliMenu->insertItem(tr("Right"));
	AliMenu->insertItem(tr("Block"));
	AliMenu->insertItem(tr("Forced"));
	ColorMenu = new QPopupMenu();
	SizeTMenu = new QPopupMenu();
	SizeTMenu->insertItem(tr("Other..."));
	SizeTMenu->insertItem(" 7 pt");
	SizeTMenu->insertItem(" 9 pt");
	SizeTMenu->insertItem("10 pt");
	SizeTMenu->insertItem("12 pt");
	SizeTMenu->insertItem("14 pt");
	SizeTMenu->insertItem("18 pt");
	SizeTMenu->insertItem("24 pt");
	SizeTMenu->insertItem("36 pt");
	SizeTMenu->insertItem("48 pt");
	SizeTMenu->insertItem("60 pt");
	SizeTMenu->insertItem("72 pt");
	ShadeMenu = new QPopupMenu();
	ShadeMenu->insertItem(tr("Other..."));
	ShadeMenu->insertItem("0 %");
	ShadeMenu->insertItem("10 %");
	ShadeMenu->insertItem("20 %");
	ShadeMenu->insertItem("30 %");
	ShadeMenu->insertItem("40 %");
	ShadeMenu->insertItem("50 %");
	ShadeMenu->insertItem("60 %");
	ShadeMenu->insertItem("70 %");
	ShadeMenu->insertItem("80 %");
	ShadeMenu->insertItem("90 %");
	ShadeMenu->insertItem("100 %");
	FStyleMenu = new QPopupMenu();
	FontMenu = new QPopupMenu();
	TypeStyleMenu = new QPopupMenu();
	TypeStyleMenu->insertItem(tr("Normal"));
	tmp = qApp->font();
	tmp.setBold(true);
	TypeStyleMenu->insertItem(new FmItem(tr("Bold"), tmp));
	tmp = qApp->font();
	tmp.setItalic(true);
	TypeStyleMenu->insertItem(new FmItem(tr("Italic"), tmp));
	tmp = qApp->font();
	tmp.setUnderline(true);
	TypeStyleMenu->insertItem(new FmItem(tr("Underline"), tmp));
	tmp = qApp->font();
	tmp.setStrikeOut(true);
	TypeStyleMenu->insertItem(new FmItem(tr("Strikethru"), tmp));
	TypeStyleMenu->insertItem(tr("Small Caps"));
	TypeStyleMenu->insertItem(tr("Superscript"));
	TypeStyleMenu->insertItem(tr("Subscript"));
}

void ScribusApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->message(tr("Ready"), 2000);
}

void ScribusApp::SetKeyEntry(int Nr, QString text, int Men, int KeyC)
{
	Keys ke;
	ke.Name = text;
	ke.MenuID = Men;
	ke.KeyID = KeyC;
	Prefs.KeyActions.insert(Nr, ke);
}

void ScribusApp::DeleteSel(PageItem *b)
{
	Pti *it;
 	for (it = b->Ptext.first(); it != 0; it = b->Ptext.next())
 		{
 		if (it->cselect)
 			{
 			b->Ptext.remove();
 			it = b->Ptext.prev();
 			if (it == 0)
 				{
 				it = b->Ptext.first();
 				}
 			}
 		}
 	if (b->Ptext.first()->cselect)
 		{
 		b->Ptext.remove();
 		}
 	b->HasSel = false;
 	b->CPos = QMIN(b->CPos, doc->ActPage->oldCp);
 	DisableTxEdit();
}

void ScribusApp::setTBvals(PageItem *b)
{
	if (b->Ptext.count() != 0)
		{
		emit TextIFont(b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->cfont);
 		emit TextISize(b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->csize);
 		emit TextUSval(b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->cextra);
 		emit TextStil(b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->cstyle & 127);
 		CurrentStyle = b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->cstyle & 127;
 		CurrentABStil = b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->cab;
 		setAbsValue(CurrentABStil);
 		Mpal2->setAli(CurrentABStil);
 		b->IFont = b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->cfont;
 		b->ISize = b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->csize;
		emit TextFarben(b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->ccolor,
										b->Pcolor,
										b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->cshade,
										b->Shade);
		b->Pcolor2 = b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->ccolor;
		b->Shade2 = b->Ptext.at(QMIN(b->CPos, int(b->Ptext.count()-1)))->cshade;
 		}
}

void ScribusApp::wheelEvent(QWheelEvent *w)
{
	if (HaveDoc)
		{
		if (w->delta() < 0)
			{
			view->scrollBy(0, Prefs.Wheelval);
			}
		else
			{
			view->scrollBy(0, -Prefs.Wheelval);
			}
		w->accept();
		}
}

void ScribusApp::keyPressEvent(QKeyEvent *k)
{
	struct Pti *hg;
	int kk = k->key();
	int as = k->ascii();
	float altx, alty;
	QString uc = k->text();
	QString cr;
	switch (k->state())
		{
		case ShiftButton:
			KeyMod = 0x00200000;
			break;
		case AltButton:
			KeyMod = 0x00800000;
			break;
		case ControlButton:
			KeyMod = 0x00400000;
			break;
		default:
			KeyMod = 0;
		}
 	if ((HaveDoc) && (!view->LE->hasFocus()))
 		{
 		switch (kk)
 			{
 			case Key_Prior:
 				view->scrollBy(0, -Prefs.Wheelval);
 				return;
 				break;
 			case Key_Next:
 				view->scrollBy(0, Prefs.Wheelval);
 				return;
 				break;
 			}
 		if (doc->ActPage->SelItem.count() != 0)
 			{
 			PageItem *b = doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0));
 			switch (doc->AppMode)
 				{
 				case 1:
 					switch (kk)
 						{
 						case Key_Delete:
 							if (!doc->EditClip)
 								doc->ActPage->DeleteItem();
 							break;
 						case Key_Left:
 							doc->ActPage->MoveItem(-1, 0, b->ItemNr);
 							break;
 						case Key_Right:
 							doc->ActPage->MoveItem(1, 0, b->ItemNr);
 							break;
 						case Key_Up:
 							doc->ActPage->MoveItem(0, -1, b->ItemNr);
 							break;
 						case Key_Down:
 							doc->ActPage->MoveItem(0, 1, b->ItemNr);
 						default:
 							if (b->PType == 4)
 								{
 								if ((kk + KeyMod) == Prefs.KeyActions[59].KeyID)
 									{
									setNewAbStyle(1);
 									b->Dirty = true;
 									b->Tinput = true;
 									b->paintObj();
 									}
 								if ((kk + KeyMod) == Prefs.KeyActions[58].KeyID)
 									{
									setNewAbStyle(2);
 									b->Dirty = true;
 									b->Tinput = true;
 									b->paintObj();
 									}
 								if ((kk + KeyMod) == Prefs.KeyActions[57].KeyID)
 									{
									setNewAbStyle(0);
 									b->Dirty = true;
 									b->Tinput = true;
 									b->paintObj();
 									}
 								}
 							break;
 						}
 					break;
 				case 7:
 					if (b->PType == 4)
 						{
 						doc->ActPage->slotDoCurs(false);
 						switch (kk)
 							{
 							case Key_Down:
 								if (b->CPos != int(b->Ptext.count()))
 									{
 									alty = b->Ptext.at(b->CPos)->yp;
 									altx = b->Ptext.at(b->CPos)->xp;
 									do
 										{
 										b->CPos += 1;
 										if (b->CPos == int(b->Ptext.count()))
 											break;
 										if (b->Ptext.at(b->CPos)->yp > alty)
 											{
 											if (b->Ptext.at(b->CPos)->xp >= altx)
 												break;
 											}
 										}
 									while (b->CPos < int(b->Ptext.count()));
 									if (b->CPos == int(b->Ptext.count()))
 										if (b->NextBox != 0)
 											{
 											if (b->NextBox->Ptext.count() != 0)
 												{
												b->OwnPage->Deselect();
												b->NextBox->CPos = 0;
												doc->ActPage = b->NextBox->OwnPage;
												b->NextBox->OwnPage->SelectItemNr(b->NextBox->ItemNr);
												b = b->NextBox;
												}
 											} 									
 									}
 								else
 									{
 									if (b->NextBox != 0)
 										{
 										if (b->NextBox->Ptext.count() != 0)
 											{
											b->OwnPage->Deselect();
											b->NextBox->CPos = 0;
											doc->ActPage = b->NextBox->OwnPage;
											b->NextBox->OwnPage->SelectItemNr(b->NextBox->ItemNr);
											b = b->NextBox;
											}
 										}
 									}
 								setTBvals(b);
 								break;
 							case Key_Up:
 								if (b->CPos > 0)
 									{
 									if (b->CPos == int(b->Ptext.count()))
 										b->CPos -= 1;
 									alty = b->Ptext.at(b->CPos)->yp;
 									altx = b->Ptext.at(b->CPos)->xp;
 									do
 										{
 										b->CPos -= 1;
 										if (b->CPos == 0)
 											break;
 										if (b->Ptext.at(b->CPos)->yp < alty)
 											{
 											if (b->Ptext.at(b->CPos)->xp <= altx)
 												break;
 											}
 										}
 									while (b->CPos > 0);
 									if (b->CPos == 0)
 										{
 										if (b->BackBox != 0)
 											{
											b->OwnPage->Deselect();
											b->BackBox->CPos = b->BackBox->Ptext.count();
											doc->ActPage = b->BackBox->OwnPage;
											b->BackBox->OwnPage->SelectItemNr(b->BackBox->ItemNr);
											b = b->BackBox;
 											}
 										}
 									}
 								else
 									{
 									b->CPos = 0;
 									if (b->BackBox != 0)
 										{
										b->OwnPage->Deselect();
										b->BackBox->CPos = b->BackBox->Ptext.count();
										doc->ActPage = b->BackBox->OwnPage;
										b->BackBox->OwnPage->SelectItemNr(b->BackBox->ItemNr);
										b = b->BackBox;
 										}
 									}
 								setTBvals(b);
 								break;
 							case Key_Left:
 								b->CPos -= 1;
 								if (b->CPos < 0)
 									{
 									b->CPos = 0;
 									if (b->BackBox != 0)
 										{
										b->OwnPage->Deselect();
										b->BackBox->CPos = b->BackBox->Ptext.count();
										doc->ActPage = b->BackBox->OwnPage;
										b->BackBox->OwnPage->SelectItemNr(b->BackBox->ItemNr);
										b = b->BackBox;
 										}
 									}
 								setTBvals(b);
 								break;
 							case Key_Right:
 								b->CPos += 1;
 								if (b->CPos > int(b->Ptext.count()))
 									{
 									b->CPos -= 1;
 									if (b->NextBox != 0)
 										{
 										if (b->NextBox->Ptext.count() != 0)
 											{
											b->OwnPage->Deselect();
											b->NextBox->CPos = 0;
											doc->ActPage = b->NextBox->OwnPage;
											b->NextBox->OwnPage->SelectItemNr(b->NextBox->ItemNr);
											b = b->NextBox;
											}
 										}
 									}
 								setTBvals(b);
 								break;
 							case Key_Delete:
 								if (b->CPos == int(b->Ptext.count())) { return; }
 								if (b->Ptext.count() == 0) { return; }
 								cr = b->Ptext.at(b->CPos)->ch;
 								if (b->HasSel)
 									{
 									DeleteSel(b);
 									}
 								else
 									{
 									b->Ptext.remove(b->CPos);
 									}
 								b->Tinput = false;
 								if (cr == QChar(13))
 									{
 									doc->ActPage->chAbStyle(b, b->Ptext.at(QMAX(b->CPos-1,0))->cab);
 									b->Tinput = false;
 									}
 								setTBvals(b);
 								b->Dirty = true;
 								b->paintObj();
 								break;
 							case Key_Backspace:
 								if (b->CPos == 0)
 									return;
 								if (b->Ptext.count() == 0) { return; }
 								cr = b->Ptext.at(QMAX(b->CPos-1,0))->ch;
 								if (b->HasSel)
 									{
 									DeleteSel(b);
 									}
 								else
 									{
 									b->CPos -= 1;
 									b->Ptext.remove(b->CPos);
 									}
 								b->Tinput = false;
 								if ((cr == QChar(13)) && (b->Ptext.count() != 0))
 									{
 									doc->ActPage->chAbStyle(b, b->Ptext.at(QMAX(b->CPos-1,0))->cab);
 									b->Tinput = false;
 									}
 								setTBvals(b);
 								b->Dirty = true;
 								b->paintObj();
 								break;
 							default:
 								if ((b->HasSel) && (kk < 0x1000))
 									{
 									DeleteSel(b);
 									b->Dirty = true;
 									b->paintObj();
 									}
 								if ((kk + KeyMod) == Prefs.KeyActions[60].KeyID)
 									{
 									as = 30;
 									uc = QString(QChar(30));
 									}
 								if ((kk + KeyMod) == Prefs.KeyActions[56].KeyID)
 									{
 									b->Ptext.at(QMAX(b->CPos-1,0))->cstyle ^= 128;
 									b->Dirty = true;
 									b->Tinput = true;
 									b->paintObj();
 									break;
 									}
 								if ((kk + KeyMod) == Prefs.KeyActions[59].KeyID)
 									{
									setNewAbStyle(1);
 									b->Dirty = true;
 									b->Tinput = true;
 									b->paintObj();
 									break;
 									}
 								if ((kk + KeyMod) == Prefs.KeyActions[57].KeyID)
 									{
									setNewAbStyle(0);
 									b->Dirty = true;
 									b->Tinput = true;
 									b->paintObj();
 									break;
 									}
 								if ((kk + KeyMod) == Prefs.KeyActions[58].KeyID)
 									{
									setNewAbStyle(2);
 									b->Dirty = true;
 									b->Tinput = true;
 									b->paintObj();
 									break;
 									}
 								if ((as > 31) || (as == 13) || (as == 30))
 									{
 									hg = new Pti;
 									hg->ch = uc;
 									hg->cfont = b->IFont;
 									hg->csize = b->ISize;
 									hg->ccolor = b->Pcolor2;
 									hg->cextra = 0;
 									hg->cshade = b->Shade2;
 									hg->cselect = false;
 									hg->cstyle = CurrentStyle;
 									hg->cab = CurrentABStil;
 									hg->xp = 0;
 									hg->yp = 0;
 									b->Ptext.insert(b->CPos, hg);
 									b->CPos += 1;
 									if ((b->CPos < int(b->Ptext.count())) || (as == 30))
 										b->Dirty = true;
 									b->Tinput = true;
 									b->paintObj();
 									}
 								break;
 							}
 						if (b->Ptext.count() != 0)
 							if (b->Ptext.at(QMAX(b->CPos-1, 0))->yp != 0)
 								doc->ActPage->slotDoCurs(true);
 						if ((kk == Key_Left) || (kk == Key_Right) || (kk == Key_Up) || (kk == Key_Down))
 							return;
 						}
 					break;
 				}
 			slotDocCh();
 			}
 		}
}

void ScribusApp::closeEvent(QCloseEvent *ce)
{
	if ((HaveDoc) && doc->isModified())
		{
		if (queryExit())
			{
			SavePrefs();
			if (Prefs.SaveAtQ)
				{
				if (ScBook->ScFilename.isEmpty())
					ScBook->ScFilename = QString(getenv("HOME"))+"/.scribusscrap.scs";
				ScBook->Save();
				}
			if (ScBook->BibWin->Objekte.count() == 0)
				system("rm -f " + QString(getenv("HOME"))+"/.scribusscrap.scs");			
			qApp->setOverrideCursor(QCursor(ArrowCursor), true);
			Mpal2->UnsetDoc();
			view->close(true);
			delete doc;
			Prefs.AvailFonts.~SCFonts();
#ifdef HAVE_CMS
			if (CMSavail)
				CloseCMSProfiles();
#endif
//			exit(0);
			ce->accept();
			}
		else
			{
			ce->ignore();
			return;
			}
		}
	else
		{
		SavePrefs();
		if (Prefs.SaveAtQ)
			{
			if (ScBook->ScFilename.isEmpty())
				ScBook->ScFilename = QString(getenv("HOME"))+"/.scribusscrap.scs";
			ScBook->Save();
			}
		if (ScBook->BibWin->Objekte.count() == 0)
			system("rm -f " + QString(getenv("HOME"))+"/.scribusscrap.scs");
		qApp->setOverrideCursor(QCursor(ArrowCursor), true);
		Prefs.AvailFonts.~SCFonts();
#ifdef HAVE_CMS
		if (CMSavail)
			CloseCMSProfiles();
#endif
//		exit(0);
		ce->accept();
		}
}

bool ScribusApp::queryExit()
{
  bool retw = false;
  int exit=QMessageBox::information(this,
  																	tr("Warning"),
                                    tr("The document has been changed since the last save."),
                                    tr("Save Now"),
                                    tr("Cancel"),
                                    tr("Leave Anyway"),
                                    0, 1);
  switch (exit)
  	{
  	case 0:
  		slotFileSaveAs();
  		retw = true;
  		break;
  	case 1:
  		retw = false;
  		break;
  	case 2:
  		retw = true;
  		break;
  	}
  return retw;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////
float ScribusApp::mm2pts(int mm)
{
	return mm / 25.4 * 72;
}

float ScribusApp::pts2mm(float pts)
{
	return pts / 72 * 25.4;
}

void ScribusApp::slotFileNew()
{
	float b, h, tpr, lr, rr, br, sp, ab;
	bool fp, atf;
	QString cc;
	if (HaveDoc)
		{
		if (!slotFileClose())
			return;
		}
	NewDoc* dia = new NewDoc(this, Prefs.Einheit);
	if (dia->exec())
		{
		if (Prefs.Einheit == 0)
			{
			b = float(dia->Breite->value());
			h = float(dia->Hoehe->value());
			tpr = float(dia->TopR->value());
			lr = float(dia->LeftR->value());
			rr = float(dia->RightR->value());
			br = float(dia->BottomR->value());
			ab = float(dia->Distance->value());
			}
		else
			{
			b = mm2pts(dia->Breite->value());
			h = mm2pts(dia->Hoehe->value());
			tpr = mm2pts(dia->TopR->value());
			lr = mm2pts(dia->LeftR->value());
			rr = mm2pts(dia->RightR->value());
			br = mm2pts(dia->BottomR->value());
			ab = mm2pts(dia->Distance->value());
			}
		sp = dia->SpinBox10->value();
		atf = dia->AutoFrame->isChecked();
		fp = dia->Doppelseiten->isChecked();
		doc = new ScribusDoc();
		if (fp)
			doc->FirstPageLeft = dia->ErsteSeite->isChecked();
		doc->AllFonts = &Prefs.AvailFonts;
		doc->AddFont(Prefs.DefFont, Prefs.AvailFonts[Prefs.DefFont]->Font);
		doc->Dfont = Prefs.DefFont;
		doc->Dsize = Prefs.DefSize;
		doc->GrabRad = Prefs.GrabRad;
		doc->minorGrid = Prefs.DminGrid;
		doc->majorGrid = Prefs.DmajGrid;
		doc->minorColor = Prefs.DminColor;
		doc->majorColor = Prefs.DmajColor;
		doc->papColor = Prefs.DpapColor;
		doc->margColor = Prefs.DmargColor;
		doc->VHoch = Prefs.DVHoch;
		doc->VHochSc = Prefs.DVHochSc;
		doc->VTief = Prefs.DVTief;
		doc->VTiefSc = Prefs.DVTiefSc;
		doc->VKapit = Prefs.DVKapit;
  	doc->Dpen = Prefs.Dpen;
  	doc->DpenText = Prefs.DpenText;
  	doc->Dbrush = Prefs.Dbrush;
  	doc->Dshade = Prefs.Dshade;
  	doc->Dshade2 = Prefs.Dshade2;
  	doc->DLineArt = PenStyle(Prefs.DLineArt);
  	doc->Dwidth = Prefs.Dwidth;
  	doc->DpenLine = Prefs.DpenLine;
  	doc->DshadeLine = Prefs.DshadeLine;
  	doc->DLstyleLine = PenStyle(Prefs.DLstyleLine);
  	doc->DwidthLine = Prefs.DwidthLine;
  	doc->MagMin = Prefs.MagMin;
  	doc->MagMax = Prefs.MagMax;
  	doc->MagStep = Prefs.MagStep;
  	doc->DbrushPict = Prefs.DbrushPict;
		doc->ShadePict = Prefs.ShadePict;
		doc->ScaleX = Prefs.ScaleX;
		doc->ScaleY = Prefs.ScaleY;
		doc->Before = Prefs.Before;
		doc->Einheit = Prefs.Einheit;
		doc->PagesSbS = Prefs.PagesSbS;
		doc->ShFrames = Prefs.ShFrames;
		doc->RandFarbig = Prefs.RandFarbig;
		doc->AutoLine = Prefs.AutoLine;
		doc->DocName = doc->DocName+cc.setNum(DocNr);
		doc->HasCMS = true;
		doc->CMSSettings.DefaultInputProfile = Prefs.DCMSset.DefaultInputProfile;
		doc->CMSSettings.DefaultInputProfile2 = Prefs.DCMSset.DefaultInputProfile2;
		doc->CMSSettings.DefaultMonitorProfile = Prefs.DCMSset.DefaultMonitorProfile;
		doc->CMSSettings.DefaultPrinterProfile = Prefs.DCMSset.DefaultPrinterProfile;
		doc->CMSSettings.DefaultIntentPrinter = Prefs.DCMSset.DefaultIntentPrinter;
		doc->CMSSettings.DefaultIntentMonitor = Prefs.DCMSset.DefaultIntentMonitor;
		doc->CMSSettings.DefaultIntentMonitor2 = Prefs.DCMSset.DefaultIntentMonitor2;
		doc->CMSSettings.SoftProofOn = Prefs.DCMSset.SoftProofOn;
		doc->CMSSettings.CMSinUse = Prefs.DCMSset.CMSinUse;
		HaveDoc = TRUE;
		if (CMSavail)
			{
			OpenCMSProfiles();
#ifdef HAVE_CMS
			SoftProofing = Prefs.DCMSset.SoftProofOn;
			CMSuse = Prefs.DCMSset.CMSinUse;
			IntentPrinter = Prefs.DCMSset.DefaultIntentPrinter;
			IntentMonitor = Prefs.DCMSset.DefaultIntentMonitor;
#endif
			if ((Prefs.DCMSset.CMSinUse) && (Prefs.DCMSset.SoftProofOn))
				RecalcColors();
			}
		DocNr++;
		doc->Scale = 1.0;
		doc->AppMode = 1;
		doc->PageColors = Prefs.DColors;
		view=new ScribusView(this, doc, &Prefs);
		setCentralWidget(view);
		view->show();
		doc->setPage(b, h, tpr, lr, rr, br, sp, ab, atf, fp);
		slotNewPage(0);
		HaveNewDoc();
		view->Pages.at(0)->parentWidget()->hide();
		view->DocPages = view->Pages;
		view->Pages = view->MasterPages;
		doc->PageC = view->MasterPages.count();
		bool atf = doc->PageAT;
		doc->PageAT = false;
		slotNewPage(0);
		doc->PageAT = atf;
		view->MasterNames["Normal"] = 0;
		view->Pages.at(0)->PageNam = "Normal";
		view->Pages.at(0)->parentWidget()->hide();
		view->MasterPages = view->Pages;
		doc->PageC = view->DocPages.count();
		view->Pages = view->DocPages;
		doc->MasterP = false;
		view->Pages.at(0)->MPageNam = "Normal";
		view->Pages.at(0)->parentWidget()->show();
		doc->setUnModified();
  	statusBar()->message(tr("Ready"), 3000);
		}
	delete dia;
}

void ScribusApp::SetupDoc()
{
	float tpr = doc->PageM.Top;
	float lr = doc->PageM.Left;
	float rr = doc->PageM.Right;
	float br = doc->PageM.Bottom;	
	bool fp = doc->PageFP;
	bool fpe = doc->FirstPageLeft;
	float tpr2, lr2, rr2, br2;
	ReformDoc* dia = new ReformDoc(this, tpr, lr, rr, br, fp, fpe, doc->Einheit);
	if (dia->exec())
		{
		if (doc->Einheit == 0)
			{
			tpr2 = float(dia->TopR->value());
			lr2 = float(dia->LeftR->value());
			rr2 = float(dia->RightR->value());
			br2 = float(dia->BottomR->value());
			}
		else
			{
			tpr2 = mm2pts(dia->TopR->value());
			lr2 = mm2pts(dia->LeftR->value());
			rr2 = mm2pts(dia->RightR->value());
			br2 = mm2pts(dia->BottomR->value());
			}
		fp = dia->Doppelseiten->isChecked();
		if (fp)
			doc->FirstPageLeft = dia->ErsteSeite->isChecked();
		doc->resetPage(tpr2, lr2, rr2, br2, fp);
		view->reformPages();
		view->GotoPage(doc->ActPage->PageNr);
		view->DrawNew();
		}
	delete dia;
}

void ScribusApp::HaveNewDoc()
{
	int a;
	DatPri->setEnabled(true);
	DatPDF->setEnabled(true);
	fileMenu->setItemEnabled(fid1, 1);
	fileMenu->setItemEnabled(fid4, 0);
	fileMenu->setItemEnabled(fid5, 1);
	fileMenu->setItemEnabled(fid6, 1);
	fileMenu->setItemEnabled(fid7, 1);
	exportMenu->setItemEnabled(fid8, 1);
	fileMenu->setItemEnabled(fid9, 1);
	if (PDFavailable)
		exportMenu->setItemEnabled(fid10, 1);
	fileMenu->setItemEnabled(fid11, 1);
	editMenu->setItemEnabled(edid1, 0);
	editMenu->setItemEnabled(edid2, 0);
	editMenu->setItemEnabled(edid3, 0);
	editMenu->setItemEnabled(edid6, 1);
	for (a=0; a<6; a++)
		{
		viewMenu->setItemEnabled(viewMenu->idAt(a), 1);
		}
	viewMenu->setItemEnabled(Markers, 1);
	viewMenu->setItemEnabled(FrameDr, 1);
	viewMenu->setItemEnabled(Bilder, 1);
	viewMenu->setItemEnabled(Ras, 1);
	viewMenu->setItemEnabled(uRas, 1);
	viewMenu->setItemChecked(uRas, doc->useRaster);
	menuBar()->setItemEnabled(pgmm, 1);
	menuBar()->setItemEnabled(exmn, 1);
	if (view->Pages.count() > 1)
		{
		pageMenu->setItemEnabled(pgmd, 1);
		pageMenu->setItemEnabled(pgmv, 1);
		}
	else
		{
		pageMenu->setItemEnabled(pgmd, 0);
		pageMenu->setItemEnabled(pgmv, 0);
		}
	editMenu->setItemEnabled(tman, 1);
	CListe::Iterator it;
	QPixmap pm = QPixmap(15, 15);
	a = 0;
	ColorMenu->clear();
	ColorMenu->insertItem(tr("None"));
	for (it = doc->PageColors.begin(); it != doc->PageColors.end(); ++it)
		{
		pm.fill(doc->PageColors[it.key()].getRGBColor());
		ColorMenu->insertItem(QIconSet(pm), it.key());
		if (it.key() == doc->Dbrush)
			{
			ColorMenu->setItemChecked(ColorMenu->idAt(a), true);
			}
		a++;
		}
	Cpal->SetColors(doc->PageColors);
	setCaption(tr(doc->DocName));
	ShadeMenu->setItemChecked(ShadeMenu->idAt(11), true);
	connect(view, SIGNAL(changeUN(int)), this, SLOT(slotChangeUnit(int)));
	Mpal2->SetDoc(doc);
	Spal->SetFormats(doc);
	CurrentABStil = 0;
	slotChangeUnit(doc->Einheit);
  BuildFontMenu();
	if (doc->ShFrames)
		viewMenu->changeItem(FrameDr, tr("Hide Frames"));
	else
		viewMenu->changeItem(FrameDr, tr("Show Frames"));
	DatClo->setEnabled(true);
}

void ScribusApp::HaveNewSel(int Nr)
{
	PageItem *b;
	switch (Nr)
		{
		case -1:
			importMenu->changeItem(fid2, tr("Get Text/Picture..."));
			importMenu->setItemEnabled(fid2, 0);
			exportMenu->setItemEnabled(fid3, 0);
			menuBar()->setItemEnabled(Stm, 0);
			menuBar()->setItemEnabled(Obm, 0);
			ObjMenu->setItemEnabled(ShapeM, 0);
			editMenu->setItemEnabled(edid1, 0);
			editMenu->setItemEnabled(edid2, 0);
			editMenu->setItemEnabled(edid4, 0);
			editMenu->setItemEnabled(edid5, 0);
			StilMenu->clear();
			KetteAus->setEnabled(false);
			KetteEin->setEnabled(false);
			Textedit->setEnabled(false);
			Rotiere->setEnabled(false);
			break;
		case 2:
			importMenu->changeItem(fid2, tr("Get Picture..."));
			importMenu->setItemEnabled(fid2, 1);
			editMenu->setItemEnabled(edid1, 1);
			editMenu->setItemEnabled(edid2, 1);
			editMenu->setItemEnabled(edid4, 0);
			editMenu->setItemEnabled(edid5, 0);
			menuBar()->setItemEnabled(Stm, 1);
			menuBar()->setItemEnabled(Obm, 1);
			ObjMenu->setItemEnabled(ShapeM, 1);
			StilMenu->clear();
			StilMenu->insertItem(tr("Color"), ColorMenu);
			StilMenu->insertItem(tr("Invert"));
			KetteAus->setEnabled(false);
			KetteEin->setEnabled(false);
			Textedit->setEnabled(true);
			Rotiere->setEnabled(true);
 			Mpal2->SetCurItem(doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0)));
			break;
		case 4:
			importMenu->changeItem(fid2, tr("Get Text..."));
			importMenu->setItemEnabled(fid2, 1);
			exportMenu->setItemEnabled(fid3, 1);
			editMenu->setItemEnabled(edid1, 1);
			editMenu->setItemEnabled(edid2, 1);
			editMenu->setItemEnabled(edid4, 0);
			editMenu->setItemEnabled(edid5, 0);
			menuBar()->setItemEnabled(Stm, 1);
			menuBar()->setItemEnabled(Obm, 1);
			ObjMenu->setItemEnabled(ShapeM, 1);
			StilMenu->clear();
			StilMenu->insertItem(tr("Font"), FontMenu);
			StilMenu->insertItem(tr("Size"), SizeTMenu);
			StilMenu->insertItem(tr("Style"), TypeStyleMenu);
			StilMenu->insertItem(tr("Alignment"), AliMenu);
			StilMenu->insertItem(tr("Color"), ColorMenu);
			StilMenu->insertItem(tr("Shade"), ShadeMenu);
			Rotiere->setEnabled(true);
			b = doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0));
			if ((b->NextBox != 0) || (b->BackBox != 0))
				{
				KetteAus->setEnabled(true);
				if ((b->BackBox != 0) && (b->Ptext.count() == 0))
					Textedit->setEnabled(false);
				else
					Textedit->setEnabled(true);
				}
			else
				Textedit->setEnabled(true);
			if (b->NextBox == 0)
				KetteEin->setEnabled(true);
			if (doc->MasterP)
				KetteEin->setEnabled(false);
 			Mpal2->SetCurItem(b);
			CurrentStyle = 0;
			doc->Vorlagen[0].LineSpa = b->LineSp;
			doc->Vorlagen[0].Ausri = b->Ausrich;
			break;
		default:
			importMenu->changeItem(fid2, tr("Get Text/Picture..."));
			importMenu->setItemEnabled(fid2, 0);
			exportMenu->setItemEnabled(fid3, 0);
			editMenu->setItemEnabled(edid1, 1);
			editMenu->setItemEnabled(edid2, 1);
			editMenu->setItemEnabled(edid4, 0);
			editMenu->setItemEnabled(edid5, 0);
			menuBar()->setItemEnabled(Stm, 1);
			menuBar()->setItemEnabled(Obm, 1);
			ObjMenu->setItemEnabled(ShapeM, 0);
			StilMenu->clear();
			StilMenu->insertItem(tr("Color"), ColorMenu);
			StilMenu->insertItem(tr("Shade"), ShadeMenu);
			KetteAus->setEnabled(false);
			KetteEin->setEnabled(false);
			Textedit->setEnabled(false);
			Rotiere->setEnabled(true);
 			Mpal2->SetCurItem(doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0)));
			break;
		}
	doc->CurrentSel = Nr;
	if (doc->ActPage->SelItem.count() > 1)
		{
		ObjMenu->setItemEnabled(DistM, 1);
		ObjMenu->setItemEnabled(Gr, 1);
		}
	else
		{
		ObjMenu->setItemEnabled(DistM, 0);
		ObjMenu->setItemEnabled(Gr, 0);
		}
	if (doc->ActPage->SelItem.count() != 0)
		{
		if(doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0))->Groups.count() != 0)
			ObjMenu->setItemEnabled(UnGr, 1);
		else
			ObjMenu->setItemEnabled(UnGr, 0);
		}
}

void ScribusApp::slotDocCh()
{
	Tpal->BuildTree(view);
	if (!doc->isModified())
		{
		doc->setModified();
		setCaption(tr(doc->DocName) + "*");
		}
	if ((!doc->DocName.startsWith("Document")) && (!TemplateMode))
		{
		fileMenu->setItemEnabled(fid4, 1);
		DatSav->setEnabled(true);
		DatClo->setEnabled(true);
		}
}

void ScribusApp::UpdateRecent(QString fn)
{
	recentMenu->clear();
	if (RecentDocs.findIndex(fn) == -1)
		RecentDocs.prepend(fn);
	else
		{
		RecentDocs.remove(fn);
		RecentDocs.prepend(fn);
		}
	uint max = QMIN(Prefs.RecentDCount, RecentDocs.count());
	for (uint m = 0; m < max; m++)
		{
		recentMenu->insertItem(RecentDocs[m]);
		}
}

void ScribusApp::LoadRecent(int id)
{
	QString fn = recentMenu->text(id);
	QFileInfo fd(fn);
	if (!fd.exists())
		{
		RecentDocs.remove(fn);
		recentMenu->clear();
		uint max = QMIN(Prefs.RecentDCount, RecentDocs.count());
		for (uint m = 0; m < max; m++)
			{
			recentMenu->insertItem(RecentDocs[m]);
			}
		return;
		}
	if (HaveDoc)
		{
		if(!slotFileClose())
			return;
		}
  qApp->setOverrideCursor(QCursor(waitCursor), true);
	LadeDoc(recentMenu->text(id));
  qApp->setOverrideCursor(QCursor(arrowCursor), true);
}

void ScribusApp::slotDocOpen()
{
	if (HaveDoc)
		{
		if(!slotFileClose())
			return;
		}
	QString fileName = CFileDialog(tr("Open"),tr("Documents (*.scd);; All Files (*)"));
  qApp->setOverrideCursor(QCursor(waitCursor), true);
	LadeDoc(fileName);
  qApp->setOverrideCursor(QCursor(arrowCursor), true);
	}
	
void ScribusApp::LadeDoc(QString fileName)
{
  if (!fileName.isEmpty())
  	{
		doc=new ScribusDoc();
		doc->AllFonts = &Prefs.AvailFonts;
		doc->Dsize = Prefs.DefSize;
		doc->GrabRad = Prefs.GrabRad;
		doc->minorGrid = Prefs.DminGrid;
		doc->majorGrid = Prefs.DmajGrid;
		doc->minorColor = Prefs.DminColor;
		doc->majorColor = Prefs.DmajColor;
		doc->papColor = Prefs.DpapColor;
		doc->margColor = Prefs.DmargColor;
  	doc->Dpen = Prefs.Dpen;
  	doc->DpenText = Prefs.DpenText;
  	doc->Dbrush = Prefs.Dbrush;
  	doc->Dshade = Prefs.Dshade;
  	doc->Dshade2 = Prefs.Dshade2;
  	doc->DLineArt = PenStyle(Prefs.DLineArt);
  	doc->Dwidth = Prefs.Dwidth;
  	doc->DpenLine = Prefs.DpenLine;
  	doc->DshadeLine = Prefs.DshadeLine;
  	doc->DLstyleLine = PenStyle(Prefs.DLstyleLine);
  	doc->DwidthLine = Prefs.DwidthLine;
  	doc->MagMin = Prefs.MagMin;
  	doc->MagMax = Prefs.MagMax;
  	doc->MagStep = Prefs.MagStep;
  	doc->DbrushPict = Prefs.DbrushPict;
		doc->ShadePict = Prefs.ShadePict;
		doc->ScaleX = Prefs.ScaleX;
		doc->ScaleY = Prefs.ScaleY;
		doc->Before = Prefs.Before;
		doc->Einheit = Prefs.Einheit;
		doc->PagesSbS = Prefs.PagesSbS;
		doc->ShFrames = Prefs.ShFrames;
		doc->RandFarbig = Prefs.RandFarbig;
		doc->AutoLine = Prefs.AutoLine;
		doc->Scale = 1.0;
		doc->AppMode = 1;
		doc->HasCMS = false;	
		view=new ScribusView(this, doc, &Prefs);
  	ScriXmlDoc *ss = new ScriXmlDoc();
  	connect(ss, SIGNAL(NewPage(int)), this, SLOT(slotNewPage(int)));
		setCentralWidget(view);
		view->show();
		doc->loading = true;
#ifdef HAVE_CMS
		SoftProofing = false;
		bool cmsu = CMSuse;
		CMSuse = false;
#endif
  	if(!ss->ReadDoc(fileName, Prefs.AvailFonts, doc, view))
  		{
  		delete ss;
  		delete doc;
  		delete view;
    	statusBar()->message(tr("Loading aborted"), 4000);
  		return;
  		}
  	delete ss;
#ifdef HAVE_CMS
		CMSuse = cmsu;
#endif
		HaveDoc = true;
		if (!doc->HasCMS)
			{
			doc->CMSSettings.DefaultInputProfile = Prefs.DCMSset.DefaultInputProfile;
			doc->CMSSettings.DefaultInputProfile2 = Prefs.DCMSset.DefaultInputProfile2;
			doc->CMSSettings.DefaultMonitorProfile = Prefs.DCMSset.DefaultMonitorProfile;
			doc->CMSSettings.DefaultPrinterProfile = Prefs.DCMSset.DefaultPrinterProfile;
			doc->CMSSettings.DefaultIntentPrinter = Prefs.DCMSset.DefaultIntentPrinter;
			doc->CMSSettings.DefaultIntentMonitor = Prefs.DCMSset.DefaultIntentMonitor;
			doc->CMSSettings.DefaultIntentMonitor2 = Prefs.DCMSset.DefaultIntentMonitor2;
			doc->CMSSettings.SoftProofOn = Prefs.DCMSset.SoftProofOn;
			doc->CMSSettings.CMSinUse = false;
			}
		if (CMSavail)
			{
			if (!InputProfiles.contains(doc->CMSSettings.DefaultInputProfile))
				doc->CMSSettings.DefaultInputProfile = Prefs.DCMSset.DefaultInputProfile;
			if (!InputProfiles.contains(doc->CMSSettings.DefaultInputProfile2))
				doc->CMSSettings.DefaultInputProfile2 = Prefs.DCMSset.DefaultInputProfile2;
			if (!MonitorProfiles.contains(doc->CMSSettings.DefaultMonitorProfile))
				doc->CMSSettings.DefaultMonitorProfile = Prefs.DCMSset.DefaultMonitorProfile;
			if (!PrinterProfiles.contains(doc->CMSSettings.DefaultPrinterProfile))
				doc->CMSSettings.DefaultPrinterProfile = Prefs.DCMSset.DefaultPrinterProfile;
			OpenCMSProfiles();
#ifdef HAVE_CMS
			SoftProofing = doc->CMSSettings.SoftProofOn;
			CMSuse = doc->CMSSettings.CMSinUse;
			IntentPrinter = doc->CMSSettings.DefaultIntentPrinter;
			IntentMonitor = doc->CMSSettings.DefaultIntentMonitor;
#endif
			if ((doc->CMSSettings.CMSinUse) && (doc->CMSSettings.SoftProofOn))
				{
				RecalcColors();
				view->RecalcPictures(&InputProfiles);
				}
			}
		Cpal->SetColors(doc->PageColors);
		doc->DocName = fileName;
		doc->MasterP = false;
		HaveNewDoc();
		if (view->MasterPages.count() == 0)
			{
			for (uint ax=0; ax<view->Pages.count(); ax++)
				{
				view->Pages.at(ax)->parentWidget()->hide();
				}
			view->DocPages = view->Pages;
			view->Pages = view->MasterPages;
			doc->PageC = view->MasterPages.count();
			bool atf = doc->PageAT;
			doc->PageAT = false;
			slotNewPage(0);
			doc->PageAT = atf;
			view->MasterNames["Normal"] = 0;
			view->Pages.at(0)->PageNam = "Normal";
			view->Pages.at(0)->parentWidget()->hide();
			view->MasterPages = view->Pages;
			doc->PageC = view->DocPages.count();
			view->Pages = view->DocPages;
			doc->MasterP = false;
			for (uint ay=0; ay<view->Pages.count(); ay++)
				{
				view->Pages.at(ay)->parentWidget()->show();
				}
			}
		doc->setUnModified();
		doc->loading = false;
		view->GotoPage(0);
		setActiveWindow();
		UpdateRecent(fileName);
  	}
}

void ScribusApp::slotFileOpen()
{
  if (doc->ActPage->SelItem.count() != 0)
  	{
 		PageItem *b = doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0));
  	if (b->PType == 2)
  		{
  		QString fileName = CFileDialog(tr("Open"),tr("Images (*.tif *.png *.jpg *.xpm);;Postscript (*.eps);;All Files (*)"), "", true);
  		if (!fileName.isEmpty())
  			{
  			b->EmProfile = "";
  			b->UseEmbedded = true;
  			b->IProfile = doc->CMSSettings.DefaultInputProfile;
				b->IRender = doc->CMSSettings.DefaultIntentMonitor2;
    		doc->ActPage->LoadPict(fileName, *doc->ActPage->SelItem.at(0));
    		doc->ActPage->update();
    		QString message=tr("Picture ")+fileName+tr(" loaded");
    		statusBar()->message(message, 4000);
				slotDocCh();
  			}
  		else
  			{
    		statusBar()->message(tr("Loading aborted"), 4000);
  			}
  		}
  	if (b->PType == 4)
  		{
  		QString fileName = CFileDialog(tr("Open"),tr("Textfiles (*.txt);;All Files (*)"));
  		if (!fileName.isEmpty())
  			{
  			Serializer *ss = new Serializer(fileName);
  			if (ss->Read())
  				{
  				ss->GetText(b, CurrentABStil);
  				}
  			delete ss;
    		doc->ActPage->update();
    		QString message=tr("file ")+fileName+tr(" loaded");
    		statusBar()->message(message, 4000);
				slotDocCh();
  			}
  		else
  			{
    		statusBar()->message(tr("Loading aborted"), 4000);
  			}
  		}
  	}
}


void ScribusApp::slotFileSave()
{
  QString fn = doc->DocName;
  ScriXmlDoc *ss = new ScriXmlDoc();
  ss->WriteDoc(fn, doc, view);
	delete ss;
	doc->setUnModified();
	setCaption(fn);
	fileMenu->setItemEnabled(fid4, 0);
	DatSav->setEnabled(false);
  statusBar()->message(tr("Ready."));
}

void ScribusApp::slotFileSaveAs()
{
	QString fna;
  if (!doc->DocName.startsWith("Document"))
  	{
  	QFileInfo fi(doc->DocName);
  	fna = fi.dirPath()+"/"+fi.baseName()+".scd";
  	}
  else
  	{
  	QDir di = QDir();
  	fna = di.currentDirPath()+"/"+doc->DocName+".scd";
  	}
  QString fn = CFileDialog(tr("Save as"), tr("Documents (*.scd);; All Files (*)"), fna);
  if (!fn.isEmpty())
  	{
  	QFile f(fn);
  	if (f.exists())
  		{
  		int exit=QMessageBox::warning(this,
  																	tr("Warning"),
  																	tr("Do you really want to overwrite the File:\n%1 ?").arg(fn),
                                		tr("No"),
                                		tr("Yes"),
                                		0, 0, 1);
  		if (exit != 1)
  			return;
  		}
  	ScriXmlDoc *ss = new ScriXmlDoc();
  	ss->WriteDoc(fn, doc, view);
  	delete ss;
		doc->setUnModified();
		setCaption(fn);
		doc->DocName = fn;
		fileMenu->setItemEnabled(fid4, 0);
		DatSav->setEnabled(false);
		UpdateRecent(fn);
  	}
  else
  	{
    statusBar()->message(tr("Saving aborted"), 2000);
  	}
  statusBar()->message(tr("Ready"));
}

bool ScribusApp::slotFileClose()
{
  uint a;
  if (doc->isModified())
  	{
  	if (!queryExit())
  		return false;
  	}
  if (CMSavail)
  	CloseCMSProfiles();
  Mpal2->UnsetDoc();
  Spal->SetFormats(0);
  CurrentABStil = 0;
  view->close();
  for (a = 0; a<view->Pages.count(); a++)
  	{
  	delete view->Pages.at(a);
  	}
  delete view;
  delete doc;
  HaveDoc = FALSE;
	fileMenu->setItemEnabled(fid1, 0);
	importMenu->setItemEnabled(fid2, 0);
	exportMenu->setItemEnabled(fid3, 0);
	fileMenu->setItemEnabled(fid4, 0);
	fileMenu->setItemEnabled(fid5, 0);
	fileMenu->setItemEnabled(fid6, 0);
	fileMenu->setItemEnabled(fid7, 0);
	exportMenu->setItemEnabled(fid8, 0);
	fileMenu->setItemEnabled(fid9, 0);
	exportMenu->setItemEnabled(fid10, 0);
	fileMenu->setItemEnabled(fid11, 0);
	editMenu->setItemEnabled(edid1, 0);
	editMenu->setItemEnabled(edid2, 0);
	editMenu->setItemEnabled(edid3, 0);
	editMenu->setItemEnabled(edid4, 0);
	editMenu->setItemEnabled(edid5, 0);
	editMenu->setItemEnabled(edid6, 0);
	for (a=0; a<6; a++)
		{
		viewMenu->setItemEnabled(viewMenu->idAt(a), 0);
		}
	viewMenu->setItemEnabled(Markers, 0);
	viewMenu->setItemEnabled(FrameDr, 0);
	viewMenu->setItemEnabled(Bilder, 0);
	viewMenu->setItemEnabled(Ras, 0);
	viewMenu->setItemEnabled(uRas, 0);
	viewMenu->setItemChecked(uRas, false);
	viewMenu->changeItem(Markers, tr("Hide Margins"));
	viewMenu->changeItem(FrameDr, tr("Hide Frames"));
	viewMenu->changeItem(Bilder, tr("Hide Images"));
	viewMenu->changeItem(Ras, tr("Show Guides"));
	editMenu->setItemEnabled(tman, 0);
	menuBar()->setItemEnabled(pgmm, 0);
	menuBar()->setItemEnabled(exmn, 0);
	menuBar()->setItemEnabled(Stm, 0);
	menuBar()->setItemEnabled(Obm, 0);
	ColorMenu->clear();
	Cpal->SetColors(Prefs.DColors);
  statusBar()->message(tr("Ready."));
  setCaption(tr("Scribus " VERSION));
  Tpal->ListView1->clear();
	DatPri->setEnabled(false);
	DatPDF->setEnabled(false);
	DatSav->setEnabled(false);
	DatClo->setEnabled(false);
  PrinterUsed = false;
	return true;
}

void ScribusApp::slotFilePrint()
{
  QString fna, prn, cmd, cc, data, SepNam;
  int Anf, Ende, Nr;
  bool fil, sep, farbe, NoRaster;
  NoRaster = true;
  statusBar()->message(tr("Printing..."));
  if (PrinterUsed)
  	{
  	prn = PDef.Pname;
  	fna = PDef.Dname;
  	}
  else
  	{
  	prn = "";
  	if (!doc->DocName.startsWith("Document"))
  		{
  		QFileInfo fi(doc->DocName);
  		fna = fi.dirPath()+"/"+fi.baseName()+".ps";
  		}
  	else
  		{
  		QDir di = QDir();
  		fna = di.currentDirPath()+"/"+doc->DocName+".ps";
  		}
  	}
  for (uint p=0; p<view->Pages.count(); p++)
   	{
   	for (uint i=0; i<view->Pages.at(p)->Items.count(); i++)
   		{
   		if (view->Pages.at(p)->Items.at(i)->PType == 2)
   			if (view->Pages.at(p)->Items.at(i)->isRaster)
   				NoRaster = false;
   		}
   	}
  Druck *printer = new Druck(this, fna, prn, NoRaster);
  printer->setMinMax(1, view->Pages.count());
  printer->setFromTo(1, view->Pages.count());
  if (printer->exec())
  	{
  	qApp->setOverrideCursor(QCursor(waitCursor), true);
  	prn = printer->printerName();
  	fna = printer->outputFileName();
  	fil = printer->outputToFile();
  	Anf = printer->fromPage();
  	Ende = printer->toPage();
  	Nr = printer->numCopies();
  	sep = printer->outputSeparations();
  	SepNam = printer->separationName();
  	farbe = printer->color();
  	PDef.Pname = prn;
  	PDef.Dname = fna;
  	PrinterUsed = true;
		PSLib *dd = getPSDriver(true, Prefs.AvailFonts, doc->UsedFonts, doc->PageColors, false);
		if (dd != NULL)
			{
 			if (printer->pageOrder() == QPrinter::FirstPageFirst)
				data =  view->CreatePS(dd, Anf-1, Ende, 1, sep, SepNam, farbe);
			else
				data =  view->CreatePS(dd, Ende-1, Anf-2, -1, sep, SepNam, farbe);
			if (fil)
				{
				QFile f(fna);	
				if (f.open(IO_WriteOnly))
					{
					QTextStream t(&f);
					t.writeRawBytes(data, data.length());
					f.close();	
					}
				}
			else
				{
				QFile f("/tmp/sc.ps");	
				if (f.open(IO_WriteOnly))
					{
					QTextStream t(&f);
					t.writeRawBytes(data, data.length());
					f.close();	
					}
				cmd = "lpr -P" + prn;
				if (Nr > 1)
					cmd += " -#" + cc.setNum(Nr);
				cmd += " /tmp/sc.ps";
				system(cmd);
				system("rm -f /tmp/sc.ps");
				}
			delete dd;
			closePSDriver();
 			qApp->setOverrideCursor(QCursor(arrowCursor), true);
 			}
  	}
  delete printer;
	statusBar()->message(tr("Ready"));
}

void ScribusApp::slotFileQuit()
{
	Mpal2->UnsetDoc();
	close();
}

void ScribusApp::slotEditCut()
{
	uint a;
	NoFrameEdit();
	if ((HaveDoc) && (doc->ActPage->SelItem.count() != 0))
		{
		Buffer2 = "";
		PageItem *b = doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0));
		if ((doc->AppMode == 7) && (b->HasSel))
			{
			for (a = 0; a < b->Ptext.count(); a++)
				{
				if (b->Ptext.at(a)->cselect)
					{
					Buffer2 += b->Ptext.at(a)->ch+"\t";
					Buffer2 += b->Ptext.at(a)->cfont+"\t";
					Buffer2 += QString::number(b->Ptext.at(a)->csize)+"\t";
					Buffer2 += b->Ptext.at(a)->ccolor+"\t";
					Buffer2 += QString::number(b->Ptext.at(a)->cextra)+"\t";
					Buffer2 += QString::number(b->Ptext.at(a)->cshade)+'\t';
					Buffer2 += QString::number(b->Ptext.at(a)->cstyle)+'\t';
					Buffer2 += QString::number(b->Ptext.at(a)->cab)+'\n';
					}
				}
			DeleteSel(b);
			b->Dirty = true;
			b->paintObj();
			BufferSet2 = true;
			}
		else
			{
  		ScriXmlDoc *ss = new ScriXmlDoc();
			Buffer3 = ss->WriteElem(&doc->ActPage->SelItem, doc);
			BufferSet = true;
			doc->ActPage->DeleteItem();
			}
		slotDocCh();
		editMenu->setItemEnabled(edid3, 1);
		}
}

void ScribusApp::slotEditCopy()
{
	uint a;
	NoFrameEdit();
	if ((HaveDoc) && (doc->ActPage->SelItem.count() != 0))
		{
		Buffer2 = "";
		PageItem *b = doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0));
		if ((doc->AppMode == 7) && (b->HasSel))
			{
			for (a = 0; a < b->Ptext.count(); a++)
				{
				if (b->Ptext.at(a)->cselect)
					{
					Buffer2 += b->Ptext.at(a)->ch+"\t";
					Buffer2 += b->Ptext.at(a)->cfont+"\t";
					Buffer2 += QString::number(b->Ptext.at(a)->csize)+"\t";
					Buffer2 += b->Ptext.at(a)->ccolor+"\t";
					Buffer2 += QString::number(b->Ptext.at(a)->cextra)+"\t";
					Buffer2 += QString::number(b->Ptext.at(a)->cshade)+'\t';
					Buffer2 += QString::number(b->Ptext.at(a)->cstyle)+'\t';
					Buffer2 += QString::number(b->Ptext.at(a)->cab)+'\n';
					}
				}
			BufferSet2 = true;
			}
		else
			{
  		ScriXmlDoc *ss = new ScriXmlDoc();
			Buffer3 = ss->WriteElem(&doc->ActPage->SelItem, doc);
			delete ss;
			BufferSet = true;
			}
		editMenu->setItemEnabled(edid3, 1);
		}
}

void ScribusApp::slotEditPaste()
{
	struct Pti *hg;
	NoFrameEdit();
	if (HaveDoc)
		{
		if ((doc->AppMode == 7) && (BufferSet2))
			{
			PageItem *b = doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0));
			QTextStream t(&Buffer2, IO_ReadOnly);
			QString cc;
			while (!t.atEnd())
				{
				cc = t.readLine();
				QStringList wt;
				QStringList::Iterator it;
				wt = QStringList::split("\t", cc);
				it = wt.begin();
				hg = new Pti;
				hg->ch = (*it);
				it++;
				hg->cfont = *it;
				it++;
				hg->csize = (*it).toInt();
				it++;
				hg->ccolor = *it;
				it++;
				hg->cextra = (*it).toInt();
				it++;
				hg->cshade = (*it).toInt();
				hg->cselect = false;
				it++;
				hg->cstyle = (*it).toInt();
				it++;
				hg->cab = (*it).toInt();
 				b->Ptext.insert(b->CPos, hg);
 				b->CPos += 1;
 				}
 			if (b->CPos < int(b->Ptext.count())) { b->Dirty = true; }
 			b->paintObj();
			}
		else
			{
			if (BufferSet);
				{
				slotElemRead(Buffer3, 0, 0, false, true);
				doc->ActPage->SelectItemNr(doc->ActPage->Items.count()-1);
				}	
			}
		slotDocCh();
		}
}

void ScribusApp::SelectAll()
{
	uint a;
	PageItem *b = doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0));
	for (a = 0; a < b->Ptext.count(); a++)
		{
		b->Ptext.at(a)->cselect = true;
		}
	b->HasSel = true;
	b->Dirty = true;
	b->paintObj();
	EnableTxEdit();
}

void ScribusApp::DeleteText()
{
	PageItem *b = doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0));
	DeleteSel(b);
	b->Dirty = true;
	b->paintObj();
	slotDocCh();
}

void ScribusApp::EnableTxEdit()
{
	editMenu->setItemEnabled(edid1, 1);
	editMenu->setItemEnabled(edid2, 1);
	editMenu->setItemEnabled(edid4, 1);
}

void ScribusApp::DisableTxEdit()
{
	editMenu->setItemEnabled(edid1, 0);
	editMenu->setItemEnabled(edid2, 0);
	editMenu->setItemEnabled(edid4, 0);
}

void ScribusApp::slotHelpAbout()
{
	void *mo;
	char *error;
	typedef About* (*sdem)(QWidget *d);
	sdem demo;
	QString pfad = PREL;
	pfad += "/share/scribus/libs/libabout.so";
	mo = dlopen(pfad, RTLD_LAZY);
	if (!mo)
		{
		cout << "Can't find Plugin" << endl;
		return;
		}
	dlerror();
	demo = (sdem)dlsym(mo, "Run");
	if ((error = dlerror()) != NULL)
		{
		cout << "Can't find Symbol" << endl;
		dlclose(mo);
		return;
		}
	About* dia = (*demo)(this);
	dia->exec();
	delete dia;
	dlclose(mo);
}

void ScribusApp::slotHelpAboutQt()
{
  QMessageBox::aboutQt(this,tr("About Qt"));
}

void ScribusApp::slotOnlineHelp()
{
	HelpBrowser *dia = new HelpBrowser(this);
	dia->show();
}

void ScribusApp::ToggleTips()
{
  tipsOn = !tipsOn;
  helpMenu->setItemChecked(tip, tipsOn);
  QToolTip::setEnabled(tipsOn);
}

void ScribusApp::SaveText()
{
  QString fn = CFileDialog(tr("Save as"), tr("Textfiles (*.txt);;All Files (*)"));
  if (!fn.isEmpty())
  	{
    Serializer *se = new Serializer(fn);
    se->PutText(doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0)));
    se->Write();
    delete se;
  	}
  else
  	{
    statusBar()->message(tr("Saving aborted"), 2000);
  	}
}

void ScribusApp::applyNewMaster(QString name)
{
	if (name == tr("Normal"))
		name = "Normal";
	doc->ActPage->MPageNam = name;
}

/** Erzeugt eine neue Seite */
void ScribusApp::slotNewPageM()
{
	int wo, cc;
	NoFrameEdit();
	doc->ActPage->Deselect();
	InsPage *dia = new InsPage(this, view, doc->ActPage->PageNr, view->Pages.count(), doc->PageFP);
	if (dia->exec())
		{
		wo = dia->ActualPage->value();
		switch (dia->Where->currentItem())
			{
			case 0:
				wo -= 1;
				for (cc = 0; cc < dia->NumPages->value(); cc++)
					{
					slotNewPage(wo);
					if (doc->PageFP)
						{
 						if ((doc->ActPage->PageNr % 2 == 0) && (doc->FirstPageLeft))
							applyNewMaster(dia->Based->currentText());
 						if ((doc->ActPage->PageNr % 2 == 1) && (doc->FirstPageLeft))
							applyNewMaster(dia->Based2->currentText());
 						if ((doc->ActPage->PageNr % 2 == 0) && (!doc->FirstPageLeft))
							applyNewMaster(dia->Based2->currentText());
 						if ((doc->ActPage->PageNr % 2 == 1) && (!doc->FirstPageLeft))
							applyNewMaster(dia->Based->currentText());
						}
					else
						applyNewMaster(dia->Based->currentText());
					wo ++;
					}
				break;
			case 1:
				for (cc = 0; cc < dia->NumPages->value(); cc++)
					{
					slotNewPage(wo);
					if (doc->PageFP)
						{
 						if ((doc->ActPage->PageNr % 2 == 0) && (doc->FirstPageLeft))
							applyNewMaster(dia->Based->currentText());
 						if ((doc->ActPage->PageNr % 2 == 1) && (doc->FirstPageLeft))
							applyNewMaster(dia->Based2->currentText());
 						if ((doc->ActPage->PageNr % 2 == 0) && (!doc->FirstPageLeft))
							applyNewMaster(dia->Based2->currentText());
 						if ((doc->ActPage->PageNr % 2 == 1) && (!doc->FirstPageLeft))
							applyNewMaster(dia->Based->currentText());
						}
					else
						applyNewMaster(dia->Based->currentText());
					wo ++;
					}
				break;
			case 2:
				for (cc = 0; cc < dia->NumPages->value(); cc++)
					{
					slotNewPage(view->Pages.count());
					if (doc->PageFP)
						{
 						if ((doc->ActPage->PageNr % 2 == 0) && (doc->FirstPageLeft))
							applyNewMaster(dia->Based->currentText());
 						if ((doc->ActPage->PageNr % 2 == 1) && (doc->FirstPageLeft))
							applyNewMaster(dia->Based2->currentText());
 						if ((doc->ActPage->PageNr % 2 == 0) && (!doc->FirstPageLeft))
							applyNewMaster(dia->Based2->currentText());
 						if ((doc->ActPage->PageNr % 2 == 1) && (!doc->FirstPageLeft))
							applyNewMaster(dia->Based->currentText());
						}
					else
						applyNewMaster(dia->Based->currentText());
					}
				break;
			}
		}
	delete dia;
}

void ScribusApp::slotNewPage(int w)
{
	view->addPage(w);
	if (view->Pages.count() > 1)
		{
		pageMenu->setItemEnabled(pgmd, 1);
		pageMenu->setItemEnabled(pgmv, 1);
		}
	connect(doc->ActPage, SIGNAL(Amode(int)), this, SLOT(setAppMode(int)));
	connect(doc->ActPage, SIGNAL(PaintingDone()), this, SLOT(slotSelect()));
	connect(doc->ActPage, SIGNAL(HaveSel(int)), this, SLOT(HaveNewSel(int)));
	connect(doc->ActPage, SIGNAL(DocChanged()), this, SLOT(slotDocCh()));
	connect(doc->ActPage, SIGNAL(ItemPos(float, float)), Mpal2, SLOT(setXY(float, float)));
	connect(doc->ActPage, SIGNAL(ItemGeom(float, float)), Mpal2, SLOT(setBH(float, float)));
	connect(doc->ActPage, SIGNAL(SetAngle(float)), Mpal2, SLOT(setR(float)));
	connect(doc->ActPage, SIGNAL(ItemRadius(float)), Mpal2, SLOT(setRR(float)));
	connect(doc->ActPage, SIGNAL(HaveSel(int)), Mpal2, SLOT(NewSel(int)));
	connect(doc->ActPage, SIGNAL(ItemTextAttr(float)), Mpal2, SLOT(setLsp(float)));
	connect(doc->ActPage, SIGNAL(SetSizeValue(int)), Mpal2, SLOT(setSvalue(int)));
	connect(doc->ActPage, SIGNAL(SetLineArt(PenStyle, PenCapStyle, PenJoinStyle)), Mpal2, SLOT( setLIvalue(PenStyle, PenCapStyle, PenJoinStyle)));
	connect(doc->ActPage, SIGNAL(ItemFarben(QString, QString, int, int)), this, SLOT(setCSMenu(QString, QString, int, int)));
	connect(doc->ActPage, SIGNAL(SetLocalValues(float, float, float, float)), Mpal2, SLOT(setLvalue(float, float, float, float)));
	connect(doc->ActPage, SIGNAL(ItemFarben(QString, QString, int, int)), Cpal, SLOT(setActFarben(QString, QString, int, int)));
	connect(doc->ActPage, SIGNAL(ItemTextFont(QString)), this, SLOT(AdjustFontMenu(QString)));
	connect(doc->ActPage, SIGNAL(ItemTextSize(int)), this, SLOT(setFSizeMenu(int)));
	connect(doc->ActPage, SIGNAL(ItemTextSize(int)), Mpal2, SLOT(setSize(int)));
	connect(doc->ActPage, SIGNAL(ItemTextUSval(float)), Mpal2, SLOT(setExtra(float)));
	connect(doc->ActPage, SIGNAL(ItemTextStil(int)), Mpal2, SLOT(setStil(int)));
	connect(doc->ActPage, SIGNAL(ItemTextStil(int)), this, SLOT(setStilvalue(int)));
	connect(doc->ActPage, SIGNAL(ItemTextAbs(int)), this, SLOT(setAbsValue(int)));
	connect(doc->ActPage, SIGNAL(ItemTextAbs(int)), Mpal2, SLOT(setAli(int)));
	connect(doc->ActPage, SIGNAL(HasTextSel()), this, SLOT(EnableTxEdit()));
	connect(doc->ActPage, SIGNAL(HasNoTextSel()), this, SLOT(DisableTxEdit()));
	connect(doc->ActPage, SIGNAL(CopyItem()), this, SLOT(slotEditCopy()));
	connect(doc->ActPage, SIGNAL(CutItem()), this, SLOT(slotEditCut()));
	connect(doc->ActPage, SIGNAL(LoadPic()), this, SLOT(slotFileOpen()));
	connect(doc->ActPage, SIGNAL(ModifyIt()), this, SLOT(ModifyObject()));
	connect(doc->ActPage, SIGNAL(AnnotProps()), this, SLOT(ModifyAnnot()));
	connect(doc->ActPage, SIGNAL(LoadElem(QString, int ,int, bool, bool)), this, SLOT(slotElemRead(QString, int, int, bool, bool)));
	slotDocCh();
}

/** Ansicht absolut zoomen */
void ScribusApp::slotZoomAbs(float z)
{
	doc->Scale = z;
	view->slotDoZoom();
	statusBar()->message(tr("Scaled to: ")+QString::number(doc->Scale*100)+" %", 2000);
}

void ScribusApp::slotZoomFit()
{
	float dx = (view->width()-50) / (doc->PageB+30);
	float dy = (view->height()-70) / (doc->PageH+30);
	if (dx > dy)
		{
		slotZoomAbs(dy);
		}
	else
		{
		slotZoomAbs(dx);
		}
}

/** Ansicht 20 % */
void ScribusApp::slotZoom20()
{
	slotZoomAbs(0.2);
}

/** Ansicht 50 % */
void ScribusApp::slotZoom50()
{
	slotZoomAbs(0.5);
}

/** Ansicht 75 % */
void ScribusApp::slotZoom75()
{
	slotZoomAbs(0.75);
}

/** Ansicht 100 % */
void ScribusApp::slotZoom100()
{
	slotZoomAbs(1.0);
}

/** Ansicht 200 % */
void ScribusApp::slotZoom200()
{
	slotZoomAbs(2.0);
}

void ScribusApp::ToggleMarks()
{
	if (doc->Marks)
	{
		doc->Marks = FALSE;
		viewMenu->changeItem(Markers, tr("Show Margins"));
	}
	else
	{
		doc->Marks = TRUE;
		viewMenu->changeItem(Markers, tr("Hide Margins"));
	}
	view->DrawNew();
}

void ScribusApp::ToggleFrames()
{
	if (doc->ShFrames)
	{
		doc->ShFrames = FALSE;
		viewMenu->changeItem(FrameDr, tr("Show Frames"));
	}
	else
	{
		doc->ShFrames = TRUE;
		viewMenu->changeItem(FrameDr, tr("Hide Frames"));
	}
	view->DrawNew();
}

void ScribusApp::ToggleMpal()
{
	if (Mpal2->isVisible())
	{
  	Prefs.Mpalx = Mpal2->pos().x();
  	Prefs.Mpaly = Mpal2->pos().y();
		Mpal2->close();
		toolMenu->changeItem(viewMpal, tr("Show Measurements"));
	}
	else
	{
		Mpal2->show();
		toolMenu->changeItem(viewMpal, tr("Hide Measurements"));
	}
}

void ScribusApp::ToggleTpal()
{
	if (Tpal->isVisible())
	{
  	Prefs.Tpalx = Tpal->pos().x();
  	Prefs.Tpaly = Tpal->pos().y();
		Tpal->close();
		toolMenu->changeItem(viewTpal, tr("Show Outline"));
	}
	else
	{
		if (HaveDoc)
			{
			Tpal->BuildTree(view);
			}
		Tpal->show();
		toolMenu->changeItem(viewTpal, tr("Hide Outline"));
	}
}

void ScribusApp::ToggleBpal()
{
	if (ScBook->isVisible())
	{
  	Prefs.SCpalx = ScBook->pos().x();
  	Prefs.SCpaly = ScBook->pos().y();
  	Prefs.SCpalw = ScBook->size().width();
  	Prefs.SCpalh = ScBook->size().height();
		ScBook->close();
		toolMenu->changeItem(viewBpal, tr("Show Scrapbook"));
	}
	else
	{
		ScBook->show();
		toolMenu->changeItem(viewBpal, tr("Hide Scrapbook"));
	}
}

void ScribusApp::ToggleSpal()
{
	if (Spal->isVisible())
	{
  	Prefs.Spalx = Spal->pos().x();
  	Prefs.Spaly = Spal->pos().y();
		Spal->close();
		toolMenu->changeItem(viewSpal, tr("Show Styles"));
	}
	else
	{
		if (HaveDoc)
			{
			Spal->SetFormats(doc);
			}
		Spal->show();
		toolMenu->changeItem(viewSpal, tr("Hide Styles"));
	}
}

void ScribusApp::ToggleCpal()
{
	if (Cpal->isVisible())
	{
  	Prefs.Cpalx = Cpal->pos().x();
  	Prefs.Cpaly = Cpal->pos().y();
		Cpal->close();
		toolMenu->changeItem(viewCpal, tr("Show Colors"));
	}
	else
	{
		Cpal->show();
		toolMenu->changeItem(viewCpal, tr("Hide Colors"));
	}
}

void ScribusApp::ToggleTools()
{
	if (WerkTools->isVisible())
	{
		WerkTools->hide();
		toolMenu->changeItem(viewTools, tr("Show Tools"));
	}
	else
	{
		WerkTools->show();
		toolMenu->changeItem(viewTools, tr("Hide Tools"));
	}
}

void ScribusApp::TogglePics()
{
	uint a, b;
	if (doc->ShowPic)
		{
		viewMenu->changeItem(Bilder, tr("Show Images"));
		doc->ShowPic = FALSE;
		}
	else
		{
		viewMenu->changeItem(Bilder, tr("Hide Images"));
		doc->ShowPic = TRUE;
		}
	for (a=0; a<view->Pages.count(); a++)
		{
		for (b=0; b<view->Pages.at(a)->Items.count(); b++)
			{
			if (view->Pages.at(a)->Items.at(b)->PType == 2)
				{
				view->Pages.at(a)->Items.at(b)->PicArt = doc->ShowPic;
				}
			}
		view->Pages.at(a)->update();
		}
}

void ScribusApp::ToggleRaster()
{
	uint a;
	if (doc->Raster)
		{
		viewMenu->changeItem(Ras, tr("Show Guides"));
		doc->Raster = FALSE;
		}
	else
		{
		viewMenu->changeItem(Ras, tr("Hide Guides"));
		doc->Raster = TRUE;
		}
	for (a=0; a<view->Pages.count(); a++)
		{
		view->Pages.at(a)->update();
		}
}

void ScribusApp::ToggleURaster()
{
	doc->useRaster = !doc->useRaster;
	viewMenu->setItemChecked(uRas, doc->useRaster);
}

void ScribusApp::ToggleFrameEdit()
{
	if (doc->EditClip)
		{
		NoFrameEdit();
		}
	else
		{
		Npal->setDoc(doc);
		Npal->ToolButton1_3->setOn(true);
		Npal->show();
		doc->EditClipMode = 0;
		doc->EditClip = TRUE;
		Select->setEnabled(false);
		Rotiere->setEnabled(false);
		Textedit->setEnabled(false);
		Zoom->setEnabled(false);
		Texte->setEnabled(false);
		BildB->setEnabled(false);
		Rechteck->setEnabled(false);
		Kreis->setEnabled(false);
		Linien->setEnabled(false);
		KetteEin->setEnabled(false);
		KetteAus->setEnabled(false);
		ObjMenu->setItemEnabled(Loesch, false);
		if (doc->ActPage->SelItem.count() != 0)
			doc->ActPage->MarkClip(doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0)));
		}
	ShapeMenu->setItemChecked(ShapeEdit, doc->EditClip);
}

void ScribusApp::NoFrameEdit()
{
  Prefs.Npalx = Npal->pos().x();
  Prefs.Npaly = Npal->pos().y();
	Npal->hide();
	doc->EditClip = FALSE;
	Select->setEnabled(true);
	Zoom->setEnabled(true);
	Texte->setEnabled(true);
	BildB->setEnabled(true);
	Rechteck->setEnabled(true);
	Kreis->setEnabled(true);
	Linien->setEnabled(true);
	ObjMenu->setItemEnabled(Loesch, true);
	ShapeMenu->setItemChecked(ShapeEdit, doc->EditClip);
	if (doc->ActPage->SelItem.count() != 0)
		{
		HaveNewSel(doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0))->PType);
		doc->ActPage->RefreshItem(doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0)));
		}
	else
		HaveNewSel(-1);
	statusBar()->message(tr("Ready"), 3000);
}

void ScribusApp::slotSelect()
{
  Select->setOn( TRUE );
	Rotiere->setOn(false);
	Textedit->setOn(false);
	Zoom->setOn(false);
	Texte->setOn(false);
	BildB->setOn(false);
	Rechteck->setOn(false);
	Kreis->setOn(false);
	Linien->setOn(false);
	KetteEin->setOn(false);
	KetteAus->setOn(false);
  setAppMode(1);
}

void ScribusApp::ModeFromTB()
{
	Select->setOn(false);
	Rotiere->setOn(false);
	Textedit->setOn(false);
	Zoom->setOn(false);
	Texte->setOn(false);
	BildB->setOn(false);
	Rechteck->setOn(false);
	Kreis->setOn(false);
	Linien->setOn(false);
	KetteEin->setOn(false);
	KetteAus->setOn(false);
	if (Select == sender())
		{
		Select->setOn(true);
		setAppMode(1);
		}
	if (Rotiere == sender())
		{
		Rotiere->setOn(true);
		setAppMode(9);
		}
	if (Textedit == sender())
		{
		Textedit->setOn(true);
		setAppMode(7);
		}
	if (Zoom == sender())
		{
		Zoom->setOn(true);
		setAppMode(6);
		}
	if (Texte == sender())
		{
		Texte->setOn(true);
		setAppMode(5);
		}
	if (BildB == sender())
		{
		BildB->setOn(true);
		setAppMode(4);
		}
	if (Rechteck == sender())
		{
		Rechteck->setOn(true);
		setAppMode(2);
		}
	if (Kreis == sender())
		{
		Kreis->setOn(true);
		setAppMode(3);
		}
	if (Linien == sender())
		{
		Linien->setOn(true);
		setAppMode(8);
		}
	if (KetteEin == sender())
		{
		KetteEin->setOn(true);
		doc->ElemToLink = doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0));
		setAppMode(10);
		}
	if (KetteAus == sender())
		{
		KetteAus->setOn(true);
		setAppMode(11);
		}
}
void ScribusApp::setAppMode(int mode)
{
	setActiveWindow();
	if (HaveDoc)
		{
		int oldMode = doc->AppMode;
		doc->AppMode = mode;
		if (oldMode == 7)
			{
			disconnect(CurTimer, SIGNAL(timeout()), doc->ActPage, SLOT(BlinkCurs()));
			CurTimer->stop();
			delete CurTimer;
			menuBar()->setItemEnabled(Obm, 1);
			if (BufferSet)
				{
				editMenu->setItemEnabled(edid3, 1);
				}
			else
				{
				editMenu->setItemEnabled(edid3, 0);
				}
			editMenu->setItemEnabled(edid4, 0);
			editMenu->setItemEnabled(edid5, 0);
			doc->ActPage->slotDoCurs(false);
			if (doc->ActPage->SelItem.count() != 0)
				doc->ActPage->RefreshItem(doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0)));
			}
		if (mode == 7)
			{
			doc->ActPage->slotDoCurs(true);
			menuBar()->setItemEnabled(Obm, 0);
			CurTimer = new QTimer(doc->ActPage);
			connect(CurTimer, SIGNAL(timeout()), doc->ActPage, SLOT(BlinkCurs()));
			CurTimer->start(500);
			if (doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0))->HasSel)
				{
				editMenu->setItemEnabled(edid1, 1);
				editMenu->setItemEnabled(edid2, 1);
				editMenu->setItemEnabled(edid4, 1);
				editMenu->setItemEnabled(edid5, 1);
				}
			else
				{
				editMenu->setItemEnabled(edid1, 0);
				editMenu->setItemEnabled(edid2, 0);
				editMenu->setItemEnabled(edid4, 0);
				editMenu->setItemEnabled(edid5, 1);
				}
			if (BufferSet2)
				{
				editMenu->setItemEnabled(edid3, 1);
				}
			else
				{
				editMenu->setItemEnabled(edid3, 0);
				}
			doc->ActPage->RefreshItem(doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0)));
			}
		if (mode == 6)
			{
			qApp->setOverrideCursor(QCursor(loadIcon("LupeZ.xpm")), true);
			}
		else
			{
			qApp->setOverrideCursor(QCursor(ArrowCursor), true);
			}
		}
}

void ScribusApp::Aktiv()
{
	setActiveWindow();
	raise();
}

void ScribusApp::setItemTypeStyle(int id)
{
	int a = TypeStyleMenu->indexOf(id);
	int b = 0;
	switch (a)
		{
		case 0:
			b = 0;
			break;
		case 1:
			b = 32;
			break;
		case 2:
			b = 4;
			break;
		case 3:
			b = 8;
			break;
		case 4:
			b = 16;
			break;
		case 5:
			b = 64;
			break;
		case 6:
			b = 1;
			break;
		case 7:
			b = 2;
			break;
		}
	setItemHoch(b);
}

void ScribusApp::setStilvalue(int s)
{
	uint a;
	CurrentStyle = s;
	for (a = 0; a < TypeStyleMenu->count(); a++)
		{
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(a), false);
		}
	if (s == 0)
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(0), true);
	if (s & 32)
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(1), true);
	if (s & 4)
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(2), true);
	if (s & 8)
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(3), true);
	if (s & 16)
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(4), true);
	if (s & 64)
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(5), true);
	if (s & 1)
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(6), true);
	if (s & 2)
		TypeStyleMenu->setItemChecked(TypeStyleMenu->idAt(7), true);
	emit TextStil(s);
}

void ScribusApp::setItemHoch(int h)
{
	if (doc->ActPage->SelItem.count() != 0)
		{
		setActiveWindow();
		if (h == 0)
			CurrentStyle = 0;
		else
			{
			CurrentStyle = CurrentStyle ^ h;
			if ((h == 1) && (CurrentStyle & 2))
				CurrentStyle = CurrentStyle & ~2;
			if ((h == 2) && (CurrentStyle & 1))
				CurrentStyle = CurrentStyle & ~1;
			}
		setStilvalue(CurrentStyle);
		doc->ActPage->chTyStyle(h);
		slotDocCh();
		}
}

void ScribusApp::DeletePage()
{
	int a, pg;
	NoFrameEdit();
	DelPages *dia = new DelPages(this, doc->ActPage->PageNr+1, view->Pages.count());
	if (dia->exec())
		{
		pg = dia->FromPage->value()-1;
		for (a = pg; a < dia->ToPage->value(); a++)
			{
			view->delPage(pg);
			}
		if (view->Pages.count() == 1)
			{
			pageMenu->setItemEnabled(pgmd, 0);
			pageMenu->setItemEnabled(pgmv, 0);
			}
		slotDocCh();
		}
	delete dia;
}

void ScribusApp::MovePage()
{
	NoFrameEdit();
	MovePages *dia = new MovePages(this, doc->ActPage->PageNr+1, view->Pages.count(), true);
	if (dia->exec())
		{
		int from = dia->FromPage->value();
		int to = dia->ToPage->value();
		int wie = dia->Where->currentItem();
		int wo = dia->ActualPage->value();
		view->movePage(from-1, to, wo-1, wie);
		slotDocCh();
		}
	delete dia;
}

void ScribusApp::CopyPage()
{
	NoFrameEdit();
	MovePages *dia = new MovePages(this, doc->ActPage->PageNr+1, view->Pages.count(), false);
	if (dia->exec())
		{
		Page* from = view->Pages.at(dia->FromPage->value()-1);
		int wo = dia->ActualPage->value();
		switch (dia->Where->currentItem())
			{
			case 0:
				slotNewPage(wo-1);
				break;
			case 1:
				slotNewPage(wo);
				break;
			case 2:
				slotNewPage(view->Pages.count());
				break;
			}
		Page* Ziel = doc->ActPage;
		for (uint ite = 0; ite < from->Items.count(); ite++)
			{
			from->Items.at(ite)->CopyIt(&Buffer);
			Ziel->PasteItem(&Buffer, true);
			}
		Ziel->MPageNam = from->MPageNam;
		Ziel->Deselect();
		view->DrawNew();
		slotDocCh();
		}
	delete dia;
}

void ScribusApp::setItemFont(int id)
{
	QString nf;
	nf = *FontID[long(id)];
	SetNewFont(nf);
}

void ScribusApp::SetNewFont(QString nf)
{
	Aktiv();
	int a;
	if (!doc->UsedFonts.contains(nf))
		{
		doc->AddFont(nf, Prefs.AvailFonts[nf]->Font);
/*
		SCFontsIterator it(Prefs.AvailFonts);
		for ( ; it.current(); ++it)
		{
			if (it.currentKey() == nf) break;
		}
		a = FontMenu->insertItem(new FmItem(it.currentKey(), it.current()->Font));
		FontID.insert(long(a), &it.current()->SCName);
*/
		a = FontMenu->insertItem(new FmItem(nf, Prefs.AvailFonts[nf]->Font));
		FontID.insert(long(a), &Prefs.AvailFonts[nf]->SCName);
		}
	AdjustFontMenu(nf);
	doc->ActPage->ItemFont(nf);
	slotDocCh();
}

void ScribusApp::AdjustFontMenu(QString nf)
{
	uint a;
	QString df;
	Mpal2->Text9->setText(nf);
	for (a = 2; a < FontMenu->count(); a++)
		{
		df = *FontID[long(FontMenu->idAt(a))];
		if (df == nf)
			{
			FontMenu->setItemChecked(FontMenu->idAt(a), true);
			}
		else
			{
			FontMenu->setItemChecked(FontMenu->idAt(a), false);
			}
		}
}

void ScribusApp::setItemFSize(int id)
{
	int c = SizeTMenu->indexOf(id);
	bool ok = false;
	if (c > 0)
		doc->ActPage->chFSize(SizeTMenu->text(id).left(2).toInt());
	else
		{
    Query* dia = new Query(this, "New", 1, 0, "Size:", "Size");
    if (dia->exec())
    	{
			c = dia->Answer->text().toInt(&ok);
			if ((ok) && (c < 513))
				doc->ActPage->chFSize(c);
			delete dia;
     	}
		}
	slotDocCh();
}

void ScribusApp::setFSizeMenu(int size)
{
	uint a;
	for (a = 0; a < SizeTMenu->count(); a++)
		{
		SizeTMenu->setItemChecked(SizeTMenu->idAt(a), false);
		if (SizeTMenu->text(SizeTMenu->idAt(a)).left(2).toInt() == size)
			{
			SizeTMenu->setItemChecked(SizeTMenu->idAt(a), true);
			}
		}
}

void ScribusApp::setItemFarbe(int id)
{
	uint a;
	for (a = 0; a < ColorMenu->count(); a++)
		{
		ColorMenu->setItemChecked(ColorMenu->idAt(a), false);
		}
	ColorMenu->setItemChecked(id, true);
	doc->ActPage->ItemBrush(ColorMenu->text(id));
	slotDocCh();
}

void ScribusApp::setItemShade(int id)
{
	int c = ShadeMenu->indexOf(id);
	uint a;
	bool ok = false;
	for (a = 0; a < ShadeMenu->count(); a++)
		{
		ShadeMenu->setItemChecked(ShadeMenu->idAt(a), false);
		}
	ShadeMenu->setItemChecked(id, true);
	if (c > 0)
		{		
		doc->ActPage->ItemBrushShade((c-1) * 10);
		}
	else
		{
    Query* dia = new Query(this, "New", 1, 0, "Shade:", "Shade");
    if (dia->exec())
    	{
			c = dia->Answer->text().toInt(&ok);
			if (ok)
				{		
				doc->ActPage->ItemBrushShade(c);
				}
			delete dia;
     	}
		}
	slotDocCh();
}

void ScribusApp::setCSMenu(QString k, QString l, int lk , int ls)
{
	uint a;
	QString la;
	int lb;
	if (doc->ActPage->SelItem.count() != 0)
		{
		if (doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0))->PType == 4)
			{
			la = k;
			lb = lk;
			}
		else
			{
			la = l;
			lb = ls;
			}	
		}
	else
		{
		la = l;
		lb = ls;
		}	
	if (la == "None")
		la = tr("None");
	for (a = 0; a < ColorMenu->count(); a++)
		{
		ColorMenu->setItemChecked(ColorMenu->idAt(a), false);
		if (ColorMenu->text(ColorMenu->idAt(a)) == la)
			ColorMenu->setItemChecked(ColorMenu->idAt(a), true);
		}
	for (a = 0; a < ShadeMenu->count(); a++)
		{
		ShadeMenu->setItemChecked(ShadeMenu->idAt(a), false);
		}
	ShadeMenu->setItemChecked(ShadeMenu->idAt(lb/10+1), true);
}

void ScribusApp::slotEditStyles()
{
	QValueList<uint> ers;
	QString nn;
	bool ff;
	uint nr;
	ers.clear();
	if (HaveDoc)
		{
		StilFormate *dia = new StilFormate(this, doc);
		if (dia->exec())
			{
			for (uint a=0; a<doc->Vorlagen.count(); a++)
				{
				ff = false;
				nn = doc->Vorlagen[a].Vname;
				for (uint b=0; b<dia->TempVorl.count(); b++)
					{
					if (nn == dia->TempVorl[b].Vname)
						{
						nr = b;
						ff = true;
						break;
						}
					}
				if (ff)
					ers.append(nr);
				else
					ers.append(0);
				}
			doc->Vorlagen = dia->TempVorl;
			for (uint c=0; c<view->Pages.count(); c++)
				{
				for (uint d=0; d<view->Pages.at(c)->Items.count(); d++)
					{
					if (view->Pages.at(c)->Items.at(d)->PType == 4)
						{
						for (uint e=0; e<view->Pages.at(c)->Items.at(d)->Ptext.count(); e++)
							{
							if (view->Pages.at(c)->Items.at(d)->Ptext.at(e)->cab > 4)
								view->Pages.at(c)->Items.at(d)->Ptext.at(e)->cab = ers[view->Pages.at(c)->Items.at(d)->Ptext.at(e)->cab];
							}
						}
					}
				}
			Spal->updateFList();
			view->DrawNew();
			slotDocCh();
			}
		delete dia;
		}
}

void ScribusApp::setItemTextAli(int id)
{
	int a = AliMenu->indexOf(id);
	setNewAbStyle(a);
}

void ScribusApp::setNewAbStyle(int a)
{
	setActiveWindow();
	if (HaveDoc)
		{
		doc->ActPage->SetAbStyle(a);
		CurrentABStil = a;
		slotDocCh();
		}
}

void ScribusApp::setAbsValue(int a)
{
	CurrentABStil = a;
	Mpal2->setAli(a);
	for (int b = 0; b < 5; b++)
		{
		AliMenu->setItemChecked(AliMenu->idAt(b), false);
		}
	if (a < 5)
		{
		Spal->ListBox1->setCurrentItem(0);
		AliMenu->setItemChecked(AliMenu->idAt(a), true);
		}
	else
		Spal->ListBox1->setCurrentItem(a-4);
}

void ScribusApp::slotEditColors()
{
	int a;
	uint b, c, d;
	CListe edc;
	QMap<QString,QString> ers;
	if (HaveDoc)
		{
		edc = doc->PageColors;
		}
	else
		{
		edc = Prefs.DColors;
		}
	Farbmanager* dia = new Farbmanager(this, edc);
	if (dia->exec())
		{
		if (HaveDoc)
			{
			slotDocCh();
			doc->PageColors = dia->EditColors;
			Cpal->SetColors(doc->PageColors);
			CListe::Iterator it;
			ColorMenu->clear();
			QPixmap pm = QPixmap(15, 15);
			a = 0;
			ColorMenu->insertItem(tr("None"));
			for (it = doc->PageColors.begin(); it != doc->PageColors.end(); ++it)
				{
				pm.fill(doc->PageColors[it.key()].getRGBColor());
				ColorMenu->insertItem(QIconSet(pm), it.key());
				if (it.key() == doc->Dbrush)
					{
					ColorMenu->setItemChecked(ColorMenu->idAt(a), true);
					}
				a++;
				}
			ers = dia->Ersatzliste;
			if (!ers.isEmpty())
				{
				for (it = doc->PageColors.begin(); it != doc->PageColors.end(); ++it)
					{
					ers.remove(it.key());
					}
				if (!ers.isEmpty())
					{
					QMap<QString,QString>::Iterator it;
					for (it = ers.begin(); it != ers.end(); ++it)
						{
						for (b=0; b<view->Pages.count(); b++)
							{
							for (c=0; c<view->Pages.at(b)->Items.count(); c++)
								{
								if (view->Pages.at(b)->Items.at(c)->PType == 4)
									{
									for (d=0; d<view->Pages.at(b)->Items.at(c)->Ptext.count(); d++)
										{
										if (it.key() == view->Pages.at(b)->Items.at(c)->Ptext.at(d)->ccolor)
											{
											view->Pages.at(b)->Items.at(c)->Ptext.at(d)->ccolor = it.data();
											}
										}
									}
								if (it.key() == view->Pages.at(b)->Items.at(c)->Pcolor)
									{
									view->Pages.at(b)->Items.at(c)->Pcolor = it.data();
									}
								if (it.key() == view->Pages.at(b)->Items.at(c)->Pcolor2)
									{
									view->Pages.at(b)->Items.at(c)->Pcolor2 = it.data();
									}
								}
							}
						}
					}
				}
			view->DrawNew();
			}
		else
			{
			Prefs.DColors = dia->EditColors;
			Cpal->SetColors(Prefs.DColors);
			}
		}
	delete dia;
}

void ScribusApp::setPenFarbe(QString farbe)
{
	setActiveWindow();
	if (HaveDoc)
		{
		doc->ActPage->ItemPen(farbe);
		slotDocCh();
		}
}

void ScribusApp::setPenShade(int sh)
{
	setActiveWindow();
	if (HaveDoc)
		{
		doc->ActPage->ItemPenShade(sh);
		slotDocCh();
		}
}

void ScribusApp::setBrushFarbe(QString farbe)
{
	setActiveWindow();
	if (HaveDoc)
		{
		doc->ActPage->ItemBrush(farbe);
		slotDocCh();
		}
}

void ScribusApp::setBrushShade(int sh)
{
	setActiveWindow();
	if (HaveDoc)
		{
		doc->ActPage->ItemBrushShade(sh);
		slotDocCh();
		}
}

void ScribusApp::GetBrushPen()
{
	setActiveWindow();
	if (HaveDoc)
		{
		doc->ActPage->QueryFarben();
		slotDocCh();
		}
}

void ScribusApp::RectFrame()
{
	doc->ActPage->SetFrameRect();
	slotDocCh();
}

void ScribusApp::RoundedFrame()
{
	doc->ActPage->SetFrameRounded();
	slotDocCh();
}

void ScribusApp::OvalFrame()
{
	doc->ActPage->SetFrameOval();
	slotDocCh();
}

void ScribusApp::DeleteObjekt()
{
	if (!doc->EditClip)
		doc->ActPage->DeleteItem();
}

void ScribusApp::Objekt2Back()
{
	doc->ActPage->ToBack();
}

void ScribusApp::Objekt2Front()
{
	doc->ActPage->ToFront();
}

void ScribusApp::ObjektRaise()
{
	doc->ActPage->RaiseItem();
}

void ScribusApp::ObjektLower()
{
	doc->ActPage->LowerItem();
}

void ScribusApp::ObjektDup()
{
	slotEditCopy();
	slotEditPaste();
	for (uint b=0; b<doc->ActPage->SelItem.count(); b++)
		{
		doc->ActPage->MoveItem(DispX, DispY, *doc->ActPage->SelItem.at(b));
		}
}

void ScribusApp::ObjektDupM()
{
	NoFrameEdit();
	Mdup *dia = new Mdup(this, qRound(DispX * Umrech), qRound(DispY * Umrech), doc->Einheit);
	if (dia->exec())
		{
		int anz = dia->Ncopies->value();
		float dH = float(dia->ShiftH->value()) / Umrech;
		float dV = float(dia->ShiftV->value()) / Umrech;
		int a;
		if (anz>0)
			{
			for (a=0; a<anz; a++)
				{
				slotEditCopy();
				slotEditPaste();
				for (uint b=0; b<doc->ActPage->SelItem.count(); b++)
					{
					doc->ActPage->MoveItem(dH, dV, *doc->ActPage->SelItem.at(b));
					}
				DispX = dH;
				DispY = dV;
				}
			slotDocCh();
			}
		}
	delete dia;
}

void ScribusApp::SelectFromOutl(int Page, int Item)
{
	NoFrameEdit();
	setActiveWindow();
	doc->ActPage->Deselect();
	view->GotoPage(Page);
	doc->ActPage->SelectItemNr(Item);
}

void ScribusApp::SelectFromOutlS(int Page)
{
	NoFrameEdit();
	setActiveWindow();
	doc->ActPage->Deselect();
	view->GotoPage(Page);
}

void ScribusApp::InfoDoc()
{
	DocInfos *dia = new DocInfos(this, doc->DocAutor, doc->DocTitel, doc->DocComments);
	if (dia->exec())
		{
		doc->DocAutor = dia->AutorInfo->text();
		doc->DocTitel = dia->TitelInfo->text();
		doc->DocComments = dia->MultiLineEdit1->text();
		slotDocCh();
		}
	delete dia;
}

void ScribusApp::ObjektAlign()
{
	float xdp, ydp;
	bool xa, ya, Vth, Vtv;
	int xart, yart, ein;
	if (HaveDoc)
		ein = doc->Einheit;
	else
		ein = Prefs.Einheit;
	NoFrameEdit();
	Align *dia = new Align(this, doc->ActPage->SelItem.count(), ein, Umrech);
	connect(dia, SIGNAL(ApplyDist(bool, bool, bool, bool, float, float, int, int)),
	        this, SLOT(DoAlign(bool, bool, bool, bool, float, float, int, int)));
	if (dia->exec())
		{
		xdp = float(dia->AHor->value()) / Umrech;
		xa = (dia->CheckH->isChecked() || dia->VerteilenH->isChecked());
		ydp = float(dia->AVert->value()) / Umrech;
		ya = (dia->CheckV->isChecked() || dia->VerteilenV->isChecked());
		xart = dia->VartH->currentItem();
		yart = dia->VartV->currentItem();
		Vth = dia->VerteilenH->isChecked();
		Vtv = dia->VerteilenV->isChecked();
		doc->ActPage->AlignObj(xa, ya, Vth, Vtv, xdp, ydp, xart, yart);
		slotDocCh();
		}
	delete dia;
}

void ScribusApp::DoAlign(bool xa, bool ya, bool Vth, bool Vtv, float xdp, float ydp, int xart, int yart)
{
	doc->ActPage->AlignObj(xa, ya, Vth, Vtv, xdp, ydp, xart, yart);
	slotDocCh();
}

void ScribusApp::BuildFontMenu()
{
	QPopupMenu *pm;
	FontID.clear();
	FontMenu->clear();
	FStyleMenu->clear();
	int a;
	QString b = " ";

	QMap<QString,QStrList> Fami;
	SCFontsIterator it(Prefs.AvailFonts);
	for ( ; it.current(); ++it)
	{
		QString family,style;
		QString &fn=it.current()->SCName;
		int	pos=fn.find(" ");
		family=fn.left(pos);
		style=fn.right(fn.length()-pos);
		Fami[family].inSort(fn);
	}

	QMapIterator<QString,QStrList> qmi;
	for (qmi = Fami.begin(); qmi != Fami.end(); ++qmi)
	{
		pm = new QPopupMenu();
		QString family=qmi.key();
		QStrList &qsl=qmi.data();
		for( QStrListIterator sli(qsl) ; sli.current() ; ++sli)
		{
			QString &fn=Prefs.AvailFonts[sli.current()]->SCName;
			a = pm->insertItem(new FmItem(fn, Prefs.AvailFonts[fn]->Font));
			FontID.insert(long(a), &fn);
		}
		connect(pm, SIGNAL(activated(int)), this, SLOT(setItemFont(int)));
		FStyleMenu->insertItem(family, pm);
	}

	a = FontMenu->insertItem(tr("Face"), FStyleMenu);
	FontID.insert(long(a), &b);
	a = FontMenu->insertSeparator();
	FontID.insert(long(a), &b);
	if (!HaveDoc)
		{
		it.toFirst();
		a = FontMenu->insertItem(new FmItem(it.currentKey(), it.current()->Font));
		FontMenu->setItemChecked(a, true);
		FontID.insert(long(a), &it.current()->SCName);
		}
	else
		{
		QMap<QString,QFont>::Iterator it3;
		for (it3 = doc->UsedFonts.begin(); it3 != doc->UsedFonts.end(); ++it3)
			{
			a = FontMenu->insertItem(new FmItem(it3.key(), it3.data()));
			if (it3.key() == doc->Dfont)
				{
				FontMenu->setItemChecked(a, true);
				}
			FontID.insert(long(a), &it3.key());
			}
		}
}

void ScribusApp::GetAllFonts()
{
	Prefs.AvailFonts.GetFonts();
	if (Prefs.AvailFonts.isEmpty())
		NoFonts = true;
}

void ScribusApp::slotFontOrg()
{
	uint a;
	FontPrefs *dia = new FontPrefs(this, Prefs.AvailFonts);
	if (dia->exec())
		{
		a = 0;
		SCFontsIterator it(Prefs.AvailFonts);
		for ( ; it.current() ; ++it)
			{
			it.current()->EmbedPS = dia->FlagsPS.at(a)->isChecked();
			a++;
			}
		}
	delete dia;
}

void ScribusApp::slotPrefsOrg()
{
	void *mo;
	char *error;
	typedef Preferences* (*sdem)(QWidget *d, preV *Vor);
	sdem demo;
	QString pfad = PREL;
	pfad += "/share/scribus/libs/libpreferences.so";
	mo = dlopen(pfad, RTLD_LAZY);
	if (!mo)
		{
		cout << "Can't find Plugin" << endl;
		return;
		}
	dlerror();
	demo = (sdem)dlsym(mo, "Run");
	if ((error = dlerror()) != NULL)
		{
		cout << "Can't find Symbol" << endl;
		dlclose(mo);
		return;
		}
	Preferences *dia = (*demo)(this, &Prefs);
	if (dia->exec())
		{
		Prefs.Einheit = dia->UnitCombo->currentItem();
		if (Prefs.Einheit == 0)
			Umrech = 1.0;
		else
			Umrech = 0.3527777;
		Prefs.KeyActions = dia->KKC;
		SetShortCut();
		Prefs.AppFontSize = dia->GFsize->value();
		Prefs.DefFont = dia->FontCombo->currentText();
		Prefs.DefSize = dia->SizeCombo->currentText().left(2).toInt();
		Prefs.Wheelval = dia->SpinBox3->value();
		Prefs.GrabRad = dia->SpinBox3_2->value();
		Prefs.RecentDCount = dia->Recen->value();
		Prefs.DminGrid = dia->SpinBox1->value() / dia->Umrech;
		Prefs.DmajGrid = dia->SpinBox2->value() / dia->Umrech;
		Prefs.DminColor = dia->minColor->backgroundColor();
		Prefs.DmajColor = dia->MaxColor->backgroundColor();
		Prefs.DpapColor = dia->PapColor->backgroundColor();
		Prefs.DmargColor = dia->RandColor->backgroundColor();
		Prefs.DVHoch = dia->VHochW->value();
		Prefs.DVHochSc = dia->VHochWSc->value();
		Prefs.DVTief = dia->VTiefW->value();
		Prefs.DVTiefSc = dia->VTiefWSc->value();
		Prefs.DVKapit = dia->SmallCaps->value();
  	Prefs.Dpen = dia->Foreground->currentText();
		if (Prefs.Dpen == tr("None"))
			Prefs.Dpen = "None";
  	Prefs.DpenText = dia->ForegroundT->currentText();
		if (Prefs.DpenText == tr("None"))
			Prefs.DpenText = "None";
  	Prefs.Dbrush = dia->Background->currentText();
		if (Prefs.Dbrush == tr("None"))
			Prefs.Dbrush = "None";
  	Prefs.Dshade = dia->Shade->value();
  	Prefs.Dshade2 = dia->Shade2->value();
		switch (dia->Linestyle->currentItem())
			{
			case 0:
				Prefs.DLineArt = SolidLine;
				break;
			case 1:
				Prefs.DLineArt = DashLine;
				break;
			case 2:
				Prefs.DLineArt = DotLine;
				break;
			case 3:
				Prefs.DLineArt = DashDotLine;
				break;
			case 4:
				Prefs.DLineArt = DashDotDotLine;
				break;
			}
  	Prefs.DpenLine = dia->Foreground2->currentText();
		if (Prefs.DpenLine == tr("None"))
			Prefs.DpenLine = "None";
  	Prefs.DshadeLine = dia->Shade22->value();
		switch (dia->Linestyle2->currentItem())
			{
			case 0:
				Prefs.DLstyleLine = SolidLine;
				break;
			case 1:
				Prefs.DLstyleLine = DashLine;
				break;
			case 2:
				Prefs.DLstyleLine = DotLine;
				break;
			case 3:
				Prefs.DLstyleLine = DashDotLine;
				break;
			case 4:
				Prefs.DLstyleLine = DashDotDotLine;
				break;
			}
  	Prefs.Dwidth = dia->LineW->value();
  	Prefs.DwidthLine = dia->LineW2->value();
  	Prefs.MagMin = dia->MinMag->value();
  	Prefs.MagMax = dia->MaxMag->value();
  	Prefs.MagStep = dia->StepMag->value();
  	Prefs.DbrushPict = dia->BackgroundP->currentText();
		if (Prefs.DbrushPict == tr("None"))
			Prefs.DbrushPict = "None";
		Prefs.ShadePict = dia->ShadeP->value();
		Prefs.ScaleX = float(dia->XScale->value()) / 100;
		Prefs.ScaleY = float(dia->YScale->value()) / 100;
		Prefs.Before = dia->RadioButton6->isChecked();
		switch (dia->PreviewSize->currentItem())
			{
			case 0:
				Prefs.PSize = 40;
				break;
			case 1:
				Prefs.PSize = 60;
				break;
			case 2:
				Prefs.PSize = 80;
				break;
			}
		Prefs.SaveAtQ = dia->SaveAtQuit->isChecked();
		Prefs.PagesSbS = dia->SidebySide->isChecked();
		Prefs.ShFrames = dia->FramesVisible->isChecked();
		Prefs.RandFarbig = dia->RandFarb->isChecked();
		Prefs.AutoLine = dia->AutoLineV->value();
		ScBook->BibWin->RebuildView();
		ScBook->AdjustMenu();
		Prefs.GUI = dia->GUICombo->currentItem();
		qApp->setFont(QFont("helvetica", Prefs.AppFontSize),true);
		switch (Prefs.GUI)
			{
			case 1:
     		qApp->setStyle(new QPlatinumStyle);
     		break;
     	case 2:
     		qApp->setStyle(new QWindowsStyle);
     		break;
     	case 3:
     		qApp->setStyle(new QMotifStyle);
     		break;
     	case 4:
     		qApp->setStyle(new QCDEStyle);
     		break;
     	case 5:
     		qApp->setStyle(new QMotifPlusStyle);
     		break;
			}
		if (HaveDoc)
			{
			doc->GrabRad = Prefs.GrabRad;
			doc->Dfont = Prefs.DefFont;
			doc->Dsize = Prefs.DefSize;
			doc->minorGrid = Prefs.DminGrid;
			doc->majorGrid = Prefs.DmajGrid;
			doc->minorColor = Prefs.DminColor;
			doc->majorColor = Prefs.DmajColor;
			doc->papColor = Prefs.DpapColor;
			doc->margColor = Prefs.DmargColor;
			doc->VHoch = Prefs.DVHoch;
			doc->VHochSc = Prefs.DVHochSc;
			doc->VTief = Prefs.DVTief;
			doc->VTiefSc = Prefs.DVTiefSc;
			doc->VKapit = Prefs.DVKapit;
  		doc->Dpen = Prefs.Dpen;
  		doc->DpenText = Prefs.DpenText;
  		doc->Dbrush = Prefs.Dbrush;
  		doc->Dshade = Prefs.Dshade;
  		doc->Dshade2 = Prefs.Dshade2;
  		doc->DLineArt = PenStyle(Prefs.DLineArt);
  		doc->Dwidth = Prefs.Dwidth;
  		doc->DpenLine = Prefs.DpenLine;
  		doc->DshadeLine = Prefs.DshadeLine;
  		doc->DLstyleLine = PenStyle(Prefs.DLstyleLine);
  		doc->DwidthLine = Prefs.DwidthLine;
  		doc->MagMin = Prefs.MagMin;
  		doc->MagMax = Prefs.MagMax;
  		doc->MagStep = Prefs.MagStep;
  		doc->DbrushPict = Prefs.DbrushPict;
			doc->ShadePict = Prefs.ShadePict;
			doc->ScaleX = Prefs.ScaleX;
			doc->ScaleY = Prefs.ScaleY;
			doc->Before = Prefs.Before;
			doc->Einheit = Prefs.Einheit;
			doc->PagesSbS = Prefs.PagesSbS;
			doc->ShFrames = Prefs.ShFrames;
			doc->RandFarbig = Prefs.RandFarbig;
			doc->AutoLine = Prefs.AutoLine;
			if (doc->Einheit == 0)
				view->UN->setText("pt");
			else
				view->UN->setText("mm");
			Mpal2->UnitChange();
			view->reformPages();
			view->DrawNew();
			}
		SavePrefs();
		}
	delete dia;
	dlclose(mo);
}

void ScribusApp::SavePrefs()
{
  Prefs.MainX = pos().x();
  Prefs.MainY = pos().y();
  Prefs.MainW = size().width();
  Prefs.MainH = size().height();
  Prefs.Werkv = WerkTools->isVisible();
  Prefs.Mpalv = Mpal2->isVisible();
  Prefs.Cpalv = Cpal->isVisible();
  Prefs.Tpalv = Tpal->isVisible();
	Prefs.Spalv = Spal->isVisible();
  Prefs.SCpalv = ScBook->isVisible();
  if (Mpal2->isVisible())
  	{
	  Prefs.Mpalx = Mpal2->pos().x();
	  Prefs.Mpaly = Mpal2->pos().y();
	  }
	if (Cpal->isVisible())
		{
	  Prefs.Cpalx = Cpal->pos().x();
	  Prefs.Cpaly = Cpal->pos().y();
	  }
	if (Tpal->isVisible())
		{
		Prefs.Tpalx = Tpal->pos().x();
		Prefs.Tpaly = Tpal->pos().y();
		}
	if (Spal->isVisible())
		{
		Prefs.Spalx = Spal->pos().x();
		Prefs.Spaly = Spal->pos().y();
		}
	if (ScBook->isVisible())
		{
		Prefs.SCpalx = ScBook->pos().x();
		Prefs.SCpaly = ScBook->pos().y();
		Prefs.SCpalw = ScBook->size().width();
		Prefs.SCpalh = ScBook->size().height();
		}
  Prefs.RecentDocs.clear();
	uint max = QMIN(Prefs.RecentDCount, RecentDocs.count());
	for (uint m = 0; m < max; m++)
		{
		Prefs.RecentDocs.append(RecentDocs[m]);
		}
  ScriXmlDoc *ss = new ScriXmlDoc();
  ss->WritePref(&Prefs);
  delete ss;
}

void ScribusApp::ReadPrefs()
{
  ScriXmlDoc *ss = new ScriXmlDoc();
  bool erg = ss->ReadPref(&Prefs);
  delete ss;
  if (!erg)
  	return;
  recentMenu->clear();
	uint max = QMIN(Prefs.RecentDCount, Prefs.RecentDocs.count());
	for (uint m = 0; m < max; m++)
		{
		QFileInfo fd(Prefs.RecentDocs[m]);
		if (fd.exists())
			{
			RecentDocs.append(Prefs.RecentDocs[m]);
			recentMenu->insertItem(Prefs.RecentDocs[m]);
			}
		}
  if (!Prefs.Werkv)
		toolMenu->changeItem(viewTools, tr("Show Tools"));
	if (Prefs.Mpalv)
		toolMenu->changeItem(viewMpal, tr("Hide Measurements"));
	if (Prefs.Cpalv)
		toolMenu->changeItem(viewCpal, tr("Hide Colors"));
	if (Prefs.Tpalv)
		toolMenu->changeItem(viewTpal, tr("Hide Outline"));
	if (Prefs.Spalv)
		toolMenu->changeItem(viewSpal, tr("Hide Styles"));
	if (Prefs.SCpalv)
		toolMenu->changeItem(viewBpal, tr("Hide Scrapbook"));
	Mpal2->move(Prefs.Mpalx, Prefs.Mpaly);
	Cpal->move(Prefs.Cpalx, Prefs.Cpaly);
	Tpal->move(Prefs.Tpalx, Prefs.Tpaly);
	Spal->move(Prefs.Spalx, Prefs.Spaly);
	ScBook->move(Prefs.SCpalx, Prefs.SCpaly);
	ScBook->resize(Prefs.SCpalw, Prefs.SCpalh);
	Npal->move(Prefs.Npalx, Prefs.Npaly);
	move(Prefs.MainX, Prefs.MainY);
	resize(Prefs.MainW, Prefs.MainH);
}

void ScribusApp::ShowSubs()
{
	QString mess;
	if (HaveGS != 0)
		{
		mess = tr("The following Programs are missing:")+"\n\n";
		if (HaveGS != 0)
			{
			mess += tr("Ghostscript : You cannot use EPS-Images")+"\n\n";
			PDFavailable = false;
			}
    QMessageBox::warning(this, tr("Warning"), mess, 1, 0, 0);
    }
	if (!Prefs.Werkv)
		WerkTools->hide();
	if (Prefs.Mpalv)
		Mpal2->show();
	if (Prefs.Cpalv)
		Cpal->show();
	if (Prefs.Tpalv)
		Tpal->show();
	if (Prefs.Spalv)
		Spal->show();
	if (Prefs.SCpalv)
		ScBook->show();
	setActiveWindow();
	raise();
}

PSLib* ScribusApp::getPSDriver(bool psart, SCFonts &AllFonts, QMap<QString,QFont> DocFonts, CListe DocColors, bool pdf)
{
	char *error;
	typedef PSLib* (*sdem)(bool psart, SCFonts &AllFonts, QMap<QString,QFont> DocFonts, CListe DocColors, bool pdf);
	sdem demo;
	QString pfad = PREL;
	pfad += "/share/scribus/libs/libpostscript.so";
	PSDriver = dlopen(pfad, RTLD_LAZY);
	if (!PSDriver)
		{
		cout << "Can't find Plugin" << endl;
		return NULL;
		}
	dlerror();
	demo = (sdem)dlsym(PSDriver, "Run");
	if ((error = dlerror()) != NULL)
		{
		cout << "Can't find Symbol" << endl;
		dlclose(PSDriver);
		return NULL;
		}
	PSLib *dia = (*demo)(psart, AllFonts, DocFonts, DocColors, pdf);
	return dia;
}

void ScribusApp::closePSDriver()
{
	dlclose(PSDriver);
}

PDFlib* ScribusApp::getPDFDriver()
{
	char *error;
	typedef PDFlib* (*sdem)();
	sdem demo;
	QString pfad = PREL;
	pfad += "/share/scribus/libs/libpdf.so";
	PDFDriver = dlopen(pfad, RTLD_LAZY);
	if (!PDFDriver)
		{
		cout << "Can't find Plugin" << endl;
		return NULL;
		}
	dlerror();
	demo = (sdem)dlsym(PDFDriver, "Run");
	if ((error = dlerror()) != NULL)
		{
		cout << "Can't find Symbol" << endl;
		dlclose(PDFDriver);
		return NULL;
		}
	PDFlib *dia = (*demo)();
	return dia;
}

void ScribusApp::closePDFDriver()
{
	dlclose(PDFDriver);
}

void ScribusApp::SaveAsEps()
{
	QString fna;
  if (!doc->DocName.startsWith("Document"))
  	{
  	QFileInfo fi(doc->DocName);
  	fna = fi.dirPath()+"/"+fi.baseName()+".eps";
  	}
  else
  	{
  	QDir di = QDir();
  	fna = di.currentDirPath()+"/"+doc->DocName+".eps";
  	}
  QString fn = CFileDialog(tr("Save as"), tr("EPS-Files (*.eps);; All Files (*)"));
  if (!fn.isEmpty())
  	{
  	qApp->setOverrideCursor(QCursor(waitCursor), true);
		PSLib *dd = getPSDriver(false, Prefs.AvailFonts, doc->UsedFonts, doc->PageColors, false);
		if (dd != NULL)
			{
			QString data = view->CreatePS(dd, doc->ActPage->PageNr, doc->ActPage->PageNr+1, 1, false, tr("All"), true);
			QFile f(fn);	
			if (f.open(IO_WriteOnly))
				{
				QTextStream t(&f);
				t.writeRawBytes(data, data.length());
				f.close();	
				}
			delete dd;
			closePSDriver();
 			qApp->setOverrideCursor(QCursor(arrowCursor), true);
 			}
  	}
}

void ScribusApp::SaveAsPDF()
{
	struct PDFOpt Optionen;
	Optionen.Version = 13;
	Optionen.PresentVals.clear();
  QString fn;
  PDF_Opts *dia = new PDF_Opts(this, doc->DocName, doc->UsedFonts, view, Optionen.PresentVals);
  if (dia->exec())
  	{
  	qApp->setOverrideCursor(QCursor(waitCursor), true);
  	fn = dia->Datei->text();
		Optionen.Thumbnails = dia->CheckBox1->isChecked();
		Optionen.Compress = dia->Compression->isChecked();
		Optionen.Resolution = dia->Resolution->value();
		Optionen.EmbedList = dia->FontsToEmbed;
		Optionen.RecalcPic = dia->DSColor->isChecked();
		Optionen.PicRes = dia->ValC->value();
		Optionen.Bookmarks = dia->CheckBM->isChecked();
		Optionen.Binding = dia->ComboBind->currentItem();
		Optionen.PresentMode = dia->CheckBox10->isChecked();
		Optionen.PresentVals = dia->EffVal;
		Optionen.Articles = dia->Article->isChecked();
		PDFlib *pd = getPDFDriver();
		pd->PDF_Begin_Doc(doc, view, &Optionen, Prefs.AvailFonts, doc->UsedFonts, dia->BView);
		for (uint a = 0; a < view->Pages.count(); a++)
			{
			pd->PDF_Begin_Page(view->Pages.at(a));
			if (view->Pages.at(a)->MPageNam != "")
				pd->PDF_ProcessPage(view->MasterPages.at(view->MasterNames[view->Pages.at(a)->MPageNam]), a);
			pd->PDF_ProcessPage(view->Pages.at(a), a);
			pd->PDF_End_Page();
			}
		QString dd = pd->PDF_End_Doc();
		QFile f(fn);	
		if (f.open(IO_WriteOnly))
			{
			QTextStream t(&f);
			t.writeRawBytes(dd, dd.length());
			f.close();	
			}
		delete pd;
		closePDFDriver();
 		qApp->setOverrideCursor(QCursor(arrowCursor), true);
		}
  delete dia;
}

void ScribusApp::ModifyObject()
{
	NoFrameEdit();
	int itNr = *doc->ActPage->SelItem.at(0);
	PageItem* b = doc->ActPage->Items.at(itNr);
  ModObj *dia = new ModObj(this, b, doc->PageColors, doc, &InputProfiles);
	connect(dia, SIGNAL(DocChanged()), this, SLOT(slotDocCh()));
  dia->exec();
	delete dia;
	Mpal2->setLvalue(b->LocalScX, b->LocalScY, b->LocalX, b->LocalY );
}

void ScribusApp::slotElemRead(QString Name, int x, int y, bool art, bool loca)
{
	NoFrameEdit();
  ScriXmlDoc *ss = new ScriXmlDoc();
  if(ss->ReadElem(Name, Prefs.AvailFonts, doc, x, y, art, loca))
  	{
  	BuildFontMenu();
		Spal->updateFList();
  	doc->ActPage->update();
  	slotDocCh();
  	}
  delete ss;
}

void ScribusApp::slotChangeUnit(int art)
{
	doc->Einheit = art;
	if (art == 0)
		{
		Umrech = 1.0;
		view->UN->setText("pt");
		}
	else
		{
		Umrech = 0.3527777;
		view->UN->setText("mm");
		}
	Mpal2->UnitChange();
	view->DrawNew();
}

void ScribusApp::ManageTemp()
{
	MusterSeiten *dia = new MusterSeiten(this, doc, view);
	connect(dia, SIGNAL(CreateNew(int)), this, SLOT(slotNewPage(int)));
	connect(dia, SIGNAL(Fertig()), this, SLOT(ManTempEnd()));
	menuBar()->setItemEnabled(pgmm, 0);
	editMenu->setItemEnabled(tman, 0);
	MenuStat[0] = DatSav->isEnabled();
	MenuStat[1] = fileMenu->isItemEnabled(fid1);
	MenuStat[2] = fileMenu->isItemEnabled(fid4);
	MenuStat[3] = fileMenu->isItemEnabled(fid5);
	DatNeu->setEnabled(false);
	DatSav->setEnabled(false);
	DatOpe->setEnabled(false);
	DatClo->setEnabled(false);
	fileMenu->setItemEnabled(fid1, 0);
	fileMenu->setItemEnabled(fid4, 0);
	fileMenu->setItemEnabled(fid5, 0);
	fileMenu->setItemEnabled(fid12, 0);
	fileMenu->setItemEnabled(fid13, 0);
	fileMenu->setItemEnabled(fid14, 0);
	TemplateMode = true;
	dia->show();
}

void ScribusApp::ManTempEnd()
{
	TemplateMode = false;
	menuBar()->setItemEnabled(pgmm, 1);
	editMenu->setItemEnabled(tman, 1);
	DatNeu->setEnabled(true);
	DatSav->setEnabled(MenuStat[0]);
	DatOpe->setEnabled(true);
	DatClo->setEnabled(true);
	fileMenu->setItemEnabled(fid1, MenuStat[1]);
	fileMenu->setItemEnabled(fid4, MenuStat[2]);
	fileMenu->setItemEnabled(fid5, MenuStat[3]);
	fileMenu->setItemEnabled(fid12, 1);
	fileMenu->setItemEnabled(fid13, 1);
	fileMenu->setItemEnabled(fid14, 1);
	if (view->Pages.count() > 1)
		{
		pageMenu->setItemEnabled(pgmd, 1);
		pageMenu->setItemEnabled(pgmv, 1);
		}
	else
		{
		pageMenu->setItemEnabled(pgmd, 0);
		pageMenu->setItemEnabled(pgmv, 0);
		}
	if (doc->isModified())
		slotDocCh();
}

void ScribusApp::ApplyTemp()
{
	QString mna;
	ApplyT *dia = new ApplyT(this, view);
	if (dia->exec())
		{
		mna = dia->Templ->currentText();
		if (mna == tr("Normal"))
			mna = "Normal";
		doc->ActPage->MPageNam = mna;
		view->DrawNew();
		slotDocCh();
		}
	delete dia;
}

void ScribusApp::GroupObj()
{
	int itNr;
	PageItem* b;
	for (uint a=0; a<doc->ActPage->SelItem.count(); a++)
		{
		itNr = *doc->ActPage->SelItem.at(a);
		b = doc->ActPage->Items.at(itNr);
		b->Groups.push(doc->GroupCounter);
		}
	doc->GroupCounter++;
	slotDocCh();
}

void ScribusApp::UnGroupObj()
{
	int itNr;
	PageItem* b;
	for (uint a=0; a<doc->ActPage->SelItem.count(); a++)
		{
		itNr = *doc->ActPage->SelItem.at(a);
		b = doc->ActPage->Items.at(itNr);
		b->Groups.pop();
		}
	doc->ActPage->Deselect();
	slotDocCh();
}

void ScribusApp::StatusPic()
{
	if (HaveDoc)
		{
		PicStatus *dia = new PicStatus(this, doc, view);
		connect(dia, SIGNAL(GotoSeite(int)), this, SLOT(SelectFromOutlS(int)));
		dia->exec();
		delete dia;
		}
}

QString ScribusApp::CFileDialog(QString caption, QString filter, QString defNa, bool Pre)
{
	CustomFDialog dia(this, caption, filter, Pre);
	if (defNa != "")
		dia.setSelection(defNa);
	if (dia.exec())
		return dia.selectedFile();
	else
		return "";
}

void ScribusApp::RunPlug(int id)
{
	int a = extraMenu->indexOf(id);
	if (a > 1)
		{
		a -= 2;
		CallDLL(PluginMap[extraMenu->text(id)]);
		}
}

void ScribusApp::RunImportPlug(int id)
{
	int a = importMenu->indexOf(id);
	if (a > 0)
		{
		a -= 1;
		CallDLL(PluginMap[importMenu->text(id)]);
		}
}

void ScribusApp::RunExportPlug(int id)
{
	int a = exportMenu->indexOf(id);
	if (a > 2)
		{
		a -= 3;
		CallDLL(PluginMap[exportMenu->text(id)]);
		}
}

void ScribusApp::InitPlugs()
{
	QString pfad = PREL;
	QString nam = "";
	int ty = 0;
	pfad += "/share/scribus/plugins/";
	QDir d(pfad, "*.so*", QDir::Name, QDir::Files | QDir::Executable | QDir::NoSymLinks);
	if ((d.exists()) && (d.count() != 0))
		{
		extraMenu->insertSeparator();
		for (uint dc = 0; dc < d.count(); dc++)
			{
			nam = DLLName(d[dc]);
			if (nam != "")
				{
				ty = DLLType(d[dc]);
				if (ty == 1)
					extraMenu->insertItem(nam);
				if (ty == 2)
					importMenu->insertItem(nam);
				if (ty == 3)
					exportMenu->insertItem(nam);
				PluginMap[nam] = d[dc];
				}
			}
	 	connect(extraMenu, SIGNAL(activated(int)), this, SLOT(RunPlug(int)));
	 	connect(importMenu, SIGNAL(activated(int)), this, SLOT(RunImportPlug(int)));
	 	connect(exportMenu, SIGNAL(activated(int)), this, SLOT(RunExportPlug(int)));
	 	}
}

void ScribusApp::CallDLL(QString name)
{
	void *mo;
	char *error;
	typedef void (*sdem)(QWidget *d, ScribusApp *plug);
	sdem demo;
	QString pfad = PREL;
	pfad += "/share/scribus/plugins/" + name;
	mo = dlopen(pfad, RTLD_LAZY);
	if (!mo)
		{
		cout << "Can't find Plugin" << endl;
		return;
		}
	dlerror();
	demo = (sdem)dlsym(mo, "Run");
	if ((error = dlerror()) != NULL)
		{
		cout << "Can't find Symbol" << endl;
		dlclose(mo);
		return;
		}
	(*demo)(this, this);
	dlclose(mo);
}

QString ScribusApp::DLLName(QString name)
{
	void *mo;
	char *error;
	typedef QString (*sdem0)();
	sdem0 demo;
	QString pfad = PREL;
	pfad += "/share/scribus/plugins/" + name;
	mo = dlopen(pfad, RTLD_LAZY);
	if (!mo)
		return "";
	dlerror();
	demo = (sdem0)dlsym(mo, "Name");
	if ((error = dlerror()) != NULL)
		{
		dlclose(mo);
		return "";
		}
	QString an = (*demo)();
	dlclose(mo);
	return an;
}

int ScribusApp::DLLType(QString name)
{
	void *mo;
	char *error;
	typedef int (*sdem0)();
	sdem0 demo;
	QString pfad = PREL;
	pfad += "/share/scribus/plugins/" + name;
	mo = dlopen(pfad, RTLD_LAZY);
	if (!mo)
		return 0;
	dlerror();
	demo = (sdem0)dlsym(mo, "Type");
	if ((error = dlerror()) != NULL)
		{
		dlclose(mo);
		return 0;
		}
	int an = (*demo)();
	dlclose(mo);
	return an;
}

void ScribusApp::GetCMSProfiles()
{
	MonitorProfiles.clear();
	PrinterProfiles.clear();
	InputProfiles.clear();
#ifdef HAVE_CMS
	QString pfad = PREL;
	QString nam = "";
	const char *Descriptor;
	cmsHPROFILE hIn;
	pfad += "/share/scribus/profiles/";
	QDir d(pfad, "*.icm", QDir::Name, QDir::Files | QDir::NoSymLinks);
	if ((d.exists()) && (d.count() != 0))
		{
		for (uint dc = 0; dc < d.count(); dc++)
			{
			hIn = cmsOpenProfileFromFile(pfad + d[dc], "r");
  		Descriptor = cmsTakeProductDesc(hIn);
			nam = QString(Descriptor);
			switch ((int) cmsGetDeviceClass(hIn))
				{
				case icSigInputClass:
					if ((int) cmsGetColorSpace(hIn) == icSigRgbData)
						InputProfiles[nam] = pfad + d[dc];
					break;
				case icSigColorSpaceClass:
					if ((int) cmsGetColorSpace(hIn) == icSigRgbData)
						InputProfiles[nam] = pfad + d[dc];
					break;
				case icSigDisplayClass:
					MonitorProfiles[nam] = d[dc];
					InputProfiles[nam] = pfad + d[dc];
					break;
				case icSigOutputClass:
					PrinterProfiles[nam] = d[dc];
					break;
				}
			cmsCloseProfile(hIn);
			}
		if ((!PrinterProfiles.isEmpty()) && (!InputProfiles.isEmpty()) && (!MonitorProfiles.isEmpty()))
			CMSavail = true;
		}
	else
		CMSavail = false;
#else
	CMSavail = false;
#endif
}

void ScribusApp::SetCMSPrefs()
{
	struct CMSset *CM;
	if (CMSavail)
		{
		if (HaveDoc)
			CM = &doc->CMSSettings;
		else
			CM = &Prefs.DCMSset;
		CMSPrefs *dia = new CMSPrefs(this, CM, &InputProfiles, &PrinterProfiles, &MonitorProfiles);
		if(dia->exec())
			{
			int cc = Prefs.DColors.count();
			QProgressDialog *dia2 = new QProgressDialog(this, "p", true);
			dia2->setMinimumDuration(0);
			dia2->setLabelText(tr("Adjusting Colors"));
			dia2->setCancelButtonText(tr("Cancel"));
			if (HaveDoc)
				{
				if (dia->Changed)
					{
  				cc = doc->PageColors.count() + view->CountElements();
  				dia2->setTotalSteps(cc);
					dia2->setProgress(0);
					slotDocCh();
#ifdef HAVE_CMS
					doc->HasCMS = doc->CMSSettings.CMSinUse;
					SoftProofing = doc->CMSSettings.SoftProofOn;
					CMSuse = doc->CMSSettings.CMSinUse;
					IntentPrinter = doc->CMSSettings.DefaultIntentPrinter;
					IntentMonitor = doc->CMSSettings.DefaultIntentMonitor;
#endif
  				qApp->setOverrideCursor(QCursor(waitCursor), true);
  				CloseCMSProfiles();
  				OpenCMSProfiles();
					RecalcColors(dia2);
					view->RecalcPictures(&InputProfiles, dia2);
					view->DrawNew();
					dia2->setProgress(cc);
 					qApp->setOverrideCursor(QCursor(arrowCursor), true);
 					}
				}
			else
				{
  			dia2->setTotalSteps(cc);
				dia2->setProgress(0);
				RecalcColors(dia2);
				}
			delete dia2;
			}
		delete dia;
		}
}

void ScribusApp::OpenCMSProfiles()
{
#ifdef HAVE_CMS
	QString pfad = PREL;
	pfad += "/share/scribus/profiles/";
	if (HaveDoc)
		{
		doc->DocInputProf = cmsOpenProfileFromFile(InputProfiles[doc->CMSSettings.DefaultInputProfile2], "r");
		doc->DocOutputProf = cmsOpenProfileFromFile(pfad + MonitorProfiles[doc->CMSSettings.DefaultMonitorProfile], "r");
		doc->DocPrinterProf = cmsOpenProfileFromFile(pfad + PrinterProfiles[doc->CMSSettings.DefaultPrinterProfile], "r");
		CMSDinputProf = CMSinputProf;
		CMSinputProf = doc->DocInputProf;
		CMSDoutputProf = CMSoutputProf;
		CMSoutputProf = doc->DocOutputProf;
		CMSDprinterProf = CMSprinterProf;
		CMSprinterProf = doc->DocPrinterProf;
		}
	else
		{
		CMSinputProf = cmsOpenProfileFromFile(InputProfiles[Prefs.DCMSset.DefaultInputProfile2], "r");
		CMSoutputProf = cmsOpenProfileFromFile(pfad + MonitorProfiles[Prefs.DCMSset.DefaultMonitorProfile], "r");
		CMSprinterProf = cmsOpenProfileFromFile(pfad + PrinterProfiles[Prefs.DCMSset.DefaultPrinterProfile], "r");
		}
#endif
}

void ScribusApp::CloseCMSProfiles()
{
#ifdef HAVE_CMS
	QString pfad = PREL;
	pfad += "/share/scribus/profiles/";
	if (HaveDoc)
		{
		cmsCloseProfile(doc->DocInputProf);
		cmsCloseProfile(doc->DocOutputProf);
		cmsCloseProfile(doc->DocPrinterProf);
		CMSinputProf = CMSDinputProf;
		CMSoutputProf = CMSDoutputProf;
		CMSprinterProf = CMSDprinterProf;
		}
	else
		{
		cmsCloseProfile(CMSinputProf);
		cmsCloseProfile(CMSoutputProf);
		cmsCloseProfile(CMSprinterProf);
		}
#endif
}

void ScribusApp::RecalcColors(QProgressDialog *dia)
{
	CListe::Iterator it;
	if (HaveDoc)
		{
		ColorMenu->clear();
		QPixmap pm = QPixmap(15, 15);
		int a = 0;
		ColorMenu->insertItem(tr("None"));
		for (it = doc->PageColors.begin(); it != doc->PageColors.end(); ++it)
			{
			doc->PageColors[it.key()].RecalcRGB();
			pm.fill(doc->PageColors[it.key()].getRGBColor());
			ColorMenu->insertItem(QIconSet(pm), it.key());
			if (it.key() == doc->Dbrush)
				{
				ColorMenu->setItemChecked(ColorMenu->idAt(a), true);
				}
			a++;
			if (dia != NULL)
				dia->setProgress(a);
			}
		Cpal->SetColors(doc->PageColors);
		}
	else
		{
		int a = 0;
		for (it = Prefs.DColors.begin(); it != Prefs.DColors.end(); ++it)
			{
			a++;
			if (dia != NULL)
				dia->setProgress(a);
			Prefs.DColors[it.key()].RecalcRGB();
			}
		Cpal->SetColors(Prefs.DColors);
		}
}

void ScribusApp::ModifyAnnot()
{
	PageItem *b;
  if (doc->ActPage->SelItem.count() != 0)
  	{
  	b = doc->ActPage->Items.at(*doc->ActPage->SelItem.at(0));
  	Annot *dia = new Annot(this, b, doc->PageC, doc->PageB, doc->PageH, view);
  	dia->exec();
  	delete dia;
  	}
}

void ScribusApp::SetShortCut()
{
	uint a;
	for (a = 0; a < 9; a++)
		{
		fileMenu->setAccel(Prefs.KeyActions[a].KeyID, Prefs.KeyActions[a].MenuID);
		}
	for (a = 9; a < 19; a++)
		{
		editMenu->setAccel(Prefs.KeyActions[a].KeyID, Prefs.KeyActions[a].MenuID);
		}
	for (a = 19; a < 30; a++)
		{
		ObjMenu->setAccel(Prefs.KeyActions[a].KeyID, Prefs.KeyActions[a].MenuID);
		}
	for (a = 30; a < 34; a++)
		{
		pageMenu->setAccel(Prefs.KeyActions[a].KeyID, Prefs.KeyActions[a].MenuID);
		}
	pageMenu->setAccel(Prefs.KeyActions[61].KeyID, Prefs.KeyActions[61].MenuID);
	for (a = 34; a < 45; a++)
		{
		viewMenu->setAccel(Prefs.KeyActions[a].KeyID, Prefs.KeyActions[a].MenuID);
		}
	for (a = 45; a < 51; a++)
		{
		toolMenu->setAccel(Prefs.KeyActions[a].KeyID, Prefs.KeyActions[a].MenuID);
		}
	extraMenu->setAccel(Prefs.KeyActions[51].KeyID, Prefs.KeyActions[51].MenuID);
	for (a = 52; a < 56; a++)
		{
		helpMenu->setAccel(Prefs.KeyActions[a].KeyID, Prefs.KeyActions[a].MenuID);
		}
}

void ScribusApp::slotTest()
{
}

void ScribusApp::slotTest2()
{
}
