/***************************************************************************
                          customfdialog.cpp  -  description
                             -------------------
    begin                : Fri Nov 30 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "customfdialog.h"
#include "customfdialog.moc"
#include <qimage.h>
#include <qpixmap.h>
#include <qfileinfo.h>
#include <qdir.h>
#include <qdom.h>
extern QImage LoadPict(QString fn);
extern bool loadTextQS(QString nam, QString *Buffer);
extern QPixmap loadIcon(QString nam);

ImIconProvider::ImIconProvider(QWidget *pa) : QFileIconProvider(pa)
{
  fmts.clear();
  fmts += "eps";
  fmts += "gif";
  fmts += "png";
  fmts += "jpg";
  fmts += "xpm";
  fmts += "tif";
  imagepm = loadIcon("image.png");
  pspm = loadIcon("postscript.png");
  txtpm = loadIcon("txt.png");
  docpm = loadIcon("doc.png");
  pdfpm = loadIcon("pdf.png");
}

ImIconProvider::~ImIconProvider()
{
}

const QPixmap * ImIconProvider::pixmap(const QFileInfo &fi)
{
	QString ext = fi.extension().lower();
	if (fmts.contains(ext))
   	{
		return &imagepm;
		}
	else
		{
		if (ext == "ps")
			return &pspm;
		if (ext == "txt")
			return &txtpm;
		if (ext == "scd")
			return &docpm;
		if (ext == "pdf")
			return &pdfpm;
		return QFileIconProvider::pixmap(fi);
		}
}

FDialogPreview::FDialogPreview(QWidget *pa) : QLabel(pa)
{
	setAlignment(AlignLeft | AlignTop);
	setMinimumSize( QSize( 100, 100 ) );
	setScaledContents( FALSE );
	setBackgroundColor( white );
	setFrameShape( QLabel::WinPanel );
	setFrameShadow( QLabel::Sunken );
}

FDialogPreview::~FDialogPreview()
{
}

void FDialogPreview::GenPreview(QString name)
{
	QPixmap pm;
	QString Buffer = "";
	setText("");
	QFileInfo fi = QFileInfo(name);
	QString ex = fi.extension(false).lower();
	if ((ex == "eps") || (ex == "jpg") || (ex == "gif") || (ex == "xpm") || (ex == "png") || (ex == "tif"))
		{
		QImage im = LoadPict(name);
		if (!im.isNull())
			{
			if ((im.width() > width()-5) || (im.height() > height()-5))
				{
				QImage im2;
				float sx = im.width() / float(width()-5);
				float sy = im.height() / float(height()-5);
				if (sy < sx)
					im2 = im.smoothScale(im.width() / sx, im.height() / sx);
				else
					im2 = im.smoothScale(im.width() / sy, im.height() / sy);
				im = im2;
				im2.detach();
				}
			pm.convertFromImage(im);
			setPixmap(pm);
			}
		}
	else
		{
		if (loadTextQS(name, &Buffer))
			{
			if (Buffer.startsWith("<SCRIBUS>"))
				{
				QDomDocument docu("scridoc");
				if(!docu.setContent(Buffer))
					return;
				QDomElement elem=docu.documentElement();
				if (elem.tagName() != "SCRIBUS")
					return;
				QDomNode DOC=elem.firstChild();
				QDomElement dc=DOC.toElement();
				QString Tit = tr("Title:")+" ";
				QString ti2 = dc.attribute("TITLE");
				if (ti2 == "")
					ti2= tr("No Title");
				Tit += ti2+"\n";
				QString Aut = tr("Author:")+" ";
				QString au2 = dc.attribute("AUTHOR");
				if (au2 == "")
					au2 = tr("Unknown");
				Aut += au2;
				setText(tr("Scribus-Document")+"\n\n"+Tit+Aut);
				}
			else
				setText(Buffer.left(200));
			}
		}
}	

void FDialogPreview::previewUrl( const QUrl &url )
{
	if (url.isLocalFile())
		GenPreview(url.path());
}

CustomFDialog::CustomFDialog(QWidget *pa, QString cap, QString filter, bool Pre) : QFileDialog(pa, "FD", true)
{
 	setIcon(loadIcon("AppIcon.xpm"));
 	setCaption(cap);
	setFilters(filter);
	cDir = QDir();
	setDir(cDir);
	setIconProvider(new ImIconProvider(this));
	FDialogPreview *pw = new FDialogPreview( this );
	setContentsPreviewEnabled( true );
	setContentsPreview( pw, pw );
	if (Pre)
		setPreviewMode( QFileDialog::Contents );
	else
		setPreviewMode( QFileDialog::NoPreview );
	setViewMode( QFileDialog::List );
}

CustomFDialog::~CustomFDialog()
{
	setIconProvider(0);
	cDir.setCurrent(dir()->path());
}
