/**
 * @file scim_exception.h
 * @brief Defines the scim::Exception class.
 */

/*
 * Smart Common Input Method
 * 
 * Copyright (c) 2004 James Su <suzhe@turbolinux.com.cn>
 * Copyright (c) 2003 James Su <suzhe@turbolinux.com.cn>
 * Copyright (c) 2002 James Su <suzhe@turbolinux.com.cn>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: scim_exception.h,v 1.7 2004/02/06 07:53:15 suzhe Exp $
 */

#ifndef __SCIM_EXCEPTION_H
#define __SCIM_EXCEPTION_H

namespace scim {
/**
 * @addtogroup Helper
 * @{
 */

/**
 * @brief A base class of all other exception classes.
 *
 * All other exception classes in namespace scim
 * should be derived from this class.
 */
class Exception: public std::exception
{
    String m_what;
public:
    Exception (const String& what_arg) : m_what (what_arg) { }
    ~Exception () throw () {}
    virtual const char* what () const throw () { return m_what.c_str (); }
};

/** @} */

} // namespace scim

#endif //__SCIM_EXCEPTION_H
/*
vi:ts=4:nowrap:ai:expandtab
*/
