#!/bin/sh

DO_MAILDIR=0
DO_MAILBOX=0
#SYS_ADMIN=root@`hostname`.``
SYS_ADMIN=root@`hostname -f`

export PATH=
. /usr/local/share/mailscan/scanmail.cfg
export PATH=/usr/bin:/usr/local/bin:/bin

function bounce 
{
 export REPORT=""
 bouncerpt
}

function bouncerpt 
{
  SENDER=`awk -f /usr/local/share/mailscan/from.awk < $FILENAME` 
  FILENAME=`awk '{print $2}' < $FILENAME.result`
  RCPT=$RECIPIENT
  DATE='date -R'
  if [ $DO_MAILDIR = 1 ] 
    then
     OUTF=~/Maildir/new/`date +%s`.`crc32 $FILENAME`.proxy 
    else
     OUTF=~/.scanmail/tmp/`date +%s`.`crc32 $FILENAME`.bounce
  fi
  cat /usr/local/share/mailscan/viruswarn.txt | sed -e "s/MYHOST/$MYHOST/g" | sed -e "s/SYS_ADMIN/$SYS_ADMIN/g" | sed -e "s/FROM/$SENDER/g" | sed -e "s/RCPT/$RCPT/g" | sed -e "s/FILE/$FILENAME/g" > $OUTF
  [ $REPORT != "" ] && cat $REPORT >> $OUTF
  cat $OUTF
  mail -s "WARNING! Mail filtered!" $SENDER < $OUTF 
  cat /usr/local/share/mailscan/viruswarn.rcpt.txt | sed -e "s/MYHOST/$MYHOST/g" | sed -e "s/SYS_ADMIN/$SYS_ADMIN/g" | sed -e "s/FROM/$SENDER/g" | sed -e "s/RCPT/$RCPT/g" | sed -e "s/FILE/$FILENAME/g" > $OUTF
   if [ $DO_MAILBOX = 1 ] 
     then
      echo >> $MBOX_NAME 
      echo >> $MBOX_NAME
      cat $OUTF >> $MBOX_NAME
     fi
}

function noterpt 
{
  SENDER=`awk -f /usr/local/share/mailscan/from.awk < $FILENAME` 
  FILENAME=`awk '{print $2}' < $FILENAME.result`
  RCPT=$RECIPIENT
  DATE='date -R'
  if [ $DO_MAILDIR = 1 ] 
    then
     OUTF=~/Maildir/new/`date +%s`.`crc32 $FILENAME`.proxy 
    else
     OUTF=~/.scanmail/tmp/`date +%s`.`crc32 $FILENAME`.bounce
  fi
  cat /usr/local/share/mailscan/virusnote.txt | sed -e "s/MYHOST/$MYHOST/g" | sed -e "s/SYS_ADMIN/$SYS_ADMIN/g" | sed -e "s/FROM/$SENDER/g" | sed -e "s/RCPT/$RCPT/g" | sed -e "s/FILE/$FILENAME/g" > $OUTF
  [ $REPORT != "" ] && cat $REPORT >> $OUTF
  cat $OUTF
  #mail -s "WARNING! Mail suspect!" $SENDER < $OUTF 
  cat /usr/local/share/mailscan/virusnote.rcpt.txt | sed -e "s/MYHOST/$MYHOST/g" | sed -e "s/SYS_ADMIN/$SYS_ADMIN/g" | sed -e "s/FROM/$SENDER/g" | sed -e "s/RCPT/$RCPT/g" | sed -e "s/FILE/$FILENAME/g" > $OUTF
   if [ $DO_MAILDIR = 1 ]  
     then 
      cp $FILENAME $OUTF.2
   fi   
   if [ $DO_MAILBOX = 1 ] 
     then
      echo >> $MBOX_NAME 
      echo >> $MBOX_NAME
      cat $OUTF >> $MBOX_NAME
      cat $FILENAME >> $MBOX_NAME
     fi
}

function unpack
{
cat $FILENAME.tmp | egrep -i '^content-type: application/ms-tnef' > /dev/null
if [ $?=0 ] 
 then 
  echo FIX ME !! MORE TO COME 
 else
  echo FIX ME !! MORE TO COME!
fi
}

function doexternal
{
unpack
/usr/local/share/mailscan/external-wrapper.sh ~/.scanmail/tmp/$FILENAME.dir $FILENAME  

case $? in 
 0) ;;    # Everything's fine!
 1) export REPORT=~/.scanmail/tmp/$FILENAME.dir/$FILENAME.report && bouncerpt && exit 0 ;;
 2) bounce && exit 0 ;;
 3) export REPORT=~/.scanmail/tmp/$FILENAME.dir/$FILENAME.report && noterpt && exit 0 ;;
 4) note && exit 0 ;;
 255) ;;  # Scanner died, what shall i do?!
esac
}
 
mkdir -p ~/.scanmail/
mkdir -p ~/.scanmail/tmp
FILENAME=~/.scanmail/tmp/`date +%s`.`rand` 

cat > $FILENAME
reformime -i < $FILENAME > $FILENAME.tmp
cat $FILENAME.tmp | egrep -i '^content-name:.*\.(vbs|exe|com|bat|js|jar)$' > $FILENAME.result
#}    # <----- Where the hell comes this from?!

if [ -s $FILENAME.result ]
 then
  bounce
  exit 0 
 else
  cat $FILENAME.tmp | egrep -i '^content-type: application/ms-tnef' > $FILENAME.result
  if [ $? = 0 ] 
   then
	mkdir -p $FILENAME.dir
	cd $FILENAME.dir
	reformime `cat $FILENAME.tmp | awk -f /usr/local/share/mailscan/reform-tnef.awk | grep "-e -s" ` < $FILENAME | tnef -t > winmail.dat.cont
	cat winmail.dat.cont | grep -i ".*\.(vbs|com|exe|bat|js|jar)$" > $FILENAME.result
	if [ -s $FILENAME.result ]
 	 then
	  cd ..
	  bounce
	  rm -r $FILENAME.dir
  	  exit 0
	fi  
   #rm -r $FILENAME.dir
  else	
   [ $DO_MAILDIR = 1 ] && cat $FILENAME > ~/Maildir/new/`date +%s`.`crc32 $FILENAME`.proxy
   if [ $DO_MAILBOX = 1 ] 
     then
      echo >> $MBOX_NAME
      echo >> $MBOX_NAME 
      cat $FILENAME >> $MBOX_NAME
     fi
  fi 
  rm -rf $FILENAME.dir $FILENAME $FILENAME.tmp $FILENAME.result 
 fi

