/* HP Scanjet 3900 series - Structures and global variables

   Copyright (C) 2005-2006 Jonathan Bravo Lopez <jkdsoft@gmail.com>

   This file is part of the SANE package.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   As a special exception, the authors of SANE give permission for
   additional uses of the libraries contained in this release of SANE.

   The exception is that, if you link a SANE library with other files
   to produce an executable, this does not by itself cause the
   resulting executable to be covered by the GNU General Public
   License.  Your use of that executable is in no way restricted on
   account of linking the SANE library code into it.

   This exception does not, however, invalidate any other reasons why
   the executable file might be covered by the GNU General Public
   License.

   If you submit changes to SANE to the maintainers to be included in
   a subsequent release, you agree by submitting the changes that
   those changes may be distributed with this exception intact.

   If you write modifications of your own for SANE, it is your choice
   whether to permit this exception to apply to your modifications.
   If you do not wish that, delete this exception notice.
*/

#define TOSHIBA     0x01
#define SONY        0x00

#define USB20       0x01
#define USB11       0x00

#define ST_NEG      0x03
#define ST_TA       0x02
#define ST_NORMAL   0x01

#define CM_COLOR    0x00
#define CM_GRAY     0x01
#define CM_LINEART  0x02

#define CL_RED      0x00
#define CL_GREEN    0x01
#define CL_BLUE     0x02

#define FLB_LAMP    0x01
#define TMA_LAMP    0x02

#define IST_NORMAL  0x00
#define IST_TA      0x01
#define IST_NEG     0x02

#define ICM_GRAY    0x00
#define ICM_LINEART 0x01
#define ICM_COLOR   0x02

#define TRUE        0x01
#define FALSE       0x00

#define OK          0x00
#define ERROR       -1

#define FIX_BY_HARD 0x01
#define FIX_BY_SOFT 0x02

#define REF_AUTODETECT      0x02
#define REF_TAKEFROMSCANNER 0x01

#define RSZ_GRAYL   0x00
#define RSZ_COLOURL 0x01
#define RSZ_COLOURH 0x02
#define RSZ_LINEART 0x03
#define RSZ_GRAYH   0x04

#define _B0(x)      ((SANE_Byte)((x) & 0xFF))
#define _B1(x)      ((SANE_Byte)((x) >> 0x08))
#define _B2(x)      ((SANE_Byte)((x) >> 0x10))
#define _B3(x)      ((SANE_Byte)((x) >> 0x18))

/* data types */

typedef unsigned short USHORT;

#ifdef STANDALONE

#define SANE_STATUS_GOOD 0
typedef unsigned char SANE_Byte;
typedef int SANE_Int;

#endif

/* structures */

struct st_debug_opts
{
  SANE_Byte SaveCalibFile;
  SANE_Byte DumpShadingData;
  SANE_Byte ScanWhiteBoard;
  SANE_Byte EnableGamma;
};

struct st_scanning
{
  SANE_Byte *imagebuffer;
  SANE_Byte *imagepointer;
  SANE_Int bfsize;

  /* Pointers to each channel colour */
  SANE_Byte *pColour[3];
  SANE_Byte *pColour1[3];
  SANE_Byte *pColour2[3];

  /* Channel displacements */
  SANE_Int desp[3];
  SANE_Int desp1[3];
  SANE_Int desp2[3];
};

struct st_resize
{
  SANE_Byte mode;
  SANE_Int type;
  SANE_Int fromwidth;
  SANE_Int towidth;
  SANE_Int bytesperline;

  SANE_Byte *v3624;
  SANE_Byte *v3628;
  SANE_Byte *v362c;
};

struct st_gammatables
{
  SANE_Int depth;		/*0=0x100| 4=0x400 |8=0x1000 */
  SANE_Byte *table[3];
};

struct st_readimage
{
  SANE_Int Size4Lines;

  SANE_Byte Starting;
  SANE_Byte *DMABuffer;
  SANE_Int DMABufferSize;
  SANE_Byte *RDStart;
  SANE_Int RDSize;
  SANE_Int DMAAmount;
  SANE_Int Channel_size;
  SANE_Byte Channels_per_dot;
  SANE_Int ImageSize;
  SANE_Int Bytes_Available;
  SANE_Int Max_Size;
  SANE_Byte Cancel;
};

struct st_calib_table
{
  /* 32 bytes
     08be|08e0|3654
     red green blue */
  USHORT edcg1[3];		/* 08e0|08e2|08e4 */
  USHORT edcg2[3];		/* 08e6|08e8|08ea */
  USHORT odcg1[3];		/* 08ec|08ee|08f0 */
  USHORT odcg2[3];		/* 08f2|08f4|08f6 */
  SANE_Byte pag[3];		/* 08f8|08f9|08fa */
  SANE_Byte vgag1[3];		/* 08fb|08fc|08fd */
  SANE_Byte vgag2[3];		/* 08fe|08ff|0900 */
};

struct st_icolours
{
  SANE_Int red;
  SANE_Int green;
  SANE_Int blue;
};

struct st_dcolours
{
  double red;
  double green;
  double blue;
};

struct st_calibration_data
{
  SANE_Int WStripXPos;
  SANE_Int WStripYPos;
  SANE_Int BStripXPos;
  SANE_Int BStripYPos;
  SANE_Int WRef[3];
  SANE_Int BRef[3];
  SANE_Byte RefBitDepth;
  double OffsetTargetMax;
  double OffsetTargetMin;
  double OffsetBoundaryRatio1;
  double OffsetBoundaryRatio2;
  double OffsetAvgRatio1;
  double OffsetAvgRatio2;
  SANE_Int CalibOffset10n;
  SANE_Int CalibOffset20n;
  SANE_Int AdcOffEvenOdd;
  SANE_Int AdcOffQuickWay;
  SANE_Int OffsetEven1[3];
  SANE_Int OffsetOdd1[3];
  SANE_Int OffsetEven2[3];
  SANE_Int OffsetOdd2[3];
  SANE_Byte OffsetHeight;
  SANE_Byte OffsetPixelStart;
  SANE_Byte OffsetNPixel;
  SANE_Byte OffsetNSigma;
  SANE_Int AdcOffPredictStart;
  SANE_Int AdcOffPredictEnd;
  SANE_Byte OffsetAvgTarget[3];
  SANE_Byte OffsetTuneStep1;
  SANE_Byte OffsetTuneStep2;
  double GainTargetFactor;
  SANE_Int CalibGain10n;
  SANE_Int CalibGain20n;
  SANE_Int CalibPAGOn;
  SANE_Int GainHeight;
  SANE_Byte PAG[3];
  SANE_Byte Gain1[3];
  SANE_Byte Gain2[3];
  /* White Shading */
  SANE_Int WShadingOn;
  SANE_Int WShadingHeight;
  SANE_Int WShadingPreDiff[3];
  SANE_Int unknown;		/*?? */
  double ShadingCut[3];
  /* Black Shading */
  SANE_Int BShadingOn;
  SANE_Int BShadingHeight;
  SANE_Int BShadingDefCutOff;
  SANE_Int BShadingPreDiff[3];
  double ExternBoundary;
  SANE_Int EffectivePixel;
  SANE_Byte TotShading;
};

struct st_calibration
{
  /* faac */
  struct st_calib_table mitabla;	/* 0..35 */
  USHORT *white_shading[3];	/* +36 +40 +44 */
  USHORT *black_shading[3];	/* +48 +52 +56 */
  SANE_Int WRef[3];		/* +60 +62 +64 */
  SANE_Byte value2;		/* +66 */
  SANE_Byte value3;		/* +67 */
  SANE_Int value;		/* +68 */
  SANE_Int shadinglength;	/* +72 */
};

struct st_cal2
{
  /* f9f8  35 bytes */
  SANE_Int table_count;		/* +0  f9f8 */
  SANE_Int shadinglength1;	/* +4  f9fc */
  SANE_Int shadinglength2;	/* +8  fa00 */
  SANE_Int shadinglength3;	/* +12 fa04 */
  USHORT *tables[4];		/* +16+20+24+28  fa08 fa0c fa10 fa14 */
  USHORT *table2;		/* +32 fa18 */
};

struct st_coords
{
  SANE_Int left;
  SANE_Int width;
  SANE_Int top;
  SANE_Int height;
};

struct params
{
  SANE_Int scantype;
  SANE_Int colormode;
  SANE_Int resolution_x;
  SANE_Int resolution_y;
  struct st_coords coords;
  SANE_Int depth;
  SANE_Int channel;
};

struct st_constrains
{
  struct st_coords reflective;
  struct st_coords negative;
  struct st_coords slide;
};

struct st_scanparams		/* 44 bytes size */
{
  /* 760-78b|155c-1587|fa58-fa83|f0c4 */
  SANE_Byte colormode;		/* [+00] 760 */
  SANE_Byte depth;		/* [+01] 761 */
  SANE_Byte samplerate;		/* [+02] 762 */
  SANE_Byte timing;		/* [+03] 763 */
  SANE_Int channel;		/* [+04] 764 */
  SANE_Int sensorresolution;	/* [+06] 766 */
  SANE_Int resolution_x;	/* [+08] 768 */
  SANE_Int resolution_y;	/* [+10] 76a */
  struct st_coords coord;	/* [+12] left */
  /* [+16] width */
  /* [+20] top */
  /* [+24] height */
  SANE_Int shadinglength;	/* [+28] 77c */
  SANE_Int v157c;		/* [+32] 780 */
  SANE_Int bytesperline;	/* [+36] 784 */
  SANE_Int expt;		/* [+40] 788 */

  SANE_Int startpos;		/* [+44] 78c */
  SANE_Int leftleading;		/* [+46] 78e */
  SANE_Int ser;			/* [+48] 790 */
  SANE_Int ler;			/* [+52] 794 */
  SANE_Int scantype;		/* [+58] 79a */
};

struct st_hwdconfig		/* 28 bytes size */
{
  /* fa84-fa9f|f0ac-f0c7|e838-e853|f3a4-f3bf */
  SANE_Int startpos;		/* +0 */
  /* +1..7 */
  SANE_Byte arrangeline;	/* +8 */
  SANE_Byte scantype;		/* +9 */
  SANE_Byte compression;	/* +10 */
  SANE_Byte use_gamma_tables;	/* +11 */
  SANE_Byte gamma_tablesize;	/* +12 */
  SANE_Byte unk1;		/* +13 */
  SANE_Byte unk2;		/* +14 */
  SANE_Byte unk3;		/* +15 */
  SANE_Byte motorplus;		/* +16 */
  SANE_Byte static_head;	/* +17 */
  SANE_Byte depth;		/* +18 */
  SANE_Byte dummy_scan;		/* +19 */
  SANE_Byte highresolution;	/* +20 */
  SANE_Byte sensorevenodddistance;	/* +21 */
  /* +22..23 */
  SANE_Int calibrate;		/* +24 */
};

struct st_scandata
{
  SANE_Int totalcount;
  SANE_Byte count;
  SANE_Int *mode;
};

struct st_scantypes
{
  struct st_scandata color[3];
};

struct st_cph
{
  double p1;
  double p2;
  SANE_Byte ps;
  SANE_Byte ge;
  SANE_Byte go;
};

struct st_timing
{
  SANE_Int sensorresolution;
  SANE_Byte cnpp;
  SANE_Byte cdss1;
  SANE_Byte cdsc1;
  SANE_Byte cdss2;
  SANE_Byte cdsc2;
  SANE_Byte cvtrp[3];
  SANE_Byte cvtrw;
  SANE_Byte cvtrbpw;
  SANE_Byte cvtrfpw;
  SANE_Int clamps;
  SANE_Int clampe;
  double adcclkp[2];
  SANE_Int adcclkp2e;
  struct st_cph cph[6];
};

struct st_scanmode
{
  SANE_Byte samplerate;
  SANE_Byte systemclock;
  SANE_Int ctpc;
  SANE_Byte dummyline;
  SANE_Int expt[3];
  SANE_Int mexpt[3];
  SANE_Byte motorplus;
  SANE_Byte timing;
  SANE_Int motorcurve;
  SANE_Int motorbackstep;
  SANE_Byte multiexposurefor16bitmode;
  SANE_Byte multiexposureforfullspeed;
  SANE_Byte has_curves;
  SANE_Int mri;
  SANE_Int msi;
  SANE_Int mmtir;
  SANE_Int mmtirh;
  SANE_Int skiplinecount;
  SANE_Byte scanmotorsteptype;
};

struct stmotormove
{
  SANE_Byte systemclock;	/* + 0 */
  SANE_Byte v12e435;		/* + 1 */
  SANE_Byte scanmotorsteptype;	/* + 2 */
  USHORT motorcurve;		/* + 4  word */
  /* + 6..7 */
  SANE_Int coord_y;		/* + 8 */
  SANE_Int ctpc;		/* + 12 dword */
  SANE_Int has_curves;		/* + 16 dword */
  SANE_Int v12e448;		/* + 20 */
  SANE_Int v12e44c;		/* + 24 */
};

struct st_find_edge
{
  SANE_Int exposuretime;
  SANE_Int scanystart;
  SANE_Int scanylines;
  SANE_Int findlermethod;
  SANE_Int findlerstart;
  SANE_Int findlerend;
  SANE_Int checkoffsetser;
  SANE_Int findserchecklines;
  SANE_Int findserstart;
  SANE_Int findserend;
  SANE_Int findsermethod;
  SANE_Int offsettoser;
  SANE_Int offsettoler;
};

struct st_acc
{
  SANE_Byte normalscan;
  SANE_Byte parkhome;
  SANE_Byte smearing;
};

struct st_dec
{
  SANE_Byte normalscan;
  SANE_Byte parkhome;
  SANE_Byte smearing;
  SANE_Byte scanbufferfull;
};

struct st_ccurve
{
  SANE_Int minspeed;		/* word & 0xffff */
  SANE_Int maxspeed;
  SANE_Int count;
  SANE_Int *step;
};

struct st_motorsetting
{
  SANE_Int acccurvecount;
  SANE_Int deccurvecount;
  SANE_Int mri;
  SANE_Int msi;
  SANE_Int skiplinecount;
  SANE_Int motorbackstep;
  struct st_acc acc;
  struct st_dec dec;
  struct st_ccurve *acccurve;	/* acccurves */
  struct st_ccurve *deccurve;	/* deccurves */
};

struct st_checkstable
{
  double diff;
  SANE_Int interval;
  SANE_Int tottime;
};


/* Unknown vars */
SANE_Int v14b4 = 0x00;
char v15fc;			/* char */
SANE_Byte *v1600 = NULL;	/* tabla */
SANE_Byte *v1604 = NULL;	/* tabla */
SANE_Byte *v1608 = NULL;	/* tabla */
SANE_Int v1494 = 0x00;		/* Resultado de la funcion AllocGammaTable */
/*static SANE_Int  v1220 = 0x80;*/
SANE_Int v084e = 0x00;
SANE_Int v0748 = 0x00;
SANE_Int v360c = 0x00;
static SANE_Int v3618 = 0x01;
SANE_Int v53ba = 0x00;
SANE_Int v0740 = 0x00;
SANE_Byte v07d0;
static SANE_Byte v163f = 0x01;
SANE_Byte v160c;
SANE_Int v1610;
SANE_Byte v1619;
SANE_Int v163c;
SANE_Int v15f8;
SANE_Int v1268 = 0x00;
SANE_Int acccurvecount;		/* counter used y MotorSetup */
SANE_Int deccurvecount;		/* counter used y MotorSetup */
SANE_Int smearacccurvecount;	/* counter used y MotorSetup */
SANE_Int smeardeccurvecount;	/* counter used y MotorSetup */

/* Known vars */
SANE_Int offset_red;		/* USB Address 0070 */
SANE_Int offset_green;		/* USB Address 0072 */
SANE_Int offset_blue;		/* USB Address 0074 */

SANE_Byte gain_blue = 0;	/* byte */
SANE_Byte gain_green = 0;	/* byte */
SANE_Byte gain_red = 0;		/* byte */

SANE_Byte BGeneral[0x71a];	/* Buffer general */
static SANE_Int timingfile = -1;
static SANE_Int usbfile = -1;
SANE_Int ccdtype;
SANE_Int usbtype;
SANE_Byte vcolormode;
SANE_Int scantype;
SANE_Int warmupt1;
SANE_Int warmupt2;

SANE_Byte pwmlampenabled;
SANE_Byte pwmlamplevel;
SANE_Byte pwmlampfrequencyflb1200;
SANE_Byte pwmlampdutycycleflb1200;
SANE_Byte pwmlampfrequencyflb600;
SANE_Byte pwmlampdutycycleflb600;
SANE_Byte pwmlampfrequencyta1200;
SANE_Byte pwmlampdutycycleta1200;
SANE_Byte pwmlampfrequencyta600;
SANE_Byte pwmlampdutycycleta600;
SANE_Byte pwmlampfrequencyneg1200;
SANE_Byte pwmlampdutycycleneg1200;
SANE_Byte pwmlampfrequencyneg600;
SANE_Byte pwmlampdutycycleneg600;

SANE_Byte dpi100Lumping;
SANE_Byte changemotorcurrent;
SANE_Byte arrangeline;
SANE_Byte motorcount;
SANE_Byte timingcount;
SANE_Int realsensorresolution;
SANE_Byte sensorlinedistance;
SANE_Byte motortype;
SANE_Byte motorpwmfrequency;
SANE_Int motorresolution;
SANE_Byte binarythresholdh;
SANE_Byte binarythresholdl;
SANE_Int rgbchannelorder[3] = { 0, 0, 0 };
SANE_Int sensorchannelcolor[3] = { 0, 0, 0 };
SANE_Int sensorchannelgray[2] = { 0, 0 };

struct st_scantypes scandata[3];

SANE_Int dmabuffersize = 0;
SANE_Int dmasetlength = 0;
SANE_Int dmatransfersize = 0;
SANE_Byte shadingbase;
SANE_Byte shadingfact[3];
SANE_Byte arrangeline;
SANE_Int calibrate;
SANE_Int throughput;
SANE_Int compression;

struct st_calib_table default_calib_table;

SANE_Byte linedarlampoff;
SANE_Byte linedarklevel1;
SANE_Byte linedarklevel2;
SANE_Int pixeldarklevel;
SANE_Int pixeldarkscanlines;
SANE_Int pixeldarkdiscardpercent;
SANE_Int waittimeafterpixeldark;
SANE_Int discardwhitepercent1;
SANE_Int discardwhitepercent2;
SANE_Int discardwhitepercent3;
SANE_Int discardblackpercent1;
SANE_Int discardblackpercent2;
SANE_Int discardblackpercent3;
SANE_Byte sensortype;
SANE_Byte sensorevenodddistance;
SANE_Int realsensorresolution;
SANE_Int lampofftimer;
SANE_Int lampwarmupchecklevel;
SANE_Byte binarythresholdh;
SANE_Byte binarythresholdl;
SANE_Int basetargetcode;
char basetarget1;
char basetarget2;
SANE_Int basespeedpps;
SANE_Int basespeedmotormove;
SANE_Int highspeedmotormove;
SANE_Int parkhomemotormove;
SANE_Byte motormovecount = 0x00;
SANE_Int usefixedpwm;
SANE_Int bw_threshold = 0x00;

struct stmotormove *motormove = NULL;
struct st_find_edge findedge[3];
struct st_motorsetting *motorsetting = NULL;

struct st_checkstable check_preview;
struct st_checkstable check_flb;
struct st_checkstable check_tma;

struct st_gammatables hp_gamma;
struct st_scanmode *scanmodeparams = NULL;
struct st_timing *scantiming = NULL;

/* SetScanParams */
struct st_scanparams scan;
struct st_scanparams scan2;

SANE_Int firstconnection = 0;
SANE_Int findref;
SANE_Int bytesperline;		/* width * (3 colors [RGB]) */
SANE_Int imagewidth3;
SANE_Int lineart_width;
double dimageheight;		/* double */
SANE_Int imagesize;		/* bytesperline * coords.height */
SANE_Int imageresx;
SANE_Int imageresy;
SANE_Int imageheight;
SANE_Int imageheight2;
SANE_Int use_sensorevenodddist;
SANE_Int v1594;
SANE_Int v158c;
SANE_Int v15b4;
SANE_Int v15b8;
SANE_Int v15bc;
SANE_Int v15ac;
SANE_Int use_compresion;
SANE_Int v15f4;
SANE_Int use_hightresolution;
SANE_Byte scan_samplerate;

SANE_Int v06c0;
long ltickcount;

SANE_Int v11c8;
SANE_Int v11ec;
SANE_Int v11f8;
SANE_Int v11e8;
SANE_Int v11f0;
SANE_Int v11f4;
SANE_Int v11fc;
SANE_Int v11e4;

SANE_Int v1200;
SANE_Int v11d0;
SANE_Int v11cc;
SANE_Int v11d4;
SANE_Int v11d8;
SANE_Int v15fa;
SANE_Int waitforpwm;
SANE_Int v14b0;

SANE_Byte WRef[3];

USHORT *fixed_black_shading[3] = { NULL, NULL, NULL };
USHORT *fixed_white_shading[3] = { NULL, NULL, NULL };

/* Calibration */
struct st_scanparams cpyscan;
SANE_Byte bkRegisters[0x71a];
struct st_calib_table mitabla;	/* calibration table */
struct st_calib_table mitabla2;	/* calibration table */
SANE_Int v0750;

static SANE_Byte use_gamma_tables = TRUE;

SANE_Int read_v15b4 = 0;

SANE_Int v35b8 = 0;
SANE_Int arrangeline2;

SANE_Int v07c0 = 0;

SANE_Int orderchannel = FALSE;

SANE_Int channel_size;
SANE_Int sresolutiony;

struct st_readimage Reading;
struct st_constrains *constrains = NULL;
struct st_debug_opts RTS_Debug;
struct st_resize Resize;
struct st_scanning scanning;
