# Samizdat member model
#
#   Copyright (c) 2002-2007  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#
# vim: et sw=2 sts=2 ts=8 tw=0

require 'samizdat/engine'

class Member
  def Member.cached(id)
    if id = Resource.validate_id(id)
      cache.fetch_or_add(%{member/#{id}}) do
        Member.new(id)
      end
    else
      Member.new(nil)
    end
  end

  def initialize(id)
    if id and @id = Resource.validate_id(id)
      @login, @full_name = rdf.select_one %{
        SELECT ?login, ?full_name
        WHERE (s::fullName #{@id} ?full_name)
              (s::login #{@id} ?login)}
    else
      @login = 'guest'
      @full_name = 'guest'
    end
  end

  def guest?
    not (@id and @id.kind_of? Integer)
  end

  attr_reader :id, :login, :full_name
end


