# Samizdat feed syndication helpers
#
#   Copyright (c) 2002-2007  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#
# vim: et sw=2 sts=2 ts=8 tw=0

require 'samizdat/engine'
require 'rss/maker'

module SyndicationHelper
  def each_import_feed
    feeds = config['import_feeds']
    if feeds.kind_of? Hash
      feeds.keys.sort.each {|name| yield name, feeds[name] }
    end
  end

  def render_feeds
    output = ''

    each_import_feed do |feed_name, options|
      case options
      when Hash
        url = options['url']
        limit = (options['limit'] or limit_page)
      when String
        url = options
        limit = limit_page
      else
        next   # ignore malformed config
      end
      next unless url.kind_of? String

      feed = persistent_cache[ '/import_feeds/' + url ]   # first slash to avoid clashes with site_name

      if feed.kind_of? Array and feed.size > 0
        output << %{<div class="feed"><div class="feed-name">#{feed_name}</div>\n<ul>}
        feed[0, limit].each do |item|
          output << %{<li><a href="#{item['link']}" title="#{format_date(item['date'])}">#{item['title']}</a></li>\n}
        end
        output << %{</ul></div>\n}
      end
    end

    output
  end
end
