
# Copyright (C) 2003 Laurent Sansonetti <lrz@gnome.org>
#
# This file is part of Ruby/GStreamer.
# 
# Ruby/GStreamer is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# Ruby/GStreamer is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with Ruby/GStreamer; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

require 'tests/misc'

class TC_elements < Test::Unit::TestCase
    def test_element
        assert_instance_of(Gst::Element, e  = Gst::ElementFactory.make("fakesrc"))
        assert_instance_of(Gst::Element, e2 = Gst::ElementFactory.make("fakesrc", "plok"))
        e.test(self); e2.test(self)
        # Test states 
        valid_codes = [ 
            Gst::Element::STATE_CHANGE_ASYNC,
            Gst::Element::STATE_CHANGE_FAILURE,
            Gst::Element::STATE_CHANGE_NO_PREROLL,
            Gst::Element::STATE_CHANGE_SUCCESS,
        ] 
    end

    def test_elementfactory
        assert_instance_of(Gst::ElementFactory, f = Gst::ElementFactory.find("fakesrc"))
        f.test(self)
        # Test unique auto-generated element names
        a = Array.new
        10.times { a.push(Gst::ElementFactory.make("fakesrc")) }
        a.each { |e| assert_instance_of(Gst::Element, e) }
        assert_nil a.collect { |e| e.name }.uniq! 
    end
    def test_pipeline
        assert_instance_of(Gst::Pipeline, p = Gst::Pipeline.new("my pipeline"))
        # Test the pipeline as a Gst::Bin (Gst::Pipeline does not have a #test method)
        p.test(self)
        # Test unique auto-generated pipelines names
        a = Array.new
        10.times { a.push(Gst::Pipeline.new) }
        a.each { |e| assert_instance_of(Gst::Pipeline, e) }
        assert_nil a.collect { |e| e.name }.uniq! 
    end
    def test_bin
        assert_instance_of(Gst::Bin, b = Gst::Bin.new("my bin"))
        b.test(self)
        # Test signals
        #b.signal_connect("element-added") { puts "element added!" }
        # Test container
        10.times { |i| b.add(Gst::ElementFactory.make("fakesrc")) }
        i = 0
        b.each_element { |e| assert_instance_of(Gst::Element, e); i += 1 }
        assert_equal(i, 10)
        b.each_element { |e| assert_instance_of(Gst::Element, e) }

        # Test unique auto-generated bins names
        a = Array.new
        10.times { a.push(Gst::Bin.new) }
        a.each { |e| assert_instance_of(Gst::Bin, e) }
        assert_nil a.collect { |e| e.name }.uniq! 
    end
    def test_bin2
        assert_instance_of(Gst::Bin, b = Gst::Bin.new)
        assert_instance_of(Gst::Element, e1 = Gst::ElementFactory.make("fakesrc", "fake1")) 
        assert_instance_of(Gst::Element, e2 = Gst::ElementFactory.make("fakesrc", "fake2")) 
        b.add(e1, e2)
        [ "fake1", "fake2" ].each do |x|
            assert_instance_of(Gst::Element, b.get_by_name(x))
            assert_instance_of(Gst::Element, b.get_by_name_recurse_up(x))
        end
    end
    def __create_bin(name)
        b = Gst::Pipeline.new(name)
        e1 = Gst::ElementFactory.make("fakesrc") 
        e2 = Gst::ElementFactory.make("fakesink")
        e1 >> e2
        b.add(e1, e2)
        b
    end
end

