#include "rbgst.h"

static VALUE
rb_gst_message_get_type(VALUE self) {
  return GENUM2RVAL (
           GST_MESSAGE_TYPE(RGST_MESSAGE(self)), GST_TYPE_MESSAGE_TYPE);
}

static VALUE
rb_gst_message_get_type_name(VALUE self) {
  return CSTR2RVAL (
           GST_MESSAGE_TYPE_NAME(RGST_MESSAGE(self)));
}

static VALUE
rb_gst_message_get_source(VALUE self) {
  return GOBJ2RVAL(GST_MESSAGE_SRC(RGST_MESSAGE(self)));
}

static VALUE
rb_gst_message_structure(VALUE self) {
  return RGST_STRUCTURE_NEW(RGST_MESSAGE(self)->structure);
}

static VALUE
rb_gst_message_parse_error(VALUE self) {
  gchar *debug;
  GError *error;

  gst_message_parse_error(RGST_MESSAGE(self), &error, &debug);
  return rb_ary_new3(2, rbgerr_gerror2exception(error), CSTR2RVAL2(debug));
}

static VALUE
rb_gst_message_parse_state_changed(VALUE self) {
  GstState old;
  GstState new;
  GstState pending;

  gst_message_parse_state_changed(RGST_MESSAGE(self), &old, &new, &pending);
  return rb_ary_new3(3, 
                      GENUM2RVAL(old, GST_TYPE_STATE),
                      GENUM2RVAL(new, GST_TYPE_STATE),
                      GENUM2RVAL(pending, GST_TYPE_STATE));

}

static VALUE
rb_gst_message_parse_tag(VALUE self) {
  GstTagList *list;
  VALUE hash;

  gst_message_parse_tag(RGST_MESSAGE(self), &list);
  hash = RGST_STRUCTURE_NEW(list);
  gst_tag_list_free(list);

  return hash;
}

void
Init_gst_message(void) {
  VALUE c = G_DEF_CLASS(GST_TYPE_MESSAGE, "Message", mGst);

  G_DEF_CLASS(GST_TYPE_MESSAGE_TYPE, "MessageType", c);
  G_DEF_CONSTANTS(c, GST_TYPE_MESSAGE_TYPE, "GST_MESSAGE_");

  rb_define_method(c, "get_type", rb_gst_message_get_type, 0);
  rb_define_method(c, "get_type_name", rb_gst_message_get_type_name, 0);
  rb_define_method(c, "source", rb_gst_message_get_source, 0);
  rb_define_method(c, "structure", rb_gst_message_structure, 0);
  rb_define_method(c, "parse_error", rb_gst_message_parse_error, 0);
  rb_define_method(c, "parse_state_changed", 
      rb_gst_message_parse_state_changed, 0);
  rb_define_method(c, "parse_tag", 
      rb_gst_message_parse_tag, 0);
}
