
require 'gst0.10'

def usage
    puts "Usage: #{__FILE__} mp3-file"
    exit
end

def main
    usage if ARGV.length != 1 
    file = ARGV[0]
    mainloop = GLib::MainLoop.new(GLib::MainContext.default, true);

    # Create a pipeline to hold the elements
    pipeline = Gst::Pipeline.new("my_pipeline")
    
    # Create a disk reader
    filesrc = Gst::ElementFactory.make("filesrc", "my_disk_source")
    filesrc.location = file 

    # Now it's time to get the MP3 decoder
    decoder = Gst::ElementFactory.make("mad", "my_decoder")

    convertor = Gst::ElementFactory.make("audioconvert", "convertor")

    # And an audio sink
    audiosink = Gst::ElementFactory.make("autoaudiosink", "my_audio_player")

    # Add objects to the main pipeline
    pipeline.add(filesrc, decoder, convertor, audiosink)

    pipeline.bus.add_watch { | message |
      case message.get_type
         when Gst::Message::MessageType::ERROR then
           print "An error occured: #{message.parse_error[0]}\n"
           mainloop.quit
         when Gst::Message::MessageType::EOS then
           mainloop.quit
      end
      true;
    }

    # Link disk source => decoder => audio player 
    filesrc >> decoder >> convertor >> audiosink

    # Start playing
    pipeline.play

    begin 
      mainloop.run
    rescue Interrupt 
    ensure
      pipeline.stop
    end
end

Gst.init
main
