require 'test-unit-ext'

class TestOmission < Test::Unit::TestCase
  class TestCase < Test::Unit::TestCase
    class << self
      def suite
        Test::Unit::TestSuite.new(name)
      end
    end

    def test_omit
      omit("1st omit")
      omit("2nd omit. Not reached here.")
    end

    def test_omit_with_failure_in_block
      omit("Wait a minute") do
        raise "Not implemented yet"
      end
      assert(true, "Not reached here.")
    end

    def test_omit_with_no_failure_in_block
      omit("Wait a minute") do
        "Nothing raised"
      end
      assert(true, "Reached here.")
    end
  end

  def test_omit
    result = run_test("test_omit")
    assert_equal("1 tests, 0 assertions, 0 failures, 0 errors, 0 pendings, " \
                 "1 omissions, 0 notifications",
                 result.to_s)
    assert_equal(["1st omit"],
                 result.omissions.collect {|omission| omission.message})
  end

  def test_omit_with_failure_in_block
    result = run_test("test_omit_with_failure_in_block")
    assert_equal("1 tests, 0 assertions, 0 failures, 0 errors, 0 pendings, " \
                 "1 omissions, 0 notifications",
                 result.to_s)
    assert_equal(["Wait a minute"],
                 result.omissions.collect {|omission| omission.message})
  end

  def test_omit_with_no_failure_in_block
    result = run_test("test_omit_with_no_failure_in_block")
    assert_equal("1 tests, 1 assertions, 1 failures, 0 errors, 0 pendings, " \
                 "0 omissions, 0 notifications",
                 result.to_s)
    assert_equal(["Omission block should not be passed: Wait a minute."],
                 result.failures.collect {|failure| failure.message})
  end

  private
  def run_test(name)
    result = Test::Unit::TestResult.new
    TestCase.new(name).run(result) {}
    result
  end
end
