require 'test-unit-ext'

class TestNotification < Test::Unit::TestCase
  class TestCase < Test::Unit::TestCase
    class << self
      def suite
        Test::Unit::TestSuite.new(name)
      end
    end

    def test_notify
      notify("1st notify")
      notify("2nd notify. Reach here.")
    end
  end

  def test_notify
    result = run_test("test_notify")
    assert_equal("1 tests, 0 assertions, 0 failures, 0 errors, 0 pendings, " \
                 "0 omissions, 2 notifications",
                 result.to_s)
    assert_equal(["1st notify", "2nd notify. Reach here."],
                 result.notifications.collect {|n| n.message})
  end

  private
  def run_test(name)
    result = Test::Unit::TestResult.new
    TestCase.new(name).run(result) {}
    result
  end
end
