# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.0.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Logic
  module Models
    #
    # Model object.
    # 
    #
    class AS2ValidationSettings

      include MsRestAzure

      # @return [Boolean] The value indicating whether to override incoming
      # message properties with those in agreement.
      attr_accessor :override_message_properties

      # @return [Boolean] The value indicating whether the message has to be
      # encrypted.
      attr_accessor :encrypt_message

      # @return [Boolean] The value indicating whether the message has to be
      # signed.
      attr_accessor :sign_message

      # @return [Boolean] The value indicating whether the message has to be
      # compressed.
      attr_accessor :compress_message

      # @return [Boolean] The value indicating whether to check for duplicate
      # message.
      attr_accessor :check_duplicate_message

      # @return [Integer] The number of days to look back for duplicate
      # interchange.
      attr_accessor :interchange_duplicates_validity_days

      # @return [Boolean] The value indicating whether to check for certificate
      # revocation list on send.
      attr_accessor :check_certificate_revocation_list_on_send

      # @return [Boolean] The value indicating whether to check for certificate
      # revocation list on receive.
      attr_accessor :check_certificate_revocation_list_on_receive

      # @return [EncryptionAlgorithm] The encryption algorithm. Possible values
      # include: 'NotSpecified', 'None', 'DES3', 'RC2', 'AES128', 'AES192',
      # 'AES256'
      attr_accessor :encryption_algorithm


      #
      # Mapper for AS2ValidationSettings class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'AS2ValidationSettings',
          type: {
            name: 'Composite',
            class_name: 'AS2ValidationSettings',
            model_properties: {
              override_message_properties: {
                required: false,
                serialized_name: 'overrideMessageProperties',
                type: {
                  name: 'Boolean'
                }
              },
              encrypt_message: {
                required: false,
                serialized_name: 'encryptMessage',
                type: {
                  name: 'Boolean'
                }
              },
              sign_message: {
                required: false,
                serialized_name: 'signMessage',
                type: {
                  name: 'Boolean'
                }
              },
              compress_message: {
                required: false,
                serialized_name: 'compressMessage',
                type: {
                  name: 'Boolean'
                }
              },
              check_duplicate_message: {
                required: false,
                serialized_name: 'checkDuplicateMessage',
                type: {
                  name: 'Boolean'
                }
              },
              interchange_duplicates_validity_days: {
                required: false,
                serialized_name: 'interchangeDuplicatesValidityDays',
                type: {
                  name: 'Number'
                }
              },
              check_certificate_revocation_list_on_send: {
                required: false,
                serialized_name: 'checkCertificateRevocationListOnSend',
                type: {
                  name: 'Boolean'
                }
              },
              check_certificate_revocation_list_on_receive: {
                required: false,
                serialized_name: 'checkCertificateRevocationListOnReceive',
                type: {
                  name: 'Boolean'
                }
              },
              encryption_algorithm: {
                required: false,
                serialized_name: 'encryptionAlgorithm',
                type: {
                  name: 'Enum',
                  module: 'EncryptionAlgorithm'
                }
              }
            }
          }
        }
      end
    end
  end
end
