/*
 * $Id: rstat_proc.c,v 1.7 2002/01/14 12:24:48 andik Exp $
 *
 *  rpc.rstatd version 3.07 rpc remote statistics daemon.
 *  Copyright (C) 1995  Adam Migus, Memorial University of Newfoundland
 *	(MUN)
 *  Copyright (C) 2001 Andreas Klingler, University of Erlangen-Nuernberg
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  If you make modifications to the source, I would be happy to have
 *  them to include in future releases.  Feel free to send them to:
 *    Adam Migus	      				
 *	  amigus@cs.mun.ca 
 *    amigus@ucs.mun.ca   
 *
 *	Original Sun version by:
 * Copyright (c) 1984 by Sun Microsystems, Inc.
 **************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h>
#include <limits.h>
#include <rpc/rpc.h>
#include <sys/socket.h>
#ifndef __GLIBC__
#include <nlist.h>
#endif
#include <syslog.h>
#include <sys/errno.h>
#include <sys/param.h>
#include <net/if.h>
#include <utmp.h>
#include "rstat.h"

#define LOADAVG "/proc/loadavg"
#define STAT "/proc/stat"
#define UPTIME "/proc/uptime"
#define NETSTUFF "/proc/net/dev"
#ifndef NET_IFACE
#define NET_IFACE "eth0"
#endif
#ifndef _PATH_UTMP
#define _PATH_UTMP "/var/adm/utmp"
#endif

#define BUFLEN 2048


static char * id = "@(#) $Id: rstat_proc.c,v 1.7 2002/01/14 12:24:48 andik Exp $ $Revision: 1.7 $";

int stats_service(void);
static void get_stats(struct statsusers *);
int l_users(void);
int l_uptime(void);


union {
  struct stats s1;
  struct statsswtch s2;  
  struct statstime s3;
  struct statsvar s4;
  struct statsusers s5;
} stats_all;

extern int inetd_connect;
extern int ninterfaces;
extern char **interfaces;

void test_connect()
{
	if(inetd_connect != 0) {
		exit(0);
	}
}

statsusers *rstatproc_stats_5_svc(arg, rqstp)
void *arg;
struct svc_req *rqstp;
{
	get_stats(&stats_all.s5);
	return &stats_all.s5;
}

statsvar *rstatproc_stats_4_svc(arg, rqstp)
void *arg;
struct svc_req *rqstp;
{
	get_stats(&stats_all.s5);
	return &stats_all.s4;
}

statstime *rstatproc_stats_3_svc(arg, rqstp)
	void *arg;
	struct svc_req *rqstp;
{
	get_stats(&stats_all.s5);
	/* can return s3, since there is only the last member missing */
	return &stats_all.s3;
}

statsswtch *rstatproc_stats_2_svc(arg, rqstp)
	void *arg;
	struct svc_req *rqstp;
{
	get_stats(&stats_all.s5);

	/* put opackets from statsusers in the right position for statsswtch 
	   this is ugly 'union' hacking */
	stats_all.s2.if_opackets = stats_all.s5.if_opackets;
	return (&stats_all.s2);
}

stats *rstatproc_stats_1_svc(arg, rqstp)
	void *arg;
	struct svc_req *rqstp;
{
	get_stats(&stats_all.s5);

	/* put opackets from stats in the right position for statsswtch 
	   this is ugly 'union' hacking */
	stats_all.s1.if_opackets = stats_all.s5.if_opackets;

	return (&stats_all.s1);
}

u_int *rstatproc_havedisk_5_svc(arg, rqstp)
	void *arg;
	struct svc_req *rqstp;
{
	static u_int have;

	get_stats(&stats_all.s5);
	have = havedisk(&stats_all.s5);
	return (&have);
}

u_int *rstatproc_havedisk_4_svc(arg, rqstp)
	void *arg;
	struct svc_req *rqstp;
{
	return (rstatproc_havedisk_5_svc(arg, rqstp));
}

u_int *rstatproc_havedisk_3_svc(arg, rqstp)
	void *arg;
	struct svc_req *rqstp;
{
	return (rstatproc_havedisk_5_svc(arg, rqstp));
}

u_int *rstatproc_havedisk_2_svc(arg, rqstp)
	void *arg;
	struct svc_req *rqstp;
{
	return (rstatproc_havedisk_5_svc(arg, rqstp));
}

u_int *rstatproc_havedisk_1_svc(arg, rqstp)
	void *arg;
	struct svc_req *rqstp;
{
	return (rstatproc_havedisk_5_svc(arg, rqstp));
}

void wrong_format(char *s)
{
  syslog(LOG_ERR, "incompatible to /proc. Could not read %s data", s);
  exit(1);
}

static void get_stats(struct statsusers *stats)
{
  /* statsusers contains all information, so we use it to collect the data */

	FILE *fp;
	char buf[BUFLEN];
	char *bufp;
	double avrun[3];

	int diskno = 0;
	int expected_statvalues = 6;

	char *iface;
	int if_ipackets, if_ierrors, if_opackets, if_oerrors, if_collisions;
	int i;
	int found_interface;

	if_ipackets = if_ierrors = if_opackets = if_oerrors = if_collisions = 0;

	memset(stats, 0, sizeof(struct statsusers));

	if((fp = fopen(LOADAVG, "r")) == NULL) {
		wrong_format("/proc/loadavg");
	}
	if(!fscanf(fp , "%lf %lf %lf", &avrun[0], &avrun[1], &avrun[2])) wrong_format("loadavg");
	stats->avenrun[0] = avrun[0] * FSCALE;
	stats->avenrun[1] = avrun[1] * FSCALE;
	stats->avenrun[2] = avrun[2] * FSCALE;
	fclose(fp);


	if((fp = fopen(STAT, "r")) == NULL) {
		wrong_format("/proc/stat");
	}

	while (fgets(buf, sizeof(buf), fp))
	  {
	    if (strncmp(buf, "cpu ", 4) == 0) {
	      if (sscanf(buf, "cpu  %u %u %u %u\n",&stats->cp_time[0],
			 &stats->cp_time[1],&stats->cp_time[2],
			 &stats->cp_time[3]) != 4)
		wrong_format("cpu");
	    }

	    if (strncmp(buf, "disk ", 5) == 0) {
	      /* seems we have a pre 2.4 kernel */
	      if (sscanf(buf, "disk %u %u %u %u\n",&stats->dk_xfer[0],
			 &stats->dk_xfer[1],&stats->dk_xfer[2],
			 &stats->dk_xfer[3]) != 4)
		  wrong_format(buf);
	    }


	    if (strncmp(buf, "disk_io:", 8) == 0) {
	      /* with a 2.4 kernel each aktive disk gets a separate line in /proc/stat */
	      /* we can just take the data from 4 (DK_NDRIVE) of them */
	      if (diskno < DK_NDRIVE) {
		/* use the ':' as marker to scan until we reach the transfer counter */
		/* expected line format is "something:something:(counter" */
		if (sscanf(buf,"%*[^:]:%*[^:]:(%u", &stats->dk_xfer[diskno]) != 1)
			wrong_format(buf);
		diskno++;
	      }	 
	    }

	    if (strncmp(buf, "page ", 5) == 0)
	      if (sscanf(buf, "page %u %u\n", &stats->v_pgpgin, &stats->v_pgpgout) != 2)
		wrong_format("pageing");

	    if (strncmp(buf, "swap ", 5) == 0)
	      if (sscanf(buf, "swap %u %u\n", &stats->v_pswpin, &stats->v_pswpout) != 2)
		wrong_format("swap");

	    if (strncmp(buf, "intr ", 5) == 0)
	      if (sscanf(buf, "intr %u ", &stats->v_intr) != 1)
		  wrong_format("intr");

	    if (strncmp(buf, "ctxt ", 5) == 0)
	      if (sscanf(buf, "ctxt %u\n", &stats->v_swtch) != 1)
		wrong_format("ctxt");
	  } /* while */
	fclose(fp);


	if ((fp = fopen(NETSTUFF,"r")) == NULL) {
		wrong_format(NETSTUFF);
	}


	/* gobble up the two header lines in /proc/net/dev */
	fgets(buf, sizeof(buf), fp);
	fgets(buf, sizeof(buf), fp);

	/* add up data from all interfaces besides the loopback interface.
	   If interfaces where specified on the commandline take only these. */
	while (fgets(buf, sizeof(buf), fp))
	  {
	    bufp = buf;

	    while (*bufp == ' ') *bufp++; /* find beginning of interface name */
	    if (*bufp == '\0') continue;  /* skip empty line */
	    iface = bufp;

	    /* search for the end of the interface name */
	    while (*bufp != ':' && *bufp != '\0') bufp++;
	    if (*bufp == '\0')
	      {
		/* no ':', no interface name?! */
		wrong_format("interface name");
	      }
	    *bufp = '\0'; /* mark the end of the interface name (Access is via iface) */

	    bufp++;

	    if (sscanf(bufp,"%*u %u %u %*u %*u %*u %*u %*u %*u %u %u %*u %*u %u %*u %*u\n",
		       &if_ipackets, &if_ierrors,
		       &if_opackets, &if_oerrors,
		       &if_collisions) != 5)
	      wrong_format(iface);

	    found_interface = 0;
	    for (i=0; i < ninterfaces; i++) {
	      if (strcmp(iface, interfaces[i]) == 0) 
		{
		  found_interface = 1;
		  break;
		}
	    }
	    if ((ninterfaces == 0 && strcmp(iface, "lo") != 0) || found_interface)
	      {
		stats->if_ipackets += if_ipackets;
		stats->if_ierrors  += if_ierrors;
		stats->if_opackets += if_opackets;
		stats->if_oerrors += if_oerrors;
		stats->if_collisions += if_collisions;
	      }
	  }

	fclose(fp);

	stats->users = l_users();

	gettimeofday((struct timeval *)
				&stats->curtime,(struct timezone *) 0);
	stats->boottime.tv_sec = (stats->curtime.tv_sec - l_uptime());
	if(inetd_connect) alarm(1); 
}

int havedisk(struct statsusers *stats)
{

	int i, cnt;

	cnt = 0;
	for (i=0; i < DK_NDRIVE; i++)
		cnt += stats->dk_xfer[i];
	return (cnt != 0);
}

int l_uptime()
{
	int fd;
	double up_secs, idle_secs;
	char buf[BUFSIZ];

	if((fd = open(UPTIME,O_RDONLY)) < 0) {
		wrong_format(UPTIME);
	}
	if((read(fd,(char *)&buf,sizeof(buf))) < 0) {
		wrong_format("/proc/uptime content");
	}
	(void)close(fd);
	if(sscanf(buf,"%lf %lf",&up_secs,&idle_secs) < 2) {
		wrong_format("/proc/uptime time");
	}
	return((unsigned int)up_secs);
}

int l_users()
{
  int ufd, users = 0;
  static char buf[3];
  struct utmp u;

    if ((ufd = open(_PATH_UTMP, O_RDONLY)) < 0) {
		wrong_format(_PATH_UTMP);
	}
    while (read(ufd, (char *) &u, sizeof(u)) == sizeof(u)) {
        if(u.ut_type==7 && u.ut_name[0] != '\0') {
            users++;
        }
    }
	(void)close(ufd);
	sprintf(buf,"%i",users);
	return(users);
}

void rstat_service(rqstp, transp)
	struct svc_req *rqstp;
	SVCXPRT *transp;
{
	union {
		int fill;
	} argument;
	char *result;
	xdrproc_t xdr_argument, xdr_result;
	char *(*local) __P((void *, struct svc_req *));
	void *v;

	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void)svc_sendreply(transp, (xdrproc_t) xdr_void, (char *)NULL);
      if(inetd_connect) exit(0);

	case RSTATPROC_STATS:
		xdr_argument = (xdrproc_t)xdr_void;
		xdr_result = (xdrproc_t)xdr_statsusers;
      switch (rqstp->rq_vers) {
          case RSTATVERS_ORIG:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_stats_1_svc;
               break;
          case RSTATVERS_SWTCH:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_stats_2_svc;
               break;
          case RSTATVERS_TIME:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_stats_3_svc;
               break;
          case RSTATVERS_VAR:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_stats_4_svc;
               break;
          case RSTATVERS_USERS:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_stats_5_svc;
               break;
          default:
               svcerr_progvers(transp, RSTATVERS_ORIG, RSTATVERS_USERS);
               if(inetd_connect) exit(0);
      }
		break;

	case RSTATPROC_HAVEDISK:
		xdr_argument = (xdrproc_t)xdr_void;
		xdr_result = (xdrproc_t)xdr_u_int;
      switch (rqstp->rq_vers) {
          case RSTATVERS_ORIG:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_havedisk_1_svc;
               break;
          case RSTATVERS_SWTCH:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_havedisk_2_svc;
               break;
          case RSTATVERS_TIME:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_havedisk_3_svc;
               break;
          case RSTATVERS_VAR:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_stats_4_svc;
               break;
          case RSTATVERS_USERS:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_havedisk_5_svc;
               break;
          default:
               svcerr_progvers(transp, RSTATVERS_ORIG, RSTATVERS_USERS);
               if(inetd_connect) exit(0);
      }
		break;
	default:
		svcerr_noproc(transp);
      if(inetd_connect) exit(0);
	}
	bzero((char *)&argument, sizeof(argument));
	if (!svc_getargs(transp, xdr_argument, (caddr_t)&argument)) {
		svcerr_decode(transp);
      if(inetd_connect) exit(0);
	}
	result = (*local)(&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, xdr_result, result)) {
		svcerr_systemerr(transp);
	}
	if (!svc_freeargs(transp, xdr_argument, (caddr_t)&argument)) {
		syslog(LOG_ERR, "unable to free arguments\n");
		exit(1);
	}
}
