// -*-objc-*-

#import "ArticleView.h"


@implementation ArticleView : NSView
{
  RSSArticle* article;
}

-  init
{
  self = RELEASE(self);
  return self;
}

-  initWithFrame: (NSFrame) frame
      andArticle: (RSSArticle*) aArticle;
{
  self = [super init];
  [self article: aArticle];
}


-initPanel
{
  NSTextField* headlineField;
  NSTextStorage* descStorage;
  NSLayoutManager* descLMan;
  NSTextContainer* descTextContainer;
  NSTextView* descriptionField;
  NSRect r;
  id oldArticleView;
  float width, height;
  
  oldArticleView = articleView;
  // ARTICLE SCROLLVIEW
  articleView = [[NSScrollView alloc]
		  initWithFrame: NSMakeRect(0,0,300,300)];
  [articleView setHasVerticalScroller: YES];
  [articleView setHasHorizontalScroller: NO];
  [articleView setBorderType: NSBezelBorder];
  
  // build headline field
  headlineField = AUTORELEASE([NSTextField new]);
  [headlineField setStringValue: [article headline]];
  [headlineField setDrawsBackground: NO];
  [headlineField setEditable: NO];
  [headlineField setSelectable: NO];
  [headlineField setBezeled: NO];
  [headlineField setBordered: NO];
  [headlineField setAlignment: NSLeftTextAlignment];
  
  // build description field
  descStorage = [[NSTextStorage alloc]
		  initWithString: [article description]];
  
  descLMan = [[NSLayoutManager alloc] init];
  [descStorage addLayoutManager: descLMan];
  RELEASE(descLMan);
  
  descTextContainer = [[NSTextContainer alloc] init];
  [descLMan addTextContainer: descTextContainer];
  
  descriptionField = [[NSTextView alloc] init];
  [descriptionField setTextContainer: descTextContainer];
  [descriptionField setDrawsBackground: NO];
  [descriptionField setEditable: YES];
  [descriptionField setSelectable: YES];
  [descriptionField setAlignment: NSLeftTextAlignment];
  [descriptionField setBackgroundColor: [NSColor whiteColor]];
  [descriptionField setDrawsBackground: YES];
  //[descriptionField setTextContainerInset: 10.0];
  
  r = [oldArticleView frame];
  width   = r.size.width;
  height  = r.size.height;
  
  // set frame for headline field
  r.origin.x = 5;
  r.origin.y = height - 25;
  r.size.width = width - 30;
  r.size.height = 13;
  [headlineField setFrame: r];
  
  // set frame for description field
  r.origin.x = 5;
  r.origin.y = 5;
  r.size.width = width - 30;
  r.size.height = height - (5+5+13+10);
  [descriptionField setFrame: r];
  r.size.width  -=10;
  r.size.height -=10;
  [descTextContainer setContainerSize: NSMakeSize(r.size.width, FLT_MAX)];
  RELEASE(descTextContainer);
  //[headlineField setFrameSize: NSMakeSize(r.size.width, r.size.height)];
  
  // ALIGNMENTS
  //[articleView setAutoresizesSubviews: YES];
  [[articleView documentView] setAutoresizesSubviews: YES];
  
  // ALIGNMENT OF HEADLINE
  [headlineField
    setAutoresizingMask: (NSViewWidthSizable)];
  
  // ALIGNMENT OF DESCRIPTION
  [descriptionField setVerticallyResizable: YES];
  [descriptionField setHorizontallyResizable: YES];
  [descriptionField
    setAutoresizingMask: (NSViewWidthSizable|NSViewHeightSizable)];
  //[descriptionField
  //  setMinSize: NSMakeSize(0.0, 0.0)];
  //[descriptionField
  //  setMaxSize: NSMakeSize(FLT_MAX, FLT_MAX)];
  
  
  
  // PUTTING THINGS TOGETHER
  NSLog(@"documentView: %@", [[articleView documentView] description]);
  NSLog(@"contentView:  %@", [[articleView contentView] description]);
  [[articleView documentView] addSubview: headlineField];
  [[articleView documentView] addSubview: descriptionField];
  
  [articleView setFrame: [oldArticleView frame]];
  [splitView replaceSubview: oldArticleView with: articleView];
  RELEASE(oldArticleView);
  
  // RELEASES
  RELEASE(descriptionField);
}

-drawRect: (NSRect) rect;

-(void) article: (RSSArticle*) aArticle
{
  RELEASE(article);
  article = aArticle;
  RETAIN(aArticle);
}

// overridden from NSView
- (BOOL)isFlipped
{
  return NO;
}

/*
- (void)rotateByAngle:(float)angle;
- (void)scaleUnitSquareToSize:(NSSize)newUnitSize;
- (void)setBoundsOrigin:(NSPoint)aPoint;
- (void)setBoundsRotation:(float)angle;
- (void)setBoundsSize:(NSSize)aSize;
- (void)setFrameSize:(NSSize)aSize;
- (void)setFrameOrigin:(NSPoint)aPoint;
- (void)setFrameRotation:(float)angle;
- (void)translateOriginToPoint:(NSPoint)aPoint;
- (void)viewBoundsChanged:(NSNotification*)aNotification;
- (void)viewFrameChanged:(NSNotification*)aNotification;
*/

@end

