
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>


RNode *
rnode_child     (RNode *node, RBuf *basename, 
                 RBuf **err)
{
    RNode *curnode;
    RNode *found_node = NULL;

    RNODE_FOREACH (node, curnode) {

        if (rbuf_equal_rbuf (curnode->type, basename)) {
            found_node = curnode;
            RNODE_FOREACH_BREAK;
        }

    } RNODE_FOREACH_CLOSE;

    return (found_node);
}

RNode *
rnode_child_attrib     (RNode *node, RBuf *type, RBuf *attrib, RBuf *value,
                        RBuf **err)
{
    RNode *curnode;
    RNode *found_node = NULL;

    RNODE_FOREACH (node, curnode) {

        if (rbuf_equal_rbuf (curnode->type, type)) {
            RBuf *real_value;
            real_value = rnode_attrib_get (curnode, attrib, err);
            if (!*err) {
                if (rbuf_equal_rbuf (real_value, value)) {
                    found_node = curnode;
                    RNODE_FOREACH_BREAK;
                }
            } else {
                rbuf_free (*err);
                *err = NULL;
            }
        }

    } RNODE_FOREACH_CLOSE;

    return (found_node);
}

RNode *
rnode_parent    (RNode *node, RBuf *basename, 
                 RBuf **err)
{
    RNode *curnode;

    curnode = node->parent;

    while (curnode) {
        if (rbuf_equal_rbuf (curnode->type, basename)) {
            return (curnode);
        }

        curnode = curnode->parent;
    }

    return (NULL);
}



