
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#ifndef __RNODE_ATTRIB_H__
#define __RNODE_ATTRIB_H__

/* Length */
unsigned int
rnode_attrib_length     (RNode *node, RBuf *attrib,
                         RBuf **err);


/* Get methods */
RBuf *
rnode_attrib_get        (RNode *node, RBuf *attrib,
                         RBuf **err);

RBuf *
rnode_attrib_get_chunk  (RNode *node, RBuf *attrib,
                         unsigned int offset, unsigned int count,
                         RBuf **err);


/* Set methods */
void
rnode_attrib_set        (RNode *node, RBuf *attrib, RBuf *value,
                         RBuf **err);

void
rnode_attrib_append     (RNode *node, RBuf *attrib, RBuf *data,
                         RBuf **err);

void
rnode_attrib_insert     (RNode *node, RBuf *attrib,
                         unsigned int offset, RBuf *data,
                         RBuf **err);

void
rnode_attrib_delete     (RNode *node, RBuf *attrib,
                         unsigned int offset, unsigned int count,
                         RBuf **err);


/* Implementation Details */


#endif /* __RNODE_ATTRIB_H__ */


