
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#ifndef __RFLAG_H__
#define __RFLAG_H__

/* This is just a simple set of macros for setting/clearing/checking flags as
 * found in a lot of structures.  In order for this to work, the structure must
 * have a 'flags' member, which has an enumerated list of bit flags associated
 * with it. */

#define RFLAG_FLAGS(strct)		    (strct->flags)
#define RFLAG_SET(strct,flagset)	    do { (RFLAG_FLAGS (strct) |= (flagset)); } while (0)
#define RFLAG_UNSET(strct,flagset)	    do { (RFLAG_FLAGS (strct) &= ~(flagset)); } while (0)
#define RFLAG_ISSET(strct,flagset)	    ((RFLAG_FLAGS (strct) & flagset) != 0)
#define RFLAG_ONLYSET(strct,flagset)	    ((RFLAG_FLAGS (strct) & flagset) == flagset)

#endif /* __RFLAG_H__ */



