/* -*- mode: C; c-basic-offset: 4  -*- */ 

/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#ifndef __RBUF_SPRINTF_H__
#define __RBUF_SPRINTF_H__


/* These 2 functions are very much like the snprintf() style functions,
 * except of course, a length argument is not necessary because we just
 * grow the buffer as big as is required to fit the string.
 *
 * Note that these functions essentially append the new string to the
 * existing rbuf.  This can be useful in some situations I think,
 * so I didn't change the behaviour.  However, it requires that you
 * use rbuf_truncate (buf, 0); first if you want to have a newly
 * formated string */


#include <stdarg.h>

void
rbuf_sprintf (RBuf *buffer, const char *fmt, ...);

void
rbuf_append_sprintf (RBuf *buffer, const char *fmt, ...);

void
rbuf_append_vsprintf (RBuf *buffer, const char *format, va_list args);

RBuf *
rbuf_new_with_sprintf (const char *fmt, ...);


#endif	/* __RBUF_SPRINTF_H__ */


