# Makefile include to build configcint.h (aka $@)
$(CINTCONF): config/Makefile.$(ARCH) config/Makefile.comp $(CINTCONFMK)
	@-rm -f __configcint
	@echo '/* Generated by cint/Module.mk */' > __configcint
	@( case $(ARCH) in \
	  win32) \
	    if [ $(VC_MAJOR) -ge 14 ]; then \
	       echo '#define G__CFG_ARCH "msvc8"' >> __configcint; \
	    else \
	       echo '#define G__CFG_ARCH "msvc7"' >> __configcint; \
	    fi && \
	    echo '#define G__CFG_LDOUT "-out:"' >> __configcint && \
	    echo '#define G__CFG_LIBL "lib@imp@"' >> __configcint && \
	    echo '#define G__CFG_LIBEXT ".lib"' >> __configcint && \
	    echo '#define G__CFG_IMPLIBEXT ".lib"' >> __configcint && \
	    echo '#define G__CFG_MANGLEPATHS "cygpath -m "' >> __configcint && \
	    echo '#define G__CFG_PLATFORMO "v6_winnt"' >> __configcint && \
	    echo '#define G__CFG_AR "lib /OUT:"' >> __configcint ;;\
	  *) case $(ARCH) in \
	     macosx*) \
	       echo '#define G__CFG_ARCH "$(ARCH)"' >> __configcint && \
	       echo '#define G__CFG_IMPLIBEXT ".dylib"' >> __configcint ;; \
	     win32gcc) \
	       echo '#define G__CFG_ARCH "cygwin"' >> __configcint && \
	       echo '#define G__CFG_IMPLIBEXT ".a"' >> __configcint ;; \
	     *)	\
	       echo '#define G__CFG_ARCH "$(ARCH)"' >> __configcint && \
	       echo '#define G__CFG_IMPLIBEXT ".a"' >> __configcint ;; \
	    esac && \
	    echo '#define G__CFG_LDOUT "-o "' >> __configcint && \
	    echo '#define G__CFG_LIBL "-l@imp@"' >> __configcint && \
	    echo '#define G__CFG_LIBEXT ".a"' >> __configcint && \
	    echo '#define G__CFG_MANGLEPATHS "echo "' >> __configcint && \
	    echo '#define G__CFG_PLATFORMO ""' >> __configcint && \
	    echo '#define G__CFG_AR "ar qcs"' >> __configcint ;; \
	esac && \
	echo '#define G__CFG_CC "$(CC)"' >> __configcint && \
	echo '#define G__CFG_CFLAGS "$(CINTCFLAGS)"' >> __configcint && \
	echo '#define G__CFG_CMACROS "$(filter -D%,$(CINTCFLAGS))"' >> __configcint && \
	echo '#define G__CFG_COMP "-c "' >> __configcint && \
	echo '#define G__CFG_CPP "$(CPPPREP)"' >> __configcint && \
	echo '#define G__CFG_COUT "$(CXXOUT)"' >> __configcint && \
	echo '#define G__CFG_COUTEXE "$(CXXOUT)"' >> __configcint && \
	echo '#define G__CFG_INCP "-I"' >> __configcint && \
	echo '#define G__CFG_CXX "$(CXX)"' >> __configcint && \
	echo '#define G__CFG_CXXFLAGS "$(CINTCXXFLAGS)"' >> __configcint && \
	echo '#define G__CFG_CXXMACROS "$(filter -D%,$(CINTCXXFLAGS))"' >> __configcint && \
	echo '#define G__CFG_LD "$(LD)"' >> __configcint && \
	echo '#define G__CFG_LDFLAGS "$(LDFLAGS)"' >> __configcint && \
	echo '#define G__CFG_LIBP "-L"' >> __configcint && \
	echo '#define G__CFG_SOFLAGS "$(SOFLAGS)"' >> __configcint && \
	echo '#define G__CFG_SOOUT G__CFG_LDOUT' >> __configcint && \
	echo '#define G__CFG_OBJEXT ".o"' >> __configcint && \
	echo '#define G__CFG_EXEEXT "$(EXEEXT)"' >> __configcint && \
	echo '#define G__CFG_SOEXT ".$(SOEXT)"' >> __configcint && \
	echo '#define G__CFG_DEBUG "$(DEBUG)"' >> __configcint && \
	echo '#define G__CFG_DEFAULTLIBS "$(SYSLIBS)"' >> __configcint && \
	echo '#define G__CFG_DEFAULTLIBS "$(SYSLIBS)"' >> __configcint && \
	echo '#define G__CFG_CINTEXINCDIR "./"' >> __configcint && \
	echo '#define G__CFG_CINTEXLIBDIR "lib/"' >> __configcint && \
	echo '#define G__CFG_REFLEXINCDIR "./"' >> __configcint && \
	echo '#define G__CFG_REFLEXLIBDIR "lib"' >> __configcint && \
	echo '#define G__CFG_STREAMDIR "$(patsubst $(MODDIRS)/%strm.cxx,%,$(filter $(MODDIRS)/%strm.cxx, $(CINTS2)))"' >> __configcint && \
	echo '#define G__CFG_EXPLLINK "$(EXPLICITLINK)"' >> __configcint && \
	echo '#define G__CFG_BUILDREADLINE ""' >> __configcint && \
	echo '#define G__CFG_READLINELIBDIR ""' >> __configcint && \
	echo '#define G__CFG_READLINEINCDIR ""' >> __configcint && \
	echo '#define G__CFG_NEEDCURSES ""' >> __configcint && \
	echo '#define G__CFG_RM "rm -f"' >> __configcint && \
	echo '#define G__CFG_MV "mv -f"' >> __configcint && \
	echo '#define G__CFG_INPUTMODE "root"' >> __configcint && \
	echo '#define G__CFG_INPUTMODELOCK "off"' >> __configcint && \
	echo '#define G__CFG_MAKEIMPLIB ""' >> __configcint && \
	echo '#define G__CFG_CINTSYSDIR "$(PWD)"' >> __configcint && \
	echo '#define G__CFG_HAVE_CONFIG "1"' >> __configcint && \
	echo '#define CINTSYSDIR "$(PWD)"' >> __configcint && \
	echo '#define G__CFG_MAKEIMPLIB ""' >> __configcint && \
	echo '#define G__CFG_HAVE_CONFIG "1"' >> __configcint \
	)
	@(if [ -r $@ ]; then \
	   diff __configcint $@ > /dev/null; status=$$?; \
	   if [ "$$status" -ne 0 ]; then \
	      echo "Running cint/configcint.mk"; \
	      echo "Changing $@"; \
	      mv __configcint $@; \
	   else \
	      rm -f __configcint; \
	   fi \
	else \
	   echo "Running cint/configcint.mk"; \
	   echo "Making $@"; \
	   mv __configcint $@; \
	fi \
	)
