#* 
#* ------------------------------------------------------------------
#* Role PlayingDB V2.0 by Deepwoods Software
#* ------------------------------------------------------------------
#* RPGEdTreasure.tcl - Edit Treasure
#* Created by Robert Heller on Wed Aug 19 19:22:19 1998
#* ------------------------------------------------------------------
#* Modification History: 
#* $Log: RPGEdTreasure.tcl,v $
#* Revision 1.6  2000/02/11 00:30:25  heller
#* Change MacOS type code GIF => GIFf
#*
#* Revision 1.5  1999/07/13 20:30:42  heller
#* Minor doc fixes.
#*
#* Revision 1.4  1999/07/13 01:29:16  heller
#* Fix documentation: spelling, punctuation, etc.
#*
#* Revision 1.3  1999/01/01 15:16:45  heller
#* Density => Dexterity...
#*
#* Revision 1.2  1998/12/30 15:10:51  heller
#* Add in comments
#*
#* Revision 1.1  1998/12/28 02:53:00  heller
#* Initial revision
#*
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Role Playing DB -- A database package that creates and maintains
#* 		       a database of RPG characters, monsters, treasures,
#* 		       spells, and playing environments.
#* 
#*     Copyright (C) 1995,1998  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

#@Chapter:RPGEdTreasure.tcl -- Goodies to take home, if you can
#@Label:RPGEdTreasure.tcl
#$Id: RPGEdTreasure.tcl,v 1.6 2000/02/11 00:30:25 heller Rel $
# This file contains the code to create and edit treasure objects.  These
# objects describe items of value that the player characters are trying to
# get so that they can amass wealth (of various sorts).  Increased wealth
# means experience points gained and that means level advancement.

proc RPGEdTreasure {{filename {}}} {
# This procedure creates and edits treasure objects.
# <in> filename -- the file to edit.
# [index] RPGEdTreasure!procedure

  global tk_version
  set toplevel [GenerateToplevelName rpgEdTre]

  RPGToplevel .$toplevel {Role Playing V2 Treasure Editor} Treasure
  wm withdraw .$toplevel
  global .$toplevel
  upvar #0 .$toplevel data
  set data(filename) "$filename"
  set data(filetype) "treasure"
  if {[string length "$filename"] > 0} {
    set data(object) [Treasure]
    set object $data(object)
    if {[file readable "$filename"]} {
    set buffer [Record]
      if {[catch [list $buffer ReadRecord "$filename"] err]} {
        CloseWindow .$toplevel
        tkerror "Could not load $filename: $err"
        return
      }
      if {[string compare {*Treasure} "[lindex [$buffer ReturnRecord] 0]"] != 0} {
	CloseWindow .$toplevel
	tkerror "Not a Treasure file: $filename"
	return
      }
      $object UpdateFromRecord $buffer
      rename $buffer {}
    } else {
      CloseWindow .$toplevel
      tkerror "File does not exist or is not readable: $filename"
      return
    }
  } else {
    set data(object) [Treasure]
    set object $data(object)
    set data(dirty) 0
  }

# Construct a toplevel to display the treasue's picture
  toplevel .$toplevel.picture
  wm transient .$toplevel.picture .$toplevel
  wm title .$toplevel.picture {Picture of Treasure}
  wm protocol .$toplevel.picture WM_DELETE_WINDOW {NoOperation}
  label .$toplevel.picture.imname -text "[$object Image]" -relief sunken -border 2
  image create photo im$toplevel
#  puts stderr "*** \[image names\] = [image names] - 'im$toplevel'"
  label .$toplevel.picture.picture -image im$toplevel -relief ridge -border 2
  bind .$toplevel.picture <Destroy> [list catch "image delete im$toplevel"]
  pack .$toplevel.picture.imname -expand 1 -fill x
  pack .$toplevel.picture.picture -expand 1 -fill both
  set im "[$object Image]"
  if {[string length "$im"] > 0} { 
    if {[catch [list im$toplevel configure -format gif -file "$im"] err]} {
      tkerror "Could not set image file $im for image im$toplevel: $err"
    }
  }
  set data(image) "$im"

  # build widget .$toplevel.attributes
  frame .$toplevel.attributes \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .$toplevel.attributes.left
  frame .$toplevel.attributes.left

  # build widget .$toplevel.attributes.left.name
  frame .$toplevel.attributes.left.name

  # build widget .$toplevel.attributes.left.name.label50
  label .$toplevel.attributes.left.name.label50 \
    -text {Name:}

  # build widget .$toplevel.attributes.left.name.value
  entry .$toplevel.attributes.left.name.value \
    -width {0} \
    -textvariable ".[set toplevel](name)"
  bind .$toplevel.attributes.left.name.value <KeyPress> "SetDirty .$toplevel"

  # build widget .$toplevel.attributes.left.weight
  frame .$toplevel.attributes.left.weight

  # build widget .$toplevel.attributes.left.weight.label50
  label .$toplevel.attributes.left.weight.label50 \
    -text {Weight:}

  # build widget .$toplevel.attributes.left.weight.value
  entry .$toplevel.attributes.left.weight.value \
    -width {0} \
    -textvariable ".[set toplevel](weight)"
  bindtags .$toplevel.attributes.left.weight.value \
	[list .$toplevel.attributes.left.weight.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.left.aCAdj
  frame .$toplevel.attributes.left.aCAdj

  # build widget .$toplevel.attributes.left.aCAdj.label50
  label .$toplevel.attributes.left.aCAdj.label50 \
    -text {Armor Class +/-:}

  # build widget .$toplevel.attributes.left.aCAdj.value
  entry .$toplevel.attributes.left.aCAdj.value \
    -width {0} \
    -textvariable ".[set toplevel](aCAdj)"
  bindtags .$toplevel.attributes.left.aCAdj.value \
	[list .$toplevel.attributes.left.aCAdj.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.left.toHitAdj
  frame .$toplevel.attributes.left.toHitAdj

  # build widget .$toplevel.attributes.left.toHitAdj.label50
  label .$toplevel.attributes.left.toHitAdj.label50 \
    -text {To Hit +/-:}

  # build widget .$toplevel.attributes.left.toHitAdj.value
  entry .$toplevel.attributes.left.toHitAdj.value \
    -width {0} \
    -textvariable ".[set toplevel](toHitAdj)"
  bindtags .$toplevel.attributes.left.toHitAdj.value \
	[list .$toplevel.attributes.left.toHitAdj.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.left.damAdj
  frame .$toplevel.attributes.left.damAdj

  # build widget .$toplevel.attributes.left.damAdj.label50
  label .$toplevel.attributes.left.damAdj.label50 \
    -text {Damage +/-:}

  # build widget .$toplevel.attributes.left.damAdj.value
  entry .$toplevel.attributes.left.damAdj.value \
    -width {0} \
    -textvariable ".[set toplevel](damAdj)"
  bindtags .$toplevel.attributes.left.damAdj.value \
	[list .$toplevel.attributes.left.damAdj.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.left.magResAdj
  frame .$toplevel.attributes.left.magResAdj

  # build widget .$toplevel.attributes.left.magResAdj.label50
  label .$toplevel.attributes.left.magResAdj.label50 \
    -text {Magic Res. +/-:}

  # build widget .$toplevel.attributes.left.magResAdj.value
  entry .$toplevel.attributes.left.magResAdj.value \
    -width {0} \
    -textvariable ".[set toplevel](magResAdj)"
  bindtags .$toplevel.attributes.left.magResAdj.value \
	[list .$toplevel.attributes.left.magResAdj.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.middle
  frame .$toplevel.attributes.middle

  # build widget .$toplevel.attributes.middle.sAdj
  frame .$toplevel.attributes.middle.sAdj

  # build widget .$toplevel.attributes.middle.sAdj.label50
  label .$toplevel.attributes.middle.sAdj.label50 \
    -text {Strength +/-:}

  # build widget .$toplevel.attributes.middle.sAdj.value
  entry .$toplevel.attributes.middle.sAdj.value \
    -width {0} \
    -textvariable ".[set toplevel](sAdj)"
  bindtags .$toplevel.attributes.middle.sAdj.value \
	[list .$toplevel.attributes.middle.sAdj.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.middle.iAdj
  frame .$toplevel.attributes.middle.iAdj

  # build widget .$toplevel.attributes.middle.iAdj.label50
  label .$toplevel.attributes.middle.iAdj.label50 \
    -text {Intelligence +/-:}

  # build widget .$toplevel.attributes.middle.iAdj.value
  entry .$toplevel.attributes.middle.iAdj.value \
    -width {0} \
    -textvariable ".[set toplevel](iAdj)"
  bindtags .$toplevel.attributes.middle.iAdj.value \
	[list .$toplevel.attributes.middle.iAdj.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.middle.wAdj
  frame .$toplevel.attributes.middle.wAdj

  # build widget .$toplevel.attributes.middle.wAdj.label50
  label .$toplevel.attributes.middle.wAdj.label50 \
    -text {Wisdom +/-:}

  # build widget .$toplevel.attributes.middle.wAdj.value
  entry .$toplevel.attributes.middle.wAdj.value \
    -width {0} \
    -textvariable ".[set toplevel](wAdj)"
  bindtags .$toplevel.attributes.middle.wAdj.value \
	[list .$toplevel.attributes.middle.wAdj.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.middle.dAdj
  frame .$toplevel.attributes.middle.dAdj

  # build widget .$toplevel.attributes.middle.dAdj.label50
  label .$toplevel.attributes.middle.dAdj.label50 \
    -text {Dexterity +/-:}

  # build widget .$toplevel.attributes.middle.dAdj.value
  entry .$toplevel.attributes.middle.dAdj.value \
    -width {0} \
    -textvariable ".[set toplevel](dAdj)"
  bindtags .$toplevel.attributes.middle.dAdj.value \
	[list .$toplevel.attributes.middle.dAdj.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.middle.cAdj
  frame .$toplevel.attributes.middle.cAdj

  # build widget .$toplevel.attributes.middle.cAdj.label50
  label .$toplevel.attributes.middle.cAdj.label50 \
    -text {Constitution +/-:}

  # build widget .$toplevel.attributes.middle.cAdj.value
  entry .$toplevel.attributes.middle.cAdj.value \
    -width {0} \
    -textvariable ".[set toplevel](cAdj)"
  bindtags .$toplevel.attributes.middle.cAdj.value \
	[list .$toplevel.attributes.middle.cAdj.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.middle.chAdj
  frame .$toplevel.attributes.middle.chAdj

  # build widget .$toplevel.attributes.middle.chAdj.label50
  label .$toplevel.attributes.middle.chAdj.label50 \
    -text {Charisma +/-:}

  # build widget .$toplevel.attributes.middle.chAdj.value
  entry .$toplevel.attributes.middle.chAdj.value \
    -width {0} \
    -textvariable ".[set toplevel](chAdj)"
  bindtags .$toplevel.attributes.middle.chAdj.value \
	[list .$toplevel.attributes.middle.chAdj.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.right
  frame .$toplevel.attributes.right

  # build widget .$toplevel.attributes.right.damProtAdj
  frame .$toplevel.attributes.right.damProtAdj

  # build widget .$toplevel.attributes.right.damProtAdj.label50
  label .$toplevel.attributes.right.damProtAdj.label50 \
    -text {Damage Protection +/-:}

  # build widget .$toplevel.attributes.right.damProtAdj.value
  entry .$toplevel.attributes.right.damProtAdj.value \
    -width {0} \
    -textvariable ".[set toplevel](damProtAdj)"
  bindtags .$toplevel.attributes.right.damProtAdj.value \
	[list .$toplevel.attributes.right.damProtAdj.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.right.gAdj
  frame .$toplevel.attributes.right.gAdj

  # build widget .$toplevel.attributes.right.gAdj.label50
  label .$toplevel.attributes.right.gAdj.label50 \
    -text {Movement +/-:}

  # build widget .$toplevel.attributes.right.gAdj.value
  entry .$toplevel.attributes.right.gAdj.value \
    -width {0} \
    -textvariable ".[set toplevel](gAdj)"
  bindtags .$toplevel.attributes.right.gAdj.value \
	[list .$toplevel.attributes.right.gAdj.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.right.fAdj
  frame .$toplevel.attributes.right.fAdj

  # build widget .$toplevel.attributes.right.fAdj.label50
  label .$toplevel.attributes.right.fAdj.label50 \
    -text {Flying +/-:}

  # build widget .$toplevel.attributes.right.fAdj.value
  entry .$toplevel.attributes.right.fAdj.value \
    -width {0} \
    -textvariable ".[set toplevel](fAdj)"
  bindtags .$toplevel.attributes.right.fAdj.value \
	[list .$toplevel.attributes.right.fAdj.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.right.swAdj
  frame .$toplevel.attributes.right.swAdj

  # build widget .$toplevel.attributes.right.swAdj.label50
  label .$toplevel.attributes.right.swAdj.label50 \
    -text {Swimming +/-:}

  # build widget .$toplevel.attributes.right.swAdj.value
  entry .$toplevel.attributes.right.swAdj.value \
    -width {0} \
    -textvariable ".[set toplevel](swAdj)"
  bindtags .$toplevel.attributes.right.swAdj.value \
	[list .$toplevel.attributes.right.swAdj.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.right.value
  frame .$toplevel.attributes.right.value

  # build widget .$toplevel.attributes.right.value.label50
  label .$toplevel.attributes.right.value.label50 \
    -text {Value:}

  # build widget .$toplevel.attributes.right.value.value
  entry .$toplevel.attributes.right.value.value \
    -width {0} \
    -textvariable ".[set toplevel](value)"
  bindtags .$toplevel.attributes.right.value.value \
	[list .$toplevel.attributes.right.value.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.attributes.right.fill
  frame .$toplevel.attributes.right.fill

  # build widget .$toplevel.description
  frame .$toplevel.description \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .$toplevel.description.scrollbar1
  scrollbar .$toplevel.description.scrollbar1 \
    -command ".$toplevel.description.value yview" \
    -relief {raised}

  # build widget .$toplevel.description.value
  text .$toplevel.description.value \
    -height {4} \
    -width {60} \
    -wrap {word} \
    -yscrollcommand ".$toplevel.description.scrollbar1 set"
  bindtags .$toplevel.description.value \
	[list .$toplevel.description.value Text .$toplevel all UpdComments]

  # build widget .$toplevel.button
  frame .$toplevel.button \
    -borderwidth {2} \
    -relief {raised}

  # build widget .$toplevel.button.button47
  button .$toplevel.button.button47 \
    -text {Load} \
    -command "LoadTreasure .$toplevel"

  # build widget .$toplevel.button.button48
  button .$toplevel.button.button48 \
    -text {Save} \
    -command "SaveTreasure .$toplevel"

  # build widget .$toplevel.button.button49
  button .$toplevel.button.button49 \
    -text {Change Picture} \
    -command "ChangeTreasurePicture .$toplevel im$toplevel"

  # pack master .$toplevel.attributes
  pack configure .$toplevel.attributes.left \
    -expand 1 \
    -fill both \
    -side left
  pack configure .$toplevel.attributes.middle \
    -expand 1 \
    -fill both \
    -side left
  pack configure .$toplevel.attributes.right \
    -expand 1 \
    -fill both \
    -side right

  # pack master .$toplevel.attributes.left
  pack configure .$toplevel.attributes.left.name \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.left.weight \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.left.aCAdj \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.left.toHitAdj \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.left.damAdj \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.left.magResAdj \
    -expand 1 \
    -fill x

  # pack master .$toplevel.attributes.left.name
  pack configure .$toplevel.attributes.left.name.label50 \
    -side left
  pack configure .$toplevel.attributes.left.name.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.left.weight
  pack configure .$toplevel.attributes.left.weight.label50 \
    -side left
  pack configure .$toplevel.attributes.left.weight.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.left.aCAdj
  pack configure .$toplevel.attributes.left.aCAdj.label50 \
    -side left
  pack configure .$toplevel.attributes.left.aCAdj.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.left.toHitAdj
  pack configure .$toplevel.attributes.left.toHitAdj.label50 \
    -side left
  pack configure .$toplevel.attributes.left.toHitAdj.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.left.damAdj
  pack configure .$toplevel.attributes.left.damAdj.label50 \
    -side left
  pack configure .$toplevel.attributes.left.damAdj.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.left.magResAdj
  pack configure .$toplevel.attributes.left.magResAdj.label50 \
    -side left
  pack configure .$toplevel.attributes.left.magResAdj.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.middle
  pack configure .$toplevel.attributes.middle.sAdj \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.middle.iAdj \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.middle.wAdj \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.middle.dAdj \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.middle.cAdj \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.middle.chAdj \
    -expand 1 \
    -fill x

  # pack master .$toplevel.attributes.middle.sAdj
  pack configure .$toplevel.attributes.middle.sAdj.label50 \
    -side left
  pack configure .$toplevel.attributes.middle.sAdj.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.middle.iAdj
  pack configure .$toplevel.attributes.middle.iAdj.label50 \
    -side left
  pack configure .$toplevel.attributes.middle.iAdj.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.middle.wAdj
  pack configure .$toplevel.attributes.middle.wAdj.label50 \
    -side left
  pack configure .$toplevel.attributes.middle.wAdj.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.middle.dAdj
  pack configure .$toplevel.attributes.middle.dAdj.label50 \
    -side left
  pack configure .$toplevel.attributes.middle.dAdj.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.middle.cAdj
  pack configure .$toplevel.attributes.middle.cAdj.label50 \
    -side left
  pack configure .$toplevel.attributes.middle.cAdj.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.middle.chAdj
  pack configure .$toplevel.attributes.middle.chAdj.label50 \
    -side left
  pack configure .$toplevel.attributes.middle.chAdj.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.right
  pack configure .$toplevel.attributes.right.damProtAdj \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.right.gAdj \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.right.fAdj \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.right.swAdj \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.right.value \
    -expand 1 \
    -fill x
  pack configure .$toplevel.attributes.right.fill \
    -expand 1 \
    -fill x

  # pack master .$toplevel.attributes.right.damProtAdj
  pack configure .$toplevel.attributes.right.damProtAdj.label50 \
    -side left
  pack configure .$toplevel.attributes.right.damProtAdj.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.right.gAdj
  pack configure .$toplevel.attributes.right.gAdj.label50 \
    -side left
  pack configure .$toplevel.attributes.right.gAdj.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.right.fAdj
  pack configure .$toplevel.attributes.right.fAdj.label50 \
    -side left
  pack configure .$toplevel.attributes.right.fAdj.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.right.swAdj
  pack configure .$toplevel.attributes.right.swAdj.label50 \
    -side left
  pack configure .$toplevel.attributes.right.swAdj.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.attributes.right.value
  pack configure .$toplevel.attributes.right.value.label50 \
    -side left
  pack configure .$toplevel.attributes.right.value.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.description
  pack configure .$toplevel.description.scrollbar1 \
    -fill y \
    -side right
  pack configure .$toplevel.description.value \
    -expand 1 \
    -fill both

  # pack master .$toplevel.button
  pack configure .$toplevel.button.button47 \
    -expand 1 \
    -side left
  pack configure .$toplevel.button.button48 \
    -expand 1 \
    -side left
  pack configure .$toplevel.button.button49 \
    -expand 1 \
    -side left

  # pack master .$toplevel
  pack configure .$toplevel.attributes \
    -expand 1 \
    -fill both
  pack configure .$toplevel.description \
    -fill both
  pack configure .$toplevel.button \
    -expand 1 \
    -fill x

  set data(name) "[$object Name]"
  set data(weight) [$object Weight]
  set data(aCAdj) [$object ArmorClassAdj]
  set data(toHitAdj) [$object ToHitAdj]
  set data(damAdj) [$object DamageAdj]
  set data(magResAdj) [$object MagicalResistanceAdj]
  set data(sAdj) [$object StrengthAdj]
  set data(iAdj) [$object IntelligenceAdj]
  set data(wAdj) [$object WisdomAdj]
  set data(dAdj) [$object DexterityAdj]
  set data(cAdj) [$object ConstitutionAdj]
  set data(chAdj) [$object CharismaAdj]
  set data(damProtAdj) [$object DamageProtectionAdj]
  set data(gAdj) [$object GroundMovementAdj]
  set data(fAdj) [$object FlyingAdj]
  set data(swAdj) [$object SwimmingAdj]
  set data(value) [$object Value]
  set data(comments) "[$object Description]"
  .$toplevel.description.value insert end "$data(comments)"
  rename $object {}

# end of widget tree

  wm deiconify .$toplevel
}

proc OpenTreasure {tl} {
# This procedure loads a treasure object file into a new GUI toplevel window.
# <in> tl -- the current toplevel window.
# [index] OpenTreasure!procedure

  if {"$tl" == {.}} {
    set data(filename) {}
    set data(filetype) treasure
    set data(class) Treasure
  } else {
    upvar #0 $tl data
  }
  set filename "$data(filename)"
  set filetype "$data(filetype)"
  set initdir "[file dirname $filename]"
  if {[string compare "$initdir" {.}] == 0} {set initdir "[pwd]"}
  if {[string compare "[string index "$initdir" 0]" {/}] != 0} {
    set initdir [file join "[pwd]" "$initdir"]
  }
  set filename [tk_getOpenFile -defaultextension ".$data(filetype)" \
			   -filetypes [list [list "$data(class) files" \
					"*.$filetype"]]\
			   -parent $tl \
			   -initialfile "$filename" \
			   -initialdir "$initdir" \
			   -title "File to load $data(class) data from"]
  if {[string length "$filename"] == 0} {return}
  RPGEd$data(class) "$filename"
}

proc SaveAsTreasure {tl} {
# This procedure saves the currently open treasure object in a disk file.
# <in> tl -- the toplevel.
# [index] SaveAsTreasure!procedure

  SaveTreasure $tl 1
}

proc SaveTreasure {tl {forceNew 0}} {
# This procedure saves the currently open treasure object in a disk file.
# <in> tl -- the toplevel.
# <in> forceNew -- flag to force a new file name.
# [index] SaveTreasure!procedure

  upvar #0 $tl data
  set filename "$data(filename)"
  set filetype "$data(filetype)"
  set object [Treasure -this [NewTreasure \
			-name  "$data(name)" \
			-description "$data(comments)" \
			-image "$data(image)" \
			-weight  $data(weight) \
			-armorclassadj $data(aCAdj) \
			-tohitadj $data(toHitAdj) \
			-damageadj $data(damAdj) \
			-magicalresistanceadj $data(magResAdj) \
			-damageprotectionadj $data(damProtAdj) \
			-strengthadj $data(sAdj) \
			-intelligenceadj $data(iAdj) \
			-wisdomadj $data(wAdj) \
			-dexterityadj $data(dAdj) \
			-constitutionadj $data(cAdj) \
			-charismaadj $data(chAdj) \
			-groundmovementadj $data(gAdj) \
			-flyingadj $data(fAdj) \
			-swimmingadj $data(swAdj) \
			-value $data(value)]]
  set buffer [Record -this [$object RawData]]
  set initdir "[file dirname $filename]"
  if {[string compare "$initdir" {.}] == 0} {set initdir "[pwd]"}
  if {[string compare "[string index "$initdir" 0]" {/}] != 0} {
    set initdir [file join "[pwd]" "$initdir"]
  }
  if {[string length "$filename"] == 0} {
    set initfile "new.$filetype"
  } else {
    set initfile "$filename"
  }
  if {$forceNew || [string length "$filename"] == 0} {
    set filename [tk_getSaveFile -defaultextension ".$filetype" \
      				   -initialfile "$initfile" \
				   -initialdir "$initdir" \
				   -filetypes [list [list "Treasure files" \
							  "*.$filetype"]]\
				   -parent . \
				   -title {File to save treasure data in}]
    if {[string length "$filename"] == 0} {return}
    if {[string length "[file extension $filename]"] == 0} {
	set filename "$filename.$filetype"
    }
  }
  $buffer WriteRecord "$filename"
  rename $buffer {}
  rename $object {}
  set data(dirty) 0
  set data(filename) "$filename"
}

proc LoadTreasure {tl} {
# This procedure loads a treasure data file into the current toplevel GUI.
# <in> tl -- the toplevel to load.
# [index] LoadTreasure!procedure

  upvar #0 $tl data
  set filename "$data(filename)"
  set filetype "$data(filetype)"
  if {$data(dirty)} {
    set saveP [tk_dialog .askDirty "Save treasure?" \
		"Save modified Treasure data?" \
		questhead 0 "Yes" "No"]
    if {$saveP == 0} {SaveTreasure $tl}
  }
  set initdir "[file dirname $filename]"
  if {[string compare "$initdir" {.}] == 0} {set initdir "[pwd]"}
  if {[string compare "[string index "$initdir" 0]" {/}] != 0} {
    set initdir [file join "[pwd]" "$initdir"]
  }
  set filename [tk_getOpenFile -defaultextension ".$filetype" \
				   -initialfile "$filename" \
                                   -initialdir "$initdir" \
                                   -filetypes [list [list "Treasure files" \
							  "*.$filetype"]]\
                                   -parent $tl \
                                   -title {File to load treasure data from}]
  if {[string length "$filename"] == 0} {return}
  set buffer [Record]
  if {[catch [list $buffer ReadRecord "$filename"] err]} {
    tkerror "Could not load file $filename: $err"
    rename $buffer {}
    return
  }
  set key [lindex [$buffer ReturnRecord] 0]
  if {[string compare "$key" {*Treasure}] != 0} {
    rename $buffer {}
    tkerror "Not a trick / trap file: $filename"
    return
  }
  set object [Treasure]
  $object UpdateFromRecord $buffer
  rename $buffer {}
  set data(name) "[$object Name]"
  set data(image) "[$object Image]"
  set data(weight) [$object Weight]
  set data(aCAdj) [$object ArmorClassAdj]
  set data(toHitAdj) [$object ToHitAdj]
  set data(damAdj) [$object DamageAdj]
  set data(magResAdj) [$object MagicalResistanceAdj]
  set data(sAdj) [$object StrengthAdj]
  set data(iAdj) [$object IntelligenceAdj]
  set data(wAdj) [$object WisdomAdj]
  set data(dAdj) [$object DexterityAdj]
  set data(cAdj) [$object ConstitutionAdj]
  set data(chAdj) [$object CharismaAdj]
  set data(damProtAdj) [$object DamageProtectionAdj]
  set data(gAdj) [$object GroundMovementAdj]
  set data(fAdj) [$object FlyingAdj]
  set data(swAdj) [$object SwimmingAdj]
  set data(value) [$object Value]
  set data(comments) "[$object Description]"
  $tl.description.value insert end "$data(comments)"
  set data(dirty) 0
  rename $object {}
  set img [$tl.picture.picture cget -image]
  if {[catch [list $img configure -format gif -file "$data(image)"] err]} {
    tkerror "Could not set image file $data(image) for image $img: $err"
  }
  $tl.picture.imname configure -text "$data(image)"
}

proc CheckWriteDirtyRecordTreasure {tl} {
# This procedure handles toplevel rundown when the data object is ``dirty''
# (modified).  The data is saved out to a file if the user wants.
# <in> tl -- the toplevel.
# [index] CheckWriteDirtyRecordTreasure!procedure

  upvar #0 $tl data
  set filename "$data(filename)"
  set filetype "$data(filetype)"
  set saveP [tk_dialog .askDirty "Save treasure?" "Save modified Treasure data?" \
	questhead 0 "Yes" "No"]
  if {$saveP == 0} {
    set object [Treasure -this [NewTreasure \
			-name  "$data(name)" \
			-description "$data(comments)" \
			-image "$data(image)" \
			-weight  $data(weight) \
			-armorclassadj $data(aCAdj) \
			-tohitadj $data(toHitAdj) \
			-damageadj $data(damAdj) \
			-magicalresistanceadj $data(magResAdj) \
			-damageprotectionadj $data(damProtAdj) \
			-strengthadj $data(sAdj) \
			-intelligenceadj $data(iAdj) \
			-wisdomadj $data(wAdj) \
			-dexterityadj $data(dAdj) \
			-constitutionadj $data(cAdj) \
			-charismaadj $data(chAdj) \
			-groundmovementadj $data(gAdj) \
			-flyingadj $data(fAdj) \
			-swimmingadj $data(swAdj) \
			-value $data(value)]]
    set buffer [Record -this [$object RawData]]
    set initdir "[file dirname $filename]"
    if {[string compare "$initdir" {.}] == 0} {set initdir "[pwd]"}
    if {[string compare "[string index "$initdir" 0]" {/}] != 0} {
      set initdir [file join "[pwd]" "$initdir"]
    }
    if {[string length "$filename"] == 0} {
      set initfile "new.$filetype"
    } else {
      set initfile "$filename"
    }
    if {[string length "$filename"] == 0} {
      set filename [tk_getSaveFile -defaultextension ".$filetype" \
      				   -initialfile "$initfile" \
				   -initialdir "$initdir" \
				   -filetypes [list [list "Treasure files" \
							  "*.$filetype"]]\
				   -parent . \
				   -title {File to save treasure data in}]
      if {[string length "$filename"] == 0} {return}
      if {[string length "[file extension $filename]"] == 0} {
	set filename "$filename.$filetype"
      }
    }
    $buffer WriteRecord "$filename"
    rename $buffer {}
    rename $object {}
  }
}

proc ChangeTreasurePicture {tl img} {
# This procedure changes the image (picture, GIF file) associated with the
# treasure object.
# <in> tl -- the toplevel GUI window.
# <in> img -- the image object.
# [index] ChangeTreasurePicture!procedure

  upvar #0 $tl data
  set initdir "[file dirname $data(image)]"
  if {[string compare "$initdir" {.}] == 0} {set initdir "[pwd]"}
  if {[string compare "[string index "$initdir" 0]" {/}] != 0} {
    set initdir [file join "[pwd]" "$initdir"]
  }
  set newIm [tk_getOpenFile -defaultextension {.gif} \
			    -filetypes { { {GIF Files} {*.gif *.GIF} GIFf } } \
			    -initialfile "$data(image)" \
			    -initialdir "$initdir" \
			    -parent "$tl" \
			    -title {Select a new image file}]
  if {[string length "$newIm"] == 0} {return}
  if {[catch [list $img configure -format gif -file "$newIm"] err]} {
    tkerror "Could not set image file $newIm for image $img: $err"
  }
  $tl.picture.imname configure -text "$newIm"
  set data(image) "$newIm"
  set data(dirty) 1
}

package provide RPGEdTreasure 1.0
