#* 
#* ------------------------------------------------------------------
#* Role PlayingDB V2.0 by Deepwoods Software
#* ------------------------------------------------------------------
#* RPGEdSpace.tcl - Space editor
#* Created by Robert Heller on Mon Aug 24 14:32:11 1998
#* ------------------------------------------------------------------
#* Modification History: 
#* $Log: RPGEdSpace.tcl,v $
#* Revision 1.10  2000/02/11 00:30:25  heller
#* Change MacOS type code GIF => GIFf
#*
#* Revision 1.9  1999/07/14 23:30:35  heller
#* Fix typos in Dialog box titles
#*
#* Revision 1.8  1999/07/13 01:29:16  heller
#* Fix documentation: spelling, punctuation, etc.
#*
#* Revision 1.7  1999/04/19 21:36:01  heller
#* Update HelpTopics to match help topic links.
#*
#* Revision 1.6  1999/03/28 06:20:44  heller
#* Update on-line help.
#*
#* Revision 1.5  1999/01/02 01:55:23  heller
#* Small fix for ComputeNextSpace.
#*
#* Revision 1.4  1999/01/02 00:10:23  heller
#* Fix title of Exit Information dialog
#*
#* Revision 1.3  1999/01/01 21:19:27  heller
#* Fix small binding error.
#*
#* Revision 1.2  1998/12/30 15:17:24  heller
#* Add in comments
#*
#* Revision 1.1  1998/12/29 22:47:54  heller
#* Initial revision
#*
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Role Playing DB -- A database package that creates and maintains
#* 		       a database of RPG characters, monsters, treasures,
#* 		       spells, and playing environments.
#* 
#*     Copyright (C) 1995,1998  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

#@Chapter:RPGEdSpace.tcl -- The spaces where things happen
#@Label:RPGEdSpace.tcl
#$Id: RPGEdSpace.tcl,v 1.10 2000/02/11 00:30:25 heller Rel $
# This file contains the code to implement the GUI windows to create and
# edit spaces.  This code is called from the code that edits Maps.

proc CreateNewSpace {maptl} {
# This procedure creates a new space.
# <in> maptl -- the map toplevel.
# [index] CreateNewSpace!procedure

  upvar #0 $maptl mapdata
  
  # build widget $maptl.newSpace
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $maptl.newSpace"
  } {
    catch "destroy $maptl.newSpace"
  }
  toplevel $maptl.newSpace 
  upvar #0 $maptl.newSpace sData
  catch "unset sData"
  set sData(CreateResult) 0

  # Window manager configurations
  wm positionfrom $maptl.newSpace ""
  wm sizefrom $maptl.newSpace ""
  wm maxsize $maptl.newSpace 1000 1000
  wm minsize $maptl.newSpace 10 10
  wm title $maptl.newSpace {Create New Space}
  wm transient $maptl.newSpace $maptl


  # build widget $maptl.newSpace.position
  frame $maptl.newSpace.position \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $maptl.newSpace.position.label5
  label $maptl.newSpace.position.label5 \
    -text {Center X:}

  # build widget $maptl.newSpace.position.centerX
  entry $maptl.newSpace.position.centerX \
    -width {3} \
    -textvariable "[set maptl].newSpace(centerX)"
  bindtags $maptl.newSpace.position.centerX \
	[list $maptl.newSpace.position.centerX Entry $maptl.newSpace all IntEntry]

  # build widget $maptl.newSpace.position.label7
  label $maptl.newSpace.position.label7 \
    -text {Center Y:}

  # build widget $maptl.newSpace.position.centerY
  entry $maptl.newSpace.position.centerY \
    -width {3} \
    -textvariable "[set maptl].newSpace(centerY)"
  bindtags $maptl.newSpace.position.centerY \
	[list $maptl.newSpace.position.centerY Entry $maptl.newSpace all IntEntry]

  # build widget $maptl.newSpace.name
  frame $maptl.newSpace.name \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $maptl.newSpace.name.label9
  label $maptl.newSpace.name.label9 \
    -text {Name:}

  # build widget $maptl.newSpace.name.value
  entry $maptl.newSpace.name.value \
    -width {10} \
    -textvariable "[set maptl].newSpace(name)"

  # build widget $maptl.newSpace.color
  frame $maptl.newSpace.color \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $maptl.newSpace.color.label11
  label $maptl.newSpace.color.label11 \
    -text {Background Color:}

  # build widget $maptl.newSpace.color.value
  entry $maptl.newSpace.color.value \
    -width {5} \
    -textvariable "[set maptl].newSpace(bgcolor)"

  # build widget $maptl.newSpace.color.button13
  button $maptl.newSpace.color.button13 \
    -padx {9} \
    -pady {3} \
    -text {Browse} \
    -command "SelectSpaceColor $maptl.newSpace.color.value"

  # build widget $maptl.newSpace.buttons
  frame $maptl.newSpace.buttons \
    -borderwidth {2}

  # build widget $maptl.newSpace.buttons.button14
  button $maptl.newSpace.buttons.button14 \
    -padx {9} \
    -pady {3} \
    -text {Create} \
    -command "CreateNewSpaceCreateButton $maptl $maptl.newSpace"

  # build widget $maptl.newSpace.buttons.button15
  button $maptl.newSpace.buttons.button15 \
    -padx {9} \
    -pady {3} \
    -text {Cancel} \
    -command "CreateNewSpaceCancelButton $maptl $maptl.newSpace"

  # build widget $maptl.newSpace.buttons.button16
  button $maptl.newSpace.buttons.button16 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {HelpTopic {Create New Space}}

  # pack master $maptl.newSpace.position
  pack configure $maptl.newSpace.position.label5 \
    -side left
  pack configure $maptl.newSpace.position.centerX \
    -expand 1 \
    -fill x \
    -side left
  pack configure $maptl.newSpace.position.label7 \
    -side left
  pack configure $maptl.newSpace.position.centerY \
    -expand 1 \
    -fill x \
    -side left

  # pack master $maptl.newSpace.name
  pack configure $maptl.newSpace.name.label9 \
    -side left
  pack configure $maptl.newSpace.name.value \
    -expand 1 \
    -fill x \
    -side left

  # pack master $maptl.newSpace.color
  pack configure $maptl.newSpace.color.label11 \
    -side left
  pack configure $maptl.newSpace.color.value \
    -expand 1 \
    -fill x \
    -side left
  pack configure $maptl.newSpace.color.button13 \
    -side right

  # pack master $maptl.newSpace.buttons
  pack configure $maptl.newSpace.buttons.button14 \
    -expand 1 \
    -side left
  pack configure $maptl.newSpace.buttons.button15 \
    -expand 1 \
    -side left
  pack configure $maptl.newSpace.buttons.button16 \
    -expand 1 \
    -side right

  # pack master $maptl.newSpace
  pack configure $maptl.newSpace.position \
    -expand 1 \
    -fill x
  pack configure $maptl.newSpace.name \
    -expand 1 \
    -fill x
  pack configure $maptl.newSpace.color \
    -expand 1 \
    -fill x
  pack configure $maptl.newSpace.buttons \
    -expand 1 \
    -fill x

  $maptl.newSpace.position.centerX insert end {}
  $maptl.newSpace.position.centerY insert end {}
  $maptl.newSpace.name.value insert end {}
  $maptl.newSpace.color.value insert end {}


# end of widget tree

  set sData(name) {}
  set sData(bgcolor) {white}
  set sData(centerX) 0
  set sData(centerY) 0

  set oldFocus [focus]
  set oldGrab [grab current $maptl.newSpace]
  if {$oldGrab != ""} {
    set grabStatus [grab status $oldGrab]
  }

  focus $maptl.newSpace.name.value
  grab $maptl.newSpace
  tkwait window $maptl.newSpace

  catch {focus $oldFocus}
  if {$oldGrab != ""} {
        if {$grabStatus == "global"} {
            grab -global $oldGrab
        } else {
            grab $oldGrab
        }
  }
  if {$sData(CreateResult)} {
    if {[info exists GeoConstants_Width] == 0} {
      catch [list GeoConstants]
    }
    global GeoConstants_Width GeoConstants_HexSideLength GeoConstants_HexPeakHeight
    if {"$mapdata(shape)" == {Space::Hexagon}} {
      set dy [expr $GeoConstants_HexSideLength + $GeoConstants_HexPeakHeight]
      if {[expr $sData(centerY) % 2] == 1} {
	set sData(centerX) [expr $sData(centerX) + .5]
      }
      set sData(centerY) [expr $sData(centerY) * ($dy / 100.0)]
    }
    set newsp [Space -this [NewSpace -shape $mapdata(shape) \
				     -xcenter [expr $sData(centerX) * $GeoConstants_Width] \
				     -ycenter [expr $sData(centerY) * $GeoConstants_Width] \
				     -name "$sData(name)" \
				     -backgroundcolor "$sData(bgcolor)" \
				     -description {}]]
    return $newsp
  } else {
    return {}
  }
}

proc SelectSpaceColor {entry} {
# This procedure selects a background color for the space.
# <in> entry -- this is the entry widget where the name of the color is entered.
# [index] SelectSpaceColor!procedure

  set newColor [tk_chooseColor -initialcolor "[$entry get]" \
			       -parent [winfo toplevel $entry] \
			       -title {Select space background color}]
  if {[string length "$newColor"] > 0} {
    $entry delete 0 end
    $entry insert end "$newColor"
  }
}

proc CreateNewSpaceCancelButton {maptl dialog} {
# This procedure handles the Cancel button on the space creation dialog.
# <in> maptl -- the map toplevel.
# <in> dialog -- the space creation dialog.
# [index] CreateNewSpaceCancelButton!procedure

  upvar #0 $dialog sData
  set sData(CreateResult) 0
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $dialog"
  } {
    catch "destroy $dialog"
  }
}  

proc CreateNewSpaceCreateButton {maptl dialog} {
# This procedure handles the Create button on the space creation dialog.
# <in> maptl -- the map toplevel.
# <in> dialog -- the space creation dialog.
# [index] CreateNewSpaceCreateButton!procedure

  upvar #0 $dialog sData
  set sData(CreateResult) 1
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $dialog"
  } {
    catch "destroy $dialog"
  }
}  

proc EditLoadedSpace {maptl spFile sp level} {
# This procedure edits a loaded space.
# <in> maptl -- the map toplevel.
# <in> spFile -- the name of the space file.
# <in> sp -- the space object.
# <in> level -- the level the space is on.
# [index] EditLoadedSpace!procedure

  upvar #0 $maptl mapdata
  upvar #0 $maptl.spaceEdit spaceData
  global $maptl.spaceEdit
  set spaceData(dirty) 0

  # build widget $maptl.spaceEdit
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $maptl.spaceEdit"
  } {
    catch "destroy $maptl.spaceEdit"
  }
  toplevel $maptl.spaceEdit 

  # Window manager configurations
  wm positionfrom $maptl.spaceEdit ""
  wm sizefrom $maptl.spaceEdit ""
  wm maxsize $maptl.spaceEdit 1000 1000
  wm minsize $maptl.spaceEdit 10 10
  wm title $maptl.spaceEdit "Editing space [$sp Name]"
  wm transient $maptl.spaceEdit $maptl


  # build widget $maptl.spaceEdit.ident
  frame $maptl.spaceEdit.ident \
    -borderwidth {2}

  # build widget $maptl.spaceEdit.ident.label4
  label $maptl.spaceEdit.ident.label4 \
    -text {Name:}

  # build widget $maptl.spaceEdit.ident.name
  label $maptl.spaceEdit.ident.name \
    -relief {sunken} \
    -text "[$sp Name]"

  # build widget $maptl.spaceEdit.ident.label6
  label $maptl.spaceEdit.ident.label6 \
    -text {X:}

  # build widget $maptl.spaceEdit.ident.x
  label $maptl.spaceEdit.ident.x \
    -relief {sunken} \
    -text "[$sp CenterX]"

  # build widget $maptl.spaceEdit.ident.label8
  label $maptl.spaceEdit.ident.label8 \
    -text {Y:}

  # build widget $maptl.spaceEdit.ident.y
  label $maptl.spaceEdit.ident.y \
    -relief {sunken} \
    -text "[$sp CenterY]"

  # build widget $maptl.spaceEdit.ident.label10
  label $maptl.spaceEdit.ident.label10 \
    -text {Shape:}

  # build widget $maptl.spaceEdit.ident.shape
  label $maptl.spaceEdit.ident.shape \
    -relief {sunken} \
    -text "[$sp Shape]"

  # build widget $maptl.spaceEdit.description
  frame $maptl.spaceEdit.description \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $maptl.spaceEdit.description.scrollbar1
  scrollbar $maptl.spaceEdit.description.scrollbar1 \
    -command "$maptl.spaceEdit.description.value yview"

  # build widget $maptl.spaceEdit.description.value
  text $maptl.spaceEdit.description.value \
    -height {5} \
    -width {40} \
    -wrap {word} \
    -yscrollcommand "$maptl.spaceEdit.description.scrollbar1 set"
  bindtags $maptl.spaceEdit.description.value \
	[list  $maptl.spaceEdit.description.value Text  $maptl.spaceEdit all UpdDescription]

  # build widget $maptl.spaceEdit.buttons
  frame $maptl.spaceEdit.buttons \
    -borderwidth {2}

  # build widget $maptl.spaceEdit.buttons.button24
  button $maptl.spaceEdit.buttons.button24 \
    -padx {9} \
    -pady {3} \
    -text {Close} \
    -command [list CloseSpaceEdit $maptl $sp $level]

  # build widget $maptl.spaceEdit.buttons.button25
  button $maptl.spaceEdit.buttons.button25 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {HelpTopic {Space Data Object Editor GUI Window}}

  # build widget $maptl.spaceEdit.viewFrame
  frame $maptl.spaceEdit.viewFrame \
    -borderwidth {2} \
    -relief {ridge}

  set cX [$sp CenterX]
  set cY [$sp CenterY]


  # build widget $maptl.spaceEdit.viewFrame.view
  canvas $maptl.spaceEdit.viewFrame.view \
    -height {200} \
    -width {200} \
    -scrollregion [list [expr $cX - 100] [expr $cY - 100] \
			[expr $cX + 100] [expr $cY + 100]]

  # build widget $maptl.spaceEdit.viewFrame.lists
  frame $maptl.spaceEdit.viewFrame.lists \
    -borderwidth {2}

  # build widget $maptl.spaceEdit.viewFrame.lists.exits
  frame $maptl.spaceEdit.viewFrame.lists.exits \
    -borderwidth {2} \
    -relief {groove}

  # build widget $maptl.spaceEdit.viewFrame.lists.exits.lbFrame
  frame $maptl.spaceEdit.viewFrame.lists.exits.lbFrame \
    -borderwidth {2}

  # build widget $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll
  frame $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll

  # build widget $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.lbFrame
  frame $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.lbFrame \
    -borderwidth {2}

  # build widget $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.lbFrame.list
  listbox $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.lbFrame.list \
    -height {2} \
    -width {10} \
    -selectmode single \
    -exportselection 0 \
    -xscrollcommand "$maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2.frame5.scrollbar10 set" \
    -yscrollcommand "$maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.frame4.scrollbar9 set"
  bind $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.lbFrame.list \
	<1> \
	"$maptl.spaceEdit.viewFrame.lists.exits.buttons.deleteButton configure -state normal"

  # build widget $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.frame4
  frame $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.frame4 \
    -borderwidth {2}

  # build widget $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.frame4.scrollbar9
  scrollbar $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.frame4.scrollbar9 \
    -command "$maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.lbFrame.list yview" \
    -width {13}

  # build widget $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2
  frame $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2 \
    -borderwidth {1}

  # build widget $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2.frame5
  frame $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2.frame5 \
    -borderwidth {2}

  # build widget $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2.frame5.scrollbar10
  scrollbar $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2.frame5.scrollbar10 \
    -command "$maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.lbFrame.list xview" \
    -orient {horizontal} \
    -width {13}

  # build widget $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2.frame6
  frame $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2.frame6 \
    -borderwidth {2}

  # build widget $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2.frame6.frame11
  frame $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2.frame6.frame11 \
    -borderwidth {2} \
    -height {13} \
    -width {16}

  # build widget $maptl.spaceEdit.viewFrame.lists.exits.buttons
  frame $maptl.spaceEdit.viewFrame.lists.exits.buttons \
    -borderwidth {2}

  # build widget $maptl.spaceEdit.viewFrame.lists.exits.buttons.addButton
  button $maptl.spaceEdit.viewFrame.lists.exits.buttons.addButton \
    -padx {9} \
    -pady {3} \
    -text {Add} \
    -command [list AddExit $maptl $sp $level]

  # build widget $maptl.spaceEdit.viewFrame.lists.exits.buttons.deleteButton
  button $maptl.spaceEdit.viewFrame.lists.exits.buttons.deleteButton \
    -padx {9} \
    -pady {3} \
    -text {Delete} \
    -state disabled \
    -command [list DeleteExit $maptl $sp]

  # build widget $maptl.spaceEdit.viewFrame.lists.exits.label7
  label $maptl.spaceEdit.viewFrame.lists.exits.label7 \
    -text {Exits}

  # build widget $maptl.spaceEdit.viewFrame.lists.items
  frame $maptl.spaceEdit.viewFrame.lists.items \
    -borderwidth {2} \
    -relief {groove}

  # build widget $maptl.spaceEdit.viewFrame.lists.items.lbFrame
  frame $maptl.spaceEdit.viewFrame.lists.items.lbFrame \
    -borderwidth {2}

  # build widget $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll
  frame $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll

  # build widget $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.lbFrame
  frame $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.lbFrame \
    -borderwidth {2}

  # build widget $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.lbFrame.list
  listbox $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.lbFrame.list \
    -height {2} \
    -width {10} \
    -selectmode single \
    -exportselection 0 \
    -xscrollcommand "$maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2.frame5.scrollbar10 set" \
    -yscrollcommand "$maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.frame4.scrollbar9 set"
  bind $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.lbFrame.list \
	<1> \
	"$maptl.spaceEdit.viewFrame.lists.items.buttons.deleteButton configure -state normal"

  # build widget $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.frame4
  frame $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.frame4 \
    -borderwidth {2}

  # build widget $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.frame4.scrollbar9
  scrollbar $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.frame4.scrollbar9 \
    -command "$maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.lbFrame.list yview" \
    -width {13}

  # build widget $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2
  frame $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2 \
    -borderwidth {1}

  # build widget $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2.frame5
  frame $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2.frame5 \
    -borderwidth {2}

  # build widget $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2.frame5.scrollbar10
  scrollbar $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2.frame5.scrollbar10 \
    -command "$maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.lbFrame.list xview" \
    -orient {horizontal} \
    -width {13}

  # build widget $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2.frame6
  frame $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2.frame6 \
    -borderwidth {2}

  # build widget $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2.frame6.frame11
  frame $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2.frame6.frame11 \
    -borderwidth {2} \
    -height {13} \
    -width {16}

  # build widget $maptl.spaceEdit.viewFrame.lists.items.buttons
  frame $maptl.spaceEdit.viewFrame.lists.items.buttons \
    -borderwidth {2}

  # build widget $maptl.spaceEdit.viewFrame.lists.items.buttons.addButton
  button $maptl.spaceEdit.viewFrame.lists.items.buttons.addButton \
    -padx {9} \
    -pady {3} \
    -text {Add} \
    -command [list AddItem $maptl $sp]

  # build widget $maptl.spaceEdit.viewFrame.lists.items.buttons.deleteButton
  button $maptl.spaceEdit.viewFrame.lists.items.buttons.deleteButton \
    -padx {9} \
    -pady {3} \
    -text {Delete} \
    -state disabled \
    -command [list DeleteItem $maptl $sp]

  # build widget $maptl.spaceEdit.viewFrame.lists.items.label8
  label $maptl.spaceEdit.viewFrame.lists.items.label8 \
    -text {Items}

  # pack master $maptl.spaceEdit.ident
  pack configure $maptl.spaceEdit.ident.label4 \
    -side left
  pack configure $maptl.spaceEdit.ident.name \
    -expand 1 \
    -fill x \
    -side left
  pack configure $maptl.spaceEdit.ident.label6 \
    -side left
  pack configure $maptl.spaceEdit.ident.x \
    -expand 1 \
    -fill x \
    -side left
  pack configure $maptl.spaceEdit.ident.label8 \
    -side left
  pack configure $maptl.spaceEdit.ident.y \
    -expand 1 \
    -fill x \
    -side left
  pack configure $maptl.spaceEdit.ident.label10 \
    -side left
  pack configure $maptl.spaceEdit.ident.shape \
    -expand 1 \
    -fill x \
    -side left

  # pack master $maptl.spaceEdit.description
  pack configure $maptl.spaceEdit.description.scrollbar1 \
    -fill y \
    -side right
  pack configure $maptl.spaceEdit.description.value \
    -expand 1 \
    -fill both

  # pack master $maptl.spaceEdit.buttons
  pack configure $maptl.spaceEdit.buttons.button24 \
    -expand 1 \
    -side left
  pack configure $maptl.spaceEdit.buttons.button25 \
    -expand 1 \
    -side right

  # pack master $maptl.spaceEdit.viewFrame
  pack configure $maptl.spaceEdit.viewFrame.view \
    -expand 1 \
    -fill both \
    -side left
  pack configure $maptl.spaceEdit.viewFrame.lists \
    -expand 1 \
    -fill y \
    -side right

  # pack master $maptl.spaceEdit.viewFrame.lists
  pack configure $maptl.spaceEdit.viewFrame.lists.exits \
    -expand 1 \
    -fill y
  pack configure $maptl.spaceEdit.viewFrame.lists.items \
    -expand 1 \
    -fill y

  # pack master $maptl.spaceEdit.viewFrame.lists.exits
  pack configure $maptl.spaceEdit.viewFrame.lists.exits.label7
  pack configure $maptl.spaceEdit.viewFrame.lists.exits.lbFrame \
    -expand 1 \
    -fill both
  pack configure $maptl.spaceEdit.viewFrame.lists.exits.buttons

  # pack master $maptl.spaceEdit.viewFrame.lists.exits.lbFrame
  pack configure $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll \
    -expand 1 \
    -fill both
  pack configure $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2 \
    -fill x \
    -side bottom

  # pack master $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll
  pack configure $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.lbFrame \
    -expand 1 \
    -fill both \
    -side left
  pack configure $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.frame4 \
    -fill y \
    -side right

  # pack master $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.lbFrame
  pack configure $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.lbFrame.list \
    -expand 1 \
    -fill both \
    -side left

  # pack master $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.frame4
  pack configure $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.frame4.scrollbar9 \
    -expand 1 \
    -fill y

  # pack master $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2
  pack configure $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2.frame5 \
    -expand 1 \
    -fill both \
    -side left
  pack configure $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2.frame6 \
    -fill y \
    -side right

  # pack master $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2.frame5
  pack configure $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2.frame5.scrollbar10 \
    -expand 1 \
    -fill x \
    -side left

  # pack master $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2.frame6
  pack configure $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.frame2.frame6.frame11 \
    -expand 1 \
    -fill both

  # pack master $maptl.spaceEdit.viewFrame.lists.exits.buttons
  pack configure $maptl.spaceEdit.viewFrame.lists.exits.buttons.addButton \
    -expand 1 \
    -side left
  pack configure $maptl.spaceEdit.viewFrame.lists.exits.buttons.deleteButton \
    -expand 1 \
    -side left

  # pack master $maptl.spaceEdit.viewFrame.lists.items
  pack configure $maptl.spaceEdit.viewFrame.lists.items.label8
  pack configure $maptl.spaceEdit.viewFrame.lists.items.lbFrame \
    -expand 1 \
    -fill both
  pack configure $maptl.spaceEdit.viewFrame.lists.items.buttons

  # pack master $maptl.spaceEdit.viewFrame.lists.items.lbFrame
  pack configure $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll \
    -expand 1 \
    -fill both
  pack configure $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2 \
    -fill x \
    -side bottom

  # pack master $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll
  pack configure $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.lbFrame \
    -expand 1 \
    -fill both \
    -side left
  pack configure $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.frame4 \
    -fill y \
    -side right

  # pack master $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.lbFrame
  pack configure $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.lbFrame.list \
    -expand 1 \
    -fill both \
    -side left

  # pack master $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.frame4
  pack configure $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.frame4.scrollbar9 \
    -expand 1 \
    -fill y

  # pack master $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2
  pack configure $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2.frame5 \
    -expand 1 \
    -fill both \
    -side left
  pack configure $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2.frame6 \
    -fill y \
    -side right

  # pack master $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2.frame5
  pack configure $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2.frame5.scrollbar10 \
    -expand 1 \
    -fill x \
    -side left

  # pack master $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2.frame6
  pack configure $maptl.spaceEdit.viewFrame.lists.items.lbFrame.frame2.frame6.frame11 \
    -expand 1 \
    -fill both

  # pack master $maptl.spaceEdit.viewFrame.lists.items.buttons
  pack configure $maptl.spaceEdit.viewFrame.lists.items.buttons.addButton \
    -expand 1 \
    -side left
  pack configure $maptl.spaceEdit.viewFrame.lists.items.buttons.deleteButton \
    -expand 1 \
    -side left

  # pack master $maptl.spaceEdit
  pack configure $maptl.spaceEdit.ident \
    -fill x
  pack configure $maptl.spaceEdit.description \
    -fill both
  pack configure $maptl.spaceEdit.viewFrame \
    -fill x
  pack configure $maptl.spaceEdit.buttons \
    -fill x

  set spaceData(description) "[$sp Description]"
  $maptl.spaceEdit.description.value insert end "$spaceData(description)"
  # build canvas items $maptl.spaceEdit.viewFrame.view
  set canvas $maptl.spaceEdit.viewFrame.view

# Draw the space and the items and exits that are in the space.

  set drawcmd "[$sp MakeGraphicCommannd 1]"
  eval [concat $canvas create $drawcmd]

# Set up the cross hairs
  update
  set topY    [$canvas canvasy 0]
  set bottomY [$canvas canvasy [winfo height $canvas]]
  set leftX   [$canvas canvasx 0]
  set rightX  [$canvas canvasx [winfo width $canvas]]
  $canvas create text $leftX $bottomY -anchor sw -text { 0.0, 0.0} \
		-fill blue -tag position
  $canvas create line $leftX $topY $leftX $bottomY -fill black -tag vert
  $canvas create line $leftX $topY $rightX $topY -fill black -tag horiz
  bind $canvas  <Motion> {DrawXHairs %W %x %y}

# The Edit/View event is the rightmost button on UNIX and Windows boxes,
# Command + button on single button Macs
  global tcl_platform
  if {"$tcl_platform(platform)" == "macintosh"} {
    set EdEvent <Command-Button-1>
  } else {
    set EdEvent <3>
  }
# Draw the exits.  Bind the left/only button to a select function and bind
# the edit event to view the exit.
  set numExits [$sp NumberOfExits]
  set lb $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.lbFrame.list
  for {set i 0} {$i < $numExits} {incr i} {
    set ex [$sp IndexedExit $i]
    if {[string length "[info command $ex]"] == 0} {set ex [Exit -this $ex]}
    $lb insert end "$i [$ex Type] at [$ex XCenter],[$ex YCenter]"
    set id [$canvas create image [expr [$ex XCenter] + [$sp CenterX]] \
				 [expr [$ex YCenter] + [$sp CenterY]] \
				 -image [image create photo -file [$ex Image]]]
    $canvas bind $id <1> [list SelectLbEnB $maptl.spaceEdit.viewFrame.lists.exits $i]
    $canvas bind $id $EdEvent [list VisitExit $sp $i $maptl.spaceEdit]
    set spaceData(ExitGrIds,$i) $id
  }
# Draw the items.  Bind the left/only button to a select function and bind
# the edit event to view/edit the item.
  set numItems [$sp NumberOfItems]
  set lb $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.lbFrame.list
  for {set i 0} {$i < $numItems} {incr i} {
    set it [$sp IndexedItem $i]
    if {[string length "[info command $it]"] == 0} {set it [Item -this $it]}
    $lb insert end "$i [$it Type] at [$it XCenter],[$it YCenter]"
    set id [$canvas create image [expr [$it XCenter] + [$sp CenterX]] \
				 [expr [$it YCenter] + [$sp CenterY]] \
				 -image [image create photo -file [$it Image]]]
    $canvas bind $id <1> [list SelectLbEnB $maptl.spaceEdit.viewFrame.lists.items $i]
    $canvas bind $id $EdEvent [list VisitItem $sp $i]
    set spaceData(ItemGrIds,$i) $id
  }

# end of widget tree

}

proc SelectLbEnB {base i} {
# Procedure to handle listbox selection for the exit and item listboxes.
# This procedure is bound to the select button of the graphical item.
# <in> base -- frame containing the section of the dialog that handles
#              the list.
# <in> i -- the listbox index that was selected.
# [index] SelectLbEnB!procedure

  set lb $base.lbFrame.lbYscroll.lbFrame.list
  catch [list $lb selection clear [$lb curselection]]
  $lb selection set $i
  $lb see $i
  $base.buttons.deleteButton configure -state normal
}

proc DrawXHairs {canvas x y} {
# Procedure to adjust the crosshairs and update the position information.
# This procedure is bound to pointer motion.
# <in> canvas -- the canvas widget.
# <in> x -- the mouse X coordinate.
# <in> y -- the mouse Y coordinate.
# [index] DrawXHairs!procedure

  set curX [$canvas canvasx $x]
  set curY [$canvas canvasy $y]
  set topY    [$canvas canvasy 0]
  set bottomY [$canvas canvasy [winfo height $canvas]]
  set leftX   [$canvas canvasx 0]
  set rightX  [$canvas canvasx [winfo width $canvas]]
  $canvas coords vert $curX $topY $curX $bottomY
  $canvas coords horiz $leftX $curY $rightX $curY
  $canvas itemconfigure position -text "[format { %f, %f} $curX $curY]"
}


proc CloseSpaceEdit {maptl sp level} {
# Procedure bound to the Close button on the space edit dialog.  Closes the
# dialog and updates the map.
# <in> maptl -- the map toplevel.
# <in> sp -- the space being edited.
# <in> level -- the level the space is on.
# [index] CloseSpaceEdit!procedure

  upvar #0 $maptl mapData
  upvar #0 $maptl.spaceEdit spaceData

  if {$spaceData(dirty) == 1 && \
      [string compare "$spaceData(description)" "[$sp Description]"] != 0} {
    $sp SetDescription "$$spaceData(description)"
  }
  if {$spaceData(dirty) == 1} {
    set mapData(SpaceDirty,$level,[$sp CenterX],[$sp CenterY]) 1
    set mapData(dirty) 1
  }

  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $maptl.spaceEdit"
  } {
    catch "destroy $maptl.spaceEdit"
  }
}

proc AddExit {maptl sp level} {
# This procedure adds a new exit to the space.
# <in> maptl -- the map toplevel.
# <in> sp -- the space object.
# <in> level -- the level the space is on.
# [index] AddExit!procedure

  upvar #0 $maptl data
  upvar #0 $maptl.spaceEdit.newExit exitData
  global $maptl.spaceEdit.newExit

  if {[winfo exists $maptl.spaceEdit.newExit]} {return}
  set exitData(dirty) 0

  # build widget $maptl.spaceEdit.newExit
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $maptl.spaceEdit.newExit"
  } {
    catch "destroy $maptl.spaceEdit.newExit"
  }
  toplevel $maptl.spaceEdit.newExit 

  # Window manager configurations
  wm positionfrom $maptl.spaceEdit.newExit ""
  wm sizefrom $maptl.spaceEdit.newExit ""
  wm maxsize $maptl.spaceEdit.newExit 1000 1000
  wm minsize $maptl.spaceEdit.newExit 10 10
  wm protocol $maptl.spaceEdit.newExit WM_DELETE_WINDOW { }
  wm title $maptl.spaceEdit.newExit "Creating New Exit"
  wm transient $maptl.spaceEdit.newExit $maptl.spaceEdit

  # build widget $maptl.spaceEdit.newExit.labelXY
  frame $maptl.spaceEdit.newExit.labelXY \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $maptl.spaceEdit.newExit.labelXY.label5
  label $maptl.spaceEdit.newExit.labelXY.label5 \
    -text {Exit}

  # build widget $maptl.spaceEdit.newExit.labelXY.label6
  label $maptl.spaceEdit.newExit.labelXY.label6 \
    -text {X:}

  # build widget $maptl.spaceEdit.newExit.labelXY.xc
  entry $maptl.spaceEdit.newExit.labelXY.xc \
    -width {5} \
    -textvariable "[set maptl].spaceEdit.newExit(centerX)"
  bindtags $maptl.spaceEdit.newExit.labelXY.xc \
	[list $maptl.spaceEdit.newExit.labelXY.xc Entry $maptl.spaceEdit.newExit all FloatEntry]

  # build widget $maptl.spaceEdit.newExit.labelXY.label8
  label $maptl.spaceEdit.newExit.labelXY.label8 \
    -text {Y:}

  # build widget $maptl.spaceEdit.newExit.labelXY.yc
  entry $maptl.spaceEdit.newExit.labelXY.yc \
    -width {5} \
    -textvariable "[set maptl].spaceEdit.newExit(centerY)"
  bindtags $maptl.spaceEdit.newExit.labelXY.yc \
	[list $maptl.spaceEdit.newExit.labelXY.yc Entry $maptl.spaceEdit.newExit all FloatEntry]

  # build widget $maptl.spaceEdit.newExit.waTyIm
  frame $maptl.spaceEdit.newExit.waTyIm \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $maptl.spaceEdit.newExit.waTyIm.wallAligned
  checkbutton $maptl.spaceEdit.newExit.waTyIm.wallAligned \
    -text {Wall Aligned} \
    -variable "[set maptl].spaceEdit.newExit(WallAlignedP)"
  set exitData(WallAlignedP) 1

  # build widget $maptl.spaceEdit.newExit.waTyIm.l1
  label $maptl.spaceEdit.newExit.waTyIm.l1 -text {Type:}

  # build widget $maptl.spaceEdit.newExit.waTyIm.type
  tk_optionMenu $maptl.spaceEdit.newExit.waTyIm.type \
	[set maptl].spaceEdit.newExit(exType) Doorway \
	Door LockedDoor SecretDoor OnewayDoor TrapDoorUp TrapDoorDown \
	StairsUp StairsDown WindowUnglazed WindowGlazed Chimney \
	Pit

  # build widget $maptl.spaceEdit.newExit.waTyIm.l2
  label $maptl.spaceEdit.newExit.waTyIm.l2 -text {Image:}

  # build widget $maptl.spaceEdit.newExit.waTyIm.image
  entry $maptl.spaceEdit.newExit.waTyIm.image \
    -textvariable "[set maptl].spaceEdit.newExit(image)"

  # build widget $maptl.spaceEdit.newExit.waTyIm.imageB
  button $maptl.spaceEdit.newExit.waTyIm.imageB \
    -text {Browse} \
    -command [list BrowseImageGif \
		   $maptl.spaceEdit.newExit.waTyIm.image \
		   "Select GIF file to use for exit"]

  # build widget $maptl.spaceEdit.newExit.description
  frame $maptl.spaceEdit.newExit.description \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $maptl.spaceEdit.newExit.description.scrollbar1
  scrollbar $maptl.spaceEdit.newExit.description.scrollbar1 \
    -command "$maptl.spaceEdit.newExit.description.value yview"

  # build widget $maptl.spaceEdit.newExit.description.value
  text $maptl.spaceEdit.newExit.description.value \
    -height {6} \
    -width {40} \
    -wrap {word} \
    -yscrollcommand "$maptl.spaceEdit.newExit.description.scrollbar1 set"

  # build widget $maptl.spaceEdit.newExit.nextSpace
  frame $maptl.spaceEdit.newExit.nextSpace \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $maptl.spaceEdit.newExit.nextSpace.label14
  label $maptl.spaceEdit.newExit.nextSpace.label14 \
    -text {Next Space:}

  # build widget $maptl.spaceEdit.newExit.nextSpace.nextSpace
  entry $maptl.spaceEdit.newExit.nextSpace.nextSpace \
    -textvariable "[set maptl].spaceEdit.newExit(nextSpace)"

  # build widget $maptl.spaceEdit.newExit.nextSpace.button
  button $maptl.spaceEdit.newExit.nextSpace.button \
    -text {Compute Next Space} \
    -command [list ComputeNextSpace $maptl $sp $level]

  # build widget $maptl.spaceEdit.newExit.buttons
  frame $maptl.spaceEdit.newExit.buttons \
    -borderwidth {2}

  # build widget $maptl.spaceEdit.newExit.buttons.button16
  button $maptl.spaceEdit.newExit.buttons.button16 \
    -padx {9} \
    -pady {3} \
    -text {Ok} \
    -command [list NewExitOk $maptl $sp]

  # build widget $maptl.spaceEdit.newExit.buttons.button17
  button $maptl.spaceEdit.newExit.buttons.button17 \
    -padx {9} \
    -pady {3} \
    -text {Cancel} \
    -command [list NewExitCancel $maptl]

  # build widget $maptl.spaceEdit.newExit.buttons.button18
  button $maptl.spaceEdit.newExit.buttons.button18 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {HelpTopic {Creating New Exit dialog box}}

  # pack master $maptl.spaceEdit.newExit.labelXY
  pack configure $maptl.spaceEdit.newExit.labelXY.label5 \
    -side left
  pack configure $maptl.spaceEdit.newExit.labelXY.label6 \
    -side left
  pack configure $maptl.spaceEdit.newExit.labelXY.xc \
    -expand 1 \
    -fill x \
    -side left
  pack configure $maptl.spaceEdit.newExit.labelXY.label8 \
    -side left
  pack configure $maptl.spaceEdit.newExit.labelXY.yc \
    -expand 1 \
    -fill x \
    -side left

  # pack master $maptl.spaceEdit.newExit.waTyIm
  pack configure $maptl.spaceEdit.newExit.waTyIm.wallAligned \
    -side left
  pack configure $maptl.spaceEdit.newExit.waTyIm.l1 -side left
  pack configure $maptl.spaceEdit.newExit.waTyIm.type \
    -side left
  pack configure $maptl.spaceEdit.newExit.waTyIm.l2 -side left
  pack configure $maptl.spaceEdit.newExit.waTyIm.image \
    -expand 1 \
    -fill x \
    -side left
  pack configure $maptl.spaceEdit.newExit.waTyIm.imageB \
    -side right

  # pack master $maptl.spaceEdit.newExit.description
  pack configure $maptl.spaceEdit.newExit.description.scrollbar1 \
    -fill y \
    -side right
  pack configure $maptl.spaceEdit.newExit.description.value \
    -expand 1 \
    -fill both

  # pack master $maptl.spaceEdit.newExit.nextSpace
  pack configure $maptl.spaceEdit.newExit.nextSpace.label14 \
    -side left
  pack configure $maptl.spaceEdit.newExit.nextSpace.nextSpace \
    -expand 1 \
    -fill x \
    -side left
  pack configure $maptl.spaceEdit.newExit.nextSpace.button \
    -side right

  # pack master $maptl.spaceEdit.newExit.buttons
  pack configure $maptl.spaceEdit.newExit.buttons.button16 \
    -expand 1 \
    -side left
  pack configure $maptl.spaceEdit.newExit.buttons.button17 \
    -expand 1 \
    -side left
  pack configure $maptl.spaceEdit.newExit.buttons.button18 \
    -expand 1 \
    -side right

  # pack master $maptl.spaceEdit.newExit
  pack configure $maptl.spaceEdit.newExit.labelXY \
    -fill x
  pack configure $maptl.spaceEdit.newExit.waTyIm \
    -fill x
  pack configure $maptl.spaceEdit.newExit.description \
    -fill both
  pack configure $maptl.spaceEdit.newExit.nextSpace \
    -fill x
  pack configure $maptl.spaceEdit.newExit.buttons \
    -fill x

  set exitData(centerX) 0
  set exitData(centerY) 0
  set exitData(exType) Doorway
  set exitData(image) {}
  set exitData(nextSpace) {}

#  $maptl.spaceEdit.newExit.labelXY.xc insert end {0}
#  $maptl.spaceEdit.newExit.labelXY.yc insert end {0}
#  $maptl.spaceEdit.newExit.waTyIm.image insert end {}
#  $maptl.spaceEdit.newExit.description.value insert end {}
#  $maptl.spaceEdit.newExit.nextSpace.nextSpace insert end {}


# end of widget tree

  
}

proc NewExitCancel {maptl} {
# Procedure bound to the Cancel button on the Add Exit dialog
# <in> maptl -- the map toplevel.
# [index] NewExitCancel!procedure

  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $maptl.spaceEdit.newExit"
  } {
    catch "destroy $maptl.spaceEdit.newExit"
  }
  global $maptl.spaceEdit.newExit
  unset $maptl.spaceEdit.newExit
}

proc NewExitOk {maptl sp} {
# Procedure bound to the Ok button on the Add Exit dialog
# <in> maptl -- the map toplevel.
# [index] NewExitOk!procedure

  upvar #0 $maptl data
  upvar #0 $maptl.spaceEdit spaceData
  upvar #0 $maptl.spaceEdit.newExit exitData

# Insert the new exit
  $sp InsertNewExit Exit::$exitData(exType) $exitData(centerX) \
	$exitData(centerY) $exitData(WallAlignedP) \
	"[$maptl.spaceEdit.newExit.description.value get 1.0 end-1c]" \
	"$exitData(image)" "$exitData(nextSpace)"
  set spaceData(dirty) 1

  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $maptl.spaceEdit.newExit"
  } {
    catch "destroy $maptl.spaceEdit.newExit"
  }
# Draw the new exit
  set canvas $maptl.spaceEdit.viewFrame.view
  set lastExI [expr [$sp NumberOfExits] - 1]
  set lb $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.lbFrame.list
  set lastEx [$sp IndexedExit $lastExI]
  if {[string length "[info command $lastEx]"] == 0} {set lastEx [Exit -this $lastEx]}
  $lb insert end "$lastExI [$lastEx Type] at [$lastEx XCenter],[$lastEx YCenter]"
  set id [$canvas create image [expr [$lastEx XCenter] + [$sp CenterX]] \
			       [expr [$lastEx YCenter] + [$sp CenterY]] \
			       -image [image create photo -file [$lastEx Image]]]
  $canvas bind $id <1> [list SelectLbEnB $maptl.spaceEdit.viewFrame.lists.exits $lastExI]
  global tcl_platform
  if {"$tcl_platform(platform)" == "macintosh"} {
    set EdEvent <Command-Button-1>
  } else {
    set EdEvent <3>
  }
  $canvas bind $id $EdEvent [list VisitExit $sp $lastExI $maptl.spaceEdit]
  set spaceData(ExitGrIds,$lastExI) $id
  global $maptl.spaceEdit.newExit
  unset $maptl.spaceEdit.newExit
}

proc DeleteExit {maptl sp} {
# This procedure deletes an Exit.  Bound to the Delete button under the Exit
# list.
# <in> maptl -- the map toplevel.
# <in> sp -- the space object.
# [index] DeleteExit!procedure

  upvar #0 $maptl data
  upvar #0 $maptl.spaceEdit spaceData
  set lb $maptl.spaceEdit.viewFrame.lists.exits.lbFrame.lbYscroll.lbFrame.list
  set deb $maptl.spaceEdit.viewFrame.lists.exits.buttons.deleteButton
  set canvas $maptl.spaceEdit.viewFrame.view
  $deb configure -state disabled
  set curExit "[$lb curselection]"
  if {[string length "$curExit"] == 0} {return}
  set spaceData(dirty) 1
  set theExit "[$lb get $curExit]"
  $lb delete $curExit
  set i [lindex "$theExit" 0]
  set Ex [$sp IndexedExit $i]
  if {[string length "[info command $Ex]"] == 0} {set Ex [Exit -this $Ex]}
  $sp DeleteExitAtIndex $i
  rename $Ex {}
  $canvas delete $spaceData(ExitGrIds,$i)
  if {[$lb size] <= $curExit} {
    unset spaceData(ExitGrIds,$curExit)
    return
  }
  set uppers "[$lb get $curExit end]"
  $lb delete $curExit end
  set i $curExit
  foreach u $uppers {
    set sp [string first { } "$u"]
    set tail [string range "$u" $sp end]
    $lb insert end "$i$tail"
    set oldI [lindex "$u" 0]
    set spaceData(ExitGrIds,$i) $spaceData(ExitGrIds,$oldI)
    incr i
  }
  unset spaceData(ExitGrIds,$oldI)
}

proc DeleteItem {maptl sp} {
# This procedure deletes an Item.  Bound to the Delete button under the Item
# list.
# <in> maptl -- the map toplevel.
# <in> sp -- the space object.
# [index] DeleteItem!procedure

  upvar #0 $maptl data
  upvar #0 $maptl.spaceEdit spaceData
  set lb $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.lbFrame.list
  set deb $maptl.spaceEdit.viewFrame.lists.items.buttons.deleteButton
  set canvas $maptl.spaceEdit.viewFrame.view
  $deb configure -state disabled
  set curItem "[$lb curselection]"
  if {[string length "$curItem"] == 0} {return}
  set spaceData(dirty) 1
  set theItem "[$lb get $curItem]"
  $lb delete $curItem
  set i [lindex "$theItem" 0]
  set It [$sp IndexedItem $i]
  if {[string length "[info command $It]"] == 0} {set It [Item -this $It]}
  $sp DeleteItemAtIndex $i
  rename $It {}
  $canvas delete $spaceData(ItemGrIds,$i)
  if {[$lb size] <= $curItem} {
    unset spaceData(ItemGrIds,$curItem)
    return
  }
  set uppers "[$lb get $curItem end]"
  $lb delete $curItem end
  set i $curItem
  foreach u $uppers {
    set sp [string first { } "$u"]
    set tail [string range "$u" $sp end]
    $lb insert end "$i$tail"
    set oldI [lindex "$u" 0]
    set spaceData(ItemGrIds,$i) $spaceData(ItemGrIds,$oldI)
    incr i
  }
  unset spaceData(ItemGrIds,$oldI)
}


proc AddItem {maptl sp} {
# This procedure adds a new item to the space.
# <in> maptl -- the map toplevel.
# <in> sp -- the space object.
# [index] AddItem!procedure

  upvar #0 $maptl data
  upvar #0 $maptl.spaceEdit.newItem itemData
  global $maptl.spaceEdit.newItem

  if {[winfo exists $maptl.spaceEdit.newItem]} {return}
  set itemData(dirty) 0

  # build widget $maptl.spaceEdit.newItem
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $maptl.spaceEdit.newItem"
  } {
    catch "destroy $maptl.spaceEdit.newItem"
  }
  toplevel $maptl.spaceEdit.newItem 

  # Window manager configurations
  wm positionfrom $maptl.spaceEdit.newItem ""
  wm sizefrom $maptl.spaceEdit.newItem ""
  wm maxsize $maptl.spaceEdit.newItem 1000 1000
  wm minsize $maptl.spaceEdit.newItem 10 10
  wm protocol $maptl.spaceEdit.newItem WM_DELETE_WINDOW { }
  wm title $maptl.spaceEdit.newItem {Creating Iew Item...}
  wm transient $maptl.spaceEdit.newItem $maptl.spaceEdit


  # build widget $maptl.spaceEdit.newItem.labelXY
  frame $maptl.spaceEdit.newItem.labelXY \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $maptl.spaceEdit.newItem.labelXY.label5
  label $maptl.spaceEdit.newItem.labelXY.label5 \
    -text {Item}

  # build widget $maptl.spaceEdit.newItem.labelXY.label6
  label $maptl.spaceEdit.newItem.labelXY.label6 \
    -text {X:}

  # build widget $maptl.spaceEdit.newItem.labelXY.xc
  entry $maptl.spaceEdit.newItem.labelXY.xc \
    -width {5} \
    -textvariable "[set maptl].spaceEdit.newItem(centerX)"
  bindtags $maptl.spaceEdit.newItem.labelXY.xc \
	[list $maptl.spaceEdit.newItem.labelXY.xc Entry $maptl.spaceEdit.newItem all FloatEntry]


  # build widget $maptl.spaceEdit.newItem.labelXY.label8
  label $maptl.spaceEdit.newItem.labelXY.label8 \
    -text {Y:}

  # build widget $maptl.spaceEdit.newItem.labelXY.yc
  entry $maptl.spaceEdit.newItem.labelXY.yc \
    -width {5} \
    -textvariable "[set maptl].spaceEdit.newItem(centerY)"
  bindtags $maptl.spaceEdit.newItem.labelXY.yc \
	[list $maptl.spaceEdit.newItem.labelXY.yc Entry $maptl.spaceEdit.newItem all FloatEntry]

  # build widget $maptl.spaceEdit.newItem.type
  frame $maptl.spaceEdit.newItem.type \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $maptl.spaceEdit.newItem.type.label10
  label $maptl.spaceEdit.newItem.type.label10 \
    -text {Type:}

  # build widget $maptl.spaceEdit.newItem.type.value
  tk_optionMenu $maptl.spaceEdit.newItem.type.value \
    [set maptl].spaceEdit.newItem(itType) \
    Character Monster Treasure TrickTrap Dressing

  # build widget $maptl.spaceEdit.newItem.filename
  frame $maptl.spaceEdit.newItem.filename \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $maptl.spaceEdit.newItem.filename.label12
  label $maptl.spaceEdit.newItem.filename.label12 \
    -text {File:}

  # build widget $maptl.spaceEdit.newItem.filename.value
  entry $maptl.spaceEdit.newItem.filename.value \
    -textvariable "[set maptl].spaceEdit.newItem(filename)"

  # build widget $maptl.spaceEdit.newItem.filename.button14
  button $maptl.spaceEdit.newItem.filename.button14 \
    -padx {9} \
    -pady {3} \
    -text {Browse} \
    -command [list BrowseItemFile $maptl.spaceEdit.newItem.filename.value \
    		   $maptl.spaceEdit.newItem]

  # build widget $maptl.spaceEdit.newItem.buttons
  frame $maptl.spaceEdit.newItem.buttons \
    -borderwidth {2}

  # build widget $maptl.spaceEdit.newItem.buttons.button15
  button $maptl.spaceEdit.newItem.buttons.button15 \
    -padx {9} \
    -pady {3} \
    -text {OK} \
    -command [list NewItemOk $maptl $sp]

  # build widget $maptl.spaceEdit.newItem.buttons.button16
  button $maptl.spaceEdit.newItem.buttons.button16 \
    -padx {9} \
    -pady {3} \
    -text {Cancel} \
    -command [list NewItemCancel $maptl]

  # build widget $maptl.spaceEdit.newItem.buttons.button17
  button $maptl.spaceEdit.newItem.buttons.button17 \
    -padx {9} \
    -pady {3} \
    -text {Help} \
    -command {HelpTopic {Creating New Item dialog box}}

  # build widget $maptl.spaceEdit.newItem.image
  frame $maptl.spaceEdit.newItem.image \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $maptl.spaceEdit.newItem.image.label1
  label $maptl.spaceEdit.newItem.image.label1 \
    -text {Image:}

  # build widget $maptl.spaceEdit.newItem.image.value
  entry $maptl.spaceEdit.newItem.image.value \
    -textvariable "[set maptl].spaceEdit.newItem(image)"

  # build widget $maptl.spaceEdit.newItem.image.button3
  button $maptl.spaceEdit.newItem.image.button3 \
    -padx {9} \
    -pady {3} \
    -text {Browse} \
    -command [list BrowseImageGif \
		   $maptl.spaceEdit.newItem.image.value \
		   "Select GIF file to use for item"]

  # pack master $maptl.spaceEdit.newItem.labelXY
  pack configure $maptl.spaceEdit.newItem.labelXY.label5 \
    -side left
  pack configure $maptl.spaceEdit.newItem.labelXY.label6 \
    -side left
  pack configure $maptl.spaceEdit.newItem.labelXY.xc \
    -expand 1 \
    -fill x \
    -side left
  pack configure $maptl.spaceEdit.newItem.labelXY.label8 \
    -side left
  pack configure $maptl.spaceEdit.newItem.labelXY.yc \
    -expand 1 \
    -fill x \
    -side left

  # pack master $maptl.spaceEdit.newItem.type
  pack configure $maptl.spaceEdit.newItem.type.label10 \
    -side left
  pack configure $maptl.spaceEdit.newItem.type.value \
    -expand 1 \
    -fill both \
    -side left

  # pack master $maptl.spaceEdit.newItem.filename
  pack configure $maptl.spaceEdit.newItem.filename.label12 \
    -side left
  pack configure $maptl.spaceEdit.newItem.filename.value \
    -expand 1 \
    -fill x \
    -side left
  pack configure $maptl.spaceEdit.newItem.filename.button14 \
    -side right

  # pack master $maptl.spaceEdit.newItem.buttons
  pack configure $maptl.spaceEdit.newItem.buttons.button15 \
    -expand 1 \
    -side left
  pack configure $maptl.spaceEdit.newItem.buttons.button16 \
    -expand 1 \
    -side left
  pack configure $maptl.spaceEdit.newItem.buttons.button17 \
    -expand 1 \
    -side right

  # pack master $maptl.spaceEdit.newItem.image
  pack configure $maptl.spaceEdit.newItem.image.label1 \
    -side left
  pack configure $maptl.spaceEdit.newItem.image.value \
    -expand 1 \
    -fill x \
    -side left
  pack configure $maptl.spaceEdit.newItem.image.button3 \
    -side right

  # pack master $maptl.spaceEdit.newItem
  pack configure $maptl.spaceEdit.newItem.labelXY \
    -fill x
  pack configure $maptl.spaceEdit.newItem.type \
    -fill x
  pack configure $maptl.spaceEdit.newItem.image \
    -fill x
  pack configure $maptl.spaceEdit.newItem.filename \
    -fill x
  pack configure $maptl.spaceEdit.newItem.buttons \
    -fill x

  set itemData(centerX) 0
  set itemData(centerY) 0
  set itemData(filename) {}
  set itemData(image) {}
  set itemData(itType) Character

#  $maptl.spaceEdit.newItem.labelXY.xc insert end {0}
#  $maptl.spaceEdit.newItem.labelXY.yc insert end {0}
#  $maptl.spaceEdit.newItem.filename.value insert end {}
#  $maptl.spaceEdit.newItem.image.value insert end {}


# end of widget tree


}

proc NewItemCancel {maptl} {
# Procedure bound to the Cancel button on the Add Item dialog
# <in> maptl -- the map toplevel.
# [index] NewItemCancel!procedure

  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $maptl.spaceEdit.newItem"
  } {
    catch "destroy $maptl.spaceEdit.newItem"
  }

  global $maptl.spaceEdit.newItem
  unset $maptl.spaceEdit.newItem
}

proc NewItemOk {maptl sp} {
# Procedure bound to the Ok button on the Add Item dialog
# <in> maptl -- the map toplevel.
# [index] NewItemOk!procedure

  upvar #0 $maptl data
  upvar #0 $maptl.spaceEdit spaceData
  upvar #0 $maptl.spaceEdit.newItem itemData

# Insert the new item
  $sp InsertNewItem Item::$itemData(itType) $itemData(centerX) \
	$itemData(centerY) "$itemData(image)" "$itemData(filename)"
  set spaceData(dirty) 1

  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $maptl.spaceEdit.newItem"
  } {
    catch "destroy $maptl.spaceEdit.newItem"
  }
# Draw the new item
  set canvas $maptl.spaceEdit.viewFrame.view
  set lastItI [expr [$sp NumberOfItems] - 1]
  set lb $maptl.spaceEdit.viewFrame.lists.items.lbFrame.lbYscroll.lbFrame.list
  set lastIt [$sp IndexedItem $lastItI]
  if {[string length "[info command $lastIt]"] == 0} {set lastIt [Item -this $lastIt]}
  $lb insert end "$lastItI [$lastIt Type] at [$lastIt XCenter],[$lastIt YCenter]"
  set id [$canvas create image [expr [$lastIt XCenter] + [$sp CenterX]] \
			       [expr [$lastIt YCenter] + [$sp CenterY]] \
			       -image [image create photo -file [$lastIt Image]]]

  $canvas bind $id <1> [list SelectLbEnB $maptl.spaceEdit.viewFrame.lists.items $lastItI]
  global tcl_platform
  if {"$tcl_platform(platform)" == "macintosh"} {
    set EdEvent <Command-Button-1>
  } else {
    set EdEvent <3>
  }
  $canvas bind $id $EdEvent [list VisitItem $sp $lastItI]
  set spaceData(ItemGrIds,$lastItI) $id
  global $maptl.spaceEdit.newItem
  unset $maptl.spaceEdit.newItem
}

proc VisitItem {sp i} {
# Procedure to visit the selected item. Bound to the right button (or Command 
# button on the Mac).
# <in> sp -- the space.
# <in> i -- the item index.
# [index] VisitItem!procedure

  set item [$sp IndexedItem $i]
  if {[string length "[info command $item]"] == 0} {set item [Item -this $item]}
  switch -exact -- "[$item Type]" {
    Item::Character {RPGEdCharacter "[$item Filename]"}
    Item::Monster   {RPGEdMonster   "[$item Filename]"}
    Item::Treasure  {RPGEdTreasure  "[$item Filename]"}
    Item::TrickTrap {RPGEdTrickTrap "[$item Filename]"}
    Item::Dressing  {RPGEdDressing  "[$item Filename]"}
  }
}

proc VisitExit {sp i {parent {}}} {
# Procedure to visit the selected edit. Bound to the right button (or Command 
# button on the Mac).
# <in> sp -- the space.
# <in> i -- the exit index.
# [index] VisitExit!procedure

  set exit [$sp IndexedExit $i]
  if {[string length "[info command $exit]"] == 0} {set exit [Exit -this $exit]}

  # build widget $parent.visitExit
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $parent.visitExit"
  } {
    catch "destroy $parent.visitExit"
  }
  toplevel $parent.visitExit 

  # Window manager configurations
  wm positionfrom $parent.visitExit ""
  wm sizefrom $parent.visitExit ""
  wm maxsize $parent.visitExit 1000 1000
  wm minsize $parent.visitExit 10 10
  wm title $parent.visitExit {Exit Information}
  wm transient $parent.visitExit [winfo toplevel [winfo parent $parent.visitExit]]

  # build widget $parent.visitExit.ident
  frame $parent.visitExit.ident \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $parent.visitExit.ident.label5
  label $parent.visitExit.ident.label5 \
    -text {Type:}

  # build widget $parent.visitExit.ident.type
  label $parent.visitExit.ident.type \
    -relief {sunken} \
    -text "[$exit Type]"

  # build widget $parent.visitExit.ident.label7
  label $parent.visitExit.ident.label7 \
    -text {X:}

  # build widget $parent.visitExit.ident.x
  label $parent.visitExit.ident.x \
    -relief {sunken} \
    -text "[$exit XCenter]"

  # build widget $parent.visitExit.ident.label9
  label $parent.visitExit.ident.label9 \
    -text {Y:}

  # build widget $parent.visitExit.ident.y
  label $parent.visitExit.ident.y \
    -relief {sunken} \
    -text "[$exit YCenter]"

  # build widget $parent.visitExit.description
  frame $parent.visitExit.description \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $parent.visitExit.description.scrollbar1
  scrollbar $parent.visitExit.description.scrollbar1 \
    -command "$parent.visitExit.description.value yview"

  # build widget $parent.visitExit.description.value
  text $parent.visitExit.description.value \
    -height {5} \
    -width {40} \
    -wrap {word} \
    -yscrollcommand "$parent.visitExit.description.scrollbar1 set"
  # bindings
  bind $parent.visitExit.description.value <Key> {break}
  bind $parent.visitExit.description.value <<Cut>> {break}
  bind $parent.visitExit.description.value <<Paste>> {break}
  bind $parent.visitExit.description.value <ButtonRelease-2> {break}

  # build widget $parent.visitExit.image
  frame $parent.visitExit.image \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $parent.visitExit.image.label11
  label $parent.visitExit.image.label11 \
    -text {Image:}

  # build widget $parent.visitExit.image.image
  label $parent.visitExit.image.image \
    -relief {sunken} \
    -text "[$exit Image]"


  # build widget $parent.visitExit.next
  frame $parent.visitExit.next \
    -borderwidth {2} \
    -relief {ridge}

  # build widget $parent.visitExit.next.label13
  label $parent.visitExit.next.label13 \
    -text {Next Space:}

  # build widget $parent.visitExit.next.next
  label $parent.visitExit.next.next \
    -relief {sunken} \
    -text "[$exit NextSpaceIndexString]"

  # build widget $parent.visitExit.button4
  button $parent.visitExit.button4 \
    -padx {9} \
    -pady {3} \
    -text {Dismiss} \
    -command [list DismissVisitExit $parent.visitExit]

  # pack master $parent.visitExit.ident
  pack configure $parent.visitExit.ident.label5 \
    -side left
  pack configure $parent.visitExit.ident.type \
    -expand 1 \
    -fill x \
    -side left
  pack configure $parent.visitExit.ident.label7 \
    -side left
  pack configure $parent.visitExit.ident.x \
    -expand 1 \
    -fill x \
    -side left
  pack configure $parent.visitExit.ident.label9 \
    -side left
  pack configure $parent.visitExit.ident.y \
    -expand 1 \
    -fill x \
    -side left

  # pack master $parent.visitExit.description
  pack configure $parent.visitExit.description.scrollbar1 \
    -fill y \
    -side right
  pack configure $parent.visitExit.description.value \
    -expand 1 \
    -fill both

  # pack master $parent.visitExit.image
  pack configure $parent.visitExit.image.label11 \
    -side left
  pack configure $parent.visitExit.image.image \
    -expand 1 \
    -fill x \
    -side right

  # pack master $parent.visitExit.next
  pack configure $parent.visitExit.next.label13 \
    -side left
  pack configure $parent.visitExit.next.next \
    -expand 1 \
    -fill x \
    -side right

  # pack master $parent.visitExit
  pack configure $parent.visitExit.ident \
    -fill x
  pack configure $parent.visitExit.description \
    -fill both
  pack configure $parent.visitExit.image \
    -fill x
  pack configure $parent.visitExit.next \
    -fill x
  pack configure $parent.visitExit.button4 \
    -expand 1 \
    -fill x

  $parent.visitExit.description.value insert end "[$exit Description]"


# end of widget tree



}

proc DismissVisitExit {tl} {
# Procedure bound to the Dismiss button on the visit Exit dialog.
# <in> tl -- the dialog box widget.
# [index] DismissVisitExit!procedure

  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy $tl"
  } {
    catch "destroy $tl"
  }
}

proc BrowseImageGif {entry title} {
# Procedure to browse for a GIF file for an item or exit.
# <in> entry -- entry widget where the file name is.
# <in> title -- title text to use.
# [index] BrowseImageGif!procedure

  set oldName "[$entry get]"
  set newName [tk_getOpenFile -defaultextension .gif \
			      -filetypes { {{GIF Files} {.gif .GIF} GIFf } } \
			      -initialdir [pwd] \
			      -initialfile "$oldName" \
			      -parent [winfo toplevel $entry] \
			      -title "$title"]
  if {[string compare "$newName" {}] == 0} {return}
  $entry delete 0 end
  $entry insert end "$newName"
}

proc BrowseItemFile {entry base} {
# Procedure to browse for an item file for an item.
# <in> entry -- entry widget where the file name is.
# <in> title -- title text to use.
# [index] BrowseItemFile!procedure

  upvar #0 $base itemData

  switch -exact -- "$itemData(itType)" {
    Character {
	set fType { {{Character Files} {.character}} }
	set dExt {.character}
    }
    Monster {
	set fType { {{Monster Files} {.monster}} }
	set dExt {.monster}
    }
    Treasure {
	set fType { {{Treasure Files} {.treasure}} }
	set dExt {.treasure}
    }
    TrickTrap {
	set fType { {{Trick / Trap Files} {.tricktrap}} }
	set dExt {.tricktrap}
    }
    Dressing {
	set fType { {{Dressing Files} {.dressing}} }
	set dExt {.dressing}
    }
  }
  set oldName "[$entry get]"
  set newName [tk_getOpenFile -defaultextension "$dExt" \
			      -filetypes "$fType" \
			      -initialdir [pwd] \
			      -initialfile "$oldName" \
			      -parent [winfo toplevel $entry] \
			      -title "Select item file"]
  if {[string compare "$newName" {}] == 0} {return}
  $entry delete 0 end
  $entry insert end "$newName"
}


proc ComputeNextSpace {maptl sp level} {
# Procedure to compute the next space for an exit.  This code is somewhat
# approximate -- there are situations where the results might need manual
# adjustments.
# <in> maptl -- the map toplevel.
# <in> sp -- the current space object.
# <in> level -- the level that the space is on.
# [index] ComputeNextSpace!procedure

  upvar #0 $maptl data
  upvar #0 $maptl.spaceEdit.newExit exitData

  set exx $exitData(centerX)
  set exy $exitData(centerY)
  set type $exitData(exType)
  set spx [$sp CenterX]
  set spy [$sp CenterY]
  if {[info exists GeoConstants_Width] == 0} {
    catch [list GeoConstants]
  }
  global GeoConstants_Width GeoConstants_HexSideLength GeoConstants_HexPeakHeight

  switch -glob -- "$type" {
    TrapDoorUp -
    Chimney -
    *Up {set nsp "[expr $level - 1],$spx,$spy"}
    TrapDoorDown -
    Pit -
    *Down {set nsp "[expr $level + 1],$spx,$spy"}
    Window* -
    Door -
    Doorway -
    *Door {
	set nsp "$level,"
	if {"[$sp Shape]" == {Space::Hexagon}} {
	  set exxA [expr $spx + $exx]
	  set exyA [expr $spy + $exy]
	  set points [lrange [$sp MakeGraphicCommannd 1] 1 14]
	  set canvas $maptl.spaceEdit.viewFrame.view
	  set found 0
	  foreach cI {{0 3} {2 5} {4 7} {6 9} {8 11} {10 13}} \
		  dcx {-1 -.5 .5 1 .5 -.5} \
		  dcy { 0  -1 -1 0  1   1} {
	    set lcoords [lrange $points [lindex $cI 0] [lindex $cI 1]]
	    set lid [eval [concat $canvas create line $lcoords -fill blue]]
	    set foundid [$canvas find closest $exxA $exyA 1]
#	    update
#	    tk_dialog  $maptl.spaceEdit.newExit.debug "Debug" \
#		"lcoords = $lcoords, lid = $lid, foundid = $foundid" \
#		info 0 Ok
	    $canvas delete $lid
	    if {$foundid == $lid} {
	      set TheDcx $dcx
	      set TheDcy $dcy
	      set found 1
	      break
	    }
	  }
	  if {$found == 1} {
	    append nsp "[expr $spx + ($GeoConstants_Width * $TheDcx)],"
	    append nsp "[expr $spy + (($GeoConstants_HexSideLength + \
				       $GeoConstants_HexPeakHeight) * $TheDcy)]"
	  } else {
	    append nsp "$spx,$spy"
	  }
	} else {
	  set nspx $spx
	  set nspy $spy
	  if {[expr abs(abs($exx) - ($GeoConstants_Width / 2.0))] < .0001} {
	    if {$exx > 0} {
	      set nspx [expr $spx + $GeoConstants_Width]
	    } else {
	      set nspx [expr $spx - $GeoConstants_Width]
	    }
	  }
	  append nsp "$nspx,"
	  if {[expr abs(abs($exy) - ($GeoConstants_Width / 2.0))] < .0001} {
	    if {$exy > 0} {
	      set nspy [expr $spy + $GeoConstants_Width]
	    } else {
	      set nspy [expr $spy - $GeoConstants_Width]
	    }
	  }
	  append nsp "$nspy"
	}
    }
  }
  set exitData(nextSpace) "$nsp"
}

package provide RPGEdSpace 1.0


