#include "allegro.h"
#include "gunobj.h"
#include "gun_angle.h"
#include "weapon_angle.h"
#include "hull_weapon_angle.h"
#include "trigtable.h"
#include "ebox.h"

#define MAX_ANGLE_SHADE 20

WeaponAngle::WeaponAngle( int z, int d, int al ):
WeaponObject( d, "Taurus Gun", 145000, al, z, 4 ) {
	//strength = z;
	shade = new int[ MAX_ANGLE_SHADE ];

	BITMAP * temp = create_bitmap( 6, 6 );
	clear_to_color( temp, makecol(255,0,255) );
	circlefill( temp, 3, 3, 2, makecol(255,0,0) );
	ecollide = new ECollide( temp, 2, makecol(255,0,255), 30.0 );
	destroy_bitmap( temp );

}


WeaponAngle::~WeaponAngle() {
	delete[] shade;
	delete ecollide;
}


WeaponObject * WeaponAngle::copy() {
	return new WeaponAngle( strength, dir, alignment );
}


void WeaponAngle::MakeShot(int x, int y, vector< SpaceObject * > * Ammo, vector< SpaceObject * > * fight ) {

	shot_counter = 13;

	int r1, g1, b1, r2, g2, b2;

	r1 = (255-(strength+1)*13+256)%256;
	g1 = (90+(strength+1)*2+256)%256;
	b1 = (20+(strength+1)*6+256)%256;

	r2 = (r1-(strength+1)*11+256)%256;
	g2 = (g1+(strength+1)*8+256)%256;
	b2 = (b1+(strength+1)*19+256)%256;

	blend_palette( shade, MAX_ANGLE_SHADE/2, makecol(r1,g1,b1), makecol(r2,g2,b2) );
	blend_palette( shade+MAX_ANGLE_SHADE/2, MAX_ANGLE_SHADE-MAX_ANGLE_SHADE/2, makecol(r2,g2,b2), makecol(r1,g1,b1) );

	int color = 0;
	for ( int q = 0; q < 360; q+= 8, color = (color+1) % MAX_ANGLE_SHADE )
		Ammo->push_back( new Angle( x, y, 0, -1.65, new Angle_WHull( 3*(strength+1), shade[color], ecollide->copy() ), alignment, (q)%360 ) );

}


#undef MAX_ANGLE_SHADE
