

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Calendars.i,v 1.11 2002/01/16 14:51:30 nando Exp $

#ifndef quantlib_calendar_i
#define quantlib_calendar_i

%include Date.i
%include String.i

// typemap rolling conventions to corresponding strings

%{
using QuantLib::RollingConvention;
using QuantLib::Following;
using QuantLib::ModifiedFollowing;
using QuantLib::Preceding;
using QuantLib::ModifiedPreceding;
using QuantLib::StringFormatter;
%}

%typemap(ruby,in) RollingConvention (RollingConvention temp),
                  const RollingConvention & (RollingConvention temp) {
    if (TYPE($source) == T_STRING) {
        std::string s(STR2CSTR($source));
        s = StringFormatter::toLowercase(s);
        if (s == "fol" || s == "following")
            temp = Following;
        else if (s == "modfol" || s == "modifiedfollowing")
            temp = ModifiedFollowing;
        else if (s == "pre" || s == "preceding")
            temp = Preceding;
        else if (s == "modpre" || s == "modifiedpreceding")
            temp = ModifiedPreceding;
        else
            rb_raise(rb_eTypeError,"not a rolling convention");
    } else {
        rb_raise(rb_eTypeError,"not a rolling convention");
    }
    $target = &temp;
};

%typemap(ruby,out) RollingConvention, const RollingConvention & {
    switch (*$source) {
      case Following:
        $target = rb_str_new2("Following");
        break;
      case ModifiedFollowing:
        $target = rb_str_new2("ModifiedFollowing");
        break;
      case Preceding:
        $target = rb_str_new2("Preceding");
        break;
      case ModifiedPreceding:
        $target = rb_str_new2("ModifiedPreceding");
        break;
    }
};

%typemap(ruby,ret) RollingConvention {
    delete $source;
};

%{
using QuantLib::Calendar;
using QuantLib::Calendars::TARGET;
using QuantLib::Calendars::NewYork;
using QuantLib::Calendars::London;
using QuantLib::Calendars::Milan;
using QuantLib::Calendars::Frankfurt;
using QuantLib::Calendars::Zurich;
using QuantLib::Calendars::Helsinki;
using QuantLib::Calendars::Wellington;
%}

class Calendar {
    %pragma(ruby) include = "Comparable";
  public:
    // constructor redefined below as string-based factory
    ~CalendarHandle();
    bool isBusinessDay(const Date& d);
    %pragma(ruby) pred = "isBusinessDay";
    bool isHoliday(const Date& d);
    %pragma(ruby) pred = "isHoliday";
};

%addmethods Calendar {
    void crash() {}
    Calendar(const String& name) {
        String s = StringFormatter::toLowercase(name);
        if (s == "target" || s == "euro" || s == "eur")
            return new TARGET;
        else if (s == "newyork" || s == "ny" || s == "nyc")
            return new NewYork;
        else if (s == "london" || s == "lon")
            return new London;
        else if (s == "milan" || s == "mil")
            return new Milan;
        else if (s == "frankfurt" || s == "fft")
            return new Frankfurt;
        else if (s == "zurich" || s == "zur")
            return new Zurich;
        else if (s == "helsinki")
            return new Helsinki;
        else if (s == "wellington")
            return new Wellington;
        else
            throw Error("Unknown calendar: " + name);
        QL_DUMMY_RETURN((Calendar*)(0));
    }
    Date _rollWithConvention(const Date& d, RollingConvention convention) {
        return self->roll(d,convention);
    }
    Date _advanceWithConvention(const Date& d, int n, TimeUnit unit,
        RollingConvention convention) {
            return self->advance(d,n,unit,convention);
    }
    String __str__() {
        return self->name()+" calendar";
    }
    int __cmp__(const Calendar& other) {
        return (*self == other ? 0 : 1);
    }
}


#endif
