/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2005-2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#include <stdio.h>
#include <stdlib.h>

#include <qpx_transport.h>
#include <qpx_mmc.h>
#include <common_functions.h>

#include "media_check_pioneer.h"

int pioneer_send_cx_scan_command(drive_info* drive, int lba, unsigned char sects)
{
/*
CDB:
00000000  3B 02 E1 00 00 00 00 00 20 00                     ;...... .      

Data Sent:
00000000  FF 01 00 00  00 60 00 00  00 00 4B 00  00 00 4B 00   ...............
00000010  00 00 00 00  00 00 00 00  00 00 00 00  00 00 00 00   ................
*/
	lba += 0x006000;

	int i;
	for (i=0; i<32; i++) drive->rd_buf[i]=0;

	drive->rd_buf[0] = 0xFF;
	drive->rd_buf[1] = 0x01;

	drive->rd_buf[4] = (lba >> 16) & 0xFF;
	drive->rd_buf[5] = (lba >> 8) & 0xFF;
	drive->rd_buf[6] = (lba) & 0xFF;
//	drive->rd_buf[6] = 0x01;

	drive->rd_buf[8] = (sects >> 16) & 0xFF;
	drive->rd_buf[9] = (sects >> 8) & 0xFF;
	drive->rd_buf[10] = sects & 0xFF;
	drive->rd_buf[12] = (sects >> 16) & 0xFF;
	drive->rd_buf[13] = (sects >> 8) & 0xFF;
	drive->rd_buf[14] = sects & 0xFF;
/*
	printf("Pioneer scan Cx CMD data:");
	for (i=0; i<16; i++) {
	    if (!(i%0x20)) printf("\n");
	    printf(" %02X",drive->rd_buf[i] & 0xFF);
	}
	printf("\n");
*/
	drive->cmd_clear();
	drive->cmd[0] = 0x3B;
	drive->cmd[1] = 0x02;
	drive->cmd[2] = 0xE1;
	drive->cmd[8] = 0x20;
	if ((drive->err=drive->cmd.transport(WRITE,drive->rd_buf,32))) {
		sperror ("pioneer_send_scan_cx",drive->err); return 1;
	}
	return 0;
}


int pioneer_send_pi_scan_command(drive_info* drive, int lba, unsigned char nECC)
{
/*
CDB:
00000000  3B 02 E1 00 00 00 00 00 20 00                     ;...... .      

Data Sent:
00000000  FF 01 00 00 03 00 01 00 00 00 80 00 00 00 08 00   ...............
00000010  00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00   ................
*/
	int i;
	int sects = nECC*16;
	lba += 0x030000;

	for (i=0; i<32; i++) drive->rd_buf[i]=0;
	drive->rd_buf[0] = 0xFF;
	drive->rd_buf[1] = 0x01;
	drive->rd_buf[4] = (lba >> 16) & 0xFF;
	drive->rd_buf[5] = (lba >> 8) & 0xFF;
	drive->rd_buf[6] = (lba) & 0xFF;
//	drive->rd_buf[6] = 0x01;

//	drive->rd_buf[9] = 0x01;
//	drive->rd_buf[9] =  (nECC >> 4 ) & 0xFF;
//	drive->rd_buf[10] = (nECC << 4 ) & 0xFF;
//	drive->rd_buf[14] = nECC;
//	drive->rd_buf[14] = 0x08;


//	drive->rd_buf[9]  = (sects >> 8) & 0xFF;
	drive->rd_buf[10] = (sects) & 0xFF;
//	drive->rd_buf[13] = (sects >> 12) & 0xFF;
//	drive->rd_buf[14] = nECC;
	drive->rd_buf[14] = 1;
/*
	printf("Pioneer scan Pi CMD data:");
	for (i=0; i<16; i++) {
	    if (!(i%0x20)) printf("\n");
	    printf(" %02X",drive->rd_buf[i] & 0xFF);
	}
	printf("\n");
*/
	drive->cmd_clear();
	drive->cmd[0] = 0x3B;
	drive->cmd[1] = 0x02;
	drive->cmd[2] = 0xE1;
	drive->cmd[8] = 0x20;
	if ((drive->err=drive->cmd.transport(WRITE,drive->rd_buf,32))) {
		sperror ("pioneer_send_scan_pi",drive->err); return 1;
	}
	return 0;
}


int pioneer_read_error_info(drive_info* drive)
{
	int i;
	for (i=0; i<32; i++) drive->rd_buf[i]=0;
	drive->cmd_clear();
	drive->cmd[0] = 0x3C;
	drive->cmd[1] = 0x02;
	drive->cmd[2] = 0xE1;
	drive->cmd[8] = 0x20;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,32))) {
		sperror ("pioneer_read_error_info",drive->err); return 1;
	}
/*
	printf("Read error info RSP data:");
	for (i=0; i<32; i++) {
	    if (!(i%0x20)) printf("\n");
	    printf(" %02X",drive->rd_buf[i] & 0xFF);
	}
	printf("\n");
*/
	return 0;
}

int pioneer_cx_do_one_interval(drive_info* drive, int* lba, int* BLER,
	int* E11, int* E21, int* E31, int* E12, int* E22, int* E32)
{
	unsigned char interval = 75;
	pioneer_send_cx_scan_command(drive, *lba, interval);
	pioneer_read_error_info(drive);
	if ((swap2(drive->rd_buf+13) > 300) || (swap2(drive->rd_buf+5) > 300)) { *BLER = 0; *E22 = 0; }
	else { *BLER = swap2(drive->rd_buf+13) - swap2(drive->rd_buf+5); *E22 = swap2(drive->rd_buf+5); }
	*E11 = 0; *E21 = 0; *E31 = 0; *E12 = 0; *E32 = 0;
	*lba += interval;
	return 0;
}

int pioneer_pie_pif_do_eight_ecc_blocks(drive_info* drive, int* lba, int* pie, int* pif, int* pof)
{
	const char interval = 8;
	pioneer_send_pi_scan_command(drive, *lba, interval);
	pioneer_read_error_info(drive);
//	*pie = max( 0, (swap2(drive->rd_buf+13) - 1.5 * swap2(drive->rd_buf+5)) / 40);
	if (drive->dev_ID < PIO_DVR_111) {
		*pie = max( 0, (swap2(drive->rd_buf+13) - swap2(drive->rd_buf+5)) / 10);
		*pif = swap2(drive->rd_buf+13) / 200;
	} else {
		*pie = max( 0, (swap2(drive->rd_buf+13) - swap2(drive->rd_buf+5)));
		*pif = swap2(drive->rd_buf+13) / 20;
	}
	*lba+= 16*interval;
	*pof = 0;
	return 0;
}

int pioneer_dummy_start(drive_info* drive)
{
//	drive->err = 0;
	spinup(drive, 2);
	seek(drive, 0);
	return 0;
}

int pioneer_dummy(drive_info* drive)
{
	drive->err = 0;
	return 0;
}

scan_commands commands_list_pioneer = {
	pioneer_dummy_start, 	pioneer_cx_do_one_interval,		pioneer_dummy,
	NULL,			NULL,					NULL,

	NULL,			NULL,					NULL,
	NULL,			NULL,					NULL,
	NULL,			NULL,					NULL,
	pioneer_dummy_start,	pioneer_pie_pif_do_eight_ecc_blocks,	pioneer_dummy,
	NULL,			NULL,					NULL,
};

scan_commands commands_pioneer()  { return commands_list_pioneer; }
