# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class SinkTestList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, sid):
        """
        Initialize the SinkTestList

        :param Version version: Version that contains the resource
        :param sid: A string that uniquely identifies this Sink.

        :returns: twilio.rest.events.v1.sink.sink_test.SinkTestList
        :rtype: twilio.rest.events.v1.sink.sink_test.SinkTestList
        """
        super(SinkTestList, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }
        self._uri = '/Sinks/{sid}/Test'.format(**self._solution)

    def create(self):
        """
        Create the SinkTestInstance

        :returns: The created SinkTestInstance
        :rtype: twilio.rest.events.v1.sink.sink_test.SinkTestInstance
        """
        payload = self._version.create(method='POST', uri=self._uri, )

        return SinkTestInstance(self._version, payload, sid=self._solution['sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Events.V1.SinkTestList>'


class SinkTestPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the SinkTestPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param sid: A string that uniquely identifies this Sink.

        :returns: twilio.rest.events.v1.sink.sink_test.SinkTestPage
        :rtype: twilio.rest.events.v1.sink.sink_test.SinkTestPage
        """
        super(SinkTestPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of SinkTestInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.events.v1.sink.sink_test.SinkTestInstance
        :rtype: twilio.rest.events.v1.sink.sink_test.SinkTestInstance
        """
        return SinkTestInstance(self._version, payload, sid=self._solution['sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Events.V1.SinkTestPage>'


class SinkTestInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, sid):
        """
        Initialize the SinkTestInstance

        :returns: twilio.rest.events.v1.sink.sink_test.SinkTestInstance
        :rtype: twilio.rest.events.v1.sink.sink_test.SinkTestInstance
        """
        super(SinkTestInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {'result': payload.get('result'), }

        # Context
        self._context = None
        self._solution = {'sid': sid, }

    @property
    def result(self):
        """
        :returns: Feedback indicating whether the test event was generated.
        :rtype: unicode
        """
        return self._properties['result']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Events.V1.SinkTestInstance>'
