# KInterbasDB Python Package - Python Module For Python 2.1-incompatible Syntax
#
# Version 3.1
#
# The following contributors hold Copyright (C) over their respective
# portions of code (see license.txt for details):
#
# [Original Author (maintained through version 2.0-0.3.1):]
#   1998-2001 [alex]  Alexander Kuznetsov   <alexan@users.sourceforge.net>
# [Maintainers (after version 2.0-0.3.1):]
#   2001-2002 [maz]   Marek Isalski         <kinterbasdb@maz.nu>
#   2002-2004 [dsr]   David Rushby          <woodsplitter@rocketmail.com>
# [Contributors:]
#   2001      [eac]   Evgeny A. Cherkashin  <eugeneai@icc.ru>
#   2001-2002 [janez] Janez Jere            <janez.jere@void.si>

# This file is a temporary companion of __init__.py to preserve Python 2.1
# compatibility.  Due to Python quirks (__future__ imports must be at the very
# beginning of the module; yield is a keyword), it wasn't possible to use
# yield in a module that tried to be even minimally compatible with Python 2.1.

from __future__ import generators # Maintain compatibility with Python 2.2


def init(mainKGlobals):
    # Give this module access to some members of the main module.
    global DESCRIPTION_NAME
    DESCRIPTION_NAME = mainKGlobals['DESCRIPTION_NAME']


def _RowMapping__iterkeys(self):
    for fieldDesc in self._description:
        yield fieldDesc[DESCRIPTION_NAME]


def _RowMapping__itervalues(self):
    for fieldName in self:
        yield self[fieldName]


def _RowMapping__iteritems(self):
    for fieldName in self:
        yield fieldName, self[fieldName]