# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class AlignMode(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """An optional field, indicating how we align different variables to the same time-range. Either
    Inner or Outer.
    """

    INNER = "Inner"
    OUTER = "Outer"

class AnomalyDetectorErrorCodes(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The error code.
    """

    INVALID_CUSTOM_INTERVAL = "InvalidCustomInterval"
    BAD_ARGUMENT = "BadArgument"
    INVALID_GRANULARITY = "InvalidGranularity"
    INVALID_PERIOD = "InvalidPeriod"
    INVALID_MODEL_ARGUMENT = "InvalidModelArgument"
    INVALID_SERIES = "InvalidSeries"
    INVALID_JSON_FORMAT = "InvalidJsonFormat"
    REQUIRED_GRANULARITY = "RequiredGranularity"
    REQUIRED_SERIES = "RequiredSeries"
    INVALID_IMPUTE_MODE = "InvalidImputeMode"
    INVALID_IMPUTE_FIXED_VALUE = "InvalidImputeFixedValue"

class DetectionStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Status of detection results. One of CREATED, RUNNING, READY, and FAILED.
    """

    CREATED = "CREATED"
    RUNNING = "RUNNING"
    READY = "READY"
    FAILED = "FAILED"

class FillNAMethod(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """An optional field, indicating how missing values will be filled. One of Previous, Subsequent,
    Linear, Zero, Fixed, and NotFill. Cannot be set to NotFill, when the alignMode is Outer.
    """

    PREVIOUS = "Previous"
    SUBSEQUENT = "Subsequent"
    LINEAR = "Linear"
    ZERO = "Zero"
    FIXED = "Fixed"
    NOT_FILL = "NotFill"

class ImputeMode(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Define the impute method, can be one of auto, previous, linear, fixed, zero, notFill.
    """

    AUTO = "auto"
    PREVIOUS = "previous"
    LINEAR = "linear"
    FIXED = "fixed"
    ZERO = "zero"
    NOT_FILL = "notFill"

class ModelStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Model training status.
    """

    CREATED = "CREATED"
    RUNNING = "RUNNING"
    READY = "READY"
    FAILED = "FAILED"

class TimeGranularity(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Optional argument, can be one of yearly, monthly, weekly, daily, hourly, minutely, secondly,
    microsecond or none. If granularity is not present, it will be none by default. If granularity
    is none, the timestamp property in time series point can be absent.
    """

    YEARLY = "yearly"
    MONTHLY = "monthly"
    WEEKLY = "weekly"
    DAILY = "daily"
    HOURLY = "hourly"
    PER_MINUTE = "minutely"
    PER_SECOND = "secondly"
    MICROSECOND = "microsecond"
    NONE = "none"
