# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ModelTrainingDetails(Model):
    """Model Training Details.

    :param status_id: The train request status ID.
    :type status_id: int
    :param status: Possible values include: 'Queued', 'InProgress',
     'UpToDate', 'Fail', 'Success'
    :type status: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    :param example_count: The count of examples used to train the model.
    :type example_count: int
    :param training_date_time: When the model was trained.
    :type training_date_time: datetime
    :param failure_reason: Reason for the training failure.
    :type failure_reason: str
    """

    _attribute_map = {
        'status_id': {'key': 'statusId', 'type': 'int'},
        'status': {'key': 'status', 'type': 'str'},
        'example_count': {'key': 'exampleCount', 'type': 'int'},
        'training_date_time': {'key': 'trainingDateTime', 'type': 'iso-8601'},
        'failure_reason': {'key': 'failureReason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ModelTrainingDetails, self).__init__(**kwargs)
        self.status_id = kwargs.get('status_id', None)
        self.status = kwargs.get('status', None)
        self.example_count = kwargs.get('example_count', None)
        self.training_date_time = kwargs.get('training_date_time', None)
        self.failure_reason = kwargs.get('failure_reason', None)
