


def test(driverFactory):

    from Ft.Rdf import Model
    from Ft.Rdf.Inference import InferenceEngine

    if driverFactory.ExistsDb('kb'):
        driverFactory.DestroyDb('kb')
    db = driverFactory.CreateDb('kb')
 
    m = Model.Model(db)
    infeng = InferenceEngine.InferenceEngine(m,[])

    db.begin()

    exp = """<?xml version = "1.0"?>
<ril:expression xmlns:ril = "http://namespaces.rdfinference.org/ril" xmlns:ft = "http://namespaces.fourthought.com/test">
  <ril:rule>
    <ril:premise>
      <ft:running>
        <ril:variable name='X'/>
      </ft:running>
    </ril:premise>
    <ril:conclusion>
      <ril:assert>
        <ft:sweating>
          <ril:variable name='X'/>
        </ft:sweating>
      </ril:assert>
    </ril:conclusion>
  </ril:rule>
  <ril:rule>
    <ril:premise>
      <ft:sweating>
        <ril:variable name='X'/>
      </ft:sweating>
    </ril:premise>
    <ril:conclusion>
      <ril:assert>
        <ft:wet>
          <ril:variable name='X'/>
        </ft:wet>
      </ril:assert>
    </ril:conclusion>
  </ril:rule>
  <ril:assert>
    <ft:running><ril:string>Mike</ril:string></ft:running>
  </ril:assert>
  <ril:query>
    <ft:wet><ril:variable name='X'/></ft:wet>
  </ril:query>
</ril:expression>"""

    obj = m.compileRil(exp)

    res = obj.execute(infeng)

    m.bind(obj,"TEST")

    db.commit()

    db.begin()

    obj = m.lookup("TEST")
    
    if m.lookup("FOO"):
        raise SystemExit('lookup failed')

    res2 = obj.execute(infeng)

    if res != res2:
        raise SystemExit('execute of bound object failed')

    db.rollback()



if __name__ == '__main__':
    from Ft.Rdf.Drivers import Postgres

    test(Postgres)
    print 'Test OK'
