import sys
try:
    from py2exe import build_exe
except ImportError:
    # Fake it out for non-Windows systems to allow for documenting this file
    import new
    build_exe = new.module('py2exe.build_exe')
    build_exe.py2exe = new.classobj('py2exe', (),
                                    {'__module__' : 'py2exe.build_exe'})

class py2exe(build_exe.py2exe):
    """
    Command class replacement for py2exe's that adds Ft extension module's
    hidden imports.
    """

    def finalize_options(self):
        build_exe.py2exe.finalize_options(self)
        # We automatically add encodings package as 4Suite is pretty useless
        # without it.  Unless, of course, Ft.Lib is the only part that is
        # being used, but that is quite unlikely.
        if 'encodings' not in self.packages:
            self.packages.append('encodings')
        return

    def get_hidden_imports(self):
        hidden_imports = build_exe.py2exe.get_hidden_imports(self)
        hidden_imports.update(_HIDDEN_IMPORTS)
        return hidden_imports

# Replace default py2exe command class module with this one
sys.modules['distutils.command.py2exe'] = sys.modules[__name__]

# This mapping lists a C-extension module's imports.  Any updates to an
# extension module's imports should be reflected in this mapping as well.
# This mapping also is used for pure-Python modules that use __import__
# to dynamically load modules.
_HIDDEN_IMPORTS = {
    'Ft.Ods.Parsers.OqlParserc' : ['re'],
    'Ft.Rdf.Parsers.Versa.VersaParserc' : ['cmd',
                                           'Ft.Rdf.Parsers.Versa.ResourceExpressions',
                                           'Ft.Rdf.Parsers.Versa.BooleanExpressions',
                                           'Ft.Rdf.Parsers.Versa.Traversal',
                                           'Ft.Rdf.Parsers.Versa.Literals',
                                           'Ft.Rdf.Parsers.Versa.DataTypes',
                                           'Ft.Rdf.Parsers.Versa.NamedExpressions',
                                           'Ft.Lib.boolean',
                                           ],
    'Ft.Xml.cDomlettec' : ['cStringIO',
                           'gc',
                           'xml.dom',
                           'Ft.Lib.Uri',
                           'Ft.Xml',
                           'Ft.Xml.cDomlette',
                           'Ft.Xml.XInclude',
                           'Ft.Xml.XPath.Util',
                           ],
    'Ft.Xml.Lib.cStringWriter' : ['cStringIO'],
    'Ft.Xml.XPath.XPathParserc' : ['cmd',
                                   'Ft.Xml.XPath.ParsedAbsoluteLocationPath',
                                   'Ft.Xml.XPath.ParsedRelativeLocationPath',
                                   'Ft.Xml.XPath.ParsedPredicateList',
                                   'Ft.Xml.XPath.ParsedStep',
                                   'Ft.Xml.XPath.ParsedAxisSpecifier',
                                   'Ft.Xml.XPath.ParsedNodeTest',
                                   'Ft.Xml.XPath.ParsedAbbreviatedAbsoluteLocationPath',
                                   'Ft.Xml.XPath.ParsedAbbreviatedRelativeLocationPath',
                                   'Ft.Xml.XPath.ParsedExpr',
                                   ],
    'Ft.Xml.XPath._conversions' : ['Ft.Lib.boolean',
                                   'Ft.Lib.number',
                                   ],
    'Ft.Xml.XPointer.XPointerParserc' : ['cmd',
                                         'Ft.Xml.XPointer.XPointer',
                                         ],
    'Ft.Xml.XPointer.XPtrExprParserc' : ['cmd',
                                         'Ft.Xml.XPath.ParsedAbsoluteLocationPath',
                                         'Ft.Xml.XPath.ParsedRelativeLocationPath',
                                         'Ft.Xml.XPath.ParsedPredicateList',
                                         'Ft.Xml.XPath.ParsedStep',
                                         'Ft.Xml.XPath.ParsedAxisSpecifier',
                                         'Ft.Xml.XPath.ParsedNodeTest',
                                         'Ft.Xml.XPath.ParsedAbbreviatedAbsoluteLocationPath',
                                         'Ft.Xml.XPath.ParsedAbbreviatedRelativeLocationPath',
                                         'Ft.Xml.XPath.ParsedExpr',
                                         ],
    'Ft.Xml.Xslt.AvtParserc' : ['cmd',
                                'Ft.Xml.XPath.ParsedAbsoluteLocationPath',
                                'Ft.Xml.XPath.ParsedRelativeLocationPath',
                                'Ft.Xml.XPath.ParsedPredicateList',
                                'Ft.Xml.XPath.ParsedStep',
                                'Ft.Xml.XPath.ParsedAxisSpecifier',
                                'Ft.Xml.XPath.ParsedNodeTest',
                                'Ft.Xml.XPath.ParsedAbbreviatedAbsoluteLocationPath',
                                'Ft.Xml.XPath.ParsedAbbreviatedRelativeLocationPath',
                                'Ft.Xml.XPath.ParsedExpr',
                                ],
    'Ft.Xml.Xslt.StylesheetHandler' : ['Ft.Xml.Xslt.ApplyTemplatesElement',
                                       'Ft.Xml.Xslt.ApplyImportsElement',
                                       'Ft.Xml.Xslt.AttributeElement',
                                       'Ft.Xml.Xslt.AttributeSetElement',
                                       'Ft.Xml.Xslt.CallTemplateElement',
                                       'Ft.Xml.Xslt.ChooseElement',
                                       'Ft.Xml.Xslt.CopyElement',
                                       'Ft.Xml.Xslt.CopyOfElement',
                                       'Ft.Xml.Xslt.CommentElement',
                                       'Ft.Xml.Xslt.ElementElement',
                                       'Ft.Xml.Xslt.ForEachElement',
                                       'Ft.Xml.Xslt.IfElement',
                                       'Ft.Xml.Xslt.MessageElement',
                                       'Ft.Xml.Xslt.NumberElement',
                                       'Ft.Xml.Xslt.ParamElement',
                                       'Ft.Xml.Xslt.ProcessingInstructionElement',
                                       'Ft.Xml.Xslt.SortElement',
                                       'Ft.Xml.Xslt.Stylesheet',
                                       'Ft.Xml.Xslt.TemplateElement',
                                       'Ft.Xml.Xslt.TextElement',
                                       'Ft.Xml.Xslt.VariableElement',
                                       'Ft.Xml.Xslt.ValueOfElement',
                                       'Ft.Xml.Xslt.WithParamElement',
                                       'Ft.Xml.Xslt.OtherXslElement',
                                       'Ft.Xml.Xslt.WhitespaceElements',
                                       ],
    'Ft.Xml.Xslt.XPatternParserc' : ['cmd',
                                     'Ft.Xml.XPath.ParsedAbsoluteLocationPath',
                                     'Ft.Xml.XPath.ParsedRelativeLocationPath',
                                     'Ft.Xml.XPath.ParsedPredicateList',
                                     'Ft.Xml.XPath.ParsedStep',
                                     'Ft.Xml.XPath.ParsedAxisSpecifier',
                                     'Ft.Xml.XPath.ParsedNodeTest',
                                     'Ft.Xml.XPath.ParsedAbbreviatedAbsoluteLocationPath',
                                     'Ft.Xml.XPath.ParsedAbbreviatedRelativeLocationPath',
                                     'Ft.Xml.XPath.ParsedExpr',
                                     'Ft.Xml.Xslt.XPatterns',
                                     ],
    'Ft.Xml.ThirdParty.Xvif.iframe' : [#'Ft.Xml.ThirdParty.Xvif.iFrameXPath',
                                       #'Ft.Xml.ThirdParty.Xvif.iFrameRegExp',
                                       'Ft.Xml.ThirdParty.Xvif.iFrameRNG',
                                       'Ft.Xml.ThirdParty.Xvif.iFrameXSLT',
                                       'Ft.Xml.ThirdParty.Xvif.iFrameTypes',
                                       'Ft.Xml.ThirdParty.Xvif.iFrameRegFrag',
                                       ],
    'Ft.Xml.ThirdParty.Xvif.rng' : ['Ft.Xml.ThirdParty.Xvif.rngCoreTypeLib',
                                    'Ft.Xml.ThirdParty.Xvif.wxsTypeLib',
                                    ],
    }
