########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Xslt/UriReferenceFile.py,v 1.5 2005/04/06 23:05:46 jkloth Exp $
"""
XSLT extension elements and functions supporting the 4SS UriReferenceFile API

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import cStringIO

from Ft.Xml.XPath import Conversions
from Ft.Xml.Xslt import XsltElement
from Ft.Xml.Xslt import ContentInfo, AttributeInfo
from Ft.Xml.Xslt import OutputParameters

from Ns import SCORE_NS
import FtssXsltBase


def GetReference(context,path=None):
    """
    Get the URI that this resource references
    """
    path = Conversions.StringValue(path)
    return FtssXsltBase.FetchBaseObject(context.processor,path).getReference()


class SetReferenceElement(XsltElement):
    """
    Change what a URI reference references.
    """

    content = ContentInfo.Empty

    legalAttrs = {
        'path' : AttributeInfo.UriReferenceAvt(
            description='The path of the document'),
        'reference' : AttributeInfo.UriReferenceAvt(
            required=1, description='The new URI'),
        }

    def instantiate(self, context, processor):
        context.setProcessState(self)
        path = self._path.evaluate(context)
        ref = self._reference.evaluate(context)
        base = FtssXsltBase.FetchBaseObject(processor, path)
        base.setReference(ref)
        return

ExtFunctions = {
    (SCORE_NS, 'get-reference'): GetReference,
}

ExtElements = {
    (SCORE_NS, 'set-reference'): SetReferenceElement,
}
