########################################################################
#
# File Name: 	        Class.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Class.py.html
#
"""
Implements the Class meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods.MetaData import Interface
from Ft.Ods.MetaData import MetaKind
from Ft.Ods import PersistentObject
td = PersistentObject.TupleDefinitions

from Ft.Ods.StorageManager.Adapters import Constants


class Class(Interface.Interface):
    def __init__(self,db,data):
        Interface.Interface.__init__(self,db,data,MetaKind.mk_class)

    #relationship extender
    def form_extender(self, extender, inverse=1):
        self._4ods_formRelationship('extender',Class,'extensions','add',extender,inverse)

    def drop_extender(self, extender, inverse=1):
        self._4ods_dropRelationship('extender','extensions','remove',extender,inverse)

    #relationship extensions
    def form_extensions(self, extensions, inverse=1):
        self.add_extensions(extensions,inverse)

    def drop_extensions(self, extensions, inverse=1):
        self.remove_extensions(extensions,inverse)

    def add_extensions(self,target,inverse=1):
        self._4ods_addRelationship('extensions',Class,'extender','form',target,inverse)

    def remove_extensions(self,target,inverse=1):
        self._4ods_removeRelationship('extensions','extender','drop',target,inverse)


    def _4ods_getOdl(self,indent):
        extends = ''
        if self.extender:
            extends = 'extends %s' % self.extender.absolute_name()
        extents = ''
        if self.extents.cardinality():
            extents= '(extent ' + self.extents[0] + ')'
        st = indent + 'class %s %s ' % (self.name,extends)
        for i in self.inherits:
            st = st + " : %s," % i.absolute_name()
        st = st[:-1]
        if extents:
            st = st + ' ' + extents
        st = st + " {\n"

        for e in self.defines:
            st = st + "%s;\n" % e._4ods_getOdl(indent + '  ')
        st = st + indent + "}"
        return st


    _tupleNames = (('extents',),('keys',),('extender',),('extensions',))


    _tupleDefinitions = {'extents':{td.TYPE:Constants.Types.LIST_COLLECTION,
                                    td.READONLY:1,
                                    td.COLLECTION_SUBTYPE:Constants.Types.STRING,
                                    },
                         'keys':{td.TYPE:Constants.Types.LIST_COLLECTION,
                                 td.READONLY:1,
                                 td.COLLECTION_SUBTYPE:Constants.Types.STRING,
                                    },
                         'extender':{td.TYPE:Constants.Types.ROBJECT,
                                     td.READONLY:1,
                                     td.RELATIONSHIP:1
                                     },
                         'extensions':{td.TYPE:Constants.Types.SET_COLLECTION,
                                       td.READONLY:1,
                                       td.RELATIONSHIP:1,
                                       td.COLLECTION_SUBTYPE:Constants.Types.ROBJECT,
                                       },
                         }
                         
                                    

    _localExtents = ()
